$('#tutorial').on('click', function () {
    $(document).ready(async function () {
        const driver = new Driver({
            doneBtnText: 'Sair',
            closeBtnText: 'Fechar',
            nextBtnText: 'Próximo',
            prevBtnText: 'Anterior',
            allowClose: false
        });
        driver.defineSteps([

            {
                element: '#btnFiltros',
                popover: {
                    title: 'Botão Filtros',
                    description: 'Clique aqui para filtrar a consulta.',
                    position: 'right'
                }
            },
            {
                element: '#btnAbreProcessar',
                popover: {
                    title: 'Botão Processar',
                    description: 'Clique aqui processar os registros filtrados.',
                    position: 'right'
                }
            },
            {
                element: '#btnReservar',
                popover: {
                    title: 'Botão Reservar',
                    description: 'Clique aqui para reservar os registros processados.',
                    position: 'right'
                }
            },
            {
                element: '#btnExcluir',
                popover: {
                    title: 'Botão Excluir',
                    description: 'Clique aqui para abrir a tela Exclusão de Reserva.',
                    position: 'right'
                }
            },
            {
                element: '#childrenTabelaPedido',
                popover: {
                    title: 'Tabela Pedidos',
                    description: 'Aqui estão os dados de pedidos consultados.',
                    position: 'botton'
                }
            },
            {
                element: '#containerTotalizadores',
                popover: {
                    title: 'Totalizadores',
                    description: 'Aqui estão os totalizadores com dados dos pedidos filtrados.',
                    position: 'top'
                }
            },
            {
                element: '#childrenTabelaItensPedido',
                popover: {
                    title: 'Tabela Itens',
                    description: 'Aqui estão os itens do pedido selecionado.',
                    position: 'top'
                }
            },
        ]);
        driver.start();
    });
});
$(document).ready(async function () {
    let listaDeItens = []
    let tbReserva = []
    let consultando = true
    await criaPesquisaFiltros()

    let colunas = JSON.parse(localStorage.getItem('colunasInvisiveisRelatorios'))

    if (colunas == null || colunas.sugestaoFaturamento == undefined) {
        localStorage.setItem('colunasInvisiveisRelatorios', JSON.stringify({ ...colunas, sugestaoFaturamento: ["DT_LIBERAFIN", "PGTO", "CODTRANSP", "NOMETRANSP", "NOMCEP", "ESTCEP", "TIPO_PED", "OBS", "SITUACAO", "DESC_SITUACAO", "OBS2", "OBS_CLIENTE", "ANTECIPADO", "RIS", "SUFRAMA", "GRUPO", "DESC_GRUPO", "ATRASO", "UF_REDESP", "DT_ORIG_ENTREGA"] }))
        colunas = JSON.parse(localStorage.getItem('colunasInvisiveisRelatorios'))
    }

    if (colunas == null || colunas.sugestaoFaturamentoItens == undefined) {
        localStorage.setItem('colunasInvisiveisRelatorios', JSON.stringify({ ...colunas, sugestaoFaturamentoItens: ["ORDEM_DIG", "ORDEM_KIT", "LOTE", "QTDE_KIT", "KITS_DISP", "QTDE_ATEND2", "LINHA", "GRAMATURA", "END_LOCAL", "LOCAL_PROD", "OBSERVACAO", "ID_ITEM_PED", "CATEGORIA", "DESC_CATEGORIA", "TOTAL_FAMILIA"] }))
        colunas = JSON.parse(localStorage.getItem('colunasInvisiveisRelatorios'))
    }

    $('#btnConfirmarColunas').on('click', async function () {
        try {
            $.LoadingOverlay('show');

            const novasColunas = retornaNovasColunasInvisiveis();

            if (localStorage.getItem('tabelaitens') == 'true') {
                localStorage.setItem('colunasInvisiveisRelatorios', JSON.stringify({ ...colunas, sugestaoFaturamentoItens: novasColunas }))
                $('#tabelaItensPedido').DataTable().columns().visible(true);
                $('#tabelaItensPedido').DataTable().columns().every(
                    function () {
                        if ((novasColunas).indexOf(this.dataSrc()) != -1) {
                            this.visible(false);
                        }
                    })
            } else {
                localStorage.setItem('colunasInvisiveisRelatorios', JSON.stringify({ ...colunas, sugestaoFaturamento: novasColunas }))
                $('#tabelaPedidos').DataTable().columns().visible(true);
                $('#tabelaPedidos').DataTable().columns().every(
                    function () {
                        if ((novasColunas).indexOf(this.dataSrc()) != -1) {
                            this.visible(false);
                        }
                    })
            }

            $('#modal-ColunasVisiveis').modal('hide');
        } catch (error) {
            console.error(error)
            msgAlerta(error.message)
        } finally {
            $.LoadingOverlay('hide');
        }
    })


    $('#btnFiltros').on('click', function () {
        $('#modal-filtros').modal('show');
    });

    async function preencheEmpresas() {
        if ($('#txtEmpresaPed').find('option').length <= 0) {
            const empresas = await buscaEmpresas()
            for (let i = 0; i < empresas.length; i++) {
                let newOption
                if (i == 0) {
                    newOption = $('<option></option>')
                        .attr('value', 'Todas')
                        .text('Todas')
                        .prop('selected', true)

                    $('#txtEmpresaPed').append(newOption)
                }

                newOption = $('<option></option>')
                    .attr('value', empresas[i].EMPRESA)
                    .text(`${empresas[i].EMPRESA} - ${empresas[i].EMP_NOME}`)

                $('#txtEmpresaPed').append(newOption)
            }
        }
    }

    $('#modal-filtros').on('show.bs.modal', async function () {
        $.LoadingOverlay('show')
        try {
            await preencheEmpresas()
        } catch (error) {
            console.error(error)
            msgAlerta(error.message)
        } finally {
            $.LoadingOverlay('hide')
        }
    })

    $('#btnConsultar').on('click', async () => {
        $.LoadingOverlay('show')
        try {
            await buscaDados()
            $('#modal-filtros').modal('hide')
            $('#checkSelecionarTodos').prop('checked', false)
        } catch (error) {
            console.error(error)
            msgAlerta(error.message)
        } finally {
            $.LoadingOverlay('hide')
        }
    });

    $('#btnLimparFiltros').on('click', function () {
        $('#txtCliente').empty().trigger('change')
        $('#txtTabf').empty().trigger('change')
        $('#txtTabPreco').empty().trigger('change')
        $('#txtGrupoCli').empty().trigger('change')
        $('#txtGrupoPA').empty().trigger('change')
        $('#txtRepresentante').empty().trigger('change')
        $('#txtStatusPed').empty().trigger('change')
        $('#txtColecao').empty().trigger('change')
        $('#txtDeposito').empty().trigger('change')
        $('#txtTipoPedido').empty().trigger('change')
        $('#txtPedido').empty().trigger('change')
        $('#txtProduto').empty().trigger('change')

        $('#cbConsideraCliente').prop('checked', true)
        $('#cbConsideraPedido').prop('checked', true)
        $('#cbConsideraProduto').prop('checked', true)
        $('#cbConsideraColecao').prop('checked', true)
        $('#cbConsideraTabuf').prop('checked', true)

        $('#rgFinLiberado').prop('checked', true)
        $('#rgComLiberado').prop('checked', true)
        $('#rgTipoPedTodos').prop('checked', true)
        $('#rgPedidoPai').prop('checked', true)
        $('#rgResPendente').prop('checked', true)

        $('#txtDtEmissaoDe').val('1200-01-01')
        $('#txtDtEntregaDe').val('1200-01-01')
        $('#txtDtSaidaDe').val('1200-01-01')
        $('#txtDtFaturaDe').val('1200-01-01')

        $('#txtDtEmissaoAte').val('2500-12-31')
        $('#txtDtEntregaAte').val('2500-12-31')
        $('#txtDtSaidaAte').val('2500-12-31')
        $('#txtDtFaturaAte').val('2500-12-31')
    })

    async function retornaFiltros() {
        const financeiro = $('#rgFinTodos').is(':checked') ? 0 : $('#rgFinLiberado').is(':checked') ? 1 : 2;
        const comercial = $('#rgComTodos').is(':checked') ? 0 : $('#rgComLiberado').is(':checked') ? 1 : 2;
        const tipoPedido = $('#rgTipoPedTodos').is(':checked') ? 0 : $('#rgTipoPedPendente').is(':checked') ? 1 : 2;
        const pedido = $('#rgPedidoTodos').is(':checked') ? 0 : $('#rgPedidoPai').is(':checked') ? 1 : 2;
        const reservados = $('#rgResTodos').is(':checked') ? 0 : $('#rgResReservado').is(':checked') ? 1 : 2;
        const considerarCliente = $('#cbConsideraCliente').is(':checked') ? 'S' : 'N'
        const considerarPedido = $('#cbConsideraPedido').is(':checked') ? 'S' : 'N'
        const considerarProduto = $('#cbConsideraProduto').is(':checked') ? 'S' : 'N'
        const considerarColecao = $('#cbConsideraColecao').is(':checked') ? 'S' : 'N'
        const considerarTabuf = $('#cbConsideraTabuf').is(':checked') ? 'S' : 'N'
        const filtros =
            `EMISSAODE=${formataDataBonita($('#txtDtEmissaoDe').val())}` +
            `&EMISSAOATE=${formataDataBonita($('#txtDtEmissaoAte').val())}` +
            `&ENTREGADE=${formataDataBonita($('#txtDtEntregaDe').val())}` +
            `&ENTREGAATE=${formataDataBonita($('#txtDtEntregaAte').val())}` +
            `&SAIDADE=${formataDataBonita($('#txtDtSaidaDe').val())}` +
            `&SAIDAATE=${formataDataBonita($('#txtDtSaidaAte').val())}` +
            `&FATURADE=${formataDataBonita($('#txtDtFaturaDe').val())}` +
            `&FATURAATE=${formataDataBonita($('#txtDtFaturaAte').val())}` +
            `&CLIENTE=${await formataListas($('#txtCliente').val().toString())}` +
            `&PEDIDOS=${await formataListas($('#txtPedido').val().toString())}` +
            `&ITENSPED=${await formataListas($('#txtProduto').val().toString())}` +
            `&GRUPOCLI=${await formataListas($('#txtGrupoCli').val().toString())}` +
            `&REPRESENTANTE=${await formataListas($('#txtRepresentante').val().toString())}` +
            `&STATUSPEDIDO=${await formataListas($('#txtStatusPed').val().toString())}` +
            `&COLECAOPEDIDO=${await formataListas($('#txtColecao').val().toString())}` +
            `&DEPOSITO=${await formataListas($('#txtDeposito').val().toString())}` +
            `&TIPOPEDIDO=${await formataListas($('#txtTipoPedido').val().toString())}` +
            `&GRUPOPA=${await formataListas($('#txtGrupoPA').val().toString())}` +
            `&ESTADO=${await formataListas($('#txtTabuf').val().toString())}` +
            `&TABELAPRECO=${await formataListas($('#txtTabPreco').val().toString())}` +
            `&CONSIDERARCLIENTE=${considerarCliente}` +
            `&CONSIDERARPEDIDO=${considerarPedido}` +
            `&CONSIDERARPRODUTO=${considerarProduto}` +
            `&CONSIDERARCOLECAO=${considerarColecao}` +
            `&CONSIDERARTABUF=${considerarTabuf}` +
            `&RGFINANCEIRO=${financeiro}` +
            `&RGCOMERCIAL=${comercial}` +
            `&RGTIPOPEDIDO=${tipoPedido}` +
            `&RGPEDIDO=${pedido}` +
            `&RGRESERVADOS=${reservados}` +
            `&EMPRESAPEDIDO=${$('#txtEmpresaPed').val()}` +
            `&CLASSIFICACAOCLI=${$('#txtClassificacaoCli').val()}`;
        return filtros;
    }
    async function buscaDados() {
        consultando = true
        if ($.fn.DataTable.isDataTable('#tabelaPedidos')) {
            $("#tabelaPedidos").DataTable().destroy();
            $("#tabelaPedidos").empty();
        };
        if ($.fn.DataTable.isDataTable('#tabelaItensPedido')) {
            $("#tabelaItensPedido").DataTable().destroy();
            $("#tabelaItensPedido").empty();
        };
        $.LoadingOverlay('show')
        try {
            $('#childrenInfoDataTablePed').addClass('d-none')
            $('#containerTotalizadores').addClass('d-none')
            $('#childrenInfoDataTableItensPed').addClass('d-none')
            $('#btnAbreProcessar').prop('disabled', true)
            $('#btnReservar').prop('disabled', true)
            $('.campoCheck').prop('disabled', false)
            $('#checkSelecionarTodos').prop('disabled', false)
            listaDeItens = []
            tbReserva = []
            const url = "/sisplan/sugestaofaturamento/v1/buscapedidos?";
            const filtros = await retornaFiltros()
            const response = await requisicao("GET", url, `${filtros}`, "", 360000);

            if (!response) {
                return;
            }

            const jsonStr = await response.json()
            if (response.status != 200) {
                throw new Error(jsonStr['RESULT'][0].mensagem);
            }

            if (jsonStr.length <= 0) {
                throw new Error('Nenhum registro encontrado!')
            }

            await montaDataTablePedidos(jsonStr)
            consultando = false
        } catch (error) {
            console.error(error)
            msgAlerta(error.message)
        } finally {
            $.LoadingOverlay('hide')
        }
    }

    async function montaDataTablePedidos(jsonStr) {
        let ordemColunasRelatorio = localStorage.getItem('ordemColunasDataTable')
        ordemColunasRelatorio = JSON.parse(ordemColunasRelatorio)

        const dataSetCols = [];
        let keys
        if (ordemColunasRelatorio != null && ordemColunasRelatorio.sugestaoFaturamentoPedido != undefined) {
            const ordenacao = 'GERAL'
            const colunas = ordemColunasRelatorio.sugestaoFaturamentoPedido.filter(f => f.ordenacao == ordenacao)
            keys = colunas.length > 0 ? colunas[0].colunas : Object.keys(jsonStr[0]);
        } else {
            keys = Object.keys(jsonStr[0]);
        }

        const colunasOriginais = Object.keys(jsonStr[0])

        keys.forEach((k) => {
            dataSetCols.push({
                title: k,
                data: k,
            });
        });

        dataSetCols[0].render = function (data, type, row, meta) {
            return '<div class="form-check pl-0">' +
                '<div class="icheck-primary">' +
                `<input style="height:20px" type="checkbox" id="check_col_${meta.col}_row_${meta.row}" class="align-self-center campoCheck"><label for="check_col_${meta.col}_row_${meta.row}"></label>` +
                '</div>' +
                '</div>';
        }

        $('#tabelaPedidos').DataTable({
            bPaginate: false,
            search: false,
            destroy: true,
            colReorder: true,
            order: [],
            info: false,
            language: {
                sEmptyTable: "Nenhum registro encontrado na tabela de pedidos",
                sInfo: "_TOTAL_ registros",
                sInfoEmpty: " 0 registros",
                sInfoFiltered: "(Filtrados de _MAX_ registros)",
                sInfoPostFix: "",
                sInfoThousands: ".",
                sLengthMenu: "_MENU_ resultados",
                sLoadingRecords: "Carregando...",
                sProcessing: "Processando...",
                sZeroRecords: "Nenhum registro encontrado na tabela de pedidos",
                sSearch: "Pesquisar",
                oPaginate: {
                    sNext: "Próximo",
                    sPrevious: "Anterior",
                    sFirst: "Primeiro",
                    sLast: "Último",
                },
                oAria: {
                    sSortAscending: ": Ordenar colunas de forma ascendente",
                    sSortDescending: ": Ordenar colunas de forma descendente",
                },
            },
            autoWidth: true,
            columns: dataSetCols,
            data: jsonStr,
            columnDefs: [
                {
                    render: function (data) {
                        if (data) {
                            return parseFloat(data).toLocaleString("pt-br", {
                                maximumFractionDigits: 2,
                                minimumFractionDigits: 2,
                            });
                        } else {
                            return ''
                        }
                    },
                    targets: [keys.indexOf(colunasOriginais[24]), keys.indexOf(colunasOriginais[45]), keys.indexOf(colunasOriginais[49]), keys.indexOf(colunasOriginais[50]), keys.indexOf(colunasOriginais[51]), keys.indexOf(colunasOriginais[24])],
                },
                {
                    type: "date-br",
                    render(data) {
                        if (data) {
                            return new Intl.DateTimeFormat("pt-BR").format(
                                new Date(`${data.split(" ")[0]} 23:59:59`)
                            );
                        } else {
                            return ''
                        }
                    },
                    targets: [keys.indexOf(colunasOriginais[3]), keys.indexOf(colunasOriginais[6]), keys.indexOf(colunasOriginais[15]), keys.indexOf(colunasOriginais[16]), keys.indexOf(colunasOriginais[44]), keys.indexOf(colunasOriginais[47]), keys.indexOf(colunasOriginais[62]), keys.indexOf(colunasOriginais[63])],
                },
            ],
        });
        $('#childrenInfoDataTablePed').removeClass('d-none')

        $('#tabelaPedidos').on('click', '.campoCheck', function () {
            const row = parseInt(this.id.split('row_')[1].split('_col')[0])
            if (this.checked) {
                $('#tabelaPedidos').DataTable().row(row).data().SEL = 'S'
            } else {
                $('#tabelaPedidos').DataTable().row(row).data().SEL = 'N'
            }
        });

        const colunasInvisiveis = JSON.parse(localStorage.getItem('colunasInvisiveisRelatorios'));

        $('#buttonColVis').on('click', async function () {
            $.LoadingOverlay('show')
            try {
                $('#modal-ColunasVisiveis').modal('show');
            } finally {
                $.LoadingOverlay('hide')
            }
        });

        $('#tabelaPedidos').DataTable().columns().every(
            function () {
                if ((colunasInvisiveis.sugestaoFaturamento).indexOf(this.dataSrc()) != -1) {
                    this.visible(false);
                }
            })

        await calculaTotais()

        const listaNumeros = []

        for (let i = 0; i < $('#tabelaPedidos').DataTable().data().length; i++) {
            const item = $('#tabelaPedidos').DataTable().row(i).data()
            listaNumeros.push(item.NUMERO)
        }

        if (listaNumeros.length > 0) {
            await divideEEnvia(listaNumeros)
        }

        $('#tabelaPedidos tbody tr:eq(0)').trigger('click')

        $('.campoCheck').on('change', async function () {
            if ($('#tabelaPedidos').DataTable().data().toArray().filter(f => { return f.SEL == 'S' }).length) {
                $('#btnAbreProcessar').prop('disabled', false)
            } else {
                $('#btnAbreProcessar').prop('disabled', true)
            }
        })

        $('#tabelaPedidos').on('column-reorder.dt', function (e, settings, details) {
            if (consultando) {
                return
            }
            const newColumnOrder = []

            for (let i = 0; i < settings.aoColumns.length; i++) {
                const column = settings.aoColumns[i].mData

                newColumnOrder.push(column)
            }

            let ordemColunas = localStorage.getItem('ordemColunasDataTable')
            ordemColunas = JSON.parse(ordemColunas)
            const ordenacao = 'GERAL'

            if (ordemColunas == null || ordemColunas.sugestaoFaturamentoPedido == undefined) {
                localStorage.setItem('ordemColunasDataTable', JSON.stringify({ ...ordemColunas, sugestaoFaturamentoPedido: [{ ordenacao: ordenacao, colunas: newColumnOrder }] }));

            } else if (!ordemColunas.sugestaoFaturamentoPedido.some(s => s.ordenacao == ordenacao)) {

                const ordensSalvas = JSON.parse(localStorage.getItem('ordemColunasDataTable'));
                const newObj = { ordenacao: ordenacao, colunas: newColumnOrder }
                ordensSalvas.sugestaoFaturamentoPedido.push(newObj)
                localStorage.setItem('ordemColunasDataTable', JSON.stringify(ordensSalvas));

            } else if (ordemColunas.sugestaoFaturamentoPedido.some(s => s.ordenacao == ordenacao)) {

                const ordensSalvas = JSON.parse(localStorage.getItem('ordemColunasDataTable'));
                ordensSalvas.sugestaoFaturamentoPedido.filter(f => f.ordenacao == ordenacao)[0].colunas = newColumnOrder
                localStorage.setItem('ordemColunasDataTable', JSON.stringify(ordensSalvas));
            }
        });
    }

    $('#checkSelecionarTodos').on('change', async function () {
        $.LoadingOverlay('show')
        try {
            for (let i = 0; i < $('#tabelaPedidos').DataTable().data().length; i++) {
                if ($('#checkSelecionarTodos').is(':checked')) {
                    if (!$(`#check_col_0_row_${i}`).is(':checked')) {
                        $(`#check_col_0_row_${i}`).trigger('click')
                    }
                } else {
                    if ($(`#check_col_0_row_${i}`).is(':checked')) {
                        $(`#check_col_0_row_${i}`).trigger('click')
                    }
                }
            }
        } finally {
            $.LoadingOverlay('hide')
        }
    });

    $('#tabelaPedidos').on('click', 'tr', async function () {
        $.LoadingOverlay('show')
        try {
            let numero = 0;
            let numeroItens = 0;

            if ($(this).hasClass('selected')) {
                $(this).removeClass('selected');
            } else {
                $('#tabelaPedidos').DataTable().$('tr.selected').removeClass('selected');
                $(this).addClass('selected');
                numero = $('#tabelaPedidos').DataTable().row($(this)).data().NUMERO
            }

            if (numero > 0) {
                await insereItensPedido(listaDeItens.filter(f => { return f.NUMERO == numero }))
            } else {
                $('#tabelaItensPedido tbody tr').hide();
            }
        } finally {
            $.LoadingOverlay('hide')
        }
    })

    $('#modal-ColunasVisiveis').on('show.bs.modal', function () {
        const cols = [];
        let colunasInvisiveis = JSON.parse(localStorage.getItem('colunasInvisiveisRelatorios'))

        if (localStorage.getItem('tabelaitens') == 'true') {
            $('#tabelaItensPedido').DataTable().columns().every(function () {
                cols.push({
                    'title': $(this.header()).text(),
                    'data': this.dataSrc()
                })
            });
            adicionaColunas(cols, colunasInvisiveis.sugestaoFaturamentoItens ?? [])
        } else {
            $('#tabelaPedidos').DataTable().columns().every(function () {
                cols.push({
                    'title': $(this.header()).text(),
                    'data': this.dataSrc()
                })
            });
            adicionaColunas(cols, colunasInvisiveis.sugestaoFaturamento ?? [], ['SEL'])
        }
    })

    $('#modal-ColunasVisiveis').on('hide.bs.modal', function () {
        localStorage.removeItem('tabelaitens')
    })

    $('#buttonExcel').on('click', async function () {
        const url = "/sisplan/sugestaofaturamento/v1/buscapedidos?";
        const filtros = await retornaFiltros()
        await exportaCSV(url, filtros, false, null, 'Relatório de Sugestão de Faturamento', '#tabelaPedidos');
    })

    async function calculaTotais() {
        $('#containerTotalizadores').removeClass('d-none')
        $('#txtTotPedidos').val(0)
        $('#txtTotClientes').val(0)
        $('#txtTotPendente').val(0)
        $('#txtTotFaturado').val(0)
        $('#txtTotReservado').val(0)
        $('#txtTotExpedido').val(0)
        $('#txtTotAtendido').val(0)
        $('#txtTotSaldo').val(0)
        $('#txtValorTotPendente').val(0)
        $('#txtValorTotFaturado').val(0)
        $('#txtValorTotAtendido').val(0)
        $('#txtValorTotReservado').val(0)
        $('#txtValorTotExpedido').val(0)
        $('#txtValorTotSaldo').val(0)

        const listaClientes = []
        const listaPedidos = []
        let qtdeTot = 0;
        let qtdeTotF = 0;
        let qtdeTotR = 0;
        let qtdeTotE = 0;
        let valorTot = 0;
        let valorTotF = 0;
        let valorTotAtend = 0;
        let valorTotR = 0;
        let valorTotE = 0;

        $('#tabelaPedidos').DataTable().rows().every(function () {
            const item = this.data();

            if (!listaClientes.includes(item.CODCLI)) {
                listaClientes.push(item.CODCLI)
            }

            if (!listaPedidos.includes(item.NUMERO)) {
                listaPedidos.push(item.NUMERO)
            }

            qtdeTot += !isNaN(parseInt(item.QTDE)) ? parseInt(item.QTDE) : parseInt(0)
            qtdeTotF += !isNaN(parseInt(item.QTDE_F)) ? parseInt(item.QTDE_F) : parseInt(0)
            qtdeTotR += !isNaN(parseInt(item.QTDE_R)) ? parseInt(item.QTDE_R) : parseInt(0)
            qtdeTotE += !isNaN(parseInt(item.QTDE_EXP)) ? parseInt(item.QTDE_EXP) : parseInt(0)

            valorTot += !isNaN(parseFloat(item.VALOR)) ? parseFloat(item.VALOR) : parseFloat(0)
            valorTotF += !isNaN(parseFloat(item.VALOR_FAT)) ? parseFloat(item.VALOR_FAT) : parseFloat(0)
            valorTotAtend += !isNaN(parseFloat(item.VALORATENDIDO)) ? parseFloat(item.VALORATENDIDO) : parseFloat(0)
            valorTotR += !isNaN(parseFloat(item.VAL_R)) ? parseFloat(item.VAL_R) : parseFloat(0)
            valorTotE += !isNaN(parseFloat(item.VAL_EXP)) ? parseFloat(item.VAL_EXP) : parseFloat(0)
        });

        $('#txtTotPedidos').val(parseInt(listaPedidos.length))
        $('#txtTotClientes').val(parseInt(listaClientes.length))

        $('#txtTotPendente').val(parseInt(qtdeTot))
        $('#txtTotFaturado').val(parseInt(qtdeTotF))
        $('#txtTotReservado').val(parseInt(qtdeTotR))
        $('#txtTotExpedido').val(parseInt(qtdeTotE))
        $('#txtTotSaldo').val(parseInt(qtdeTot) - (parseInt(qtdeTotR) + parseInt(qtdeTotE)))

        $('#txtValorTotPendente').val(formataValor(valorTot))
        $('#txtValorTotFaturado').val(formataValor(valorTotF))
        $('#txtValorTotAtendido').val(formataValor(valorTotAtend))
        $('#txtValorTotReservado').val(formataValor(valorTotR))
        $('#txtValorTotExpedido').val(formataValor(valorTotE))
        $('#txtValorTotSaldo').val(formataValor((parseFloat(valorTot) - (parseFloat(valorTotR) + parseFloat(valorTotE))) - parseFloat(valorTotAtend)))
    }

    function formataValor(numero) {
        return numero.toFixed(2).replace('.', ',').replace(/\d(?=(\d{3})+,)/g, '$&.');
    }

    async function divideEEnvia(numeros) {
        if ($.fn.DataTable.isDataTable('#tabelaItensPedido')) {
            $("#tabelaItensPedido").DataTable().destroy();
            $("#tabelaItensPedido").empty();
        }
        const tamanhoMaximo = 500;
        const partes = [];
        for (let i = 0; i < numeros.length; i += tamanhoMaximo) {
            partes.push(numeros.slice(i, i + tamanhoMaximo));
        }

        const resultados = [];
        for (const parte of partes) {
            try {
                const resultadoParte = await buscaItens(parte);
                resultados.push(resultadoParte);
            } catch (error) {
                console.error(error);
            }
        }

        const jsonStr = [].concat.apply([], resultados);
        await montaDataTableItensPedidos(jsonStr);
    }

    async function buscaItens(numeros) {
        $.LoadingOverlay('show');
        try {
            $('#childrenInfoDataTableItensPed').addClass('d-none');
            const url = "/sisplan/sugestaofaturamento/v1/buscaitens?";
            const filtros = await retornaFiltros();
            const response = await requisicao("POST", url, `${filtros}`, `${encodeURIComponent(JSON.stringify(await formataListas(numeros.toString())))}`, 360000);

            if (!response) {
                return [];
            }

            const jsonStr = await response.json();
            if (response.status != 200) {
                throw new Error(jsonStr['RESULT'][0].mensagem);
            }

            if (jsonStr.length <= 0) {
                throw new Error('Nenhum registro encontrado!');
            }

            return jsonStr;
        } catch (error) {
            console.error(error);
            msgAlerta(error.message);
            return [];
        } finally {
            $.LoadingOverlay('hide');
        }
    }

    async function montaDataTableItensPedidos(jsonStr) {
        let ordemColunasRelatorio = localStorage.getItem('ordemColunasDataTable')
        ordemColunasRelatorio = JSON.parse(ordemColunasRelatorio)

        const dataSetCols = [];
        let keys
        if (ordemColunasRelatorio != null && ordemColunasRelatorio.sugestaoFaturamentoItensPedido != undefined) {
            const ordenacao = 'GERAL'
            const colunas = ordemColunasRelatorio.sugestaoFaturamentoItensPedido.filter(f => f.ordenacao == ordenacao)
            keys = colunas.length > 0 ? colunas[0].colunas : Object.keys(jsonStr[0]);
        } else {
            keys = Object.keys(jsonStr[0]);
        }

        const colunasOriginais = Object.keys(jsonStr[0])

        keys.forEach((k) => {
            dataSetCols.push({
                title: k,
                data: k,
            });
        });

        $('#tabelaItensPedido').DataTable({
            bPaginate: false,
            search: false,
            destroy: true,
            colReorder: true,
            order: [],
            info: false,
            language: {
                sEmptyTable: "Nenhum registro encontrado na tabela de pedidos",
                sInfo: "_TOTAL_ registros",
                sInfoEmpty: " 0 registros",
                sInfoFiltered: "(Filtrados de _MAX_ registros)",
                sInfoPostFix: "",
                sInfoThousands: ".",
                sLengthMenu: "_MENU_ resultados",
                sLoadingRecords: "Carregando...",
                sProcessing: "Processando...",
                sZeroRecords: "Nenhum registro encontrado na tabela de pedidos",
                sSearch: "Pesquisar",
                oPaginate: {
                    sNext: "Próximo",
                    sPrevious: "Anterior",
                    sFirst: "Primeiro",
                    sLast: "Último",
                },
                oAria: {
                    sSortAscending: ": Ordenar colunas de forma ascendente",
                    sSortDescending: ": Ordenar colunas de forma descendente",
                },
            },
            autoWidth: true,
            columns: dataSetCols,
            columnDefs: [
                {
                    render: function (data) {
                        if (data) {
                            return parseFloat(data).toLocaleString("pt-br", {
                                maximumFractionDigits: 2,
                                minimumFractionDigits: 2,
                            });
                        } else {
                            return ''
                        }
                    },
                    targets: [keys.indexOf(colunasOriginais[20]), keys.indexOf(colunasOriginais[21]), keys.indexOf(colunasOriginais[22])],
                },
            ],
        });

        listaDeItens = jsonStr

        $('#childrenInfoDataTableItensPed').removeClass('d-none')

        const colunasInvisiveis = JSON.parse(localStorage.getItem('colunasInvisiveisRelatorios'));

        $('#buttonColVisItens').on('click', async function () {
            $.LoadingOverlay('show')
            try {
                localStorage.setItem('tabelaitens', 'true')
                $('#modal-ColunasVisiveis').modal('show');
            } finally {
                $.LoadingOverlay('hide')
            }
        });

        $('#tabelaItensPedido').DataTable().columns().every(
            function () {
                if ((colunasInvisiveis.sugestaoFaturamentoItens).indexOf(this.dataSrc()) != -1) {
                    this.visible(false);
                }
            })

        $('#buttonExcelItens').on('click', async function () {
            const url = "/sisplan/sugestaofaturamento/v1/exprtacsvitens?";
            const filtros = await retornaFiltros()
            await exportaCSV(url, `${filtros}&NUMERO=${listaDeItens[0].NUMERO}`, false, null, 'Relatório de Itens Sugestão de Faturamento', '#tabelaPedidos');
        })

        $('#tabelaItensPedido').on('column-reorder.dt', function (e, settings, details) {
            if (consultando) {
                return
            }
            const newColumnOrder = []

            for (let i = 0; i < settings.aoColumns.length; i++) {
                const column = settings.aoColumns[i].mData

                newColumnOrder.push(column)
            }

            let ordemColunas = localStorage.getItem('ordemColunasDataTable')
            ordemColunas = JSON.parse(ordemColunas)
            const ordenacao = 'GERAL'

            if (ordemColunas == null || ordemColunas.sugestaoFaturamentoItensPedido == undefined) {
                localStorage.setItem('ordemColunasDataTable', JSON.stringify({ ...ordemColunas, sugestaoFaturamentoItensPedido: [{ ordenacao: ordenacao, colunas: newColumnOrder }] }));

            } else if (!ordemColunas.sugestaoFaturamentoItensPedido.some(s => s.ordenacao == ordenacao)) {

                const ordensSalvas = JSON.parse(localStorage.getItem('ordemColunasDataTable'));
                const newObj = { ordenacao: ordenacao, colunas: newColumnOrder }
                ordensSalvas.sugestaoFaturamentoItensPedido.push(newObj)
                localStorage.setItem('ordemColunasDataTable', JSON.stringify(ordensSalvas));

            } else if (ordemColunas.sugestaoFaturamentoItensPedido.some(s => s.ordenacao == ordenacao)) {

                const ordensSalvas = JSON.parse(localStorage.getItem('ordemColunasDataTable'));
                ordensSalvas.sugestaoFaturamentoItensPedido.filter(f => f.ordenacao == ordenacao)[0].colunas = newColumnOrder
                localStorage.setItem('ordemColunasDataTable', JSON.stringify(ordensSalvas));
            }
        });
    }

    async function insereItensPedido(jsonStr) {
        $.LoadingOverlay('show');
        try {
            const tabela = $('#tabelaItensPedido').DataTable();
            tabela.clear();

            for (let i = 0; i < jsonStr.length; i++) {
                const rowData = {};
                const item = jsonStr[i];

                rowData.ATENDE = item.ATENDE;
                rowData.NUMERO = item.NUMERO;
                rowData.TIPO = item.TIPO;
                rowData.CODIGO = item.CODIGO;
                rowData.DESCRICAO = item.DESCRICAO;
                rowData.COR = item.COR;
                rowData.DESC_COR = item.DESC_COR;
                rowData.TAM = item.TAM;
                rowData.POSICAO = item.POSICAO;
                rowData.ORDEM = item.ORDEM;
                rowData.ORDEM_DIG = item.ORDEM_DIG;
                rowData.ORDEM_KIT = item.ORDEM_KIT;
                rowData.LOTE = item.LOTE;
                rowData.QTDE_KIT = item.QTDE_KIT;
                rowData.KITS_DISP = item.KITS_DISP;
                rowData.QTDE = item.QTDE;
                rowData.QTDE_PED = item.QTDE_PED;
                rowData.QTDE_EXP = item.QTDE_EXP;
                rowData.QTDE_R = item.QTDE_R;
                rowData.QTDE_EST = item.QTDE_EST;
                rowData.PRECO = item.PRECO;
                rowData.PRECO_LIQ = item.PRECO_LIQ;
                rowData.VALOR = item.VALOR;
                rowData.QTDE_ATEND = item.QTDE_ATEND;
                rowData.QTDE_ATEND2 = item.QTDE_ATEND2;
                rowData.QTDE_ATEND_SIMULA = item.QTDE_ATEND_SIMULA;
                rowData.LINHA = item.LINHA;
                rowData.CODIGO2 = item.CODIGO2;
                rowData.ETIQUETA = item.ETIQUETA;
                rowData.ETQ_PROD = item.ETQ_PROD;
                rowData.DESC_ETQ = item.DESC_ETQ;
                rowData.GRAMATURA = item.GRAMATURA;
                rowData.END_LOCAL = item.END_LOCAL;
                rowData.LOCAL_PROD = item.LOCAL_PROD;
                rowData.QUANTIDADE = item.QUANTIDADE;
                rowData.COMPLEMENTO = item.COMPLEMENTO;
                rowData.OBSERVACAO = item.OBSERVACAO;
                rowData.SORTIDO = item.SORTIDO;
                rowData.MODELO = item.MODELO;
                rowData.ID_ITEM_PED = item.ID_ITEM_PED;
                rowData.CATEGORIA = item.CATEGORIA;
                rowData.DESC_CATEGORIA = item.DESC_CATEGORIA;
                rowData.TOTAL_FAMILIA = item.TOTAL_FAMILIA;
                rowData.COLECAO = item.COLECAO;
                rowData.DESC_COLECAO = item.DESC_COLECAO;
                rowData.STATUS = item.STATUS;
                rowData.DESC_STATUS = item.DESC_STATUS;
                rowData.FAIXA = item.FAIXA;
                rowData.DESCFAIXA = item.DESCFAIXA;
                rowData.DEPOSITO = item.DEPOSITO;

                tabela.row.add(rowData);
            }
            tabela.draw(false);

            if ($('#tabelaItensPedido').DataTable().data().toArray()[0].ATENDE != '') {
                $("#tabelaItensPedido tr:gt(0)").each(function () {
                    let item = $('#tabelaItensPedido').DataTable().row($(this)).data()

                    if ((parseFloat(item.QTDE_ATEND_SIMULA) > 0) && parseFloat(item.QTDE_ATEND) == 0) {
                        $(this).removeClass('linhaVermelha').removeClass('linhaVerde').removeClass('linhaAzul').removeClass('linhaOlive').removeClass('linhaRoxa').addClass('linhaFont')
                    } else if ((parseFloat(item.QTDE_R) > 0) && (parseFloat(item.QTDE_R) == (parseFloat(item.QTDE_R) + parseFloat(item.QTDE_EXP))) || (parseFloat(item.QTDE_PED) == parseFloat(item.QTDE_R))) {
                        $(this).removeClass('linhaVermelha').removeClass('linhaVerde').removeClass('linhaFont').removeClass('linhaOlive').removeClass('linhaRoxa').addClass('linhaAzul')
                    } else if (parseFloat(item.QTDE_PED) == parseFloat(item.QTDE_EXP)) {
                        $(this).removeClass('linhaVermelha').removeClass('linhaVerde').removeClass('linhaFont').removeClass('linhaAzul').removeClass('linhaRoxa').addClass('linhaOlive')
                    } else if (parseFloat(item.QTDE_ATEND) > 0) {
                        $(this).removeClass('linhaVermelha').removeClass('linhaOlive').removeClass('linhaFont').removeClass('linhaAzul').removeClass('linhaRoxa').addClass('linhaVerde')
                    } else {
                        $(this).removeClass('linhaVerde').removeClass('linhaOlive').removeClass('linhaFont').removeClass('linhaAzul').removeClass('linhaRoxa').addClass('linhaVermelha')
                    }

                    if ((parseFloat($('#txtMinAtendValor').val()) + parseFloat($('#txtMinAtendQtde').val()) + parseFloat($('#txtMaxAtendQtde').val()) + parseFloat($('#txtValorMinPed').val()) + parseFloat($('#txtValMinDup').val()) + parseFloat($('#txtMaxAtend').val())) == 0
                        && (parseFloat(item.QTDE_ATEND) > 0) && (parseFloat(item.QTDE_PED) > parseFloat(item.QTDE_ATEND))) {
                        $(this).removeClass('linhaVerde').removeClass('linhaOlive').removeClass('linhaFont').removeClass('linhaAzul').removeClass('linhaVermelha').addClass('linhaRoxa')
                    }


                })
            }
        } catch (error) {
            console.error(error);
            msgAlerta(error.message);
        } finally {
            $.LoadingOverlay('hide');
        }
    }

    function limpaCamposProcessar() {
        $('#txtMinAtendValor').val(100)
        $('#txtMinAtendQtde').val(100)
        $('#txtMaxAtendValor').val(0)
        $('#txtMaxAtendQtde').val(0)
        $('#txtValorMaxPed').val(999999)
        $('#txtValorMinPed').val(0)
        $('#txtValMinDup').val(0)
        $('#txtMaxAtend').val(0)
        $('#rgAtendProduto').prop('checked', true)
    }

    $('#btnAbreProcessar').on('click', async function () {
        $.LoadingOverlay('show')
        try {
            limpaCamposProcessar()
            $('#modal-processar').modal('show')
        } finally {
            $.LoadingOverlay('hide')
        }
    })

    $('#btnFecharProcessar').on('click', async function () {
        $.LoadingOverlay('show')
        try {
            $('#modal-processar').modal('hide')
        } finally {
            $.LoadingOverlay('hide')
        }
    })

    $('#btnProcessar').on('click', async function () {
        $.LoadingOverlay('show')
        try {
            const classeProcessar = await montaClasseProcessar()
            const filtros = await retornaFiltros()
            let response = await requisicao('POST', '/Sisplan/sugestaofaturamento/v1/processar?', `${filtros}`, `${encodeURIComponent(JSON.stringify(classeProcessar))}`);

            if (!response) {
                $.LoadingOverlay("hide");
                return;
            };

            let jsonStr = await response.json();
            tbReserva = jsonStr;

            $($('#tabelaPedidos').DataTable().row(':eq(0)').node()).trigger('click')
            if (response.status != 200) {
                $.LoadingOverlay("hide");
                msgErro(jsonStr.mensagem);
                return;
            }
            $.LoadingOverlay("hide");
            toastr.success(
                `Registros processados com sucesso!`,
                'Confirmação', {
                toastClass: 'alert',
                iconClasses: {
                    error: 'alert-error',
                    info: 'alert-info',
                    success: 'alert-success',
                    warning: 'alert-warning'
                },
                positionClass: "toast-top-center",
                progressBar: true,
                timeOut: 3000,
                fadeOut: 1000,
                async onHidden() {
                    $('#modal-processar').modal('hide')
                    $('.campoCheck').prop('disabled', true)
                    $('#checkSelecionarTodos').prop('disabled', true)
                    $('#btnAbreProcessar').prop('disabled', true)
                    $('#btnReservar').prop('disabled', false)
                    await atualizaPedIten(tbReserva)
                }
            }
            ).css({
                "margin-top": "20%",
                "width": "500px",
                "max-width": "500px"
            });
        } catch (error) {
            console.error(error)
            msgAlerta(error.message)
        } finally {
            $.LoadingOverlay('hide')
        }
    })

    async function montaClasseProcessar() {
        const classeProcessar = {}

        classeProcessar.MINATENDVALOR = $('#txtMinAtendValor').val()
        classeProcessar.MINATENDQTDE = $('#txtMinAtendQtde').val()
        classeProcessar.MAXATENDVALOR = $('#txtMaxAtendValor').val()
        classeProcessar.MAXATENDQTDE = $('#txtMaxAtendQtde').val()
        classeProcessar.VALORMAXPED = $('#txtValorMaxPed').val()
        classeProcessar.VALORMINPED = $('#txtValorMinPed').val()
        classeProcessar.VALORMINDUP = $('#txtValMinDup').val()
        classeProcessar.VALORMAXATEND = $('#txtMaxAtend').val()
        classeProcessar.MINATENDEITENS = $('#txtMinAtendItens').val()
        classeProcessar.LISTAPEDIDOS = montaArrayPedidos()

        return classeProcessar
    }

    function montaArrayPedidos() {
        const arrayPed = []
        const tabela = $('#tabelaPedidos').DataTable().data().toArray()
        for (let i = 0; i < tabela.length; i++) {
            if (tabela[i].SEL == 'S') {
                const novaRow = {}
                novaRow.NUMERO = tabela[i].NUMERO;
                novaRow.CODCLI = tabela[i].CODCLI;
                novaRow.ITENS = montaArrayItens(tabela[i].NUMERO)
                novaRow.QTDE = tabela[i].QTDE
                novaRow.VALOR = tabela[i].VALOR

                arrayPed.push(novaRow)
            }
        }

        return arrayPed
    }

    function montaArrayItens(numero) {
        const arrayItens = []
        const tabela = listaDeItens;
        for (let i = 0; i < tabela.length; i++) {
            if (tabela[i].NUMERO == numero) {
                const novaRow = {}
                novaRow.CODIGO = tabela[i].CODIGO
                novaRow.COR = tabela[i].COR
                novaRow.TAM = tabela[i].TAM
                novaRow.QTDE = tabela[i].QTDE
                novaRow.QTDEPED = tabela[i].QTDE_PED
                novaRow.QTDEEXP = tabela[i].QTDE_EXP
                novaRow.QTDER = tabela[i].QTDE_R
                novaRow.QTDEEST = tabela[i].QTDE_EST
                novaRow.PRECO = tabela[i].PRECO
                novaRow.PRECOLIQ = tabela[i].PRECO_LIQ
                novaRow.NUMERO = numero
                novaRow.ORDEM = tabela[i].ORDEM
                novaRow.TIPO = tabela[i].TIPO
                novaRow.ETIQUETA = tabela[i].ETIQUETA
                novaRow.DEPOSITO = tabela[i].DEPOSITO

                arrayItens.push(novaRow)
            }
        }

        return arrayItens
    }

    async function atualizaPedIten(reservas) {
        $.LoadingOverlay('show')
        try {
            const listaPedidosReserva = []
            for (let j = 0; j < listaDeItens.length; j++) {
                let item = listaDeItens[j];
                item.ATENDE = 'N';

                for (let i = 0; i < reservas.length; i++) {
                    if (reservas[i].PEDIDO == item.NUMERO &&
                        reservas[i].CODIGO == item.CODIGO &&
                        reservas[i].COR == item.COR &&
                        reservas[i].TAM == item.TAM) {
                        item.ATENDE = 'S'
                        item.QTDE_ATEND = reservas[i].QTDE_ATEND
                        item.QTDE_ATEND_SIMULA = reservas[i].QTDE_ATEND_SIMULA
                        break;
                    }
                    if (!listaPedidosReserva.includes(reservas[i].PEDIDO)) {
                        listaPedidosReserva.push(reservas[i].PEDIDO)
                    }
                }
            }

            $("#tabelaPedidos tr:gt(0)").each(function () {
                let item = $('#tabelaPedidos').DataTable().row($(this)).data()

                if (listaPedidosReserva.length <= 0) {
                    $(this).removeClass('linhaVerde').addClass('linhaVermelha')
                } else {
                    for (let i = 0; i < listaPedidosReserva.length; i++) {
                        if (listaPedidosReserva.includes(item.NUMERO)) {
                            $(this).removeClass('linhaVermelha').addClass('linhaVerde')
                        } else {
                            $(this).removeClass('linhaVerde').addClass('linhaVermelha')
                        }
                    }
                }
            })

            if ($($('#tabelaPedidos').DataTable().row(':eq(0)').node()).hasClass('selected')) {
                $($('#tabelaPedidos').DataTable().row(':eq(0)').node()).trigger('click')
                $($('#tabelaPedidos').DataTable().row(':eq(0)').node()).trigger('click')
            } else {
                $($('#tabelaPedidos').DataTable().row(':eq(0)').node()).trigger('click')
            }
        } finally {
            $.LoadingOverlay('hide')
        }
    }

    retornaHintRelatorio('btnImprimir', 'RelSugestaoFaturamento')

    $('#btnImprimir').on('click', async function () {
        try {
            $.LoadingOverlay('show');
            if (listaDeItens.length <= 0 ){
                throw new Error('Nenhum registro para imprmir!');
            }
            const url = `/sisplan/sugestaofaturamento/v1/imprimir?`;
            const filtros = await retornaFiltros();
            const bImprimeAutomatico = await verificaImprimirAutomatico('RelSugestaoFaturamento');
            const arquivo = await GeraRelatorio(`${url}${filtros}&`, 'POST', 100000, false, 'RelSugestaoFaturamento', `${encodeURIComponent(JSON.stringify(listaDeItens))}`);
            if (arquivo != undefined) {
                if (!bImprimeAutomatico) {
                    window.open(`${BASE_URI}/relatorios_api/pdf/${arquivo}`, '_blank');
                }
                await limparRelatorios();
            }

        } catch (error) {
            msgAlerta(error.message)
            console.error(error);
        } finally {
            $.LoadingOverlay('hide');
        }
    });

    $('#btnExcluir').on('click', async function () {
        parent.document.querySelector('#menu_excluireserva .nav-link').click();
    })

    $('#btnReservar').on('click', async function () {
        $.LoadingOverlay('show')
        try {
            $('#modal-reservar').modal('show')

            await setarDataAtual('txtDtBase')
        } catch (error) {
            console.error(error)
            msgAlerta(error.message)
        } finally {
            $.LoadingOverlay('hide')
        }
    })

    $('#btnFecharReserva').on('click', async function () {
        $.LoadingOverlay('show')
        try {
            $('#modal-reservar').modal('hide')
            $('#txtStatus').val('')
            $('#txtObs').val('')
            msgAlerta('Não possui informações da reserva para serem gravadas.')
        } finally {
            $.LoadingOverlay('hide')
        }
    })

    $('#btnConfirmarReserva').on('click', async function () {
        $.LoadingOverlay('show')
        try {
            const reservas = await reservaItens()

            $.LoadingOverlay("hide");
            toastr.success(
                `Reserva gravada com sucesso! ` +
                `\nReserva número: ${reservas[0].RESERVA}`,
                'Confirmação', {
                toastClass: 'alert',
                iconClasses: {
                    error: 'alert-error',
                    info: 'alert-info',
                    success: 'alert-success',
                    warning: 'alert-warning'
                },
                positionClass: "toast-top-center",
                progressBar: true,
                timeOut: 3000,
                fadeOut: 1000,
                async onHidden() {
                    await finalizaReserva(reservas)
                }
            }
            ).css({
                "margin-top": "20%",
                "width": "500px",
                "max-width": "500px"
            });
        } catch (error) {
            console.error(error)
            msgAlerta(error.message)
        } finally {
            $.LoadingOverlay('hide')
        }
    })

    async function reservaItens() {
        tbReserva.forEach(obj => {
            obj.STATUS = pegaChave('#txtStatus')
            obj.DATARES = formataDataBonita($('#txtDtBase').val())
            obj.MENSAGEM = $('#txtObs').val()
        })
        const filtros = retornaFiltros()
        const response = await requisicao('POST', '/Sisplan/sugestaofaturamento/v1/reservar?', `${filtros}`, `${encodeURIComponent(JSON.stringify(tbReserva))}`);

        if (!response) {
            throw new Error('Ocorreu um erro ao reservar!')
        };

        const jsonStr = await response.json();

        if (response.status != 200) {
            finalizaReserva()
            throw new Error(jsonStr.mensagem);
        }

        return jsonStr
    }

    async function finalizaReserva(reservas) {
        $.LoadingOverlay('show')
        try {
            $('#tabelaPedidos').DataTable().rows().every(function () {
                const item = this.data();

                for (let i = 0; i < reservas.length; i++) {
                    if (reservas[i].NUMERO == item.NUMERO) {
                        item.RESERVA = reservas[i].RESERVA
                        item.QTDE_R = reservas[i].QTDE_R
                    }
                }
            })
            $('#tabelaPedidos').DataTable().rows().invalidate().draw('page');
            await calculaTotais()

            $('#modal-reservar').modal('hide')
            $('.campoCheck').prop('disabled', true)
            $('#checkSelecionarTodos').prop('disabled', true)
            $('#btnAbreProcessar').prop('disabled', true)
            $('#btnReservar').prop('disabled', true)
            $('#txtStatus').val('')
            $('#txtObs').val('')
        } finally {
            $.LoadingOverlay('hide')
        }
    }

    async function criaPesquisaFiltros() {
        componenteFiltro('cliente', true)
        componenteFiltro('tabuf', true)
        componenteFiltro('tabPreco', true)
        componenteFiltro('grupoCli', true);
        componenteFiltro('grupoPA', true)
        componenteFiltro('representante', true)
        componenteFiltro('statusPed', true)
        componenteFiltro('colecao', true)
        componenteFiltro('deposito', true)
        componenteFiltro('tipoPedido', true)
        componenteFiltro('pedido', true)
        componenteFiltro('produto', true)
        componenteFiltro('status', false)
    }
});