$('#tutorial').on('click', function () {
    $(document).ready(async function () {
        const driver = new Driver({
            doneBtnText: 'Sair',
            closeBtnText: 'Fechar',
            nextBtnText: 'Próximo',
            prevBtnText: 'Anterior',
            allowClose: false,
            animate: true,
        });

        driver.defineSteps([
            {
                element: '#txtCodigo',
                popover: {
                    title: 'Código',
                    description: "Aqui, adicionamos o codigo do subgrupo de cor.",
                    position: 'top'
                }
            },
            {
                element: '#txtDescricao',
                popover: {
                    title: 'Descrição',
                    description: 'Aqui, adicionamos a descrição do subgrupo de cor.',
                    position: 'top'
                }
            },
            {
                element: "#btnVoltar",
                popover: {
                    title: "Botão Voltar",
                    description:
                        "Ao clicar nesse botão você retorna para a tela de consulta.",
                    position: "left",
                },
            },
            {
                element: '#gravar',
                popover: {
                    title: 'Botão Gravar',
                    description: 'Clique aqui para gravar o subgrupo de cor.',
                    position: 'left'
                }
            }
        ]);
        driver.start();
    });
});

$(document).ready(async function () {
    componenteFiltro('classeCor', false, false)
    let queryString = window.location.href;
    let parametros = queryString.split('/');
    let subgrupocor = parametros[parametros.length - 1];

    $('#btnVoltar').on('click', async function () {
        await deletaRegistro('SUBGRUPOCOR', getCookie('usuario'), subgrupocor);
        window.location.href = `${BASE_URI}/subgrupocor`;
    });

    $('#txtCodigo').on('blur', async function () {
        if ($(this).val() != '') {
            return
        }
        $.LoadingOverlay('show')
        try {
            const newCodigo = await RetornaProximo('CODIGO', 'SUBGRUPO_COR', 'CODIGO', 3)

            $(this).val(newCodigo)
        } catch (error) {
            console.error(error)
            msgAlerta(error.message)
        } finally {
            $.LoadingOverlay('hide')
        }
    })

    async function ajustaOrdem() {
        $.LoadingOverlay('show')
        try {
            const pesquisaMax = {
                tabela: 'SUBGRUPO_COR',
                camposSelect: ['MAX(ORDEM) ORDEM'],
                where: null
            };
            const jsonStrMax = await retornaJsonPesquisaPadrao(JSON.stringify(pesquisaMax));

            $('#txtOrdem').val(parseInt(jsonStrMax[0].ORDEM) + 1)
        } catch (error) {
            console.error(error)
            msgAlerta(error.message)
        } finally {
            $.LoadingOverlay('hide')
        }
    }

    $('#txtOrdem').on('blur', async function () {
        $.LoadingOverlay('show')
        try {
            const ordemOrig = $(this).val()
            if (ordemOrig != '') {
                const pesquisa = {
                    tabela: 'SUBGRUPO_COR',
                    camposSelect: ['ORDEM'],
                    where: [`CODIGO <> '${subgrupocor}' AND ORDEM = '${ordemOrig}'`]
                };
                const jsonStr = await retornaJsonPesquisaPadrao(JSON.stringify(pesquisa));

                if (jsonStr.length > 0) {
                    await ajustaOrdem()
                    throw new Error(`Ordem: ${ordemOrig} já existe, ajustado para a proxima ordem.`)
                }
            } else {
                await ajustaOrdem()
            }
        } catch (error) {
            console.error(error)
            msgAlerta(error.message)
        } finally {
            $.LoadingOverlay('hide')
        }
    })

    $('#txtOrdem').on('input', function (e) {
        let valorAtual = $(this).val();

        let novoValor = valorAtual.replace(/\D/g, '');

        if (novoValor != valorAtual) {
            $(this).val(novoValor);
        }
    });


    $(document).ready(function () {

        $('#msform').validate({
            debug: false,
            ignore: "",
            rules: {
                txtDescricao: {
                    required: true,
                },
            },
            messages: {
                txtDescricao: {
                    required: "Informe uma descrição válida."
                },
            },
            errorElement: 'span',
            errorPlacement(error, element) {
                error.addClass('invalid-feedback');
                element.closest('.form-group').append(error);
            },
            highlight(element) {
                $(element).addClass('is-invalid');
            },
            unhighlight(element) {
                $(element).removeClass('is-invalid');
            }
        });

        $('.radio-group .radio').click(function () {
            $(this).parent().find('.radio').removeClass('selected');
            $(this).addClass('selected');
        });

        $(".submit").click(function () {
            return false;
        });
    });

    $('#tabelaClasse').DataTable({
        destroy: true,
        lengthChange: false,
        serverside: true,
        filter: false,
        "language": {
            "sEmptyTable": "Nenhum registro encontrado",
            "sInfo": "_TOTAL_ registros",
            "sInfoEmpty": " 0 registros",
            "sInfoFiltered": "(Filtrados de _MAX_ registros)",
            "sInfoPostFix": "",
            "sInfoThousands": ".",
            "sLengthMenu": "_MENU_ resultados",
            "sLoadingRecords": "Carregando...",
            "sProcessing": "Processando...",
            "sZeroRecords": "Nenhum registro encontrado",
            "sSearch": "Pesquisar",
            "oPaginate": {
                "sNext": "Próximo",
                "sPrevious": "Anterior",
                "sFirst": "Primeiro",
                "sLast": "Último"
            },
            "oAria": {
                "sSortAscending": ": Ordenar colunas de forma ascendente",
                "sSortDescending": ": Ordenar colunas de forma descendente"
            }
        },
        "autoWidth": true,
        "columns": [{
            "data": "CODIGO"
        },
        {
            "data": "DESCRICAO"
        }
        ],
        "columnDefs": [{
            targets: [0], render: function (data, type, row) {
                return retornaBotaoOpcoes(data);
            }
        }]
    });

    if (subgrupocor != '' && subgrupocor != 'create') {

        if (await liberarRegistro('SUBGRUPOCOR', subgrupocor) == false) {
            window.location.href = '../subgrupocor';
        } else {

            try {
                $.LoadingOverlay("show");
                try {
                    let response = await requisicao('GET', '/Sisplan/Funcoes/v1/pesquisa?',
                        `JSON={ "tabela":"SUBGRUPO_COR", 
                    "camposSelect":["CODIGO", "DESCRICAO", "ORDEM", "FORMA_CODCOR"], 
                    "where": ["CODIGO = '${subgrupocor}'"]}`, null);

                    if (!response) {
                        return;
                    }
                    let jsonStr = await response.json();
                    if (response.status != 200) {
                        msgErro(jsonStr.RESULT[0].mensagem);
                        return;
                    }

                    $('#txtCodigo').val(jsonStr.RESULT[0][0].CODIGO);
                    $('#txtDescricao').val(jsonStr.RESULT[0][0].DESCRICAO);
                    $('#txtOrdem').val(jsonStr.RESULT[0][0].ORDEM);
                    $('#utilizaFormarCodigo').prop('checked', jsonStr.RESULT[0][0].FORMA_CODCOR == 'S');
                    await buscaClasses(subgrupocor)
                } catch (error) {
                    console.error(error);
                    msgErro(`Não foi possível buscar os dados do subgrupo de cor: ${error}`);
                }
            } finally {
                $('#txtCodigo').attr('readonly', true);
                $.LoadingOverlay('hide');
            }
        }
    }

    async function buscaClasses(subgrupo) {
        const pesquisaParam = {
            tabela: 'SUBGRUPOCLASSE',
            leftjoin: [{ tabela: 'CLASSE_COR', condicao: 'CLASSE_COR.CODIGO = SUBGRUPOCLASSE.CLASSE' }],
            camposSelect: ['SUBGRUPOCLASSE.CLASSE', 'CLASSE_COR.DESCRICAO'],
            where: [`SUBGRUPOCLASSE.SUBGRUPO = '${subgrupo}'`]
        }

        const jsonStr = await retornaJsonPesquisaPadrao(JSON.stringify(pesquisaParam));

        jsonStr.map(item => {
            $('#tabelaClasse').DataTable().row.add({ CODIGO: item.CLASSE, DESCRICAO: item.DESCRICAO }).draw(false);
        });
    }

    function retornaBotaoOpcoes(data) {
        var retorno = '<div style="text-align:start;"> ' +
            '    <button class="btn btn-info btn-sm dropdown-toggle btnVerificaOpcoes" type="button" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false"> ' +
            '      ' + data + ' ' +
            '    </button> ' +
            '    <div class="dropdown-menu"> ' +
            '    <button class="dropdown-item" type="button" title="Excluir" id="btn-excluir">Excluir</button>  ' +
            '</div>';
        return retorno;
    };

    $('#btnIncluirClasse').on('click', async function () {
        $.LoadingOverlay('show');
        try {
            const codigo = pegaChave('#txtClasseCor');
            const descricao = pegaDescricao('#txtClasseCor');

            if (codigo == '') {
                throw new Error('Classe não informada para incluir!');
            }

            const table = $('#tabelaClasse').DataTable();
            const data = table.rows().data().toArray();

            const exists = data.some(row => row.CODIGO === codigo);

            if (exists) {
                throw new Error('Classe já existe na tabela!');
            }

            table.row.add({ CODIGO: codigo, DESCRICAO: descricao }).draw(false);

        } catch (error) {
            console.error(error);
            msgAlerta(error.message);
        } finally {
            $.LoadingOverlay('hide');
            $('#txtClasseCor').focus()
            $('#txtClasseCor').val('')
        }
    });

    $('#tabelaClasse').on('click', '#btn-excluir', async function () {
        await msgAguardaConfirmacao('Deseja excluir este registro?', async () => {
            $('#tabelaClasse').DataTable().row($(this).parents('tr')).remove().draw(false);
        })
    })

    $("#gravar").click(

        async function () {
            let validator = $("#msform").validate();
            validator.form();
            let erros = 0;
            erros = validator.numberOfInvalids();

            if (erros == 0) {
                try {
                    $.LoadingOverlay("show");

                    const arrayClasse = []

                    for (let i = 0; i < $('#tabelaClasse').DataTable().data().toArray().length; i++) {
                        const item = $('#tabelaClasse').DataTable().data().toArray()[i]

                        const obj = {
                            CODIGO: item.CODIGO
                        }

                        arrayClasse.push(obj)
                    }

                    let subgrupocorClasse = {};

                    subgrupocorClasse.CODIGO = $('#txtCodigo').val()
                    subgrupocorClasse.DESCRICAO = $('#txtDescricao').val().toUpperCase();
                    subgrupocorClasse.ORDEM = $('#txtOrdem').val();
                    subgrupocorClasse.FORMACODCOR = $('#utilizaFormarCodigo').is(':checked') ? 'S' : 'N';
                    subgrupocorClasse.CLASSESCOR = arrayClasse

                    let response = await requisicao('POST', '/Sisplan/Cadastros/v1/subgrupocor?', `JSON=${encodeURIComponent(JSON.stringify(subgrupocorClasse))}`, null);

                    if (!response) {
                        $.LoadingOverlay("hide");
                        return;
                    };

                    let jsonStr = await response.json();
                    if (response.status != 200) {
                        $.LoadingOverlay("hide");
                        msgErro(jsonStr.mensagem);
                        return;
                    }
                    $.LoadingOverlay("hide");
                    toastr.success(
                        `Cadastro efetuado com sucesso!`,
                        'Confirmação', {
                        toastClass: 'alert',
                        iconClasses: {
                            error: 'alert-error',
                            info: 'alert-info',
                            success: 'alert-success',
                            warning: 'alert-warning'
                        },
                        positionClass: "toast-top-center",
                        progressBar: true,
                        timeOut: 3000,
                        fadeOut: 1000,
                        onHidden() {
                            window.location.href = `${BASE_URI}/subgrupocor`;
                        }
                    }
                    ).css({
                        "margin-top": "20%",
                        "width": "500px",
                        "max-width": "500px"
                    });

                } catch (error) {
                    console.error(error);
                    $.LoadingOverlay("hide");
                }
            }
        });
});