<?php include_once('../../config.php') ?>

<!DOCTYPE html>
<html>

<head>
    <meta charset="utf-8">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <title>Sisplan Web | Relatório Detalhado de Venda</title>
    <!-- Tell the browser to be responsive to screen width -->
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <!-- Font Awesome -->
    <link rel="stylesheet" href="plugins/fontawesome-free/css/all.min.css?versao=3.251.16.1">
    <!-- Theme style -->
    <link rel="stylesheet" href="dist/css/adminlte.min.css?versao=3.251.16.1">

    <!-- Google Font: Source Sans Pro -->
    <link href="https://fonts.googleapis.com/css?family=Source+Sans+Pro:300,400,400i,700" rel="stylesheet">

    <link rel="stylesheet" href="dist/css/PesquisaVariosSelect2.css?versao=3.251.16.1">
    <link rel="stylesheet" href="plugins/select2/css/select2.min.css?versao=3.251.16.1">
    <link rel="stylesheet" href="plugins/select2-bootstrap4-theme/select2-bootstrap4.min.css?versao=3.251.16.1">
    <link rel="stylesheet" href="dist/css/custom.css?versao=3.251.16.1">
    <link rel="stylesheet" href="dist/css/sisplan.css?versao=3.251.16.1">
    <link rel="stylesheet" type="text/css" href="dist/css/dataTables.bootstrap4.min.css?versao=3.251.16.1" />
    <link rel="shortcut icon" href="favicon.ico">
    <link rel="stylesheet" href="plugins/toastr/toastr.min.css?versao=3.251.16.1">
    <link rel="stylesheet" type="text/css" href="dist/css/driver.min.css?versao=3.251.16.1" />

    <style>
        .bordaCampos {
            border: solid #e0e4e6;
            border-radius: 4px;
            border-width: 2px;
            padding-top: 2%;
            padding-bottom: 0%;
        }

        .bordaCampos:first-child {
            display: flex;
            flex-direction: row;
            flex-wrap: wrap;
            justify-content: flex-end;
            align-items: center;
        }

        .border-Field .textoBorda {
            font-size: 1.0em !important;
            text-align: left !important;
            width: auto;
            padding: 0 10px;
            border-bottom: none;
        }

        .border-Field .textoTitulo {
            font-size: 1.3em !important;
            text-align: left !important;
            width: auto;
            padding: 0 10px;
            border-bottom: none;
            font-weight: bold;
        }

        .border-Field {
            border: 1.0px solid var(--font-color) !important;
            padding: 0 1.0em 1.0em 1.0em !important;
            margin: 0 0 1.0em 0 !important;
            -webkit-box-shadow: 0px 0px 0px 0px #000;
            box-shadow: 0px 0px 0px 0px #000;
            padding-bottom: 0px !important;
        }

        .apexcharts-tooltip-text,
        .apexcharts-tooltip-title,
        .apexcharts-menu-item {
            color: white !important;
        }

        .apexcharts-text,
        .apexcharts-title-text {
            fill: white !important;
        }
    </style>
</head>

<body class="hold-transition sidebar-mini layout-fixed">
    <div class="wrapper">
        <div class="content-wrapper">
            <div class="content-header">
                <div class="container-fluid">
                    <div class="row mb-2">
                        <div class="col-sm-6 flex">
                            <h1 class="m-0 text-dark">Relatório Detalhado de Venda</h1>
                            <button type="button" class="btn btn-info btn-sm ml-2" title="Tutorial" style="color: white;" id="tutorial">
                                <i class="fas fa-question-circle"></i></button>
                        </div>
                        <div class="col-sm-6">

                        </div><!-- /.col -->
                    </div><!-- /.row -->
                </div>
                <div class="container-fluid" id="tabelaSolicitacoesForne">
                    <div class="row card">
                        <div class="col-sm-12 mt-3">
                            <button class="btn btn-success btn-sisp" id="btnFiltros" type="button"><span class="fas fa-filter"></span> Filtros</button>
                            <button id="btnImprimir" class="btn-sisp btn btn-danger"><i class="fas fa-print"></i> Imprimir</button>
                        </div>
                        <div class="col-12 d-flex mt-3">
                            <div class="col-lg-4 col-md-4 col-sm-12 pl-0">
                                <fieldset class="form border-Field mb-0 pb-0">
                                    <legend class="textoTitulo mb-0 pb-0" id="totalEmpresas">Empresas</legend>
                                    <div class="col-11" id="chart"></div>
                                    <div class="col-12 table-responsive card-body pr-0 pt-0 pl-0">
                                        <table id="tabelaEmpresas" class="table table-sm table-select table-hover" width="100%" style="white-space: nowrap;">
                                            <thead>
                                            </thead>
                                            <tbody>
                                            </tbody>
                                        </table>
                                    </div>
                                </fieldset>
                            </div>

                            <div class="col-lg-4 col-md-4 col-sm-12 pl-0">
                                <fieldset class="form border-Field mb-0 pb-0">
                                    <legend class="textoTitulo mb-0 pb-0" id="totalRepresentantes">Representantes</legend>
                                    <div class="col-11" id="chart2"></div>
                                    <div class="col-12 table-responsive card-body pr-0 pt-0 pl-0">
                                        <table id="tabelaRepresentantes" class="table table-sm table-select table-hover" width="100%" style="white-space: nowrap;">
                                            <thead>
                                            </thead>
                                            <tbody>
                                            </tbody>
                                        </table>
                                    </div>
                                </fieldset>
                            </div>

                            <div class="col-lg-4 col-md-4 col-sm-12 pl-0">
                                <fieldset class="form border-Field mb-0 pb-0">
                                    <legend class="textoTitulo mb-0 pb-0" id="totalMoedas">Moedas</legend>
                                    <div class="col-11" id="chart3"></div>
                                    <div class="col-12 table-responsive card-body pr-0 pt-0 pl-0">
                                        <table id="tabelaMoedas" class="table table-sm table-select table-hover" width="100%" style="white-space: nowrap;">
                                            <thead>
                                            </thead>
                                            <tbody>
                                            </tbody>
                                        </table>
                                    </div>
                                </fieldset>
                            </div>
                        </div>
                        <div class="col-12 d-flex mt-3">
                            <div class="col-lg-6 col-md-6 col-sm-12 pl-0">
                                <fieldset class="form border-Field mb-0 pb-0">
                                    <legend class="textoTitulo mb-0 pb-0">Vendas</legend>
                                    <div class="col-12 table-responsive card-body pr-0 pt-0 pl-0">
                                        <table id="tabelaVendas" class="table table-sm table-select table-hover" width="100%" style="white-space: nowrap;">
                                            <thead>
                                            </thead>
                                            <tbody>
                                            </tbody>
                                        </table>
                                    </div>
                                </fieldset>
                            </div>

                            <div class="col-lg-6 col-md-6 col-sm-12 pl-0">
                                <fieldset class="form border-Field mb-0 pb-0">
                                    <legend class="textoTitulo mb-0 pb-0">Histórico</legend>
                                    <div class="col-12 table-responsive card-body pr-0 pt-0 pl-0">
                                        <table id="tabelaHistorico" class="table table-sm table-select table-hover" width="100%" style="white-space: nowrap;">
                                            <thead>
                                            </thead>
                                            <tbody>
                                            </tbody>
                                        </table>
                                    </div>
                                </fieldset>
                            </div>
                        </div>
                        <div class="col-12 d-flex">
                            <div class="col-lg-6 col-md-6 col-sm-12 pl-0">
                                <fieldset class="form border-Field mb-0 pb-0">
                                    <legend class="textoTitulo mb-0 pb-0">Itens da venda</legend>
                                    <div class="col-12 table-responsive card-body pr-0 pt-0 pl-0">
                                        <table id="tabelaItens" class="table table-sm table-select table-hover" width="100%" style="white-space: nowrap;">
                                            <thead>
                                            </thead>
                                            <tbody>
                                            </tbody>
                                        </table>
                                    </div>
                                </fieldset>
                            </div>

                            <div class="col-lg-6 col-md-6 col-sm-12 pl-0">
                                <fieldset class="form border-Field mb-0 pb-0">
                                    <legend class="textoTitulo mb-0 pb-0">Documentos Fiscais</legend>
                                    <div class="col-12 table-responsive card-body pr-0 pt-0 pl-0">
                                        <table id="tabelaFiscais" class="table table-sm table-select table-hover" width="100%" style="white-space: nowrap;">
                                            <thead>
                                            </thead>
                                            <tbody>
                                            </tbody>
                                        </table>
                                    </div>
                                </fieldset>
                            </div>
                        </div>
                        <div class="col-12 d-flex">

                            <div class="col-lg-6 col-md-6 col-sm-12 pl-0">
                                <fieldset class="form border-Field mb-0 pb-0">
                                    <legend class="textoTitulo mb-0 pb-0">Formas de pagamento</legend>
                                    <div class="col-12 table-responsive card-body pr-0 pt-0 pl-0">
                                        <table id="tabelaFormasPagto" class="table table-sm table-select table-hover" width="100%" style="white-space: nowrap;">
                                            <thead>
                                            </thead>
                                            <tbody>
                                            </tbody>
                                        </table>
                                    </div>
                                </fieldset>
                            </div>

                            <div class="col-lg-6 col-md-6 col-sm-12 pl-0">
                                <fieldset class="form border-Field mb-0 pb-0">
                                    <legend class="textoTitulo mb-0 pb-0">Financeiro</legend>
                                    <div class="col-12 table-responsive card-body pr-0 pt-0 pl-0">
                                        <table id="tabelaFinanceiro" class="table table-sm table-select table-hover" width="100%" style="white-space: nowrap;">
                                            <thead>
                                            </thead>
                                            <tbody>
                                            </tbody>
                                        </table>
                                    </div>
                                </fieldset>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <div id="modal-filtros" class="modal" tabindex="-1" role="dialog">
                <div class="modal-dialog modal-xl" role="document">
                    <div class="modal-content" id="modalBody">
                        <div class="modal-header">
                            <h4 class="modal-title">Filtros</h4>
                            <div class="ml-2 pt-2 d-flex">
                                <div class="radio-group form-radio icheck-primary"><input type="radio" id="radioProduto" name="tipoFat"><label for="radioProduto" class="container escondeRadio">Produto</label></div>
                                <div class="radio-group form-radio icheck-primary"><input type="radio" checked id="radioMaterial" name="tipoFat"><label for="radioMaterial" class="container escondeRadio">Material</label></div>
                            </div>
                            <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                                <span aria-hidden="true">&times;</span>
                            </button>
                        </div>
                        <div class="modal-body">
                            <div class="row">

                                <div class="col-lg-6 col-6 form" id="tipos">
                                    <fieldset class="form border-Field mb-0 pb-0">
                                        <legend class="textoBorda mb-0 pb-0">Status</legend>
                                        <div class="form-row">
                                            <div class="form-group form-check icheck-primary">
                                                <input type="checkbox" checked class="form-check-input" id="cbEmitido">
                                                <label class="form-check-label pr-2" for="cbEmitido">Emitido</label>
                                            </div>
                                            <div class="form-group form-check icheck-primary">
                                                <input type="checkbox" checked class="form-check-input" id="cbPendente">
                                                <label class="form-check-label pr-2" for="cbPendente">Pendente</label>
                                            </div>
                                            <div class="form-group form-check icheck-primary">
                                                <input type="checkbox" checked class="form-check-input" id="cbAgrupada">
                                                <label class="form-check-label pr-2" for="cbAgrupada">Agrupada</label>
                                            </div>
                                            <div class="form-group form-check icheck-primary">
                                                <input type="checkbox" checked class="form-check-input" id="cbDevolvido">
                                                <label class="form-check-label pr-2" for="cbDevolvido">Devolvido</label>
                                            </div>
                                            <div class="form-group form-check icheck-primary">
                                                <input type="checkbox" checked class="form-check-input" id="cbCancelada">
                                                <label class="form-check-label pr-2" for="cbCancelada">Canceladas</label>
                                            </div>
                                        </div>
                                    </fieldset>
                                </div>

                                <div class="col-lg-4 col-6 form" id="tipos">
                                    <fieldset class="form border-Field mb-0 pb-0">
                                        <legend class="textoBorda mb-0 pb-0">Documento Fiscal</legend>
                                        <div class="form-row">
                                            <div class="form-group form-check icheck-primary">
                                                <input type="checkbox" class="form-check-input" id="cbSemNfe">
                                                <label class="form-check-label pr-2" for="cbSemNfe">S/ NFe</label>
                                            </div>
                                            <div class="form-group form-check icheck-primary">
                                                <input type="checkbox" class="form-check-input" id="cbComNfe">
                                                <label class="form-check-label pr-2" for="cbComNfe">C/ NFe</label>
                                            </div>
                                            <div class="form-group form-check icheck-primary">
                                                <input type="checkbox" class="form-check-input" id="cbSemNfce">
                                                <label class="form-check-label pr-2" for="cbSemNfce">S/ NFCe</label>
                                            </div>
                                            <div class="form-group form-check icheck-primary">
                                                <input type="checkbox" class="form-check-input" id="cbComNfce">
                                                <label class="form-check-label pr-2" for="cbComNfce">C/ NFCe</label>
                                            </div>
                                        </div>
                                    </fieldset>
                                </div>

                                <div class="col-lg-2 col-6">
                                    <div style="margin-top: 12px;">
                                        <button class="btn btn-danger btn-sisp" type='button' id="btnSelecionarEmpresas">Selecionar Empresas</button>   
                                    </div>
                                </div>

                                <div class="col-lg-4 col-12">
                                    <label data-error="wrong" data-success="right" for="txtDtIni">Data (de/até):</label>
                                    <div class="input-group">
                                        <input type="date" max="2500-12-31" value="1200-01-01" class="input-default focus form-control" id="txtDtIni" name="txtDtIni">
                                        <input type="date" max="2500-12-31" value="2500-12-31" class="input-default focus form-control" id="txtDtFin" name="txtDtFin">
                                    </div>
                                </div>

                                <div class="col-lg-4 col-12" id="ClienteInfoTour">
                                    <label data-error="wrong" data-success="right" for="txtCliente">Cliente: </label>
                                    <div class="input-group">
                                        <select class="js-example-programmatic js-states form-control" id="txtCliente" name="txtCliente" multiple="multiple"></select>
                                        <div class="input-group-append">
                                            <button class="btn bg-danger" id="btnCliente" name="btnCliente" data-button="absoluteFbtn" type="button"><i class="m-0 p-0 fas fa-search"></i></button>
                                            <button class="btn bg-danger" id="btnLimpaCliente" name="btnLimpaCliente" type="button"><i class="m-0 p-0 fas fa-trash"></i></button>
                                        </div>
                                    </div>
                                </div>

                                <div class="col-lg-4 col-12" id="VendedorInfoTour">
                                    <label data-error="wrong" data-success="right" for="txtVendedor">Vendedor: </label>
                                    <div class="input-group">
                                        <select class="js-example-programmatic js-states form-control" id="txtVendedor" name="txtVendedor" multiple="multiple"></select>
                                        <div class="input-group-append">
                                            <button class="btn bg-danger" id="btnVendedor" name="btnVendedor" data-button="absoluteFbtn" type="button"><i class="m-0 p-0 fas fa-search"></i></button>
                                            <button class="btn bg-danger" id="btnLimpaVendedor" name="btnLimpaVendedor" type="button"><i class="m-0 p-0 fas fa-trash"></i></button>
                                        </div>
                                    </div>
                                </div>

                                <div class="col-lg-4 col-12" id="CaixaInfoTour">
                                    <label data-error="wrong" data-success="right" for="txtCaixa">Caixa: </label>
                                    <div class="input-group">
                                        <select class="js-example-programmatic js-states form-control" id="txtCaixa" name="txtCaixa" multiple="multiple"></select>
                                        <div class="input-group-append">
                                            <button class="btn bg-danger" id="btnCaixa" name="btnCaixa" data-button="absoluteFbtn" type="button"><i class="m-0 p-0 fas fa-search"></i></button>
                                            <button class="btn bg-danger" id="btnLimpaCaixa" name="btnLimpaCaixa" type="button"><i class="m-0 p-0 fas fa-trash"></i></button>
                                        </div>
                                    </div>
                                </div>

                                <div class="col-lg-4 col-12" id="TipoVendaInfoTour">
                                    <label data-error="wrong" data-success="right" for="txtTipoVenda">Tipo de Venda: </label>
                                    <div class="input-group">
                                        <select class="js-example-programmatic js-states form-control" id="txtTipoVenda" name="txtTipoVenda" multiple="multiple"></select>
                                        <div class="input-group-append">
                                            <button class="btn bg-danger" id="btnTipoVenda" name="btnTipoVenda" data-button="absoluteFbtn" type="button"><i class="m-0 p-0 fas fa-search"></i></button>
                                            <button class="btn bg-danger" id="btnLimpaTipoVenda" name="btnLimpaTipoVenda" type="button"><i class="m-0 p-0 fas fa-trash"></i></button>
                                        </div>
                                    </div>
                                </div>

                                <div class="col-lg-4 col-12" id="VendaInfoTour">
                                    <label data-error="wrong" data-success="right" for="txtVenda">Venda: </label>
                                    <div class="input-group">
                                        <select class="js-example-programmatic js-states form-control" id="txtVenda" name="txtVenda" multiple="multiple"></select>
                                        <div class="input-group-append">
                                            <button class="btn bg-danger" id="btnVenda" name="btnVenda" data-button="absoluteFbtn" type="button"><i class="m-0 p-0 fas fa-search"></i></button>
                                            <button class="btn bg-danger" id="btnLimpaVenda" name="btnLimpaVenda" type="button"><i class="m-0 p-0 fas fa-trash"></i></button>
                                        </div>
                                    </div>
                                </div>

                                <div class="col-lg-4 col-12" id="NotaInfoTour">
                                    <label data-error="wrong" data-success="right" for="txtNota">NF-e: </label>
                                    <div class="input-group">
                                        <select class="js-example-programmatic js-states form-control" id="txtNota" name="txtNota" multiple="multiple"></select>
                                        <div class="input-group-append">
                                            <button class="btn bg-danger" id="btnNota" name="btnNota" data-button="absoluteFbtn" type="button"><i class="m-0 p-0 fas fa-search"></i></button>
                                            <button class="btn bg-danger" id="btnLimpaNota" name="btnLimpaNota" type="button"><i class="m-0 p-0 fas fa-trash"></i></button>
                                        </div>
                                    </div>
                                </div>

                                <div class="col-lg-4 col-12" id="NotaNfceInfoTour">
                                    <label data-error="wrong" data-success="right" for="txtNotaNfce">NFC-e: </label>
                                    <div class="input-group">
                                        <select class="js-example-programmatic js-states form-control" id="txtNotaNfce" name="txtNotaNfce" multiple="multiple"></select>
                                        <div class="input-group-append">
                                            <button class="btn bg-danger" id="btnNotaNfce" name="btnNotaNfce" data-button="absoluteFbtn" type="button"><i class="m-0 p-0 fas fa-search"></i></button>
                                            <button class="btn bg-danger" id="btnLimpaNotaNfce" name="btnLimpaNotaNfce" type="button"><i class="m-0 p-0 fas fa-trash"></i></button>
                                        </div>
                                    </div>
                                </div>

                            </div>
                        </div>
                        <div class="modal-footer justify-content-start pl-0">
                            <div class="row col-12 ml-0">
                                <div class="col-md-4 col-sm-4 col-12">
                                    <label for="txtOrdem">Opção de Relatório:</label>
                                    <div class="relative d-flex align-items-center">
                                        <select id="txtOrdem" class="input-default focus custom-select">
                                        </select>
                                        <button class="btn btn-sm btn-success ml-2" id="btnEdicaoRelatorio" title="Edição de ordenações">
                                            <i class="fas fa-check"></i>
                                        </button>
                                    </div>
                                </div>
                                <div class="col-6 col-lg-8 d-flex justify-content-end align-items-end pr-0">
                                    <div class="d-flex">
                                        <button class="btn btn-primary btn-sisp mr-2" id="btnLimparFiltros" style="background-color: #B22222; border-color: #B22222">
                                            <span class="fas fa-trash"></span> Limpar Filtros
                                        </button>
                                        <button id="btnConsultar" class="btn btn-primary btn-sisp" type="button">
                                            <span class="fas fa-search"></span> Consultar
                                        </button>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <?php
    include_once('../../modais.php');
    ?>
    <aside class="control-sidebar control-sidebar-dark">
    </aside>
    </div>
    <script src="plugins/jquery/jquery.min.js?versao=3.251.16.1"></script>
    <script type="text/javascript" src="dist/js/jquery.dataTables.js?versao=3.251.16.1"></script>
    <script type="text/javascript" src="dist/js/dataTables.bootstrap4.min.js?versao=3.251.16.1"></script>
    <script src="plugins/jquery-ui/jquery-ui.min.js?versao=3.251.16.1"></script>
    <script>
        $.widget.bridge('uibutton', $.ui.button);
    </script>
    <script src="plugins/bootstrap/js/bootstrap.bundle.min.js?versao=3.251.16.1"></script>
    <script src="dist/js/adminlte.min.js?versao=3.251.16.1"></script>
    <script src="dist/js/sisplan.js?versao=3.251.16.1"></script>
    <script src="utils/funcoes.js?versao=3.251.16.1"></script>
    <script src="utils/cookies.js?versao=3.251.16.1"></script>
    <script src="dist/js/requisicoes.js?versao=3.251.16.1"></script>
    <script src="dist/js/loadingoverlay.min.js?versao=3.251.16.1"></script>
    <script src="dist/js/driver.min.js?versao=3.251.16.1"></script>
    <script src="plugins/toastr/toastr.min.js?versao=3.251.16.1"></script>
    <script src="plugins/select2/js/select2.full.min.js?versao=3.251.16.1"></script>
    <script type="text/javascript" src="dist/js/sum().js?versao=3.251.16.1"></script>
    <script src="dist/js/dataTables.keyTable2.js?versao=3.251.16.1"></script>
    <script type="text/javascript" src="config.js?versao=3.251.16.1"></script>
    <script src="plugins/datatables-colreorder/js/dataTables.colReorder.min.js?versao=3.251.16.1"></script>
    <script type="text/javascript" src="dist/js/apexcharts.js?versao=3.251.16.1"></script>
    <script>
        $(document).ready(async function() {
            if (getCookie('usuario') == "") {
                window.location.href = `${BASE_URI}/login`;
                return;
            }

            let usuario = getCookie('usuario');
            let empresa = getCookie('empresa');

            ipInterno = IP_INTERNO;
            ipExterno = IP_EXTERNO;
            basicAuth = BASIC_AUTH;

            const temAcesso = await temAcessoTela('RELVENDADETALHADA');
            if (!temAcesso.resultado) {
                toastrAcesso(temAcesso, BASE_URI);
                return;
            }

            sArquivo = `${BASE_URI}/pages/relvendadetalhada/relvendadetalhada.js?versao=3.251.16.1`;
            insereJavaScriptPagina(sArquivo);

        });
    </script>
</body>

</html>