$(document).ready(async function () {

    let colunas = JSON.parse(localStorage.getItem('colunasInvisiveisRelatorios'));

    let filtroDeposito = await buscaDepositoEmpresaUsuario();

    whereDeposito = 'null';

    if (filtroDeposito != '') {
        whereDeposito = `["CODIGO IN (${filtroDeposito})"]`;
    }

    // aqui so valida se nao existe tem que criar para nao dar erro
    if (colunas == null || colunas.relPecasFaturadas == undefined) {
        localStorage.setItem('colunasInvisiveisRelatorios', JSON.stringify({ ...colunas, relPecasFaturadas: ['MATERIAL', 'DESC_MATERIAL'] }));
        colunas = JSON.parse(localStorage.getItem('colunasInvisiveisRelatorios'));
    }

    // confirma as colunas
    $('#btnConfirmarColunas').on('click', async function () {
        try {
            $.LoadingOverlay('show');

            const novasColunas = retornaNovasColunasInvisiveis();
            localStorage.setItem('colunasInvisiveisRelatorios', JSON.stringify({ ...colunas, relPecasFaturadas: novasColunas }))

            $('#tabelaPecasFaturadas').DataTable().columns().visible(true);
            // $('#tabelaPrecosProduto').DataTable().columns(novasColunas).visible(false);

            $('#tabelaPecasFaturadas').DataTable().columns().every(
                function () {
                    if ((novasColunas).indexOf(this.dataSrc()) != -1) {
                        this.visible(false);
                    }
                })

        } finally {
            $.LoadingOverlay('hide');
            $('#modal-ColunasVisiveis').modal('hide');
        }
    })

    $('#btnFiltrosRel').on('click', async function () {
        $('#modal-filtros').modal('show');
        limpaFiltros();

        const parametrosVenda = await BuscaParametrosVenda();

        if (parametrosVenda[17] == '1') {
            $('#radioProduto').prop('checked', false);
            $('#radioMaterial').prop('checked', true);
            $('#lblInputCodigo').html('Material:');
            $('#txtCodigo').pesquisa_variosServerside(1, `{ "tabela":"MATERIAL", "camposSelect":["CODIGO", "DESCRICAO"], "where": null}`, 'CODIGO', 'DESCRICAO');
            $('#btnCodigo').pesquisa_serversideSel('#txtCodigo', `{"tabela":"MATERIAL", "camposSelect":["CODIGO", "DESCRICAO"], "where": null}`, 'Pesquisa de Material');
            $('#txtCodigo').empty().trigger('change');
        } else {
            $('#radioProduto').prop('checked', true);
            $('#radioMaterial').prop('checked', false);
            $('#lblInputCodigo').html('Produto:');
            $('#txtCodigo').pesquisa_variosServerside(1, '{ "tabela":"PRODUTO", "camposSelect":[ "CODIGO CHAVE", "DESCRICAO DESCRICAO"], "where": null}', 'CODIGO', 'DESCRICAO');
            $('#btnCodigo').pesquisa_serversideSel('#txtCodigo', '{"tabela":"PRODUTO", "camposSelect":[ "CODIGO", "DESCRICAO"], "where": null}', 'Pesquisa de Produto');
            $('#txtCodigo').empty().trigger('change');
        };

        criaPesquisaAutoCompletaELimpaCampo();
    });

    $('#btnLimpaFiltros').on('click', async function () {
        limpaFiltros();
    });

    $('#btnConsultar').on('click', async function () {
        await fazConsulta();
        if ($("#txtOrdem option").toArray().lenght > 0) {
            retornaHintRelatorio('btnImprimirRel', $("#txtOrdem option").toArray().map(map => { return [map.selected, $(map).attr('nome_prt')] }).filter(filter => filter[0] == true)[0][1])
        }
        $('#modal-filtros').modal('hide');
    });

    $('#radioProduto').on('click', function () {
        $('#lblInputCodigo').html('Produto:');
        $('#txtCodigo').pesquisa_variosServerside(1, '{ "tabela":"PRODUTO", "camposSelect":[ "CODIGO CHAVE", "DESCRICAO DESCRICAO"], "where": null}', 'CODIGO', 'DESCRICAO');
        $('#btnCodigo').pesquisa_serversideSel('#txtCodigo', '{"tabela":"PRODUTO", "camposSelect":[ "CODIGO", "DESCRICAO"], "where": null}', 'Pesquisa de Produto');
        $('#txtCodigo').prop('placeholder', 'Produto');
        $('#txtCodigo').empty().trigger('change');
    });

    $('#radioMaterial').on('click', function () {
        $('#lblInputCodigo').html('Material:');
        $('#txtCodigo').pesquisa_variosServerside(1, `{ "tabela":"MATERIAL", "camposSelect":["CODIGO", "DESCRICAO"], "where": null}`, 'CODIGO', 'DESCRICAO');
        $('#btnCodigo').pesquisa_serversideSel('#txtCodigo', `{"tabela":"MATERIAL", "camposSelect":["CODIGO", "DESCRICAO"], "where": null}`, 'Pesquisa de Material');
        $('#txtCodigo').prop('placeholder', 'Material');
        $('#txtCodigo').empty().trigger('change');
    });

    retornaHintRelatorio('btnImprimirRel', 'RelPecasFaturadas')

    $('#btnImprimirRel').on('click', async function () {
        try {
            $.LoadingOverlay("show");
            try {
                const filtros = await retornaFiltros();
                const url = `/sisplan/impressao/v1/imprimirrelpecasfat?${filtros}&COD_USUARIO=${getCookie('cod_usuario')}`;
                const bImprimeAutomatico = await verificaImprimirAutomatico('relpecasfaturadas');
                const arquivo = await GeraRelatorio(`${url}`, "GET", 100000, false, 'relpecasfaturadas');
                if (arquivo != undefined) {
                    if (!bImprimeAutomatico) {
                        window.open(`${BASE_URI}/relatorios_api/pdf/${arquivo}`, "_blank");
                    }
                    await limparRelatorios();
                }
            } catch (error) {
                console.error(error);
            }
        } finally {
            $.LoadingOverlay("hide");
        }
    });


    async function buscaPisECofins() {
        const empresaLogada = getCookie('emp_id');
        const PesquisaParam = {
            tabela: 'EMPRESA',
            camposSelect: ['EMP_COFINS',
                'EMP_PIS'],
            where: [`EMP_ID = ${empresaLogada}`]
        };
        const jsonStr = await retornaJsonPesquisaPadrao(JSON.stringify(PesquisaParam));
        $('#txtPis').val(jsonStr[0].EMP_PIS);
        $('#txtCofins').val(jsonStr[0].EMP_COFINS);
    };

    await buscaPisECofins();

    // async function adicionaOrdem() {
    //     const dadosSelect = {
    //         tabela: `${"ORDEM_TELA"}`,
    //         camposSelect: [`${"NOME_ORD_TELA"}, ${"NOME_PRT"}`],
    //         where: [`${"NOME_TELA"} = '${"RelPecasFaturadas"}'`],
    //     };

    //     const retornoSelect = await retornaJsonPesquisaPadrao(
    //         JSON.stringify(dadosSelect)
    //     );
    //     if (!retornoSelect) {
    //         return;
    //     }

    //     let index = 0;
    //     retornoSelect.forEach(function (item) {
    //         $("#txtOrdem").append(
    //             `<option value= ${index} nome_prt= ${item.NOME_PRT}>${item.NOME_ORD_TELA}</option>`
    //         );
    //         index++;
    //     });
    // };

    // await adicionaOrdem();
    preencheOrdenacaoTela('RelPecasFaturadas');


    async function fazConsulta() {

        if ($.fn.DataTable.isDataTable('#tabelaPecasFaturadas')) {
            $('#tabelaPecasFaturadas').DataTable().destroy();
            $('#tabelaPecasFaturadas').empty();
        };

        try {
            $.LoadingOverlay('show');

            const url = `/sisplan/impressao/v1/consultarelpecasafat?`;
            const filtros = await retornaFiltros();
            const response = await requisicao('GET', url, `${filtros}&COD_USUARIO=${getCookie('cod_usuario')}`, '', 360000);

            if (!response) {
                return;
            };

            const jsonStr = await response.json();

            if (response.status != 200) {
                msgAlerta(jsonStr.mensagem);
                return;
            };

            const tipoProd = $('#radioMaterial').is(':checked') ? 'M' : 'P';

            const dataSetCols = [];
            let indiceDireita;
            let indiceValores;

            if (tipoProd == 'M') {
                indiceDireita = [15, 16, 17, 23, 36, 37, 46, 50, 53, 54, 55, 57, 58, 59, 60, 63, 64, 66, 68, 83, 90, 91, 92, 93, 111, 112, 113, 114, 117, 118, 121, 127, 128, 129, 130, 133, 134, 137, 138, 143];
                indiceValores = [9, 10, 11, 12, 13, 14, 38, 42, 49];

                dataSetCols.push({
                    "title": "Fatura",
                    "data": "FATURA"
                });

                dataSetCols.push({
                    "title": "Tipo Fat",
                    "data": "TIPFAT"
                });

                dataSetCols.push({
                    "title": "Data Emissão",
                    "data": "DT_EMISSAO"
                });

                dataSetCols.push({
                    "title": "Data Fatura",
                    "data": "DT_FATURA"
                });

                dataSetCols.push({
                    "title": "Material",
                    "data": "MATERIAL"
                });

                dataSetCols.push({
                    "title": "Desc Material",
                    "data": "DESC_MATERIAL"
                });

                dataSetCols.push({
                    "title": "Cor",
                    "data": "COR"
                });

                dataSetCols.push({
                    "title": "Desc Cor",
                    "data": "DESCCOR"
                });

                dataSetCols.push({
                    "title": "Tam",
                    "data": "TAM"
                });

                dataSetCols.push({
                    "title": "Preço",
                    "data": "PRECO"
                });

                dataSetCols.push({
                    "title": "Valor",
                    "data": "VALOR"
                });

                dataSetCols.push({
                    "title": "Despesas",
                    "data": "DESPESAS"
                });

                dataSetCols.push({
                    "title": "Valor Líq",
                    "data": "VALOR_LIQ"
                });

                dataSetCols.push({
                    "title": "Valor Desc",
                    "data": "VALOR_DESC"
                });

                dataSetCols.push({
                    "title": "Valor ICMS",
                    "data": "VALOR_ICMS"
                });

                dataSetCols.push({
                    "title": "Qtde",
                    "data": "QTDE"
                });

                dataSetCols.push({
                    "title": "Peso L",
                    "data": "PESOL"
                });

                dataSetCols.push({
                    "title": "Peso B",
                    "data": "PESOB"
                });

                dataSetCols.push({
                    "title": "Cliente",
                    "data": "CODCLI"
                });

                dataSetCols.push({
                    "title": "Nome CLiente",
                    "data": "NOME"
                });

                dataSetCols.push({
                    "title": "Fantasia",
                    "data": "FANTASIA"
                });

                dataSetCols.push({
                    "title": "Unidade",
                    "data": "UNIDADE"
                });

                dataSetCols.push({
                    "title": "Tipo",
                    "data": "TIPO"
                });
            } else {
                indiceDireita = [15, 16, 17, 23, 36, 37, 46, 50, 53, 54, 55, 57, 58, 59, 60, 63, 64, 66, 68, 83, 90, 91, 92, 93, 111, 112, 113, 114, 117, 118, 121, 127, 128, 129, 130, 133, 134, 137, 138, 143];
                indiceValores = [9, 10, 11, 12, 13, 14, 38, 42, 49];
                dataSetCols.push({
                    "title": "Fatura",
                    "data": "FATURA"
                });

                dataSetCols.push({
                    "title": "Tipo Fat",
                    "data": "TIPFAT"
                });

                dataSetCols.push({
                    "title": "Data Emissão",
                    "data": "DT_EMISSAO"
                });

                dataSetCols.push({
                    "title": "Data Fatura",
                    "data": "DT_FATURA"
                });

                dataSetCols.push({
                    "title": "Produto",
                    "data": "CODIGO"
                });

                dataSetCols.push({
                    "title": "Desc Produto",
                    "data": "DESCRICAO"
                });

                dataSetCols.push({
                    "title": "Cor",
                    "data": "COR"
                });

                dataSetCols.push({
                    "title": "Desc Cor",
                    "data": "DESCCOR"
                });

                dataSetCols.push({
                    "title": "Tam",
                    "data": "TAM"
                });

                dataSetCols.push({
                    "title": "Preço",
                    "data": "PRECO"
                });

                dataSetCols.push({
                    "title": "Valor",
                    "data": "VALOR"
                });

                dataSetCols.push({
                    "title": "Despesas",
                    "data": "DESPESAS"
                });

                dataSetCols.push({
                    "title": "Valor Líq",
                    "data": "VALOR_LIQ"
                });

                dataSetCols.push({
                    "title": "Valor Desc",
                    "data": "VALOR_DESC"
                });

                dataSetCols.push({
                    "title": "Valor ICMS",
                    "data": "VALOR_ICMS"
                });

                dataSetCols.push({
                    "title": "Qtde",
                    "data": "QTDE"
                });

                dataSetCols.push({
                    "title": "Peso L",
                    "data": "PESOL"
                });

                dataSetCols.push({
                    "title": "Peso B",
                    "data": "PESOB"
                });

                dataSetCols.push({
                    "title": "Cliente",
                    "data": "CODCLI"
                });

                dataSetCols.push({
                    "title": "Nome CLiente",
                    "data": "NOME"
                });

                dataSetCols.push({
                    "title": "Fantasia",
                    "data": "FANTASIA"
                });

                dataSetCols.push({
                    "title": "Unidade",
                    "data": "UNIDADE"
                });

                dataSetCols.push({
                    "title": "Tipo",
                    "data": "TIPO"
                });
            };

            dataSetCols.push({
                "title": "Val Subst",
                "data": "VAL_SUBST"
            });

            dataSetCols.push({
                "title": "Impresso",
                "data": "IMPRESSO"
            });

            dataSetCols.push({
                "title": "Pedido Cli",
                "data": "PED_CLI"
            });

            dataSetCols.push({
                "title": "Grupo",
                "data": "GRUPO"
            });

            dataSetCols.push({
                "title": "Descrição Grupo Cli",
                "data": "DESCRICAO_GRUPO_CLI"
            });

            dataSetCols.push({
                "title": "Composição",
                "data": "COMPOSICAO"
            });

            dataSetCols.push({
                "title": "Desc Composição",
                "data": "DESC_COMPOSI"
            });

            dataSetCols.push({
                "title": "Pedido",
                "data": "PEDIDO"
            });

            dataSetCols.push({
                "title": "Tipo Item",
                "data": "TIPO_IT"
            });

            dataSetCols.push({
                "title": "Cod QT PisCofins",
                "data": "COD_QT_PISCOFINS"
            });

            dataSetCols.push({
                "title": "Cotação",
                "data": "COTACAO"
            });

            dataSetCols.push({
                "title": "Cod Linha",
                "data": "CODLINHA"
            });

            dataSetCols.push({
                "title": "Desc Linha",
                "data": "DESCLINHA"
            });

            dataSetCols.push({
                "title": "Peso Líq",
                "data": "PESO_LIQ"
            });

            dataSetCols.push({
                "title": "Peso",
                "data": "PESO"
            });

            dataSetCols.push({
                "title": "Custo",
                "data": "CUSTO"
            });

            dataSetCols.push({
                "title": "Descrição 2",
                "data": "DESCRICAO2"
            });

            dataSetCols.push({
                "title": "Código 2",
                "data": "CODIGO2"
            });

            dataSetCols.push({
                "title": "Protótipo",
                "data": "PROTOTIPO"
            });

            dataSetCols.push({
                "title": "Preço Médio",
                "data": "PRECO_MED"
            });

            dataSetCols.push({
                "title": "Desc Pro",
                "data": "DESC_PRO"
            });

            dataSetCols.push({
                "title": "Cod Grupo",
                "data": "CODGRUPO"
            });

            dataSetCols.push({
                "title": "Desc Grupo",
                "data": "DESCGRUPO"
            });

            dataSetCols.push({
                "title": "Qtde Unit.",
                "data": "QTDE_UNI"
            });

            dataSetCols.push({
                "title": "Etiqueta",
                "data": "ETIQUETA"
            });

            dataSetCols.push({
                "title": "Desc Etiqueta",
                "data": "DESC_ETIQUETA"
            });

            dataSetCols.push({
                "title": "Val Frete",
                "data": "VAL_FRETE"
            });

            dataSetCols.push({
                "title": "Valor Item",
                "data": "VALOR_ITEN"
            });

            dataSetCols.push({
                "title": "Custo Nota",
                "data": "CUSTO_NOTA"
            });

            dataSetCols.push({
                "title": "Espécie",
                "data": "ESPECIE"
            });

            dataSetCols.push({
                "title": "Perc ICMS",
                "data": "PERC_ICMS"
            });

            dataSetCols.push({
                "title": "Perc IPI",
                "data": "PERC_IPI"
            });

            dataSetCols.push({
                "title": "Valor IPI",
                "data": "VALOR_IPI"
            });

            dataSetCols.push({
                "title": "Pgto",
                "data": "PGTO"
            });

            dataSetCols.push({
                "title": "Taxa",
                "data": "TAXA"
            });

            dataSetCols.push({
                "title": "Margem",
                "data": "MARGEM"
            });

            dataSetCols.push({
                "title": "Perc Comissão",
                "data": "PERC_COMISSAO"
            });

            dataSetCols.push({
                "title": "Índice",
                "data": "INDICE"
            });

            dataSetCols.push({
                "title": "Natureza",
                "data": "NATUREZA"
            });

            dataSetCols.push({
                "title": "Desc Natureza",
                "data": "DESC_NAT"
            });

            dataSetCols.push({
                "title": "Val Produtos",
                "data": "VAL_PRODUTOS"
            });

            dataSetCols.push({
                "title": "Impostos Ped",
                "data": "IMPOSTOS_PED"
            });

            dataSetCols.push({
                "title": "Pedido Frete",
                "data": "PEDIDO_FRETE"
            });

            dataSetCols.push({
                "title": "Ped. Valor Desc",
                "data": "PEDIDO_VLR_DESC"
            });

            dataSetCols.push({
                "title": "Pedido Numero",
                "data": "PEDIDO_NUMERO"
            });

            dataSetCols.push({
                "title": "Ped. Perc Desc",
                "data": "PEDIDO_PER_DESC"
            });

            dataSetCols.push({
                "title": "E-mail",
                "data": "EMAIL"
            });

            dataSetCols.push({
                "title": "Endereço",
                "data": "ENDERECO"
            });

            dataSetCols.push({
                "title": "Cli End Num.",
                "data": "CLI_END_NUM"
            });

            dataSetCols.push({
                "title": "Complemento",
                "data": "COMPLEMENTO"
            });

            dataSetCols.push({
                "title": "Bairro",
                "data": "BAIRRO"
            });

            dataSetCols.push({
                "title": "Cliente CEP",
                "data": "CLIENTE_CEP"
            });

            dataSetCols.push({
                "title": "Cidade Cod UF",
                "data": "CIDADE_COD_UF"
            });

            dataSetCols.push({
                "title": "Cliente CNPJ",
                "data": "CLI_CNPJ"
            });

            dataSetCols.push({
                "title": "Cliente DDDFone",
                "data": "CLI_DDD_FONE"
            });

            dataSetCols.push({
                "title": "Cliente Telefone",
                "data": "CLI_TELEFONE"
            });

            dataSetCols.push({
                "title": "Cli Fone Compl",
                "data": "CLI_FONE_COMPL"
            });

            dataSetCols.push({
                "title": "Transportadora",
                "data": "TRANSPORT"
            });

            dataSetCols.push({
                "title": "Nome Transp.",
                "data": "NOMETRAN"
            });

            dataSetCols.push({
                "title": "Cif",
                "data": "CIF"
            });

            dataSetCols.push({
                "title": "Volumes",
                "data": "VOLUMES"
            });

            dataSetCols.push({
                "title": "CodRep",
                "data": "CODREP"
            });

            dataSetCols.push({
                "title": "TP Base",
                "data": "TP_BASE"
            });

            dataSetCols.push({
                "title": "Redesp",
                "data": "REDESP"
            });

            dataSetCols.push({
                "title": "Nome Redesp",
                "data": "NOMEREDESP"
            });

            dataSetCols.push({
                "title": "Histórico",
                "data": "HISTORICO"
            });

            dataSetCols.push({
                "title": "Desc Hist",
                "data": "DESC_HIST"
            });

            dataSetCols.push({
                "title": "Total Ped",
                "data": "TOTAL_PED"
            });

            dataSetCols.push({
                "title": "Desc Val NF",
                "data": "DESC_VALNF"
            });

            dataSetCols.push({
                "title": "Valor Ped",
                "data": "VALOR_PED"
            });

            dataSetCols.push({
                "title": "Desc Dupl",
                "data": "DESC_DUPL"
            });

            dataSetCols.push({
                "title": "Data Ini",
                "data": "DATA_INI"
            });

            dataSetCols.push({
                "title": "Data Fim",
                "data": "DATA_FIM"
            });

            dataSetCols.push({
                "title": "Grupo Cor",
                "data": "GRUPO_COR"
            });

            dataSetCols.push({
                "title": "Desc Grupo Cor",
                "data": "DESC_GRUPO_COR"
            });

            dataSetCols.push({
                "title": "Lote",
                "data": "LOTE"
            });

            dataSetCols.push({
                "title": "Cod NCM",
                "data": "COD_NCM"
            });

            dataSetCols.push({
                "title": "Nome NCM",
                "data": "NOME_NCM"
            });

            dataSetCols.push({
                "title": "Tab Fis Tipo",
                "data": "TABFIS_TIPO"
            });

            dataSetCols.push({
                "title": "Gera INSS",
                "data": "GERA_INSS"
            });

            dataSetCols.push({
                "title": "Faixa",
                "data": "FAIXA"
            });

            dataSetCols.push({
                "title": "Marca",
                "data": "MARCA"
            });

            dataSetCols.push({
                "title": "Desc Marca",
                "data": "DESC_MARCA"
            });

            dataSetCols.push({
                "title": "Linha",
                "data": "LINHA"
            });

            dataSetCols.push({
                "title": "Desc Linha",
                "data": "DESC_LINHA"
            });

            dataSetCols.push({
                "title": "Estilista",
                "data": "ESTILISTA"
            });

            dataSetCols.push({
                "title": "Desc Estilista",
                "data": "DESC_ESTILISTA"
            });

            dataSetCols.push({
                "title": "Coleção",
                "data": "COLECAO"
            });

            dataSetCols.push({
                "title": "Valor PIS",
                "data": "PIS"
            });

            dataSetCols.push({
                "title": "Valor COFINS",
                "data": "COFINS"
            });

            dataSetCols.push({
                "title": "Preço Orig",
                "data": "PRECO_ORIG",
            });

            dataSetCols.push({
                "title": "Desc Pedido",
                "data": "DESC_PEDIDO"
            });

            dataSetCols.push({
                "title": "EMP",
                "data": "EMP"
            });

            dataSetCols.push({
                "title": "Unidade Nota",
                "data": "UNIDADE_NOTA"
            });

            dataSetCols.push({
                "title": "Qtde Unit. Nota",
                "data": "QTDE_UNI_NOTA"
            });

            dataSetCols.push({
                "title": "Preço Custo",
                "data": "PRECO_CUSTO"
            });

            dataSetCols.push({
                "title": "Pantone",
                "data": "PANTONE"
            });

            dataSetCols.push({
                "title": "Posição",
                "data": "POSICAO"
            });

            dataSetCols.push({
                "title": "Valor ICMSST",
                "data": "VALOR_ICMSST"
            });

            dataSetCols.push({
                "title": "Desc Coleção",
                "data": "DESC_COLECAO"
            });

            dataSetCols.push({
                "title": "Coleção Ped",
                "data": "COL_PED"
            });

            dataSetCols.push({
                "title": "Desc Col Ped",
                "data": "DESC_COL_PED"
            });

            dataSetCols.push({
                "title": "Coleção Mat.",
                "data": "COLECAO_MAT"
            });

            dataSetCols.push({
                "title": "Desc Coleção Mat",
                "data": "DESC_COLECAO_MAT"
            });

            dataSetCols.push({
                "title": "Peso OB",
                "data": "PESO_OB"
            });

            dataSetCols.push({
                "title": "Valor Prod. Nota",
                "data": "VAL_PRODUTOS_NOTA"
            });

            dataSetCols.push({
                "title": "Valor Desc. Nota",
                "data": "VAL_DESCONTO_NOTA"
            });

            dataSetCols.push({
                "title": "Divisor",
                "data": "DIVISOR"
            });

            dataSetCols.push({
                "title": "Existe Receber",
                "data": "EXISTE_RECEBER"
            });

            dataSetCols.push({
                "title": "Mês",
                "data": "MES"
            });

            dataSetCols.push({
                "title": "Emp PIS",
                "data": "EMP_PIS"
            });

            dataSetCols.push({
                "title": "Emp COFINS",
                "data": "EMP_COFINS"
            });

            dataSetCols.push({
                "title": "SubGrupo",
                "data": "SUB_GRUPO"
            });

            dataSetCols.push({
                "title": "Desc SubGrupo",
                "data": "DESC_SUBGRUPO"
            });

            dataSetCols.push({
                "title": "Com 1",
                "data": "COM1"
            });

            dataSetCols.push({
                "title": "Com 2",
                "data": "COM2"
            });

            dataSetCols.push({
                "title": "Tipo Venda",
                "data": "TP_VENDA"
            });

            dataSetCols.push({
                "title": "Desc TP Venda",
                "data": "DESC_TP_VENDA"
            });

            dataSetCols.push({
                "title": "Motivo",
                "data": "MOTIVO"
            });

            dataSetCols.push({
                "title": "Desc Motivo",
                "data": "DESC_MOTIVO"
            });

            dataSetCols.push({
                "title": "Val ICMS Deson",
                "data": "VAL_ICMS_DESON"
            });

            dataSetCols.push({
                "title": "Depósito",
                "data": "DEPOSITO"
            });


            dataSetCols.push({
                "title": "Desc Depósito",
                "data": "DESC_DEPOSITO"
            });

            dataSetCols.push({
                "title": "CodFis",
                "data": "CODFIS"
            });

            dataSetCols.push({
                "title": "CodMoeda",
                "data": "COD_MOEDA"
            });

            dataSetCols.push({
                "title": "Data Saída",
                "data": "DT_SAIDA"
            });

            dataSetCols.push({
                "title": "Nome Cidade",
                "data": "CIDADE_NOME"
            });

            if (tipoProd == 'P') {
                dataSetCols.push({
                    "title": "Material",
                    "data": "MATERIAL"
                });

                dataSetCols.push({
                    "title": "Desc Material",
                    "data": "DESC_MATERIAL"
                });
            } else {
                dataSetCols.push({
                    "title": "Produto",
                    "data": "CODIGO"
                });

                dataSetCols.push({
                    "title": "Desc Produto",
                    "data": "DESCRICAO"
                });
            }

            $('#tabelaPecasFaturadas').DataTable({
                bPaginate: true,
                destroy: true,
                colReorder: true,
                language: {
                    sEmptyTable: "Nenhum registro encontrado",
                    sInfo: "_TOTAL_ registros",
                    sInfoEmpty: " 0 registros",
                    sInfoFiltered: "(Filtrados de _MAX_ registros)",
                    sInfoPostFix: "",
                    sInfoThousands: ".",
                    sLengthMenu: "_MENU_ resultados",
                    sLoadingRecords: "Carregando...",
                    sProcessing: "Processando...",
                    sZeroRecords: "Nenhum registro encontrado",
                    sSearch: "Pesquisar",
                    oPaginate: {
                        sNext: "Próximo",
                        sPrevious: "Anterior",
                        sFirst: "Primeiro",
                        sLast: "Último",
                    },
                    oAria: {
                        sSortAscending: ": Ordenar colunas de forma ascendente",
                        sSortDescending: ": Ordenar colunas de forma descendente",
                    },
                },
                autoWidth: true,
                columns: dataSetCols,
                data: jsonStr,
                columnDefs: [
                    {
                        type: 'date-br',
                        targets: [2, 3, 94, 95],
                        render(data) {
                            if (data) {
                                return new Intl.DateTimeFormat('pt-BR').format(new Date(`${data.split(' ')[0]} 23:59:59`));
                            } else {
                                return '';
                            }

                        },
                    },
                    {
                        targets: indiceValores,
                        render(data) {
                            return 'R$ ' + parseFloat(data).toFixed(2).replace('.', ',')
                        },
                        "className": 'pr-4 text-right'
                    },
                    {
                        targets: indiceDireita,
                        "className": 'pr-4 text-right'
                    }
                ]
            });

            const colunasInvisiveis = JSON.parse(localStorage.getItem('colunasInvisiveisRelatorios'));

            $('#tabelaPecasFaturadas_length').prepend('<button class="buttonColVis" id="buttonColVis"><i class="fas fa-cogs"></i></button>');
            $('#tabelaPecasFaturadas_length').prepend('<button class="buttonExcel" id="buttonExcel"><i class="fas fa-file-excel"></i></button>');

            $('#buttonColVis').prop('title', 'Configurar colunas visíveis')
            $('#buttonExcel').prop('title', 'Exportar')

            $('#buttonColVis').on('click', async function () {
                $.LoadingOverlay('show');
                $('#modal-ColunasVisiveis').modal('show');
                $.LoadingOverlay('hide');
            });

            $('#buttonExcel').on('click', async function () {
                const url = `/sisplan/impressao/v1/consultarelpecasafat?`;
                const filtros = await retornaFiltros();
                await exportaCSV(url, filtros, false, null, 'Relatório de Peças Faturadas', '#tabelaPecasFaturadas');
            })

            $('#tabelaPecasFaturadas').DataTable().columns().every(
                function () {
                    if ((colunasInvisiveis.relPecasFaturadas).indexOf(this.dataSrc()) != -1) {
                        this.visible(false);
                    }
                })

        } catch (error) {
            console.error(error)
        } finally {
            $.LoadingOverlay('hide');
        }
    };

    $('#modal-ColunasVisiveis').on('show.bs.modal', function () {
        const cols = [];

        let colunasInvisiveis = JSON.parse(localStorage.getItem('colunasInvisiveisRelatorios'))

        $('#tabelaPecasFaturadas').DataTable().columns().every(function () {
            cols.push({
                'title': $(this.header()).text(),
                'data': this.dataSrc()
            })
        });

        adicionaColunas(cols, colunasInvisiveis.relPecasFaturadas ?? ['MATERIAL', 'DESC_MATERIAL'])
    })

    $('#btnCarregaEmpresas').on('click', function () {
        carregaEmpresasDisponiveis();
    });

    async function retornaFiltros() {

        const dataEmissaoNFIni = $('#txtDataEmissaoNFI').val();
        const dataEmissaoNFFim = $('#txtDataEmissaoNFF').val();
        const tipoItemFiltrado = $('#radioMaterial').is(':checked') ? 'M' : 'P';
        const produtoFiltrado = await formataListas($('#txtCodigo').val().toString());
        const clienteFiltrado = await formataListas($('#txtCliente').val().toString());
        const grupoMatFiltrado = await formataListas($('#txtGrupoMat').val().toString());
        const subGrupoMatFiltrado = await formataListas($('#txtSubgrupoMat').val().toString());
        const represenFiltrado = await formataListas($('#txtRepresentante').val().toString());
        const grupoCliFiltrado = await formataListas($('#txtGrupoCli').val().toString());
        const grupoProdFiltrado = await formataListas($('#txtGrupo').val().toString());
        const composicaoFiltrado = await formataListas($('#txtComposicao').val().toString());
        const ncmFiltrado = await formataListas($('#txtNCM').val().toString());
        const coordFiltrado = await formataListas($('#txtCoord').val().toString());
        const depositoFiltrado = await formataListas($('#txtDeposito').val().toString());
        const moedaFiltrado = await formataListas($('#txtMoeda').val().toString());
        const linhaMatFiltrado = await formataListas($('#txtLinhaMat').val().toString());
        const linhaFiltrado = await formataListas($('#txtLinha').val().toString());
        const nfFiltrado = await formataListas($('#txtNF').val().toString());
        const colecaoProdFiltrado = await formataListas($('#txtColecaoProd').val().toString());
        const colecaoPedFiltrado = await formataListas($('#txtColecaoPed').val().toString());
        const tipoVendaFiltrado = await formataListas($('#txtTipoVenda').val().toString());
        const estilistaFiltrado = await formataListas($('#txtEstilista').val().toString());
        const marcaFiltrado = await formataListas($('#txtMarca').val().toString());
        const pedidoFiltrado = await formataListas($('#txtPedido').val().toString());
        const estadoFiltrado = await formataListas($('#txtEstado').val().toString());
        const naturezaFiltrado = await formataListas($('#txtNatureza').val().toString());
        const consideraNatureza = $('#cbConsideraNatureza').is(':checked');
        const prazoEntFiltrado = await formataListas($('#txtPrazoEnt').val().toString());
        const loteFiltrado = $('#txtLote').val();
        const motivoFiltrado = await formataListas($('#txtMotivo').val().toString());
        const categoriaFiltrado = await formataListas($('#txtCategoria').val().toString());
        const etiquetaFiltrado = await formataListas($('#txtEtiqueta').val().toString());
        const percCofins = $('#txtCofins').val();
        const percPis = $('#txtPis').val();
        const consideraCategoria = $('#selectTipoEntidade').val();
        const naoMostraNfeDev = $('#cbMostraOuNaoNFEDevolucao').is(':checked');
        const consideraFatorConv = $('#cbConsideraFatorConversao').is(':checked');
        const empresasFiltradas = $('.empresa_selecionada:checked').toArray().length > 0 ? $('.empresa_selecionada:checked').toArray().map(input => input.id.substring(input.id.indexOf('-') + 1, input.id.length))
            : [getCookie('emp_id')];

        const empresasFiltradasFormatada = await formataListas(empresasFiltradas.toString());

        ///Notas
        let tipoNotas;

        if ($('#cbTodas').is(':checked')) {
            tipoNotas = $('#cbTodas').val();
        } else if ($('#cbNormais').is(':checked')) {
            tipoNotas = $('#cbNormais').val();
        } else if ($('#cbNormais-Den-Canc').is(':checked')) {
            tipoNotas = $('#cbNormais-Den-Canc').val();
        } else if ($('#cbNormais-Den').is(':checked')) {
            tipoNotas = $('#cbNormais-Den').val();
        } else if ($('#cbNormais-Canc').is(':checked')) {
            tipoNotas = $('#cbNormais-Canc').val();
        } else {
            tipoNotas = '';
        }

        ///Duplicatas
        let tipoDuplicatas;

        if ($('#cbTodasDups').is(':checked')) {
            tipoDuplicatas = $('#cbTodasDups').val();
        } else if ($('#cbComDups').is(':checked')) {
            tipoDuplicatas = $('#cbComDups').val();
        } else if ($('#cbSemDups').is(':checked')) {
            tipoDuplicatas = $('#cbSemDups').val();
        } else {
            tipoDuplicatas = '';
        }

        //Filtro
        let tipoFiltro;

        if ($('#cbTodosFiltros').is(':checked')) {
            tipoFiltro = $('#cbTodosFiltros').val();
        } else if ($('#cbProduto').is(':checked')) {
            tipoFiltro = $('#cbProduto').val();
        } else if ($('#cbMaterial').is(':checked')) {
            tipoFiltro = $('#cbMaterial').val();
        } else if ($('#cbServico').is(':checked')) {
            tipoFiltro = $('#cbServico').val();
        } else {
            tipoFiltro = '';
        }

        //Inss
        let tipoInss;

        if ($('#cbTodosInss').is(':checked')) {
            tipoInss = $('#cbTodosInss').val();
        } else if ($('#cbComInss').is(':checked')) {
            tipoInss = $('#cbComInss').val();
        } else if ($('#cbSemInss').is(':checked')) {
            tipoInss = $('#cbSemInss').val();
        } else {
            tipoInss = '';
        }

        ///tipos de Natureza
        let tiposNatureza = [];

        if ($('#cbVendaCompra').is(':checked')) {
            tiposNatureza.push($('#cbVendaCompra').val());
        };
        if ($('#cbDevolucao').is(':checked')) {
            tiposNatureza.push($('#cbDevolucao').val());
        };
        if ($('#cbRemessa').is(':checked')) {
            tiposNatureza.push($('#cbRemessa').val());
        };
        if ($('#cbRetorno').is(':checked')) {
            tiposNatureza.push($('#cbRetorno').val());
        };
        if ($('#cbConsignacao').is(':checked')) {
            tiposNatureza.push($('#cbConsignacao').val());
        };
        if ($('#cbAntecipacao').is(':checked')) {
            tiposNatureza.push($('#cbAntecipacao').val());
        };
        if ($('#cbServicos').is(':checked')) {
            tiposNatureza.push($('#cbServicos').val());
        };
        if ($('#cbEnergiaTelefone').is(':checked')) {
            tiposNatureza.push($('#cbEnergiaTelefone').val());
        };
        if ($('#cbBonificacao').is(':checked')) {
            tiposNatureza.push($('#cbBonificacao').val());
        };
        if ($('#cbPatrimonio').is(':checked')) {
            tiposNatureza.push($('#cbPatrimonio').val());
        };
        if ($('#cbEstornoImposto').is(':checked')) {
            tiposNatureza.push($('#cbEstornoImposto').val());
        };

        tiposNatureza = await formataListas(tiposNatureza.toString());



        //tipos de Categoria de Entidade
        let clienteEstaCheck = false;
        let fornecedorEstaCheck = false;
        let terceirosEstaCheck = false;

        if ($('#cbCliente').is(':checked')) {
            clienteEstaCheck = true;
        };

        if ($('#cbFornecedor').is(':checked')) {
            fornecedorEstaCheck = true;
        };

        if ($('#cbTerceiros').is(':checked')) {
            terceirosEstaCheck = true;
        };


        const filtros = `DTEMISSAONFINI=${dataEmissaoNFIni}&` +
            `DTEMISSAONFFIM=${dataEmissaoNFFim}&` +
            `ITEMFILTRADO=${produtoFiltrado}&` +
            `TIPOITEMFILTRADO=${tipoItemFiltrado}&` +
            `CLIENTEFILTRADO=${clienteFiltrado}&` +
            `GRUPOMATFILTRADO=${grupoMatFiltrado}&` +
            `SUBGRUPOMATFILTRADO=${subGrupoMatFiltrado}&` +
            `REPRESENTANTEFILTRADO=${represenFiltrado}&` +
            `GRUPOCLIFILTRADO=${grupoCliFiltrado}&` +
            `GRUPOPRODFILTRADO=${grupoProdFiltrado}&` +
            `COMPOSICAOFILTRADO=${composicaoFiltrado}&` +
            `NCMFILTRADO=${ncmFiltrado}&` +
            `COORDFILTRADO=${coordFiltrado}&` +
            `DEPOSITOFILTRADO=${depositoFiltrado}&` +
            `MOEDAFILTRADO=${moedaFiltrado}&` +
            `LINHAMATFILTRADO=${linhaMatFiltrado}&` +
            `LINHAFILTRADO=${linhaFiltrado}&` +
            `NFFILTRADO=${nfFiltrado}&` +
            `COLECAOPRODFILTRADO=${colecaoProdFiltrado}&` +
            `COLECAOPEDFILTRADO=${colecaoPedFiltrado}&` +
            `TIPOVENDAFILTRADO=${tipoVendaFiltrado}&` +
            `ESTILISTAFILTRADO=${estilistaFiltrado}&` +
            `MARCAFILTRADO=${marcaFiltrado}&` +
            `PEDIDOFILTRADO=${pedidoFiltrado}&` +
            `ESTADOFILTRADO=${estadoFiltrado}&` +
            `NATUREZAFILTRADO=${naturezaFiltrado}&` +
            `CONSIDERANATUREZA=${consideraNatureza}&` +
            `PRAZOENTFILTRADO=${prazoEntFiltrado}&` +
            `LOTEFILTRADO=${loteFiltrado}&` +
            `MOTIVOFILTRADO=${motivoFiltrado}&` +
            `CATEGORIAFILTRADO=${categoriaFiltrado}&` +
            `ETIQUETAFILTRADO=${etiquetaFiltrado}&` +
            `PERCCOFINS=${percCofins}&` +
            `PERCPIS=${percPis}&` +
            `CONSIDERACATEGORIA=${consideraCategoria}&` +
            `NAOMOSTRANFDEV=${naoMostraNfeDev}&` +
            `CONSIDERAFATORCONV=${consideraFatorConv}&` +
            `EMPRESASFILTRADAS=${empresasFiltradasFormatada}&` +
            `TIPONOTASFILTRADO=${tipoNotas}&` +
            `TIPODUPLICATASFILTRADO=${tipoDuplicatas}&` +
            `TIPOFILTROFILTRADO=${tipoFiltro}&` +
            `TIPOINSSFILTRADO=${tipoInss}&` +
            `NATUREZASFILTRADAS=${tiposNatureza.toString()}&` +
            `CLIENTEESTACHECK=${clienteEstaCheck}&` +
            `FORNECEDORESTACHECK=${fornecedorEstaCheck}&` +
            `TERCEIROSESTACHECK=${terceirosEstaCheck}&` +
            `UTILIZAPARTEDOLOTE=${$('#cbUtilizaPartedoLote').is(':checked')}&` +
            `NATDEVOLUCAO=${$('#cbDevolucao').is(':checked')}&` +
            `TODASEMPRESAS=${$('#cbTodasAsEmpresas').is(':checked')}&` +
            `ORDEM_ORDENACAO=${$('#txtOrdem').val()}`


        return filtros;

    };

    function criaPesquisaAutoCompletaELimpaCampo() {

        $('#txtCodigo').pesquisa_variosServerside(2, '{ "tabela":"PRODUTO", "camposSelect":[ "CODIGO", "DESCRICAO"], "where": null}', 'CODIGO', 'DESCRICAO');
        $('#btnCodigo').pesquisa_serversideSel('#txtCodigo', `{ "tabela":"PRODUTO", "camposSelect":[ "CODIGO", "DESCRICAO"], "where": null}`, 'Pesquisa de Produto');
        $('#btnLimpaCodigo').on('click', function () {$('#txtCodigo').empty().trigger('change');});
        
        $('#txtDeposito').pesquisa_variosServerside(1, `{ "tabela":"DEPOSITO", "camposSelect":[ "CODIGO", "DESCRICAO"], "where": ${whereDeposito}}`, 'CODIGO', 'DESCRICAO');
        $('#btnDeposito').pesquisa_serversideSel('#txtDeposito', `{ "tabela":"DEPOSITO", "camposSelect":[ "CODIGO", "DESCRICAO"], "where": ${whereDeposito}}`, 'Pesquisa de Depósito');
        $('#btnLimpaDeposito').on('click', function () {$('#txtDeposito').empty().trigger('change');});

        $('#txtCliente').pesquisa_variosServerside(2, '{ "tabela":"ENTIDADE", "camposSelect":[ "CODCLI", "NOME"], "where": null}', 'CODCLI', 'NOME');
        $('#btnCliente').pesquisa_serversideSel('#txtCliente', `{ "tabela":"ENTIDADE", "camposSelect":[ "CODCLI", "NOME"], "where": null}`, 'Pesquisa de Cliente');
        $('#btnLimpaCliente').on('click', function () {$('#txtCliente').empty().trigger('change');});

        $('#txtGrupoMat').pesquisa_variosServerside(1, '{ "tabela":"GRUPO_MA", "camposSelect":[ "CODIGO", "DESCRICAO"], "where": null}', 'CODIGO', 'DESCRICAO');
        $('#btnGrupoMat').pesquisa_serversideSel('#txtGrupoMat', `{ "tabela":"GRUPO_MA", "camposSelect":[ "CODIGO", "DESCRICAO"], "where": null}`, 'Pesquisa de Grupo de Material');
        $('#btnLimpaGrupoMat').on('click', function () {$('#txtGrupoMat').empty().trigger('change');});

        $('#txtSubgrupoMat').pesquisa_variosServerside(1, '{ "tabela":"SUBGRUPO_MA", "camposSelect":[ "CODIGO", "DESCRICAO"], "where": null}', 'CODIGO', 'DESCRICAO');
        $('#btnSubgrupoMat').pesquisa_serversideSel('#txtSubgrupoMat', `{ "tabela":"SUBGRUPO_MA", "camposSelect":[ "CODIGO", "DESCRICAO"], "where": null}`, 'Pesquisa de Sub Grupo de Material');
        $('#btnLimpaSubgrupoMat').on('click', function () {$('#txtSubgrupoMat').empty().trigger('change');});

        $('#txtRepresentante').pesquisa_variosServerside(1, '{ "tabela":"REPRESEN", "camposSelect":[ "CODREP", "NOME"], "where": null}', 'CODREP', 'NOME');
        $('#btnRepresentante').pesquisa_serversideSel('#txtRepresentante', `{ "tabela":"REPRESEN", "camposSelect":[ "CODREP", "NOME"], "where": null}`, 'Pesquisa de Representante');
        $('#btnLimpaRepresentante').on('click', function () {$('#txtRepresentante').empty().trigger('change');});

        $('#txtGrupoCli').pesquisa_variosServerside(1, '{ "tabela":"GRUPO_CLI", "camposSelect":[ "CODIGO", "DESCRICAO"], "where": null}', 'CODIGO', 'DESCRICAO');
        $('#btnGrupoCli').pesquisa_serversideSel('#txtGrupoCli', `{ "tabela":"GRUPO_CLI", "camposSelect":[ "CODIGO", "DESCRICAO"], "where": null}`, 'Pesquisa de Grupo de Cliente');
        $('#btnLimpaGrupoCli').on('click', function () {$('#txtGrupoCli').empty().trigger('change');});

        $('#txtGrupo').pesquisa_variosServerside(1, '{ "tabela":"GRUPO_PA", "camposSelect":[ "CODIGO", "DESCRICAO"], "where": null}', 'CODIGO', 'DESCRICAO');
        $('#btnGrupo').pesquisa_serversideSel('#txtGrupo', `{ "tabela":"GRUPO_PA", "camposSelect":[ "CODIGO", "DESCRICAO"], "where": null}`, 'Pesquisa de Grupo');
        $('#btnLimpaGrupo').on('click', function () {$('#txtGrupo').empty().trigger('change');});

        $('#txtComposicao').pesquisa_variosServerside(1, '{ "tabela":"CADCOMPOSI", "camposSelect":[ "CODIGO", "DESCRICAO"], "where": null}', 'CODIGO', 'DESCRICAO');
        $('#btnComposicao').pesquisa_serversideSel('#txtComposicao', `{ "tabela":"CADCOMPOSI", "camposSelect":[ "CODIGO", "DESCRICAO"], "where": null}`, 'Pesquisa de Composição');
        $('#btnLimpaComposicao').on('click', function () {$('#txtComposicao').empty().trigger('change');});

        $('#txtNCM').pesquisa_variosServerside(1, '{ "tabela":"TABFIS", "camposSelect":[ "CODIGO", "DESCRICAO", "TIPO"], "where": null}', 'CODIGO', 'DESCRICAO');
        $('#btnNCM').pesquisa_serversideSel('#txtNCM', `{ "tabela":"TABFIS", "camposSelect":[ "CODIGO", "DESCRICAO", "TIPO"], "where": null}`, 'Pesquisa de NCM');
        $('#btnLimpaNCM').on('click', function () {$('#txtNCM').empty().trigger('change');});

        $('#txtCoord').pesquisa_variosServerside(1, '{ "tabela":"ENTIDADE", "camposSelect":[ "CODCLI", "NOME"], "where": null}', 'CODCLI', 'NOME');
        $('#btnCoord').pesquisa_serversideSel('#txtCoord', `{ "tabela":"ENTIDADE", "camposSelect":[ "CODCLI", "NOME"], "where": null}`, 'Pesquisa de Coord.');
        $('#btnLimpaCoord').on('click', function () {$('#txtCoord').empty().trigger('change');});

        $('#txtMoeda').pesquisa_variosServerside(1, '{ "tabela":"MOEDA", "camposSelect":[ "CODMOE", "DESCRICAO"], "where": null}', 'CODMOE', 'DESCRICAO');
        $('#btnMoeda').pesquisa_serversideSel('#txtMoeda', `{ "tabela":"MOEDA", "camposSelect":[ "CODMOE", "DESCRICAO"], "where": null}`, 'Pesquisa de Moeda.');
        $('#btnLimpaMoeda').on('click', function () {$('#txtMoeda').empty().trigger('change');});

        $('#txtLinhaMat').pesquisa_variosServerside(1, '{ "tabela":"TABLIN", "camposSelect":[ "CODIGO", "DESCRICAO"], "where": null}', 'CODIGO', 'DESCRICAO');
        $('#btnLinhaMat').pesquisa_serversideSel('#txtLinhaMat', `{ "tabela":"TABLIN", "camposSelect":[ "CODIGO", "DESCRICAO"], "where": null}`, 'Pesquisa de Linha.');
        $('#btnLimpaLinhaMat').on('click', function () {$('#txtLinhaMat').empty().trigger('change');});

        $('#txtLinha').pesquisa_variosServerside(1, '{ "tabela":"TABLIN", "camposSelect":[ "CODIGO", "DESCRICAO"], "where": null}', 'CODIGO', 'DESCRICAO');
        $('#btnLinha').pesquisa_serversideSel('#txtLinha', `{ "tabela":"TABLIN", "camposSelect":[ "CODIGO", "DESCRICAO"], "where": null}`, 'Pesquisa de Linha.');
        $('#btnLimpaLinha').on('click', function () {$('#txtLinha').empty().trigger('change');});

        $('#txtNF').pesquisa_variosServerside(1, '{ "tabela":"NOTA", "camposSelect":[ "FATURA", "SERIE"], "where": null}', 'FATURA', 'SERIE');
        $('#btnNF').pesquisa_serversideSel('#txtNF', `{ "tabela":"NOTA", "camposSelect":[ "FATURA", "SERIE"], "where": null}`, 'Pesquisa de Nota Fiscal.');
        $('#btnLimpaNF').on('click', function () {$('#txtNF').empty().trigger('change');});

        $('#txtColecaoProd').pesquisa_variosServerside(1, '{ "tabela":"COLECAO", "camposSelect":[ "CODIGO", "DESCRICAO"], "where": null}', 'CODIGO', 'DESCRICAO');
        $('#btnColecaoProd').pesquisa_serversideSel('#txtColecaoProd', `{ "tabela":"COLECAO", "camposSelect":[ "CODIGO", "DESCRICAO"], "where": null}`, 'Pesquisa de Coleção.');
        $('#btnLimpaColecaoProd').on('click', function () {$('#txtColecaoProd').empty().trigger('change');});

        $('#txtColecaoPed').pesquisa_variosServerside(1, '{ "tabela":"COLECAO", "camposSelect":[ "CODIGO", "DESCRICAO"], "where": null}', 'CODIGO', 'DESCRICAO');
        $('#btnColecaoPed').pesquisa_serversideSel('#txtColecaoPed', `{ "tabela":"COLECAO", "camposSelect":[ "CODIGO", "DESCRICAO"], "where": null}`, 'Pesquisa de Coleção.');
        $('#btnLimpaColecaoPed').on('click', function () {$('#txtColecaoPed').empty().trigger('change');});

        $('#txtTipoVenda').pesquisa_variosServerside(1, '{ "tabela":"VENDA_TIPO", "camposSelect":[ "ID", "DESCRICAO"], "where": null}', 'ID', 'DESCRICAO');
        $('#btnTipoVenda').pesquisa_serversideSel('#txtTipoVenda', `{ "tabela":"VENDA_TIPO", "camposSelect":[ "ID", "DESCRICAO"], "where": null}`, 'Pesquisa de Tipo de Venda.');
        $('#btnLimpaTipoVenda').on('click', function () {$('#txtTipoVenda').empty().trigger('change');});

        $('#txtEstilista').pesquisa_variosServerside(1, '{ "tabela":"PESSOAL", "camposSelect":[ "CODIGO", "NOME"], "where": null}', 'CODIGO', 'NOME');
        $('#btnEstilista').pesquisa_serversideSel('#txtEstilista', `{ "tabela":"PESSOAL", "camposSelect":[ "CODIGO", "NOME"], "where": null}`, 'Pesquisa de Estilista.');
        $('#btnLimpaEstilista').on('click', function () {$('#txtEstilista').empty().trigger('change');});

        $('#txtMarca').pesquisa_variosServerside(1, '{ "tabela":"MARCA", "camposSelect":[ "CODIGO", "DESCRICAO"], "where": null}', 'CODIGO', 'DESCRICAO');
        $('#btnMarca').pesquisa_serversideSel('#txtMarca', `{ "tabela":"MARCA", "camposSelect":[ "CODIGO", "DESCRICAO"], "where": null}`, 'Pesquisa de Marca.');
        $('#btnLimpaMarca').on('click', function () {$('#txtMarca').empty().trigger('change');});

        $('#txtPedido').pesquisa_variosServerside(1, '{ "tabela":"PEDIDO", "camposSelect":[ "NUMERO", "CODCLI"], "where": null}', 'NUMERO', 'CODCLI');
        $('#btnPedido').pesquisa_serversideSel('#txtPedido', `{ "tabela":"PEDIDO", "camposSelect":[ "NUMERO", "CODCLI"], "where": null}`, 'Pesquisa de Pedido.');
        $('#btnLimpaPedido').on('click', function () {$('#txtPedido').empty().trigger('change');});

        $('#txtEstado').pesquisa_variosServerside(1, '{ "tabela":"TABUF", "camposSelect":[ "CODIGO", "DESCRICAO"], "where": null}', 'CODIGO', 'DESCRICAO');
        $('#btnEstado').pesquisa_serversideSel('#txtEstado', `{ "tabela":"TABUF", "camposSelect":[ "CODIGO", "DESCRICAO"], "where": null}`, 'Pesquisa de Estado.');
        $('#btnLimpaEstado').on('click', function () {$('#txtEstado').empty().trigger('change');});

        $('#txtNatureza').pesquisa_variosServerside(1, '{ "tabela":"NATUREZA", "camposSelect":[ "NATUREZA", "DESCRICAO"], "where": null}', 'NATUREZA', 'DESCRICAO');
        $('#btnNatureza').pesquisa_serversideSel('#txtNatureza', `{ "tabela":"NATUREZA", "camposSelect":[ "NATUREZA", "DESCRICAO"], "where": null}`, 'Pesquisa de Natureza.');
        $('#btnLimpaNatureza').on('click', function () {$('#txtNatureza').empty().trigger('change');});

        $('#txtPrazoEnt').pesquisa_variosServerside(1, '{ "tabela":"TABPRZ", "camposSelect":[ "PRAZO", "DESCRICAO"], "where": null}', 'PRAZO', 'DESCRICAO');
        $('#btnPrazoEnt').pesquisa_serversideSel('#txtPrazoEnt', `{ "tabela":"TABPRZ", "camposSelect":[ "PRAZO", "DESCRICAO"], "where": null}`, 'Pesquisa de Prazo de Entrega.');
        $('#btnLimpaPrazoEnt').on('click', function () {$('#txtPrazoEnt').empty().trigger('change');});

        $('#txtMotivo').pesquisa_variosServerside(1, '{ "tabela":"MENSAGEM", "camposSelect":[ "CODMEN", "DESCRICAO"], "where": null}', 'CODMEN', 'DESCRICAO');
        $('#btnMotivo').pesquisa_serversideSel('#txtMotivo', `{ "tabela":"MENSAGEM", "camposSelect":[ "CODMEN", "DESCRICAO"], "where": null}`, 'Pesquisa de Motivo.');
        $('#btnLimpaMotivo').on('click', function () {$('#txtMotivo').empty().trigger('change');});

        $('#txtCategoria').pesquisa_variosServerside(1, '{ "tabela":"AUXILIAR", "camposSelect":[ "ID", "DESCRICAO"], "where": null}', 'ID', 'DESCRICAO');
        $('#btnCategoria').pesquisa_serversideSel('#txtCategoria', `{ "tabela":"AUXILIAR", "camposSelect":[ "ID", "DESCRICAO"], "where": null}`, 'Pesquisa de Categoria.');
        $('#btnLimpaCategoria').on('click', function () {$('#txtCategoria').empty().trigger('change');});

        $('#txtEtiqueta').pesquisa_variosServerside(1, '{ "tabela":"ETQ_PROD", "camposSelect":[ "CODIGO", "DESCRICAO"], "where": null}', 'CODIGO', 'DESCRICAO');
        $('#btnEtiqueta').pesquisa_serversideSel('#txtEtiqueta', `{ "tabela":"ETQ_PROD", "camposSelect":[ "CODIGO", "DESCRICAO"], "where": null}`, 'Pesquisa de Etiqueta.');
        $('#btnLimpaEtiqueta').on('click', function () {$('#txtEtiqueta').empty().trigger('change');});
    };

    ///tem pouco filtro graças a Deus
    function limpaFiltros() {
        $('#txtCodigo').empty().trigger('change');
        $('#txtDeposito').empty().trigger('change');
        $('#txtCliente').empty().trigger('change');
        $('#txtGrupoMat').empty().trigger('change');
        $('#txtSubgrupoMat').empty().trigger('change');
        $('#txtRepresentante').empty().trigger('change');
        $('#txtGrupoCli').empty().trigger('change');
        $('#txtGrupo').empty().trigger('change');
        $('#txtComposicao').empty().trigger('change');
        $('#txtNCM').empty().trigger('change');
        $('#txtCoord').empty().trigger('change');
        $('#txtMoeda').empty().trigger('change');
        $('#txtLinhaMat').empty().trigger('change');
        $('#txtLinha').empty().trigger('change');
        $('#txtNF').empty().trigger('change');
        $('#txtColecaoProd').empty().trigger('change');
        $('#txtColecaoPed').empty().trigger('change');
        $('#txtTipoVenda').empty().trigger('change');
        $('#txtEstilista').empty().trigger('change');
        $('#txtMarca').empty().trigger('change');
        $('#txtPedido').empty().trigger('change');
        $('#txtEstado').empty().trigger('change');
        $('#txtNatureza').empty().trigger('change');
        $('#txtPrazoEnt').empty().trigger('change');
        $('#txtMotivo').empty().trigger('change');
        $('#txtCategoria').empty().trigger('change');
        $('#txtEtiqueta').empty().trigger('change');

        $('#txtDataEmissaoNFI').val('1200-01-01');
        $('#txtDataEmissaoNFF').val('2500-12-01');
        $('#cbVendaCompra').prop('checked', false);
        $('#cbDevolucao').prop('checked', false);
        $('#cbRemessa').prop('checked', false);
        $('#cbRetorno').prop('checked', false);
        $('#cbConsignacao').prop('checked', false);
        $('#cbAntecipacao').prop('checked', false);
        $('#cbServicos').prop('checked', false);
        $('#cbEnergiaTelefone').prop('checked', false);
        $('#cbBonificacao').prop('checked', false);
        $('#cbPatrimonio').prop('checked', false);
        $('#cbEstornoImposto').prop('checked', false);
        $('#cbMostraOuNaoNFEDevolucao').prop('checked', false);
        $('#cbConsideraFatorConversao').prop('checked', false);
        $('#cbConsideraNatureza').prop('checked', true);
        $('#cbTodosInss').prop('checked', true);
        $('#cbComInss').prop('checked', false);
        $('#cbUtilizaPartedoLote').prop('checked', false);
        $('#cbSemInss').prop('checked', false);
        $('#cbCliente').prop('checked', false);
        $('#cbFornecedor').prop('checked', false);
        $('#cbTerceiros').prop('checked', false);
        $('#cbNormais').prop('checked', true);
        $('#cbTodosFiltros').prop('checked', true);
        $('#cbTodasDups').prop('checked', true);
        $('#selectTipoEntidade').val('considerartipoEntidade');
    };








































})













































