$(document).ready(async function () {

  let abaAtiva = 'Resumida';
  let colunas = JSON.parse(localStorage.getItem('colunasInvisiveisRelatorios'));

  // aqui so valida se nao existe tem que criar para nao dar erro
  if (colunas == null || colunas.relMetaVendasRes == undefined) {
    localStorage.setItem('colunasInvisiveisRelatorios', JSON.stringify({ ...colunas, relMetaVendasRes: [] }));
    colunas = JSON.parse(localStorage.getItem('colunasInvisiveisRelatorios'));
  }

  if (colunas == null || colunas.relMetaVendasCom == undefined) {
    localStorage.setItem('colunasInvisiveisRelatorios', JSON.stringify({ ...colunas, relMetaVendasCom: [] }));
    colunas = JSON.parse(localStorage.getItem('colunasInvisiveisRelatorios'));
  }

  // confirma as colunas
  $('#btnConfirmarColunas').on('click', async function () {
    try {
      $.LoadingOverlay('show');

      const novasColunas = retornaNovasColunasInvisiveis();
      let cols = JSON.parse(localStorage.getItem('colunasInvisiveisRelatorios'));

      if (abaAtiva == 'Resumida') {
        localStorage.setItem('colunasInvisiveisRelatorios', JSON.stringify({ ...cols, relMetaVendasRes: novasColunas }))
        $('#tabelaResumida').DataTable().columns().visible(true);

        $('#tabelaResumida').DataTable().columns().every(
          function () {
            if ((novasColunas).indexOf(this.dataSrc()) != -1) {
              this.visible(false);
            }
          })
      } else {
        localStorage.setItem('colunasInvisiveisRelatorios', JSON.stringify({ ...cols, relMetaVendasCom: novasColunas }))
        $('#tabelaCompleta').DataTable().columns().visible(true);

        $('#tabelaCompleta').DataTable().columns().every(
          function () {
            if ((novasColunas).indexOf(this.dataSrc()) != -1) {
              this.visible(false);
            }
          })
      }

    } finally {
      $.LoadingOverlay('hide');
      $('#modal-ColunasVisiveis').modal('hide');
    }
  })

  $("#divCompleta").addClass('d-none')

  $('#tabCompleta').on('click', async function () {
    $('#divCompleta').removeClass('d-none')
    $('#divResumida').addClass('d-none')
  })

  $('#tabResumida').on('click', async function () {
    $('#divCompleta').addClass('d-none')
    $('#divResumida').removeClass('d-none')
  })

  $('#tabResumida').on('click', function () {
    abaAtiva = 'Resumida';
  })

  $('#tabCompleta').on('click', function () {
    abaAtiva = 'Completa';
  })

  // autocompleta
  $("#txtMeta").autocompleta(
    1,
    `JSON={ "tabela":"METAVENDA", "camposSelect":[ "ID chave", "DESCRICAO descricao"], "where": null}`
  );

  //pesquisa varios
  $("#btn-meta").pesquisa(
    "#txtMeta",
    "ID",
    "DESCRICAO",
    `/sisplan/funcoes/v1/pesquisa?JSON={ "tabela":"METAVENDA", "camposSelect":[ "ID", "DESCRICAO"] }`,
    "Pesquisa Meta",
    "METAVENDA"
  );

  // limpa campos
  $("#btn-limpa-meta").on("click", function () {
    $("#txtMeta").val("");
  });

  // modais
  $("#btnFiltros").on("click", async function () {
    $("#modal-filtros").modal("show");
  });
  $("#btnOpcoesFiltros").on("click", async function () {
    $("#modal-opcoesFiltros").modal("show");
  });

  preencheOrdenacaoTela('RelMetaVendas');

  limparFiltros();
  retornaHintRelatorio('btnImprimir', 'RelMetaVendedor');

  $("#btnImprimir").on("click", async function () {
    try {
      $.LoadingOverlay("show");
      try {
        const ordemOrdenacao = $('#txtOrdem').val();
        const url = `/sisplan/impressao/v1/imprimirrelmetavendas?ordem_ordenacao=${ordemOrdenacao}&`;
        const Filtros = await preencheFiltros();
        const bImprimeAutomatico = await verificaImprimirAutomatico('RelMetaVendas');
        const arquivo = await GeraRelatorio(`${url}${Filtros}`, "GET", 100000, false, 'RelMetaVendas');

        if (arquivo != undefined) {
          if (!bImprimeAutomatico) {
            window.open(`${BASE_URI}/relatorios_api/pdf/${arquivo}`, "_blank");
          }
          await limparRelatorios();
        }
      } catch (error) {
        console.error(error);
      }
    } finally {
      $.LoadingOverlay("hide");
    }
  });

  async function preencheFiltros() {
    try {
      const Meta = pegaChave("#txtMeta");
      const DataIni = $("#dtInicio").val();
      const DataFim = $("#dtAte").val();
      const retorno =
        `META=${Meta}` +
        `&DATAINI=${DataIni}` +
        `&DATAFIM=${DataFim}`;

      return retorno;

    } catch (error) {
      console.error(error);
      $.LoadingOverlay("hide");
    }
  }

  $('#btnConsultar').on('click', async function () {
    if ($('#txtMeta').val() == '') {
      msgAlerta('Nenhuma meta selecionada, verifique!');
      return;
    }
    if ($("#txtOrdem option").toArray().lenght > 0) {
      retornaHintRelatorio('btnImprimir', $("#txtOrdem option").toArray().map(map => { return [map.selected, $(map).attr('nome_prt')] }).filter(filter => filter[0] == true)[0][1])
    }
    if ($.fn.DataTable.isDataTable('#tabelaResumida') && $.fn.DataTable.isDataTable('#tabelaCompleta')) {
      $('#tabelaResumida').DataTable().destroy();
      $('#tabelaResumida').empty();
      $('#tabelaCompleta').DataTable().destroy();
      $('#tabelaCompleta').empty();
    };

    $.LoadingOverlay('show');
    try {
      const resumida = await consultaMetaResumida()
      if (!resumida) {
        return;
      }
      await consultaMetaCompleta();

    } catch (error) {
      console.log(error)

    } finally {
      $.LoadingOverlay('hide');
      $('#modal-filtros').modal('hide');
      $('#tabCompleta').trigger('click');
      $('#tabResumida').trigger('click');

    }
  });

  async function consultaMetaResumida() {
    try {
      $.LoadingOverlay("show");
      try {

        let dataSetCols = [];
        const ordemOrdenacao = $('#txtOrdem').val();
        const url = `/sisplan/impressao/v1/consultarelmetavendas?ordem_ordenacao=${ordemOrdenacao}&`;
        const Filtros = await preencheFiltros();
        const response = await requisicao("GET", url, Filtros, '', 30000);


        if (!response) {
          return;
        }

        const jsonStr = await response.json();

        if (jsonStr.length == 0) {
          msgAlerta("Nenhum registro encontrado!");
          $("#txtMeta").val('');

          return;
        }

        if (response.status != 200) {
          console.error(jsonStr.mensagem);
          return;
        }

        let keys = Object.keys(jsonStr[0]);

        keys.forEach((k) => {
          dataSetCols.push({
            title: k,
            data: k,
          });
        });

        $("#tabelaResumida").DataTable({
          destroy: true,
          filter: false,
          info: false,
          colReorder: true,
          language: {
            sEmptyTable: "Nenhum registro encontrado",
            sInfo: "_TOTAL_ registros",
            sInfoEmpty: " 0 registros",
            sInfoFiltered: "(Filtrados de _MAX_ registros)",
            sInfoPostFix: "",
            sInfoThousands: ".",
            sLengthMenu: "_MENU_ resultados",
            sLoadingRecords: "Carregando...",
            sProcessing: "Processando...",
            sZeroRecords: "Nenhum registro encontrado",
            sSearch: "Pesquisar",
            oPaginate: {
              sNext: "Próximo",
              sPrevious: "Anterior",
              sFirst: "Primeiro",
              sLast: "Último",
            },
            oAria: {
              sSortAscending: ": Ordenar colunas de forma ascendente",
              sSortDescending: ": Ordenar colunas de forma descendente",
            },
          },
          autoWidth: true,
          data: jsonStr,
          columns: dataSetCols,
          "columnDefs": [
            {
              "render": function (data) {
                return parseFloat(data).toLocaleString('pt-br', {
                  style: 'currency',
                  currency: 'BRL'
                });
              },
              "targets": 3,
              "className": 'pr-4 text-right'
            },
            {
              "render": function (data) {
                return parseFloat(data).toLocaleString('pt-br', {
                  style: 'currency',
                  currency: 'BRL'
                });
              },
              "targets": 4,
              "className": 'pr-4 text-right'
            },
            {
              "targets": [5, 6],
              "className": 'pr-4 text-right'
            }
          ],
        });

        const colunasInvisiveis = JSON.parse(localStorage.getItem('colunasInvisiveisRelatorios'));

        $('#tabelaResumida_length').prepend('<button class="buttonColVis" id="buttonColVis"><i class="fas fa-cogs"></i></button>');
        $('#tabelaResumida_length').prepend('<button class="buttonExcel" id="buttonExcel"><i class="fas fa-file-excel"></i></button>');

        $('#buttonColVis').prop('title', 'Configurar colunas visíveis')
        $('#buttonExcel').prop('title', 'Exportar')

        $('#buttonColVis').on('click', async function () {
          $.LoadingOverlay('show');
          $('#modal-ColunasVisiveis').modal('show');
          $.LoadingOverlay('hide');
        });

        $('#buttonExcel').on('click', async function () {
          const ordemOrdenacao = $('#txtOrdem').val();
          const url = `/sisplan/impressao/v1/consultarelmetavendas?ordem_ordenacao=${ordemOrdenacao}&`;
          const filtros = await preencheFiltros();
          await exportaCSV(url, filtros, false, null, 'Relatório de Meta de Vendas - Resumida', '#tabelaResumida');
        })

        $('#tabelaResumida').DataTable().columns().every(
          function () {
            if ((colunasInvisiveis.relMetaVendasRes).indexOf(this.dataSrc()) != -1) {
              this.visible(false);
            }
          })

        $.LoadingOverlay("hide");

      } catch (error) {
        console.error(error);
        return false;
      }
      return true
    } finally {
      $.LoadingOverlay("hide");
      $("#modal-filtros").modal("hide");
    }

  }

  $('#modal-ColunasVisiveis').on('show.bs.modal', function () {
    const cols = [];

    let colunasInvisiveis = JSON.parse(localStorage.getItem('colunasInvisiveisRelatorios'))

    if (abaAtiva == 'Resumida') {

      $('#tabelaResumida').DataTable().columns().every(function () {
        cols.push({
          'title': $(this.header()).text(),
          'data': this.dataSrc()
        })
      });

      adicionaColunas(cols, colunasInvisiveis.relMetaVendasRes ?? [])
    } else {
      $('#tabelaCompleta').DataTable().columns().every(function () {
        cols.push({
          'title': $(this.header()).text(),
          'data': this.dataSrc()
        })
      });

      adicionaColunas(cols, colunasInvisiveis.relMetaVendasCom ?? [])
    }
  })

  async function consultaMetaCompleta() {
    try {
      $.LoadingOverlay("show");
      try {

        let dataSetCols = [];
        const url = `/sisplan/impressao/v1/consultarelmetavendascompleta?`;
        const Filtros = await preencheFiltros();
        const response = await requisicao("GET", url, Filtros, '', 30000);


        if (!response) {
          return;
        }

        const jsonStr = await response.json();

        if (jsonStr.length == 0) {
          msgAlerta("Nenhum registro encontrado!");
          $("#txtMeta").val('');

          return;
        }

        if (response.status != 200) {
          console.error(jsonStr.mensagem);
          return;
        }

        let keys = Object.keys(jsonStr[0]);

        keys.forEach((k) => {
          dataSetCols.push({
            title: k,
            data: k,
          });
        });

        let indiceValor;
        let indiceTotal;
        let indiceValorDesc;
        let indiceQtde;

        for (let i = 0; i < keys.length; i++) {
          if (keys[i] == 'VALOR') {
            indiceValor = i;
          } else if (keys[i] == 'TOTAL') {
            indiceTotal = i;
          } else if (keys[i] == 'VALOR_DESC') {
            indiceValorDesc = i;
          } else if (keys[i] == 'QUANTIDADE') {
            indiceQtde = i;
          }
        }

        $("#tabelaCompleta").DataTable({
          destroy: true,
          filter: false,
          info: false,
          order: false,
          colReorder: true,
          language: {
            sEmptyTable: "Nenhum registro encontrado",
            sInfo: "_TOTAL_ registros",
            sInfoEmpty: " 0 registros",
            sInfoFiltered: "(Filtrados de _MAX_ registros)",
            sInfoPostFix: "",
            sInfoThousands: ".",
            sLengthMenu: "_MENU_ resultados",
            sLoadingRecords: "Carregando...",
            sProcessing: "Processando...",
            sZeroRecords: "Nenhum registro encontrado",
            sSearch: "Pesquisar",
            oPaginate: {
              sNext: "Próximo",
              sPrevious: "Anterior",
              sFirst: "Primeiro",
              sLast: "Último",
            },
            oAria: {
              sSortAscending: ": Ordenar colunas de forma ascendente",
              sSortDescending: ": Ordenar colunas de forma descendente",
            },
          },
          autoWidth: true,
          data: jsonStr,
          columns: dataSetCols,
          "columnDefs": [
          {
            "render": function (data) {
              return parseFloat(data).toLocaleString('pt-br', {
                style: 'currency',
                currency: 'BRL'
              });
            },
            "targets": [+indiceValor, +indiceTotal, +indiceValorDesc],
            "className": 'pr-4 text-right'
          },
          {
            "targets": [+indiceQtde],
            "className": 'pr-4 text-right'
          }
          ],
        });

        const colunasInvisiveis = JSON.parse(localStorage.getItem('colunasInvisiveisRelatorios'));

        $('#tabelaCompleta_length').prepend('<button class="buttonColVis" id="buttonColVis2"><i class="fas fa-cogs"></i></button>');
        $('#tabelaCompleta_length').prepend('<button class="buttonExcel" id="buttonExcel2"><i class="fas fa-file-excel"></i></button>');

        $('#buttonColVis2').prop('title', 'Configurar colunas visíveis')
        $('#buttonExcel2').prop('title', 'Exportar')

        $('#buttonColVis2').on('click', async function () {
          $.LoadingOverlay('show');
          $('#modal-ColunasVisiveis').modal('show');
          $.LoadingOverlay('hide');
        });

        $('#buttonExcel2').on('click', async function () {
          const url = `/sisplan/impressao/v1/consultarelmetavendascompleta?`;
          const filtros = await preencheFiltros();
          await exportaCSV(url, filtros, false, null, 'Relatório de Meta de Vendas - Completa', '#tabelaCompleta');
        })

        $('#tabelaCompleta').DataTable().columns().every(
          function () {
            if ((colunasInvisiveis.relMetaVendasCom).indexOf(this.dataSrc()) != -1) {
              this.visible(false);
            }
          })

        $.LoadingOverlay("hide");

      } catch (error) {
        console.error(error);
      }
    } finally {
      $.LoadingOverlay("hide");
      $("#modal-filtros").modal("hide");
    }

  }

});