$('#tutorial').on('click', function () {
  $(document).ready(async function () {
    const driver = new Driver({
      doneBtnText: 'Sair',
      closeBtnText: 'Fechar',
      nextBtnText: 'Próximo',
      prevBtnText: 'Anterior',
      allowClose: false
    });
    driver.defineSteps([{
      element: '#btnFiltros',
      popover: {
        title: 'Botão Filtros',
        description: 'Clique aqui para abrir os filtros padrões da tela.',
        position: 'right'
      }
    },
    {
      element: '#btnImprimir',
      popover: {
        title: 'Botão Imprimir',
        description: 'Clique aqui para Imprimir um relatório.',
        position: 'right'
      }
    },
    {
      element: '#tabelaDRE',
      popover: {
        title: 'Tabela',
        description: 'Aqui estão os dados dos produtos Filtrados.',
        position: 'top'
      }
    }
    ]);
    driver.start();
  });
});

$(document).ready(async function () {
  adicionarConteudoModal(
    'Relatório de DRE', [
    {
      tipo: 'paragrafo',
      valor: 'Para assegurar o funcionamento adequado do relatório de Demonstração do Resultado do Exercício (DRE), ' +
        'é fundamental que haja uma classe analítica vinculada a uma classe título. Esta vinculação é essencial ' +
        'para garantir a precisão e a integridade das informações apresentadas no relatório.'
    },
  ]
  );

  let colunas = JSON.parse(localStorage.getItem('colunasInvisiveisRelatorios'));

  if (colunas == null || colunas.relDre == undefined) {
    localStorage.setItem('colunasInvisiveisRelatorios', JSON.stringify({ ...colunas, relDre: ['EMPRESA'] }))
    colunas = JSON.parse(localStorage.getItem('colunasInvisiveisRelatorios'))
  }

  $('#btnConfirmarColunas').on('click', async function () {
    try {
      $.LoadingOverlay('show');

      const novasColunas = retornaNovasColunasInvisiveis();
      localStorage.setItem('colunasInvisiveisRelatorios', JSON.stringify({ ...colunas, relDre: novasColunas }))

      $('#tabelaDRE').DataTable().columns().visible(true);

      $('#tabelaDRE').DataTable().columns().every(
        function () {
          if ((novasColunas).indexOf(this.dataSrc()) != -1) {
            this.visible(false);
          }
        })

    } finally {
      $.LoadingOverlay('hide');
      $('#modal-ColunasVisiveis').modal('hide');
    }
  })

  $('#btnFiltros').on('click', async function () {
    $('#modal-filtros').modal('show');
  });

  componenteFiltro("classeTitulo", true);
  componenteFiltro("centroCusto", true);
  componenteFiltro("historico", true);
  componenteFiltro("situacao", true);
  componenteFiltro("moeda", true);
  componenteFiltro("banco", true);
  componenteFiltro("conta", true);

  limparFiltros(true);

  await preencheOrdenacaoTela('RelDre');

  $('#btnImprimir').on('click', async function () {
    try {
      $.LoadingOverlay('show');
      try {
        const url = `/sisplan/impressao/v1/imprimirreldre?`;
        const filtros = await retornaFiltros();
        const ordem = `&TELA_ORDENACAO=RelDre&ORDEM_ORDENACAO=${$('#txtOrdem').val()}`;
        const bImprimeAutomatico = await verificaImprimirAutomatico('RelDre');
        const arquivo = await GeraRelatorio(`${url}${filtros}${ordem}&`, 'POST', 100000, false, 'RelDre');
        if (arquivo != undefined) {
          if (!bImprimeAutomatico) {
            window.open(`${BASE_URI}/relatorios_api/pdf/${arquivo}`, '_blank');
          }
          await limparRelatorios();
        }

      } catch (error) {
        console.error(error);
      }
    } finally {
      $.LoadingOverlay('hide');
    }
  });

  async function retornaFiltros() {
    const dataIni = $('#txtDataInicio').val();
    const dataFim = $('#txtDataFim').val();
    const classe = await formataListas($('#txtClasseTitulo').val().toString());
    const centroCusto = await formataListas($('#txtCentroCusto').val().toString());
    const historico = await formataListas($('#txtHistorico').val().toString());
    const situacao = await formataListas($('#txtSituacao').val().toString());
    const moeda = await formataListas($('#txtMoeda').val().toString());
    const banco = await formataListas($('#txtBanco').val().toString());
    const conta = await formataListas($('#txtConta').val().toString());
    const empresas = $('.empresa_selecionada:checked').toArray().length > 0 ? $('.empresa_selecionada:checked').toArray().map(input => input.id.substring(input.id.indexOf('-') + 1, input.id.length))
      : [getCookie('emp_id')]

    return `DATA_INI=${dataIni}` +
      `&DATA_FIM=${dataFim}` +
      `&CLASSES=${classe}` +
      `&CENTROCUSTO=${centroCusto}` +
      `&HISTORICO=${historico}` +
      `&SITUACAO=${situacao}` +
      `&MOEDA=${moeda}` +
      `&BANCO=${banco}` +
      `&CONTA=${conta}` +
      `&EMPRESAS=${empresas}`;
  };

  $('#btnConsultar').on('click', async function () {
    try {
      $.LoadingOverlay('show');
      try {
        const filtros = await retornaFiltros();

        const response = await requisicao('GET', '/sisplan/impressao/v1/imprimirreldre?', filtros, null, 150000);

        if (!response) {
          return;
        }

        const jsonStr = await response.json();

        if (response.status != 200) {
          console.error(jsonStr.mensagem);
          return;
        }
        const colunas = retornaColunas()
        $('#tabelaDRE').DataTable({
          sort: true,
          destroy: true,
          order: [
            [1, 'asc'],
            [6, 'desc']
          ],
          language: {
            sEmptyTable: 'Nenhum registro encontrado',
            sInfo: '_TOTAL_ registros',
            sInfoEmpty: ' 0 registros',
            sInfoFiltered: '(Filtrados de _MAX_ registros)',
            sInfoPostFix: '',
            sInfoThousands: '.',
            sLengthMenu: '_MENU_ resultados',
            sLoadingRecords: 'Carregando...',
            sProcessing: 'Processando...',
            sZeroRecords: 'Nenhum registro encontrado',
            sSearch: 'Pesquisar',
            oPaginate: {
              sNext: 'Próximo',
              sPrevious: 'Anterior',
              sFirst: 'Primeiro',
              sLast: 'Último',
            },
            oAria: {
              sSortAscending: ': Ordenar colunas de forma ascendente',
              sSortDescending: ': Ordenar colunas de forma descendente',
            },
          },
          autoWidth: true,
          "colReorder": true,
          "data": jsonStr,
          "columns": colunas.dataSetCols,
          rowCallback: async function (row, data) {
            $(row).find('td').each(function (index, cell) {
              const coluna = colunas.dataSetCols[index];
              const valorColuna = data[coluna.data];
              if (coluna.data == 'OPERACAO') {
                $(cell).css('font-weight', 'bold');
                if (valorColuna == '+') {
                  $(cell).css('color', '#75BE25');
                } else {
                  $(cell).css('color', 'red');
                }
              }
            });
          },
        });

        const colunasInvisiveis = JSON.parse(localStorage.getItem('colunasInvisiveisRelatorios'));

        $('#tabelaDRE_length').prepend('<button class="buttonColVis" id="buttonColVis"><i class="fas fa-cogs"></i></button>');
        $('#tabelaDRE_length').prepend('<button class="buttonExcel" id="buttonExcel"><i class="fas fa-file-excel"></i></button>');

        $('#buttonColVis').prop('title', 'Configurar colunas visíveis')
        $('#buttonExcel').prop('title', 'Exportar')

        $('#buttonColVis').on('click', async function () {
          $.LoadingOverlay('show');
          $('#modal-ColunasVisiveis').modal('show');
          $.LoadingOverlay('hide');
        });

        $('#buttonExcel').on('click', async function () {
          const url = '/sisplan/impressao/v1/imprimirreldre?';
          const filtros = await retornaFiltros();
          await exportaCSV(url, filtros, false, null, 'Relatório de DRE', '#tabelaDRE');
        })

        $('#tabelaDRE').DataTable().columns().every(
          function () {
            if ((colunasInvisiveis.relDre).indexOf(this.dataSrc()) != -1) {
              this.visible(false);
            }
          })

      } catch (error) {
        console.error(error);
      }
    } finally {
      $.LoadingOverlay('hide');
      $('#modal-filtros').modal('hide');
    }
  });

  $('#modal-ColunasVisiveis').on('show.bs.modal', function () {
    const cols = [];

    let colunasInvisiveis = JSON.parse(localStorage.getItem('colunasInvisiveisRelatorios'))

    $('#tabelaDRE').DataTable().columns().every(function () {
      cols.push({
        'title': $(this.header()).text(),
        'data': this.dataSrc()
      })
    });

    adicionaColunas(cols, colunasInvisiveis.relDre ?? ['EMPRESA'])
  })

  $('#btnSelecionarEmpresas').on('click', function () {
    carregaEmpresasDisponiveis();
  });

  function retornaColunas() {
    const columns = [{
      title: 'Origem',
      data: 'ORIGEM',
    },
    {
      title: 'EmpId',
      data: 'EMP_ID',
    },
    {
      title: 'Fantasia',
      data: 'EMP_FANTASIA',
    },
    {
      title: 'Classe T',
      data: 'CLASSE_T',
    },
    {
      title: 'Desc. Classe T',
      data: 'DESC_CLASSE_T',
    },
    {
      title: 'Classe A',
      data: 'CLASSE_A',
    },
    {
      title: 'Desc. Classe A',
      data: 'DESC_CLASSE_A',
    },
    {
      title: 'Centro de Custo',
      data: 'CCUSTO',
    },
    {
      title: 'Desc. Centro de Custo',
      data: 'DESC_CCUSTO',
    },
    {
      title: 'Operacao',
      data: 'OPERACAO',
    },
    {
      title: 'Valor Rateio',
      data: 'VALOR_RATEIO',
    },
    {
      title: 'Valor Pago',
      data: 'VALOR_PAGO',
    },
    {
      title: 'Valor Recebido',
      data: 'VALOR_RECEBIDO',
    }
    ,
    {
      title: 'Histórico',
      data: 'HISTORICO',
    }
    ,
    {
      title: 'Desc. Histórico',
      data: 'DESC_HISTORICO',
    },
    {
      title: 'Moeda',
      data: 'MOEDA',
    }
    ,
    {
      title: 'Desc. Moeda',
      data: 'DESC_MOEDA',
    },
    {
      title: 'Situação',
      data: 'SITUACAO',
    }
    ,
    {
      title: 'Desc. Situação',
      data: 'DESC_SITUACAO',
    },
    {
      title: 'Banco',
      data: 'BANCO',
    }
    ,
    {
      title: 'Desc. Banco',
      data: 'DESC_BANCO',
    }
    ,
    {
      title: 'Conta',
      data: 'CONTA',
    }
    ,
    {
      title: 'Desc. Conta',
      data: 'DESC_CONTA',
    }];

    const dataSetCols = [];

    columns.forEach((column) => {
      dataSetCols.push({
        title: column.title,
        data: column.data,
      });
    });

    return { dataSetCols }
  }

  const cores = [
    '#F87171', // red-400
    '#F45D9E', // rose-400
    '#E57373', // pink-400
    '#F99157', // orange-400
    '#F27116', // amber-400
    '#F3B71C', // yellow-400
    '#D9F0A3', // lime-400
    '#70A664', // green-400
    '#64C2A6', // teal-400
    '#5793F3', // blue-400
    '#6366F1', // indigo-400
    '#9370DB', // violet-400
    '#BDBDBD', // gray-400
    '#F9FAFB', // white-400
    '#ffffff', // white
    '#ff0000', // red
    '#00ff00', // green
    '#0000ff', // blue
    '#ffff00', // yellow
    '#ff00ff', // magenta
    '#00ffff', // cyan
    '#808080', // gray
    '#a9a9a9', // darkgray
    '#dcdcdc', // lightgrey
    '#696969', // dimgray
    '#708090', // slategray
    '#2f4f4f', // darkslategray
    '#0000ff', // blue
    '#008080', // teal
    '#006400', // darkgreen
    '#008b00', // green
    '#00ff00', // lime
    '#808000', // olive
    '#8b4513', // saddlebrown
    '#a0522d', // sienna
    '#a52a2a', // brown
    '#c04000', // maroon
    '#dc143c', // crimson
    '#ff0000', // red
    '#ff4500', // orange
    '#ff6347', // tomato
    '#ff7f50', // coral
    '#ffa500', // orange
    '#ffebcd', // lightyellow
    '#fff000', // gold
    '#ffdab9', // peachpuff
    '#f0e68c', // khaki
    '#f5f5dc', // beige
    '#f4a460', // sandybrown
    '#fa8072', // salmon
    '#e9967a', // darksalmon
    '#ff6347', // tomato
    '#ff7f50', // coral
    '#ff8c00', // darkorange
    '#ffa500', // orange
    '#ffebcd', // lightyellow
    '#fff000', // gold
    '#ffdead', // navajowhite
    '#f0e68c',
    '#f0e68c', // khaki
    '#f5f5dc', // beige
    '#f4a460', // sandybrown
    '#f08080', // coral
    '#e9967a', // darksalmon
    '#c71585', // mediumvioletred
    '#dd0030', // violet
    '#ff0033', // hotpink
    '#ff1493', // deeppink
    '#ff69b4', // pink
    '#c2c2f0', // lightblue
    '#a0a0ff', // lightblue
    '#add8e6', // lightcyan
    '#87ceeb', // skyblue
    '#4169e1', // royalblue
    '#00bfff', // deepskyblue
    '#1e90ff', // dodgerblue
    '#4682b4', // steelblue
    '#8080ff', // blue
    '#63b8ff', // lightseagreen
    '#47ffb4', // aquamarine
    '#00ced1', // darkturquoise
    '#00ffff', // cyan
    '#2e8b57', // seagreen
    '#228b22', // forestgreen
    '#006b00', // darkgreen
    '#00ff00', // lime
    '#32cd32', // limegreen
    '#7fff00', // chartreuse
    '#76ee00', // lightgreen
    '#90ee90', // lightgreen
    '#adff2f', // palegreen
    '#8fbc8f', // seagreen
  ];
});