$('#tutorial').on('click', function () {
    $(document).ready(async function () {
        const driver = new Driver({
            doneBtnText: 'Sair',
            closeBtnText: 'Fechar',
            nextBtnText: 'Próximo',
            prevBtnText: 'Anterior',
            allowClose: false
        });
        driver.defineSteps([{
            element: '#btn-filtros',
            popover: {
                title: 'Botão Filtros',
                description: 'Clique aqui para abrir os campos disponíveis de filtro.',
                position: 'right'
            }
        },
        {
            element: '#btnImpTodas',
            popover: {
                title: 'Botão Importar Todas',
                description: 'Aqui você ira importar todas as duplicatas filtradas.',
                position: 'right'
            }
        },
        {
            element: '#btnImpDup',
            popover: {
                title: 'Botão Importar Duplicata',
                description: 'Aqui você ira importar somente as duplicatas selecionadas.',
                position: 'right'
            }
        },
        {
            element: '#tabelaRegistros_wrapper',
            popover: {
                title: 'Lista de duplicatas',
                description: 'Aqui você verá as duplicatas filtradas',
                position: 'top'
            }
        },
        ]);
        //inicio tour

        driver.start();

        // inicior tuor
        //final
    });
});
$(document).ready(async function () {
    const permissaoUsuarioLogado = await permissaoAcessos("RELBLOQUETO");

    let listaRegistros = [];

    //autocomplete
    $('#txtCliente').pesquisa_variosServerside(1, '{ "tabela":"ENTIDADE", "camposSelect":[ "CODCLI", "NOME" ], "where": null}', 'CODCLI', 'NOME');
    $('#txtSitDupl').pesquisa_variosServerside(1, '{ "tabela":"TABSIT", "camposSelect":[ "CODIGO", "DESCRICAO" ], "where": null}', 'CODIGO', 'DESCRICAO');
    $('#txtRepresentante').pesquisa_variosServerside(1, '{ "tabela":"REPRESEN", "camposSelect":[ "CODREP", "NOME" ], "where": null}', 'CODREP', 'NOME');
    $('#txtGrupoCli').pesquisa_variosServerside(1, '{ "tabela":"GRUPO_CLI", "camposSelect":[ "CODIGO", "DESCRICAO" ], "where": null}', 'CODIGO', 'DESCRICAO');
    $('#txtDuplicata').pesquisa_variosServerside(1, '{ "tabela":"RECEBER", "camposSelect":[ "NUMERO", "VALOR" ], "where": null}', 'NUMERO', 'VALOR');
    $('#txtBanco').autocompleta(1, 'JSON={ "tabela":"CADBAN", "camposSelect":[ "BANCO CHAVE", "NOME_BANCO DESCRICAO" ], "where": null}');
    $('#txtConta').autocompleta(1, 'JSON={ "tabela":"CADCONTA", "camposSelect":[ "CONTA CHAVE", "DESCRICAO DESCRICAO" ], "where": null}');
    $('#txtClasseGer').autocompleta(1, 'JSON={ "tabela":"CLASSE_GER", "camposSelect":[ "CODIGO CHAVE", "DESCRICAO DESCRICAO" ], "where": null}');
    $('#txtEndosso').autocompleta(1, 'JSON={ "tabela":"ENTIDADE", "camposSelect":[ "CODCLI CHAVE", "NOME DESCRICAO" ], "where": null}');
    $('#txtHistorico').autocompleta(1, 'JSON={ "tabela":"HISTCP", "camposSelect":[ "HISTORICO CHAVE", "DESCRICAO DESCRICAO" ], "where": null}');
    $('#txtTransportadora').autocompleta(1, 'JSON={ "tabela":"TABTRAN", "camposSelect":[ "CODIGO CHAVE", "NOME DESCRICAO" ], "where": null}');


    //btnconsultar
    $('#btn-ClienteConsulta').pesquisa_serversideSel('#txtCliente', `{ "tabela":"ENTIDADE", "camposSelect":[ "CODCLI", "NOME"], "where": null}`, 'Pesquisa de Cliente');
    $('#btn-SitDuplConsulta').pesquisa_serversideSel('#txtSitDupl', `{ "tabela":"TABSIT", "camposSelect":[ "CODIGO", "DESCRICAO" ], "where": null}`, 'Pesquisa de Situação de Duplicata');
    $('#btn-RepresentanteConsulta').pesquisa_serversideSel('#txtRepresentante', `{ "tabela":"REPRESEN", "camposSelect":[ "CODREP", "NOME" ], "where": null}`, 'Pesquisa de Representante');
    $('#btn-GrupoCliConsulta').pesquisa_serversideSel('#txtGrupoCli', `{ "tabela":"GRUPO_CLI", "camposSelect":[ "CODIGO", "DESCRICAO" ], "where": null}`, 'Pesquisa de Gupo de Cliente');
    $('#btn-DuplicataConsulta').pesquisa_serversideSel('#txtDuplicata', `{ "tabela":"RECEBER", "camposSelect":[ "NUMERO", "VALOR" ], "where": null, "camposWhereServerSide":["NUMERO"]}`, 'Pesquisa de Duplicata');
    $('#btn-BancoConsulta').pesquisa_serverside(['#txtBanco'], ['BANCO'], ['NOME_BANCO'], `{ "tabela":"CADBAN", "camposSelect":[ "BANCO", "NOME_BANCO" ], "where": null}`, 'Pesquisa de Banco');
    $('#btn-ContaConsulta').pesquisa_serverside(['#txtConta'], ['CONTA'], ['DESCRICAO'], `{ "tabela":"CADCONTA", "camposSelect":[ "CONTA", "DESCRICAO" ], "where": null}`, 'Pesquisa de Conta');
    $('#btn-ClasseGerConsulta').pesquisa_serverside(['#txtClasseGer'], ['CODIGO'], ['DESCRICAO'], `{ "tabela":"CLASSE_GER", "camposSelect":[ "CODIGO", "DESCRICAO" ], "where": null}`, 'Pesquisa de Classe Gerencial');
    $('#btn-EndossoConsulta').pesquisa_serverside(['#txtEndosso'], ['CODCLI'], ['NOME'], `{ "tabela":"ENTIDADE", "camposSelect":[ "CODCLI", "NOME" ], "where": null}`, 'Pesquisa de Endosso');
    $('#btn-HistoricoConsulta').pesquisa_serverside(['#txtHistorico'], ['HISTORICO'], ['DESCRICAO'], `{ "tabela":"HISTCP", "camposSelect":[ "HISTORICO", "DESCRICAO" ], "where": null}`, 'Pesquisa de Histórico');
    $('#btn-TransportadoraConsulta').pesquisa_serverside(['#txtTransportadora'], ['CODIGO'], ['NOME'], `{ "tabela":"TABTRAN", "camposSelect":[ "CODIGO", "NOME" ], "where": null}`, 'Pesquisa de Histórico');

    //btnLimpar
    $('#btn-limpa-Cliente').on('click', function () { $('#txtCliente').empty().trigger('change') })
    $('#btn-limpa-SitDupl').on('click', function () { $('#txtSitDupl').empty().trigger('change') })
    $('#btn-limpa-Representante').on('click', function () { $('#txtRepresentante').empty().trigger('change') })
    $('#btn-limpa-GrupoCli').on('click', function () { $('#txtGrupoCli').empty().trigger('change') })
    $('#btn-limpa-Duplicata').on('click', function () { $('#txtDuplicata').empty().trigger('change') })
    $('#btn-limpa-Banco').on('click', function () { $('#txtBanco').val('') })
    $('#btn-limpa-Conta').on('click', function () { $('#txtConta').val('') })
    $('#btn-limpa-ClasseGer').on('click', function () { $('#txtClasseGer').val('') })
    $('#btn-limpa-Endosso').on('click', function () { $('#txtEndosso').val('') })
    $('#btn-limpa-Historico').on('click', function () { $('#txtHistorico').val('') })
    $('#btn-limpa-Transportadora').on('click', function () { $('#txtTransportadora').val('') })

    $('#btnLimparFiltros').click(async function () {
        $('#txtCliente').empty().trigger('change')
        $('#txtSitDupl').empty().trigger('change')
        $('#txtRepresentante').empty().trigger('change')
        $('#txtGrupoCli').empty().trigger('change')
        $('#txtDuplicata').empty().trigger('change')
        $('#txtBanco').val('')
        $('#txtConta').val('')
        $('#txtClasseGer').val('')
        $('#txtEndosso').val('')
        $('#txtHistorico').val('')
        $('#txtTransportadora').val('')
        $('#txtNotaDe').val('')
        $('#txtNotaAte').val('')
        $('#txtBordero').val('')
        $('#txtConta').val('')
        $('#txtVenda').val('')
        $('#txtCartaoPresente').val('')
        $('#dtVencimentoDe').val('1200-01-01')
        $('#dtEmissaoDe').val('1200-01-01')
        $('#dtVencimentoAte').val('2500-12-31')
        $('#dtEmissaoAte').val('2500-12-31')
        $('#rdTodos').prop('checked', true)
        $('#cbSemDataEmail').prop('checked', false)
        $('#cbSituacaoBoleto').prop('checked', false)
    });

    async function retornaFiltros() {
        const empresasFiltradas = $(".empresa_selecionada:checked").toArray().length > 0 ? $(".empresa_selecionada:checked").toArray().map((input) => input.id.substring(input.id.indexOf("-") + 1, input.id.length)) : [getCookie("emp_id")];
        const empresasFiltradasFormatada = await formataListas(empresasFiltradas.toString());
        const todasEmpresas = $("#cbTodasAsEmpresas").is(':checked') ? true : false;

        const filtros =
            `EMISSAODE=${$('#dtEmissaoDe').val()}` +
            `&EMISSAOATE=${$('#dtEmissaoAte').val()}` +
            `&VENCIMENTODE=${$('#dtVencimentooDe').val()}` +
            `&VENCIMENTOATE=${$('#dtVencimentooAte').val()}` +
            `&NOTADE=${$('#txtNotaDe').val()}` +
            `&NOTAATE=${$('#txtNotaAte').val()}` +
            `&BORDERO=${$('#txtBordero').val()}` +
            `&VENDA=${$('#txtVenda').val()}` +
            `&CARTAOPRESENTE=${$('#txtCartaoPresente').val()}` +
            `&BANCO=${pegaChave('#txtBanco')}` +
            `&CONTA=${pegaChave('#txtConta')}` +
            `&CLASSEGER=${pegaChave('#txtClasseGer')}` +
            `&ENDOSSO=${pegaChave('#txtEndosso')}` +
            `&HISTORICO=${pegaChave('#txtHistorico')}` +
            `&TRANSPORTADORA=${pegaChave('#txtTransportadora')}` +
            `&CLIENTE=${await formataListas($('#txtCliente').val().toString())}` +
            `&SITDUP=${await formataListas($('#txtSitDupl').val().toString())}` +
            `&REPRESENTANTE=${await formataListas($('#txtRepresentante').val().toString())}` +
            `&GRUPOCLI=${await formataListas($('#txtGrupoCli').val().toString())}` +
            `&DUPLICATA=${await formataListas($('#txtDuplicata').val().toString())}` +
            `&CONSIDERASIT=${$('#cbConsideraSitDupl').prop('checked')}` +
            `&CONSIDERAREPRESENTANTE=${$('#cbConsideraRepresentante').prop('checked')}` +
            `&CONSIDERARDUPLICATA=${$('#cbConsideraDuplicata').prop('checked')}` +
            `&SEMDATAEMAIL=${$('#cbSemDataEmail').prop('checked')}` +
            `&SITUACAOBOLETO=${$('#cbSituacaoBoleto').prop('checked')}` +
            `&IMPRESSO=${$('#rdImpresso').prop('checked')}` +
            `&NAOIMPRESSO=${$('#rdNaoImpresso').prop('checked')}` +
            `&IMPRESSOLINHADIG=${$('#rdImpressoLinhaDig').prop('checked')}` +
            `&TODASEMPRESAS=${todasEmpresas}` +
            `&EMPRESAS=${empresasFiltradasFormatada}`
        return filtros;
    }

    $("#btnCarregaEmpresas").on("click", function () {
        carregaEmpresasDisponiveis();
    });

    retornaHintRelatorio('btnImprimir', 'RelAcessoBloqueto')

    $('#btnImprimir').on('click', async function () {
        try {
            $.LoadingOverlay('show');
            try {
                const url = `/sisplan/impressao/v1/acesso_relbloqueto?`;
                const filtros = await retornaFiltros();
                const ordem = `&TELA_ORDENACAO=RelBloqueto&ORDEM_ORDENACAO=${$('#txtOrdem').val()}`;
                const bImprimeAutomatico = await verificaImprimirAutomatico('RelBloqueto');
                const arquivo = await GeraRelatorio(`${url}${filtros}${ordem}&`, 'GET', 100000, false, 'RelBloqueto');
                if (arquivo != undefined) {
                    if (!bImprimeAutomatico) {
                        window.open(`${BASE_URI}/relatorios_api/pdf/${arquivo}`, '_blank');
                    }
                    await limparRelatorios();
                }

            } catch (error) {
                console.error(error);
            }
        } finally {
            $.LoadingOverlay('hide');
        }
    });

    async function buscaRegistros() {
        const url = "/sisplan/relbloqueto/v1/relbloqueto?";
        const filtros = await retornaFiltros();
        try {
            $.LoadingOverlay("Show");
            try {
                const response = await requisicao("GET", url, `${filtros}&EMPRESA=${getCookie("empresa")}`, "", 360000);

                if (!response) {
                    return;
                }

                var jsonStr = await response.json()
                if (response.status != 200) {
                    msgErro(jsonStr['RESULT'][0].mensagem);
                    return;
                }

                return jsonStr;
            } catch (error) {
                console.error(error);
                msgErro('Não foi possível buscar os dados.');
            }
        } finally {
            $.LoadingOverlay("Hide");
        }
    }

    async function criaDataTable() {
        let jsonStr = await buscaRegistros();

        let dataCols = [
            {
                title: 'Sel',
                data: 'SEL'
            },
            {
                title: 'Fatura',
                data: 'FATURA'
            },
            {
                title: 'Número',
                data: 'NUMERO'
            },
            {
                title: 'Bordero',
                data: 'BORDERO'
            },
            {
                title: 'Codcli',
                data: 'CODCLI'
            },
            {
                title: 'Nome',
                data: 'NOME'
            },
            {
                title: 'Valor',
                data: 'VALOR'
            },
            {
                title: 'Juros',
                data: 'JUROS'
            },
            {
                title: 'Dt_Emissao',
                data: 'DT_EMISSAO'
            },
            {
                title: 'Dt_Vencto',
                data: 'DT_VENCTO'
            },
            {
                title: 'Banco',
                data: 'BANCO'
            },
            {
                title: 'Endosso',
                data: 'ENDOSSO'
            },
            {
                title: 'Nome_Banco',
                data: 'NOME_BANCO'
            },
            {
                title: 'NRBanco',
                data: 'NRBANCO'
            },
            {
                title: 'ObsDup',
                data: 'OBSDUP'
            },
            {
                title: 'Taxa',
                data: 'TAXA'
            },
            {
                title: 'Cnpj',
                data: 'CNPJ'
            },
            {
                title: 'Nota_Denegada',
                data: 'NOTA_DENEGADA'
            },
            {
                title: 'Obriga_NFSe',
                data: 'OBRIGA_NFSE'
            },
            {
                title: 'NFSe',
                data: 'NFSE'
            },
            {
                title: 'Emp_id',
                data: 'EMP_ID'
            },
        ]

        dataCols[0].render = function (data, type, row, meta) {
            return '<div class="form-check">' +
                '<div class="icheck-primary">' +
                `<input style="height:20px" type="checkbox" id="check_col_${meta.row}_row_${meta.col}" class="align-self-center campoCheck"><label for="check_col_${meta.row}_row_${meta.col}"></label>` +
                '</div>' +
                '</div>';
        }

        $("#tabelaRegistros").DataTable({
            destroy: true,
            sort: true,
            colReorder: {
                fixedColumnsLeft: 2
            },
            language: {
                sEmptyTable: "Nenhum registro encontrado",
                sInfo: "_TOTAL_ registros",
                sInfoEmpty: " 0 registros",
                sInfoFiltered: "(Filtrados de _MAX_ registros)",
                sInfoPostFix: "",
                sInfoThousands: ".",
                language: {
                    decimal: ",",
                    thousands: ".",
                },
                sLengthMenu: "_MENU_ resultados",
                sLoadingRecords: "Carregando...",
                sProcessing: "Processando...",
                sZeroRecords: "Nenhum registro encontrado",
                sSearch: "Pesquisar",
                oPaginate: {
                    sNext: "Próximo",
                    sPrevious: "Anterior",
                    sFirst: "Primeiro",
                    sLast: "Último",
                },
                oAria: {
                    sSortAscending: ": Ordenar colunas de forma ascendente",
                    sSortDescending: ": Ordenar colunas de forma descendente",
                },
            },
            autoWidth: true,
            order: [[2, "asc"]],
            data: jsonStr,
            columns: dataCols,
            columnDefs: [
                {
                    type: "date-br",
                    render(data) {
                        return new Intl.DateTimeFormat("pt-BR").format(
                            new Date(`${data.split(" ")[0]} 23:59:59`)
                        );
                    },
                    targets: [8, 9]
                },
                {
                    render(data) {
                        return parseFloat(data).toLocaleString("pt-br", {
                            minimumFractionDigits: 2,
                        });
                    },
                    targets: [6, 7, 15],
                    "className": 'pr-4 text-right'
                },
            ]
        });
    }

    $('#tabelaRegistros').on('click', '.campoCheck', async function () {
        let notaDenegada = this.parentNode.parentNode.parentNode.parentNode.cells[17].textContent;
        let obrigaNFSe = this.parentNode.parentNode.parentNode.parentNode.cells[18].textContent;
        let NFSe = this.parentNode.parentNode.parentNode.parentNode.cells[19].textContent;
        let temNfse = NFSe != '' ? 'S' : 'N'
        let destacaSisplan = await buscaParametroERP('FIN', '970', '2', '1');
        let validaNota = await buscaParametroERP('FIN', '540', '2', '1');
        let banco = this.parentNode.parentNode.parentNode.parentNode.cells[10].textContent;
        let nrBanco = this.parentNode.parentNode.parentNode.parentNode.cells[13].textContent;
        let notaGerada = await validaNotaGerada(this.parentNode.parentNode.parentNode.parentNode.cells[1].textContent);

        if (this.checked) {
            if ((banco == '077') && (nrBanco == '')) {
                msgAlerta('NR Banco não preenchido Banco 077 permite impressão de boleto somente com nosso número gerado pelo banco (Consulte Manual do Banco). Impossivel selecionar!')
                this.checked = false
                return;
            }

            if (notaDenegada == 'S') {
                msgAlerta('Atenção duplicata pertence a uma nota com status Denegada. Impossível imprimir duplicata nº:' + this.parentNode.parentNode.parentNode.parentNode.cells[2].textContent)
                this.checked = false
                return;
            }

            if ((destacaSisplan) && (obrigaNFSe == 'S') && (temNfse == 'N')) {
                msgAlerta('Atenção cliente obriga a conter NFS-e e nota não foi gerada, desmarque essa duplicata. Impossível selecionar esta duplicata!')
                this.checked = false
                return;
            }

            if ((validaNota == 'S') || (validaNota == 'B')) {
                if (!notaGerada) {
                    if ((validaNota == 'S') || (validaNota == 'B')) {
                        msgAlerta('Atenção duplicata pertence a uma nota não autorizada. Impossível selecionar esta duplicata!')
                        this.checked = false
                        return;
                    }
                }
            }
        }

        if (this.checked) {
            if (listaRegistros.findIndex(item => item.FATURA == this.parentNode.parentNode.parentNode.parentNode.cells[1].textContent &&
                item.NUMERO == this.parentNode.parentNode.parentNode.parentNode.cells[2].textContent &&
                item.BORDERO == this.parentNode.parentNode.parentNode.parentNode.cells[3].textContent &&
                item.CODCLI == this.parentNode.parentNode.parentNode.parentNode.cells[4].textContent) == -1) {
                listaRegistros.push({
                    "FATURA": this.parentNode.parentNode.parentNode.parentNode.cells[1].textContent,
                    "NUMERO": this.parentNode.parentNode.parentNode.parentNode.cells[2].textContent,
                    "BORDERO": this.parentNode.parentNode.parentNode.parentNode.cells[3].textContent,
                    "CODCLI": this.parentNode.parentNode.parentNode.parentNode.cells[4].textContent,
                })
            }
        } else {
            const index = listaRegistros.findIndex(item => item.FATURA == this.parentNode.parentNode.parentNode.parentNode.cells[1].textContent &&
                item.NUMERO == this.parentNode.parentNode.parentNode.parentNode.cells[2].textContent &&
                item.BORDERO == this.parentNode.parentNode.parentNode.parentNode.cells[3].textContent &&
                item.CODCLI == this.parentNode.parentNode.parentNode.parentNode.cells[4].textContent);
            listaRegistros.splice(index, 1);
        };
    })

    async function validaNotaGerada(fatura) {
        const pesquisa = {
            tabela: "NOTA",
            camposSelect: [
                "PROTOCOLO_NFE",
                "EMISSAO_NFE"
            ],
            where: [` 1=1 AND FATURA = '${fatura}' AND ((IMPRESSO <> 'C') AND (IMPRESSO <> 'D')) AND ((PROTOCOLO_NFE IS NOT NULL) OR (PROTOCOLO_NFE <> '')) AND ((CHAVE_NFE IS NOT NULL) OR (CHAVE_NFE <> ''))`]
        };
        const jsonStr = await retornaJsonPesquisaPadrao(JSON.stringify(pesquisa));

        if (jsonStr.length <= 0) {
            return false;
        } else {
            return true;
        }
    }

    $('#btn-consultar').on('click', async function () {
        try {
            $.LoadingOverlay("Show");
            try {
                await criaDataTable();

                if ($('#tabelaRegistros').DataTable().data().length <= 0) {
                    msgAlerta('Nenhum registro encontrado!');
                    $('#btnImpDup').prop('disabled', true);
                    $('#btnImpTodas').prop('disabled', true);
                    return;
                }

                $('#btnImpDup').prop('disabled', false);
                $('#btnImpTodas').prop('disabled', false);


            } catch (error) {
                console.error(error);
                msgErro("Erro ao buscar os dados");
            }
        } finally {
            $("#modal-filtros").modal("hide");
            $.LoadingOverlay("hide");
        }
    });

    $('#btnImpTodas').on('click', function () {
        $.LoadingOverlay('show')
        try {
            for (let i = 0; i < $('#tabelaRegistros').DataTable().data().count(); i++) {
                if (listaRegistros.findIndex(item => item.FATURA == $('#tabelaRegistros').DataTable().data()[i].FATURA &&
                    item.NUMERO == $('#tabelaRegistros').DataTable().data()[i].NUMERO &&
                    item.BORDERO == $('#tabelaRegistros').DataTable().data()[i].BORDERO &&
                    item.CODCLI == $('#tabelaRegistros').DataTable().data()[i].CODCLI) == -1) {
                    listaRegistros.push({
                        "FATURA": $('#tabelaRegistros').DataTable().data()[i].FATURA,
                        "NUMERO": $('#tabelaRegistros').DataTable().data()[i].NUMERO,
                        "BORDERO": $('#tabelaRegistros').DataTable().data()[i].BORDERO,
                        "CODCLI": $('#tabelaRegistros').DataTable().data()[i].CODCLI,
                    });
                }
            }
            if (listaRegistros.length <= 0) {
                msgAlerta('Nenhum registro para importar!');
            } else {
                if (permissaoUsuarioLogado.ALTERA == 'S') {
                    localStorage.removeItem('registros')
                    localStorage.setItem('registros', JSON.stringify(listaRegistros));
                    window.location.href = `relbloqueto/create`;
                } else {
                    msgAlertaSemConfirmacao("Sem permissão para alterar!");
                }
            }
        } finally {
            $.LoadingOverlay('hide')
        }
    });

    $('#btnImpDup').on('click', function () {
        $.LoadingOverlay('show')
        try{
            if (listaRegistros.length <= 0) {
                msgAlerta('Nenhum registro para importar!');
            } else {
                if (permissaoUsuarioLogado.ALTERA == 'S') {
                    localStorage.removeItem('registros')
                    localStorage.setItem('registros', JSON.stringify(listaRegistros));
                    window.location.href = `relbloqueto/create`;
                } else {
                    msgAlertaSemConfirmacao("Sem permissão para alterar!");
                }
            }
        } finally{
            $.LoadingOverlay('hide')
        }
    })
});