<!DOCTYPE html>
<html>

<head>
  <meta charset="utf-8">
  <meta http-equiv="X-UA-Compatible" content="IE=edge">
  <title>Sisplan Web | Relatório de Autorização de Pagamento</title>
  <!-- Tell the browser to be responsive to screen width -->
  <meta name="viewport" content="width=device-width, initial-scale=1">
  <link rel="stylesheet" href="plugins/fontawesome-free/css/all.min.css?versao=3.251.16.1">

  <link rel="stylesheet" href="dist/css/adminlte.min.css?versao=3.251.16.1">
  <link rel="stylesheet" href="dist/css/custom.css?versao=3.251.16.1">
  <link rel="stylesheet" href="dist/css/sisplan.css?versao=3.251.16.1">
  <link rel="stylesheet" href="dist/css/PesquisaVariosSelect2.css?versao=3.251.16.1">
  <link rel="stylesheet" type="text/css" href="plugins/datatables-keytable/css/keyTable.bootstrap4.min.css?versao=3.251.16.1">
  <link rel="stylesheet" href="plugins/toastr/toastr.min.css?versao=3.251.16.1">
  <link rel="stylesheet" href="plugins/fontawesome-free/css/all.min.css?versao=3.251.16.1">
  <link rel="shortcut icon" href="favicon.ico">
  <link rel="stylesheet" type="text/css" href="dist/css/driver.min.css?versao=3.251.16.1" />
  <link rel="stylesheet" href="dist/css/jquery-ui.css?versao=3.251.16.1">
  <link href="https://fonts.googleapis.com/css?family=Source+Sans+Pro:300,400,400i,700" rel="stylesheet">
  <link rel="stylesheet" href="plugins/select2/css/select2.min.css?versao=3.251.16.1">
  <link rel="stylesheet" href="plugins/select2-bootstrap4-theme/select2-bootstrap4.min.css?versao=3.251.16.1">
  <link rel="stylesheet" href="plugins/icheck-bootstrap/icheck-bootstrap.min.css?versao=3.251.16.1">
  <link rel="stylesheet" href="plugins/datatables-colreorder/css/colReorder.bootstrap4.min.css?versao=3.251.16.1">
  <style>
    .border-Field .textoBorda {
      font-size: 1.1em !important;
      text-align: left !important;
      width: auto;
      padding: 0 10px;
      border-bottom: none;
    }

    .border-Field {
      border: 1px solid var(--font-color) !important;
      padding: 0 1.0em .5em 1.0em !important;
      margin: 0 0 1.0em 0 !important;
      -webkit-box-shadow: 0px 0px 0px 0px #000;
      box-shadow: 0px 0px 0px 0px #000;
    }

    .form-group {
      margin-bottom: 0.5rem !important;
    }

    #tabelaAP_wrapper .table.dataTable tbody td {
      white-space: nowrap;
      text-overflow: ellipsis;
      overflow: hidden;
    }
  </style>
</head>

<body class="hold-transition sidebar-mini layout-fixed">
  <main class="wrapper">

    <div class="content-wrapper">
      <div class="content-header">
        <div class="container-fluid">
          <div class="row mb-2">
            <div class="col-sm-6 flex">
              <h1 class="m-0 text-dark"> Relatório de Autorização de Pagamento</h1>
              <button type="button" class="btn btn-info btn-sm ml-2" title="Tutorial" style="color: white;" id="tutorial">
                <i class="fas fa-question-circle"></i></button>
            </div>
            <div class="col-sm-6">

            </div>
          </div>
          <div class="row">
            <div class="col-12">
              <fieldset>
                <div class="row">
                  <div class="col-12">
                    <div class="buttons">
                      <button class="btn btn-success btn-sisp" id="btnFiltros" type="button"><span class="fas fa-filter"></span> Filtros</button>
                      <button id="btnImprimir" class="btn-sisp btn btn-danger"><i class="fas fa-print"></i> Imprimir</button>
                    </div>
                  </div>
                </div>
                <div class="card-body" id="divTabelaVendas">
                  <div class="card">
                    <div class="col-sm-12 table-responsive card-body">
                      <table id="tabelaAP" class="table table-sm table-select table-hover" width="100%"></table>
                      <thead>
                        <tr></tr>
                      </thead>
                      <tbody>
                        <tr></tr>
                      </tbody>
                    </div>
                  </div>
                </div>
              </fieldset>
            </div>
          </div>
        </div>
      </div>
    </div>
    <div id="modal-filtros" class="modal" tabindex="-1" role="dialog">
      <div class="modal-dialog modal-xl" role="document">
        <div class="modal-content" id="modalBody">
          <div class="modal-header">
            <h4 class="modal-title">Filtros</h4>

            <button type="button" class="close" data-dismiss="modal" aria-label="Close">
              <span aria-hidden="true">&times;</span>
            </button>
          </div>

          <div class="modal-body mb-0 pb-0">

            <div class="row justify-content-center justify-content-md-start">
              <div class="col-auto"><!-- Ativo -->
                <fieldset class="form border-Field p-0 d-block d-md-flex">
                  <legend class="textoBorda pb-0 mb-0">Buscar</legend>
                  <div class="icheck-primary mr-2"><input type="radio" id="rdTodas" value="0" name="rd" checked /><label for="rdTodas">Todas</label></div>
                  <div class="icheck-primary"><input type="radio" id="rdNaoImpressa" value="1" name="rd" /><label for="rdNaoImpressa">Não Impressas</label></div>
                </fieldset>
              </div>

              <div class="col-auto"><!-- Ativo -->
                <fieldset class="form border-Field p-0 d-block d-md-flex">
                  <legend class="textoBorda pb-0 mb-0">Opções</legend>
                  <div class="icheck-primary mr-2"><input type="checkbox" id="cbAPAberto" /><label for="cbAPAberto">Somente AP's em aberto</label></div>
                  <!-- <div class="icheck-primary mr-2"><input type="checkbox" id="cbRateioCP" /><label for="cbRateioCP">Somente Rateio CP</label></div> -->
                  <div class="icheck-primary"><input type="checkbox" id="cbAntecipacao" /><label for="cbAntecipacao">Antecipações</label></div>
                </fieldset>
              </div>
            </div>


            <div class="row">
              <div class="col-lg-4 col-sm-12  form-group">
                <div class="d-flex justify-content-start ">
                  <label for="txtAPde">Autorização de Pagamento de/até:</label>
                </div>
                <div class="input-group">
                  <input type="text" class="input-default focus form-control" id="txtAPde">  
                  <input type="text" class="input-default focus form-control" id="txtAPate">
                </div>
              </div>
            </div>


            <div class="row">
              <div class="col-lg-4 col-sm-12 col-12 form-group">
                <label for="txtVenctoDe">Data vencimento de/até:</label>
                <div class="input-group">
                  <input type="date" max="2500-12-31" value="1200-01-01" class="input-default focus form-control" id="txtVenctoDe">  
                  <input type="date" max="2500-12-31" value="2500-12-31" class="input-default focus form-control" id="txtVenctoAte">
                </div>
              </div>

              <div class="col-lg-4 col-sm-12 col-12 form-group">
                <label for="txtVenctoDe">Data emissão de/até:</label>
                <div class="input-group">
                  <input type="date" max="2500-12-31" value="1200-01-01" class="input-default focus form-control" id="txtDataEmiDe">  
                  <input type="date" max="2500-12-31" value="2500-12-31" class="input-default focus form-control" id="txtDataEmiAte">
                </div>
              </div>

              <div class="col-lg-4 col-sm-12 col-12 form-group">
                <label for="txtEmissaoDe">Data digitação de/até:</label>
                <div class="input-group">
                  <input type="date" max="2500-12-31" value="1200-01-01" class="input-default focus form-control" id="txtDigitacaoDe">  
                  <input type="date" max="2500-12-31" value="2500-12-31" class="input-default focus form-control" id="txtDigitacaoAte">
                </div>
              </div>
            </div>

            <div class="row">
              <div class="col-lg-4 col-sm-12  form-group" id="FornecedorInfoTour">
                <label data-error="wrong" data-success="right" for="txtEntidade">Fornecedor:</label>
                <div class="input-group">
                  <select class="js-example-programmatic js-states form-control" id="txtEntidade" name="txtEntidade" multiple="multiple"> </select>
                  <div class="input-group-append">
                    <button class="btn bg-danger" id="btnEntidade" name="btnEntidade" data-button="absolute" type="button"><i class="m-0 p-0 fas fa-search"></i></button>
                    <button class="btn bg-danger" id="btnLimpaEntidade" name="btnLimpaEntidade" type="button"><i class="m-0 p-0 fas fa-trash"></i></button>
                  </div>
                </div>
              </div>

              <div class="col-lg-4 col-sm-12  form-group" id="HistoricoInfoTour">
                <label data-error="wrong" data-success="right" for="txtHistorico">Histórico:</label>
                <div class="input-group">
                  <select class="js-example-programmatic js-states form-control" id="txtHistorico" name="txtHistorico" multiple="multiple"> </select>
                  <div class="input-group-append">
                    <button class="btn bg-danger" id="btnHistorico" name="btnHistorico" data-button="absolute" type="button"><i class="m-0 p-0 fas fa-search"></i></button>
                    <button class="btn bg-danger" id="btnLimpaHistorico" name="btnLimpaHistorico" type="button"><i class="m-0 p-0 fas fa-trash"></i></button>
                  </div>
                </div>
              </div>

              <div class="col-lg-4 col-sm-12  form-group" id="SituacaoInfoTour">
                <label data-error="wrong" data-success="right" for="txtSituacao">Situação:</label>
                <div class="input-group">
                  <select class="js-example-programmatic js-states form-control" id="txtSituacao" name="txtSituacao" multiple="multiple"> </select>
                  <div class="input-group-append">
                    <button class="btn bg-danger" id="btnSituacao" name="btnSituacao" data-button="absolute" type="button"><i class="m-0 p-0 fas fa-search"></i></button>
                    <button class="btn bg-danger" id="btnLimpaSituacao" name="btnLimpaSituacao" type="button"><i class="m-0 p-0 fas fa-trash"></i></button>
                  </div>
                </div>
              </div>

            </div>

            <div class="row">

              <div class="col-lg-4 col-sm-12  form-group" id="ClasseInfoTour">
                <label data-error="wrong" data-success="right" for="txtClasse">Classe:</label>
                <div class="input-group">
                  <select class="js-example-programmatic js-states form-control" id="txtClasse" name="txtClasse" multiple="multiple"> </select>
                  <div class="input-group-append">
                    <button class="btn bg-danger" id="btnClasse" name="btnClasse" data-button="absolute" type="button"><i class="m-0 p-0 fas fa-search"></i></button>
                    <button class="btn bg-danger" id="btnLimpaClasse" name="btnLimpaClasse" type="button"><i class="m-0 p-0 fas fa-trash"></i></button>
                  </div>
                </div>
              </div>

              <div class="col-lg-4 col-sm-12  form-group" id="MoedaInfoTour">
                <label data-error="wrong" data-success="right" for="txtMoeda">Moeda:</label>
                <div class="input-group">
                  <select class="js-example-programmatic js-states form-control" id="txtMoeda" name="txtMoeda" multiple="multiple"> </select>
                  <div class="input-group-append">
                    <button class="btn bg-danger" id="btnMoeda" name="btnMoeda" data-button="absolute" type="button"><i class="m-0 p-0 fas fa-search"></i></button>
                    <button class="btn bg-danger" id="btnLimpaMoeda" name="btnLimpaMoeda" type="button"><i class="m-0 p-0 fas fa-trash"></i></button>
                  </div>
                </div>
              </div>


              <div class="col-lg-4 col-sm-12  form-group" id="BancoInfoTour">
                <label data-error="wrong" data-success="right" for="txtBanco">Banco:</label>
                <div class="input-group">
                  <select class="js-example-programmatic js-states form-control" id="txtBanco" name="txtBanco" multiple="multiple"> </select>
                  <div class="input-group-append">
                    <button class="btn bg-danger" id="btnBanco" name="btnBanco" data-button="absolute" type="button"><i class="m-0 p-0 fas fa-search"></i></button>
                    <button class="btn bg-danger" id="btnLimpaBanco" name="btnLimpaBanco" type="button"><i class="m-0 p-0 fas fa-trash"></i></button>
                  </div>
                </div>
              </div>

            </div>

            <div class="row mb-3">

              <div class="col-lg-4 col-sm-12  form-group" id="ContaInfoTour">
                <label data-error="wrong" data-success="right" for="txtConta">Conta:</label>
                <div class="input-group">
                  <select class="js-example-programmatic js-states form-control" id="txtConta" name="txtConta" multiple="multiple"> </select>
                  <div class="input-group-append">
                    <button class="btn bg-danger" id="btnConta" name="btnConta" data-button="absolute" type="button"><i class="m-0 p-0 fas fa-search"></i></button>
                    <button class="btn bg-danger" id="btnLimpaConta" name="btnLimpaConta" type="button"><i class="m-0 p-0 fas fa-trash"></i></button>
                  </div>
                </div>
              </div>

              <div class="col-lg-2 col-sm-12">
                <div class="d-flex justify-content-start">
                  <label for="txtNF">Nota Fiscal:</label>
                </div>
                <div class="input-group">
                  <input type="text" autocomplete="off" class="input-default focus form-control" id="txtNF">
                </div>
              </div>

              <div class="col-lg col-sm-12 mb-4 mb-md-0">
                <div class="d-flex justify-content-center justify-content-md-start" style="margin-top: 28px;">
                  <button id="btnSelecionarEmpresas" type="button" class="btn btn-danger">Selecionar empresas</button>
                </div>
              </div>
            </div>


            <div class="modal-footer justify-content-start pl-0">
              <div class="row col-12 ml-0">
                <div class="col-lg-4 col-sm-6 col-md-6 ml-0 pl-0">
                  <label for="txtOrdem">Opção de Relatório:</label>
                  <div class="relative d-flex align-items-center">
                    <select id="txtOrdem" class="input-default focus custom-select">
                    </select>
                    <button class="btn btn-sm btn-success ml-2" id="btnEdicaoRelatorio" title="Edição de ordenações">
                      <i class="fas fa-check"></i>
                    </button>
                  </div>
                </div>
                <div class="col-6 col-lg-8 d-flex justify-content-end align-items-end pr-0">
                  <div class="d-flex">
                    <button class="btn btn-primary btn-sisp mr-2" id="btnLimparFiltros" style="background-color: #B22222; border-color: #B22222">
                      <span class="fas fa-trash"></span> Limpar Filtros
                    </button>
                    <button id="btnConsultar" class="btn btn-primary btn-sisp" type="button">
                      <span class="fas fa-search"></span> Consultar
                    </button>
                  </div>
                </div>
              </div>
            </div>
          </div>
        </div>
      </div>
    </div>

    <!-- Control Sidebar -->
    <aside class="control-sidebar control-sidebar-dark">
      <!-- Control sidebar content goes here -->
    </aside><!-- /.control-sidebar -->
    <?php include_once('../../modais.php'); ?>
  </main><!-- /.wrapper -->

  <script src="plugins/jquery/jquery.min.js?versao=3.251.16.1"></script>
  <script src="dist/js/jquery.maskMoney.min.js?versao=3.251.16.1"></script>
  <script src="plugins/jquery-ui/jquery-ui.min.js?versao=3.251.16.1"></script>
  <script type="text/javascript" src="dist/js/jquery.dataTables.js?versao=3.251.16.1"></script>
  <script type="text/javascript" src="dist/js/dataTables.bootstrap4.min.js?versao=3.251.16.1"></script>
  <script src="plugins/sweetalert2/sweetalert2.min.js?versao=3.251.16.1"></script>
  <script src="plugins/toastr/toastr.min.js?versao=3.251.16.1"></script>
  <script>
    $.widget.bridge('uibutton', $.ui.button);
  </script>
  <script src="plugins/bootstrap/js/bootstrap.bundle.min.js?versao=3.251.16.1"></script>
  <script src="dist/js/adminlte.min.js?versao=3.251.16.1"></script>
  <script src="dist/js/requisicoes.js?versao=3.251.16.1"></script>
  <script src="dist/js/loadingoverlay.min.js?versao=3.251.16.1"></script>
  <script src="dist/js/valida_cpf_cnpj.js?versao=3.251.16.1"></script>
  <script src="plugins/jquery-validation/jquery.validate.min.js?versao=3.251.16.1"></script>
  <script src="dist/js/dataTables.keyTable.js?versao=3.251.16.1"></script>
  <script src="plugins/moment/moment.min.js?versao=3.251.16.1"></script>
  <script src="dist/js/sisplan.js?versao=3.251.16.1"></script>
  <script src="utils/funcoes.js?versao=3.251.16.1"></script>
  <script src="utils/cookies.js?versao=3.251.16.1"></script>
  <script src="dist/js/driver.min.js?versao=3.251.16.1"></script>
  <script src="config.js?versao=3.251.16.1"></script>
  <script src="plugins/datatables-colreorder/js/dataTables.colReorder.min.js?versao=3.251.16.1"></script>
  <script src="plugins/select2/js/select2.full.min.js?versao=3.251.16.1"></script>
  <script>
    $(document).ready(async function() {
      if (getCookie('usuario') == "") {
        window.location.href = `${BASE_URI}/login`;
        return;
      }

      let usuario = getCookie('usuario');
      let empresa = getCookie('empresa');

      ipInterno = IP_INTERNO;
      ipExterno = IP_EXTERNO;
      basicAuth = BASIC_AUTH;

      const temAcesso = await temAcessoTela('RELAP');
      if (!temAcesso.resultado) {
        toastrAcesso(temAcesso, BASE_URI);
        return;
      }

      sArquivo = `${BASE_URI}/pages/relap/relap.js?versao=3.251.16.1`;
      const nomeTela = ('<?php echo basename(__FILE__) ?>').replace('.php', '');

      await insereJavaScriptPagina(sArquivo);

      habilitaCamposObrigatoriosTela(nomeTela);
    });
  </script>

</body>

</html>