/* eslint-disable guard-for-in */

const columnsProdutosRelacionados = [
    {
        title: 'Id',
        data: 'ID',
    },
    {
        title: 'Código',
        data: 'CODIGO',
    },
    {
        title: 'Descrição',
        data: 'DESCRICAO',
    },
    {
        title: 'Cor',
        data: 'COR',
    },
    {
        title: 'Descrição Cor',
        data: 'DESC_COR',
    },
    {
        title: 'Tamanho',
        data: 'TAM',
    },
    {
        title: 'Opções',
        data: 'OPCOES',
    }
];
const columnsProdutosFilhosRelacionados = [
    {
        title: 'Id',
        data: 'ID',
    },
    {
        title: 'Código',
        data: 'CODIGO',
    },
    {
        title: 'Descrição',
        data: 'DESCRICAO',
    },
    {
        title: 'Cor',
        data: 'COR',
    },
    {
        title: 'Descrição Cor',
        data: 'DESC_COR',
    },
    {
        title: 'Tamanho',
        data: 'TAM',
    },
    {
        title: 'Quantidade',
        data: 'QUANTIDADE',
    },
    {
        title: 'Ordem',
        data: 'ORDEM',
    },
    {
        title: 'Opções',
        data: 'OPCOES',
    }
];

$('#tutorial').on('click', function () {
    $(document).ready(async function () {
        const driver = new Driver({
            doneBtnText: 'Sair',
            closeBtnText: 'Fechar',
            nextBtnText: 'Próximo',
            prevBtnText: 'Anterior',
            allowClose: false
        });
        driver.defineSteps([{
            element: '#btnFiltros',
            popover: {
                title: 'Botão Filtros',
                description: 'Clique aqui para abrir os filtros padrões da tela.',
                position: 'right'
            }
        },
        {
            element: '#btnNovoProduto',
            popover: {
                title: 'Botão Incluir',
                description: 'Clique aqui para iniciar o cadastro de um produto.',
                position: 'right'
            }
        },
        {
            element: '#tabelaCadProduto_wrapper',
            popover: {
                title: 'Tabela Produtos',
                description: 'Aqui estão os dados dos produtos cadastrados.',
                position: 'top'
            }
        }
        ]);
        driver.start();
    });
});
$(document).ready(async function () {
    const permissaoUsuarioLogado = await permissaoAcessos("PRODUTO");
    const acessoFaccao = await permissaoAcessos('FACPRECO');

    function retornaBotaoOpcoes(sCodigo) {
        var retorno = '<div style="text-align:start;"> ' +
            '    <button class="btn btn-info btn-sm dropdown-toggle btnVerificaOpcoes" type="button" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false"> ' +
            '      ' + sCodigo + ' ' +
            '    </button> ' +
            '    <div class="dropdown-menu dropDownProduto" style="z-index: 999999;"> ' +
            '       <button class="dropdown-item" id="btn-editar">Editar</button>     ' +
            '       <button class="dropdown-item" id="btn-excluir">Excluir</button>  ' +
            '       <button class="dropdown-item" id="btn-duplicar">Duplicar</button>  ' +
            '       <button class="dropdown-item" id="btn-barra">Gera Barras</button>  ' +
            '       <button class="dropdown-item" id="btnAnexos">Gestão Documentos</button>     ' +
            '       <button class="dropdown-item" id="btnMedidas">Medidas</button>     ' +
            '       <button class="dropdown-item" id="btnCombProd">Combinações</button>     ' +
            '       <button class="dropdown-item" id="btnHistProd">Modificações</button>     ' +
            '       <button class="dropdown-item" id="btnFluxoProd">Fluxo</button> ' +
            '       <button class="dropdown-item" id="btnProdItensEst">Consulta Estoque</button>     ' +
            '       <button class="dropdown-item" id="btnRelacionarProdutos">Relacionar Produtos</button>     ' +
            '       <button class="dropdown-item" id="btnCadConsumo">Consumos</button>     ';
        if (acessoFaccao.CONSULTA == 'S') {
            retorno +=
                '       <button class="dropdown-item" id="btnImprimirFT">Imprimir FT</button>     ';
        }
        retorno +=
            '       <button class="dropdown-item" id="btnPrecoFaccao">Preço Facção</button>     '; +
                '</div>';
        return retorno;
    }

    function retornaBotaoOpcoesRelacionamentoFilhos() {
        const opcoes = `
         <div class="col-lg-1 col-12">
            <div class="btn-group grupo_botao" role="group" aria-label="Basic example">
               <button type="button" class="btn btn-opcao bg-button nofocus btnDeletarOpcoesFilhos">
                    <i class="fas fa-trash text-red" style="font-weight: bold;margin-left: 10px;font-size: 18px;"></i>
                </button>
            </div>
        </div>
        `
        // <button type="button" class="btn btn-opcao bg-button nofocus btnEditarOpcoesFilhos">
        //     <i class="fas fa-edit text-red" style="font-weight: bold;margin-left: 10px;font-size: 18px;"></i>
        // </button>

        // '<div class="">' +
        //     '    <button class="btnDeletarOpcoesFilhos btn btn-danger" type="button" title="Excluir" style="font-size: 0.8rem;">Excluir</span></button>  ' +
        //     '    <button class="btnDeletarOpcoesFilhos btn btn-danger" type="button" title="Excluir" style="font-size: 0.8rem;">Excluir</span></button>  ' +
        //     '</div>';



        return opcoes
    }
    function retornaBotaoOpcoesRelacionamentoPais() {
        const opcoes = `
            <div class="col-lg-1 col-12">
                <div class="btn-group grupo_botao" role="group" aria-label="Basic example">
                <button type="button" class="btn btn-opcao bg-button nofocus btnDeletarOpcoesPais">
                        <i class="fas fa-trash text-red" style="font-weight: bold;margin-left: 10px;font-size: 18px;"></i>
                    </button>
                </div>
            </div>
        `

        return opcoes
    }

    consultaProduto();

    $('#btnFiltros').on('click', function () {
        $('#modal-filtros').modal('show');
    });

    $('#btnNovoProduto').on('click', function () {
        if (permissaoUsuarioLogado.INCLUI == 'S') {
            window.location.href = "produto/create";
        } else {
            msgAlertaSemConfirmacao("Sem permissão para incluir!");
        }
    });

    // autocompleta filtros

    componenteFiltro("produto", true);
    componenteFiltro("colecao", true);
    componenteFiltro("marca", true);
    componenteFiltro("grupo", true);
    componenteFiltro("linha", true);
    componenteFiltro("status", true);
    componenteFiltro("etiqueta", true);

    $('#btnConsultar').on('click', async function () {
        $('#modal-filtros').modal('hide');
        await consultaProduto();
    });

    $('#btnLimparFiltros').on('click', async function () {
        $('#txtProduto').empty().trigger('change');
        $('#txtColecao').empty().trigger('change');
        $('#txtMarca').empty().trigger('change');
        $('#txtGrupo').empty().trigger('change');
        $('#txtLinha').empty().trigger('change');
        $('#txtStatus').empty().trigger('change');
        $('#txtEtiqueta').empty().trigger('change');
    });

    function criptografaCodigo(codigo) {
        return btoa(codigo).replaceAll('=', '');
    }

    $('#txtProdutoFilhoRelacionamento').autocompleta(3, `JSON={ "tabela":"PRODUTO", "camposSelect":[ "CODIGO chave", "DESCRICAO descricao"], "where": null}`);
    $('#btn-ProdutoFilhoRelacionamento').pesquisa_serverside(['#txtProdutoFilhoRelacionamento'], ['CODIGO'], ['DESCRICAO'], '{"tabela":"produto", "camposSelect":[ "CODIGO", "DESCRICAO"], "where": null}', 'Pesquisa de Produto');

    $('#txtProdutoFilhoRelacionamento').on('blur', function () {
        // $('#txtCor').off();

        $('#txtCorFilhoRelacionamento').unbind('autocompleta');
        $('#txtTamanhoFilhoRelacionamento').unbind('autocompleta');
        $('#txtCorFilhoRelacionamento').autocompleta(1, `JSON={ "tabela":"pa_iten", "camposSelect":["PA_ITEN.COR CHAVE, CADCOR.DESCRICAO"], "leftjoin": [{ "tabela" : "cadcor", "condicao" : "pa_iten.cor = cadcor.cor" }], "groupBy": ["pa_iten.cor", "cadcor.descricao"], "where": ["PA_ITEN.CODIGO = '${$(this).attr('data-chave')}'"] }`, [], [], []);
        $('#txtTamanhoFilhoRelacionamento').autocompleta(1, `JSON={ "tabela":"pa_iten", "camposSelect":["TABTAM.ID_TAM CHAVE, TABTAM.TAM DESCRICAO"], "leftjoin": [{ "tabela" : "TABTAM", "condicao" : "pa_iten.TAM = TABTAM.TAM" }], "groupBy": ["TABTAM.ID_TAM", "TABTAM.TAM"], "where": ["PA_ITEN.CODIGO = '${$(this).attr('data-chave')}'"] }`, [], [], []);

        $('#btn-CorFilhoRelacionamento').off();
        $('#btn-TamanhoFilhoRelacionamento').off();
        $('#btn-CorFilhoRelacionamento').unbind('pesquisa');
        $('#btn-TamanhoFilhoRelacionamento').unbind('pesquisa');
        $('#btn-CorFilhoRelacionamento').pesquisa('#txtCorFilhoRelacionamento', 'COR', 'DESCRICAO', `/sisplan/funcoes/v1/pesquisa?JSON={ "tabela":"pa_iten", "camposSelect":[ "PA_ITEN.COR COR", "CADCOR.DESCRICAO DESCRICAO" ],"leftjoin": [{ "tabela" : "cadcor", "condicao" : "pa_iten.cor = cadcor.cor" }], "groupBy": ["pa_Iten.cor", "cadcor.descricao"], "where": ["PA_ITEN.CODIGO = '${$(this).attr('data-chave')}'"]}`, 'Pesquisa Cor', 'CADCOR');
        $('#btn-TamanhoFilhoRelacionamento').pesquisa('#txtTamanhoFilhoRelacionamento', 'ID_TAM', 'TAM', `/sisplan/funcoes/v1/pesquisa?JSON={ "tabela":"PA_ITEN", "camposSelect":[ "TABTAM.ID_TAM", "TABTAM.TAM" ],"leftjoin": [{ "tabela" : "TABTAM", "condicao" : "pa_iten.TAM = TABTAM.TAM" }], "groupBy": ["TABTAM.ID_TAM", "TABTAM.TAM"], "where": ["PA_ITEN.CODIGO = '${$(this).attr('data-chave')}'"]}`, 'Pesquisa Tamanho', 'TABTAM');

        // $('#btn-CorFilhoRelacionamento').pesquisa(['#txtCorFilhoRelacionamento'], ['COR'], ['DESCRICAO'], `{ "tabela":"pa_iten", "camposSelect":[ "PA_ITEN.COR CHAVE", "cadcor.descricao DESCRICAO" ],"leftjoin": [{ "tabela" : "cadcor", "condicao" : "pa_iten.cor = cadcor.cor" }], "groupBy": ["pa_Iten.cor", "cadcor.descricao"], "where": ["PA_ITEN.CODIGO = '${$(this).attr('data-chave')}'"]}`, 'Pesquisa Cor', 'cadcor');
    });

    async function consultaProduto(ordenacaoPesquisa = '', orderTable = []) {
        try {
            $.LoadingOverlay("show");
            let response;
            let produto = await formataListas($('#txtProduto').val().toString()) != '' ? ` AND PRODUTO.CODIGO IN (${await formataListas($('#txtProduto').val().toString())})` : '';
            let colecao = await formataListas($('#txtColecao').val().toString()) != '' ? ` AND PRODUTO.COLECAO IN (${await formataListas($('#txtColecao').val().toString())})` : '';
            let marca = await formataListas($('#txtMarca').val().toString()) != '' ? ` AND PRODUTO.MARCA IN (${await formataListas($('#txtMarca').val().toString())})` : '';
            let grupo = await formataListas($('#txtGrupo').val().toString()) != '' ? ` AND PRODUTO.GRUPO IN (${await formataListas($('#txtGrupo').val().toString())})` : '';
            let linha = await formataListas($('#txtLinha').val().toString()) != '' ? ` AND PRODUTO.LINHA IN (${await formataListas($('#txtLinha').val().toString())})` : '';
            let status = await formataListas($('#txtStatus').val().toString()) != '' ? ` AND PRODUTO.STATUS IN (${await formataListas($('#txtStatus').val().toString())})` : '';
            let etiqueta = await formataListas($('#txtEtiqueta').val().toString()) != '' ? ` AND PRODUTO.ETIQUETA IN (${await formataListas($('#txtEtiqueta').val().toString())})` : '';
            let inputStatus = $('input[name="cbStatusProd"]:checked');
            const tipoBanco = await retornaDatabase();
            const objTipoBanco = {
                'FIREBIRD': `((PRODUTO.CODIGO IS NOT NULL) AND (PRODUTO.CODIGO <> ''))`,
                'ORACLE': `((PRODUTO.CODIGO IS NOT NULL) OR (PRODUTO.CODIGO <> ''))`,
                'POSTGRES': `((PRODUTO.CODIGO IS NOT NULL) AND (PRODUTO.CODIGO <> ''))`,
                'SQLSERVER': `((PRODUTO.CODIGO IS NOT NULL) AND (PRODUTO.CODIGO <> ''))`
            };
            const whereInicial = objTipoBanco[tipoBanco];
            let statusProduto = inputStatus.attr('id') === 'cbTodos' ? '' : ` AND PRODUTO.ATIVO = '${inputStatus.val()}'`;
            const objPesquisa = {
                "tabela": "produto",
                "camposSelect": ["PRODUTO.CODIGO", "PRODUTO.CODIGO2", "PRODUTO.IMAGEM4", "PRODUTO.DESCRICAO", "PRODUTO.PRECO"],
                // "camposWhereServerSide": ["PRODUTO.CODIGO", "PRODUTO.CODIGO2", "PRODUTO.DESCRICAO", "PA_ITEN.BARRA", "PA_ITEN.BARRA28", "PA_ITEN.BARRACLI"],
                "camposWhereServerSide": ["PRODUTO.CODIGO", "PRODUTO.CODIGO2", "PRODUTO.DESCRICAO"],
                "where": [`${whereInicial} ${produto} ${colecao} ${grupo} ${marca} ${linha} ${status} ${etiqueta} ${statusProduto}`],
                // "innerjoin": [{ "tabela": "PA_ITEN", "condicao": "PA_ITEN.CODIGO = PRODUTO.CODIGO" }],
                "groupBy": ["PRODUTO.CODIGO", "PRODUTO.CODIGO2", "PRODUTO.IMAGEM4", "PRODUTO.DESCRICAO", "PRODUTO.PRECO"],
                "orderBy": [`${ordenacaoPesquisa == '' ? 'PRODUTO.CODIGO' : ordenacaoPesquisa}`]
            };
            const order = orderTable.length <= 0 ? [0, 'asc'] : orderTable

            $("#tabelaCadProduto").DataTable({
                destroy: true,
                lengthChange: false,
                serverSide: true,
                processing: true,
                order: [order],
                ajax: {
                    url: `${getCookie('protocolo')}://${getCookie(
                        "ip_api"
                    )}/sisplan/funcoes/v1/pesquisadatatable`,
                    type: "POST",
                    headers: { Authorization: BASIC_AUTH },
                    data: {
                        EMPRESA: getCookie("empresa"),
                        JSON: JSON.stringify(objPesquisa),
                        CLIENTE: "S",
                    },
                    error: function (xhr, error, thrown) {
                        console.error("Erro no AJAX:", xhr.responseText);
                    }
                },
                language: {
                    sEmptyTable: "Nenhum registro encontrado",
                    sInfo: "_TOTAL_ registros",
                    sInfoEmpty: " 0 registros",
                    sInfoFiltered: "(Filtrados de _MAX_ registros)",
                    sInfoPostFix: "",
                    sInfoThousands: ".",
                    sLengthMenu: "_MENU_ resultados",
                    sLoadingRecords: "Carregando...",
                    sProcessing: "Processando...",
                    sZeroRecords: "Nenhum registro encontrado",
                    sSearch: "Pesquisar",
                    oPaginate: {
                        sNext: "Próximo",
                        sPrevious: "Anterior",
                        sFirst: "Primeiro",
                        sLast: "Último",
                    },
                    oAria: {
                        sSortAscending: ": Ordenar colunas de forma ascendente",
                        sSortDescending: ": Ordenar colunas de forma descendente",
                    },
                },
                columnDefs: [
                    {
                        targets: [0], render: function (data, type, row) {
                            return retornaBotaoOpcoes(row[0]);
                        }
                    },
                    {
                        targets: [2], render: function (data, type, row, meta) {
                            const codigo = row[0];
                            const tipo = row[5];
                            buscaFotoProduto(codigo, tipo);
                            const codigoCriptografado = criptografaCodigo('img_prod_' + codigo + '_' + tipo);
                            return `<img id="${codigoCriptografado}" src="dist/img/prod-1.png" loading="lazy" alt="${data}" height="75" width="75"/>`
                        }
                    },
                    {
                        targets: [4], render: function (data, type, row, meta) {
                            const preco = (Math.round(row[4])).toFixed(2);
                            return preco == "NaN" ? row[4] : preco;

                        }
                    }

                ]
            });

            let tabelaProduto = $('#tabelaCadProduto').DataTable();
            tabelaProduto.on('draw.dt', function () {
                const info = tabelaProduto.page.info();
                const paginaAtual = info.page + 1;

                if (paginaAtual === info.pages) {
                    if ((info.end - info.start) < 10) {
                        $('.dropDownProduto').each((i, t) => {
                            $($('.dropDownProduto')[i]).addClass('dropProduto');
                        });
                    }
                }
            });

            // if (bBotao) {
            //     response = await requisicao('GET', '/Sisplan/Funcoes/V1/pesquisa?', `JSON={ "tabela":"produto", "camposSelect":[ "PRODUTO.CODIGO", "PRODUTO.DESCRICAO, PA_ITEN.TIPO"], "where": ["1=1 ${produto} ${colecao} ${grupo} ${marca}"], "innerJoin": [{"tabela": "PA_ITEN", "condicao": "PA_ITEN.CODIGO = PRODUTO.CODIGO "}], "groupBy": ["PRODUTO.codigo", "PRODUTO.descricao", "PA_ITEN.tipo"]}`, null);
            // } else {
            //     response = await requisicao('GET', '/Sisplan/Funcoes/V1/pesquisa?', `JSON={ "tabela":"produto", "camposSelect":[ "PRODUTO.CODIGO", "PRODUTO.DESCRICAO, PA_ITEN.TIPO"], "where": ["1=1"], "innerJoin": [{"tabela": "PA_ITEN", "condicao": "PA_ITEN.CODIGO = PRODUTO.CODIGO "}], "groupBy": ["PRODUTO.codigo", "PRODUTO.descricao", "PA_ITEN.tipo"], "limit": 100000}`, null);
            // }

            // if (!response) {
            //     $.LoadingOverlay("hide");
            //     return;
            // }

            // let jsonStr = await response.json();
            // if (response.status != 200) {
            //     $.LoadingOverlay("hide");
            //     msgErro(jsonStr.RESULT[0].mensagem);
            //     return;
            // }

            // $('#tabelaCadProduto').DataTable({
            //     destroy: true,
            //     lengthChange: false,
            //     serverside: true,
            //     "language": {
            //         "sEmptyTable": "Nenhum registro encontrado",
            //         "sInfo": "_TOTAL_ registros",
            //         "sInfoEmpty": " 0 registros",
            //         "sInfoFiltered": "(Filtrados de _MAX_ registros)",
            //         "sInfoPostFix": "",
            //         "sInfoThousands": ".",
            //         "sLengthMenu": "_MENU_ resultados",
            //         "sLoadingRecords": "Carregando...",
            //         "sProcessing": "Processando...",
            //         "sZeroRecords": "Nenhum registro encontrado",
            //         "sSearch": "Pesquisar",
            //         "oPaginate": {
            //             "sNext": "Próximo",
            //             "sPrevious": "Anterior",
            //             "sFirst": "Primeiro",
            //             "sLast": "Último"
            //         },
            //         "oAria": {
            //             "sSortAscending": ": Ordenar colunas de forma ascendente",
            //             "sSortDescending": ": Ordenar colunas de forma descendente"
            //         }
            //     },

            //     "autoWidth": true,
            //     "data": jsonStr.RESULT[0],
            //     "columns": [{
            //         "data": "CODIGO"
            //     },
            //     {
            //         "data": "DESCRICAO"
            //     },
            //     {
            //         "data": null
            //     },
            //     ],
            //     "columnDefs": [{
            //         "targets": -1,
            //         "data": null,
            //         className: "tdBtnOpcoes",
            //         "defaultContent": retornaBotaoOpcoes()
            //     }]
            // });

            $('#tabelaCadProduto').on('click', '#btn-editar', async function () {
                if (permissaoUsuarioLogado.ALTERA == 'S') {
                    let data = $('#tabelaCadProduto').DataTable().row($(this).parents('tr')).data();
                    let registroLiberado = await verificarRegistro('PRODUTO', data[0]);
                    if (registroLiberado) {
                        window.location.href = `produto/${criptografaUrl(data[0])}`;
                    }
                } else {
                    msgAlertaSemConfirmacao("Sem permissão para alterar!");
                }
            });

            $('#tabelaCadProduto').on('dblclick', 'tr', async function () {
                if (permissaoUsuarioLogado.ALTERA == 'S') {
                    let data = $('#tabelaCadProduto').DataTable().row($(this)).data();
                    let registroLiberado = await verificarRegistro('PRODUTO', data[0]);
                    if (registroLiberado) {
                        window.location.href = `produto/${criptografaUrl(data[0])}`;
                    }
                } else {
                    msgAlertaSemConfirmacao("Sem permissão para alterar!");
                }
            });

            $('#tabelaCadProduto').on('click', 'tr td', async function () {
                if ($(this).index() == 2) {
                    $('.imagepreview').attr('src', $(this).find('img').attr('src'));
                    $('#imagemodal').modal('show');
                    $('#imagemodal').css('z-index', '999999')
                }
            })

            $.LoadingOverlay("hide");
        } catch (error) {
            $.LoadingOverlay("hide");
            console.error(error);
            msgErro(`Não foi possível buscar os dados do produto`);
        }
    }

    async function buscaFotoProduto(codigo, tipo) {
        const codigoFormatado = criptografaCodigo('img_prod_' + codigo + '_' + tipo);
        try {
            const urlRequisicao = '/Sisplan/Funcoes/v1/FotoItem?';
            const response = await requisicao('GET', urlRequisicao, `codigo=${codigo}`, null);

            if (!response) {
                return;
            }
            const jsonStr = await response.json();
            if (response.status != 200) {
                $(`#${codigoFormatado}`).attr('src', `${BASE_URI}/dist/img/prod-1.png`);
                return;
            }

            const sBase64 = jsonStr;
            $(`#${codigoFormatado}`).attr('src', `data:image/png;base64,${sBase64.mensagem}`);

        } catch (error) {
            console.error(error);
            $(`#${codigoFormatado}`).attr('src', `${BASE_URI}/dist/img/prod-1.png`);
        }
    }

    $('#tabelaCadProduto').on('click', '#btn-excluir', async function () {
        if (permissaoUsuarioLogado.EXCLUI == 'S') {
            msgAlerta('Você realmente deseja excluir esse registro?', async () => {
                const data = $('#tabelaCadProduto').DataTable().row($(this).parents('tr')).data();
                await excluiRegistro(data[0]);
            });
        } else {
            msgAlertaSemConfirmacao("Sem permissão para excluir!");
        }
    });

    async function excluiRegistro(codigo) {
        try {
            $.LoadingOverlay("show");
            try {
                let response = await requisicao("DELETE", "/Sisplan/Cadastros/v1/produto?", `CODIGOPRODUTO=${encodeURIComponent(codigo)}`, null);
                if (!response) {
                    return;
                }
                if (response.status != 200) {
                    let jsonStr = await response.json();
                    msgErro(jsonStr.mensagem);
                    return;
                }

                toastr.success("Exclusão efetuada com sucesso!", "Confirmação", {
                    toastClass: "success",
                    iconClasses: {
                        error: "alert-error",
                        info: "alert-info",
                        success: "alert-success",
                        warning: "alert-warning",
                    },
                    positionClass: "toast-top-center",
                    progressBar: true,
                    timeOut: 3000,
                    fadeOut: 1000,
                    onHidden() {
                        window.location.reload();
                    },
                }).css({
                    "margin-top": "20%",
                    width: "500px",
                    "max-width": "500px",
                });

            } catch (error) {
                console.error(error);
            }
        } finally {
            $.LoadingOverlay("hide");
        }
    }

    let guardaLinha;

    $('#tabelaCadProduto').on('click', '#btnRelacionarProdutos', async function () {
        const data = $('#tabelaCadProduto').DataTable().rows($(this).closest('tr')).data();
        $('#txtCodigoProdutoPai').val(data[0][0])
        $('#modalRelacionarProduto').modal('show');
    })

    // barra
    $('#tabelaCadProduto').on('click', '#btn-barra', async function () {
        if (permissaoUsuarioLogado.INCLUI == 'S') {
            // ao dar o click ele vai consultar as barras
            let data = $('#tabelaCadProduto').DataTable().rows($(this).closest('tr')).data();
            guardaLinha = $(this).closest('tr');
            let jsonBarra;
            $('#txtCodigoProduto').val(data[0][0]);
            $('#txtDescricaoProduto').val(data[0][3]);
            jsonBarra = await buscaBarras(data[0][0], '1');

            for (let i = 0; i < jsonBarra[0].length; i++) {
                jsonBarra[0][i].BARRA =
                    `
                <input type="text" style="width: 15em;" value="${jsonBarra[0][i].BARRA}" class="input-default focus form-control txtBarraIten" name="txtBarraIten">
                
                `;
                jsonBarra[0][i].BARRA28 =
                    `
                    <input type="text" style="width: 15em;" value="${jsonBarra[0][i].BARRA28}" class="input-default focus form-control txtBarra28" name="txtBarra28">
                    
                `;
                jsonBarra[0][i].BARRACLI =
                    `
                    <input type="text" style="width: 15em;" value="${jsonBarra[0][i].BARRACLI}" class="input-default focus form-control txtBarracli" name="txtBarracli">
                    
                `;
                jsonBarra[0][i].CUSTO =
                    `
                    <input type="number" style="width: 6em;" value="${jsonBarra[0][i].CUSTO ?? 0}" class="input-default focus form-control txtCusto" name="txtCusto">
                    
                `;
                jsonBarra[0][i].PRECO_REPOS =
                    `
                    <input type="number" style="width: 6em;" value="${jsonBarra[0][i].PRECO_REPOS ?? 0}" class="input-default focus form-control txtPrecoRepos" name="txtPrecoRepos">
                    
                `;
                jsonBarra[0][i].PRECO_COM =
                    `
                    <input type="number" style="width: 6em;" value="${jsonBarra[0][i].PRECO_COM ?? 0}" class="input-default focus form-control txtPrecoCom" name="txtPrecoCom">
                    
                `;
                jsonBarra[0][i].PRECO_VEN =
                    `
                    <input type="number" style="width: 6em;" value="${jsonBarra[0][i].PRECO_VEN ?? 0}" class="input-default focus form-control txtPrecoVen" name="txtPrecoVen">
                    
                `;
            }

            let dataSetCols = [];

            let keys = Object.keys(jsonBarra[0][0]);

            // eslint-disable-next-line no-restricted-syntax
            for (let k in keys) {
                dataSetCols.push({
                    'title': keys[k],
                    'data': keys[k]
                });
            }

            let rowDuplicado = []

            for (let j = 0; j < jsonBarra[0].length; j++) {
                for (let i = j + 1; i < jsonBarra[0].length; i++) {
                    if (jsonBarra[0][j].COR == jsonBarra[0][i].COR && jsonBarra[0][j].TAM == jsonBarra[0][i].TAM) {
                        rowDuplicado.push(i);
                    }
                }
            }

            const duplicados = rowDuplicado.filter(function (itens, pos) {
                return rowDuplicado.indexOf(itens) == pos;
            })

            tabelaBarra = $('#tabelaBarra').DataTable({
                paging: false,
                filter: false,
                info: true,
                order: true,
                destroy: true,
                "language": {
                    "sEmptyTable": "Nenhum registro encontrado",
                    "sInfo": "_TOTAL_ registros",
                    "sInfoEmpty": " 0 registros",
                    "sInfoFiltered": "(Filtrados de _MAX_ registros)",
                    "sInfoPostFix": "",
                    "sInfoThousands": ".",
                    "sLengthMenu": "_MENU_ resultados",
                    "sLoadingRecords": "Carregando...",
                    "sProcessing": "Processando...",
                    "sZeroRecords": "Nenhum registro encontrado",
                    "sSearch": "Pesquisar",
                    "oPaginate": {
                        "sNext": "Próximo",
                        "sPrevious": "Anterior",
                        "sFirst": "Primeiro",
                        "sLast": "Último"
                    },
                    "oAria": {
                        "sSortAscending": ": Ordenar colunas de forma ascendente",
                        "sSortDescending": ": Ordenar colunas de forma descendente"
                    }
                },
                "data": jsonBarra[0],
                "columns": dataSetCols,
                "columnDefs": [{
                    "targets": [0, 1, 2, 3, 11, 12, 13, 14, 15, 16, 17],
                    "visible": false
                }],
                autoWidth: true,
            });

            if (duplicados.length > 0) {
                $('#tabelaBarra').DataTable().rows([duplicados.toString()]).remove().draw(false);
            }

            $('#modalBarra').modal('show');
        } else {
            msgAlertaSemConfirmacao("Sem permissão para incluir!");
        }
    });

    $("#modalBarra").on("shown.bs.modal", function () {
        $("#tabelaBarra").DataTable().columns.adjust().draw(false);
    });

    async function abreProdutosFilhosRelacionados(data) {
        try {
            $.LoadingOverlay('show');
            const url = '/sisplan/produto/v1/produtos_filhos_relacionados?';
            const response = await requisicao('GET', url, `ID=${data.ID}`, '', 30000);

            if (!response) {
                return;
            };
            $('.divProdutosFilhos').removeClass('d-none');
            if (response.status != 200) {
                await criaTabelaProdutosFilhosRelacionados();
                return;
            }

            const jsonStr = await response.json();
            if (!jsonStr.produtos) {
                await criaTabelaProdutosFilhosRelacionados();
                return;
            }

            const produtos = jsonStr.produtos.map((prod) => {
                return {
                    ID: prod.id,
                    CODIGO: prod.codigo,
                    DESCRICAO: prod.desc_Prod,
                    COR: prod.cor,
                    DESC_COR: prod.desc_Cor,
                    TAM: prod.tam,
                    QUANTIDADE: prod.quantidade,
                    ORDEM: prod.ordem,
                    OPCOES: retornaBotaoOpcoesRelacionamentoFilhos()
                }
            })

            await criaTabelaProdutosFilhosRelacionados(produtos);

        } finally {
            $.LoadingOverlay('hide');
        }
    }

    async function criaTabelaProdutosFilhosRelacionados(data) {

        if ($.fn.DataTable.isDataTable("#tabelaProdutosFilhosRelacionados")) {
            $('#tabelaProdutosFilhosRelacionados').DataTable().destroy();
            $('#tabelaProdutosFilhosRelacionados').empty();
        }

        let objetoTabela = {
            paging: false,
            filter: false,
            info: false,
            order: false,
            destroy: true,
            language: {
                sEmptyTable: 'Nenhum registro encontrado',
                sInfo: '_TOTAL_ registros',
                sInfoEmpty: ' 0 registros',
                sInfoFiltered: '(Filtrados de _MAX_ registros)',
                sInfoPostFix: '',
                sInfoThousands: '.',
                sLengthMenu: '_MENU_ resultados',
                sLoadingRecords: 'Carregando...',
                sProcessing: 'Processando...',
                sZeroRecords: 'Nenhum registro encontrado',
                sSearch: 'Pesquisar',
                oPaginate: {
                    sNext: 'Próximo',
                    sPrevious: 'Anterior',
                    sFirst: 'Primeiro',
                    sLast: 'Último',
                },
                oAria: {
                    sSortAscending: ': Ordenar colunas de forma ascendente',
                    sSortDescending: ': Ordenar colunas de forma descendente',
                },
            },
            columns: columnsProdutosFilhosRelacionados,
            columnDefs: [
                {
                    targets: [2], // índice da coluna que você quer definir o tamanho
                    width: "250px",

                }
            ]
        }
        if (data) {
            objetoTabela = { ...objetoTabela, data: data }
        }

        $('#tabelaProdutosFilhosRelacionados').DataTable(objetoTabela);

        $('.btnDeletarOpcoesFilhos').on('click', function () {
            try {
                msgAlerta('Você realmente deseja excluir esse registro?', async () => {
                    const dados = $('#tabelaProdutosFilhosRelacionados').DataTable().row($(this).parents('tr')).data();

                    const url = '/sisplan/produto/v1/produto_filho_relacionado?';
                    const response = await requisicao('DELETE', url, `ID=${dados.ID}`, '', 15000);

                    if (!response) {
                        return;
                    }

                    if (response.status != 200) {
                        const jsonStr = await response.json();
                        msgErro(jsonStr.mensagem);
                        return;
                    }
                    criaMensagemSucesso('Produto deletado do relacionamento!');

                    const dadosProdutoPai = $("#tabelaProdutosPaisRelacionados").DataTable().row(".selected").data()
                    $('#txtOrdemItensFilho').val('0')
                    await abreProdutosFilhosRelacionados(dadosProdutoPai)
                });
            } catch (error) {
                console.error(error);
            }
        });

        $('#tabelaProdutosFilhosRelacionados tbody').on('click', 'tr', async function () {
            if ($(this).hasClass('selected')) {
                $(this).removeClass('selected');
                $('#txtOrdemItensFilho').val(0);
            } else {
                $('#tabelaProdutosFilhosRelacionados').DataTable().$('tr.selected').removeClass('selected');
                $(this).addClass('selected');
                const data = $('#tabelaProdutosFilhosRelacionados').DataTable().row(this.rowIndex - 1).data();
                $('#txtOrdemItensFilho').val(data.ORDEM);
            }
        });
    }

    async function criaTabelaProdutosPaisRelacionados(data) {

        if ($.fn.DataTable.isDataTable("#tabelaProdutosPaisRelacionados")) {
            $('#tabelaProdutosPaisRelacionados').DataTable().destroy();
            $('#tabelaProdutosPaisRelacionados').empty();
        }
        if ($.fn.DataTable.isDataTable("#tabelaProdutosFilhosRelacionados")) {
            $('#tabelaProdutosFilhosRelacionados').DataTable().destroy();
            $('#tabelaProdutosFilhosRelacionados').empty();
        }

        let objetoTabela = {
            paging: false,
            filter: false,
            info: false,
            order: false,
            destroy: true,
            scrollX: '250px',
            scrollY: '150px',
            language: {
                sEmptyTable: 'Nenhum registro encontrado',
                sInfo: '_TOTAL_ registros',
                sInfoEmpty: ' 0 registros',
                sInfoFiltered: '(Filtrados de _MAX_ registros)',
                sInfoPostFix: '',
                sInfoThousands: '.',
                sLengthMenu: '_MENU_ resultados',
                sLoadingRecords: 'Carregando...',
                sProcessing: 'Processando...',
                sZeroRecords: 'Nenhum registro encontrado',
                sSearch: 'Pesquisar',
                oPaginate: {
                    sNext: 'Próximo',
                    sPrevious: 'Anterior',
                    sFirst: 'Primeiro',
                    sLast: 'Último',
                },
                oAria: {
                    sSortAscending: ': Ordenar colunas de forma ascendente',
                    sSortDescending: ': Ordenar colunas de forma descendente',
                },
            },
            columns: columnsProdutosRelacionados,
        }
        if (data) {
            objetoTabela = { ...objetoTabela, data: data }
        }

        $('#tabelaProdutosPaisRelacionados').DataTable(objetoTabela);

        $('#tabelaProdutosPaisRelacionados tbody').on('click', 'tr', async function () {
            if ($(this).hasClass('selected')) {
                $(this).removeClass('selected');
            } else {
                $('#tabelaProdutosPaisRelacionados').DataTable().$('tr.selected').removeClass('selected');
                $(this).addClass('selected');
                const data = $('#tabelaProdutosPaisRelacionados').DataTable().row(this.rowIndex - 1).data();
                await abreProdutosFilhosRelacionados(data)
            }
        });

        $('.btnDeletarOpcoesPais').on('click', function () {
            try {
                msgAlerta('Você realmente deseja excluir esse registro?', async () => {
                    const dados = $('#tabelaProdutosPaisRelacionados').DataTable().row($(this).parents('tr')).data();

                    const url = '/sisplan/produto/v1/produto_pai_relacionado?';
                    const response = await requisicao('DELETE', url, `ID=${dados.ID}`, '', 15000);

                    if (!response) {
                        return;
                    }

                    if (response.status != 200) {
                        const jsonStr = await response.json();
                        msgErro(jsonStr.mensagem);
                        return;
                    }
                    criaMensagemSucesso('Produto deletado do relacionamento!');

                    await abreProdutosPaisRelacionados()
                });
            } catch (error) {
                console.error(error);
            }
        });

        if ($('#tabelaProdutosPaisRelacionados').DataTable().rows().count() === 1) {
            $($('#tabelaProdutosPaisRelacionados tbody tr')[0]).trigger('click')
        }

        $('#txtCorPaiRelacionamento').autocompleta(1, `JSON={ "tabela":"pa_iten", "camposSelect":["PA_ITEN.COR CHAVE, CADCOR.DESCRICAO"], "leftjoin": [{ "tabela" : "cadcor", "condicao" : "pa_iten.cor = cadcor.cor" }], "groupBy": ["pa_iten.cor", "cadcor.descricao"], "where": ["PA_ITEN.CODIGO = '${$('#txtCodigoProdutoPai').val()}'"] }`, [], [], []);
        $('#txtTamanhoPaiRelacionamento').autocompleta(1, `JSON={ "tabela":"pa_iten", "camposSelect":["TABTAM.ID_TAM CHAVE, TABTAM.TAM DESCRICAO"], "leftjoin": [{ "tabela" : "TABTAM", "condicao" : "pa_iten.TAM = TABTAM.TAM" }], "groupBy": ["TABTAM.ID_TAM", "TABTAM.TAM"], "where": ["PA_ITEN.CODIGO = '${$('#txtCodigoProdutoPai').val()}'"] }`, [], [], []);
        $('#btn-CorPaiRelacionamento').pesquisa('#txtCorPaiRelacionamento', 'COR', 'DESCRICAO', `/sisplan/funcoes/v1/pesquisa?JSON={ "tabela":"pa_iten", "camposSelect":[ "PA_ITEN.COR COR", "CADCOR.DESCRICAO DESCRICAO" ],"leftjoin": [{ "tabela" : "cadcor", "condicao" : "pa_iten.cor = cadcor.cor" }], "groupBy": ["pa_Iten.cor", "cadcor.descricao"], "where": ["PA_ITEN.CODIGO = '${$('#txtCodigoProdutoPai').val()}'"]}`, 'Pesquisa Cor', 'CADCOR');
        $('#btn-TamanhoPaiRelacionamento').pesquisa('#txtTamanhoPaiRelacionamento', 'ID_TAM', 'TAM', `/sisplan/funcoes/v1/pesquisa?JSON={ "tabela":"PA_ITEN", "camposSelect":[ "TABTAM.ID_TAM", "TABTAM.TAM" ],"leftjoin": [{ "tabela" : "TABTAM", "condicao" : "pa_iten.TAM = TABTAM.TAM" }], "groupBy": ["TABTAM.ID_TAM", "TABTAM.TAM"], "where": ["PA_ITEN.CODIGO = '${$('#txtCodigoProdutoPai').val()}'"]}`, 'Pesquisa Tamanho', 'TABTAM');

    }

    $('#btnAdicionarProdutoPai').on('click', async function () {
        const corPai = pegaChave('#txtCorPaiRelacionamento')
        const tamPai = pegaChave('#txtTamanhoPaiRelacionamento')
        if (corPai === '') {
            msgAlerta('Cor não informada!')
            return;
        }
        if (tamPai === '') {
            msgAlerta('Tamanho não informado!')
            return;
        }

        const objeto = {
            Id_Prod: 0,
            Id: 0,
            Id_Cor: 0,
            Id_Tam: tamPai,
        }

        const url = '/sisplan/produto/v1/produto_pai_relacionado?';
        const response = await requisicao('POST', url, `CODIGO=${$('#txtCodigoProdutoPai').val()}&COR=${corPai}`, JSON.stringify(objeto), 30000);

        if (!response) {
            return;
        };

        if (response.status != 200) {
            msgAlerta(`Erro ao gravar relacionamento`);
            return;
        }

        // const jsonStr = await response.json();

        await abreProdutosPaisRelacionados();
        criaMensagemSucesso('Produto Pai adicionado com sucesso!');

    })

    $('#btnAdicionarProdutoFilho').on('click', async function () {
        if ($("#tabelaProdutosPaisRelacionados").DataTable().rows(".selected").count() == 0) {
            msgAlerta('Nenhum produto pai selecionado!');
            return;
        }

        const dadosProdutoPai = $("#tabelaProdutosPaisRelacionados").DataTable().row(".selected").data()
        const corFilho = pegaChave('#txtCorFilhoRelacionamento')
        const tamFilho = pegaChave('#txtTamanhoFilhoRelacionamento')
        const produtoFilho = pegaChave('#txtProdutoFilhoRelacionamento')
        const qtdeFilho = parseInt($('#txtQuantidadeFilho').val())
        const dataFilhos = $("#tabelaProdutosFilhosRelacionados").DataTable().rows().data().toArray();
        const ordem = []
        dataFilhos.forEach((data) => ordem.push(data.ORDEM))

        const ordemFilho = $('#txtOrdemItensFilho').val() == '0' ? ordem.length === 0 ? 1 : Math.max(...ordem) + 1 : parseInt($('#txtOrdemItensFilho').val());

        if (corFilho === '') {
            msgAlerta('Cor não informada!')
            return;
        }
        if (tamFilho === '') {
            msgAlerta('Tamanho não informado!')
            return;
        }
        if (produtoFilho === '') {
            msgAlerta('Produto não informado!')
            return;
        }
        if (!qtdeFilho || qtdeFilho == 0) {
            msgAlerta('Quantidade não informada!')
            return;
        }

        const objeto = {
            Id_Prod: 0,
            Id: 0,
            Id_Cor: 0,
            Id_Tam: tamFilho,
            Id_Pai: dadosProdutoPai.ID,
            Quantidade: qtdeFilho,
            Ordem: ordemFilho
        }

        const url = '/sisplan/produto/v1/produto_filho_relacionado?';
        const response = await requisicao('POST', url, `CODIGO=${pegaChave('#txtProdutoFilhoRelacionamento')}&COR=${corFilho}`, JSON.stringify(objeto), 30000);

        if (!response) {
            return;
        };

        if (response.status != 200) {
            msgAlerta(`Erro ao gravar relacionamento`);
            return;
        }

        // const jsonStr = await response.json();

        // $('#tabelaProdutosFilhosRelacionados').DataTable().row.add({
        //     ID: jsonStr.id,
        //     CODIGO: jsonStr.id_Prod,
        //     DESCRICAO: jsonStr.desc_Prod,
        //     COR: jsonStr.id_Cor,
        //     DESC_COR: jsonStr.desc_Cor,
        //     TAM: jsonStr.id_Tam,
        //     QUANTIDADE: jsonStr.quantidade,
        //     ORDEM: jsonStr.ordem,
        //     OPCOES: retornaBotaoOpcoesRelacionamentoFilhos()
        // }).draw(false)

        await abreProdutosFilhosRelacionados(dadosProdutoPai)

        criaMensagemSucesso('Produto adicionado ao relacionamento com sucesso!');
    })

    $('#btnConfirmarRelacionamento').on('click', async function () {
        $('#modalRelacionarProduto').modal('hide');
    })

    $("#modalRelacionarProduto").on("hidden.bs.modal", async function () {
        limpaValor('#txtCorFilhoRelacionamento');
        limpaValor('#txtProdutoFilhoRelacionamento');
        limpaValor('#txtTamanhoFilhoRelacionamento');
        $('#txtCodigoProdutoPai').val('');
        $('.divProdutosFilhos').addClass('d-none');
    });

    async function abreProdutosPaisRelacionados() {
        try {
            $.LoadingOverlay('show');
            const url = '/sisplan/produto/v1/produtos_relacionados?';
            const response = await requisicao('GET', url, `CODIGO=${$('#txtCodigoProdutoPai').val()}`, '', 30000);

            if (!response) {
                return;
            };

            if (response.status != 200) {
                await criaTabelaProdutosPaisRelacionados();
                return;
            }

            const jsonStr = await response.json();

            if (!jsonStr.produtos) {
                await criaTabelaProdutosPaisRelacionados();
                return;
            }

            const produtos = jsonStr.produtos.map((prod) => {
                return {
                    ID: prod.id,
                    CODIGO: prod.codigo,
                    DESCRICAO: prod.desc_Prod,
                    COR: prod.cor,
                    DESC_COR: prod.desc_Cor,
                    TAM: prod.tam,
                    OPCOES: retornaBotaoOpcoesRelacionamentoPais()
                }
            })

            await criaTabelaProdutosPaisRelacionados(produtos);

        } finally {
            $.LoadingOverlay('hide');
        }
    }

    $("#modalRelacionarProduto").on("shown.bs.modal", async function () {
        await abreProdutosPaisRelacionados()
    });

    async function consultaCor(codigoProduto) {
        const pesquisaParam = {
            tabela: 'PA_ITEN',
            camposSelect: ['DISTINCT PA_ITEN.COR'],
            where: [`PA_ITEN.CODIGO = '${codigoProduto}'`],
            innerJoin: [{ tabela: "CADCOR", condicao: "PA_ITEN.COR = CADCOR.COR" }]
        };
        const jsonStr = await retornaJsonPesquisaPadrao(JSON.stringify(pesquisaParam));

        if (jsonStr.length == 0) {
            return;
        };

        const listaCores = [];

        for (i in jsonStr) {
            listaCores.push(jsonStr[i].COR);
        };

        const listaFormatada = await formataListas(listaCores.toString());

        return listaFormatada
    };

    async function recarregaBarras(linha) {
        // ao dar o click ele vai consultar as barras
        let data = $('#tabelaCadProduto').DataTable().rows(linha).data();
        let jsonBarra;
        $('#txtCodigoProduto').val(data[0][0]);
        $('#txtDescricaoProduto').val(data[0][1]);
        jsonBarra = await buscaBarras(data[0][0], data[0][5]);

        let dataSetCols = [];

        let keys = Object.keys(jsonBarra[0][0]);

        // eslint-disable-next-line no-restricted-syntax
        for (let k in keys) {
            dataSetCols.push({
                'title': keys[k],
                'data': keys[k]
            });
        }

        for (let i = 0; i < jsonBarra[0].length; i++) {
            jsonBarra[0][i].BARRA =
                `
            <input type="text" style="width: 15em;" value="${jsonBarra[0][i].BARRA}" class="input-default focus form-control txtBarraIten" name="txtBarraIten">
            
            `;
            jsonBarra[0][i].BARRA28 =
                `
                <input type="text" style="width: 15em;" value="${jsonBarra[0][i].BARRA28}" class="input-default focus form-control txtBarra28" name="txtBarra28">
                
            `;
            jsonBarra[0][i].BARRACLI =
                `
                <input type="text" style="width: 15em;" value="${jsonBarra[0][i].BARRACLI}" class="input-default focus form-control txtBarracli" name="txtBarracli">
                
            `;
            jsonBarra[0][i].CUSTO =
                `
                <input type="number" style="width: 6em;" value="${jsonBarra[0][i].CUSTO ?? 0}" class="input-default focus form-control txtCusto" name="txtCusto">
                
            `;
            jsonBarra[0][i].PRECO_REPOS =
                `
                <input type="number" style="width: 6em;" value="${jsonBarra[0][i].PRECO_REPOS ?? 0}" class="input-default focus form-control txtPrecoRepos" name="txtPrecoRepos">
                
            `;
            jsonBarra[0][i].PRECO_COM =
                `
                <input type="number" style="width: 6em;" value="${jsonBarra[0][i].PRECO_COM ?? 0}" class="input-default focus form-control txtPrecoCom" name="txtPrecoCom">
                
            `;
            jsonBarra[0][i].PRECO_VEN =
                `
                <input type="number" style="width: 6em;" value="${jsonBarra[0][i].PRECO_VEN ?? 0}" class="input-default focus form-control txtPrecoVen" name="txtPrecoVen">
                
            `;
        }

        let rowDuplicado = []

        for (let j = 0; j < jsonBarra[0].length; j++) {
            for (let i = j + 1; i < jsonBarra[0].length; i++) {
                if (jsonBarra[0][j].COR == jsonBarra[0][i].COR && jsonBarra[0][j].TAM == jsonBarra[0][i].TAM) {
                    rowDuplicado.push(i);
                }
            }
        }

        const duplicados = rowDuplicado.filter(function (itens, pos) {
            return rowDuplicado.indexOf(itens) == pos;
        })

        tabelaBarra = $('#tabelaBarra').DataTable({
            paging: false,
            filter: false,
            info: true,
            order: true,
            destroy: true,
            autoWidth: true,
            "language": {
                "sEmptyTable": "Nenhum registro encontrado",
                "sInfo": "_TOTAL_ registros",
                "sInfoEmpty": " 0 registros",
                "sInfoFiltered": "(Filtrados de _MAX_ registros)",
                "sInfoPostFix": "",
                "sInfoThousands": ".",
                "sLengthMenu": "_MENU_ resultados",
                "sLoadingRecords": "Carregando...",
                "sProcessing": "Processando...",
                "sZeroRecords": "Nenhum registro encontrado",
                "sSearch": "Pesquisar",
                "oPaginate": {
                    "sNext": "Próximo",
                    "sPrevious": "Anterior",
                    "sFirst": "Primeiro",
                    "sLast": "Último"
                },
                "oAria": {
                    "sSortAscending": ": Ordenar colunas de forma ascendente",
                    "sSortDescending": ": Ordenar colunas de forma descendente"
                }
            },
            "data": jsonBarra[0],
            "columns": dataSetCols,
            "columnDefs": [{
                "targets": [0, 1, 2, 3, 11, 12, 13, 14, 15, 16, 17],
                "visible": false
            }]
        });

        if (duplicados.length > 0) {
            $('#tabelaBarra').DataTable().rows([duplicados.toString()]).remove().draw(false);
        }
    };

    async function buscaBarras(codigo) {
        try {
            $.LoadingOverlay('hide');
            try {
                let url = `/sisplan/funcoes/v1/pesquisa?`;
                let response = await requisicao('GET', url, `JSON={
                    "tabela": "PRODUTO",
                    "camposSelect": ["SUM(QUANTIDADE) AS QTDE", "PRODUTO.CODIGO", "PRODUTO.DESCRICAO", "PRODUTO.UNIDADE", "PA_ITEN.TIPO QUALIDADE", "PA_ITEN.COR", "CADCOR.DESCRICAO DESC_COR", "PA_ITEN.TAM",
                        "PA_ITEN.BARRA", "PA_ITEN.BARRA28", "PA_ITEN.BARRACLI", "PA_ITEN.ORDEM", "PA_ITEN.QTDE_MIN",
                        " CASE WHEN MAX(PA_ITEN.COD_PROD_CLI) IS NULL THEN '' ELSE MAX(PA_ITEN.COD_PROD_CLI) END AS COD_PROD_CLI",
                        " PA_ITEN.ATIVO", " MAX(PA_ITEN.COMPOSICAO2) COMPOSICAO2", "MAX(PA_ITEN.COMPOSICAO3) COMPOSICAO3", "PA_ITEN.QTDE_BARRA", "MAX(PA_ITEN.CUSTO) CUSTO", "MAX(PA_ITEN.PRECO_REPOS) PRECO_REPOS",
                        " MAX(PA_ITEN.PRECO_COM) PRECO_COM", "MAX(PA_ITEN.PRECO_VEN) PRECO_VEN"],
                    "where": ["PRODUTO.CODIGO = '${codigo}'"],
                    "innerJoin": [
                        { "tabela": "PA_ITEN", "condicao": "PA_ITEN.CODIGO = PRODUTO.CODIGO" },
                        { "tabela": "CADCOR", "condicao": "PA_ITEN.COR = CADCOR.COR" },
                        { "tabela": "FAIXA_ITEN", "condicao": "PRODUTO.FAIXA = FAIXA_ITEN.FAIXA AND FAIXA_ITEN.TAMANHO = PA_ITEN.TAM" }],
                    "groupby": ["PRODUTO.CODIGO", "PRODUTO.DESCRICAO", "PRODUTO.UNIDADE", "PA_ITEN.TIPO", "PA_ITEN.COR", "CADCOR.DESCRICAO", "PA_ITEN.QTDE_MIN",
                        "PA_ITEN.TAM", "PA_ITEN.BARRA", "PA_ITEN.BARRA28", "PA_ITEN.BARRACLI", "PA_ITEN.ORDEM", "PA_ITEN.QTDE_BARRA",
                        "FAIXA_ITEN.POSICAO", "PA_ITEN.ATIVO"],
                    "orderby": ["PA_ITEN.ORDEM", "PA_ITEN.COR", "FAIXA_ITEN.POSICAO"]
                }`, null, 20000);

                if (!response) {
                    return;
                }

                let jsonStr = await response.json();
                if (response.status != 200) {
                    msgErro(jsonStr.RESULT[0].mensagem);
                    return;
                }

                return jsonStr.RESULT;
            } catch (error) {
                console.error(error);
            }
        } finally {
            $.LoadingOverlay('hide');
        }
    }

    // confirma barra
    $('#btnConfirmarBarra').on('click', async function () {
        try {
            $.LoadingOverlay('show');
            try {
                let data = $('#tabelaBarra').DataTable().rows().data();
                const url = '/sisplan/barra/v1/gerabarra?';
                let jsonStr;
                let arrayBarra = [];
                let ProdutoBarra = {};

                for (let i = 0; i < data.length; i++) {
                    let InfoBarras = {
                        CODIGO: data[i].CODIGO,
                        COR: data[i].COR,
                        TAMANHO: data[i].TAM,
                        BARRAITEN: $('.txtBarraIten')[i].value,
                        BARRA28: $('.txtBarra28')[i].value,
                        BARRA: $('.txtBarracli')[i].value,
                        TIPO: 'P',
                        ESPECIEBARRA: 'BARRACLI',
                        CUSTO: parseFloat($('.txtCusto')[i].value).toFixed(2),
                        PRECOREPOS: parseFloat($('.txtPrecoRepos')[i].value).toFixed(2),
                        PRECOCOM: parseFloat($('.txtPrecoCom')[i].value).toFixed(2),
                        PRECOVEN: parseFloat($('.txtPrecoVen')[i].value).toFixed(2)
                    };
                    arrayBarra.push(InfoBarras);
                };
                ProdutoBarra.TIPOBARRA = 4;
                ProdutoBarra.BARRAS = arrayBarra;

                const response = await requisicao('POST', url, '', `JSON=${encodeURIComponent(JSON.stringify(ProdutoBarra))}`, 30000);

                if (!response) {
                    return;
                };

                if (response.status != 200) {
                    jsonStr = await response.json();
                    msgAlerta(jsonStr.mensagem);
                }

                await recarregaBarras(guardaLinha);

            } catch (error) {
                msgErro(error);
                console.error(error);
            }
        } finally {
            $.LoadingOverlay('hide');
        }
        $('#modalBarra').modal('hide');
    });
    // gera Ean13
    $('#btnGeraEan13').on('click', async function () {
        try {
            $.LoadingOverlay('show');
            try {
                let data = $('#tabelaBarra').DataTable().rows().data();
                const url = '/sisplan/barra/v1/gerabarra?';
                let jsonStr;
                let arrayBarra = [];
                let ProdutoBarra = {};

                for (let i = 0; i < data.length; i++) {
                    let InfoBarras = {
                        CODIGO: data[i].CODIGO,
                        COR: data[i].COR,
                        TAMANHO: data[i].TAM,
                        BARRA: data[i].BARRA,
                        TIPO: 'P',
                        ESPECIEBARRA: 'BARRA'
                    };
                    arrayBarra.push(InfoBarras);
                };
                ProdutoBarra.TIPOBARRA = 1;
                ProdutoBarra.BARRAS = arrayBarra;

                const response = await requisicao('POST', url, '', `JSON=${encodeURIComponent(JSON.stringify(ProdutoBarra))}`, 30000);

                if (!response) {
                    return;
                };

                if (response.status != 200) {
                    jsonStr = await response.json();
                    msgAlerta(jsonStr.mensagem);
                }

                await recarregaBarras(guardaLinha);

            } catch (error) {
                console.error(error);
            }
        } finally {
            $.LoadingOverlay('hide');
        }
    });
    // gera Barra128
    $('#btnGeraBarra128').on('click', async function () {
        try {
            $.LoadingOverlay('show');
            try {
                let data = $('#tabelaBarra').DataTable().rows().data();
                const url = '/sisplan/barra/v1/gerabarra?';
                let jsonStr;
                let arrayBarra = [];
                let ProdutoBarra = {};

                for (let i = 0; i < data.length; i++) {
                    let InfoBarras = {
                        CODIGO: data[i].CODIGO,
                        COR: data[i].COR,
                        TAMANHO: data[i].TAM,
                        // BARRA: data[i].BARRA28,
                        BARRA: $('.txtBarra28')[i].value,
                        TIPO: 'P',
                        ESPECIEBARRA: 'BARRA28'
                    };
                    arrayBarra.push(InfoBarras);
                };
                ProdutoBarra.TIPOBARRA = 2;
                ProdutoBarra.BARRAS = arrayBarra;

                const response = await requisicao('POST', url, '', `JSON=${encodeURIComponent(JSON.stringify(ProdutoBarra))}`, 30000);

                if (!response) {
                    return;
                };

                if (response.status != 200) {
                    jsonStr = await response.json();
                    msgAlerta(jsonStr.mensagem);
                }

                await recarregaBarras(guardaLinha);

            } catch (error) {
                console.error(error);
            }
        } finally {
            $.LoadingOverlay('hide');
        }
    });

    // $('#tabelaBarra').on('blur', '.txtBarra28', async function() {
    //     let linha = $(this).closest('tr');
    //     let index = $('#tabelaBarra').DataTable().row(linha).index();
    //     let rowData = $('#tabelaBarra').DataTable().row(index).data();

    //     let inputBarra28 = $(rowData.BARRA28)
    //     let barra28 = inputBarra28.val()
    //     await verificaUsoBarra28(barra28);
    // });

    $('#tabelaBarra').on('blur', '.txtBarra28', async function () {
        let barra28 = $(this).val();
        if (barra28 !== '' && (barra28.length < 6 || barra28.length > 9)) {
            msgAlerta("O código de barra28 deve ter entre 6 e 9 dígitos.");
            $(this).val('');
            return;
        }
        await verificaUsoBarra28(barra28)
    });

    async function verificaUsoBarra28(barra28) {
        let url = `/sisplan/funcoes/v1/pesquisa?`;
        try {
            let response = await requisicao(
                "GET",
                url,
                `JSON={ "tabela":"PA_ITEN", "camposSelect":[ "BARRA28", "CODIGO"], "where": ["BARRA28 = '${barra28}'"] }`,
                null
            );

            if (!response) {
                return;
            }

            let jsonStr = await response.json();
            if (response.status != 200) {
                msgErro(jsonStr.RESULT[0].mensagem);
                return;
            }

            if (barra28 !== '' && barra28 !== barra28) {
                msgAlerta(`A barra28: ${barra28}, já está em uso no produto ${jsonStr.RESULT[0][0].CODIGO}!`)
            }

        } catch (error) {
            console.error(error);
            msgErro("Não foi possível buscar os dados dos vencimentos.");
        }
    }

    // gera Dun14
    $('#btnGeraDun14Barra').on('click', async function () {
        try {
            $.LoadingOverlay('show');
            try {
                let data = $('#tabelaBarra').DataTable().rows().data();
                const url = '/sisplan/barra/v1/gerabarra?';
                let jsonStr;
                let arrayBarra = [];
                let ProdutoBarra = {};

                for (let i = 0; i < data.length; i++) {
                    let InfoBarras = {
                        CODIGO: data[i].CODIGO,
                        COR: data[i].COR,
                        TAMANHO: data[i].TAM,
                        BARRA: data[i].BARRACLI,
                        TIPO: 'P',
                        ESPECIEBARRA: 'BARRACLI'
                    };
                    arrayBarra.push(InfoBarras);
                };
                ProdutoBarra.TIPOBARRA = 3;
                ProdutoBarra.BARRAS = arrayBarra;

                const response = await requisicao('POST', url, '', `JSON=${encodeURIComponent(JSON.stringify(ProdutoBarra))}`, 30000);

                if (!response) {
                    return;
                };

                if (response.status != 200) {
                    jsonStr = await response.json();
                    msgAlerta(jsonStr.mensagem);
                }

                await recarregaBarras(guardaLinha);

            } catch (error) {
                console.error(error);
            }
        } finally {
            $.LoadingOverlay('hide');
        }
    });

    $("#tabelaCadProduto").on('click', "#btnAnexos", async function () {
        const data = $('#tabelaCadProduto').DataTable().row($(this).parents('tr')).data();

        await abreModalAnexos(data[0], data[3], 'PRODUTO');
    });

    $('#tabelaCadProduto').on('click', '#btnMedidas', async function () {
        const data = $('#tabelaCadProduto').DataTable().row($(this).parents('tr')).data();

        await abreModalMedidas(data[0], data[3]);
    })

    $("#tabelaCadProduto").on('click', "#btnCombProd", async function () {
        const data = $('#tabelaCadProduto').DataTable().row($(this).parents('tr')).data();

        await abreModalCombinacao(data[0], data[3]);
    });

    $("#tabelaCadProduto").on('click', "#btnHistProd", async function () {
        const data = $('#tabelaCadProduto').DataTable().row($(this).parents('tr')).data();

        await abreModalHistProd(data[0], data[3]);
    });

    $("#tabelaCadProduto").on('click', "#btnFluxoProd", async function () {
        const data = $('#tabelaCadProduto').DataTable().row($(this).parents('tr')).data();

        await abreModalFluxoProd(data[0], data[3]);

    });

    $("#tabelaCadProduto").on('click', "#btnProdItensEst", async function () {
        const data = $('#tabelaCadProduto').DataTable().row($(this).parents('tr')).data();

        await abreModalProdItensEst(data[0], data[3]);

    });

    $('#tabelaCadProduto').on('click', '#btnCadConsumo', async function () {
        const data = $('#tabelaCadProduto').DataTable().row($(this).parents('tr')).data();

        await abreCadConsumo(data[0], data[3]);
    });

    $('#tabelaCadProduto').on('click', "#btn-duplicar", async function () {
        if (permissaoUsuarioLogado.ALTERA == 'S') {
            let data = $('#tabelaCadProduto').DataTable().row($(this).parents('tr')).data();
            await duplicaCadastroProduto(data[0]);
        } else {
            msgAlertaSemConfirmacao("Sem permissão para alterar!");
        }
    });

    $('#tabelaCadProduto').on('click', "#btnImprimirFT", async function () {
        try {
            $.LoadingOverlay("show");
            const data = $('#tabelaCadProduto').DataTable().row($(this).parents('tr')).data();
            const codigoProduto = data[0];
            const coresProd = await consultaCor(codigoProduto);
            const url = `/sisplan/impressao/v1/imprimirft?CODIGO_PROD=${codigoProduto}&CORES_PROD=${coresProd}`;
            const bImprimeAutomatico = await verificaImprimirAutomatico('FichaTecnica');
            let arquivo = await GeraRelatorio(`${url}&`, "GET", 15000, false, 'FichaTecnica');
            if (arquivo != undefined) {
                if (!bImprimeAutomatico) {
                    window.open(`${BASE_URI}/relatorios_api/pdf/${arquivo}`, "_blank");
                }
                await limparRelatorios();
            }
        } finally {
            $.LoadingOverlay("hide");
        }
    });

    $('#tabelaCadProduto').on('click', '#btnPrecoFaccao', async function () {
        if (acessoFaccao.ALTERA == 'S') {
            $.LoadingOverlay('show');
            try {
                const data = $('#tabelaCadProduto').DataTable().row($(this).parents('tr')).data();
                const response = await requisicao('GET',
                    '/Sisplan/Funcoes/V1/pesquisa?',
                    `JSON={ "tabela":"PRO_FLUXO", 
                        "camposSelect":["PRO_FLUXO.PARTE", "TIPO_APL.DESCRICAO"],
                        "leftjoin": [{"tabela": "TIPO_APL", "condicao": "PRO_FLUXO.PARTE = TIPO_APL.CODIGO"}],
                        "where": ["PRO_FLUXO.CODIGO = '${data[0]}'", "TIPO_APL.ATIVO = 'S'"]}`, null);

                if (!response) {
                    return;
                }

                let jsonStr = await response.json();
                if (response.status !== 200) {
                    msgErro(jsonStr.RESULT[0].mensagem);
                    return;
                }
                jsonStr = jsonStr.RESULT[0];

                if (jsonStr.length == 0) {
                    msgErro('Esse produto não possui nenhuma parte. Impossível continuar.');
                    return;
                }

                let tabelaPadrao = await buscaParametroERP('FAC', '310', '3', '3');

                if (tabelaPadrao == '') {
                    tabelaPadrao = await buscaValor('REGIAO', 'REGIAO', 'PADRAO_PROD', 'S');
                }

                if (jsonStr.length > 1) {

                    $('#txtTabPadrao').val(tabelaPadrao);
                    $('#txtCodigoFaccao').val(data[0]);

                    $('#txtParte').html('');

                    jsonStr.map((e) => {
                        $('#txtParte').append(`<option class="drilldown-item" value="${e.PARTE}">${e.PARTE} - ${e.DESCRICAO}</option>`);
                    });

                    $('#modalPartes').modal('show');

                } else {
                    $.LoadingOverlay('show');
                    try {
                        window.location.href = `facpreco/${data[0]}#${tabelaPadrao}#${jsonStr[0].PARTE}`;
                    } finally {
                        $.LoadingOverlay('hide');
                    }
                }
            } finally {
                $.LoadingOverlay('hide');
            }
        } else {
            msgAlertaSemConfirmacao("Sem permissão para alterar!");
        }
    });

    $('#btnConfirmarPartes').on('click', async function () {
        if ($('#txtParte').val() != '') {
            $.LoadingOverlay('show');
            try {
                window.location.href = `facpreco/${$('#txtCodigoFaccao').val()}#${$('#txtTabPadrao').val()}#${$('#txtParte').val()}`;
            } finally {
                $.LoadingOverlay('hide');
            }
        } else {
            msgErro('Nenhuma parte selecionada, impossível continuar!');
            return;
        }
    });

    $('#btnFecharPartes').on('click', function () {
        $('#modalPartes').modal('hide');
    });

    async function retornaFiltros() {
        const produto = await formataListas($('#txtProduto').val().toString());
        const colecao = await formataListas($('#txtColecao').val().toString());
        const marca = await formataListas($('#txtMarca').val().toString());
        const grupo = await formataListas($('#txtGrupo').val().toString());
        const linha = await formataListas($('#txtLinha').val().toString());
        const status = await formataListas($('#txtStatus').val().toString());
        const etiqueta = await formataListas($('#txtEtiqueta').val().toString());

        const retorno =
            `PRODUTO=${produto}` +
            `&COLECAO=${colecao}` +
            `&MARCA=${marca}` +
            `&GRUPO=${grupo}` +
            `&LINHA=${linha}` +
            `&STATUS=${status}` +
            `&ETIQUETA=${etiqueta}` +
            `&ATIVO=${$('input[name=cbStatusProd]:checked').val()}`

        return retorno;
    }

    retornaHintRelatorio('btnImprimir', 'RelAcessoProduto')

    async function limpaRelatorioAcessoProd() {
        try {
            try {
                $.LoadingOverlay("show");
                let response = await requisicao(
                    "GET",
                    "/Sisplan/funcoes/v1/limparImpressos?",
                    "",
                    null
                );

                if (!response) {
                    $.LoadingOverlay("hide");
                    return;
                }

                let jsonStr = await response.json();
                if (response.status != 200) {
                    $.LoadingOverlay("hide");
                    return;
                }
            } finally {
                $.LoadingOverlay("hide");
            }
        } catch (error) {
            $.LoadingOverlay("hide");
        }

    }

    retornaHintRelatorio('btnImprimirAcessoProd', 'RelAcessoProduto')

    $('#btnImprimirAcessoProd').on('click', async function () {
        let str = $('#tabelaCadProduto_info').text();
        str = str.replace('.', '');
        let endIndex = str.indexOf(' registro');

        let contadorRegistros = parseFloat(str.substring(0, endIndex));

        if (parseFloat(contadorRegistros) > 1000) {
            msgAlerta(`Existem ${contadorRegistros} produtos filtrados, a impressão poderá demorar. Deseja Continuar?`, async () =>
                await imprimirAcessoProd()
            )
        } else {
            await imprimirAcessoProd()
        }
    });

    async function imprimirAcessoProd() {
        try {
            $.LoadingOverlay('show');
            try {
                const url = `/sisplan/impressao/v1/imprimiracessoproduto?`;
                const filtros = await retornaFiltros();
                const bImprimeAutomatico = await verificaImprimirAutomatico('RelAcessoProduto');
                const arquivo = await GeraRelatorio(`${url}${filtros}&`, 'GET', 3600000, false, 'RelAcessoProduto');
                if (arquivo != undefined) {
                    if (!bImprimeAutomatico) {
                        window.open(`${BASE_URI}/relatorios_api/pdf/${arquivo}`, '_blank');
                    }
                    await limpaRelatorioAcessoProd();
                }

            } catch (error) {
                console.error(error);
            }
        } finally {
            $.LoadingOverlay('hide');
        }
    }

    $("#tabelaCadProduto").off('click', 'th')
    $("#tabelaCadProduto").on('click', 'th', function () {
        let campoOrdenacao
        let odrdenacao

        switch ($(this).index()) {
            case 0:
            case 2:
                campoOrdenacao = 'PRODUTO.CODIGO'
                break;
            case 1:
                campoOrdenacao = 'PRODUTO.CODIGO2'
                break;
            case 3:
                campoOrdenacao = 'PRODUTO.DESCRICAO'
                break;
            case 4:
                campoOrdenacao = 'PRODUTO.PRECO'
                break
            default:
                break;
        }

        if ($(this)[0].ariaSort == 'descending') {
            odrdenacao = 'DESC'
        } else {
            odrdenacao = 'ASC'
        }

        consultaProduto(`${campoOrdenacao} ${odrdenacao}`, [$(this).index(), odrdenacao.toLowerCase() == 'desc' ? 'asc' : 'desc'])
    })

});
