$("#tutorial").on("click", function () {
  $(document).ready(async function () {
    const driver = new Driver({
      doneBtnText: "Sair",
      closeBtnText: "Fechar",
      nextBtnText: "Próximo",
      prevBtnText: "Anterior",
      allowClose: false,
    });
    driver.defineSteps([
      {
        element: "#btnFiltros",
        popover: {
          title: "Botão Filtros",
          description: "Clique aqui para iniciar filtrar a consulta.",
          position: "right",
        },
      },
      {
        element: "#btnNovoPreco",
        popover: {
          title: "Botão Incluir",
          description:
            "Clique aqui para iniciar o cadastro de um produto na tabela de preço.",
          position: "right",
        },
      },
      {
        element: "#tabelaPreco",
        popover: {
          title: "Tabela Preços",
          description: "Aqui estão todos os preços cadastrados.",
          position: "top",
        },
      },
    ]);
    driver.start();
  });
});

$(document).ready(async function () {
  const permissaoUsuarioLogado = await permissaoAcessos("TABELAPRECO");

  $("#txtTabPreco").autocompleta(1, `JSON={ "tabela":"REGIAO", "camposSelect":[ "REGIAO chave", "descricao descricao"], "where": null}`);
  $("#txtProduto").autocompleta(1, `JSON={ "tabela":"produto", "camposSelect":[ "codigo chave", "descricao descricao"], "where": null}`);

  $("#btnTabPreco").pesquisa("#txtTabPreco", "REGIAO", "DESCRICAO", `/sisplan/funcoes/v1/pesquisa?JSON={"tabela":"REGIAO", "camposSelect":[ "REGIAO", "DESCRICAO"]}`, "Pesquisa Tabela de Preço", "regiao");
  $("#btnProduto").pesquisa("#txtProduto", "CODIGO", "DESCRICAO", `/sisplan/funcoes/v1/pesquisa?JSON={"tabela":"produto", "camposSelect":[ "CODIGO", "DESCRICAO"]}`, "Pesquisa Produto", "produto");

  $("#btnExcluiProduto").on("click", function () {
    $("#txtProduto").val("");
  });

  $("#btnExcluiTabPreco").on("click", function () {
    $("#txtTabPreco").val("");
  });

  $("#btnFiltros").on("click", function () {
    $("#modal-filtros").modal("show");
  });

  function retornaBotaoOpcoes() {
    return (
      '<div class="divBtnOpcoes"> ' +
      '    <button class="botaoOpcoes" type="button" title="Editar" id="btn-editar"><span class="fas fa-edit" style="color:green"></span></button>      ' +
      '    <button class="botaoOpcoes" type="button" title="Excluir" id="btn-excluir"><span class="fas fa-trash-alt" style="color:red"></span></button>  ' +
      "   </div>"
    );
  }

  function retornaBotaoOpcoes(data) {
    var retorno = '<div style="text-align:start;"> ' +
      '    <button class="btn btn-info btn-sm dropdown-toggle btnVerificaOpcoes" type="button" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false"> ' +
      '      ' + data + ' ' +
      '    </button> ' +
      '    <div class="dropdown-menu"> ' +
      '    <button class="dropdown-item" type="button" title="Editar" id="btn-editar">Editar</button>     ' +
      '    <button class="dropdown-item" type="button" title="Excluir" id="btn-excluir">Excluir</button>  ' +
      '</div>';
    return retorno;
  };

  consultaPreco();

  $("#btnConsultar").on("click", async function () {
    $("#modal-filtros").modal("hide");
    await consultaPreco(true);
  });

  retornaHintRelatorio('btnImprimir', 'RelPreco')
  preencheOrdenacaoTela('AcessoPreco')

  $('#btnImprimir').on('click', async function () {
    try {
      $.LoadingOverlay('show');

      const url = `/sisplan/impressao/v1/preco?`;
      const codigo = pegaChave("#txtProduto")
      const tabelapreco = pegaChave("#txtTabPreco")
      const ordem = `&TELA_ORDENACAO=AcessoPreco&ORDEM_ORDENACAO=${$('#txtOrdem').val()}`;
      const bImprimeAutomatico = await verificaImprimirAutomatico('RelPreco');
      const arquivo = await GeraRelatorio(`${url}&CODIGO=${codigo}&REGIAO=${tabelapreco}&${ordem}&`, 'GET', 100000, false, 'RelPreco');
      if (arquivo != undefined) {
        if (!bImprimeAutomatico) {
          window.open(`${BASE_URI}/relatorios_api/pdf/${arquivo}`, '_blank');
        }
        await limparRelatorios();
      }

    } catch (error) {
      console.error(error);
    } finally {
      $.LoadingOverlay('hide');
    }
  });

  $("#btnLimparFiltros").on("click", async function () {
    $("#txtTabPreco").val("");
    $("#txtProduto").val("");
  });

  async function consultaPreco(bBotao = false) {
    try {
      $.LoadingOverlay("show");
      let response;
      let codigo =
        pegaChave("#txtProduto") != ""
          ? ` AND CODIGO = '${pegaChave("#txtProduto")}'`
          : "";
      let tabelapreco =
        pegaChave("#txtTabPreco") != ""
          ? ` AND REGIAO = '${pegaChave("#txtTabPreco")}'`
          : "";
      if (bBotao) {
        response = await requisicao(
          "GET",
          "/Sisplan/Funcoes/V1/pesquisa?",
          `JSON={ "tabela":"tabpreco", "camposSelect":["'' SEL", "CODIGO", "DESC_PRODUTO", "REGIAO", "DESCRICAO"],   "where": ["1=1 ${codigo} ${tabelapreco} "]}`,
          null
        );
      } else {
        response = await requisicao(
          "GET",
          "/Sisplan/Funcoes/V1/pesquisa?",
          `JSON={ "tabela":"tabpreco", "camposSelect":["'' SEL", "CODIGO", "DESC_PRODUTO", "REGIAO", "DESCRICAO"], "where": null, "limit": 10000}`,
          null
        );
      }

      if (!response) {
        $.LoadingOverlay("hide");
        return;
      }

      let jsonStr = await response.json();
      if (response.status != 200) {
        $.LoadingOverlay("hide");
        msgErro(jsonStr.RESULT[0].mensagem);
        return;
      }

      $("#tabelaPreco").DataTable({
        destroy: true,
        lengthChange: false,
        serverside: true,
        language: {
          sEmptyTable: "Nenhum registro encontrado",
          sInfo: "_TOTAL_ registros",
          sInfoEmpty: " 0 registros",
          sInfoFiltered: "(Filtrados de _MAX_ registros)",
          sInfoPostFix: "",
          sInfoThousands: ".",
          sLengthMenu: "_MENU_ resultados",
          sLoadingRecords: "Carregando...",
          sProcessing: "Processando...",
          sZeroRecords: "Nenhum registro encontrado",
          sSearch: "Pesquisar",
          oPaginate: {
            sNext: "Próximo",
            sPrevious: "Anterior",
            sFirst: "Primeiro",
            sLast: "Último",
          },
          oAria: {
            sSortAscending: ": Ordenar colunas de forma ascendente",
            sSortDescending: ": Ordenar colunas de forma descendente",
          },
        },

        autoWidth: true,
        data: jsonStr.RESULT[0],
        columns: [
          {
            data: "SEL",
          },
          {
            data: "CODIGO",
          },
          {
            data: "DESC_PRODUTO",
          },
          {
            data: "REGIAO",
          },
          {
            data: "DESCRICAO",
          },
        ],
        columnDefs: [
          {
            targets: [0], render: function (_data, _type, _row, meta) {
              return `<div class="icheck-primary d-inline">
                        <input type="checkbox" id="check_col_${meta.row}_row_${meta.col}" class="checkSel">
                        <label for="check_col_${meta.row}_row_${meta.col}"></label>
                      </div>`;
            },
          },
          {
            targets: [1], render: function (data) {
              return retornaBotaoOpcoes(data);
            }
          },
        ],
      });

      adicionarEventoSelecionarTodos()
      $('#cbSelAll').prop('checked', false).trigger('change')

      $.LoadingOverlay("hide");
    } catch (error) {
      console.error(error);
    }
  }

  function adicionarEventoSelecionarTodos() {
    $('#cbSelAll').off('change')
    $('#cbSelAll').on('change', function () {
      const isChecked = this.checked
      const table = $('#tabelaPreco').DataTable()
      table.rows().every(function () {
        const row = $(this.node())
        row.toggleClass('selected', isChecked)
        const checkbox = row.find('.checkSel')
        checkbox.prop('checked', isChecked)
      })
    })
  }

  $("#tabelaPreco").on('change', '.checkSel', function () {
    if ($(this).prop('checked')) {
      $($(this).closest('tr')).addClass('selected')
    } else {
      $($(this).closest('tr')).removeClass('selected')
    }
  });

  $('#btnNovoPreco').on('click', function () {
    if (permissaoUsuarioLogado.INCLUI == 'S') {
      window.location.href = "preco/create";
    } else {
      msgAlertaSemConfirmacao("Sem permissão para incluir!");
    }
  });

  $("#tabelaPreco").on("click", "#btn-editar", async function () {
    if (permissaoUsuarioLogado.ALTERA == 'S') {
      let data = $("#tabelaPreco").DataTable().row($(this).parents("tr")).data();
      let registroLiberado = await verificarRegistro("PRECO", String(data.REGIAO) + String(data.CODIGO));
      if (registroLiberado) {
        window.location.href = `preco/${btoa(`${data.REGIAO}/${data.CODIGO}`)}`;
      }
    } else {
      msgAlertaSemConfirmacao("Sem permissão para alterar!");
    }
  });

  $("#tabelaPreco").on("dblclick", "tr", async function () {
    if (permissaoUsuarioLogado.ALTERA == 'S') {
      let data = $("#tabelaPreco").DataTable().row($(this)).data();
      let registroLiberado = await verificarRegistro("PRECO", String(data.REGIAO) + String(data.CODIGO));
      if (registroLiberado) {
        window.location.href = `preco/${btoa(`${data.REGIAO}/${data.CODIGO}`)}`;
      }
    } else {
      msgAlertaSemConfirmacao("Sem permissão para alterar!");
    }
  });

  $("#tabelaPreco").on("click", "#btn-excluir", async function () {
    if (permissaoUsuarioLogado.EXCLUI == 'S') {
      msgAlerta("Você realmente deseja excluir esse registro?", async () => {
        const data = $("#tabelaPreco").DataTable().row($(this).parents("tr"));
        await excluiRegistro(data);
      });
    } else {
      msgAlertaSemConfirmacao("Sem permissão para excluir!");
    }
  });

  async function excluiRegistro(data) {
    try {
      $.LoadingOverlay("show");
      try {
        let valorLinha = data.data();
        let response = await requisicao(
          "DELETE",
          "/Sisplan/Cadastros/v1/preco?",
          `CODIGOPRODUTO=${encodeURIComponent(
            valorLinha.CODIGO
          )}&CODIGOPRECO=${encodeURIComponent(valorLinha.REGIAO)}`,
          null
        );
        if (!response) {
          return;
        }
        if (response.status != 200) {
          let jsonStr = await response.json();
          msgErro(jsonStr.mensagem);
          return;
        }

        toastr
          .success("Exclusão efetuada com sucesso!", "Confirmação", {
            toastClass: "success",
            iconClasses: {
              error: "alert-error",
              info: "alert-info",
              success: "alert-success",
              warning: "alert-warning",
            },
            positionClass: "toast-top-center",
            progressBar: true,
            timeOut: 3000,
            fadeOut: 1000,
            onHidden() {
              data.remove().draw(false);
            },
          })
          .css({
            "margin-top": "20%",
            width: "500px",
            "max-width": "500px",
          });
      } catch (error) {
        console.error(error);
      }
    } finally {
      $.LoadingOverlay("hide");
    }
  }

  function alteraDadosTabelaPreco() {
    const dataini = $("#txtDataIni").val();
    const datafim = $("#txtDataFim").val();
    const desconto = $("#txtDescontoPreco").val();
    const tabela = $("#tabelaAlterarPreco").DataTable().rows().data();

    tabela.map(() => {
      $(".campoDtIni").val(dataini);
      $(".campoDtFim").val(datafim);
      $(`.campoDesconto`).val(desconto);
    });
    calculaDescontoGeral();
  }

  function calculaDescontoGeral() {
    const desconto = $("#txtDescontoPreco").val();
    const tabela = $("#tabelaAlterarPreco").DataTable().rows().data();

    tabela.map((item, i) => {
      const percentual = +desconto / 100;
      const valor = +item.PRECO_00 * +percentual;
      const valorfinal = +item.PRECO_00 - valor;
      const valorDesconto = +item.PRECO_00 - valorfinal;
      $($(`.campoPrecoFinal`)[i]).val(TruncaDecimaisNova(2, valorfinal));
      $($(`.campoValorDesconto`)[i]).val(TruncaDecimaisNova(2, valorDesconto));
    });
  }

  $("#btnAlterarPreco").on("click", function () {
    if (permissaoUsuarioLogado.ALTERA == 'S') {
      senhaSupervisor('', modalAlterarPreco);
    } else {
      msgAlertaSemConfirmacao("Sem permissão para alterar!");
    }
  });

  $("#btnFiltrosPreco").on("click", function () {
    $("#modal-filtrosAlterarPreco").modal("show");
  });

  $("#btnConfirmarPreco").on("click", function () {
    if ($("#txtDataIni").val() == '' && $("#txtDataFim").val() == '') {
      msgAlerta("Data inicial e final devem ser preenchidas!")
      return;
    }
    if ($("#txtDataIni").val() > $("#txtDataFim").val()) {
      msgAlerta("Data final não pode ser menor que a data inicial!");
      return;
    }
    alteraDadosTabelaPreco();
  });

  $("#txtTabelaPrecoAltera").autocompleta(1, `JSON={ "tabela":"REGIAO", "camposSelect":[ "REGIAO chave", "descricao descricao"], "where": null}`);
  $("#txtMarcaPreco").autocompleta(1, `JSON={ "tabela":"marca", "camposSelect":[ "codigo chave", "descricao descricao"], "where": null}`);
  $("#txtColecaoPreco").autocompleta(1, `JSON={ "tabela":"colecao", "camposSelect":[ "codigo chave", "descricao descricao"], "where": null}`);
  $("#txtPrazoPreco").autocompleta(1, `JSON={ "tabela":"TABPRZ", "camposSelect":[ "PRAZO CHAVE", "DESCRICAO DESCRICAO"], "where": null}`);

  $("#btnTabelaPreco").pesquisa("#txtTabelaPrecoAltera", "REGIAO", "DESCRICAO", `/sisplan/funcoes/v1/pesquisa?JSON={"tabela":"REGIAO", "camposSelect":[ "REGIAO", "DESCRICAO"]}`, "Pesquisa Tabela de Preço", "regiao");
  $("#btnMarcaPreco").pesquisa("#txtMarcaPreco", "CODIGO", "DESCRICAO", `/sisplan/funcoes/v1/pesquisa?JSON={ "tabela":"marca", "camposSelect":[ "codigo", "descricao"]}`, "Pesquisa Marca", "marca");
  $("#btnColecaoPreco").pesquisa("#txtColecaoPreco", "CODIGO", "DESCRICAO", `/sisplan/funcoes/v1/pesquisa?JSON={ "tabela":"colecao", "camposSelect":[ "codigo", "descricao"]}`, "Pesquisa Coleção", "colecao");
  $("#btnPrazoPreco").pesquisa("#txtPrazoPreco", "PRAZO", "DESCRICAO", `/sisplan/funcoes/v1/pesquisa?JSON={ "tabela":"TABPRZ", "camposSelect":[ "PRAZO", "DESCRICAO"]}`, "Pesquisa Prazo", "TABPRZ");

  $("#btnLimpaTabelaPreco").on("click", function () {
    $("#txtTabelaPrecoAltera").val("");
  });

  $("#btnLimpaMarcaPreco").on("click", function () {
    $("#txtMarcaPreco").val("");
  });

  $("#btnLimpaGrupoPreco").on("click", function () {
    $("#txtGrupoPreco").val("");
  });

  $("#btnLimpaColecaoPreco").on("click", function () {
    $("#txtColecaoPreco").val("");
  });

  $("#btnLimpaProdutoMaterial").on("click", function () {
    $("#txtProdutoMaterial").val("");
  });

  $("#btnLimpaPrazoPreco").on("click", function () {
    $("#txtPrazoPreco").val("");
  });

  async function modalAlterarPreco() {
    $.LoadingOverlay("show");
    $("#modal-alterarpreco").modal("show");
    await habilitaBodyPrincipal();
    await montaTabelasPreco();
    $.LoadingOverlay("hide");
  }

  function alteraTipoPesquisa(tipo) {
    $("#btnGrupoPreco").off();
    $("#btnProdutoMaterial").off();
    if (tipo == 1) {
      $("#txtGrupoPreco").autocompleta(
        1,
        `JSON={ "tabela":"grupo_ma", "camposSelect":[ "codigo chave", "descricao descricao"], "where": null}`
      );
      $("#txtProdutoMaterial").autocompleta(
        1,
        `JSON={ "tabela":"material", "camposSelect":[ "codigo chave", "descricao descricao"], "where": null}`
      );
      $("#btnGrupoPreco").pesquisa(
        "#txtGrupoPreco",
        "CODIGO",
        "DESCRICAO",
        `/sisplan/funcoes/v1/pesquisa?JSON={ "tabela":"grupo_ma", "camposSelect":[ "codigo", "descricao"]}`,
        "Pesquisa Grupo",
        "grupo_pa"
      );
      $("#btnProdutoMaterial").pesquisa(
        "#txtProdutoMaterial",
        "CODIGO",
        "DESCRICAO",
        `/sisplan/funcoes/v1/pesquisa?JSON={ "tabela":"material", "camposSelect":[ "codigo", "descricao"]}`,
        "Pesquisa Material",
        "material"
      );
    } else {
      $("#txtGrupoPreco").autocompleta(
        1,
        `JSON={ "tabela":"grupo_pa", "camposSelect":[ "codigo chave", "descricao descricao"], "where": null}`
      );
      $("#txtProdutoMaterial").autocompleta(
        1,
        `JSON={ "tabela":"produto", "camposSelect":[ "codigo chave", "descricao descricao"], "where": null}`
      );
      $("#btnGrupoPreco").pesquisa(
        "#txtGrupoPreco",
        "CODIGO",
        "DESCRICAO",
        `/sisplan/funcoes/v1/pesquisa?JSON={ "tabela":"grupo_pa", "camposSelect":[ "codigo", "descricao"]}`,
        "Pesquisa Grupo",
        "grupo_pa"
      );
      $("#btnProdutoMaterial").pesquisa(
        "#txtProdutoMaterial",
        "CODIGO",
        "DESCRICAO",
        `/sisplan/funcoes/v1/pesquisa?JSON={"tabela":"produto", "camposSelect":[ "CODIGO", "DESCRICAO"]}`,
        "Pesquisa Produto",
        "produto"
      );
    }
  }

  function ajustaTipoCampoBusca() {
    if ($("#rgTipoItemPreco").val() != 0) {
      $("#labelProdutoMaterial").html("Material");
      $("#txtProdutoMaterial").attr("placeholder", "Material");
      $("#txtProdutoMaterial").val("");
    } else {
      $("#labelProdutoMaterial").html("Produto");
      $("#txtProdutoMaterial").attr("placeholder", "Produto");
      $("#txtProdutoMaterial").val("");
    }
  }

  function desabilitaCampos(tipo) {
    const ehMaterial = tipo == 1;
    const componentes = [
      "#txtMarcaPreco",
      "#btnMarcaPreco",
      "#btnLimpaMarcaPreco",
      "#txtPrazoPreco",
      "#btnPrazoPreco",
      "#btnLimpaPrazoPreco",
    ];
    componentes.forEach((componente) =>
      $(componente).prop("disabled", ehMaterial)
    );
    $("#txtMarcaPreco").val('');
    $("#txtPrazoPreco").val('');
  }

  $("#rgTipoItemPreco").on("change", function () {
    ajustaTipoCampoBusca();
    alteraTipoPesquisa($("#rgTipoItemPreco").val());
    desabilitaCampos($("#rgTipoItemPreco").val());
  });

  $("#rgTipoItemPreco").trigger("change");

  $('#btnFecharDuplicar').on('click', function () {
    $('#modal-duplicar').modal('hide')
    $('#txtNovaTabelaPreco').val('')
  })

  $('#btnDuplicar').on('click', function () {
    const selectedData = $("#tabelaPreco").DataTable().rows(".selected").data().toArray()
    if (!selectedData || selectedData.length === 0) {
      msgErro('É necessário selecionar pelo menos um item para duplicar.')
      return
    }
    $('#modal-duplicar').modal('show')
  })

  $('#btnConfirmarDuplicar').on('click', async function () {
    const tabela = pegaChave('#txtNovaTabelaPreco')
    if (!tabela || tabela === '') {
      msgErro('É necessário selecionar uma tabela de destino para duplicar os itens.')
      return
    }
    await duplicarPrecos(tabela)
  })

  async function duplicarPrecos(tabela) {
    $('#btnConfirmarDuplicar').prop('disabled', true)
    $.LoadingOverlay('show')
    try {
      const selectedData = $("#tabelaPreco").DataTable().rows(".selected").data().toArray()
      const arrayCodigosTabelas = selectedData.map(e => {
        return {
          CODIGO: e.CODIGO,
          REGIAO: e.REGIAO
        }
      })
      const obj = {
        ITENS: arrayCodigosTabelas,
        TABELA_DESTINO: tabela
      }

      let response = await requisicao(
        "POST",
        "/sisplan/preco/v1/duplicarprecoitens?",
        "",
        JSON.stringify(obj),
        null
      )

      if (!response) {
        throw ''
      }

      if (response.status !== 200) {
        throw ''
      }

      toastr.success("Preço(s) duplicado(s) com sucesso!", "Confirmação", {
        toastClass: "success",
        iconClasses: {
          error: "alert-error",
          info: "alert-info",
          success: "alert-success",
          warning: "alert-warning",
        },
        positionClass: "toast-top-center",
        progressBar: true,
        timeOut: 3000,
        fadeOut: 1000,
        onHidden() {
          $('#modal-duplicar').modal('hide')
          $('#txtNovaTabelaPreco').val('')
          $('#tabelaPreco tr.selected').removeClass('selected')
          $('#cbSelAll').prop('checked', false).trigger('change')
        },
      }).css({
        "margin-top": "20%",
        width: "500px",
        "max-width": "500px",
      });

    } catch (e) {
      msgErro('Não foi possível duplicar os registros.')
      console.log(e)
    } finally {
      $.LoadingOverlay('hide')
      $('#btnConfirmarDuplicar').prop('disabled', false)
    }
  }

  componenteFiltro('tabPreco', false, false, 'NovaTabelaPreco')

  $('#btnImportar').on('click', function () {
    criaTabelaImportar()
    $('#modal-importar').modal('show')
  })

  function criaTabelaImportar(info = []) {
    function carregaInputPreco(valor, indices) {
      return `<div class="d-flex justify-content-end">
                <input type="text" id="txtPreco_${indices.row}"
                class="input-default focus form-control apenasFloat text-right classPreco"
                style="min-width: 15ch; max-width: 20ch" value="${valor}">
              </div>`;
    }
    function carregaInputPrecoPromo(valor, indices) {
      return `<div class="d-flex justify-content-end pr-4">
                <input type="text" id="txtPrecoPromo_${indices.row}"
                class="input-default focus form-control apenasFloat text-right classPrecoPromo"
                style="min-width: 15ch; max-width: 20ch" value="${valor}">
              </div>`;
    }

    if ($.fn.DataTable.isDataTable('#tabelaImportar')) {
      $('#tabelaImportar').DataTable().destroy();
      $('#tabelaImportar').empty();
    }

    const cols = [
      {
        data: 'TABELA',
        title: 'Tabela'
      },
      {
        data: 'CODIGO',
        title: 'Código'
      },
      {
        data: 'PRECO_ATUAL',
        title: 'Preço Atual'
      },
      {
        data: 'PRECO_PROMO_ATUAL',
        title: 'Preço Promocional Atual'
      },
      {
        data: 'PRECO',
        title: 'Preço Arquivo'
      },
      {
        data: 'PRECO_PROMO',
        title: 'Preço Promocional'
      }
    ];

    $("#tabelaImportar").DataTable({
      sort: true,
      paging: false,
      destroy: true,
      lengthChange: false,
      filter: false,
      language: {
        sEmptyTable: "Nenhum registro encontrado",
        sInfo: "_TOTAL_ registros",
        sInfoEmpty: " 0 registros",
        sInfoFiltered: "(Filtrados de _MAX_ registros)",
        sInfoPostFix: "",
        sInfoThousands: ".",
        sLengthMenu: "_MENU_ resultados",
        sLoadingRecords: "Carregando...",
        sProcessing: "Processando...",
        sZeroRecords: "Nenhum registro encontrado",
        sSearch: "Pesquisar",
        oPaginate: {
          sNext: "Próximo",
          sPrevious: "Anterior",
          sFirst: "Primeiro",
          sLast: "Último",
        },
        oAria: {
          sSortAscending: ": Ordenar colunas de forma ascendente",
          sSortDescending: ": Ordenar colunas de forma descendente",
        },
      },
      columnDefs: [
        {
          targets: [2, 3],
          render: function (data) {
            if (!data) {
              return parseFloat(0).toFixed(2)
            }
            return parseFloat(data).toFixed(2)
          },
          className: 'text-right pr-4'
        },
        {
          targets: [4],
          render: function (data, _type, _row, meta) {
            return carregaInputPreco(data, meta)
          }
        },
        {
          targets: [5],
          render: function (data, _type, _row, meta) {
            return carregaInputPrecoPromo(data, meta)
          }
        },
      ],
      autoWidth: true,
      data: info,
      columns: cols
    }).draw(false);

    adicionaMascaraCampos()
  }

  function adicionaMascaraCampos() {
    $('.apenasFloat').maskMoney({
      decimal: ".",
      thousands: "",
      precision: 2,
    });
  };

  $('#btnArquivoImportar').on('click', function (e) {
    e.preventDefault();
    $('#mdModalUpload').trigger('click');
  });

  $('#mdModalUpload').on('change', async function () {
    let nomeAnexo = $(this).val().split('\\')[$(this).val().split('\\').length - 1];
    $('#txtArquivoImportar').val(nomeAnexo);

    let file = document.getElementById('mdModalUpload').files[0];
    let reader = new FileReader();
    dados = leArquivoExcel(reader, file, nomeAnexo);
  });

  function leArquivoExcel(reader, file, name) {
    try {
      const extension = (name.split('.')[name.split('.').length - 1]);
      if (extension == 'csv') {
        reader.onload = function (e) {
          $('#fileContent').text(e.target.result);
        }
        reader.readAsText(file);
      } else if (extension == 'xls' || extension == 'xlsx' || extension == 'xlsm' || extension == 'xlt') {
        reader.onload = function (e) {
          const data = new Uint8Array(e.target.result);
          const workbook = XLSX.read(data, { type: 'array' });
          const sheetName = workbook.SheetNames[0];
          const sheet = workbook.Sheets[sheetName];

          // Get the range of the sheet
          const range = XLSX.utils.decode_range(sheet['!ref']);
          let resultString = '';

          for (let R = range.s.r; R <= range.e.r; ++R) {
            for (let C = range.s.c; C <= range.e.c; ++C) {
              const cellAddress = { c: C, r: R };
              const cellRef = XLSX.utils.encode_cell(cellAddress);
              const cell = sheet[cellRef];
              let cellValue = cell ? cell.v : null;

              if (cell && cell.t === 'n' && cell.z === 'm/d/yy') {
                const serialDate = cellValue;
                const jsDate = excelSerialToJSDate(serialDate);
                cellValue = formatDate(jsDate);
              }

              resultString += `${cellValue},`;
            }
            resultString = resultString.slice(0, -1); // Remove the trailing comma
            resultString += ';';
          }

          $('#fileContent').text(resultString);
        }
        reader.readAsArrayBuffer(file);

      }
    } catch (e) {
      msgErro(`Não foi possível ler o arquivo: ${e}`)
      return;
    }
  }

  function retornaDadosImportar() {
    let info = $('#fileContent').text();
    let arquivo = $('#txtArquivoImportar').val();
    let ext = (arquivo.split('.'))[(arquivo.split('.')).length - 1];
    let dados = '';
    dados = formataDadosExcel(info, ext);
    return dados;
  }

  function formataDadosExcel(info, ext) {
    let char1, char2;
    if (ext == 'csv') {
      char1 = '\n';
      char2 = ';';
    } else {
      char1 = ';';
      char2 = ',';
    }

    let data = (info.split(char1)).filter(item => item != '');
    let arrayRetorno = [];

    let firstLine = data[0].split(char2);

    firstLine = firstLine.map(e => {
      return e.normalize("NFD").replaceAll('R$', '').replace(/[\u0300-\u036f]/g, '').replace(/[^\w\s]/gi, '').replaceAll('.', '').replaceAll(',', '').toUpperCase().trim();
    })

    data.map((e, i) => {
      let d
      if (e.indexOf('\r') != -1){
        d = e.replace('\r', '').split(char2);
      } else {
        d = e.split(char2);
      }
      if (d[0] == 'null' && d[1] == 'null' && d[2] == 'null' && d[3] == 'null' && d[4] == 'null' && d[5] == 'null') {
        return;
      }

      arrayRetorno.push({
        TABELA: d[0] == 'null' || !d[0] ? '' : d[0],
        CODIGO: d[1] == 'null' || !d[1] ? '' : d[1],
        PRECO_ATUAL: d[2] == 'null' || !d[2] ? 0 : d[2],
        PRECO_PROMO_ATUAL: d[3] == 'null' || !d[3] ? 0 : d[3],
        PRECO_ARQUIVO: d[4] == 'null' || !d[4] ? 0 : d[4],
        PRECO_PROMO: d[5] == 'null' || !d[5] ? 0 : d[5],
      });
    });

    return arrayRetorno;
  }

  $('#btnCarregarImportar').on('click', async function () {
    await carregaDadosImportacao()
  })

  async function carregaDadosImportacao() {
    $('#btnCarregarImportar').prop('disabled', true)
    $.LoadingOverlay('show')
    try {
      const dadosImportacao = retornaDadosImportar()

      const response = await requisicao(
        "POST",
        "/Sisplan/preco/v1/carregarimportacaoprecoitens?",
        "",
        JSON.stringify({ itens: dadosImportacao }),
        360000
      );

      if (!response) {
        return;
      }

      let jsonStr = await response.json();
      if (response.status != 200) {
        msgErro(jsonStr.mensagem);
        return;
      }

      criaTabelaImportar(jsonStr)
    } catch (e) {
      msgErro('Não foi possível realizar a importação.')
      console.log(e)
    } finally {
      $.LoadingOverlay('hide')
      $('#btnCarregarImportar').prop('disabled', false)
    }
  }
});

function retornaDataImportar() {
  const itens = $('#tabelaImportar').DataTable().data().toArray()
  return itens.map((e, i) => {
    return {
      tabela: e.TABELA,
      codigo: e.CODIGO,
      preco_atual: e.PRECO_ATUAL,
      preco_promo_atual: e.PRECO_PROMO_ATUAL,
      preco_arquivo: $(`#txtPreco_${i}`).val().replace('.', ','),
      preco_promo: $(`#txtPrecoPromo_${i}`).val().replace('.', ',')
    }
  })

}

$('#btnConfirmarImportar').on('click', async function () {
  const data = retornaDataImportar()
  msgAlerta('Deseja realmente importar os preços?',
    () => { },
    () => { },
    async () => {
      await importaPrecos(data)
    }
  )
})

function retornaFiltrosImportar() {
  return {
    tipo: $('#selectTipoImportar').val(),
    dt_promo_ini: !$('#dtPromocaoIniImportar').val() && $('#dtPromocaoIniImportar').val() !== '' ? $('#dtPromocaoIniImportar').val() : null,
    dt_promo_fim: !$('#dtPromocaoFimImportar').val() && $('#dtPromocaoFimImportar').val() !== '' ? $('#dtPromocaoFimImportar').val() : null
  }
}

async function importaPrecos(data) {
  $('#btnConfirmarImportar').prop('disabled', true)
  $.LoadingOverlay('show')
  try {
    const filtros = retornaFiltrosImportar()

    const response = await requisicao(
      "POST",
      "/Sisplan/preco/v1/importaprecoitens?",
      "",
      JSON.stringify({ itens: data, filtros }),
      null
    );

    if (!response) {
      return;
    }

    if (response.status != 200) {
      let jsonStr = await response.json();
      msgErro(jsonStr.mensagem);
      return;
    }

    toastr.success("Preço(s) importado(s) com sucesso!", "Confirmação", {
      toastClass: "success",
      iconClasses: {
        error: "alert-error",
        info: "alert-info",
        success: "alert-success",
        warning: "alert-warning",
      },
      positionClass: "toast-top-center",
      progressBar: true,
      timeOut: 3000,
      fadeOut: 1000,
      onHidden() {
        $('#modal-importar').modal('hide')
        $('#dtPromocaoIniImportar').val('')
        $('#dtPromocaoFimImportar').val('')
        $('#txtArquivoImportar').val('')
      },
    }).css({
      "margin-top": "20%",
      width: "500px",
      "max-width": "500px",
    });

  } catch (e) {
    msgErro('Não foi possível importar os dados.')
    console.log(e)
  } finally {
    $('#btnConfirmarImportar').prop('disabled', false)
    $.LoadingOverlay('hide')
  }
}

async function consultaAlterarPreco() {
  try {
    $.LoadingOverlay("show");
    const tabelapreco =
      pegaChave("#txtTabelaPrecoAltera") != ""
        ? ` AND TABPRECO.REGIAO = '${pegaChave("#txtTabelaPrecoAltera")}'`
        : "";
    const tipoitem = $("#rgTipoItemPreco").val() == 0 ? `PRODUTO` : `MATERIAL`;
    const codigo =
      pegaChave("#txtProdutoMaterial") != ""
        ? ` AND TABPRECO.CODIGO = '${pegaChave("#txtProdutoMaterial")}'`
        : "";
    const grupo =
      pegaChave("#txtGrupoPreco") != ""
        ? ` AND ${tipoitem}.GRUPO = '${pegaChave("#txtGrupoPreco")}'`
        : "";
    const colecao =
      pegaChave("#txtColecaoPreco") != ""
        ? ` AND TABPRECO.COLECAO = '${pegaChave("#txtColecaoPreco")}'`
        : "";
    const marca =
      pegaChave("#txtMarcaPreco") != ""
        ? ` AND PRODUTO.MARCA = '${pegaChave("#txtMarcaPreco")}'`
        : "";
    const linha =
      pegaChave("#txtLinhaPreco") != ""
        ? ` AND PRODUTO.LINHA = '${pegaChave("#txtLinhaPreco")}'`
        : "";
    const prazo = pegaChave("#txtPrazoPreco") != "" ? `AND PRODUTO.SEMANA = '${pegaChave("#txtPrazoPreco")}'` : "";

    let pesquisaParam = {
      tabela: "TABPRECO",
      where: [`1=1 ${tabelapreco} ${codigo} ${grupo} ${colecao} ${marca} ${prazo} ${linha}`],
    };

    if ($("#rgTipoItemPreco").val() == 0) {
      pesquisaParam.camposSelect = [
        "TABPRECO.REGIAO",
        "TABPRECO.CODIGO",
        "TABPRECO.DESC_PRODUTO",
        "TABPRECO.COLECAO",
        "COLECAO.DESCRICAO DESC_COLECAO",
        "PRODUTO.SEMANA",
        "TABPRECO.DT_PROMOINI",
        "TABPRECO.DT_PROMOFIM",
        "TABPRECO.PRECO_00",
        "TABPRECO.PRECO_PROMO",
        "SUM(PA_ITEN.QUANTIDADE) QUANTIDADE"
      ],
        pesquisaParam.groupBy = [
          "TABPRECO.REGIAO",
          "TABPRECO.CODIGO",
          "TABPRECO.DESC_PRODUTO",
          "TABPRECO.COLECAO",
          "COLECAO.DESCRICAO",
          "PRODUTO.SEMANA",
          "TABPRECO.DT_PROMOINI",
          "TABPRECO.DT_PROMOFIM",
          "TABPRECO.PRECO_00",
          "TABPRECO.PRECO_PROMO"
        ],
        pesquisaParam.leftJoin = [
          { tabela: "PRODUTO", condicao: "PRODUTO.CODIGO = TABPRECO.CODIGO" },
          { tabela: "COLECAO", condicao: "TABPRECO.COLECAO = COLECAO.CODIGO" },
          { tabela: "PA_ITEN", condicao: "PA_ITEN.CODIGO = TABPRECO.CODIGO" }
        ];
    } else {
      pesquisaParam.camposSelect = [
        "TABPRECO.REGIAO",
        "TABPRECO.CODIGO",
        "TABPRECO.DESC_PRODUTO",
        "TABPRECO.COLECAO",
        "COLECAO.DESCRICAO DESC_COLECAO",
        "TABPRECO.DT_PROMOINI",
        "TABPRECO.DT_PROMOFIM",
        "TABPRECO.PRECO_00",
        "TABPRECO.PRECO_PROMO",
        "SUM(MAT_ITEN.QTDE) QUANTIDADE"
      ],
        pesquisaParam.groupBy = [
          "TABPRECO.REGIAO",
          "TABPRECO.CODIGO",
          "TABPRECO.DESC_PRODUTO",
          "TABPRECO.COLECAO",
          "COLECAO.DESCRICAO",
          "TABPRECO.DT_PROMOINI",
          "TABPRECO.DT_PROMOFIM",
          "TABPRECO.PRECO_00",
          "TABPRECO.PRECO_PROMO"
        ],
        pesquisaParam.leftJoin = [
          { tabela: "MATERIAL", condicao: "MATERIAL.CODIGO = TABPRECO.CODIGO" },
          { tabela: "COLECAO", condicao: "TABPRECO.COLECAO = COLECAO.CODIGO" },
          { tabela: "MAT_ITEN", condicao: "MAT_ITEN.CODIGO = TABPRECO.CODIGO" }
        ];
    }

    const jsonStr = await retornaJsonPesquisaPadrao(
      JSON.stringify(pesquisaParam)
    );

    if (jsonStr.length == 0) {
      msgAlerta("Item não encontrado na tabela de preço");
      return;
    }

    const jsonFormatado = [{}];

    jsonStr.map((item, i) => {
      jsonFormatado[i] = {
        REGIAO: jsonStr[i].REGIAO,
        CODIGO: jsonStr[i].CODIGO,
        DESC_PRODUTO: jsonStr[i].DESC_PRODUTO,
        PRODUTO: jsonStr[i].CODIGO + ' - ' + jsonStr[i].DESC_PRODUTO,
        COLECAO: jsonStr[i].COLECAO + ' - ' + jsonStr[i].DESC_COLECAO,
        DT_PROMOINI: item.DT_PROMOINI = `<input type="date" max="2500-12-31" class="input-default focus form-control campoDtIni" value="${jsonStr[i].DT_PROMOINI}">`,
        DT_PROMOFIM: item.DT_PROMOFIM = `<input type="date" max="2500-12-31" class="input-default focus form-control campoDtFim" value="${jsonStr[i].DT_PROMOFIM}">`,
        PRAZO: item.PRAZO = jsonStr[i].SEMANA == undefined ? '' : jsonStr[i].SEMANA,
        QTDE_ESTOQUE: jsonStr[i].QUANTIDADE,
        PRECO_00: jsonStr[i].PRECO_00,
        PRECO_PROMO: item.PRECO_PROMO = jsonStr[i].PRECO_PROMO == '' || 0 ? jsonStr[i].PRECO_00 : jsonStr[i].PRECO_PROMO,
        DESCONTO: item.DESCONTO = `<input type="number" class="input-default focus form-control campoDesconto" value="">`,
        VALOR_DESCONTO: item.VALOR_DESCONTO = `<input type="number" class="input-default focus form-control campoValorDesconto" value="">`,
        PRECO_FINAL: item.PRECO_FINAL = jsonStr[i].PRECO_PROMO != '' ? `<input type="number" class="input-default focus form-control campoPrecoFinal" value="${jsonStr[i].PRECO_PROMO}">`
          : `<input type="number" class="input-default focus form-control campoPrecoFinal" value="${jsonStr[i].PRECO_00}">`,
      };
    });


    const dataSetCols = [];
    const keys = Object.keys(jsonFormatado[0]);
    for (let k in keys) {
      dataSetCols.push({
        data: keys[k],
      });
    }

    $('#tabelaAlterarPreco').DataTable({
      paging: false,
      filter: true,
      info: false,
      order: false,
      destroy: true,
      scrollX: true,
      scrollY: "350px",
      language: {
        sEmptyTable: "Nenhum registro encontrado",
        sInfo: "_TOTAL_ registros",
        sInfoEmpty: " 0 registros",
        sInfoFiltered: "(Filtrados de _MAX_ registros)",
        sInfoPostFix: "",
        sInfoThousands: ".",
        sLengthMenu: "_MENU_ resultados",
        sLoadingRecords: "Carregando...",
        sProcessing: "Processando...",
        sZeroRecords: "Nenhum registro encontrado",
        sSearch: "Pesquisar",
        oPaginate: {
          sNext: "Próximo",
          sPrevious: "Anterior",
          sFirst: "Primeiro",
          sLast: "Último",
        },
        oAria: {
          sSortAscending: ": Ordenar colunas de forma ascendente",
          sSortDescending: ": Ordenar colunas de forma descendente",
        },
      },
      data: jsonFormatado,
      columns: dataSetCols,
      columnDefs: [
        {
          targets: [1, 2],
          visible: false,
        },
        {
          targets: 7,
          className: "ajustePrazo",
        },
        {
          targets: 8,
          className: "ajusteQtdeEstoque",
        },
        {
          targets: 9,
          className: "ajustePrecoAtual",
        },
        {
          targets: 10,
          className: "ajustePrecoPromocional",
        }

      ],
    });


    $(".campoDesconto").on("blur", function () {
      const tabela = $("#tabelaAlterarPreco").DataTable().row($(this).parents("tr")).data();
      const index = $(this).parent()[0]._DT_CellIndex.row;
      const desconto = $($(".campoDesconto")[index]).val();
      const percentual = +desconto / 100;
      const valor = +tabela.PRECO_00 * +percentual;
      const valorfinal = +tabela.PRECO_00 - valor;
      const valorDesconto = +tabela.PRECO_00 - valorfinal
      $($(`.campoPrecoFinal`)[index]).val(TruncaDecimaisNova(2, valorfinal));
      $($(`.campoValorDesconto`)[index]).val(TruncaDecimaisNova(2, valorDesconto));
    });

    $(".campoValorDesconto").on("blur", function () {
      const tabela = $("#tabelaAlterarPreco").DataTable().row($(this).parents("tr")).data();
      const index = $(this).parent()[0]._DT_CellIndex.row;
      const valorDesconto = $($(".campoValorDesconto")[index]).val();
      const valorfinal = +tabela.PRECO_00 - valorDesconto;
      const calculoPercentual = +valorDesconto * 100;
      const percentualDesconto = +calculoPercentual / +tabela.PRECO_00;
      $($(`.campoPrecoFinal`)[index]).val(TruncaDecimaisNova(2, valorfinal));
      $($(`.campoDesconto`)[index]).val(TruncaDecimaisNova(2, percentualDesconto));
    });

    $(".campoPrecoFinal").on("blur", function () {
      const tabela = $("#tabelaAlterarPreco").DataTable().row($(this).parents("tr")).data();
      const index = $(this).parent()[0]._DT_CellIndex.row;
      const precofinal = $($(".campoPrecoFinal")[index]).val();
      const valorpercentual = +precofinal * 100;
      const valor = +valorpercentual / +tabela.PRECO_00;
      const percentualfinal = 100 - valor;
      const valorDesconto = +tabela.PRECO_00 - precofinal;
      $($(`.campoDesconto`)[index]).val(TruncaDecimaisNova(2, percentualfinal));
      $($(`.campoValorDesconto`)[index]).val(TruncaDecimaisNova(2, valorDesconto));
    });

    $('.campoDesconto').on('keydown', async function (event) {
      if ((event.key == 'Enter')) {
        const tabela = $("#tabelaAlterarPreco").DataTable().row($(this).parents("tr")).data();
        const index = $(this).parent()[0]._DT_CellIndex.row;
        const desconto = $($(".campoDesconto")[index]).val();
        const percentual = +desconto / 100;
        const valor = +tabela.PRECO_00 * +percentual;
        const valorfinal = +tabela.PRECO_00 - valor;
        const valorDesconto = +tabela.PRECO_00 - valorfinal
        $($(`.campoPrecoFinal`)[index]).val(TruncaDecimaisNova(2, valorfinal));
        $($(`.campoValorDesconto`)[index]).val(TruncaDecimaisNova(2, valorDesconto));
      }
    });

    $('.campoValorDesconto').on('keydown', async function (event) {
      if ((event.key == 'Enter')) {
        const tabela = $("#tabelaAlterarPreco").DataTable().row($(this).parents("tr")).data();
        const index = $(this).parent()[0]._DT_CellIndex.row;
        const valorDesconto = $($(".campoValorDesconto")[index]).val();
        const valorfinal = +tabela.PRECO_00 - valorDesconto;
        const calculoPercentual = +valorDesconto * 100;
        const percentualDesconto = +calculoPercentual / +tabela.PRECO_00;
        $($(`.campoPrecoFinal`)[index]).val(TruncaDecimaisNova(2, valorfinal));
        $($(`.campoDesconto`)[index]).val(TruncaDecimaisNova(2, percentualDesconto));
      }
    });

    $('.campoPrecoFinal').on('keydown', async function (event) {
      if ((event.key == 'Enter')) {
        const tabela = $("#tabelaAlterarPreco").DataTable().row($(this).parents("tr")).data();
        const index = $(this).parent()[0]._DT_CellIndex.row;
        const precofinal = $($(".campoPrecoFinal")[index]).val();
        const valorpercentual = +precofinal * 100;
        const valor = +valorpercentual / +tabela.PRECO_00;
        const percentualfinal = 100 - valor;
        const valorDesconto = +tabela.PRECO_00 - precofinal;
        $($(`.campoDesconto`)[index]).val(TruncaDecimaisNova(2, percentualfinal));
        $($(`.campoValorDesconto`)[index]).val(TruncaDecimaisNova(2, valorDesconto));
      }
    });


  } finally {
    $.LoadingOverlay("hide");
  }
}

async function limpaCamposFiltrosAlterarPreco() {
  $("#txtTabelaPrecoAltera").val("");
  $("#txtProdutoMaterial").val("");
  $("#txtGrupoPreco").val("");
  $("#txtColecaoPreco").val("");
  $("#txtMarcaPreco").val("");
  $("#txtPrazoPreco").val("");
  $('#txtLinhaPreco').val('')
}

async function limpaCamposAlterarPreco() {
  $("#txtDataIni").val("");
  $("#txtDataFim").val("");
  $("#txtDescontoPreco").val("");
  $("#txtColecaoPreco").val("");
}

$("#btnLimparCamposAlterarPreco").on("click", async function () {
  limpaCamposAlterarPreco();
  $("#tabelaAlterarPreco").DataTable().clear().draw(false);
});

$("#btnConsultarPreco").on("click", async function () {
  if ($("#txtTabelaPrecoAltera").val() == "") {
    msgAlerta("Tabela de preço não informada, favor verificar.");
    return;
  }
  $("#tabelaAlterarPreco").DataTable().clear().draw(false);
  await consultaAlterarPreco();
  await limpaCamposFiltrosAlterarPreco();
  $("#modal-filtrosAlterarPreco").modal("hide");
});

$("#btnAvancar").on("click", async function () {
  if ($("#tabelaAlterarPreco").DataTable().rows()[0].length == 0) {
    msgAlerta("Nenhum item informado, verifique!");
    return;
  }
  const rows = $("#tabelaAlterarPreco").DataTable().rows();
  for (let i = 0; i < rows[0].length; i++) {
    const dtini = new Date($($(".campoDtIni")[i]).val() + ' 00:00:00');
    const dtfim = new Date($($(".campoDtFim")[i]).val() + ' 00:00:00');

    if (($($('.campoDtIni')[i]).val() == '') && ($($('.campoDtFim')[i]).val() == '')) {
      msgAlerta('Data inicial e final devem ser preenchidas!');
      return;
    }

    if (dtini > dtfim) {
      msgAlerta('Data final não pode ser menor que a data inicial!');
      return;
    }

  }

  $(".dataTables_scroll").children(".dataTables_scrollHead").children(".dataTables_scrollHeadInner").children(".table.table-sm.table-select.table-hover.no-footer.dataTable").css("width", "1080px");
  await habilitaBodyTabelasPreco();
  if ($("#tabelaAlterarPreco").DataTable().row(0).data().REGIAO != '') {
    await checkTabelaPreco();
  }
});

$("#btnVoltar").on("click", async function () {
  $(".dataTables_scroll").children(".dataTables_scrollHead").children(".dataTables_scrollHeadInner").children(".table.table-sm.table-select.table-hover.no-footer.dataTable").css("width", "1350.52px");
  await habilitaBodyPrincipal();
});

$("#btnGravarPreco").on("click", async function () {
  const rows = $("#tabelaAlterarPreco").DataTable().rows();
  const arrayItensAlterarPreco = [];
  const listaTabelasPreco = await buscaTabelasMarcadas();

  try {
    $.LoadingOverlay("show");
    try {
      for (let i = 0; i < rows[0].length; i++) {
        const tabela = $("#tabelaAlterarPreco").DataTable().row(i).data();
        let itensAlterarPreco = {
          REGIAO: tabela.REGIAO,
          CODIGO: tabela.CODIGO,
          DESC_PRODUTO: tabela.DESC_PRODUTO,
          DT_PROMOINI: $($(".campoDtIni")[i]).val(),
          DT_PROMOFIM: $($(".campoDtFim")[i]).val(),
          DESCONTO: $($(".campoDesconto")[i]).val(),
          PRECO_PROMO: $($(".campoPrecoFinal")[i]).val(),
        };
        arrayItensAlterarPreco.push(itensAlterarPreco);
      }

      if (listaTabelasPreco == '') {
        msgAlerta("Nenhuma tabela de preço selecionada, verifique!");
        return;
      }

      const preco = {
        itensPreco: arrayItensAlterarPreco,
        tabelasPreco: listaTabelasPreco,
      };

      let response = await requisicao(
        "PUT",
        "/Sisplan/Cadastros/v1/alterarpreco?",
        "",
        JSON.stringify(preco),
        null
      );

      if (!response) {
        return;
      }

      if (response.status != 200) {
        let jsonStr = await response.json();
        msgErro(jsonStr.mensagem);
        return;
      }

      limpaCamposAlterarPreco();
      $("#tabelaAlterarPreco").DataTable().clear().draw(false);
      $("#modal-alterarpreco").modal("hide");
      msgSucesso("Preço alterado com sucesso!");
    } catch (error) {
      console.error(error);
      msgErro(`Não foi possível gravar os dados : ${error}`);
    }
  } finally {
    $.LoadingOverlay("hide");
  }

});

async function habilitaBodyPrincipal() {
  $("#btnFiltrosPreco").removeClass("d-none");
  $("#btnAvancar").removeClass("d-none");
  $("#btnLimparCamposAlterarPreco").removeClass("d-none");
  $("#btnVoltar").addClass("d-none");
  $("#btnGravarPreco").addClass("d-none");
  $("#bodyPrincipal").removeClass("d-none");
  $("#bodyTabelasPreco").addClass("d-none");
}

async function habilitaBodyTabelasPreco() {
  $("#btnFiltrosPreco").addClass("d-none");
  $("#btnAvancar").addClass("d-none");
  $("#btnLimparCamposAlterarPreco").addClass("d-none");
  $("#btnVoltar").removeClass("d-none");
  $("#btnGravarPreco").removeClass("d-none");
  $("#bodyPrincipal").addClass("d-none");
  $("#bodyTabelasPreco").removeClass("d-none");
}

async function buscaTabelasMarcadas() {
  const rows = $("#tabelaTabelasPreco").DataTable().rows()[0].length;
  let tabelasMarcadas = [];

  for (let i = 0; i < rows; i++) {
    if ($(`#check_col_${i}`)[0].checked == true) {
      tabelasMarcadas.push($("#tabelaTabelasPreco").DataTable().row(i).data().REGIAO.substr(0, 3));
    }
  }
  return tabelasMarcadas;
}

async function checkTabelaPreco() {
  const rows = $("#tabelaTabelasPreco").DataTable().rows()[0].length;

  for (let i = 0; i < rows; i++) {
    $(`#check_col_${i}`)[0].checked = false;
  }

  for (let i = 0; i < rows; i++) {
    if ($("#tabelaTabelasPreco").DataTable().row(i).data().REGIAO.substr(0, 3) == $("#tabelaAlterarPreco").DataTable().row(0).data().REGIAO) {
      $(`#check_col_${i}`)[0].checked = true;
    }
  }
}

async function montaTabelasPreco() {
  let pesquisaParam = {
    tabela: "REGIAO",
    camposSelect: [
      "REGIAO.REGIAO",
      "REGIAO.DESCRICAO",
    ],
    where: [''],
    orderBy: ["REGIAO.REGIAO"]
  };

  const jsonStr = await retornaJsonPesquisaPadrao(
    JSON.stringify(pesquisaParam)
  );

  const jsonFormatado = [{}];

  jsonStr.map((item, i) => {
    jsonFormatado[i] = {
      SEL: `<input type="checkbox" id="check_col_${i}" class="campoSel">`,
      REGIAO: jsonStr[i].REGIAO + ' - ' + jsonStr[i].DESCRICAO,
    };
  });

  const dataSetCols = [];

  const keys = Object.keys(jsonFormatado[0]);
  for (let k in keys) {
    dataSetCols.push({
      data: keys[k],
    });
  }

  criaDataTablePadrao(
    "#tabelaTabelasPreco",
    false,
    false,
    false,
    false,
    true,
    false,
    "250px",
    jsonFormatado,
    dataSetCols
  );

  $('#txtPrecoAlterarPreco').maskMoney({
    decimal: ".",
    thousands: "",
    precision: 2,
  });
  $('#txtPrecoAlterarPrecoSeg').maskMoney({
    decimal: ".",
    thousands: "",
    precision: 2,
  });

  componenteFiltro('linha', false, false, 'LinhaPreco')

  $('#btnGravarAlterarPreco').on('click', async function () {
    const preco = $('#txtPrecoAlterarPreco').val()
    const precoSegunda = parseFloat($('#txtPrecoAlterarPrecoSeg').val()) || 0
    if (parseFloat(preco) === 0 || isNaN(parseFloat(preco))) {
      msgErro('Preço não informado, verifique!')
      return
    }

    const listaTabelasPreco = await buscaTabelasMarcadas();
    if (listaTabelasPreco == '') {
      msgAlerta("Nenhuma tabela de preço selecionada, verifique!");
      return;
    }

    msgAlerta('Deseja realmente alterar o preço de todos os registros filtrados?',
      () => { },
      () => { },
      async () => {
        await atualizaPrecoItens(preco, precoSegunda, listaTabelasPreco)
      }
    )
  })

  async function atualizaPrecoItens(preco, precoSegunda, tabelas) {
    $.LoadingOverlay('show')
    try {
      const rows = $("#tabelaAlterarPreco").DataTable().rows();
      const arrayItensAlterarPreco = [];

      for (let i = 0; i < rows[0].length; i++) {
        const tabela = $("#tabelaAlterarPreco").DataTable().row(i).data();
        let itensAlterarPreco = {
          REGIAO: tabela.REGIAO,
          CODIGO: tabela.CODIGO,
          DESC_PRODUTO: tabela.DESC_PRODUTO,
          PRECO_00: preco,
          PRECO_SEGUNDA: precoSegunda
        };
        arrayItensAlterarPreco.push(itensAlterarPreco);
      }

      const precoClasse = {
        itensPreco: arrayItensAlterarPreco,
        tabelasPreco: tabelas,
      };

      let response = await requisicao(
        "POST",
        "/sisplan/preco/v1/alterarprecoitens?",
        "",
        JSON.stringify(precoClasse),
        null
      );

      if (!response) {
        return;
      }

      if (response.status != 200) {
        let jsonStr = await response.json();
        msgErro(jsonStr.mensagem);
        return;
      }

      toastr.success("Preço atualizado com sucesso!", "Confirmação", {
        toastClass: "success",
        iconClasses: {
          error: "alert-error",
          info: "alert-info",
          success: "alert-success",
          warning: "alert-warning",
        },
        positionClass: "toast-top-center",
        progressBar: true,
        timeOut: 3000,
        fadeOut: 1000,
        onHidden() {
          $('#txtPrecoAlterarPreco').val('')
          $('#txtPrecoAlterarPrecoSeg').val('')
        },
      })
        .css({
          "margin-top": "20%",
          width: "500px",
          "max-width": "500px",
        });

    } catch (e) {
      msgErro('Ocorreu um problema ao atualizar os preços, tente novamente.')
    } finally {
      $.LoadingOverlay('hide')
    }
  }
}