$("#tutorial").on("click", function () {
  $(document).ready(async function () {
    const driver = new Driver({
      doneBtnText: "Sair",
      closeBtnText: "Fechar",
      nextBtnText: "Próximo",
      prevBtnText: "Anterior",
      allowClose: false,
    });
    driver.defineSteps([
      {
        element: "#btnFiltros",
        popover: {
          title: "Botão Filtros",
          description: "Clique aqui para filtrar a consulta.",
          position: "right",
        },
      },
      {
        element: "#btnNovaOrdemProducao",
        popover: {
          title: "Botão Incluir",
          description: "Clique aqui para incluir uma nova ordem de produção.",
          position: "right",
        },
      },
      {
        element: "#tabelaOs",
        popover: {
          title: "Tabela Ordem de Produção Simples",
          description: "Aqui estão os dados das ordens de produção cadastradas.",
          position: "top",
        },
      },
    ]);
    driver.start();
  });
});

$(document).ready(async function () {
  const permissaoUsuarioLogado = await permissaoAcessos("ORDEM_SERVICO");

  $('#txtOs').autocompleta(1, `JSON={ "tabela":"OS", "camposSelect":[ "OS.NUMERO chave", "ENTIDADE.NOME descricao"], "leftJoin": [{"tabela": "ENTIDADE", "condicao": "ENTIDADE.CODCLI = OS.CLIENTE"}], "where": null}`);
  $('#btn-Os').pesquisa('#txtOs', 'NUMERO', 'NOME', `/sisplan/funcoes/v1/pesquisa?JSON={ "tabela":"OS", "camposSelect":[ "OS.NUMERO", "ENTIDADE.NOME"], "leftJoin": [{"tabela": "ENTIDADE", "condicao": "ENTIDADE.CODCLI = OS.CLIENTE"}]}`, 'Pesquisa OS', 'OS');

  $('#btn-limpa-Os').on('click', function () {
    $('#txtOs').val('');
  });

  componenteFiltro('cliente', false, false)

  $('#btnLimparFiltros').on('click', function () {
    $('#txtOs').val('');
    $('#txtCliente').val('');
    $('#dtEmissaoDe').val('1200-01-01');
    $('#dtEmissaoAte').val('2500-12-31');
    $('#dtEntregaDe').val('1200-01-01');
    $('#dtEntregaAte').val('2500-12-31');
  });

  $('#btnFiltros').on('click', function () {
    $('#modal-filtros').modal('show');
  });

  $('#btnNovaOrdemProducao').on('click', function () {
    if (permissaoUsuarioLogado.INCLUI == 'S') {
      window.location.href = "ordemservico/create";
    } else {
      msgAlertaSemConfirmacao("Sem permissão para incluir!");
    }
  });

  setarDataAtual('dtEmissaoAte');
  setarDataAtual('dtEmissaoDe');

  await consultaOs();

  async function consultaOs() {
    try {
      $.LoadingOverlay("show");
      const codSituacao = $('input[name="rdSituacao"]:checked').val();
      let situacao = '';

      if (codSituacao == 'RF') {
        situacao = `AND (OS.SITUACAO = 'R' OR OS.SITUACAO = 'F' )`;
      } else if (codSituacao == 'BP') {
        situacao = `AND (OS.SITUACAO = 'B' OR OS.SITUACAO = 'P' )`;
      } else if (codSituacao != '') {
        situacao = `AND OS.SITUACAO = '${codSituacao}'`;
      }

      let sWhere = ' ';
      sWhere += (pegaChave('#txtOs') == '' ? '' : ` AND OS.NUMERO = '${pegaChave('#txtOs')}'`);
      sWhere += (pegaChave('#txtCliente') == '' ? '' : ` AND OS.CLIENTE = '${pegaChave('#txtCliente')}'`);
      sWhere += (pegaValor('#dtEmissaoDe') == '' ? '' : ` AND OS.DT_INICIO >= '${pegaValor('#dtEmissaoDe')}'`);
      sWhere += (pegaValor('#dtEmissaoAte') == '' ? '' : ` AND OS.DT_INICIO <= '${pegaValor('#dtEmissaoAte')}'`);
      sWhere += (pegaValor('#dtEntregaDe') == '' ? '' : ` AND OS.DT_FINAL >= '${pegaValor('#dtEntregaDe')}'`);
      sWhere += (pegaValor('#dtEntregaAte') == '' ? '' : ` AND OS.DT_FINAL <= '${pegaValor('#dtEntregaAte')}'`);
      sWhere += situacao
      const params = `{"tabela":"OS", "camposSelect":[ "OS.NUMERO", "OS.CLIENTE", "ENTIDADE.NOME", "OS.DUPLICATA", "OS.SITUACAO", "OS.DT_INICIO", "OS.USUARIO", "OS.VALOR"], "leftJoin": [{"tabela": "ENTIDADE", "condicao": "ENTIDADE.CODCLI = OS.CLIENTE"}],"where": ["1=1 ${sWhere}"], "orderBy": ["OS.NUMERO DESC"]}`;

      const jsonStr = await retornaJsonPesquisaPadrao(params);

      $('#tabelaOs').DataTable({
        destroy: true,
        ordering: true,
        lengthChange: false,
        serverside: true,
        "language": {
          "sEmptyTable": "Nenhum registro encontrado",
          "sInfo": "_TOTAL_ registros",
          "sInfoEmpty": " 0 registros",
          "sInfoFiltered": "(Filtrados de _MAX_ registros)",
          "sInfoPostFix": "",
          "sInfoThousands": ".",
          "sLengthMenu": "_MENU_ resultados",
          "sLoadingRecords": "Carregando...",
          "sProcessing": "Processando...",
          "sZeroRecords": "Nenhum registro encontrado",
          "sSearch": "Pesquisar",
          "oPaginate": {
            "sNext": "Próximo",
            "sPrevious": "Anterior",
            "sFirst": "Primeiro",
            "sLast": "Último"
          },
          "oAria": {
            "sSortAscending": ": Ordenar colunas de forma ascendente",
            "sSortDescending": ": Ordenar colunas de forma descendente"
          }
        },
        "autoWidth": true,
        "data": jsonStr,
        "columns": [{ "data": "NUMERO" }, { "data": "CLIENTE" }, { "data": "NOME" }, { "data": "SITUACAO" }, { "data": "DT_INICIO" }, { "data": "USUARIO" }, { "data": "VALOR" }, { "data": "DUPLICATA" }],
        "columnDefs": [{
          targets: [0], render: function (data, type, row) {
            return retornaBotaoOpcoes(data);
          },
        },
        {
          targets: [4], render: function (data, type, row) {
            return new Intl.DateTimeFormat("pt-BR").format(
              new Date(`${data.split(" ")[0]} 23:59:59`)
            );
          }
        },
        {
          targets: [3], render: function (data, type, row) {
            if (data == 'P') {
              return 'Em Aberto'
            } else if (data == 'B') {
              return 'Encerrado'
            } else if (data == 'F') {
              return 'Faturado'
            } else if (data == 'R') {
              return 'Romaneio'
            } else {
              return data
            }
          }
        },
        {
          render(data) {
            return parseFloat(data).toLocaleString("pt-BR", {
              maximumFractionDigits: 2,
              minimumFractionDigits: 2
            });
          },
          targets: [6],
          "className": 'pr-4 text-right'
        }],
        "createdRow": function (row, data, dataIndex) {
          if ((data.SITUACAO == 'P') || !(data.SITUACAO)) {
              $(row).css('background-color', 'rgba(245, 81, 81, 1)');
          } else if (data.SITUACAO == 'R') {
              $(row).css('background-color', 'rgba(67, 57, 205, 1)');
          } else if (data.SITUACAO == 'F') {
             $(row).css('background-color', 'rgba(114, 103, 103, 1)').css('color', 'white');
          } else if (data.SITUACAO == 'B') {
              $(row).css('background-color', 'rgba(43, 156, 43, 1)');
          }
      }
      });

      $.LoadingOverlay("hide");
    } catch (error) {
      console.error(error);
      $.LoadingOverlay("hide");
    }

  }

  function retornaBotaoOpcoes(data) {
    var retorno = '<div style="text-align:start;"> ' +
      '    <button class="btn btn-info btn-sm dropdown-toggle btnVerificaOpcoes" id="tutorialTabela" type="button" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false"> ' +
      '      ' + data + ' ' +
      '    </button> ' +
      '    <div class="dropdown-menu"> ' +
      '    <button class="dropdown-item" type="button" title="Editar" id="btn-editar">Editar</button>     ' +
      '    <button class="dropdown-item" type="button" title="Ver Receber" id="btn-verReceber">Ver Receber</button>     ' +
      '    <button class="dropdown-item" type="button" title="Gerar/Baixar Receber" id="btn-gerarReceber">Gerar/Baixar Receber</button>     ' +
      '    <button class="dropdown-item" type="button" title="Faturar O.S." id="btn-faturaServico">Faturar Ordem de Serviço</button>     ' +
      '    <button class="dropdown-item" type="button" title="Imprimir O.S. Individual" id="btn-ImprimeOs">Imprimir O.S.</button>     ' +
      '    <button class="dropdown-item" type="button" title="Encerrar a O.S." id="btn-EncerrarOs">Encerrar O.S.</button>     ' +
      '    <button class="dropdown-item" type="button" title="Entregar a O.S." id="btn-EntregarOS">Entregar O.S.</button>     ' +
      '    <button class="dropdown-item" type="button" title="Estornar a O.S." id="btn-EstornarOS">Estornar O.S.</button>     ' +
      '    <button class="dropdown-item" type="button" title="Excluir a O.S." id="btn-ExcluirOS">Excluir O.S.</button>     ' +
      '</div>';
    return retorno;
  };

  $('#tabelaOs').on('click', '#btn-editar', async function () {
    if (permissaoUsuarioLogado.ALTERA == 'S') {
      let data = $('#tabelaOs').DataTable().row($(this).parents('tr')).data();
      if ((data.SITUACAO == 'F') || (data.SITUACAO == 'B')){
        msgAlerta('Ordem de Serviço Faturada/Encerrada. Impossível alterar!')
        return;
      }
      let registroLiberado = await verificarRegistro('NUMERO', data.NUMERO);
      if (registroLiberado) {
        window.location.href = `ordemservico/${data.NUMERO}`;
      }
    } else {
      msgAlertaSemConfirmacao("Sem permissão para alterar!");
    }
  });

  $('#tabelaOs').on('dblclick', 'tr', async function () {
    if (permissaoUsuarioLogado.ALTERA == 'S') {
      let data = $('#tabelaOs').DataTable().row($(this)).data();
      if ((data.SITUACAO == 'F') || (data.SITUACAO == 'B')){
        msgAlerta('Ordem de Serviço Faturada/Encerrada. Impossível alterar!')
        return;
      }
      let registroLiberado = await verificarRegistro('NUMERO', data.NUMERO);
      if (registroLiberado) {
        window.location.href = `ordemservico/${data.NUMERO}`;
      }
    } else {
      msgAlertaSemConfirmacao("Sem permissão para alterar!");
    }
  });

  $('#tabelaOs').on('click', '#btn-verReceber', async function () {
    $.LoadingOverlay('show')
    try {
      let data = $('#tabelaOs').DataTable().row($(this).parents('tr')).data();

      const documentoPrincipal = window.parent.document
      const tabReceber = documentoPrincipal.querySelector('.content-wrapper.iframe-mode').querySelector('.tab-content').querySelector('#panel--sisplan_web-receber')

      if ((tabReceber == null) ||
        (tabReceber.querySelector('iframe').contentDocument.querySelector('#bodyReceber') == null)) {
        if (data.DUPLICATA != '') {
          localStorage.setItem('duplicataservico', JSON.stringify({ DUPLICATA: data.DUPLICATA.split(',')[0] }))
        } else if (data.CLIENTE != '') {
          localStorage.setItem('clienteservico', JSON.stringify({ CODCLI: data.CLIENTE, NOME: data.NOME }))
        }

        parent.document.querySelector('#menu_contas_a_receber  .nav-link').click();
      } else {
        await msgAlerta('Já existe uma duplicata em inclusão/alteração, finalize o cadastro antes de continuar.')
      }

    } catch (error) {
      console.error(error)
      msgAlerta(error.message)
    } finally {
      $.LoadingOverlay('hide')
    }
  });

  $('#tabelaOs').on('click', '#btn-gerarReceber', async function () {
    $.LoadingOverlay('show')
    try {
      let data = $('#tabelaOs').DataTable().row($(this).parents('tr')).data();

      const pesquisa = {
        tabela: 'OS',
        camposSelect: ['ENTIDADE.CLASSE',
          'CLASSE_GER.DESCRICAO DESC_CLASSE',
          'ENTIDADE.HISTORICO',
          'HISTCP.DESCRICAO DESC_HISTORICO',
          'ENTIDADE.BANCO',
          'CADBAN.NOME_BANCO',
          'ENTIDADE.SIT_DUP',
          'TABSIT.DESCRICAO DESC_SIT',
          'OS.VALOR',
          'OS.VALOR_HR',
          'OS.DUPLICATA',
          'OS.SITUACAO',
          'OS.DT_FINAL'],
        leftJoin: [
          { tabela: 'ENTIDADE', condicao: 'ENTIDADE.CODCLI = OS.CLIENTE' },
          { tabela: 'CLASSE_GER', condicao: 'CLASSE_GER.CODIGO = ENTIDADE.CLASSE' },
          { tabela: 'HISTCP', condicao: 'HISTCP.HISTORICO = ENTIDADE.HISTORICO' },
          { tabela: 'CADBAN', condicao: 'CADBAN.BANCO = ENTIDADE.BANCO' },
          { tabela: 'TABSIT', condicao: 'TABSIT.CODIGO = ENTIDADE.SIT_DUP' },
        ],
        where: [`OS.NUMERO = '${data.NUMERO}'`]
      }

      const json = await retornaJsonPesquisaPadrao(JSON.stringify(pesquisa));

      if (json != undefined && json.length <= 0) {
        throw new Error('Não foi possivel buscar os dados do cliente')
      }
      if ((parseFloat(json[0].VALOR) + parseFloat(json[0].VALOR_HR)) <= 0) {
        throw new Error('Ordem de Serviço sem Valor. Impossível Continuar.')
      }
      if (json[0].DUPLICATA != '') {
        throw new Error('Ja existe duplicata para esta ordem de serviço. Impossível Continuar')
      }
      if (json[0].SITUACAO != 'B') {
        throw new Error('Ordem de Serviço não está Baixada. Impossível Continuar.')
      }
      if (json[0].DT_FINAL == '' || json[0].DT_FINAL == null) {
        throw new Error('Ordem de Serviço sem data de entrega. Impossível Continuar.')
      }

      insereValor('#txtClasse', json[0].CLASSE, json[0].DESC_CLASSE);
      insereValor('#txtHistorico', json[0].HISTORICO, json[0].DESC_HISTORICO);
      insereValor('#txtBanco', json[0].BANCO, json[0].NOME_BANCO);
      insereValor('#txtSituacao', json[0].SIT_DUP, json[0].DESC_SIT);
      $('#txtValor').val(((parseFloat(json[0].VALOR) + parseFloat(json[0].VALOR_HR))).toFixed(2))
      $('#txtValorParc').val(0)
      $('#txtParcelas').val(1)
      $('#txtIntDias').val(0)
      $('#txtNumero').val(await RetornaProximo('NUMERO', 'RECEBER', 'NUMERO', 6))
      $('#txtOrdemServico').val(data.NUMERO)
      $('#txtEmissao').val(retornaDataAtual())
      let dataVencimento = new Date();
      dataVencimento.setDate(dataVencimento.getDate() + 30);
      $('#txtVencimento').val(formataData(dataVencimento))
      $('#txtPrimeiroVencto').val(formataData(dataVencimento))


      $('#modal-gerarReceber').modal('show');

    } catch (error) {
      console.error(error)
      msgAlerta(error.message)
    } finally {
      $.LoadingOverlay('hide')
    }
  });

  $('#modal-gerarReceber').on('show.bs.modal', async function () {
    $.LoadingOverlay('show')
    try {
      aplicaMascaraCampos()
      await criaPesquisaReceber()

      $('#tabelaReceber').DataTable({
        destroy: true,
        ordering: false,
        lengthChange: false,
        serverside: true,
        "language": {
          "sEmptyTable": "Nenhum registro encontrado",
          "sInfo": "_TOTAL_ registros",
          "sInfoEmpty": " 0 registros",
          "sInfoFiltered": "(Filtrados de _MAX_ registros)",
          "sInfoPostFix": "",
          "sInfoThousands": ".",
          "sLengthMenu": "_MENU_ resultados",
          "sLoadingRecords": "Carregando...",
          "sProcessing": "Processando...",
          "sZeroRecords": "Nenhum registro encontrado",
          "sSearch": "Pesquisar",
          "oPaginate": {
            "sNext": "Próximo",
            "sPrevious": "Anterior",
            "sFirst": "Primeiro",
            "sLast": "Último"
          },
          "oAria": {
            "sSortAscending": ": Ordenar colunas de forma ascendente",
            "sSortDescending": ": Ordenar colunas de forma descendente"
          }
        },
        "autoWidth": true,
      });

    } catch (error) {
      console.error(error)
      msgAlerta(error.message)
    } finally {
      $.LoadingOverlay('hide')
    }
  });

  $('#modal-gerarReceber').on('hide.bs.modal', async function () {
    $('#tabelaReceber').DataTable().clear().draw();
    $('#txtMoeda').val('');
    $('#txtValor').val('');
    $('#txtValorParc').val('0');
    $('#txtParcelas').val('1');
    $('#txtIntDias').val('0');
    $('#cbBaixarReceber').prop('checked', false);
    $('#divConta').addClass('d-none')
    $('#txtConta').val('')
  });

  $('#btnDesistirReceber').on('click', async function () {
    const existeRegistroTabelaReceber = $('#tabelaReceber').DataTable().data().toArray().length;

    if (existeRegistroTabelaReceber <= 0) {
      $.LoadingOverlay('show');
      $('#modal-gerarReceber').modal('hide');
      $.LoadingOverlay('hide');
    }

    if (existeRegistroTabelaReceber > 0) {
      msgAlerta('Existem parcelas geradas, caso desista elas não serão gravadas! Tem certeza que deseja desistir?', () => {
        $.LoadingOverlay('show');
        $('#modal-gerarReceber').modal('hide');
        $.LoadingOverlay('hide');
      })
    }
  });

  $('#btnGerarReceber').on('click', async function () {
    $.LoadingOverlay('show')
    try {
      const tabelaReceberData = $('#tabelaReceber').DataTable().data().toArray().length;

      if (tabelaReceberData > 0) {
        await msgAguardaConfirmacao('Já existem parcelas geradas, deseja gerar novamente?', async () => {
          $('#tabelaReceber').DataTable().clear().draw();
          const dataVencto = parseDate($('#txtPrimeiroVencto').val())
          dataVencto.setHours(0, 0, 0, 0)
          const dataAtual = new Date();
          dataAtual.setHours(0, 0, 0, 0)

          if (dataVencto < dataAtual) {
            msgAguardaConfirmacao('Receber esta sendo lançado vencido. Deseja Continuar?', async () => {
              await geraDuplicatas()
            })
          } else {
            await geraDuplicatas()
          }

          return
        }, () => { return })
      }
      function parseDate(input) {
        var parts = input.split('-');
        return new Date(parts[0], parts[1] - 1, parts[2]);
      }

      const dataVencto = parseDate($('#txtPrimeiroVencto').val())
      dataVencto.setHours(0, 0, 0, 0)
      const dataAtual = new Date();
      dataAtual.setHours(0, 0, 0, 0)

      if (dataVencto < dataAtual) {
        msgAguardaConfirmacao('Receber esta sendo lançado vencido. Deseja Continuar?', async () => {
          await geraDuplicatas()
        })
      } else {
        await geraDuplicatas()
      }
    } catch (error) {
      console.error(error)
      msgAlerta(error.message)
    } finally {
      $.LoadingOverlay('hide')
    }
  })

  async function geraDuplicatas() {
    $.LoadingOverlay('show')
    try {
      const filtros = `NUMERO=${$('#txtNumero').val()}&EMP_ID=${getCookie('emp_id')}&VALOR=${parseFloat($('#txtValor').val())}&NPARC=${parseInt($('#txtParcelas').val())}&DIAS=${parseInt($('#txtIntDias').val())}&VENCIMENTO=${formataDataBonita($('#txtPrimeiroVencto').val(), true)}&EMISSAO=${formataDataBonita($('#txtEmissao').val())}`
      let response = await requisicao("GET", `/Sisplan/os/V1/gerareceber?`, filtros);

      let json = await response.json();
      criaTabelaReceber(json)
    } catch (error) {
      console.error(error)
      msgAlerta(error.message)
    } finally {
      $.LoadingOverlay('hide')
    }
  }

  function criaTabelaReceber(info) {
    if ($.fn.DataTable.isDataTable('#tabelaReceber')) {
      $('#tabelaReceber').DataTable().destroy();
      $('#tabelaReceber').empty();
    }

    function carregaInput(valor, indices) {
      try {

        switch (indices.col) {
          case 2: {
            return `<input type="text" id="txtValor_${indices.row}"
                          class="input-default focus form-control text-right campoValor"
                          style="width: 15ch" value="${valor}">`;
          }
          case 3: {
            return `<input type="date" max="2500-12-31" style="width: 22ch" class="input-default focus form-control validate" id="txtVencto_${indices.row}" value="${valor.split('/')[2] + '-' + valor.split('/')[1] + '-' + valor.split('/')[0]}"></input>`;
          }
          default:
            break;
        }

      } catch (e) {
        msgErro(`Não foi possível carregar os dados: ${e}`);
        console.log(e);
      }
    }

    const cols = [{
      data: 'NUMAP',
      title: 'Num Rec'
    },
    {
      data: 'DUPLICATA',
      title: 'Duplicata'
    },
    {
      data: 'VALOR',
      title: 'Valor'
    },
    {
      data: 'VENCIMENTO',
      title: 'Vencimento'
    },
    {
      data: 'EMISSAO',
      title: 'Emissão'
    },
    {
      data: 'COMPETENCIA',
      title: 'Competencia'
    },
    {
      data: 'DIA_SEMANA',
      title: 'Dia da Semana'
    }]

    $('#tabelaReceber').DataTable({
      destroy: true,
      ordering: false,
      lengthChange: false,
      serverside: true,
      "language": {
        "sEmptyTable": "Nenhum registro encontrado",
        "sInfo": "_TOTAL_ registros",
        "sInfoEmpty": " 0 registros",
        "sInfoFiltered": "(Filtrados de _MAX_ registros)",
        "sInfoPostFix": "",
        "sInfoThousands": ".",
        "sLengthMenu": "_MENU_ resultados",
        "sLoadingRecords": "Carregando...",
        "sProcessing": "Processando...",
        "sZeroRecords": "Nenhum registro encontrado",
        "sSearch": "Pesquisar",
        "oPaginate": {
          "sNext": "Próximo",
          "sPrevious": "Anterior",
          "sFirst": "Primeiro",
          "sLast": "Último"
        },
        "oAria": {
          "sSortAscending": ": Ordenar colunas de forma ascendente",
          "sSortDescending": ": Ordenar colunas de forma descendente"
        }
      },
      "autoWidth": true,
      "data": info,
      "columns": cols,
      "columnDefs": [{
        targets: [2, 3],
        render: function (data, v2, v3, index) {
          return carregaInput(data, index);
        }
      },
      {
        type: "date-br",
        render(data) {
          return new Intl.DateTimeFormat("pt-BR").format(
            new Date(`${data.split(" ")[0]} 23:59:59`)
          );
        },
        targets: [4, 5],
      },]
    });

    aplicaMascaraCampos()
  }

  function aplicaMascaraCampos() {
    $(".campoValor").maskMoney({
      decimal: '.',
      thousands: '',
      precision: 2,
    }).on("focus", function () {
      var that = $(this);
      setTimeout(function () {
        that.select();
      }, 1)
    }).on('blur', function () {
      if (isNaN(parseFloat($(this).val())) || parseFloat($(this).val()) <= 0) {
        $(this).val(0)
      }
    })
  }

  $('#txtParcelas').on('blur', function () {
    if (($(this).val() > 0) && parseFloat($('#txtValor').val()) > 0) {
      return
    }
    $.LoadingOverlay('show')
    try {
      if ($(this).val() == 0) {
        $(this).val(1)
      }

      if (parseFloat($('#txtValor').val()) <= 0) {
        const novoValor = parseFloat($('#txtValorParc').val()) * parseInt($('#txtParcelas').val())
        $('#txtValor').val(parseFloat(novoValor))
      }
    } catch (error) {
      console.error(error)
      msgAlerta(error.message)
    } finally {
      $.LoadingOverlay('hide')
    }
  })

  $('#txtIntDias').on('blur', function () {
    $.LoadingOverlay('show')
    try {
      let novaData = new Date();
      novaData.setDate(novaData.getDate() + parseInt($('#txtIntDias').val()));

      $('#txtPrimeiroVencto').val(formataData(novaData))
    } catch (error) {
      console.error(error)
      msgAlerta(error.message)
    } finally {
      $.LoadingOverlay('hide')
    }
  })

  $('#cbBaixarReceber').on('change', function () {
    if ($(this).is(':checked')) {
      $('#divConta').removeClass('d-none')
    } else {
      $('#divConta').addClass('d-none')
    }
  })

  async function validacoesReceber() {
    if ($('#txtClasse').val() == '') {
      throw new Error('Classe Gerencial não informada!')
    }
    if ($('#txtHistorico').val() == '') {
      throw new Error('Histórico não informads!')
    }
    if ($('#txtBanco').val() == '') {
      throw new Error('Banco não informado!')
    }
    if ($('#txtSituacao').val() == '') {
      throw new Error('Situação não informada!')
    }
    if ($('#txtMoeda').val() == '') {
      throw new Error('Moeda não informada!')
    }
    if ((!$('#divConta').hasClass('d-none')) && ($('#txtConta').val() == '')) {
      throw new Error('Conta não informada!')
    }
    if (!$.fn.DataTable.isDataTable('#tabelaReceber') || $('#tabelaReceber').DataTable().data().toArray().length <= 0) {
      throw new Error('Nenhuma duplicata foi gerada!')
    }

  }

  $('#btnConfirmarReceber').on('click', async function () {
    $.LoadingOverlay('show')
    try {
      const existeRegistroTabelaReceber = $('#tabelaReceber').DataTable().data().toArray().length;

      if (existeRegistroTabelaReceber <= 0) {
        await msgAlerta('Nenhuma duplicata gerada!')
        return
      }

      let valorTotal = 0
      for (let i = 0; i < $('#tabelaReceber').DataTable().data().toArray().length; i++) {
        valorTotal = parseFloat(valorTotal) + parseFloat($(`#txtValor_${i}`).val())
      }

      if (parseFloat(valorTotal).toFixed(2) != parseFloat($('#txtValor').val()).toFixed(2)) {
        await msgAguardaConfirmacao('Valor das parcelas está divergente do valor informado, deseja recalcular?',
          async () => {
            $('#btnGerarReceber').trigger('click')
          },
          async () => {
            return
          }
        )
      } else {
        await validacoesReceber();
        await msgAguardaConfirmacao('Deseja gravar as duplicatas geradas?', async () => {
          await gravarDuplicatas()
        }, async () => { return })

      }


    } catch (error) {
      console.error(error)
      msgAlerta(error.message)
    } finally {
      $.LoadingOverlay('hide')
    }
  })

  async function gravarDuplicatas() {
    $.LoadingOverlay('show')
    try {
      const classeReceber = await montaClasseReceber();
      const response = await requisicao('POST', '/sisplan/os/v1/gerareceber?', '', `JSON=${encodeURIComponent(JSON.stringify(classeReceber))}`, 90000);
      if (!response) {
        $.LoadingOverlay('hide');
        return;
      }

      const jsonStr = await response.json();
      if (response.status != 200) {
        $.LoadingOverlay('hide');
        msgErro(jsonStr.mensagem);
        return;
      }

      criaMensagemSucesso('Duplicatas gravada com sucesso.', () => { $('#modal-gerarReceber').modal('hide') });
    } catch (error) {
      console.error(error)
      msgAlerta(error.message)
    } finally {
      $.LoadingOverlay('hide')
    }
  }

  async function montaClasseReceber() {
    const cliente = await buscaValor('OS', 'CLIENTE', 'NUMERO', $('#txtOrdemServico').val())
    const classe = {
      CLASSE: pegaChave('#txtClasse'),
      HISTORICO: pegaChave('#txtHistorico'),
      BANCO: pegaChave('#txtBanco'),
      SITUACAO: pegaChave('#txtSituacao'),
      MOEDA: pegaChave('#txtMoeda'),
      CONTA: $('#cbBaixarReceber').is(':checked') ? pegaChave('#txtConta') : '',
      ORDEMSERVICO: $('#txtOrdemServico').val(),
      VALORORIG: $('#txtValor').val(),
      CODCLI: cliente.CLIENTE,
      DUPLICATAS: await retornaDuplicatas()
    }

    return classe
  }

  async function retornaDuplicatas() {
    const duplicatas = []

    for (let i = 0; i < $('#tabelaReceber').DataTable().data().toArray().length; i++) {
      const item = $('#tabelaReceber').DataTable().row(i).data()

      const obj = {
        DUPLICATA: item.DUPLICATA,
        EMISSAO: item.EMISSAO,
        VALOR: $(`#txtValor_${i}`).val(),
        VENCIMENTO: $(`#txtVencto_${i}`).val(),
      }

      duplicatas.push(obj)
    }

    return duplicatas
  }

  async function criaPesquisaReceber() {
    await componenteFiltro('classe', false, false)
    await componenteFiltro('historico', false, false)
    await componenteFiltro('banco', false, false)
    await componenteFiltro('situacao', false, false)
    await componenteFiltro('moeda', false, false)
    await componenteFiltro('conta', false, false)
  }

  $('#btnConsultar').on('click', async function () {
    $('#modal-filtros').modal('hide');
    await consultaOs();
  });

  $('#tabelaOs').on('click', '#btn-faturaServico', async function () {
    $.LoadingOverlay('show');
    try {
      let data = $('#tabelaOs').DataTable().row($(this).parents('tr')).data();

      const documentoPrincipal = window.parent.document
      const tabReceber = documentoPrincipal.querySelector('.content-wrapper.iframe-mode').querySelector('.tab-content').querySelector('#panel--sisplan_web-receber')

      if ((tabReceber == null) ||
        (tabReceber.querySelector('iframe').contentDocument.querySelector('#bodyReceber') == null)) {
        if (data.DUPLICATA != '') {
          localStorage.setItem('duplicataservico', JSON.stringify({ DUPLICATA: data.DUPLICATA.split(',')[0] }))
        } else if (data.CLIENTE != '') {
          localStorage.setItem('clienteservico', JSON.stringify({ CODCLI: data.CLIENTE, NOME: data.NOME }))
        }

        parent.abrirEmNovaAbaIFrame('Faturamento de Serviço', `${BASE_URI}/fatservico`, `/${data.NUMERO}`)
      } else {
        await msgAlerta('Já existe uma duplicata em inclusão/alteração, finalize o cadastro antes de continuar.')
      }

    } finally {
      $.LoadingOverlay('hide');
    }
  });

  $("#btnImprimir").on("click", async function () {
    try {
      $.LoadingOverlay("show");
      const url = `/sisplan/impressao/v1/imprimeacessoos?`;

      if ($('#tabelaOs').DataTable().data().toArray().length <= 0) {
        msgAlerta('Nenhum registro para ser impresso, por favor verifique! Tente novamente');
        return
      }

      const dtEmiDe = $('#dtEmissaoDe').val();
      const dtEmiAte = $('#dtEmissaoAte').val();
      const dtEntregaDe = $('#dtEntregaDe').val();
      const dtEntregaAte = $('#dtEntregaAte').val();
      const numeroOs = pegaChave('#txtOs');
      const situacaoOs = $('input[name="rdSituacao"]:checked').val();
      const filtros = `DT_EMI_DE=${dtEmiDe}&DT_EMI_ATE=${dtEmiAte}&DT_ENTREGA_DE=${dtEntregaDe}&DT_ENTREGA_ATE=${dtEntregaAte}&ORDEM_SERVICO=${numeroOs}&SITUACAO=${situacaoOs}`
      const ordem = `&TELA_ORDENACAO=AcessoOrdemServico&`;
      const bImprimeAutomatico = await verificaImprimirAutomatico('AcessoOrdemServico');
      const arquivo = await GeraRelatorio(`${url}${filtros}${ordem}&`, "GET", 15000, false, 'AcessoOrdemServico');
      if (arquivo != undefined) {
        if (!bImprimeAutomatico) {
          window.open(`${BASE_URI}/relatorios_api/pdf/${arquivo}`, "_blank");
        }
        await limparRelatorios();
      }
    } finally {
      $.LoadingOverlay("hide");
    }
  });

  $('#tabelaOs').on('click', '#btn-ImprimeOs', async function () {
    try {
      $.LoadingOverlay("show");
      const url = `/sisplan/impressao/v1/imprimeosindividual?`;

      const data = $('#tabelaOs').DataTable().row($(this).parents('tr')).data();
      const filtros = `ORDEM_SERVICO=${data.NUMERO}`
      const ordem = `&TELA_ORDENACAO=OrdemServicoIndividual&`;
      const bImprimeAutomatico = await verificaImprimirAutomatico('OrdemServicoIndividual');
      const arquivo = await GeraRelatorio(`${url}${filtros}${ordem}&`, "GET", 15000, false, 'OrdemServicoIndividual');
      if (arquivo != undefined) {
        if (!bImprimeAutomatico) {
          window.open(`${BASE_URI}/relatorios_api/pdf/${arquivo}`, "_blank");
        }
        await limparRelatorios();
      }
    } finally {
      $.LoadingOverlay("hide");
    }
  });

  $('#tabelaOs').on('click', '#btn-EncerrarOs', async function () {
    try {
      $.LoadingOverlay("show");
      const url = `/sisplan/os/v1/movimentaos?`;

      const data = $('#tabelaOs').DataTable().row($(this).parents('tr')).data();
      const filtros = `ORDEM_SERVICO=${data.NUMERO}&TIPO_MOVIMENTO=ENCERRAR`
      const response = await requisicao("PUT", url, filtros, '', 90000);

      const json = await response.json();

      if (json.length == 0) {
        msgAlerta('Nenhum registro encontrado!');
        return;
      }

      if (response.status != 200) {
        msgAlerta(json.mensagem);
        return;
      }

      await criaMensagemSucesso('Ordem de serviço encerrada com sucesso!', () => { 
        $('#btnConsultar').trigger('click');
      });

    } finally {
      $.LoadingOverlay("hide");
    }
  });

  $('#tabelaOs').on('click', '#btn-EstornarOS', async function () {
    try {
      $.LoadingOverlay("show");
      const url = `/sisplan/os/v1/movimentaos?`;

      const data = $('#tabelaOs').DataTable().row($(this).parents('tr')).data();
      const filtros = `ORDEM_SERVICO=${data.NUMERO}&TIPO_MOVIMENTO=ESTORNO`
      const response = await requisicao("PUT", url, filtros, '', 90000);

      const json = await response.json();

      if (json.length == 0) {
        msgAlerta('Nenhum registro encontrado!');
        return;
      }

      if (response.status != 200) {
        msgAlerta(json.mensagem);
        return;
      }

      await criaMensagemSucesso('Ordem de serviço estornada com sucesso!', () => { 
        $('#btnConsultar').trigger('click');
      });

    } finally {
      $.LoadingOverlay("hide");
    }
  });

  $('#tabelaOs').on('click', '#btn-EntregarOS', async function () {
    $('#modalEntregaOs').modal('show');
    const data = $('#tabelaOs').DataTable().row($(this).parents('tr')).data();
    $('#txtOrdemServicoEntrega').val(data.NUMERO);
  });

  $('#modalEntregaOs').on('shown.bs.modal', function () {
    const hoje = new Date();
    const dia = ("0" + hoje.getDate()).slice(-2);
    const mes = ("0" + (hoje.getMonth() + 1)).slice(-2);
    const ano = hoje.getFullYear();
    const dataFormatada = dia + "/" + mes + "/" + ano;

    const horas = ("0" + hoje.getHours()).slice(-2);
    const minutos = ("0" + hoje.getMinutes()).slice(-2);
    const segundos = ("0" + hoje.getSeconds()).slice(-2);
    const horaFormatada = horas + ":" + minutos + ":" + segundos;

    $('#txtDataEntrega').val(dataFormatada);
    $('#txtHorarioEntrega').val(horaFormatada);
  });

  $('#btnConfirmaEntrega').on('click', async function () {
    try {
      $.LoadingOverlay("show");

      if ($('#txtDataEntrega').val() == '') {
        msgAlerta('Data inválida. Por favor, tente novamente!');
        return
      }

      if ($('#txtHorarioEntrega').val() == '') {
        msgAlerta('Horário inválido. Por favor, tente novamente!');
        return
      }

      if ($('#txtClienteEntrega').val() == '') {
        msgAlerta('Cliente inválido. Por favor, tente novamente!');
        return
      }

      const dataEntrega = $('#txtDataEntrega').val();
      const horaEntrega = $('#txtHorarioEntrega').val();
      const clienteEntrega = $('#txtClienteEntrega').val();
      const osNumero = $('#txtOrdemServicoEntrega').val();

      const url = `/sisplan/os/v1/movimentaos?`;

      const filtros = `ORDEM_SERVICO=${osNumero}&TIPO_MOVIMENTO=ENTREGAR&DATA=${dataEntrega}&HORA=${horaEntrega}&DESCRICAO=${clienteEntrega}`
      const response = await requisicao("PUT", url, filtros, '', 90000);

      const json = await response.json();

      if (json.length == 0) {
        msgAlerta('Nenhum registro encontrado!');
        return;
      }

      if (response.status != 200) {
        msgAlerta(json.mensagem);
        return;
      }

      await criaMensagemSucesso('Ordem de serviço entregue com sucesso!', () => { 
        $('#btnConsultar').trigger('click');
      });

    } finally {
      $.LoadingOverlay("hide");
      $('#txtOrdemServicoEntrega').val('');
      $('#modalEntregaOs').modal('hide');
    }
  });

  async function deletaOrdemDeServico(ordemServico) {
    try {
      const url = `/sisplan/os/v1/ordemservico?`;

      const filtros = `NUMERO=${ordemServico}&TELA=ORDEM_SERVICO_WEB`
      const response = await requisicao("DELETE", url, filtros, '', 90000);

      const json = await response.json();

      if (json.length == 0) {
        msgAlerta('Nenhum registro encontrado!');
        return;
      }

      if (response.status != 200) {
        msgAlerta(json.mensagem);
        return;
      }

      await criaMensagemSucesso('Ordem de serviço excluída com sucesso!', () => {
         $('#btnConsultar').trigger('click');
        });
    } catch (error) {
      console.error(error);
      msgErro('Não foi possível excluir ordem de serviço! Por favor, verifique.');
      return;
    } 
  }

  $('#tabelaOs').on('click', '#btn-ExcluirOS', async function () {
    $.LoadingOverlay('show');
    try {
      const data = $('#tabelaOs').DataTable().row($(this).parents('tr')).data();

      if (data.SITUACAO == 'B') {
        await senhaSupervisor('Ordem de serviço já movimentada.', async () => {
          await deletaOrdemDeServico(data.NUMERO);
        }, '', false, undefined, undefined, undefined, false, 'ACESSOOS')
      } else if (data.SITUACAO == 'F') {
        msgErro('Ordem de serviço já faturada. Impossível continuar!');
        return;
      } else {
        await deletaOrdemDeServico(data.NUMERO);
      };
    } catch (error) {
      console.error(error);
      msgErro('Não foi possível excluir ordem de serviço! Por favor, verifique.');
      return;
    } finally {
      $.LoadingOverlay('hide');
    }
  });

});