$(document).ready(async function () {

  const orcamento = $(window.location.href.split('/')).get(-1);
  const parametrosComercial = await BuscaParametrosPedido();
  let itensAlteracao = []

  const colunasItens = [
    { title: 'Ordem', data: 'ORDEM' },
    { title: 'Código', data: 'CODIGO' },
    { title: 'Descrição', data: 'DESCRICAO' },
    { title: 'Cor', data: 'COR' },
    { title: 'Desc. Cor', data: 'DESCCOR' },
    { title: 'Tam', data: 'TAM' },
    { title: 'Qtde', data: 'QTDE' },
    { title: 'Preço', data: 'PRECO' },
    { title: 'Valor', data: 'VALOR' },
    { title: 'Custom', data: 'CUSTOMIZACAO' },
    { title: 'ObsProd', data: 'OBS2' },
    { title: 'ObsProducao', data: 'OBS3' },
    { title: 'ObsEspec', data: 'OBSERVACAO' },
    { title: 'Faixa', data: 'FAIXA' },
    { title: 'Excluir', data: 'EXCLUIR' },
    { title: 'Prototipo', data: 'PROTOTIPO' },
  ];

  const colunasCaracteristicas = [
    { title: 'SEL', data: 'SEL' },
    { title: 'Código', data: 'CODIGO' },
    { title: 'Descrição', data: 'DESCRICAO' },
    { title: 'Valor', data: 'VALOR' },
    { title: 'Existe', data: 'EXISTE' },
    { title: 'Id', data: 'ID' },
    { title: 'Cons. Tecido.', data: 'CONS_TECIDO' },
    { title: 'Cod. Apl.', data: 'COD_APL' },
  ];

  const colunasComposicao = [
    { title: 'Código', data: 'CODIGO' },
    { title: 'Descrição', data: 'DESCRICAO' },
    { title: 'Cor', data: 'COR' },
    { title: 'Desc Cor', data: 'DESC_COR' },
    { title: 'Fornecedor', data: 'FORNECEDOR' },
    { title: 'Nome Fornecedor', data: 'NOME_FORNECEDOR' },
    { title: 'Cód. Subcaracterística', data: 'COD_OPCIONAL' },
    { title: 'Desc. Subcaracterística', data: 'DESC_OPCIONAL' },
    { title: 'Ações', data: 'ACOES' },
  ];

  const colunasFt = [
    { title: 'Tipo', data: 'TIPO' },
    { title: 'Ordem', data: 'ORDEM' },
    { title: 'Código', data: 'CODIGO' },
    { title: 'Descrição', data: 'DESCRICAO' },
    { title: 'Consumo', data: 'CONSUMO' },
    { title: 'Cor', data: 'COR' },
  ];

  const colunasGrade = [
    { title: 'Tamanho', data: 'TAMANHO' },
    { title: 'Qtde', data: 'QTDE' },
    { title: 'Preço', data: 'PRECO' },
    { title: '% Acresc.', data: 'PERC_ACRESC' },
    { title: 'Val Acresc.', data: 'VAL_ACRESC' },
    { title: '% Desc.', data: 'PERC_DESC' },
    { title: 'Val Desc.', data: 'VAL_DESC' },
    { title: 'Preço Líq.', data: 'PRECO_LIQ' },
    { title: 'Total', data: 'TOTAL' },
  ];

  const colunasAplicacoes = [
    { title: 'Característica', data: 'CARACTERISTICA' },
    { title: 'Subcaracterística', data: 'SUBCARACTERISTICA' },
    { title: 'ID', data: 'ID' },
    { title: 'Cod. Apl.', data: 'COD_APL' },
  ];

  const colunasTecidosUtilizados = [
    { title: 'SEL', data: 'SEL' },
    { title: 'Código', data: 'CODIGO' },
    { title: 'Descrição', data: 'DESCRICAO' },
    { title: 'Altura', data: 'ALTURA' },
    { title: 'Largura', data: 'LARGURA' },
    { title: 'Fundo', data: 'FUNDO' },
    { title: 'Visor', data: 'VISOR' },
    { title: 'Consumo', data: 'CONSUMO' },
    { title: 'Cor', data: 'COR' },
    { title: 'Fornecedor', data: 'FORNECEDOR' },
    { title: 'Id', data: 'ID' },
    { title: 'Cod. Apl', data: 'COD_APL' },
  ];

  const colunasConsumos = [
    { title: 'Código', data: 'CODIGO' },
    { title: 'Descrição', data: 'DESCRICAO' },
    { title: 'Qtde', data: 'QTDE' },
    { title: 'Custo', data: 'CUSTO' },
    { title: 'Valor', data: 'VALOR' },
    { title: 'Setor', data: 'SETOR' },
    { title: 'Desc Setor', data: 'DESC_SETOR' },
    { title: 'Cor', data: 'COR' },
    { title: 'Desc Cor', data: 'DESC_COR' },
    { title: 'Cod Opcional', data: 'COD_OPCIONAL' },
  ];

  const colunasSerigrafiaTipo = [
    { title: 'Código', data: 'CODIGO' },
    { title: 'Qtde Cores', data: 'QTDE_CORES' },
    { title: 'Descrição', data: 'DESCRICAO' },
    { title: 'Preço', data: 'PRECO' },
  ];

  const colunasSerigrafiaLocal = [
    { title: 'Código', data: 'CODIGO' },
    { title: 'Descrição', data: 'DESCRICAO' },
    { title: 'Preço', data: 'PRECO' },
  ];

  const colunasSerigrafiaTamanho = [
    { title: 'Código', data: 'CODIGO' },
    { title: 'Descrição', data: 'DESCRICAO' },
  ];

  const colunasSerigrafia = [
    { title: 'Nome', data: 'NOME' },
    { title: 'Tipo', data: 'TIPO' },
    { title: 'Tamanho', data: 'TAMANHO' },
    { title: 'Local', data: 'LOCAL' },
    { title: 'Qtde Cores', data: 'QTDE_CORES' },
    { title: 'Total', data: 'TOTAL' },
    { title: 'Altura', data: 'ALTURA' },
    { title: 'Largura', data: 'LARGURA' },
    { title: 'Preço', data: 'PRECO' },
  ];

  const colunasBordadoProgramacao = [
    { title: 'Código', data: 'CODIGO' },
    { title: 'Descrição', data: 'DESCRICAO' },
    { title: 'Preço', data: 'PRECO' }
  ];

  const colunasBordadoTamanho = [
    { title: 'Código', data: 'CODIGO' },
    { title: 'Descrição', data: 'DESCRICAO' },
    { title: 'Preço', data: 'PRECO' }
  ];

  const colunasBordadoLocal = [
    { title: 'Código', data: 'CODIGO' },
    { title: 'Descrição', data: 'DESCRICAO' },
    { title: 'Preço', data: 'PRECO' },
    { title: 'Margem', data: 'MARGEM' }
  ];

  const colunasBordado = [
    { title: 'Nome', data: 'NOME' },
    { title: 'Programação', data: 'PROGRAMACAO' },
    { title: 'Tamanho', data: 'TAMANHO' },
    { title: 'Local', data: 'LOCAL' },
    { title: 'Qtde Prog', data: 'QTDE_PROG' },
    { title: 'Total', data: 'TOTAL' },
    { title: 'Altura', data: 'ALTURA' },
    { title: 'Largura', data: 'LARGURA' },
    { title: 'Preço', data: 'PRECO' },
  ];

  const colunasSublimacao = [
    { title: 'SEL', data: 'SEL' },
    { title: 'Código', data: 'CODIGO' },
    { title: 'Descrição', data: 'DESCRICAO' },
    { title: 'Preço', data: 'PRECO' },
  ];

  const colunasTermotapeTipo = [
    { title: 'Código', data: 'CODIGO' },
    { title: 'Descrição', data: 'DESCRICAO' },
    { title: 'Preço', data: 'PRECO' },
  ];

  const colunasTermotape = [
    { title: 'Código', data: 'CODIGO' },
    { title: 'Descrição', data: 'DESCRICAO' },
    { title: 'Tam CM²', data: 'TAM_CM2' },
    { title: 'Total', data: 'TOTAL' },
    { title: 'Preço', data: 'PRECO' },
  ];

  const colunasDuplicatas = [
    { title: 'Parcela', data: 'PARCELA' },
    { title: 'Vencimento', data: 'VENCIMENTO' },
    { title: 'Valor', data: 'VALOR' },
  ];

  let idCaracteristica = '';

  await verificaPermissoes('ORCAMENTO');
  await adicionaEmpresas();
  await setarDataAtual('dtDigitacao');
  await setarDataAtual('dtEmissao');
  await carregaValoresPadroes();

  addPesquisaAutocompleta();
  criaMascaraCampos();
  await addBotoesAvancarVoltar();
  addValidacaoCamposObrigatorios();

  const retornaBotaoOpcoes = () => {
    return '<div class="p-0 d-flex"> ' +
      '     <button class="botaoOpcoes btn-sm" type="button" title="Editar" id="btn-editar" style="background-color:var(--blue); padding: 5px 1px 5px 6px;"><span class="fas fa-edit" style="color:white !important"></span></button>  ' +
      '     <button class="divBtnItens botaoOpcoes btn-sm" type="button" title="Excluir" id="btn-excluir" style="padding: 5px 2px 5px 4px;"><span class="fas fa-trash-alt" style="color:white !important"></span></button>  ' +
      '   </div>';
  };

  criaDataTablePadrao('#tabelaDuplicatas', false, false, false, false, true, false, '193px', undefined, colunasDuplicatas, [], [1], [], [2]);
  criaDataTablePadrao('#tabelaItens', false, false, false, false, true, false, '300px', undefined, colunasItens, [10, 11, 12, 13, 15], [], [], [], { targets: 14, funcao: function (data, type, row) { return retornaBotaoOpcoes() } });
  criaDataTablePadrao('#tabelaCaracteristicas', false, false, false, false, true, false, '300px', undefined, colunasCaracteristicas, [4, 5, 6, 7]);
  criaDataTablePadrao('#tabelaComposicao', false, false, false, false, true, false, '300px', undefined, colunasComposicao);
  criaDataTablePadrao('#tabelaFt', false, false, false, false, true, false, '300px', undefined, colunasFt);
  criaDataTablePadrao('#tabelaGrade', false, false, false, false, true, false, '300px', undefined, colunasGrade);
  criaDataTablePadrao('#tabelaAplicacoes', false, false, false, false, true, false, '300px', undefined, colunasAplicacoes, [2, 3]);
  criaDataTablePadrao('#tabelaTecidosUtilizados', false, false, false, false, true, false, '300px', undefined, colunasTecidosUtilizados, [8, 9, 10, 11]);
  criaDataTablePadrao('#tabelaConsumos', false, false, false, false, true, false, '300px', undefined, colunasConsumos, [9], [], [], [], {}, null, null, null, null, [], [2, 3, 4]);
  criaDataTablePadrao('#tabelaSerigrafia', false, false, false, false, true, true, '400px', undefined, colunasSerigrafia);
  criaDataTablePadrao('#tabelaSerigrafiaTipo', false, false, false, false, true, false, '200px', undefined, colunasSerigrafiaTipo, [0, 1, 3]);
  criaDataTablePadrao('#tabelaSerigrafiaLocal', false, false, false, false, true, false, '200px', undefined, colunasSerigrafiaLocal, [0, 2]);
  criaDataTablePadrao('#tabelaSerigrafiaTamanho', false, false, false, false, true, false, '200px', undefined, colunasSerigrafiaTamanho, [0]);
  criaDataTablePadrao('#tabelaBordado', false, false, false, false, true, false, '400px', undefined, colunasBordado);
  criaDataTablePadrao('#tabelaBordadoProgramacao', false, false, false, false, true, false, '200px', undefined, colunasBordadoProgramacao, [0, 2]);
  criaDataTablePadrao('#tabelaBordadoTamanho', false, false, false, false, true, false, '200px', undefined, colunasBordadoTamanho, [0, 2]);
  criaDataTablePadrao('#tabelaBordadoLocal', false, false, false, false, true, false, '200px', undefined, colunasBordadoLocal, [0, 2, 3]);
  criaDataTablePadrao('#tabelaSublimacao', false, false, false, false, true, false, '400px', undefined, colunasSublimacao);
  criaDataTablePadrao('#tabelaTermotapeTipo', false, false, false, false, true, false, '200px', undefined, colunasTermotapeTipo, [2]);
  criaDataTablePadrao('#tabelaTermotape', false, false, false, false, true, false, '400px', undefined, colunasTermotape, [0]);

  await carregaCustomSerigrafiaTipo(0);
  await carregaCustomSerigrafiaLocal(0);
  await carregaCustomSerigrafiaTam(0);

  await carregaCustomBordadoProg(0);
  await carregaCustomBordadoTam(0);
  await carregaCustomBordadoLocal(0);

  await carregaCustomSublimacao();
  await carregaCustomTermotape();

  await validaEdicao();

  let alterandoComposicao = false;
  let indexComposicao = -1;
  const usaPrecoCorTam = await CopiaParametro("VENDA", 5) == 1

  $(".radio-group .radio").click(function () {
    $(this).parent().find(".radio").removeClass("selected");
    $(this).addClass("selected");
  });

  $(".submit").click(function () {
    return false;
  });

  $('#txtLinha, #txtGrupo, #txtEtiqueta').on('blur', async function () {
    const linha = pegaChave('#txtLinha');
    const grupo = pegaChave('#txtGrupo');
    const etiqueta = pegaChave('#txtEtiqueta');

    if ((linha == '') || (grupo == '') || (etiqueta == '')) {
      return;
    }

    await buscaCaracteristica(linha, grupo, etiqueta);
  });

  $('#btnAddSerigrafia').on('click', async function () {
    await carregaCustomSerigrafiaTipo($('#tabelaSerigrafiaTipo').DataTable().row('.selected').index());
    await carregaCustomSerigrafiaLocal($('#tabelaSerigrafiaLocal').DataTable().row('.selected').index());
    await carregaCustomSerigrafiaTam($('#tabelaSerigrafiaTamanho').DataTable().row('.selected').index());
    addSerigrafia();
  });

  $('#btnRemoveSerigrafia').on('click', function () {
    removeSerigrafia();
  });

  $('#btnAddBordado').on('click', async function () {
    await carregaCustomBordadoProg($('#tabelaBordadoProgramacao').DataTable().row('.selected').index());
    await carregaCustomBordadoTam($('#tabelaBordadoTamanho').DataTable().row('.selected').index());
    await carregaCustomBordadoLocal($('#tabelaBordadoLocal').DataTable().row('.selected').index());
    addBordado();
  });

  $('#btnRemoveBordado').on('click', function () {
    removeBordado();
  });

  $('#btnAddTermotape').on('click', function () {
    addTermotape();
  });

  $('#btnAddComposicao').on('click', function () {
    $('#modalComposicao').modal('show');
  });

  $('#btnAddItem').on('click', function () {
    $('#modalItem').modal('show');
    $('#txtFaixa').prop('disabled', true)
    $('#btnFaixa').prop('disabled', true)
    $('#btnAFaixa').prop('disabled', true)

    $('#txtCodigo').prop('disabled', false)
    $('#btn-Codigo').prop('disabled', false)
    $('#btn-limpa-Codigo').prop('disabled', false)

    $('#txtCor').prop('disabled', false)
    $('#btn-Cor').prop('disabled', false)
    $('#btn-limpa-Cor').prop('disabled', false)

    $('#txtQtde').prop('disabled', false)
  });


  $('#btnConfirmarComposicao').on('click', function () {
    adicionaComposicao();
  });

  $('#tabelaComposicao').on('click', '#btn-excluir-composicao', async function () {
    await msgAguardaConfirmacao('Você realmente deseja excluir esse registro?', async () => {
      $.LoadingOverlay('show')
      try {
        $('#tabelaComposicao').DataTable().row($(this).parents('tr')).remove().draw(false);
      } finally {
        $.LoadingOverlay('hide')
      }
    })
  });

  $('#tabelaComposicao').on('click', '#btn-editar-composicao', async function () {
    $.LoadingOverlay('show')
    try {
      let item = $('#tabelaComposicao').DataTable().row($(this).parents('tr')).data()
      indexComposicao = $('#tabelaComposicao').DataTable().row($(this).parents('tr')).index()
      $('#modalComposicao').modal('show')
      insereValor('#txtFornecedor', item.FORNECEDOR, item.NOME_FORNECEDOR)
      insereValor('#txtMaterial', item.CODIGO, item.DESCRICAO)
      insereValor('#txtCorItem', item.COR, item.DESC_COR)
      insereValor('#txtOpcionalItem', item.COD_OPCIONAL, item.DESC_OPCIONAL)
      alterandoComposicao = true;
    } finally {
      $.LoadingOverlay('hide')
    }
  })

  $("#modalItem").on('shown.bs.modal', async function () {
    ajustaTabelasModalItem();
    if ($('#dtEntrega').val() != '') {
      $('#dtEntregaItem').val($('#dtEntrega').val());
    }
    $('#tabCaracteristicas').trigger('click')
  });

  $('#tabCaracteristicas, #tabComposicao, #tabAplicacoes, #tabConsumos, #tabGrade, #tabObs, #tabFt, #tabSerigrafia, #tabBordado, #tabSublimacao, #tabTermotape').on('click', async function () {
    setTimeout(() => { ajustaTabelasModalItem() }, 200);
    if ($(this)[0].id == 'tabAplicacoes' && $('#tabelaTecidosUtilizados').DataTable().rows('.selected').data().toArray().length <= 0) {
      let existeCorVazia = false;
      for (let i = 0; i < $('#tabelaComposicao').DataTable().data().toArray().length; i++) {
        const item = $('#tabelaComposicao').DataTable().data().toArray()[0]

        if (item.COR == '') {
          existeCorVazia = true
          break
        }
      }

      if (existeCorVazia) {
        msgAlerta('Existem composições sem cor informada, impossível continuar!')
        setTimeout(() => { $('#tabComposicao').trigger('click') }, 200);
      } else {
        carregaAplicacoes();
      }
    }
    if ((($(this)[0].id == 'tabGrade') && (pegaValor('#txtFaixa') != '')) || ((pegaValor('#txtCodigo') != ''))) {
      if ((pegaValor('#txtLinha') != '') && (pegaValor('#txtGrupo') != '') && (pegaValor('#txtEtiqueta') != '')) {
        await explodeFaixa(pegaChave('#txtFaixa'));
      } else {
        let tabela = pegaChave('#txtTabPreco')
        if (tabela == '') {
          const pesquisaParam = {
            tabela: 'REGIAO',
            camposSelect: ['REGIAO'],
            where: [`PADRAO = 'S'`],
          }

          const jsonStr = await retornaJsonPesquisaPadrao(JSON.stringify(pesquisaParam));

          tabela = jsonStr[0].REGIAO
        }
        await explodeFaixaExpress(pegaChave('#txtFaixa'), tabela, pegaChave('#txtCodigo'));
      }
      atualizaTotaisGrade()
    }
  });

  $('#txtFaixa').on('blur', async function () {
    if (!$('#txtFaixa').val()) {
      return
    }
    if (!$('#txtCodigo').val()) {
      throw msgAlerta('É necessário inserir um código para explodir a grade.')
    }
    $.LoadingOverlay('show')
    try {
      if ((pegaValor('#txtLinha') != '') && (pegaValor('#txtGrupo') != '') && (pegaValor('#txtEtiqueta') != '')) {
        await explodeFaixa(pegaChave('#txtFaixa'));
      } else {
        let tabela = pegaChave('#txtTabPreco')
        if (tabela == '') {
          const pesquisaParam = {
            tabela: 'REGIAO',
            camposSelect: ['REGIAO'],
            where: [`PADRAO = 'S'`],
          }

          const jsonStr = await retornaJsonPesquisaPadrao(JSON.stringify(pesquisaParam));

          tabela = jsonStr[0].REGIAO
        }
        await explodeFaixaExpress(pegaChave('#txtFaixa'), tabela, pegaChave('#txtCodigo'));
      }
    } catch (error) {
      console.error(error)
      msgAlerta(error.message)
    } finally {
      $.LoadingOverlay('hide')
    }
  })

  $('#tabCustomizacoes').on('click', function () {
    setTimeout(async () => {
      $('#tabSerigrafia').trigger('click')
    }, 200);
    setTimeout(() => { ajustaTabelasModalItem() }, 200);
  });

  $('#tabBordado').on('click', function () {
    setTimeout(async () => {
      await carregaCustomBordadoProg(0);
      await carregaCustomBordadoTam(0);
      await carregaCustomBordadoLocal(0);
    }, 200);
  });

  $('#tabBordado').on('click', function () {
    setTimeout(async () => {
      await carregaCustomSerigrafiaTipo(0);
      await carregaCustomSerigrafiaLocal(0);
      await carregaCustomSerigrafiaTam(0);
    }, 200);
  });

  $('#txtCliente').on('blur', async function () {
    await buscaRepresentanteCliente();
    await buscaContatoCliente();
    await buscaTabelaCliente();
  });

  $('#txtRepresentante').on('blur', async function () {
    await buscaComissaoRepresentante();
  });

  $('#txtDias').on('blur', function () {
    const dias = pegaValor('#txtDias');

    if (dias == '') {
      return;
    }

    if ($('#rdSumDiasCorridos').is(':checked')) {
      consideraDiasCorridos(dias)
    }

    if ($('#rdSumDiasUteis').is(':checked')) {
      consideraDiasUteis(dias)
    }

  });

  $('#rdSumDiasCorridos, #rdSumDiasUteis').on('change', function () {
    const dias = pegaValor('#txtDias');

    if (dias == '') {
      return;
    }

    if ($('#rdSumDiasCorridos').is(':checked')) {
      consideraDiasCorridos(dias)
    }

    if ($('#rdSumDiasUteis').is(':checked')) {
      consideraDiasUteis(dias)
    }
  })

  function consideraDiasCorridos(dias) {
    setarDataAtual('dtEntrega', false, parseFloat(dias));
    setarDataAtual('dtSaida', false, parseFloat(dias));
  }

  function consideraDiasUteis(dias) {
    var dataInicial = new Date();

    var data = new Date(dataInicial);

    var contadorDias = 0;
    while (contadorDias < dias) {
      data.setDate(data.getDate() + 1);
      if (data.getDay() !== 0 && data.getDay() !== 6) {
        contadorDias++;
      }
    }

    var ano = data.getFullYear();
    var mes = ("0" + (data.getMonth() + 1)).slice(-2);
    var dia = ("0" + data.getDate()).slice(-2);
    var dataFinalFormatada = ano + "-" + mes + "-" + dia;

    $("#dtEntrega").val(dataFinalFormatada);
    $("#dtSaida").val(dataFinalFormatada);
  }

  $('#tabelaCaracteristicas').on('click', 'td', function () {
    selecionarLinhaTabela('#tabelaCaracteristicas', 'checkCaracteristica', this);
  });

  $('#tabelaTecidosUtilizados').on('click', 'td', function () {
    selecionarLinhaTabela('#tabelaTecidosUtilizados', 'checkAplicacoes', this);
  });

  $('#tabelaBordadoProgramacao').on('click', 'tr', async function () {
    $('#tabelaBordadoProgramacao > tbody > tr').removeClass('selected');
    $(this).closest('tr').addClass('selected');
  });

  $('#tabelaBordadoTamanho').on('click', 'tr', async function () {
    $('#tabelaBordadoTamanho > tbody > tr').removeClass('selected');
    $(this).closest('tr').addClass('selected');
  });

  $('#tabelaBordadoLocal').on('click', 'tr', async function () {
    $('#tabelaBordadoLocal > tbody > tr').removeClass('selected');
    $(this).closest('tr').addClass('selected');
  });

  $('#tabelaSerigrafiaTipo').on('click', 'tr', async function () {
    $('#tabelaSerigrafiaTipo > tbody > tr').removeClass('selected');
    $(this).closest('tr').addClass('selected');
    await carregaCustomSerigrafiaTam();
  });

  $('#tabelaSerigrafiaLocal').on('click', 'tr', function () {
    $('#tabelaSerigrafiaLocal > tbody > tr').removeClass('selected');
    $(this).closest('tr').addClass('selected');
  });

  $('#tabelaSerigrafiaTamanho').on('click', 'tr', function () {
    $('#tabelaSerigrafiaTamanho > tbody > tr').removeClass('selected');
    $(this).closest('tr').addClass('selected');
  });

  $('#tabelaSerigrafia').on('click', 'tr', function () {
    $('#tabelaSerigrafia > tbody > tr').removeClass('selected');
    $(this).closest('tr').addClass('selected');
  });

  $('#tabelaBordado').on('click', 'tr', function () {
    $('#tabelaBordado > tbody > tr').removeClass('selected');
    $(this).closest('tr').addClass('selected');
  });

  $('#tabelaSublimacao').on('click', 'tr', function () {
    $('#tabelaSublimacao > tbody > tr').removeClass('selected');
    $(this).closest('tr').addClass('selected');
  });

  $('#tabelaTermotapeTipo').on('click', 'tr', function () {
    $('#tabelaTermotapeTipo > tbody > tr').removeClass('selected');
    $(this).closest('tr').addClass('selected');
  });

  $('#txtCodigo').on('blur', async function () {

    $.LoadingOverlay('show')
    try {
      const codigo = pegaChave('#txtCodigo');
      const cor = pegaChave('#txtCor')
      if (codigo == '') {
        return;
      }

      $('#txtCor').unbind('autocompleta');
      $('#txtCor').autocompleta(1, `JSON={ "tabela":"PA_ITEN", "camposSelect":["PA_ITEN.COR CHAVE, CADCOR.DESCRICAO"], "leftjoin": [{ "tabela" : "CADCOR", "condicao" : "PA_ITEN.COR = CADCOR.COR" }], "groupBy": ["PA_ITEN.COR", "CADCOR.DESCRICAO"], "where": ["PA_ITEN.CODIGO = '${codigo}' AND PA_ITEN.ATIVO = 'S'"] }`);
      $('#btn-Cor').off();
      $('#btn-Cor').unbind();
      $('#btn-Cor').pesquisa_array(['#txtCor'], ['COR'], ['DESCRICAO'], `/sisplan/funcoes/v1/pesquisa?JSON={ "tabela":"PA_ITEN", "camposSelect":[ "PA_ITEN.COR", "CADCOR.DESCRICAO" ],"leftjoin": [{ "tabela" : "CADCOR", "condicao" : "PA_ITEN.COR = CADCOR.COR" }], "groupBy": ["PA_ITEN.COR", "CADCOR.DESCRICAO"], "where": ["PA_ITEN.CODIGO = '${codigo}' AND PA_ITEN.ATIVO = 'S'"]}`, 'Pesquisa Cor', 'CADCOR');
      await preencheFaixa()

      if (!cor) {
        const pesquisaCor = {
          tabela: "PA_ITEN",
          camposSelect: [
            "PA_ITEN.COR",
            "CADCOR.DESCRICAO"
          ],
          leftJoin: [{ tabela: "CADCOR", condicao: "PA_ITEN.COR = CADCOR.COR" }],
          groupBy: [
            "PA_ITEN.COR",
            "CADCOR.DESCRICAO"
          ],
          where: [`PA_ITEN.CODIGO = '${codigo}' AND PA_ITEN.ATIVO = 'S'`],
        }
        const jsonStrCor = await retornaJsonPesquisaPadrao(JSON.stringify(pesquisaCor));

        if (jsonStrCor && jsonStrCor.length == 1) {
          insereValor('#txtCor', jsonStrCor[0].COR, jsonStrCor[0].DESCRICAO)
          $('#txtCor').trigger('blur')
        }
      }

    } catch (error) {
      console.error(error)
      msgAlerta(error.message)
    } finally {
      $.LoadingOverlay('hide')
    }

  });

  $('#txtCor').on('focusout', async function () {
    const codigo = pegaChave('#txtCodigo');
    const cor = pegaChave('#txtCor');

    if ((codigo == '') || (cor == '')) {
      return;
    }

    await carregaConsumosExpress(codigo, cor)
  });

  async function validaEdicao() {
    if (orcamento == 'create') {
      insereValor('#txtNumero', await RetornaProximo('OS', 'OS', 'NUMERO', 5));
      const codrep = (await buscaValor('ACESSO_USUARIOS', 'CODREP', 'CODIGO', getCookie('cod_usuario'))).CODREP
      if (codrep) insereValor('#txtRepresentante', codrep, { tabela: 'REPRESEN', campoBusca: 'NOME', campoWhere: 'CODREP', valorWhere: codrep })
      return;
    } else {
      await buscarOrcamento(orcamento)
    }
  }

  async function buscaRepresentanteCliente() {
    const codcli = pegaChave('#txtCliente');

    if (codcli == '') {
      return;
    }

    if (pegaChave('#txtRepresentante') != '') {
      await buscaComissaoRepresentante();
      return;
    }

    const pesquisaParam = {
      tabela: 'ENTIDADE',
      camposSelect: ['ENTIDADE.CODREP', 'REPRESEN.NOME'],
      leftJoin: [{ tabela: 'REPRESEN', condicao: `ENTIDADE.CODREP = REPRESEN.CODREP` }],
      where: [`ENTIDADE.CODCLI = '${codcli}'`]
    }

    const jsonStr = await retornaJsonPesquisaPadrao(JSON.stringify(pesquisaParam));

    if (jsonStr[0].CODREP != '') {
      insereValor('#txtRepresentante', jsonStr[0].CODREP, jsonStr[0].NOME);
      await buscaComissaoRepresentante();
    }
  }

  async function buscaContatoCliente() {
    const codcli = pegaChave('#txtCliente');

    if (codcli == '') {
      return;
    }

    const pesquisaParam = {
      tabela: 'CONTATO',
      camposSelect: ['ID', 'NOME'],
      where: [`CODCLI = '${codcli}' AND TIPO = 'Orçamento'`]
    }

    const jsonStr = await retornaJsonPesquisaPadrao(JSON.stringify(pesquisaParam));

    if (jsonStr.length > 0 && jsonStr[0].NOME != '') {
      insereValor('#txtSolicitante', jsonStr[0].ID, jsonStr[0].NOME);
    } else {
      limpaValor('#txtSolicitante');
    }
  }

  async function buscaComissaoRepresentante() {
    const codrep = pegaChave('#txtRepresentante');

    if (codrep == '') {
      return;
    }

    const pesquisaParam = {
      tabela: 'REPRESEN',
      camposSelect: ['COMISSAO', 'COMISSAO2'],
      where: [`CODREP = '${codrep}'`]
    }

    const jsonStr = await retornaJsonPesquisaPadrao(JSON.stringify(pesquisaParam));

    insereValor('#txtComissaoFat', jsonStr[0].COMISSAO);
    insereValor('#txtComissaoRec', jsonStr[0].COMISSAO2);
  }

  async function carregaCustomSerigrafiaTam(indiceClick = 0) {
    $.LoadingOverlay('show');
    $('#tabelaSerigrafiaTamanho').DataTable().clear().draw(false);
    try {
      if ($('#tabelaSerigrafiaTipo').DataTable().rows().count() == 0) {
        return;
      }

      const descTipo = $('#tabelaSerigrafiaTipo').DataTable().rows('.selected').data()[0].DESCRICAO;
      const qtdeCores = $('#tabelaSerigrafiaTipo').DataTable().rows('.selected').data()[0].QTDE_CORES;

      const pesquisaParam = {
        tabela: 'CUSTOMIZA',
        camposSelect: ['CUSTOMIZA.ID_TAMANHO', 'TAM.DESCRICAO'],
        leftJoin: [{ tabela: 'CUSTOMIZA', alias: 'TAM', condicao: `TAM.ID = CUSTOMIZA.ID_TAMANHO AND TAM.TIPO = 'SERIGTAM'` }],
        where: [`CUSTOMIZA.TIPO = 'SERIGTIPO' AND CUSTOMIZA.DESCRICAO = '${descTipo}'`]
      }

      const jsonStr = await retornaJsonPesquisaPadrao(JSON.stringify(pesquisaParam));

      jsonStr.map(item => {
        $('#tabelaSerigrafiaTamanho').DataTable().row.add({
          CODIGO: item.ID_TAMANHO,
          DESCRICAO: item.DESCRICAO,
        }).draw(false);
      });

      insereValor('#txtQtdeCores', qtdeCores);

      if ($('#tabelaSerigrafiaTamanho').DataTable().rows().count() > 0) {
        $($('#tabelaSerigrafiaTamanho > tbody > tr')[indiceClick]).addClass('selected');
      }
    } finally {
      $.LoadingOverlay('hide');
    }
  };

  async function carregaCustomSerigrafiaLocal(indiceClick = 0) {
    $.LoadingOverlay('show');
    $('#tabelaSerigrafiaLocal').DataTable().clear().draw(false);
    try {
      const pesquisaParam = {
        tabela: 'CUSTOMIZA',
        camposSelect: ['ID', 'DESCRICAO', 'COALESCE(PRECO, 0) PRECO', 'MARGEM', 'ATIVO'],
        where: [`TIPO = 'SERIGLOCAL'`],
      }

      const jsonStr = await retornaJsonPesquisaPadrao(JSON.stringify(pesquisaParam));

      jsonStr.map(item => {
        $('#tabelaSerigrafiaLocal').DataTable().row.add({
          CODIGO: item.ID,
          DESCRICAO: item.DESCRICAO,
          PRECO: item.PRECO,
        }).draw(false);
      });

      if ($('#tabelaSerigrafiaLocal').DataTable().rows().count() > 0) {
        $($('#tabelaSerigrafiaLocal > tbody > tr')[indiceClick]).addClass('selected');
      }
    } finally {
      $.LoadingOverlay('hide');
    }

  };

  async function carregaCustomSerigrafiaTipo(indiceClick = 0) {
    $.LoadingOverlay('show')
    $('#tabelaSerigrafiaTipo').DataTable().clear().draw(false);
    try {
      const pesquisaParam = {
        tabela: 'CUSTOMIZA',
        camposSelect: ['ID', 'DESCRICAO', 'QTDE_COR', 'COALESCE(VAL_TELA [SOMA] VAL_FOTO [SOMA] VAL_COR, 0) PRECO'],
        where: [`TIPO = 'SERIGTIPO'`],
      }

      const jsonStr = await retornaJsonPesquisaPadrao(JSON.stringify(pesquisaParam));

      jsonStr.map(item => {
        $('#tabelaSerigrafiaTipo').DataTable().row.add({
          CODIGO: item.ID,
          QTDE_CORES: item.QTDE_COR,
          DESCRICAO: item.DESCRICAO,
          PRECO: item.PRECO,
        }).draw(false);
      });

      if ($('#tabelaSerigrafiaTipo').DataTable().rows().count() > 0) {
        $($('#tabelaSerigrafiaTipo > tbody > tr')[indiceClick]).addClass('selected');
      }
    } finally {
      $.LoadingOverlay('hide')
    }
  };

  async function carregaCustomBordadoProg(indiceClick = 0) {
    $.LoadingOverlay('show')
    $('#tabelaBordadoProgramacao').DataTable().clear().draw(false);
    try {
      const pesquisaParam = {
        tabela: 'CUSTOMIZA',
        camposSelect: ['ID', 'DESCRICAO', 'COALESCE(PRECO, 0) PRECO'],
        where: [`TIPO = 'BORDPROG'`],
      }

      const jsonStr = await retornaJsonPesquisaPadrao(JSON.stringify(pesquisaParam));

      jsonStr.map(item => {
        $('#tabelaBordadoProgramacao').DataTable().row.add({
          CODIGO: item.ID,
          DESCRICAO: item.DESCRICAO,
          PRECO: item.PRECO,
        }).draw(false);
      });

      if ($('#tabelaBordadoProgramacao').DataTable().rows().count() > 0) {
        $($('#tabelaBordadoProgramacao > tbody > tr')[indiceClick]).addClass('selected');
      }
    } finally {
      $.LoadingOverlay('hide')
    }
  };

  async function carregaCustomBordadoTam(indiceClick = 0) {
    $.LoadingOverlay('show')
    $('#tabelaBordadoTamanho').DataTable().clear().draw(false);
    try {
      const pesquisaParam = {
        tabela: 'CUSTOMIZA',
        camposSelect: ['ID', 'DESCRICAO', 'COALESCE(PRECO, 0) PRECO'],
        where: [`TIPO = 'BORDTAM'`],
      }

      const jsonStr = await retornaJsonPesquisaPadrao(JSON.stringify(pesquisaParam));

      jsonStr.map(item => {
        $('#tabelaBordadoTamanho').DataTable().row.add({
          CODIGO: item.ID,
          DESCRICAO: item.DESCRICAO,
          PRECO: item.PRECO,
        }).draw(false);
      });

      if ($('#tabelaBordadoTamanho').DataTable().rows().count() > 0) {
        $($('#tabelaBordadoTamanho > tbody > tr')[indiceClick]).addClass('selected');
      }
    } finally {
      $.LoadingOverlay('hide')
    }
  };

  async function carregaCustomBordadoLocal(indiceClick = 0) {
    $.LoadingOverlay('show')
    $('#tabelaBordadoLocal').DataTable().clear().draw(false);
    try {
      const pesquisaParam = {
        tabela: 'CUSTOMIZA',
        camposSelect: ['ID', 'DESCRICAO', 'COALESCE(PRECO, 0) PRECO', 'MARGEM'],
        where: [`TIPO = 'BORDLOCAL'`],
      }

      const jsonStr = await retornaJsonPesquisaPadrao(JSON.stringify(pesquisaParam));

      jsonStr.map(item => {
        $('#tabelaBordadoLocal').DataTable().row.add({
          CODIGO: item.ID,
          DESCRICAO: item.DESCRICAO,
          PRECO: item.PRECO,
          MARGEM: item.MARGEM,
        }).draw(false);
      });

      if ($('#tabelaBordadoLocal').DataTable().rows().count() > 0) {
        $($('#tabelaBordadoLocal > tbody > tr')[indiceClick]).addClass('selected');
      }
    } finally {
      $.LoadingOverlay('hide')
    }
  };

  async function carregaCustomSublimacao() {
    const pesquisaParam = {
      tabela: 'CUSTOMIZA',
      camposSelect: ['ID', 'DESCRICAO', 'VAL_PROG'],
      where: [`TIPO = 'SUBLI'`],
    }

    const jsonStr = await retornaJsonPesquisaPadrao(JSON.stringify(pesquisaParam));

    jsonStr.map(item => {
      $('#tabelaSublimacao').DataTable().row.add({
        SEL: botaoSelecionarGrid('checkSublimacao'),
        CODIGO: item.ID,
        DESCRICAO: item.DESCRICAO,
        PRECO: item.VAL_PROG
      }).draw(false);
    });

    if ($('#tabelaSublimacao').DataTable().rows().count() > 0) {
      $($('#tabelaSublimacao > tbody > tr')[0]).addClass('selected');
    }
  };

  async function carregaCustomTermotape() {
    const pesquisaParam = {
      tabela: 'CUSTOMIZA',
      camposSelect: ['ID', 'DESCRICAO', 'PRECO'],
      where: [`TIPO = 'TERMO'`],
    }

    const jsonStr = await retornaJsonPesquisaPadrao(JSON.stringify(pesquisaParam));

    jsonStr.map(item => {
      $('#tabelaTermotapeTipo').DataTable().row.add({
        CODIGO: item.ID,
        DESCRICAO: item.DESCRICAO,
        PRECO: item.PRECO
      }).draw(false);
    });

    if ($('#tabelaTermotapeTipo').DataTable().rows().count() > 0) {
      $($('#tabelaTermotapeTipo > tbody > tr')[0]).addClass('selected');
    }
  };

  async function carregaComposicao() {
    $.LoadingOverlay('show');
    $('#tabelaComposicao').DataTable().clear().draw();
    try {
      const caracteristicas = $('#tabelaCaracteristicas').DataTable().rows(function (idx, data, node) {
        return $(node).find('input.checkCaracteristica').is(':checked');
      }).data().map(item => item.CODIGO).toArray();
      const caracteristicasFormatadas = await formataListas(caracteristicas.toString())
      const response = await requisicao('GET', '/sisplan/orcamento/v1/buscacomposicao?', `ID=${idCaracteristica}&CARACTERISTICAS=${caracteristicasFormatadas}`);

      if (!response) {
        return;
      }

      const jsonStr = await response.json();

      jsonStr.map(item => {
        $('#tabelaComposicao').DataTable().row.add({
          CODIGO: item.COD_MAT,
          DESCRICAO: item.DESC_MAT,
          COR: item.COR,
          DESC_COR: item.DESC_COR,
          FORNECEDOR: '',
          NOME_FORNECEDOR: '',
          COD_OPCIONAL: item.COD_OPCIONAL,
          DESC_OPCIONAL: item.DESC_OPCIONAL,
          ACOES: retornaBotaoExcluir(),
        }).draw(false);
      });

    } finally {
      $.LoadingOverlay('hide');
    }
  };

  async function carregaConsumos() {
    $.LoadingOverlay('show');
    $('#tabelaConsumos').DataTable().clear().draw();
    try {
      const response = await requisicao('GET', '/sisplan/orcamento/v1/buscaconsumos?', `ID=${idCaracteristica}`);

      if (!response) {
        return;
      }

      const jsonStr = await response.json();

      jsonStr.map(item => {
        $('#tabelaConsumos').DataTable().row.add({
          CODIGO: item.COD_MAT,
          DESCRICAO: item.DESC_MAT,
          QTDE: item.QTDE,
          CUSTO: item.CUSTO,
          VALOR: item.VALOR,
          SETOR: item.SETOR,
          DESC_SETOR: item.DESC_SETOR,
          COR: item.COR,
          DESC_COR: item.DESC_COR,
          COD_OPCIONAL: '',
        }).draw(false);
      });

    } finally {
      $.LoadingOverlay('hide');
    }
  };

  async function buscaCaracteristica(sLinha, sGrupo, sEtiqueta) {
    const pesquisaParam = {
      tabela: 'CARACT',
      camposSelect: ['CARACT.ID', 'CARACT.COD_FAIXA', 'FAIXA.DESCRICAO DESC_FAIXA'],
      where: [`CARACT.COD_ETQ = '${sEtiqueta}' AND CARACT.COD_GRUPO = '${sGrupo}' AND CARACT.COD_LINHA = '${sLinha}'`],
      leftJoin: [{ tabela: 'FAIXA', condicao: `FAIXA.CODIGO = CARACT.COD_FAIXA` }],
    }

    const jsonStr = await retornaJsonPesquisaPadrao(JSON.stringify(pesquisaParam));

    if (jsonStr.length == 0) {
      msgAlerta('Nenhuma característica encontrada para o grupo, etiqueta e linha informados. Favor verificar.');
      return;
    }

    idCaracteristica = jsonStr[0].ID;

    insereValor('#txtFaixa', jsonStr[0].COD_FAIXA, jsonStr[0].DESC_FAIXA);

    await carregaCaracteristicas();
    await carregaComposicao();
    await carregaConsumos();
  };

  async function explodeFaixa(sFaixa) {
    if (pegaValor('#txtValTotal') > 0) {
      return;
    }

    $.LoadingOverlay('show');
    $('#tabelaGrade').DataTable().clear();
    try {
      const pesquisaParam = {
        tabela: 'FAIXA_ITEN',
        camposSelect: ['TAMANHO', 'POSICAO'],
        where: [`FAIXA = '${sFaixa}'`],
        orderBy: ['POSICAO'],
      }

      const jsonStr = await retornaJsonPesquisaPadrao(JSON.stringify(pesquisaParam));

      const precoVenda = await montaPrecoVenda();

      jsonStr.map((item, index) => {
        $('#tabelaGrade').DataTable().row.add({
          TAMANHO: item.TAMANHO,
          QTDE: retornaInputValor('txtQtdeGrade txtCamposGrade', index, true),
          PRECO: precoVenda,
          PERC_ACRESC: retornaInputValor('txtPercAcresGrade txtCamposGrade', index),
          VAL_ACRESC: retornaInputValor('txtValAcresGrade txtCamposGrade', index),
          PERC_DESC: retornaInputValor('txtPercDescGrade txtCamposGrade', index),
          VAL_DESC: retornaInputValor('txtValDescGrade txtCamposGrade', index),
          PRECO_LIQ: '0.00',
          TOTAL: '0.00',
        }).draw(false);
      });
    } catch (error) {
      console.error(error)
      msgAlerta(error.message)
    } finally {
      $('.txtCamposGrade').on('blur', function () {
        calculaTotaisGrade($(this).attr('data-campo').replace(' txtCamposGrade', ''), $(this).attr('data-index'));
      });

      insereValor('#txtQtdeTotal', '0.00');
      insereValor('#txtValTotal', '0.00');

      aplicaMascara();

      $.LoadingOverlay('hide');
    }
  };

  async function carregaCaracteristicas() {
    $.LoadingOverlay('show');
    $('#tabelaCaracteristicas').DataTable().clear().draw();
    try {
      const response = await requisicao('GET', '/sisplan/orcamento/v1/buscacaracteristicas?', `ID=${idCaracteristica}&CODIGO=${pegaChave('#txtCodigo')}`);

      if (!response) {
        return;
      }

      const jsonStr = await response.json();

      jsonStr.map(item => {
        $('#tabelaCaracteristicas').DataTable().row.add({
          SEL: botaoSelecionarGrid('checkCaracteristica'),
          CODIGO: item.OPCIONAL,
          DESCRICAO: item.DESC_OPCIONAL,
          VALOR: item.VALOR,
          EXISTE: item.EXISTE,
          ID: item.ID,
          CONS_TECIDO: item.CONS_TECIDO,
          COD_APL: item.COD_APL,
        }).draw(false);
      });

      $('#tabelaCaracteristicas').DataTable().rows().every(function () {
        let data = this.data()
        let index = this.index()


        if (data.EXISTE == 'S' && data.ID != null) {
          $($('.checkCaracteristica')[index]).trigger('click')
        }
      })

      $('#tabelaCaracteristicas').DataTable().rows().every(function () {
        let data = this.data()

        if (data.ID == null) {
          $(this.node()).find('.form-check').remove()
          $(this.node()).addClass('disabledCaracteristica');
        }
      })

    } finally {
      $.LoadingOverlay('hide');
    }
  };

  async function adicionaEmpresas() {
    const pesquisaParam = {
      tabela: 'EMPRESA',
      camposSelect: ['EMP_PAT', 'EMP_NOME'],
      where: ['1 = 1'],
    }
    const jsonStr = await retornaJsonPesquisaPadrao(JSON.stringify(pesquisaParam));
    jsonStr.map(emp => {
      $("#selectEmpresa").append(new Option(`${emp.EMP_PAT} - ${emp.EMP_NOME}`, emp.EMP_PAT.replace('_', ''), null, emp.EMP_PAT == getCookie('empresa')));
    });
  };

  function removeSerigrafia() {
    $('#tabelaSerigrafia').DataTable().row('.selected').remove().draw(false);

    if ($('#tabelaSerigrafia').DataTable().rows().count() > 0) {
      $($('#tabelaSerigrafia > tbody > tr')[0]).addClass('selected');
    }
  };

  async function montaPrecoVenda(express = false) {
    let precoVenda = 0
    if (parametrosComercial[9].VALOR == '1') {
      if (!$('#txtPreco').val()) {
        throw new Error('Parametro nº10 da aba comercial na tela de parametros está ativo, favor inserir um preço manualmente.')
      }
      if (!$('#txtQtde').val()) {
        throw new Error('Parametro nº10 da aba comercial na tela de parametros está ativo, favor inserir uma quantidade manualmente.')
      }
      precoVenda = parseFloat($('#txtQtde').val()) * parseFloat($('#txtPreco').val())
    } else if (itensAlteracao && itensAlteracao.length > 0) {
      precoVenda = parseFloat($('#txtQtde').val()) * parseFloat($('#txtPreco').val())
    } else {
      if (!express) {
        precoVenda = await retornaCustoFixo();
      }

      if (($('#txtCorGrade').val() == '') && ($('#tabelaComposicao').DataTable().data().toArray().length > 0)) {
        insereValor('#txtCorGrade', $('#tabelaComposicao').DataTable().data().toArray()[0].COR, $('#tabelaComposicao').DataTable().data().toArray()[0].DESC_COR)
      }

      for (let j = 0; j < $('#tabelaCaracteristicas').DataTable().rows('.selected').data().length; j++) {
        const item = $('#tabelaCaracteristicas').DataTable().rows('.selected').data()[j]

        precoVenda += item.VALOR;
        for (let i = 0; i < $('#tabelaTecidosUtilizados').DataTable().rows('.selected').data().length; i++) {
          const aplicacao = $('#tabelaTecidosUtilizados').DataTable().rows('.selected').data()[i]

          if (item.COD_APL == aplicacao.COD_APL && item.ID == aplicacao.ID) {
            const precoMat = await retornaPrecoMat(idCaracteristica, aplicacao.COD_APL, item.CODIGO, aplicacao.CODIGO, aplicacao.COR)
            precoVenda += parseFloat(precoMat)
          }
        }
      }

      $('#tabelaConsumos').DataTable().rows().data().map(item => {
        precoVenda += (item.CUSTO * item.QTDE);
      });

      $('#tabelaSerigrafia').DataTable().rows().data().map(item => {
        precoVenda += (parseInt(item.TOTAL) * parseFloat(item.PRECO));
      }
      )
      $('#tabelaBordado').DataTable().rows().data().map(item => {
        precoVenda += (parseInt(item.TOTAL) * parseFloat(item.PRECO));
      })

      let precoMarkup = 0
      let precoIndFixo = 0

      if ($('#txtMarkup').val() != '') {
        precoMarkup = await retornaIndMarkup()
        precoIndFixo = await retornaPrecoIndFixo()
      }

      if (precoMarkup > 0) {
        precoVenda = precoVenda / (1 - (precoMarkup / 100))
      }

      precoVenda = precoVenda + precoIndFixo;
    }

    return precoVenda.toFixed(2);
  };

  async function retornaPrecoMat(id, codApl, opcional, codigo, cor) {
    $.LoadingOverlay('show')
    try {
      const response = await requisicao('GET', '/sisplan/orcamento/v1/buscaprecomat?', `ID=${id}&COD_APL=${codApl}&OPCIONAL=${opcional}&CODIGO=${codigo}&COR=${cor}`);

      if (!response) {
        return;
      }

      const jsonPrecoMat = await response.json();

      if (jsonPrecoMat.length > 0) {
        let valor = (jsonPrecoMat[0].QTDE_TECIDO * jsonPrecoMat[0].PRECO)
        return valor.toFixed(2)
      } else {
        return 0;
      }
    } catch (error) {
      console.error(error)
      msgAlerta(error.message)
    } finally {
      $.LoadingOverlay('hide')
    }
  };

  async function retornaCustoFixo() {
    const pesquisaParam = {
      tabela: 'CARACT',
      camposSelect: ['(VALOR_COST [SOMA] VALOR_LINHA [SOMA] MARGEM) CUSTO_FIXO'],
      where: [`ID = ${idCaracteristica}`]
    }

    const jsonStr = await retornaJsonPesquisaPadrao(JSON.stringify(pesquisaParam));

    return jsonStr[0].CUSTO_FIXO;
  };

  async function retornaIndMarkup() {
    const pesquisaParam = {
      tabela: 'PRECO_INDICE',
      camposSelect: ['SUM(PRECO_INDICE.INDICE) INDICE'],
      where: [`MARKUP = '${pegaChave('#txtMarkup')}' AND CODIGO <> '09' AND DESCRICAO <> 'CUSTO_IND'`]
    }

    const jsonStr = await retornaJsonPesquisaPadrao(JSON.stringify(pesquisaParam));

    if (!jsonStr) {
      return 0
    }

    return jsonStr[0].INDICE;
  }

  async function retornaPrecoIndFixo() {
    const pesquisaParam = {
      tabela: 'PRECO_INDICE',
      camposSelect: ['SUM(PRECO_INDICE.INDICE) INDICE'],
      where: [`MARKUP = '${pegaChave('#txtMarkup')}' AND CODIGO = '09' AND DESCRICAO = 'CUSTO_IND'`]
    }

    const jsonStr = await retornaJsonPesquisaPadrao(JSON.stringify(pesquisaParam));

    if (!jsonStr) {
      return 0
    }

    return jsonStr[0].INDICE;
  }

  function addSerigrafia() {
    try {
      $('#tabelaSerigrafia').DataTable().row.add({
        NOME: pegaValor('#txtNomeSerigrafia'),
        TIPO: $('#tabelaSerigrafiaTipo').DataTable().row('.selected').data().DESCRICAO,
        TAMANHO: $('#tabelaSerigrafiaTamanho').DataTable().row('.selected').data().DESCRICAO,
        LOCAL: $('#tabelaSerigrafiaLocal').DataTable().row('.selected').data().DESCRICAO,
        QTDE_CORES: pegaValor('#txtQtdeCores'),
        TOTAL: pegaValor('#txtTotalPecasSerigrafia'),
        ALTURA: pegaValor('#txtAlturaSerigrafia'),
        LARGURA: pegaValor('#txtLarguraSerigrafia'),
        PRECO: $('#tabelaSerigrafiaTipo').DataTable().row('.selected').data().PRECO + $('#tabelaSerigrafiaLocal').DataTable().row('.selected').data().PRECO
      }).draw(false);

      if ($('#tabelaSerigrafia').DataTable().rows().count() > 0) {
        $('#tabelaSerigrafia > tbody > tr').removeClass('selected');
        $($('#tabelaSerigrafia > tbody > tr')[$('#tabelaSerigrafia').DataTable().rows().count() - 1]).addClass('selected');
      }
    } finally {
      limpaValor('#txtNomeSerigrafia');
      limpaValor('#txtAlturaSerigrafia');
      limpaValor('#txtLarguraSerigrafia');
      limpaValor('#txtTotalPecasSerigrafia');
    }
  };

  function addTermotape() {
    try {
      $('#tabelaTermotape').DataTable().row.add({
        CODIGO: $('#tabelaTermotapeTipo').DataTable().row('.selected').data().CODIGO,
        DESCRICAO: $('#tabelaTermotapeTipo').DataTable().row('.selected').data().DESCRICAO,
        TAM_CM2: pegaValor('#txtTamCm2'),
        TOTAL: pegaValor('#txtTotalPecasTermotape'),
        PRECO: $('#tabelaTermotapeTipo').DataTable().row('.selected').data().PRECO,
      }).draw(false);

      if ($('#tabelaTermotape').DataTable().rows().count() > 0) {
        $('#tabelaTermotape > tbody > tr').removeClass('selected');
        $($('#tabelaTermotape > tbody > tr')[$('#tabelaTermotape').DataTable().rows().count() - 1]).addClass('selected');
      }
    } finally {
      limpaValor('#txtTamCm2');
      limpaValor('#txtTotalPecasTermotape');
    }
  };

  function removeBordado() {
    $('#tabelaBordado').DataTable().row('.selected').remove().draw(false);

    if ($('#tabelaBordado').DataTable().rows().count() > 0) {
      $($('#tabelaBordado > tbody > tr')[0]).addClass('selected');
    }
  };

  function addBordado() {
    try {
      $('#tabelaBordado').DataTable().row.add({
        NOME: pegaValor('#txtNomeBordado'),
        PROGRAMACAO: $('#tabelaBordadoProgramacao').DataTable().row('.selected').data().DESCRICAO,
        TAMANHO: $('#tabelaBordadoTamanho').DataTable().row('.selected').data().DESCRICAO,
        LOCAL: $('#tabelaBordadoLocal').DataTable().row('.selected').data().DESCRICAO,
        QTDE_PROG: pegaValor('#txtQtdeProg'),
        TOTAL: pegaValor('#txtTotalPecasBordado'),
        ALTURA: pegaValor('#txtAlturaBordado'),
        LARGURA: pegaValor('#txtLarguraBordado'),
        PRECO: $('#tabelaBordadoProgramacao').DataTable().row('.selected').data().PRECO + $('#tabelaBordadoTamanho').DataTable().row('.selected').data().PRECO + $('#tabelaBordadoLocal').DataTable().row('.selected').data().PRECO
      }).draw(false);

      if ($('#tabelaBordado').DataTable().rows().count() > 0) {
        $('#tabelaBordado > tbody > tr').removeClass('selected');
        $($('#tabelaBordado > tbody > tr')[$('#tabelaBordado').DataTable().rows().count() - 1]).addClass('selected');
      }
    } finally {
      limpaValor('#txtNomeBordado');
      limpaValor('#txtQtdeProg');
      limpaValor('#txtAlturaBordado');
      limpaValor('#txtLarguraBordado');
      limpaValor('#txtTotalPecasBordado');
    }
  };

  function carregaAplicacoes() {
    $('#tabelaAplicacoes').DataTable().clear();
    $('#tabelaTecidosUtilizados').DataTable().clear();

    try {
      $('#tabelaCaracteristicas').DataTable().rows('.selected').data().map(item => {
        if (item.CONS_TECIDO != 'N') {
          $('#tabelaAplicacoes').DataTable().row.add({
            CARACTERISTICA: item.CODIGO,
            SUBCARACTERISTICA: item.DESCRICAO,
            COD_APL: item.COD_APL,
            ID: item.ID,
          }).draw(false);
        }
      });

      $('#tabelaComposicao').DataTable().rows().data().map(item => {
        $('#tabelaTecidosUtilizados').DataTable().row.add({
          SEL: botaoSelecionarGrid('checkAplicacoes'),
          CODIGO: item.CODIGO,
          DESCRICAO: item.DESCRICAO,
          ALTURA: retornaInputValor('txtAltura'),
          LARGURA: retornaInputValor('txtLargura'),
          FUNDO: retornaInputValor('txtFundo'),
          VISOR: retornaInputValor('txtVisor'),
          CONSUMO: retornaInputValor('txtConsumo'),
          COR: item.COR,
          FORNECEDOR: item.FORNECEDOR,
          ID: -1,
          COD_APL: -1,
        }).draw(false);
      });
    } finally {
      aplicaMascara();
    }
  };

  function botaoSelecionarGrid(sNomeCheck) {
    return '<div class="form-check" style="max-width: 20px">' +
      `<input type="checkbox" class="align-self-center ${sNomeCheck}" value"">` +
      '</div>';
  };

  function adicionaComposicao() {
    if ((pegaValor('#txtMaterial') == '') || (pegaValor('#txtCorItem') == '')) {
      msgAlerta('Necessário preencher todos os campos para adicionar composição.');
      return;
    }

    try {
      const composicao = {
        CODIGO: pegaChave('#txtMaterial'),
        DESCRICAO: pegaDescricao('#txtMaterial'),
        COR: pegaChave('#txtCorItem'),
        DESC_COR: pegaDescricao('#txtCorItem'),
        FORNECEDOR: pegaChave('#txtFornecedor'),
        NOME_FORNECEDOR: pegaDescricao('#txtFornecedor'),
        COD_OPCIONAL: pegaChave('#txtOpcionalItem'),
        DESC_OPCIONAL: pegaDescricao('#txtOpcionalItem'),
        ACOES: retornaBotaoExcluir(),
      };

      if (alterandoComposicao && indexComposicao >= 0) {
        $('#tabelaComposicao').DataTable().row(indexComposicao).data(composicao).draw(false);
      } else {
        $('#tabelaComposicao').DataTable().row.add(composicao).draw(false);
      }
    } finally {
      $('#modalComposicao').modal('hide');
    }
  };

  $('#modalComposicao').on('hidden.bs.modal', async function () {
    $.LoadingOverlay('show')
    try {
      $('#txtMaterial').val('');
      $('#txtCorItem').val('');
      $('#txtFornecedor').val('');
      $('#txtOpcionalItem').val('');
      alterandoComposicao = false;
      indexComposicao = -1;
    } finally {
      $.LoadingOverlay('hide')
    }
  })

  function retornaBotaoExcluir() {
    return '<div class="divBtnOpcoes p-0"> ' +
      '     <button class="botaoOpcoes btn-sm" type="button" title="Excluir" id="btn-excluir-composicao"><span class="fas fa-trash-alt" style="color:red"></span></button>  ' +
      '     <button class="botaoOpcoes btn-sm" type="button" title="Editar" id="btn-editar-composicao"><span class="fas fa-edit" style="color:blue"></span></button>     ' +
      '   </div>';
  }

  function retornaInputValor(sNomeInput, iIndex = 0, campoQtde = false) {
    return !campoQtde ? `<input type="text" class="input-default focus form-control camposMascara ${sNomeInput}" data-campo="${sNomeInput}" data-index="${iIndex}" value="0.00">` : `<input type="text" class="input-default focus form-control camposMascaraQtde ${sNomeInput}" data-campo="${sNomeInput}" data-index="${iIndex}" value="0">`
  };

  function aplicaMascara() {
    $(".camposMascara").maskMoney({
      decimal: ".",
      thousands: "",
      precision: 2,
    });

    $(".camposMascara").on('blur', function () {
      if (($(this).val() == '0.00') || ($(this).val() == '')) {
        $(this).val('0.00');
      }
    });

    $('.camposMascaraQtde').maskMoney({
      decimal: ".",
      thousands: "",
      precision: 0,
    })

    $(".camposMascaraQtde").on('blur', function () {
      if (($(this).val() == '0') || ($(this).val() == '')) {
        $(this).val('0');
      }
    });

    $("#txtDias").maskMoney({
      decimal: ".",
      thousands: "",
      precision: 0,
    });
    $("#txtDiasValidade").maskMoney({
      decimal: ".",
      thousands: "",
      precision: 0,
    });
  };

  function ajustaTabelasModalItem() {
    $('#tabelaCaracteristicas').DataTable().columns.adjust().draw(false);
    $('#tabelaComposicao').DataTable().columns.adjust().draw(false);
    $('#tabelaFt').DataTable().columns.adjust().draw(false);
    $('#tabelaGrade').DataTable().columns.adjust().draw(false);
    $('#tabelaAplicacoes').DataTable().columns.adjust().draw(false);
    $('#tabelaTecidosUtilizados').DataTable().columns.adjust().draw(false);
    $('#tabelaConsumos').DataTable().columns.adjust().draw(false);
    $('#tabelaSerigrafia').DataTable().columns.adjust().draw(false);
    $('#tabelaSerigrafiaTipo').DataTable().columns.adjust().draw(false);
    $('#tabelaSerigrafiaLocal').DataTable().columns.adjust().draw(false);
    $('#tabelaSerigrafiaTamanho').DataTable().columns.adjust().draw(false);
    $('#tabelaBordado').DataTable().columns.adjust().draw(false);
    $('#tabelaBordadoProgramacao').DataTable().columns.adjust().draw(false);
    $('#tabelaBordadoTamanho').DataTable().columns.adjust().draw(false);
    $('#tabelaBordadoLocal').DataTable().columns.adjust().draw(false);
    $('#tabelaSublimacao').DataTable().columns.adjust().draw(false);
    $('#tabelaTermotapeTipo').DataTable().columns.adjust().draw(false);
    $('#tabelaTermotape').DataTable().columns.adjust().draw(false);
  };

  function calculaTotaisGrade(sCampo, iIndex) {
    const valor = parseFloat($($('.' + sCampo)[iIndex]).val());
    const qtde = parseInt($($('.txtQtdeGrade')[iIndex]).val());

    switch (sCampo) {
      case 'txtQtdeGrade': {
        const dados = $('#tabelaGrade').DataTable().row(iIndex).data();
        dados.TOTAL = (parseFloat(dados.PRECO) * valor).toFixed(2);
        dados.PRECO_LIQ = dados.TOTAL;

        if (parseInt($($('.txtQtdeGrade')[iIndex]).val()) > 0) {
          if ((parametrosComercial[9].VALOR == '0') && !(itensAlteracao && itensAlteracao.length > 0)) {
            if ($('#txtMarkup').val() == '') {
              msgAlerta('Selecione um Markup!')
              $($('.txtQtdeGrade')[iIndex]).val('0')
              return;
            }
          }
        }

        $('#tabelaGrade').DataTable().row(iIndex).data(dados).draw(false);
        $($('.txtPercAcresGrade')[iIndex]).val('0.00');
        $($('.txtValAcresGrade')[iIndex]).val('0.00');
        $($('.txtPercDescGrade')[iIndex]).val('0.00');
        $($('.txtValDescGrade')[iIndex]).val('0.00');
        break;
      }
      case 'txtPercAcresGrade': {
        const dados = $('#tabelaGrade').DataTable().row(iIndex).data();
        const valorAcres = TruncaDecimaisNova(2, (parseFloat(dados.PRECO_LIQ) * valor) / 100);
        dados.TOTAL = (parseFloat(dados.PRECO_LIQ) + valorAcres).toFixed(2);

        $('#tabelaGrade').DataTable().row(iIndex).data(dados).draw(false);
        $($('.txtValAcresGrade')[iIndex]).val(valorAcres.toFixed(2));
        $($('.txtPercDescGrade')[iIndex]).val('0.00');
        $($('.txtValDescGrade')[iIndex]).val('0.00');
        break;
      }
      case 'txtValAcresGrade': {
        const dados = $('#tabelaGrade').DataTable().row(iIndex).data();
        const percAcres = TruncaDecimaisNova(2, valor / (parseFloat(dados.PRECO_LIQ) / 100));
        dados.TOTAL = (parseFloat(dados.PRECO_LIQ) + valor).toFixed(2);

        $('#tabelaGrade').DataTable().row(iIndex).data(dados).draw(false);
        $($('.txtPercAcresGrade')[iIndex]).val(percAcres.toFixed(2));
        $($('.txtPercDescGrade')[iIndex]).val('0.00');
        $($('.txtValDescGrade')[iIndex]).val('0.00');
        break;
      }
      case 'txtPercDescGrade': {
        const dados = $('#tabelaGrade').DataTable().row(iIndex).data();
        const valorDesc = TruncaDecimaisNova(2, (parseFloat(dados.PRECO_LIQ) * valor) / 100);
        dados.TOTAL = (parseFloat(dados.PRECO_LIQ) - valorDesc).toFixed(2);

        $('#tabelaGrade').DataTable().row(iIndex).data(dados).draw(false);
        $($('.txtValDescGrade')[iIndex]).val(valorDesc.toFixed(2));
        $($('.txtPercAcresGrade')[iIndex]).val('0.00');
        $($('.txtValAcresGrade')[iIndex]).val('0.00');
        break;
      }
      case 'txtValDescGrade': {
        const dados = $('#tabelaGrade').DataTable().row(iIndex).data();
        const percDesc = TruncaDecimaisNova(2, valor / (parseFloat(dados.PRECO_LIQ) / 100));
        dados.TOTAL = (parseFloat(dados.PRECO_LIQ) - valor).toFixed(2);

        $('#tabelaGrade').DataTable().row(iIndex).data(dados).draw(false);
        $($('.txtPercDescGrade')[iIndex]).val(percDesc.toFixed(2));
        $($('.txtPercAcresGrade')[iIndex]).val('0.00');
        $($('.txtValAcresGrade')[iIndex]).val('0.00');
        break;
      }
    }

    $('.camposMascara').off();
    $('.txtCamposGrade').off('blur');

    $('.txtCamposGrade').on('blur', function () {
      calculaTotaisGrade($(this).attr('data-campo').replace(' txtCamposGrade', ''), $(this).attr('data-index'));
    });

    aplicaMascara();

    $($('.' + sCampo)[iIndex]).val(valor.toFixed(2));
    $($('.txtQtdeGrade')[iIndex]).val(qtde.toFixed(0));

    atualizaTotaisGrade();
  };

  function atualizaTotaisGrade() {
    let qtdeTotal = 0;
    $('.txtQtdeGrade').each(index => { qtdeTotal += parseInt($($('.txtQtdeGrade')[index]).val()) });

    const valTotal = $("#tabelaGrade").DataTable().column(8, {}).data().sum();

    insereValor('#txtQtdeTotal', qtdeTotal.toFixed(2));
    insereValor('#txtValTotal', valTotal.toFixed(2));
  };

  $(".collapse").on("shown.bs.collapse", function (e) {
    let clicked = $(document).find(`[href='#${$(e.target).attr("id")}']`);
    clicked.parent().find(".fa-angle-right").removeClass("fa-angle-right").addClass("fa-angle-down");
  }).on("hidden.bs.collapse", function (e) {
    let clicked = $(document).find(`[href='#${$(e.target).attr("id")}']`);
    clicked.parent().find(".fa-angle-down").removeClass("fa-angle-down").addClass("fa-angle-right");
  });

  $("#txtValorNota, #txtQuantidade").bind("DOMSubtreeModified", function () {
    setTimeout(() => { $(this).css("color", "red"); }, 200);
    setTimeout(() => { $(this).css("color", "inherit"); }, 2000);
  });

  $("#dropdown").trigger("change");

  function validaDadosItens() {
    const servico = $($(".classeProduto")[0]).val();
    const qtde = $($(".classeQuantidade")[0]).val();
    const preco = $($(".classePreco")[0]).val();

    if ([servico, qtde, preco].includes('')) {
      msgAlerta('Serviço, quantidade ou preço não informados.\nFavor voltar a aba de itens e verificar.');
      return false;
    }
    return true;
  };

  $("#gravar").click(async function () {
    $(this).attr('disabled', true);

    if (!validaDadosItens()) {
      return;
    }

    $.LoadingOverlay("show");
    try {
      let arrayItens = [];
      let arrayFinanceiro = [];
      for (let i = 0; i < $('#tabelaItens').DataTable().data().toArray().length; i++) {
        const item = $('#tabelaItens').DataTable().data().toArray()[i]

        arrayItens.push({
          ORDEM_DIG: item.ORDEM,
          ORDEM: 1,
          CODIGO: item.PROTOTIPO != '' ? '' : item.CODIGO,
          PROTOTIPO: item.PROTOTIPO,
          DESCRICAO: item.DESCRICAO,
          QUALIDADE: '1',
          COR: item.COR,
          TAM: item.TAM,
          QTDE: item.QTDE,
          PRECO: item.PRECO,
          PRECO_LIQ: item.PRECO,
          VALOR_TOTAL: item.VALOR,
          TIPO_PROD: item.PROTOTIPO != '' ? 'N' : 'E',
          OBS2: item.OBS2,
          OBS3: item.OBS3,
          OBSERVACAO: item.OBSERVACAO,
          FAIXA: item.FAIXA,
          TELA: 'ORCAMENTO'
        });
      }

      for (let i = 0; i < $('#tabelaDuplicatas').DataTable().data().toArray().length; i++) {
        const item = $('#tabelaDuplicatas').DataTable().data().toArray()[i]
        arrayFinanceiro.push({
          NUM_PARCELA: item.PARCELA,
          VENCTO: item.VENCIMENTO,
          VALOR_PARCELA: item.VALOR,
          QUANT_PARC: $('#txtNParcelas').val(),
          VALOR_TOTAL: $('#txtValorFinanceiro').text().replace('.', '').replace(',', '.'),
          PRZ_PRIM_PARC: $('#txtPrazoPrimeiraParc').val(),
          INTERV_PARC: $('#txtIntervaloParc').val(),
          PRZ_MEDIO: $('#txtPrazoMedioCalc').val(),
          VAL_ENT_PED: parseFloat($('#txtValorEntrada').val()),
          CONSIDERARSIMULACAO: $('#checkConsiderarSimulação').is(':checked') ? 'S' : 'N',
        });
      }

      if (arrayItens.length <= 0) {
        throw new Error('Nenhum item no orçamento!')
      }

      if (arrayFinanceiro.length <= 0) {
        throw new Error('Nenhuma parcela criada no orçamento!')
      }

      const classOs = {
        USUARIO: getCookie('usuario'),
        NUMERO: pegaValor('#txtNumero'),
        EMP_FAT: pegaValor('#selectEmpresa'),
        CLIENTE: pegaChave('#txtCliente'),
        PED_CLI: pegaValor('#txtPedcli'),
        DTDIGITA: pegaValor('#dtDigitacao'),
        CODREP: pegaChave('#txtRepresentante'),
        COM1: pegaValor('#txtComissaoFat'),
        COM2: pegaValor('#txtComissaoRec'),
        CODAGENCIA: pegaChave('#txtAgencia'),
        COM1_AGENCIA: pegaValor('#txtComissao'),
        PEDIDO: pegaChave('#txtPedido'),
        SOLICITANTE: pegaChave('#txtSolicitante'),
        TAB_PRE: pegaChave('#txtTabPreco'),
        BLOQ_COM: pegaValor('#selectStatusComercial'),
        DT_CADASTRO: $('#dtEmissao').val(),
        DT_VALIDADE: pegaValor('#dtValidade'),
        DIAS_ENTREGA: pegaValor('#txtDias'),
        DT_ENTREGA: $('#dtEntrega').val(),
        DT_SAIDA: $('#dtSaida').val(),
        OBSERVACAO: pegaValor('#txtObservacoes'),
        SITUACAO: $('#rdSituacaoAberto').is(':checked') ? 'A' : $('#rdSituacaoFechado').is(':checked') ? 'F' : $('#rdSituacaoEmAprov').is(':checked') ? 'E' : $('#rdSituacaoPerdido').is(':checked') ? 'P' : '',
        SOMA_DIAS_ENT: $('#rdSumDiasCorridos').is(':checked') ? 'C' : 'U',
        MOEDA: pegaChave('#txtMoeda'),
        HISTORICO: pegaChave('#txtHistorico'),
        SIT_DUP: pegaChave('#txtSituacao'),
        CLASSE_GER: pegaChave('#txtClasseGer'),
        TAB_TRANS: pegaChave('#txtTransportadora'),
        CIF: $('#rgTransportador').val(),
        NATUREZA: pegaChave('#txtNatureza'),
        ALIQUOTA: pegaValor('#txtAliquota'),
        FRETE: pegaValor('#txtValFrete'),
        PESO_BRUTO: pegaValor('#txtPesoBruto'),
        PESO_LIQ: pegaValor('#txtPesoLiquido'),
        VOLUMES: pegaValor('#txtVolumes'),
        END_ENT: pegaValor('#txtEndEntrega'),
        BAIRRO_ENT: pegaValor('#txtBairroEntrega'),
        NOME_CIDADE: pegaValor('#txtCidadeEntrega'),
        COD_UF: pegaValor('#txtEstadoEntrega'),
        NUM_ENT: pegaValor('#txtNumeroEntrega'),
        CEP: pegaValor('#txtCepEntrega'),
        MARKUP: pegaChave('#txtMarkup'),
        PGTO: pegaChave('#txtCondicao'),
        PRZ_MEDIO: pegaValor('#txtPrazoMedioCalc'),
        PER_DESC: parseFloat(pegaValor('#txtDesconto')),
        DESC_UNIFICADO: campoDesconto(parseFloat($('#txtDesconto1').val()), parseFloat($('#txtDesconto2').val()), parseFloat($('#txtDesconto3').val()), parseFloat($('#txtDesconto4').val()), parseFloat($('#txtDesconto5').val())),
        ITENS: arrayItens,
        OS_SIMULA: arrayFinanceiro,
        EMP_ID: getCookie('emp_id'),
      };

      const response = await requisicao('POST', '/sisplan/os/v1/ordemservico?', '', `JSON=${encodeURIComponent(JSON.stringify(classOs))}`, 90000);

      if (!response) {
        return;
      }

      const jsonStr = await response.json();
      if (response.status != 200) {
        msgErro(jsonStr.mensagem);
        return;
      }

      criaMensagemSucesso('Orçamento gravado com sucesso.', () => { window.location.href = `${BASE_URI}/orcamento`; });

    } catch (error) {
      console.error(error);
      msgErro(`Não foi possível gravar os dados da ordem de serviço: ${error}`);
    } finally {
      $(this).attr('disabled', false);
      $.LoadingOverlay('hide')
    }
  });

  async function carregaValoresPadroes() {
    if (orcamento != 'create') {
      return;
    }

    const pesquisa = {
      camposSelect: ['CAMPO', 'VALOR'],
      tabela: 'TABPADRAO',
      where: [`TABELA = 'ORCAMENTO'`]
    }
    const jsonStr = await retornaJsonPesquisaPadrao(JSON.stringify(pesquisa));

    jsonStr.map(item => {
      switch (item.CAMPO) {
        case 'MOEDA': {
          if (item.VALOR != '') {
            insereValor('#txtMoeda', item.VALOR, { tabela: 'MOEDA', campoBusca: 'DESCRICAO', campoWhere: 'CODMOE', valorWhere: item.VALOR });
          }
          break;
        }
        case 'HISTORICO': {
          if (item.VALOR != '') {
            insereValor('#txtHistorico', item.VALOR, { tabela: 'HISTCP', campoBusca: 'DESCRICAO', campoWhere: 'HISTORICO', valorWhere: item.VALOR });
          }
          break;
        }
        case 'SITUACAO': {
          if (item.VALOR != '') {
            insereValor('#txtSituacao', item.VALOR, { tabela: 'TABSIT', campoBusca: 'DESCRICAO', campoWhere: 'CODIGO', valorWhere: item.VALOR });
          }
          break;
        }
        case 'CLASSEGER': {
          if (item.VALOR != '') {
            insereValor('#txtClasseGer', item.VALOR, { tabela: 'CLASSE_GER', campoBusca: 'DESCRICAO', campoWhere: 'CODIGO', valorWhere: item.VALOR });
          }
          break;
        }
        case 'TABPRECO': {
          if (item.VALOR != '') {
            insereValor('#txtTabPreco', item.VALOR, { tabela: 'REGIAO', campoBusca: 'DESCRICAO', campoWhere: 'REGIAO', valorWhere: item.VALOR });
          }
          break;
        }

      }
    });
  };

  function addPesquisaAutocompleta() {
    $("#txtCliente").autocompleta(3, `JSON={ "tabela":"entidade", "camposSelect":["CODCLI CHAVE, NOME DESCRICAO"], "where": ["nome <> 'CONSUMIDOR FINAL' and ativo = 'S'"] }`);
    $("#btn-cliente").pesquisa_serverside(["#txtCliente"],
      ["CODCLI"], ["ENTIDADE.NOME"],
      `{
        "tabela":"ENTIDADE", 
        "camposSelect":[
          "CODCLI", 
          "ENTIDADE.NOME", 
          "FANTASIA", 
          "CNPJ", 
          "COD_UF", 
          "CIDADE.NOME" 
        ], 
        "leftJoin":[
          {"tabela": "CADCEP", "condicao": "ENTIDADE.CEP = CADCEP.CEP"},
          {"tabela": "CIDADE", "condicao": "CIDADE.CODIGO = CADCEP.CODMUN"}
        ],
        "where": ["ENTIDADE.nome <> 'CONSUMIDOR FINAL' and ENTIDADE.ativo = 'S'"]
       }`,
      "Pesquisa Cliente");
    $("#btn-limpa-cliente").on("click", function () {
      $("#txtCliente").val("")
      $("#txtCliente").trigger("blur");
    });

    $("#txtRepresentante").autocompleta(1, `JSON={ "tabela":"REPRESEN", "camposSelect":["CODREP CHAVE, NOME DESCRICAO"], "where": null }`);
    $("#btn-Representante").pesquisa_serverside(["#txtRepresentante"], ["CODREP"], ["NOME"], `{"tabela":"REPRESEN", "camposSelect":[ "CODREP", "NOME" ], "where": null}`, "Pesquisa Representante");
    $("#btn-limpa-Representante").on("click", function () { $("#txtRepresentante").val(""); });

    $("#txtAgencia").autocompleta(1, `JSON={ "tabela":"REPRESEN", "camposSelect":["CODREP CHAVE, NOME DESCRICAO"], "where": null }`);
    $("#btn-Agencia").pesquisa_serverside(["#txtAgencia"], ["CODREP"], ["NOME"], `{"tabela":"REPRESEN", "camposSelect":[ "CODREP", "NOME" ], "where": null}`, "Pesquisa Agência");
    $("#btn-limpa-Agencia").on("click", function () { $("#txtAgencia").val(""); });

    $("#txtSolicitante").autocompleta(1, `JSON={ "tabela":"CONTATO", "camposSelect":["ID CHAVE, NOME DESCRICAO"], "where": ["NOME <> ''"] }`, [], [], []);
    $("#btn-Solicitante").pesquisa_serverside(["#txtSolicitante"], ["ID"], ["NOME"], `{"tabela":"CONTATO", "camposSelect":[ "ID", "NOME" ], "where": ["NOME <> ''"]}`, "Pesquisa Solicitante",);
    $("#btn-limpa-Solicitante").on("click", function () { $("#txtSolicitante").val(""); });

    $("#txtTabPreco").autocompleta(1, `JSON={ "tabela":"REGIAO", "camposSelect":["REGIAO CHAVE, DESCRICAO DESCRICAO"], "where": null }`);
    $("#btn-TabPreco").pesquisa_serverside(["#txtTabPreco"], ["REGIAO"], ["DESCRICAO"], `{"tabela":"REGIAO", "camposSelect":[ "REGIAO", "DESCRICAO" ], "where": null}`, "Pesquisa Tabela de Preço");
    $("#btn-limpa-TabPreco").on("click", function () { $("#txtTabPreco").val(""); });

    $("#txtSituacao").autocompleta(1, `JSON={ "tabela":"tabsit", "camposSelect":["CODIGO CHAVE, DESCRICAO"], "where": [] }`);
    $("#btn-situacao").pesquisa("#txtSituacao", "CODIGO", "DESCRICAO", '/sisplan/funcoes/v1/pesquisa?JSON={ "tabela":"tabsit", "camposSelect":[ "codigo", "descricao" ], "where": null}', "Pesquisa Situação", "tabsit");
    $("#btn-limpa-situacao").on("click", function () { $("#txtSituacao").val(""); });

    $("#txtClasseGer").autocompleta(1, `JSON={ "tabela":"classe_ger", "camposSelect":["CODIGO CHAVE, DESCRICAO"], "where": [] }`);
    $("#btn-classeGer").pesquisa("#txtClasseGer", "CODIGO", "DESCRICAO", '/sisplan/funcoes/v1/pesquisa?JSON={ "tabela":"classe_ger", "camposSelect":[ "codigo", "descricao" ], "where": null}', "Pesquisa Classe Gerencial", "classe_ger");
    $("#btn-limpa-classeGer").on("click", function () { $("#txtClasseGer").val(""); });

    $("#txtMoeda").autocompleta(1, `JSON={ "tabela":"moeda", "camposSelect":["codmoe CHAVE, DESCRICAO"], "where": [] }`);
    $("#btnMoeda").pesquisa("#txtMoeda", "CODMOE", "DESCRICAO", '/sisplan/funcoes/v1/pesquisa?JSON={ "tabela":"moeda", "camposSelect":[ "codmoe", "descricao" ], "where": null}', "Pesquisa Moeda", "moeda");
    $("#btnAMoeda").on("click", function () { $("#txtMoeda").val(""); });

    $("#txtHistorico").autocompleta(1, `JSON={ "tabela":"histcp", "camposSelect":["HISTORICO CHAVE, DESCRICAO"], "where": [] }`);
    $("#btn-historico").pesquisa("#txtHistorico", "HISTORICO", "DESCRICAO", '/sisplan/funcoes/v1/pesquisa?JSON={ "tabela":"histcp", "camposSelect":[ "historico", "descricao" ], "where": null}', "Pesquisa Histórico", "histcp");
    $("#btn-limpa-historico").on("click", function () { $("#txtHistorico").val(""); });

    $("#txtNatureza").autocompleta(1, `JSON={ "tabela":"natureza", "camposSelect":["NATUREZA CHAVE, DESCRICAO DESCRICAO"], "where": ["ativo = 'S'"] }`);
    $("#btn-natureza").pesquisa("#txtNatureza", "NATUREZA", "DESCRICAO", `/sisplan/funcoes/v1/pesquisa?JSON={ "tabela":"natureza", "camposSelect":[ "natureza", "descricao" ], "where": ["ativo = 'S'"]}`, "Pesquisa Natureza", "natureza");
    $("#btn-limpa-natureza").on("click", function () { $("#txtNatureza").val(""); });

    $("#txtTransportadora").autocompleta(1, `JSON={ "tabela":"tabtran", "camposSelect":["CODIGO CHAVE, NOME DESCRICAO"], "where": [] }`);
    $("#btnTransportadora").pesquisa("#txtTransportadora", "CODIGO", "NOME", '/sisplan/funcoes/v1/pesquisa?JSON={ "tabela":"tabtran", "camposSelect":[ "codigo", "nome" ], "where": null}', "Pesquisa Transportadora", "tabtran");
    $("#btnATransportadora").on("click", function () { $("#txtTransportadora").val(""); });

    $("#txtCodigo").autocompleta(1, `JSON={ "tabela":"PRODUTO", "camposSelect":["CODIGO CHAVE, DESCRICAO"], "where": [] }`);
    $("#btn-Codigo").pesquisa("#txtCodigo", "CODIGO", "DESCRICAO", '/sisplan/funcoes/v1/pesquisa?JSON={ "tabela":"PRODUTO", "camposSelect":[ "codigo", "descricao" ], "where": null}', "Pesquisa Produto", "PRODUTO");
    $("#btn-limpa-Codigo").on("click", function () { $("#txtCodigo").val(""); });

    $("#txtCor").autocompleta(1, `JSON={ "tabela":"CADCOR", "camposSelect":["COR CHAVE, DESCRICAO"], "where": [] }`);
    $("#btn-Cor").pesquisa("#txtCor", "COR", "DESCRICAO", '/sisplan/funcoes/v1/pesquisa?JSON={ "tabela":"CADCOR", "camposSelect":[ "COR", "descricao" ], "where": null}', "Pesquisa Cor", "CADCOR");
    $("#btn-limpa-Cor").on("click", function () { $("#txtCor").val(""); });

    $("#txtLinha").autocompleta(1, `JSON={ "tabela":"TABLIN", "camposSelect":["CODIGO CHAVE, DESCRICAO"], "where": [] }`);
    $("#btn-Linha").pesquisa("#txtLinha", "CODIGO", "DESCRICAO", '/sisplan/funcoes/v1/pesquisa?JSON={ "tabela":"TABLIN", "camposSelect":[ "CODIGO", "descricao" ], "where": null}', "Pesquisa Linha", "TABLIN");
    $("#btn-limpa-Linha").on("click", function () { $("#txtLinha").val(""); });

    $("#txtGrupo").autocompleta(1, `JSON={ "tabela":"GRUPO_PA", "camposSelect":["CODIGO CHAVE, DESCRICAO"], "where": [] }`);
    $("#btn-Grupo").pesquisa("#txtGrupo", "CODIGO", "DESCRICAO", '/sisplan/funcoes/v1/pesquisa?JSON={ "tabela":"GRUPO_PA", "camposSelect":[ "CODIGO", "descricao" ], "where": null}', "Pesquisa Grupo", "GRUPO_PA");
    $("#btn-limpa-Grupo").on("click", function () { $("#txtGrupo").val(""); });

    $("#txtEtiqueta").autocompleta(1, `JSON={ "tabela":"ETQ_PROD", "camposSelect":["CODIGO CHAVE, DESCRICAO"], "where": [] }`);
    $("#btn-Etiqueta").pesquisa("#txtEtiqueta", "CODIGO", "DESCRICAO", '/sisplan/funcoes/v1/pesquisa?JSON={ "tabela":"ETQ_PROD", "camposSelect":[ "CODIGO", "descricao" ], "where": null}', "Pesquisa Etiqueta", "ETQ_PROD");
    $("#btn-limpa-Etiqueta").on("click", function () { $("#txtEtiqueta").val(""); });

    $("#txtMarkup").autocompleta(1, `JSON={ "tabela":"CAD_MARKUP", "camposSelect":["CODIGO CHAVE, DESCRICAO"], "where": [] }`);
    $("#btn-Markup").pesquisa("#txtMarkup", "CODIGO", "DESCRICAO", '/sisplan/funcoes/v1/pesquisa?JSON={ "tabela":"CAD_MARKUP", "camposSelect":[ "CODIGO", "descricao" ], "where": null}', "Pesquisa Markup", "CAD_MARKUP");
    $("#btn-limpa-Markup").on("click", function () { $("#txtMarkup").val(""); });

    $("#txtDeposito").autocompleta(1, `JSON={ "tabela":"DEPOSITO", "camposSelect":["CODIGO CHAVE, DESCRICAO"], "where": [] }`);
    $("#btn-Deposito").pesquisa("#txtDeposito", "CODIGO", "DESCRICAO", '/sisplan/funcoes/v1/pesquisa?JSON={ "tabela":"DEPOSITO", "camposSelect":[ "CODIGO", "descricao" ], "where": null}', "Pesquisa Depósito", "DEPOSITO");
    $("#btn-limpa-Deposito").on("click", function () { $("#txtDeposito").val(""); });

    $("#txtFornecedor").autocompleta(3, `JSON={ "tabela":"entidade", "camposSelect":["CODCLI CHAVE, NOME DESCRICAO"], "where": ["nome <> 'CONSUMIDOR FINAL' and ativo = 'S'"] }`);
    $("#btnFornecedor").pesquisa_serverside(["#txtFornecedor"], ["CODCLI", "CNPJ"], ["NOME"], `{"tabela":"entidade", "camposSelect":[ "CODCLI", "NOME" ], "where": ["nome <> 'CONSUMIDOR FINAL' and ativo = 'S'"]}`, "Pesquisa Fornecedor");
    $("#btnAFornecedor").on("click", function () { $("#txtFornecedor").val(""); });

    $("#txtMaterial").autocompleta(1, `JSON={ "tabela":"MATERIAL", "camposSelect":["CODIGO CHAVE, DESCRICAO"], "where": [] }`);
    $("#btnMaterial").pesquisa("#txtMaterial", "CODIGO", "DESCRICAO", '/sisplan/funcoes/v1/pesquisa?JSON={ "tabela":"MATERIAL", "camposSelect":[ "CODIGO", "descricao" ], "where": null}', "Pesquisa Material", "MATERIAL");
    $("#btnAMaterial").on("click", function () { $("#txtMaterial").val(""); });

    $("#txtCorItem").autocompleta(1, `JSON={ "tabela":"CADCOR", "camposSelect":["COR CHAVE, DESCRICAO"], "where": [] }`);
    $("#btnCor").pesquisa("#txtCorItem", "COR", "DESCRICAO", '/sisplan/funcoes/v1/pesquisa?JSON={ "tabela":"CADCOR", "camposSelect":[ "COR", "descricao" ], "where": null}', "Pesquisa Cor", "CADCOR");
    $("#btnACor").on("click", function () { $("#txtCorItem").val(""); });

    $("#txtCorGrade").autocompleta(1, `JSON={ "tabela":"CADCOR", "camposSelect":["COR CHAVE, DESCRICAO"], "where": [] }`);
    $("#btnCorGrade").pesquisa("#txtCorGrade", "COR", "DESCRICAO", '/sisplan/funcoes/v1/pesquisa?JSON={ "tabela":"CADCOR", "camposSelect":[ "COR", "descricao" ], "where": null}', "Pesquisa Cor", "CADCOR");
    $("#btnACorGrade").on("click", function () { $("#txtCorGrade").val(""); });

    $("#txtFaixa").autocompleta(1, `JSON={ "tabela":"FAIXA", "camposSelect":["CODIGO CHAVE, DESCRICAO"], "where": [] }`);
    $("#btnFaixa").pesquisa("#txtFaixa", "CODIGO", "DESCRICAO", '/sisplan/funcoes/v1/pesquisa?JSON={ "tabela":"FAIXA", "camposSelect":[ "CODIGO", "descricao" ], "where": null}', "Pesquisa Faixa", "Faixa");
    $("#btnAFaixa").on("click", function () { $("#txtFaixa").val(""); });

    $("#txtCondicao").autocompleta(1, `JSON={ "tabela":"CONDICAO", "camposSelect":["CODCOND CHAVE, DESCRICAO"], "where": [] }`);
    $("#btnCondicao").pesquisa("#txtCondicao", "CODCOND", "DESCRICAO", '/sisplan/funcoes/v1/pesquisa?JSON={ "tabela":"CONDICAO", "camposSelect":[ "CODCOND", "DESCRICAO", "ENTRADA", "PRZ_MEDIO", "NRPAR", "PRAZOINI", "NRDIA"], "where": null}', "Pesquisa Condicao", "CONDICAO");
    $("#btnLimpaCondicao").on("click", function () {
      $('.dadosFinan').prop('disabled', true)
      limpaDadosFinan()
      $("#txtCondicao").val("");
    });
  };

  function criaMascaraCampos() {
    $("#txtTamCm2, #txtLarguraBordado, #txtAlturaBordado, #txtLarguraSerigrafia, #txtAlturaSerigrafia, #txtComissaoFat, #txtComissaoRec, #txtComissao, #txtAliquota, #txtValFrete, #txtPesoBruto, #txtPesoLiquido, #txtFrete, #txtPreco").maskMoney({
      decimal: ".",
      thousands: "",
      precision: 2,
    });

    $("#txtTotalPecasTermotape, #txtTotalPecasBordado, #txtQtdeProg, #txtTotalPecasSerigrafia, #txtVolumes, #txtQtdeCores").maskMoney({
      decimal: ".",
      thousands: "",
      precision: 0,
    });

    $('.maskDecimais').maskMoney({
      decimal: ".",
      thousands: "",
      precision: 2,
    });

    $('.maskDecimais').on('blur', function () {
      if ($(this).val() == "") {
        $(this).val('0.00');
      }
    });

    $('.maskInteiro').maskMoney({
      decimal: ".",
      thousands: "",
      precision: 0,
    });

    $('.maskInteiro').on('blur', function () {
      if ($(this).val() == "") {
        $(this).val('0');
      }
    });

    $('.blurEnter').on('keydown', function () {
      if (event.key == "Enter") {
        $(this).trigger("blur");
      }
    })
  };

  async function addBotoesAvancarVoltar() {
    $(".next").click(async function () {
      currentFs = $(this).parent();
      nextFs = $(this).parent().next();

      if (currentFs.prevObject[0].id == 'avancar1') {
        if (!$('#txtCliente').val()) {
          throw msgAlerta('Necessário inserir um cliente, verifique!')
        }
      }

      if (currentFs.prevObject[0].id == 'avancarFinanceiro') {
        if (!$('#txtMoeda').val()) {
          throw msgAlerta('Necessário inserir uma moeda, verifique!')
        }
        if (!$('#txtHistorico').val()) {
          throw msgAlerta('Necessário inserir um histórico, verifique!')
        }
        if (!$('#txtSituacao').val()) {
          throw msgAlerta('Necessário inserir uma situação, verifique!')
        }
        if (!$('#txtClasseGer').val()) {
          throw msgAlerta('Necessário inserir uma classe, verifique!')
        }
        if (!$('#txtCondicao').val()) {
          throw msgAlerta('Necessário infromar a condição de pagamento, verifique!')
        }
      }

      $("#progressbar li").eq($("fieldset").index(nextFs) - 2).addClass("active");
      nextFs.show();
      currentFs.animate(
        {
          opacity: 0,
        },
        {
          step(now) {
            opacity = 1 - now;
            currentFs.css({
              display: "none",
              position: "relative",
            });
            nextFs.css({
              opacity,
            });
          },
          duration: 600,
        }
      );
      $("#tabelaDuplicatas").DataTable().columns.adjust().draw(false);
      $("#tabelaItens").DataTable().columns.adjust().draw(false);
    });

    $(".previous").click(async function () {
      let currentFs = $(this).parent();
      let previousFs = $(this).parent().prev();
      $("#progressbar li").eq($("fieldset").index(currentFs) - 2).removeClass("active");
      previousFs.show();
      currentFs.animate(
        {
          opacity: 0,
        },
        {
          step(now) {
            opacity = 1 - now;
            currentFs.css({ display: "none", position: "relative" });
            previousFs.css({ opacity });
          },
          duration: 600,
        }
      );
      $("#tabelaDuplicatas").DataTable().columns.adjust().draw(false);
      $("#tabelaItens").DataTable().columns.adjust().draw(false);
    });
  };

  function addValidacaoCamposObrigatorios() {
    $("#msform").validate({
      debug: false,
      ignore: "",
      rules: {
        txtCliente: {
          required: true,
        },
        txtDeposito: {
          required: true,
        },
        txtTransportadora: {
          required: true,
        },
        "txtProduto-0": {
          required: true,
        },
        "txtQuantidade-0": {
          required: true,
        },
        "txtPreco-0": {
          required: true,
        }
      },
      messages: {
        txtCliente: {
          required: "Informe um cliente válido.",
        },
        txtDeposito: {
          required: "Informe um depósito válido.",
        },
        txtTransportadora: {
          required: "Informe uma transportadora válida.",
        },
        "txtProduto-0": {
          required: "Informe um produto válido.",
        },
        "txtQuantidade-0": {
          required: "Informe uma quantidade válida.",
        },
        "txtPreco-0": {
          required: "Informe um preço válido.",
        }
      },
      errorElement: "span",
      errorPlacement(error, element) {
        error.addClass("invalid-feedback");
        element.closest(".form-group").append(error);
      },
      highlight(element) {
        $(element).addClass("is-invalid");
      },
      unhighlight(element) {
        $(element).removeClass("is-invalid");
      },
    });
  };

  $('#txtDiasValidade').on('blur', function () {
    const dias = pegaValor('#txtDiasValidade');

    if (dias == '') {
      return;
    }

    setarDataAtual('dtValidade', false, parseFloat(dias));
  });

  $('#btn-adiciona-cliente').on('click', async function () {
    $('#modal-entid-simpl').modal('show')
    $('#btnModalNovaEntidSimpl').trigger('click')
  })

  $("#txtMaterial").on('blur', async function () {
    if ($("#txtMaterial").val() == '') {
      return
    }
    $.LoadingOverlay('show')
    try {
      $("#txtCorItem").autocompleta(1, `JSON={ "tabela":"CADCOR", "camposSelect":["CADCOR.COR CHAVE, CADCOR.DESCRICAO DESCRICAO"], "innerjoin": [{"tabela": "MAT_ITEN", "condicao": "MAT_ITEN.COR = CADCOR.COR"}], "where": ["MAT_ITEN.CODIGO = '${pegaChave('#txtMaterial')}' AND CADCOR.INATIVO <> 'S'"], "groupBy": ["CADCOR.COR, CADCOR.DESCRICAO"] }`);
      $("#btnCor").pesquisa("#txtCorItem", "COR", "DESCRICAO", `/sisplan/funcoes/v1/pesquisa?JSON={ "tabela":"CADCOR", "camposSelect":[ "CADCOR.COR", "CADCOR.DESCRICAO" ], "innerjoin": [{"tabela": "MAT_ITEN", "condicao": "MAT_ITEN.COR = CADCOR.COR"}], "where": ["MAT_ITEN.CODIGO = '${pegaChave('#txtMaterial')}' AND CADCOR.INATIVO <> 'S'"], "groupBy": ["CADCOR.COR, CADCOR.DESCRICAO"]}`, "Pesquisa Cor", "CADCOR");
    } finally {
      $.LoadingOverlay('hide')
    }
  })

  $('#modalComposicao').on('shown.bs.modal', async function () {
    $.LoadingOverlay('show')
    try {
      if ($("#txtMaterial").val() != '') {
        $("#txtCorItem").autocompleta(1, `JSON={ "tabela":"CADCOR", "camposSelect":["CADCOR.COR CHAVE, CADCOR.DESCRICAO DESCRICAO"], "innerjoin": [{"tabela": "MAT_ITEN", "condicao": "MAT_ITEN.COR = CADCOR.COR"}], "where": ["MAT_ITEN.CODIGO = '${pegaChave('#txtMaterial')}' AND CADCOR.INATIVO <> 'S'"], "groupBy": ["CADCOR.COR, CADCOR.DESCRICAO"] }`);
        $("#btnCor").pesquisa("#txtCorItem", "COR", "DESCRICAO", `/sisplan/funcoes/v1/pesquisa?JSON={ "tabela":"CADCOR", "camposSelect":[ "CADCOR.COR", "CADCOR.DESCRICAO" ], "innerjoin": [{"tabela": "MAT_ITEN", "condicao": "MAT_ITEN.COR = CADCOR.COR"}], "where": ["MAT_ITEN.CODIGO = '${pegaChave('#txtMaterial')}' AND CADCOR.INATIVO <> 'S'"], "groupBy": ["CADCOR.COR, CADCOR.DESCRICAO"]}`, "Pesquisa Cor", "CADCOR");
      }
    } finally {
      $.LoadingOverlay('hide')
    }
  })

  async function limpaValoresItens() {
    limpaValor('#txtCodigo')
    limpaValor('#txtCor')
    limpaValor('#txtLinha')
    limpaValor('#txtGrupo')
    limpaValor('#txtEtiqueta')
    limpaValor('#txtDeposito')
    limpaValor('#txtFrete')
    limpaValor('#txtQtde')
    limpaValor('#txtPreco')
    limpaValor('#dtEntregaItem')
    limpaValor('#txtObsProduto')
    limpaValor('#txtObsProducao')
    limpaValor('#txtObsEspecificacoes')
    limpaValor('#txtCorGrade')
    limpaValor('#txtFaixa')
    limpaValor('#txtNomeSerigrafia')
    limpaValor('#txtQtdeCores')
    limpaValor('#txtAlturaSerigrafia')
    limpaValor('#txtLarguraSerigrafia')
    limpaValor('#txtTotalPecasSerigrafia')
    limpaValor('#txtTamCm2')
    limpaValor('#txtTotalPecasTermotape')
    $('#txtQtdeTotal').val(0)
    $('#txtValTotal').val(0)

    $('#tabelaCaracteristicas').DataTable().rows().clear().draw(false)
    $('#tabelaComposicao').DataTable().rows().clear().draw(false)
    $('#tabelaAplicacoes').DataTable().rows().clear().draw(false)
    $('#tabelaTecidosUtilizados').DataTable().rows().clear().draw(false)
    $('#tabelaConsumos').DataTable().rows().clear().draw(false)
    $('#tabelaSerigrafia').DataTable().rows().clear().draw(false)
    $('#tabelaBordado').DataTable().rows().clear().draw(false)
    $('#tabelaSublimacao').DataTable().rows().clear().draw(false)
    $('#tabelaTermotape').DataTable().rows().clear().draw(false)
    $('#tabelaTermotapeTipo').DataTable().rows().clear().draw(false)
    $('#tabelaGrade').DataTable().rows().clear().draw(false)
  }

  $('#btnDesistirInfos').on('click', async function () {
    $.LoadingOverlay('show')
    try {
      await limpaValoresItens()
    } finally {
      $.LoadingOverlay('hide')
    }
  })

  $('#tabelaTecidosUtilizados').on('click', '.checkAplicacoes', async function () {
    $.LoadingOverlay('show')
    try {
      let item = $('#tabelaTecidosUtilizados').DataTable().row($(this).parents('tr')).data()
      if ($(this).is(':checked')) {
        for (let j = 0; j < $('#tabelaAplicacoes').DataTable().data().toArray().length; j++) {
          const aplicacao = $('#tabelaAplicacoes').DataTable().data().toArray()[j]
          for (let i = 0; i < $('#tabelaComposicao').DataTable().data().toArray().length; i++) {
            const composicao = $('#tabelaComposicao').DataTable().data().toArray()[i]

            if (item.CODIGO == composicao.CODIGO) {
              item.COR = composicao.COR
              item.ID = aplicacao.ID
              item.COD_APL = aplicacao.COD_APL
            }
          }
        }
        $('#tabelaTecidosUtilizados').DataTable().row($(this).parents('tr')).data(item).draw(false);
      }
    } finally {
      $.LoadingOverlay('hide')
    }
  })

  async function buscarOrcamento(orcamento) {
    $.LoadingOverlay('show')
    try {
      const pesquisaParam = {
        tabela: 'OS',
        camposSelect: ['OS.NUMERO', 'OS.CLIENTE', 'ENTIDADE.NOME NOME_CLI', 'OS.PED_CLI', 'OS.DTDIGITA',
          'OS.CODREP', 'REPRESEN.NOME NOME_REP', 'OS.COM1', 'OS.COM2', 'OS.CODAGENCIA', 'AGENCIA.NOME NOME_AGEN',
          'OS.COM1_AGENCIA', 'OS.PEDIDO', 'OS.TERCEIRO SOLICITANTE', 'CONTATO.NOME NOME_SOL',
          'OS.TAB_PRE', 'REGIAO.DESCRICAO DESC_TABPRECO', 'OS.BLOQ_COM', 'OS.DT_CADASTRO DT_EMI', 'OS.VALIDADE',
          'OS.DT_VALIDADE', 'OS.DIAS_ENTREGA', 'OS.DT_ENTREGA', 'OS.DT_SAIDA', 'OS.OBSERVACAO', 'OS.SITUACAO', 'OS.SOMA_DIAS_ENT',
          'OS.MOEDA', 'MOEDA.DESCRICAO DESC_MOE', 'OS.HISTORICO', 'HISTCP.DESCRICAO DESC_HIST', 'OS.SIT_DUP',
          'TABSIT.DESCRICAO DESC_SIT', 'OS.CLASSE_GER', 'CLASSE_GER.DESCRICAO DESC_CLASSE', 'OS.TAB_TRANS',
          'TABTRAN.NOME NOME_TRANSP', 'OS.CIF, OS.NATUREZA', 'NATUREZA.DESCRICAO DESC_NATUREZA', 'NATUREZA.ALIQUOTA',
          'OS.FRETE', 'OS.PESO_BRUTO', 'OS.PESO_LIQ', 'OS.VOLUMES', 'ENTIDADE.END_ENT', 'ENTIDADE.BAIRRO_ENT',
          'CIDADE.NOME NOME_CIDADE', 'CIDADE.COD_UF', 'ENTIDADE.NUM_ENT', 'ENTIDADE.CEP', 'OS.MARKUP',
          'OS.PGTO', 'OS.PER_DESC'],
        leftJoin: [{ tabela: "ENTIDADE", alias: "ENTIDADE", condicao: "ENTIDADE.CODCLI = OS.CLIENTE" },
        { tabela: "REPRESEN", alias: "REPRESEN", condicao: "REPRESEN.CODREP = OS.CODREP" },
        { tabela: "REPRESEN", alias: "AGENCIA", condicao: "AGENCIA.CODREP = OS.CODAGENCIA" },
        { tabela: "CONTATO", alias: "CONTATO", condicao: "CONTATO.NUMERO = OS.TERCEIRO " },
        { tabela: "REGIAO", alias: "REGIAO", condicao: "REGIAO.REGIAO = OS.TAB_PRE " },
        { tabela: "MOEDA", alias: "MOEDA", condicao: "CAST(MOEDA.CODMOE AS VARCHAR(3)) = OS.MOEDA" },
        { tabela: "HISTCP", alias: "HISTCP", condicao: "HISTCP.HISTORICO = OS.HISTORICO " },
        { tabela: "TABSIT", alias: "TABSIT", condicao: "TABSIT.CODIGO = OS.SIT_DUP " },
        { tabela: "CLASSE_GER", alias: "CLASSE_GER", condicao: "CLASSE_GER.CODIGO = OS.CLASSE_GER " },
        { tabela: "TABTRAN", alias: "TABTRAN", condicao: "TABTRAN.CODIGO = OS.TAB_TRANS" },
        { tabela: "NATUREZA", alias: "NATUREZA", condicao: "NATUREZA.NATUREZA = OS.NATUREZA " },
        { tabela: "CADCEP", alias: "CADCEP", condicao: "ENTIDADE.CEP = CADCEP.CEP " },
        { tabela: "CI", alias: "CIDADE", condicao: "CIDADE.CODIGO = CADCEP.CODMUN" }],
        where: [`OS.NUMERO = '${orcamento}'`],
        limit: 1
      }

      const jsonStr = await retornaJsonPesquisaPadrao(JSON.stringify(pesquisaParam));
      const os = jsonStr[0]

      //PREENCHE OS CAMPOS DO ORCAMENTO
      $('#txtNumero').val(orcamento)
      insereValor('#txtCliente', os.CLIENTE, os.NOME_CLI)
      $('#txtPedcli').val(os.PED_CLI)
      $('#dtDigitacao').val(os.DTDIGITA)
      insereValor('#txtRepresentante', os.CODREP, os.NOME_REP)
      $('#txtComissaoFat').val(os.COM1)
      $('#txtComissaoRec').val(os.COM2)
      insereValor('#txtAgencia', os.CODAGENCIA, os.NOME_AGEN)
      $('#txtComissao').val(os.COM1_AGENCIA)
      $('#txtPedido').val(os.PEDIDO)
      insereValor('#txtSolicitante', os.SOLICITANTE, os.NOME_SOL)
      insereValor('#txtTabPreco', os.TAB_PRE, os.DESC_TABPRECO)
      $('#selectStatusComercial').val(os.BLOQ_COM)
      $('#dtEmissao').val(os.DT_EMI)
      $('#txtDiasValidade').val(os.VALIDADE)
      $('#dtValidade').val(os.DT_VALIDADE)
      $('#txtDias').val(os.DIAS_ENTREGA)
      $('#dtEntrega').val(os.DT_ENTREGA)
      $('#dtSaida').val(os.DT_SAIDA)
      $('#txtObservacoes').val(os.OBSERVACAO)
      switch (os.SITUACAO) {
        case 'A': {
          $('#rdSituacaoAberto').prop('checked', true)
          break
        }
        case 'F': {
          $('#rdSituacaoFechado').prop('checked', true)
          break
        }
        case 'E': {
          $('#rdSituacaoEmAprov').prop('checked', true)
          break
        }
        case 'P': {
          $('#rdSituacaoPerdido').prop('checked', true)
          break
        }
        default: break
      }
      $('#rdSumDiasCorridos').prop('checked', os.SOMA_DIAS_ENT == 'C')
      $('#rdSumDiasUteis').prop('checked', os.SOMA_DIAS_ENT != 'C')
      //ABA FINANCEIRO
      insereValor('#txtMoeda', os.MOEDA, os.DESC_MOE)
      insereValor('#txtHistorico', os.HISTORICO, os.DESC_HIST)
      insereValor('#txtHistorico', os.HISTORICO, os.DESC_HIST)
      insereValor('#txtSituacao', os.SIT_DUP, os.DESC_SIT)
      insereValor('#txtClasseGer', os.CLASSE_GER, os.DESC_CLASSE)
      insereValor('#txtCondicao', os.PGTO, { tabela: 'CONDICAO', campoBusca: 'DESCRICAO', campoWhere: 'CODCOND', valorWhere: os.PGTO })
      $('#txtDesconto').val(os.PER_DESC)
      //ABA TRANSPORTE
      insereValor('#txtTransportadora', os.TAB_TRANS, os.NOME_TRANSP)
      $('#rgTransportador').val(os.CIF)
      insereValor('#txtNatureza', os.NATUREZA, os.DESC_NATUREZA)
      $('#txtAliquota').val(os.ALIQUOTA)
      $('#txtValFrete').val(os.FRETE)
      $('#txtPesoBruto').val(os.PESO_BRUTO)
      $('#txtPesoLiquido').val(os.PESO_LIQ)
      $('#txtVolumes').val(os.VOLUMES)
      $('#txtEndEntrega').val(os.END_ENT)
      $('#txtBairroEntrega').val(os.BAIRRO_ENT)
      $('#txtCidadeEntrega').val(os.NOME_CIDADE)
      $('#txtEstadoEntrega').val(os.COD_UF)
      $('#txtNumeroEntrega').val(os.NUM_ENT)
      $('#txtCepEntrega').val(os.CEP)

      await buscaItens(orcamento, os)
      await buscaFinanceiro(orcamento)
      calculaTotais()

    } catch (error) {
      console.error(error)
      msgAlerta(error.message)
    } finally {
      $.LoadingOverlay('hide')
    }
  }

  async function buscaItens(orcamento, os) {
    const pesquisaParam = {
      tabela: 'OS_ITEN',
      camposSelect: ['OS_ITEN.ORDEM_DIG', 'OS_ITEN.CODIGO', 'OS_ITEN.TIPO_PROD',
        'PRODUTO.DESCRICAO DESCPRO', 'PROTOTIPO.DESCRICAO DESCPROT',
        'OS_ITEN.COR', 'CADCOR.DESCRICAO DESCCOR',
        'OS_ITEN.TAM', 'OS_ITEN.QTDE', 'OS_ITEN.PRECO', 'OS_ITEN.FAIXA', 'OS_ITEN.PROTOTIPO',
        'OS_ITEN.VALOR_TOTAL VALOR', 'OS_ITEN.CUSTOMIZACAO', 'OS_ITEN.OBS_APROV', 'OS_ITEN.OBS2', 'OS_ITEN.OBS3', 'OS_ITEN.OBSERVACAO'],
      leftJoin: [{ tabela: "CADCOR", condicao: "CADCOR.COR = OS_ITEN.COR" },
      { tabela: "PRODUTO", condicao: "OS_ITEN.CODIGO = PRODUTO.CODIGO AND PRODUTO.CODIGO <> ''" },
      { tabela: "PRODUTO", alias: "PROTOTIPO", condicao: "OS_ITEN.PROTOTIPO = PROTOTIPO.PROTOTIPO AND OS_ITEN.PROTOTIPO IS NOT NULL AND OS_ITEN.PROTOTIPO <> ''" }
      ],
      where: [`OS_ITEN.NUMERO = '${orcamento}'`]
    }

    const jsonStr = await retornaJsonPesquisaPadrao(JSON.stringify(pesquisaParam));

    insereValor('#txtMarkup', os.MARKUP, { tabela: 'CAD_MARKUP', campoBusca: 'DESCRICAO', campoWhere: 'CODIGO', valorWhere: os.MARKUP })
    jsonStr.map(item => {
      $('#tabelaItens').DataTable().row.add({
        ORDEM: item.ORDEM_DIG,
        CODIGO: item.CODIGO == '' ? item.PROTOTIPO : item.CODIGO,
        DESCRICAO: item.DESCPRO == '' ? item.DESCPROT : item.DESCPRO,
        COR: item.COR,
        DESCCOR: item.DESCCOR,
        TAM: item.TAM,
        QTDE: item.QTDE,
        PRECO: item.PRECO,
        VALOR: item.VALOR,
        CUSTOMIZACAO: item.CUSTOMIZACAO,
        OBS2: item.OBS2,
        OBS3: item.OBS3,
        OBSERVACAO: item.OBSERVACAO,
        FAIXA: item.FAIXA,
        PROTOTIPO: item.PROTOTIPO
      }).draw(false);
    });
  }

  async function buscaFinanceiro(orcamento) {
    const pesquisaParam = {
      tabela: 'OS_SIMULA',
      camposSelect: ['NUM_PARCELA', 'VENCTO', 'VALOR_PARCELA', 'CONSIDERAR', 'QUANT_PARC', 'PRZ_PRIM_PARC', 'INTERV_PARC', 'PRZ_MEDIO'],
      where: [`NUMERO = '${orcamento}'`]
    }

    const jsonStr = await retornaJsonPesquisaPadrao(JSON.stringify(pesquisaParam));

    jsonStr.map(item => {
      $('#tabelaDuplicatas').DataTable().row.add({
        PARCELA: item.NUM_PARCELA,
        VENCIMENTO: item.VENCTO,
        VALOR: item.VALOR_PARCELA
      }).draw(false);
    });

    if (jsonStr.length > 0) {
      $('#txtNParcelas').val(jsonStr[0].QUANT_PARC)
      $('#txtPrazoPrimeiraParc').val(jsonStr[0].PRZ_PRIM_PARC)
      $('#txtIntervaloParc').val(jsonStr[0].INTERV_PARC)
      $('#txtPrazoMedioCalc').val(jsonStr[0].PRZ_MEDIO)

      $('#checkConsiderarSimulação').prop('checked', jsonStr[0].CONSIDERAR != 'N');
    }

    $('.dadosFinan').prop('disabled', false)

    const pesquisaParamCond = {
      tabela: 'CONDICAO',
      camposSelect: ['CONDICAO.ENTRADA', 'CONDICAO.PRZ_MEDIO', 'CONDICAO.NRPAR', 'CONDICAO.PRAZOINI', 'CONDICAO.NRDIA', 'COND_PERC.DESCONTO DESCMAX'],
      leftJoin: [{ tabela: 'COND_PERC', condicao: 'COND_PERC.CODIGO = CONDICAO.COND_PERC' }],
      where: [`CONDICAO.CODCOND = '${pegaChave('#txtCondicao')}'`]
    }

    const jsonStrCond = await retornaJsonPesquisaPadrao(JSON.stringify(pesquisaParamCond));

    if (jsonStrCond.length > 0) {
      $('#txtPercEntrada').val(jsonStrCond[0].ENTRADA)
      $('#txtPrzMedio').val(jsonStrCond[0].PRZ_MEDIO)
      $('#txtMaxParcelas').val(jsonStrCond[0].NRPAR)
      $('#txtPrzMaxPrimeira').val(jsonStrCond[0].PRAZOINI)
      $('#txtIntervaloParcelas').val(jsonStrCond[0].NRDIA)
    }
  }

  async function buscaTabelaCliente() {
    if (pegaChave('#txtCliente') == '') {
      return
    }
    $.LoadingOverlay('show')
    try {
      const pesquisaParam = {
        tabela: 'ENTIDADE',
        camposSelect: ['ENTIDADE.TABELA', 'REGIAO.DESCRICAO'],
        leftJoin: [{ tabela: "REGIAO", condicao: "REGIAO.REGIAO = ENTIDADE.TABELA" }],
        where: [`ENTIDADE.CODCLI = '${pegaChave('#txtCliente')}'`]
      }

      const jsonStr = await retornaJsonPesquisaPadrao(JSON.stringify(pesquisaParam));

      if (jsonStr.length > 0) {
        insereValor('#txtTabPreco', jsonStr[0].TABELA, jsonStr[0].DESCRICAO)
      }

    } catch (error) {
      console.error(error)
      msgAlerta(error.message)
    } finally {
      $.LoadingOverlay('hide')
    }
  }

  async function carregaConsumosExpress(sCodigo, sCor) {
    $.LoadingOverlay('show');
    $('#tabelaConsumos').DataTable().clear().draw();
    try {
      const response = await requisicao('GET', '/sisplan/orcamento/v1/buscaconsumosexpress?', `CODIGO=${sCodigo}&COR=${sCor}`);

      if (!response) {
        return;
      }

      const jsonStr = await response.json();

      jsonStr.map(item => {
        $('#tabelaConsumos').DataTable().row.add({
          CODIGO: item.INSUMO,
          DESCRICAO: item.DESCRICAO,
          QTDE: item.CONSUMO,
          CUSTO: item.PRECO_1,
          SETOR: '',
          DESC_SETOR: '',
          COR: item.COR_I,
          DESC_COR: item.DESCCOR,
          COD_OPCIONAL: '',
        }).draw(false);
      });

    } finally {
      $.LoadingOverlay('hide');
    }
  };

  async function explodeFaixaExpress(sFaixa, sTabPreco, sCodigo) {
    $.LoadingOverlay('show');
    $('#tabelaGrade').DataTable().clear();
    try {
      let pesquisaParam;
      if (!usaPrecoCorTam) {
        pesquisaParam = {
          tabela: 'FAIXA_ITEN',
          camposSelect: ['FAIXA_ITEN.TAMANHO', 'FAIXA_ITEN.POSICAO', 'TABPRECO.PRECO_00 PRECO'],
          leftJoin: [{ tabela: "TABPRECO", condicao: `TABPRECO.REGIAO = '${sTabPreco}' AND TABPRECO.CODIGO = '${sCodigo}'` }],
          where: [`FAIXA_ITEN.FAIXA = '${sFaixa}'`],
          orderBy: ['FAIXA_ITEN.POSICAO'],
        }
      } else {
        pesquisaParam = {
          tabela: 'FAIXA_ITEN',
          camposSelect: ['FAIXA_ITEN.TAMANHO', 'FAIXA_ITEN.POSICAO', 'PRECO_COR_TAM.PRECO'],
          leftJoin: [{ tabela: "PRECO_COR_TAM", condicao: `PRECO_COR_TAM.REGIAO = '${sTabPreco}' AND PRECO_COR_TAM.CODIGO = '${sCodigo}' AND PRECO_COR_TAM.COR = '${pegaChave('#txtCor')}' AND PRECO_COR_TAM.TAM = FAIXA_ITEN.TAMANHO` }],
          where: [`FAIXA_ITEN.FAIXA = '${sFaixa}'`],
          orderBy: ['FAIXA_ITEN.POSICAO'],
        }
      }

      const jsonStr = await retornaJsonPesquisaPadrao(JSON.stringify(pesquisaParam));

      const precoVenda = await montaPrecoVenda(true);

      jsonStr.map((item, index) => {
        $('#tabelaGrade').DataTable().row.add({
          TAMANHO: item.TAMANHO,
          QTDE: retornaInputValor('txtQtdeGrade txtCamposGrade', index, true),
          PRECO: item.PRECO > 0 && usaPrecoCorTam ? item.PRECO : precoVenda,
          PERC_ACRESC: retornaInputValor('txtPercAcresGrade txtCamposGrade', index),
          VAL_ACRESC: retornaInputValor('txtValAcresGrade txtCamposGrade', index),
          PERC_DESC: retornaInputValor('txtPercDescGrade txtCamposGrade', index),
          VAL_DESC: retornaInputValor('txtValDescGrade txtCamposGrade', index),
          PRECO_LIQ: '0.00',
          TOTAL: '0.00',
        }).draw(false);
      });

      if (itensAlteracao.length > 0) {
        $('#tabelaGrade').DataTable().data().toArray().forEach((item, index) => {
          const itemAlteracao = itensAlteracao.find(item2 => item2.TAM == item.TAMANHO);
          if (itemAlteracao) {
            $($('.txtQtdeGrade')[index]).val(itemAlteracao.QTDE)
            calculaTotaisGrade($($('.txtQtdeGrade')[index]).attr('data-campo').replace(' txtCamposGrade', ''), $($('.txtQtdeGrade')[index]).attr('data-index'));
          }
        })
      }
    } catch (error) {
      console.error(error)
      msgAlerta(error.message)
    } finally {
      $('.txtCamposGrade').on('blur', function () {
        calculaTotaisGrade($(this).attr('data-campo').replace(' txtCamposGrade', ''), $(this).attr('data-index'));
      });

      insereValor('#txtQtdeTotal', '0.00');
      insereValor('#txtValTotal', '0.00');

      aplicaMascara();

      $.LoadingOverlay('hide');
    }
  };

  async function preencheFaixa() {
    $.LoadingOverlay('show')
    try {
      const pesquisaParam = {
        tabela: 'PRODUTO',
        camposSelect: ['PRODUTO.FAIXA', 'FAIXA.DESCRICAO DESC_FAIXA'],
        leftJoin: [{ tabela: "FAIXA", condicao: `FAIXA.CODIGO = PRODUTO.FAIXA` }],
        where: [`PRODUTO.CODIGO = '${pegaChave('#txtCodigo')}'`],
      }

      const jsonStr = await retornaJsonPesquisaPadrao(JSON.stringify(pesquisaParam));

      if (jsonStr.length > 0) {
        insereValor('#txtFaixa', jsonStr[0].FAIXA, jsonStr[0].DESC_FAIXA);
      }
    } catch (error) {
      console.error(error)
      msgAlerta(error.message)
    } finally {
      $.LoadingOverlay('hide')
    }
  }

  $('#btnConfirmarInfos').on('click', async function () {
    $.LoadingOverlay('show')
    try {
      await preencheItens()
      await limpaValoresItens()
    } catch (error) {
      console.error(error)
      msgAlerta(error.message)
    } finally {
      $.LoadingOverlay('hide')
    }
  })

  async function preencheItens() {
    const tabelaItens = $('#tabelaItens').DataTable()
    let ordem = tabelaItens.data().toArray().length <= 0 ? 0 : tabelaItens.column(0).data().reduce(function (a, b) {
      return Math.max(a, b)
    })
    const codProt = $('#txtCodigo').val() != '' ? pegaChave('#txtCodigo') : await RetornaProximo('PROTOTIPO', 'PRODUTO', 'PROTOTIPO', 6)
    ordem = itensAlteracao.length > 0 ? parseInt(itensAlteracao[0].ORDEM) <= 0 ? ordem + 1 : itensAlteracao[0].ORDEM : ordem + 1
    const cor = $('#txtCor').val() == '' ? pegaChave('#txtCorGrade') : pegaChave('#txtCor')
    const descCor = $('#txtCor').val() == '' ? pegaDescricao('#txtCorGrade') : pegaDescricao('#txtCor')
    let qtdeTotal = 0;
    const codigo = codProt
    const prototipo = itensAlteracao.length > 0 ? itensAlteracao[0].PROTOTIPO == '' ? '' : itensAlteracao[0].PROTOTIPO : $('#txtCodigo').val() != '' ? '' : codProt
    const descricao = $('#txtCodigo').val() != '' ? pegaDescricao('#txtCodigo') : pegaDescricao('#txtLinha') + ' - ' + pegaDescricao('#txtGrupo') + ' - ' + pegaDescricao('#txtEtiqueta');
    const valorTotal = parseFloat($('#txtValTotal').val())
    for (let i = 0; i < $('#tabelaGrade').DataTable().data().toArray().length; i++) {
      qtdeTotal += parseInt($($('.txtQtdeGrade')[i]).val())
    }
    if (cor == '') {
      throw new Error('Cor da grade não informada')
    }
    if (qtdeTotal <= 0) {
      throw new Error('Quantidade da grade não preenchida, verifique.')
    }
    if (valorTotal <= 0) {
      throw new Error('Itens sem preço, verifique.')
    }

    const tabelaGrade = $('#tabelaGrade').DataTable().data().toArray()

    for (let i = 0; i < tabelaGrade.length; i++) {
      const grade = tabelaGrade[i]

      const obj = {
        ORDEM: ordem,
        CODIGO: codigo,
        DESCRICAO: descricao,
        COR: cor,
        DESCCOR: descCor,
        TAM: grade.TAMANHO,
        QTDE: parseInt($($('.txtQtdeGrade')[i]).val()),
        PRECO: parseFloat(grade.PRECO),
        VALOR: parseFloat(grade.TOTAL),
        CUSTOMIZACAO: parseFloat(0),
        OBS2: $('#txtObsProduto').val(),
        OBS3: $('#txtObsProducao').val(),
        OBSERVACAO: $('#txtObsEspecificacoes').val(),
        FAIXA: pegaChave('#txtFaixa'),
        PROTOTIPO: prototipo
      }

      if (itensAlteracao && itensAlteracao.length > 0) {
        const itemExistente = itensAlteracao.find(item =>
          item.ORDEM == obj.ORDEM &&
          item.CODIGO == obj.CODIGO &&
          item.COR == obj.COR &&
          item.TAM == obj.TAM
        );

        if (itemExistente) {
          tabelaItens.rows(function (idx, data, node) {
            return data.ORDEM == obj.ORDEM && data.CODIGO == obj.CODIGO && data.COR == obj.COR && data.TAM == obj.TAM;
          }).remove().draw(false);
        }
      }

      if (parseInt($($('.txtQtdeGrade')[i]).val()) <= 0) {
        continue
      }

      tabelaItens.row.add(obj).draw(false);
    }
    calculaTotais()
    $('#modalItem').modal('hide')
  }

  function calculaTotais() {
    let qtdeTotal = 0;
    let valorTotal = 0;
    for (let i = 0; i < $('#tabelaItens').DataTable().data().toArray().length; i++) {
      const item = $('#tabelaItens').DataTable().data().toArray()[i]
      qtdeTotal += parseInt(item.QTDE)
      valorTotal = parseFloat(valorTotal) + parseFloat(item.VALOR)
    }

    const novoValor = parseFloat(valorTotal) || 0
    const desc = $('#txtDesconto').val() || 0
    let novoValorLiq = 0
    if (desc > 0) {
      novoValorLiq = novoValor - (novoValor * (desc / 100))
    } else {
      novoValorLiq = novoValor
    }
    $('.txtTotalQtde').text(qtdeTotal)
    $('.txtValorTotal').html(parseFloat(novoValor.toFixed(2)).toLocaleString("pt-BR", { style: "decimal" }));
    $('.txtTotalLiquido').html(parseFloat(novoValorLiq.toFixed(2)).toLocaleString("pt-BR", { style: "decimal" }));
    $("#txtValorFinanceiro").html(parseFloat(novoValorLiq.toFixed(2)).toLocaleString("pt-BR", { style: "decimal" }))
  }

  $('#modalItem').on('hidden.bs.modal', function () {
    $('#tabelaItens').DataTable().columns.adjust().draw(false)
    itensAlteracao = []
    limpaValoresItens()
  })

  $('#tabelaItens').on('click', '#btn-excluir', async function () {
    await msgAguardaConfirmacao('Deseja excluir este registro?', async () => {
      $('#tabelaItens').DataTable().data().rows($('#tabelaItens').DataTable().row($($(this).get(0)).closest('tr')).index()).remove().draw(false);
      calculaTotais()
    })
  })

  $('#tabelaItens').on('click', '#btn-editar', async function () {
    $.LoadingOverlay('show')
    try {
      const data = $('#tabelaItens').DataTable().row($(this).parents('tr')).data()
      itensAlteracao = $('#tabelaItens').DataTable().data().toArray().filter(item => { return item.CODIGO == data.CODIGO && item.ORDEM == data.ORDEM })
      insereValor('#txtCodigo', data.CODIGO, data.DESCRICAO)
      insereValor('#txtCor', data.COR, data.DESCCOR)
      $('#txtQtde').val(1);
      $('#txtPreco').val(data.PRECO);

      $('#modalItem').modal('show')
      $('#txtCodigo').trigger('blur')
      $('#txtObsProduto').val(data.OBS2)
      $('#txtObsProducao').val(data.OBS3)
      $('#txtObsEspecificacoes').val(data.OBSERVACAO)

      if (data.FAIXA) {
        insereValor('#txtFaixa', data.FAIXA, { tabela: 'FAIXA', campoBusca: 'DESCRICAO', campoWhere: 'CODIGO', valorWhere: data.FAIXA })
      }
      $('#txtFaixa').prop('disabled', true)
      $('#btnFaixa').prop('disabled', true)
      $('#btnAFaixa').prop('disabled', true)

      $('#txtCodigo').prop('disabled', true)
      $('#btn-Codigo').prop('disabled', true)
      $('#btn-limpa-Codigo').prop('disabled', true)

      $('#txtCor').prop('disabled', true)
      $('#btn-Cor').prop('disabled', true)
      $('#btn-limpa-Cor').prop('disabled', true)

      $('#txtQtde').prop('disabled', true)
    } finally {
      $.LoadingOverlay('hide')
    }
  })

  $('#txtQtde').on('keydown', function (e) {
    if (e.key == ',' || e.key == '.') {
      e.preventDefault();
    }
  });

  $('#txtQtde').on('input', function () {
    this.value = this.value.replace(/[^\d-]/g, '');
    this.value = this.value.replace(/(\d+)[.,](\d+)/, '$1');
  });

  $('#btnVoltar').on('click', async function () {
    await deletaRegistro('ORCAMENTO', getCookie('usuario'), orcamento);
    window.location.href = `${BASE_URI}/orcamento`;
  })

  $('#btnBuscarComposicao').on('click', async function () {
    $.LoadingOverlay('show')
    $('#tabelaComposicao').DataTable().clear().draw();
    try {
      const caracteristicas = $('#tabelaCaracteristicas').DataTable().rows(function (idx, data, node) {
        return $(node).find('input.checkCaracteristica').is(':checked');
      }).data().map(item => item.CODIGO).toArray();
      const caracteristicasFormatadas = await formataListas(caracteristicas.toString())

      const response = await requisicao('GET', '/sisplan/orcamento/v1/buscacomposicaocarac?', `ID=${idCaracteristica}&CARACTERISTICAS=${caracteristicasFormatadas}`);

      if (!response) {
        return;
      }

      const jsonStr = await response.json();

      jsonStr.map(item => {
        $('#tabelaComposicao').DataTable().row.add({
          CODIGO: item.COD_MAT,
          DESCRICAO: item.DESC_MAT,
          COR: item.COR,
          DESC_COR: item.DESC_COR,
          FORNECEDOR: '',
          NOME_FORNECEDOR: '',
          COD_OPCIONAL: item.COD_OPCIONAL,
          DESC_OPCIONAL: item.DESC_OPCIONAL,
          ACOES: retornaBotaoExcluir(),
        }).draw(false);
      });
    } catch (error) {
      console.error(error)
      msgAlerta(error.message)
    } finally {
      $.LoadingOverlay('hide')
    }
  })

  $('#txtMarkup').off('blur')
  $('#txtMarkup').on('blur', async function () {
    if ($(this).val() == '') {
      return
    }
    $.LoadingOverlay('show')
    try {
      const precoVenda = await montaPrecoVenda();

      if ($('#tabelaGrade').DataTable().data().toArray().length > 0) {
        $('#tabelaGrade').DataTable().rows().every(function () {
          const data = this.data();
          data.PRECO = precoVenda;
          this.data(data).draw(false);
        });
      }

    } catch (error) {
      console.error(error)
      msgAlerta(error.message)
    } finally {
      $('.txtCamposGrade').on('blur', function () {
        calculaTotaisGrade($(this).attr('data-campo').replace(' txtCamposGrade', ''), $(this).attr('data-index'));
      });
      $.LoadingOverlay('hide')
    }
  })

  $('#tabelaCaracteristicas').on('click', '.checkCaracteristica', async function () {
    $.LoadingOverlay('show')
    try {
      let data = $('#tabelaCaracteristicas').DataTable().row($(this).parents('tr')).data()
      if ($(this).is(':checked')) {
        await carregaConsumosCaracteristicas(data.COD_APL, data.CODIGO)
        await validaCaracteristicaUnica(data.COD_APL, $('#tabelaCaracteristicas').DataTable().row($(this).parents('tr')).index())
      } else {
        const consumos = $('#tabelaConsumos').DataTable().data().toArray().filter(f => { return f.COD_OPCIONAL != data.CODIGO })
        $('#tabelaConsumos').DataTable().clear();
        consumos.forEach(item => {
          $('#tabelaConsumos').DataTable().row.add(item);
        })

        $('#tabelaConsumos').DataTable().draw(false);
      }
    } finally {
      $.LoadingOverlay('hide')
    }
  })

  async function carregaConsumosCaracteristicas(codApl, codigo) {
    $.LoadingOverlay('show');
    try {
      const response = await requisicao('GET', '/sisplan/orcamento/v1/buscaconsumoscarac?', `ID=${idCaracteristica}&CODAPL=${codApl}&CODIGO=${codigo}`);

      if (!response) {
        return;
      }

      const jsonStr = await response.json();

      jsonStr.map(item => {
        $('#tabelaConsumos').DataTable().row.add({
          CODIGO: item.COD_MAT,
          DESCRICAO: item.DESC_MAT,
          QTDE: item.QTDE,
          CUSTO: item.CUSTO,
          VALOR: item.VALOR,
          SETOR: item.SETOR,
          DESC_SETOR: item.DESC_SETOR,
          COR: item.COR,
          DESC_COR: item.DESC_COR,
          COD_OPCIONAL: codigo,
        }).draw(false);
      });

    } finally {
      $.LoadingOverlay('hide');
    }
  };

  async function validaCaracteristicaUnica(codApl, indexSel) {
    $.LoadingOverlay('show')
    try {
      const pesquisaParam = {
        tabela: 'PCPAPL',
        camposSelect: ['CARACT_UNICA'],
        where: [`CODIGO = '${codApl}'`]
      }

      const jsonStr = await retornaJsonPesquisaPadrao(JSON.stringify(pesquisaParam));

      if (jsonStr.length > 0 && jsonStr[0].CARACT_UNICA == 'S') {
        const caracteristicas = $('#tabelaCaracteristicas').DataTable().data().toArray()
        const linhas = $('#tabelaCaracteristicas').DataTable().rows().nodes()
        for (let i = 0; i < caracteristicas.length; i++) {
          const item = caracteristicas[i]

          if (item.COD_APL != codApl) {
            continue
          }

          const row = $(linhas[i]);
          const checkBox = row.find('.checkCaracteristica');

          if (checkBox.length > 0) {
            if (i == indexSel) {
              if (!checkBox.is(':checked')) {
                checkBox.trigger('click');
              }
            } else {
              if (checkBox.is(':checked')) {
                checkBox.trigger('click');
              }
            }
          }

        }
      } else {
        return
      }
    } catch (error) {
      console.error(error)
      msgAlerta(error.message)
    } finally {
      $.LoadingOverlay('hide')
    }
  }

  function limpaDadosFinan() {
    $('.dadosFinan').val('')
    $('.dadosFinanHeader').val('')
  }

  $('#txtCondicao').on('blur', async function () {
    if ($(this).val() == '') {
      $('.dadosFinan').prop('disabled', true)
      limpaDadosFinan()
      return
    }
    $.LoadingOverlay('show')
    try {
      $('.dadosFinan').prop('disabled', false)

      const pesquisaParam = {
        tabela: 'CONDICAO',
        camposSelect: ['CONDICAO.ENTRADA', 'CONDICAO.PRZ_MEDIO', 'CONDICAO.NRPAR', 'CONDICAO.PRAZOINI', 'CONDICAO.NRDIA', 'COND_PERC.DESCONTO DESCMAX'],
        leftJoin: [{ tabela: 'COND_PERC', condicao: 'COND_PERC.CODIGO = CONDICAO.COND_PERC' }],
        where: [`CONDICAO.CODCOND = '${pegaChave('#txtCondicao')}'`]
      }

      const jsonStr = await retornaJsonPesquisaPadrao(JSON.stringify(pesquisaParam));

      if (jsonStr.length > 0) {
        $('#txtPercEntrada').val(jsonStr[0].ENTRADA)
        $('#txtPrzMedio').val(jsonStr[0].PRZ_MEDIO)
        $('#txtMaxParcelas').val(jsonStr[0].NRPAR)
        $('#txtPrzMaxPrimeira').val(jsonStr[0].PRAZOINI)
        $('#txtIntervaloParcelas').val(jsonStr[0].NRDIA)

        $('#txtNParcelas').val(jsonStr[0].NRPAR)
        $('#txtPrazoPrimeiraParc').val(jsonStr[0].PRAZOINI)
        $('#txtIntervaloParc').val(jsonStr[0].NRDIA)
        calculaPrazoMedio()
      } else {
        return
      }

      if (jsonStr.length > 0 && jsonStr[0].DESCMAX != '') {
        $('#txtDesconto1').val(jsonStr[0].DESCMAX)
        $('#txtDesconto1').trigger('blur')
      }

    } catch (error) {
      console.error(error)
      msgAlerta(error.message)
    } finally {
      $.LoadingOverlay('hide')
    }
  })

  $("#txtDesconto1, #txtDesconto2, #txtDesconto3, #txtDesconto4, #txtDesconto5").change(async function () {
    const desc = descontoUnificado('0' + $('#txtDesconto1').val() + '+0' + $('#txtDesconto2').val() + '+0' + $('#txtDesconto3').val() + '+0' + $('#txtDesconto4').val() + '+0' + $('#txtDesconto5').val())
    $('#txtDesconto').val(desc)
    $('#txtDesconto').trigger('change')
  });

  $('#txtDesconto').on('change', function () {
    const valorTot = parseFloat($('#txtValorTotalItens').text().replace('.', '').replace(',', '.'))
    const desc = parseFloat($(this).val())
    const valFinal = roundTo(valorTot - (valorTot * (desc / 100)), 2)

    $("#txtValorFinanceiro").html(parseFloat(valFinal).toLocaleString("pt-BR", { style: "decimal" }));
    $(".txtTotalLiquido").html(parseFloat(valFinal).toLocaleString("pt-BR", { style: "decimal" }));
  })

  function descontoUnificado(descontos) {
    let descUni = 100;
    let descRestante = descontos + '+';

    while (descRestante.indexOf('+') > 0 && descRestante.length > 1) {
      let desc = parseFloat($.trim(descRestante.substring(0, descRestante.indexOf('+'))));
      descUni = descUni - ((descUni / 100) * desc);
      descRestante = descRestante.substring(descRestante.indexOf('+') + 1);
    }

    return parseFloat((100 - descUni).toFixed(2));
  }

  function calculaPrazoMedio() {
    let dias = 0;
    let totGeral = 0
    let ultimo
    const parcelas = parseInt($('#txtNParcelas').val())

    for (let i = 0; i < parcelas; i++) {
      if (i == 0) {
        dias = parseInt($('#txtPrazoPrimeiraParc').val())
        ultimo = dias
        totGeral = ultimo
      } else {
        dias = dias + parseInt($('#txtIntervaloParc').val())
        ultimo = dias
        totGeral = totGeral + ultimo
      }
    }

    if (totGeral > 0 && parcelas > 0) {
      return $('#txtPrazoMedioCalc').val(Math.ceil(totGeral / parcelas))
    } else {
      return $('#txtPrazoMedioCalc').val(0)
    }
  }

  $('#txtNParcelas').on('blur', function () {
    if (parseInt($(this).val()) > parseInt($('#txtMaxParcelas').val())) {
      msgAlerta('Número de parcelas não pode ser maior que o máximo definido na condição de pagamento.', () => {
        $('#txtNParcelas').focus()
      }, null, null, null, false, true)
      $('#txtNParcelas').val(0)
    }

    calculaPrazoMedio()
  })

  $('#txtPrazoPrimeiraParc').on('blur', function () {
    if (parseInt($(this).val()) > parseInt($('#txtPrzMaxPrimeira').val())) {
      msgAlerta('Prazo da primeira parcela não pode ser maior que o máximo definido na condição de pagamento.', () => {
        $('#txtPrazoPrimeiraParc').focus()
      }, null, null, null, false, true)
      $('#txtPrazoPrimeiraParc').val(0)
    }

    calculaPrazoMedio()
  })

  $('#txtValorEntrada').on('blur', function () {
    const valorTot = $('#txtValorFinanceiro').text().replace('.', '').replace(',', '.');
    if ((parseFloat($('#txtPercEntrada').val()) > 0) && ((parseFloat($('#txtValorEntrada').val()) <= 0) || (parseFloat(valorTot) <= 0))) {
      msgAlerta('Valor de entrada ou valor total do orçamento zerado, impossível continuar.', () => {
        $('#txtValorEntrada').focus()
      }, null, null, null, false, true)
      $('#txtValorEntrada').val(0)
      return
    }

    if (parseFloat($('#txtValorEntrada').val()) > parseFloat(valorTot)) {
      msgAlerta('Valor de entrada maior que o valor total do orçamento, impossível continuar.', () => {
        $('#txtValorEntrada').focus()
      }, null, null, null, false, true)
      $('#txtValorEntrada').val(0)
      return
    }

    if (parseFloat($('#txtValorEntrada').val()) > 0) {
      const perc = roundTo((parseFloat($('#txtValorEntrada').val()) / parseFloat(valorTot)) * 100, 2)
      if (parseFloat(perc.toFixed(2)) < parseFloat(parseFloat($('#txtPercEntrada').val()).toFixed(2))) {
        $('#txtValorEntrada').val(0)
        msgAlerta('Valor de entrada não pode ser menor que o definido na condição de pagamento.', () => {
          $('#txtValorEntrada').focus()
        }, null, null, null, false, true)
        $('#txtValorEntrada').val(0)
        return
      }
    }

    calculaPrazoMedio()
  })

  $('#txtIntervaloParc').on('blur', function () {
    if (parseInt($(this).val()) > parseInt($('#txtIntervaloParcelas').val())) {
      msgAlerta('Intervalo entre as parcelas não pode ser maior que o máximo definido na condição de pagamento.', () => {
        $('#txtIntervaloParc').focus()
      }, null, null, null, false, true)
      $('#txtIntervaloParc').val(0)
    }

    calculaPrazoMedio()
  })

  function validacoesGerarParcelas() {
    const valorTot = $('#txtValorFinanceiro').text().replace('.', '').replace(',', '.');
    if (parseInt($('#txtPrazoMedioCalc').val()) > parseInt($('#txtPrzMedio').val())) {
      throw new Error('Prazo médio calculado não pode ser maior que o máximo definido na condição de pagamento.')
    }

    if ((parseFloat($('#txtPercEntrada').val()) > 0) && ((parseFloat($('#txtValorEntrada').val()) <= 0) || (parseFloat(valorTot) <= 0))) {
      throw new Error('Valor de entrada ou valor total do orçamento zerado, impossível continuar.')
    }

    if (parseFloat($('#txtValorEntrada').val()) > 0) {
      const perc = roundTo((parseFloat($('#txtValorEntrada').val()) / parseFloat(valorTot)) * 100, 2)
      if (parseFloat(perc.toFixed(2)) < parseFloat(parseFloat($('#txtPercEntrada').val()).toFixed(2))) {
        $('#txtValorEntrada').val(0)
        throw new Error('Valor de entrada não pode ser menor que o definido na condição de pagamento.')
      }
    }

    if (parseFloat($('#txtValorEntrada').val()) == 0 && parseFloat($('#txtMaxParcelas').val()) == 0) {
      throw new Error('O Número máximo de parcelas não pode ser 0. Favor Verificar!')
    }
  }

  $('#btnGerarParcelas').on('click', async function () {
    $.LoadingOverlay('show')
    try {
      validacoesGerarParcelas()
      await gerarParcelas()
    } catch (error) {
      console.error(error)
      msgAlerta(error.message)
    } finally {
      $.LoadingOverlay('hide')
    }
  })

  async function gerarParcelas() {
    $.LoadingOverlay('show')
    try {
      await simulaFinanceiro()
    } catch (error) {
      console.error(error)
      msgAlerta(error.message)
    } finally {
      $.LoadingOverlay('hide')
    }
  }

  async function simulaFinanceiro() {
    const numParcelas = parseInt($('#txtNParcelas').val()) || 0;
    const primeiraParcela = parseInt($('#txtPrazoPrimeiraParc').val()) || 0;
    const intervalo = parseInt($('#txtIntervaloParc').val()) || 0;
    const entrada = parseFloat($('#txtValorEntrada').val()) || 0;
    const valorTot = parseFloat($('#txtValorFinanceiro').text().replace('.', '').replace(',', '.')) || 0;

    const inicial = entrada > 0 ? 0 : 1;
    let dias = entrada > 0 ? 0 : primeiraParcela;
    let vParcelas = 0;

    $("#tabelaDuplicatas").DataTable().rows().remove().draw(false);

    for (let i = inicial; i <= numParcelas; i++) {
      let valorParcela;

      if (i == 0) {
        valorParcela = entrada;
      } else if (i == numParcelas) {
        valorParcela = ((valorTot - entrada) - vParcelas).toFixed(2);
        vParcelas += parseFloat(valorParcela);
      } else {
        valorParcela = ((valorTot - entrada) / numParcelas).toFixed(2);
        vParcelas += parseFloat(valorParcela);
      }


      $("#tabelaDuplicatas").DataTable().row.add({
        PARCELA: i,
        VENCIMENTO: formatDateDup(new Date(Date.now() + dias * 24 * 60 * 60 * 1000)),
        VALOR: parseFloat(valorParcela).toFixed(2)
      }).draw(false);

      dias += intervalo;
    }
  }

  function formatDateDup(date) {
    const day = date.getDate().toString().padStart(2, '0');
    const month = (date.getMonth() + 1).toString().padStart(2, '0');
    const year = date.getFullYear();
    return `${year}-${month}-${day}`;
  }

  function campoDesconto(desc1, desc2, desc3, desc4, desc5) {
    let sDescontos = '';

    function formatDesconto(valor) {
      if (valor > 0) {
        return valor.toFixed(2).padStart(5, ' ');
      } else {
        return ''
      }
    }

    sDescontos += formatDesconto(desc1);
    sDescontos += formatDesconto(desc2);
    sDescontos += formatDesconto(desc3);
    sDescontos += formatDesconto(desc4);
    sDescontos += formatDesconto(desc5);

    return sDescontos;
  }

});
