$("#tutorial").on("click", function () {
  $(document).ready(async function () {
    const driver = new Driver({
      doneBtnText: "Sair",
      closeBtnText: "Fechar",
      nextBtnText: "Próximo",
      prevBtnText: "Anterior",
      allowClose: false,
    });
    driver.defineSteps([]);
    driver.start();
  });
});

$(document).ready(async function () {
  const permissaoUsuarioLogado = await permissaoAcessos("ORCAMENTO");
  let consultando = true

  let colunas = JSON.parse(localStorage.getItem('colunasInvisiveisRelatorios'))

  if (colunas == null || colunas.orcamento == undefined) {
    localStorage.setItem('colunasInvisiveisRelatorios', JSON.stringify({ ...colunas, orcamento: [] }))
    colunas = JSON.parse(localStorage.getItem('colunasInvisiveisRelatorios'))
  }

  $('#btnConfirmarColunas').on('click', async function () {
    try {
      $.LoadingOverlay('show');

      const novasColunas = retornaNovasColunasInvisiveis();
      localStorage.setItem('colunasInvisiveisRelatorios', JSON.stringify({ ...colunas, orcamento: novasColunas }))
      $('#tabelaOrcamento').DataTable().columns().visible(true);
      $('#tabelaOrcamento').DataTable().columns().every(
        function () {
          if ((novasColunas).indexOf(this.dataSrc()) != -1) {
            this.visible(false);
          }
        })

      $('#modal-ColunasVisiveis').modal('hide');
    } catch (error) {
      console.error(error)
      msgAlerta(error.message)
    } finally {
      $.LoadingOverlay('hide');
    }
  })

  $('#modal-ColunasVisiveis').on('show.bs.modal', function () {
    const cols = [];
    let colunasInvisiveis = JSON.parse(localStorage.getItem('colunasInvisiveisRelatorios'))

    $('#tabelaOrcamento').DataTable().columns().every(function () {
      cols.push({
        'title': $(this.header()).text(),
        'data': this.dataSrc()
      })
    });
    adicionaColunas(cols, colunasInvisiveis.orcamento ?? [], ['NUMERO'])

  })

  await adicionaPesquisaFiltros()
  await buscaDadosOs()
  $("#btnFiltros").on("click", async function () {
    $("#modal-filtros").modal("show");
  });

  $("#btnIncluir").on("click", async function () {
    if (permissaoUsuarioLogado.INCLUI == "S") {
      window.location.href = "orcamento/create";
    } else {
      msgAlertaSemConfirmacao("Sem permissão para incluir!");
    }
  });

  $('#btnConsultar').on('click', async function () {
    await buscaDadosOs()
    $("#modal-filtros").modal("hide");
  })

  $('#btnSelecionarEmpresas').on('click', function () {
    carregaEmpresasDisponiveis();
  });

  async function retornaFiltros() {
    const representanteUsuario = await retornaRepUsuario()
    const situacao = $('#rgAberto').is(':checked') ? 1 : $('#rgFechado').is(':checked') ? 2 : $('#rgEmAprovacao').is(':checked') ? 3 : $('#rgPerdido').is(':checked') ? 4 : 0
    const situacaoItem = $('#rgItensAprovado').is(':checked') ? 1 : $('#rgItensReprovado').is(':checked') ? 2 : $('#rgItensBloquetado').is(':checked') ? 3 : 0
    const empresas = $('.empresa_selecionada:checked').toArray().length > 0 ? $('.empresa_selecionada:checked').toArray().map(input => input.id.substring(input.id.indexOf('-') + 1, input.id.length))
      : [getCookie('emp_id')]
    const filtros = `DTCADASTRODE=${$('#txtDtCadastroI').val()}` +
      `&DTCADASTROATE=${$('#txtDtCadastroF').val()}` +
      `&DTSAIDADE=${$('#txtDtSaidaI').val()}` +
      `&DTSAIDAATE=${$('#txtDtSaidaF').val()}` +
      `&DTENTREGADE=${$('#txtDtEntregaI').val()}` +
      `&DTENTREGAATE=${$('#txtDtEntregaF').val()}` +
      `&DTDIGITACAODE=${$('#txtDtDigitacaoI').val()}` +
      `&DTDIGITACAOATE=${$('#txtDtDigitacaoF').val()}` +
      `&SITUACAO=${situacao}` +
      `&SITUACAOITEM=${situacaoItem}` +
      `&NUMEROS=${await formataListas($('#txtNumero').val().toString())}` +
      `&CLIENTE=${await formataListas($('#txtCliente').val().toString())}` +
      `&PRODUTO=${await formataListas($('#txtProduto').val().toString())}` +
      `&GRUPO=${await formataListas($('#txtGrupoPA').val().toString())}` +
      `&ETIQUETA=${await formataListas($('#txtEtiqueta').val().toString())}` +
      `&LINHA=${await formataListas($('#txtLinha').val().toString())}` +
      `&EMPRESAS=${await formataListas(empresas.toString())}` +
      `&REPRESENTANTE=${await formataListas($('#txtRepresentante').val().toString())}` +
      `&REPUSUARIO=${representanteUsuario}`;

    return filtros
  }

  async function buscaDadosOs() {
    $.LoadingOverlay('show')
    consultando = true
    try {
      const url = "/sisplan/orcamento/v1/buscadadosacesso?"
      const filtros = await retornaFiltros()
      const response = await requisicao('GET', url, filtros, null, 180000);

      if (!response) {
        return;
      }

      const jsonStr = await response.json();

      if (response.status != 200) {
        throw msgAlerta(jsonStr.mensagem);
      }

      if (jsonStr.length <= 0) {
        throw msgAlerta('Nenhum registro encontrado!');
      }

      await montaDataTableAcesso(jsonStr)

    } catch (error) {
      $('#modal-filtros').modal('hide')
    } finally {
      $.LoadingOverlay('hide')
      consultando = false
    }
  }

  async function retornaRepUsuario() {
    const filtraClientesRepresentante = await CopiaParametro('SISTEMA', 2) == 1;

    if (!filtraClientesRepresentante) {
      return '';
    }


    const usuarioMasterSupervisor = await uMasterOuSupervisor()

    if (usuarioMasterSupervisor) {
      return ''
    }

    const repUsuario = retornaRepresentanteUsuario()

    return `'${repUsuario}'`
  }

  function retornaBotaoOpcoes(data) {
    var retorno = '<div> ' +
      '    <button class="btn btn-info btn-sm dropdown-toggle btnVerificaOpcoes" type="button" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false"> ' +
      '      ' + data + ' ' +
      '    </button> ' +
      '    <div class="dropdown-menu"> ' +
      '    <button class="dropdown-item" title="Editar" id="btn-editar">Editar</button>     ' +
      '    <button class="dropdown-item" title="Excluir" id="btnExcluir">Excluir</button>     ' +
      '    <button class="dropdown-item" title="Duplicar" id="btnDuplicar">Duplicar</button>     ' +
      `    <button id="btn-imprimirIndividual" type="button" ${getCookie('cod_usuario') == '0000' ? 'title="Este botão chama o Layout RelOrcamentoIndividual.FR3"' : ''} class="dropdown-item">Imprimir</button>` +
      `    <button id="btnGerarPedido" type="button" class="dropdown-item">Gerar Pedido</button>` +
      '    <button class="dropdown-item" title="Anexos" id="btnAnexos">Gestão de Documentos</button>     ' +
      '</div>';
    return retorno;
  };

  async function montaDataTableAcesso(jsonStr) {
    if ($.fn.DataTable.isDataTable('#tabelaOrcamento')) {
      $('#tabelaOrcamento').DataTable().destroy();
      $('#tabelaOrcamento').empty();
    }
    let ordemColunasRelatorio = localStorage.getItem('ordemColunasDataTable')
    ordemColunasRelatorio = JSON.parse(ordemColunasRelatorio)

    const dataSetCols = [];
    let keys
    if (ordemColunasRelatorio != null && ordemColunasRelatorio.orcamento != undefined) {
      const ordenacao = 'GERAL'
      const colunas = ordemColunasRelatorio.orcamento.filter(f => f.ordenacao == ordenacao)
      keys = colunas.length > 0 ? colunas[0].colunas : Object.keys(jsonStr[0]);
    } else {
      keys = Object.keys(jsonStr[0]);
    }

    const colunasOriginais = Object.keys(jsonStr[0])

    keys.forEach((k) => {
      dataSetCols.push({
        title: k,
        data: k,
      });
    });;

    $('#tabelaOrcamento').DataTable({
      bPaginate: true,
      search: false,
      destroy: true,
      colReorder: true,
      order: [],
      info: true,
      language: {
        sEmptyTable: "Nenhum registro encontrado na tabela de pedidos",
        sInfo: "_TOTAL_ registros",
        sInfoEmpty: " 0 registros",
        sInfoFiltered: "(Filtrados de _MAX_ registros)",
        sInfoPostFix: "",
        sInfoThousands: ".",
        sLengthMenu: "_MENU_ resultados",
        sLoadingRecords: "Carregando...",
        sProcessing: "Processando...",
        sZeroRecords: "Nenhum registro encontrado na tabela de pedidos",
        sSearch: "Pesquisar",
        oPaginate: {
          sNext: "Próximo",
          sPrevious: "Anterior",
          sFirst: "Primeiro",
          sLast: "Último",
        },
        oAria: {
          sSortAscending: ": Ordenar colunas de forma ascendente",
          sSortDescending: ": Ordenar colunas de forma descendente",
        },
      },
      autoWidth: true,
      columns: dataSetCols,
      data: jsonStr,
      columnDefs: [
        {
          type: "date-br",
          render(data) {
            if (data) {
              return new Intl.DateTimeFormat("pt-BR").format(
                new Date(`${data.split(" ")[0]} 23:59:59`)
              );
            } else {
              return ''
            }
          },
          targets: [keys.indexOf(colunasOriginais[6]), keys.indexOf(colunasOriginais[7]), keys.indexOf(colunasOriginais[8]), keys.indexOf(colunasOriginais[9]), keys.indexOf(colunasOriginais[10])]
        },
        {
          render(data) {
            return parseFloat(data).toLocaleString("pt-br", {
              minimumFractionDigits: 2,
            });
          },
          targets: [keys.indexOf(colunasOriginais[19]), keys.indexOf(colunasOriginais[20]), keys.indexOf(colunasOriginais[21]), keys.indexOf(colunasOriginais[26]), keys.indexOf(colunasOriginais[27]), keys.indexOf(colunasOriginais[28])],
          "className": 'pr-4 text-right'
        },
        {
          targets: [0], render: function (data, type, row) {
            return retornaBotaoOpcoes(data);
          },
        },
        {
          targets: [keys.indexOf(colunasOriginais[11])],
          render(data) {
            if (data) {
              switch (data) {
                case 'A':
                  return 'Aberto'
                  break;
                case 'F':
                  return 'Fechado'
                  break;
                case 'E':
                  return 'Em Aprovação'
                  break;
                case 'P':
                  return 'Perdido'
                  break
                default:
                  return 'Outro'
                  break;
              }
            } else {
              return 'Outro'
            }
          }
        }
      ]
    });

    $('#tabelaOrcamento_length').prepend('<button class="buttonColVis" id="buttonColVis"><i class="fas fa-cogs"></i></button>');
    $('#tabelaOrcamento_length').prepend('<button class="buttonExcel" id="buttonExcel"><i class="fas fa-file-excel"></i></button>');

    $('#buttonColVis').prop('title', 'Configurar colunas visíveis')
    $('#buttonExcel').prop('title', 'Exportar')

    const colunasInvisiveis = JSON.parse(localStorage.getItem('colunasInvisiveisRelatorios'));

    $('#buttonColVis').on('click', async function () {
      $.LoadingOverlay('show')
      try {
        $('#modal-ColunasVisiveis').modal('show');
      } finally {
        $.LoadingOverlay('hide')
      }
    });

    $('#tabelaOrcamento').DataTable().columns().every(
      function () {
        if ((colunasInvisiveis.orcamento).indexOf(this.dataSrc()) != -1) {
          this.visible(false);
        }
      })

    $('#buttonExcel').off()
    $('#buttonExcel').on('click', async function () {
      const dados = $("#tabelaOrcamento").DataTable().data().toArray();
      await exportaCSV('', null, false, null, 'Relatório de Orçamento', '#tabelaOrcamento', '', 999, false, false, dados)
    })

    $('#tabelaOrcamento').on('column-reorder.dt', function (e, settings, details) {
      if (consultando) {
        return
      }
      let newColumnOrder = []

      for (let i = 0; i < settings.aoColumns.length; i++) {
        const column = settings.aoColumns[i].mData

        newColumnOrder.push(column)
      }

      newColumnOrder = newColumnOrder.filter(item => item != 'NUMERO')
      newColumnOrder.unshift('NUMERO')

      let ordemColunas = localStorage.getItem('ordemColunasDataTable')
      ordemColunas = JSON.parse(ordemColunas)
      const ordenacao = 'GERAL'

      if (ordemColunas == null || ordemColunas.orcamento == undefined) {
        localStorage.setItem('ordemColunasDataTable', JSON.stringify({ ...ordemColunas, orcamento: [{ ordenacao: ordenacao, colunas: newColumnOrder }] }));

      } else if (!ordemColunas.orcamento.some(s => s.ordenacao == ordenacao)) {

        const ordensSalvas = JSON.parse(localStorage.getItem('ordemColunasDataTable'));
        const newObj = { ordenacao: ordenacao, colunas: newColumnOrder }
        ordensSalvas.orcamento.push(newObj)
        localStorage.setItem('ordemColunasDataTable', JSON.stringify(ordensSalvas));

      } else if (ordemColunas.orcamento.some(s => s.ordenacao == ordenacao)) {

        const ordensSalvas = JSON.parse(localStorage.getItem('ordemColunasDataTable'));
        ordensSalvas.orcamento.filter(f => f.ordenacao == ordenacao)[0].colunas = newColumnOrder
        localStorage.setItem('ordemColunasDataTable', JSON.stringify(ordensSalvas));
      }
    });

  }

  async function validacaoModifica(numero, exclusao = false) {
    const pesquisa = {
      camposSelect: ["RECEBER.NUMERO REC, OS.SITUACAO"],
      tabela: "OS",
      leftjoin: [{ tabela: "RECEBER", condicao: "RECEBER.CARTAO_PRESENTE = OS.NUMERO" }],
      where: [`OS.NUMERO = '${numero}'`],
      limit: 1
    };

    const jsonStr = await retornaJsonPesquisaPadrao(encodeURIComponent(JSON.stringify(pesquisa)));


    if (exclusao && jsonStr[0].REC != '' && jsonStr[0].REC != null) {
      throw new Error(`Existe Antecipação gerada com número ${jsonStr[0].REC} Impossível continuar.`)
    }

    if (jsonStr[0].SITUACAO == 'F') {
      throw new Error(`Situação do orçamento já fechada, impossível continuar.`)
    }
  }

  $("#tabelaOrcamento").on('click', "#btnAnexos", async function () {
    const data = $('#tabelaOrcamento').DataTable().row($(this).parents('tr')).data();

    await abreModalAnexos(data.NUMERO, data.CODCLI + ' ' + data.NOME_CLI, 'ORCAMENTO');
  });

  $("#tabelaOrcamento").on('click', "#btnDuplicar", async function () {
    const data = $('#tabelaOrcamento').DataTable().row($(this).parents('tr')).data();
    $('#txtAntigoNumero').val(data.NUMERO)
    $('#modalDuplicar').modal('show')
  });

  $('#btnConfirmaDuplicar').on('click', async function () {
    if (!$('#txtNovoNumero').val()) {
      throw msgAlerta('Necessário informar um novo número para o orçamento');
    }
    if (await Existe('OS', ['NUMERO'], [$('#txtNovoNumero').val()])) {
      throw msgAlerta('Número de orçamento já existe, deve inserir um número diferente.')
    }
    try {
      $.LoadingOverlay('hide');

      let response = await requisicao("POST", "/sisplan/orcamento/v1/duplicar?", `NUMERO=${$('#txtAntigoNumero').val()}&NOVO_NUMERO=${$('#txtNovoNumero').val()}`, null, 50000);
      if (!response) {
        return;
      }
      if (response.status != 200) {
        let jsonStr = await response.json();
        msgAlerta(jsonStr.mensagem);
        return;
      }

      toastr.success("Orçamento duplicado com sucesso!", "Confirmação", {
        toastClass: "success",
        iconClasses: {
          error: "alert-error",
          info: "alert-info",
          success: "alert-success",
          warning: "alert-warning",
        },
        positionClass: "toast-top-center",
        progressBar: true,
        timeOut: 3000,
        fadeOut: 1000,
        onHidden() {
          window.location.href = `${BASE_URI}/orcamento`;
        },
      }).css({
        "margin-top": "20%",
        width: "500px",
        "max-width": "500px",
      });

    } catch (error) {
      console.log(error)
    } finally {
      $.LoadingOverlay('hide');
    }
  })

  $("#tabelaOrcamento").on("click", "#btn-editar", async function () {
    if (permissaoUsuarioLogado.ALTERA == 'S') {
      const data = $("#tabelaOrcamento")
        .DataTable()
        .row($(this).parents("tr"))
        .data();

      if (parseInt(data.EMP_ID) != parseInt(getCookie('emp_id'))) {
        msgAlertaSemConfirmacao('Este orçamento não pertence a esta empresa. Impossível alterar!')
        return
      }
      if (data.SITUACAO == 'F') {
        msgAlertaSemConfirmacao('Orçamento fechado. Impossível alterar!')
        return
      }
      const orcamentoLiberado = await verificarRegistro("ORCAMENTO", data.NUMERO);
      if (orcamentoLiberado) {
        window.location.href = `orcamento/${data.NUMERO}`;
      }
    } else {
      msgAlertaSemConfirmacao("Sem permissão para alterar!");
    }
  });

  $("#tabelaOrcamento").on("dblclick", "tr", async function () {
    if (permissaoUsuarioLogado.ALTERA == 'S') {
      const data = $("#tabelaOrcamento").DataTable().row($(this)).data();

      if (parseInt(data.EMP_ID) != parseInt(getCookie('emp_id'))) {
        msgAlertaSemConfirmacao('Este orçamento não pertence a esta empresa. Impossível alterar!')
        return
      }
      if (data.SITUACAO == 'F') {
        msgAlertaSemConfirmacao('Orçamento fechado. Impossível alterar!')
        return
      }
      const orcamentoLiberado = await verificarRegistro("ORCAMENTO", data.NUMERO);
      if (orcamentoLiberado) {
        window.location.href = `orcamento/${data.NUMERO}`;
      }
    } else {
      msgAlertaSemConfirmacao("Sem permissão para alterar!");
    }
  });

  $("#tabelaOrcamento").on("click", "#btnExcluir", async function () {
    $.LoadingOverlay("show");
    try {
      if (permissaoUsuarioLogado.EXCLUI == "S") {
        msgAlerta('Você realmente deseja excluir esse registro?', async () => {
          const data = $("#tabelaOrcamento").DataTable().row($(this).parents("tr"));
          await deletaOs(data);
        });
      } else {
        msgAlertaSemConfirmacao("Sem permissão para excluir!");
      }
    } finally {
      $.LoadingOverlay("hide");
    }
  })

  $("#tabelaOrcamento").on("click", "#btnGerarPedido", async function () {
    $.LoadingOverlay("show");
    try {
      const permissaoUsuarioLogadoPedido = await permissaoAcessos("PEDIDO");
      if (permissaoUsuarioLogadoPedido.INCLUI == "S") {
        msgAlerta('Deseja criar um Pedido a partir da Proposta Comercial?', async () => {
          const data = $("#tabelaOrcamento").DataTable().row($(this).parents("tr")).data();
          if (parseInt(data.EMP_ID) != parseInt(getCookie('emp_id'))) {
            msgAlertaSemConfirmacao('Este orçamento não pertence a esta empresa. Impossível gerar pedido!')
            return
          }
          await gerarPedido(data);
        });
      } else {
        msgAlertaSemConfirmacao("Sem permissão para incluir pedidos!");
      }
    } finally {
      $.LoadingOverlay("hide");
    }
  })


  async function deletaOs(data) {
    $.LoadingOverlay('show')
    try {
      let numero = data.data().NUMERO;

      await validacaoModifica(numero, true)

      let response = await requisicao("DELETE", "/sisplan/os/v1/ordemservico?", `NUMERO=${numero}`, null, 50000);
      if (!response) {
        return;
      }
      if (response.status != 200) {
        let jsonStr = await response.json();
        msgAlerta(jsonStr.mensagem);
        return;
      }

      toastr.success("Exclusão efetuada com sucesso!", "Confirmação", {
        toastClass: "success",
        iconClasses: {
          error: "alert-error",
          info: "alert-info",
          success: "alert-success",
          warning: "alert-warning",
        },
        positionClass: "toast-top-center",
        progressBar: true,
        timeOut: 3000,
        fadeOut: 1000,
        onHidden() {
          data.remove().draw(false);
        },
      }).css({
        "margin-top": "20%",
        width: "500px",
        "max-width": "500px",
      });
    } catch (error) {
      console.error(error)
      msgAlerta(error.message)
    } finally {
      $.LoadingOverlay('hide')
    }
  }

  $('#btnLimparFiltros').on('click', async function () {
    limparFiltros()
  })

  function limparFiltros() {
    $('#txtDtCadastroI').val('1200-01-01')
    $('#txtDtCadastroF').val('2500-12-01')
    $('#txtDtSaidaI').val('1200-01-01')
    $('#txtDtSaidaF').val('2500-12-01')
    $('#txtDtEntregaI').val('1200-01-01')
    $('#txtDtEntregaF').val('2500-12-01')
    $('#txtDtDigitacaoI').val('1200-01-01')
    $('#txtDtDigitacaoF').val('2500-12-01')
    $('#rgTodos').prop('checked', true)
    $('#rgItensTodos').prop('checked', true)
    $('#txtNumero').empty().trigger('change')
    $('#txtCliente').empty().trigger('change')
    $('#txtProduto').empty().trigger('change')
    $('#txtGrupoPA').empty().trigger('change')
    $('#txtEtiqueta').empty().trigger('change')
    $('#txtLinha').empty().trigger('change')
  }


  retornaHintRelatorio('btnImprimir', 'RelAcessoOrcamento')

  $('#btnImprimir').on('click', async function () {
    try {
      $.LoadingOverlay('show');
      try {
        const url = `/sisplan/orcamento/v1/imprimiracesso?`;
        const filtros = await retornaFiltros();
        const bImprimeAutomatico = await verificaImprimirAutomatico('RelAcessoOrcamento');
        const arquivo = await GeraRelatorio(`${url}${filtros}&`, 'GET', 100000, false, 'RelAcessoOrcamento');
        if (arquivo != undefined) {
          if (!bImprimeAutomatico) {
            window.open(`${BASE_URI}/relatorios_api/pdf/${arquivo}`, '_blank');
          }
          await limparRelatorios();
        }

      } catch (error) {
        console.error(error);
      }
    } finally {
      $.LoadingOverlay('hide');
    }
  });

  $("#tabelaOrcamento").on("click", "#btn-imprimirIndividual", async function () {
    $.LoadingOverlay('show');
    try {
      const data = $('#tabelaOrcamento').DataTable().row($(this).parents('tr')).data();
      const url = `/sisplan/impressao/v1/imprimeorcamentoindividual?`;

      const filtros = `NUMERO=${data.NUMERO}`;
      const bImprimeAutomatico = await verificaImprimirAutomatico('RelOrcamentoIndividual');
      let arquivo = await GeraRelatorio(`${url}${filtros}`, 'GET', 150000, false, 'RelOrcamentoIndividual');
      if (arquivo != undefined) {
        if (!bImprimeAutomatico) {
          window.open(`${BASE_URI}/relatorios_api/pdf/${arquivo}`, '_blank');
        }
        await limparRelatorios();
      }

    } catch (error) {
      console.error(error);
    } finally {
      $.LoadingOverlay('hide');
    }
  })

  async function retornaItens(numOs) {
    $.LoadingOverlay('show')
    try {
      const pesquisaParam = {
        tabela: "OS_ITEN",
        camposSelect: [
          "CODIGO", "PROTOTIPO", "COR", "TAM", "QTDE", "PRECO", "ORDEM_DIG", "OBS2", "TIPO_PROD"
        ],
        where: [`NUMERO = '${numOs}'`]
      };

      const jsonStrItens = await retornaJsonPesquisaPadrao(encodeURIComponent(JSON.stringify(pesquisaParam)));

      let arrItens = [];
      for(let i = 0; i < jsonStrItens.length; i++){
        const item = jsonStrItens[i]
        let prototipo = await buscaValor('PRODUTO', 'CODIGO', 'PROTOTIPO', item.PROTOTIPO);
        let codigo = item.CODIGO
        if (prototipo != undefined && item.CODIGO == '' && prototipo.CODIGO == ''){
          const responseCodProduto = await requisicao('PUT', '/sisplan/orcamento/v1/geracodigoproduto?', `PROTOTIPO=${item.PROTOTIPO}`, 90000);
  
          if (!responseCodProduto) {
            $.LoadingOverlay('hide');
            return;
          }
  
          const jsonStrCodProd = await responseCodProduto.text();
          if (responseCodProduto.status != 200) {
            $.LoadingOverlay('hide');
            msgErro(jsonStrCodProd.mensagem);
            return;
          }

          prototipo = await buscaValor('PRODUTO', 'CODIGO', 'PROTOTIPO', item.PROTOTIPO);
        }
  
        if ((item.TIPO_PROD == 'N' || item.TIPO_PROD == 'P' ) || (!await Existe('PRODUTO', ['CODIGO'], [item.CODIGO]))) {
          codigo = prototipo.CODIGO
        }
  
        arrItens.push({
          CODIGO: codigo != '' ? codigo : prototipo.CODIGO,
          COR: item.COR,
          TAM: item.TAM,
          QTDE: item.QTDE,
          QTDE_ORIG: item.QTDE,
          PRECO: item.PRECO,
          PRECO_ORIG: item.PRECO,
          TIPO: 'P',
          QUALIDADE: '1',
          ORDEM: item.ORDEM_DIG,
          OBSERVACAO: item.OBS2
        })
      }

      return arrItens;

    } catch (error) {
      console.error(error)
      msgAlerta(error.message)
    } finally {
      $.LoadingOverlay('hide')
    }
  };

  async function retornaRecSimula(numeroPed, numOs) {
    $.LoadingOverlay('show')
    try {
      let sCondicoes = '';
      const pesquisaParam = {
        tabela: "OS_SIMULA",
        camposSelect: [
          "VENCTO", "VALOR_PARCELA", "VALOR_TOTAL", "NUM_PARCELA", "DT_FATURA", "MOEDA"
        ],
        where: [`NUMERO = '${numOs}'`]
      };

      const jsonStrRec = await retornaJsonPesquisaPadrao(encodeURIComponent(JSON.stringify(pesquisaParam)));

      let arrRec_Simula = [];
      let arrCondicoes = [];
      let i = 1;
      jsonStrRec.map((item, index) => {
        const dtFatura = new Date(item.DT_FATURA);
        const vencto = new Date(item.VENCTO);
        const diffTime = Math.abs(dtFatura - vencto);
        const diffDays = Math.ceil(diffTime / (1000 * 60 * 60 * 24));

        let diffStr = diffDays.toString()

        arrCondicoes.push({
          DIAS: diffStr,
          DT_VENCTO: item.VENCTO,
          MOEDA: item.MOEDA,
          VALOR: item.VALOR_PARCELA,
          TIPO: 'P',
          NUMERO: numeroPed,
          ORDEM: i++
        })
        
        while (diffStr.length < 3) {
          diffStr = diffStr + ' ';
        }

        sCondicoes += diffStr;

        arrRec_Simula.push({
          PEDIDO: numeroPed,
          VENCTO: item.VENCTO,
          VALOR_PARCELA: item.VALOR_PARCELA,
          VALOR_TOTAL: item.VALOR_TOTAL,
          NUM_PARCELA: item.NUM_PARCELA,
          DT_FATURA: item.DT_FATURA
        })
      });

      return { arrRecSimula: arrRec_Simula, pgto: sCondicoes.trim(), condicoes: arrCondicoes };

    } catch (error) {
      console.error(error)
      msgAlerta(error.message)
    } finally {
      $.LoadingOverlay('hide')
    }
  };

  async function gerarPedido(data) {
    $.LoadingOverlay('show')
    try {
      if (await Existe('PEDIDO', ['ORCAMENTO'], [data.NUMERO])) {
        throw new Error('Orçamento já virou pedido, impossível continuar.');
      }

      const parametrosComercial = await BuscaParametrosPedido();

      const sNumero = await RetornaProximo('NUMERO', 'PEDIDO', 'NUMERO', 5)

      const pesquisaParam = {
        tabela: "OS",
        camposSelect: [
          "CLIENTE", "CODREP", "CIF", "COM1", "COM2", "DT_ENTREGA", "DEPOSITO",
          "TAB_TRANS", "EMP_FAT", "DT_SAIDA", "PED_CLI", "MOEDA", "SIT_DUP",
          "CLASSE_GER", "HISTORICO", "STATUS", "FRETE", "NATUREZA", "PESO_BRUTO",
          "PESO_LIQ", "VOLUMES", "PER_DESC", "PRZ_MEDIO", "OBS", "BLOQ_COM", "TAB_PRE"
        ],
        where: [`NUMERO = '${data.NUMERO}'`]
      };

      const jsonStrPed = await retornaJsonPesquisaPadrao(encodeURIComponent(JSON.stringify(pesquisaParam)));
      
      let tabPre = jsonStrPed[0].TAB_PRE

      if (!tabPre) {
        tabPre = '999'
      }

      const recSimula = await retornaRecSimula(sNumero, data.NUMERO)
      const arrRecSimula = recSimula.arrRecSimula
      const pgto = recSimula.pgto
      const condPgto = recSimula.condicoes

      const arrItens = await retornaItens(data.NUMERO)

      const dadosOs = jsonStrPed[0]
      const pedido = {
        NUMERO: sNumero,
        PED_CLI: dadosOs.PED_CLI,
        CODCLI: dadosOs.CLIENTE,
        CODREP: dadosOs.CODREP,
        CIF: dadosOs.CIF,
        COM1: dadosOs.COM1,
        COM2: dadosOs.COM2,
        DTDIGITA: retornaDataAtual(),
        DT_EMISSAO: retornaDataAtual(),
        TAB_TRANS: dadosOs.TAB_TRANS,
        FATURA: 100,
        EMP_FAT: dadosOs.EMP_FAT,
        DT_SAIDA: dadosOs.DT_SAIDA,
        DT_FATURA: dadosOs.DT_SAIDA,
        ENTREGA: dadosOs.DT_ENTREGA,
        IND_QTDE: 100,
        TAB_PRE2: '00',
        BLOQUEIO: dadosOs.BLOQ_COM,
        FINANCEIRO: parametrosComercial[2].VALOR,
        PERIODO: '0',
        MOEDA: dadosOs.MOEDA,
        SIT_DUP: dadosOs.SIT_DUP,
        CLASSE_GER: dadosOs.CLASSE_GER,
        HISTORICO: dadosOs.HISTORICO,
        STATUS: dadosOs.STATUS,
        STATUS_PED: dadosOs.STATUS,
        ID_TIPO: 0,
        FRETE: dadosOs.FRETE,
        NATUREZA: dadosOs.NATUREZA,
        PESO_BRUTO: dadosOs.PESO_BRUTO,
        PESO_LIQ: dadosOs.PESO_LIQ,
        VOLUMES: dadosOs.VOLUMES,
        PGTO: pgto,
        PER_DESC: dadosOs.PER_DESC,
        ORCAMENTO: data.NUMERO,
        BONIFICACAO: 'N',
        PRZ_MEDIO: dadosOs.PRZ_MEDIO,
        OBS: dadosOs.OBS,
        REC_SIMULA: arrRecSimula,
        EMP_ID: getCookie('emp_id'),
        DEPOSITO: dadosOs.DEPOSITO,
        TAB_PRE: tabPre,
        COND_PAGTOS: condPgto,
        ITENS: arrItens
      };

      const response = await requisicao('POST', '/sisplan/pedido/v1/pedido?', `&BARRAS_LOG=${encodeURIComponent(JSON.stringify({ BARRAS: [] }))}`, encodeURIComponent(JSON.stringify(pedido)), 90000);

      if (!response) {
        $.LoadingOverlay('hide');
        return;
      }

      const jsonStr = await response.json();
      if (response.status != 200) {
        $.LoadingOverlay('hide');
        msgErro(jsonStr.mensagem);
        return;
      }

      $.LoadingOverlay('hide');
      msgAlerta('Deseja imprimir o pedido?',
        async () => { await imprimirPedido(sNumero); callBack(); },
        () => { callBack(); },
        () => { },
        () => { callBack(); });

      function callBack() {
        criaMensagemSucesso(`Pedido ${sNumero} gravado com sucesso!`, async () => { await alteraStatusOs(data.NUMERO, sNumero) });
      }
    } catch (error) {
      console.error(error)
      msgAlerta(error.message)
    } finally {
      $.LoadingOverlay('hide')
    }
  }

  async function alteraStatusOs(numOs, numPed) {
    $.LoadingOverlay('show')
    try {
      const response = await requisicao('POST', '/sisplan/orcamento/v1/alterastatusorcamento?', `&NUMERO=${numOs}&PEDIDO=${numPed}`, null, 36000);

      if (!response) {
        $.LoadingOverlay('hide');
        return;
      }

      const jsonStr = await response.text();
      if (response.status != 200) {
        $.LoadingOverlay('hide');
        msgErro(jsonStr.mensagem);
        return;
      }

    } catch (error) {
      console.error(error)
      msgAlerta(error.message)
    } finally {
      $.LoadingOverlay('hide')
    }
  }

  async function imprimirPedido(numero) {
    try {
      $.LoadingOverlay('show');
      try {
        let url = `/sisplan/impressao/v1/acesso_pedido?`;

        const ordem = `&TELA_ORDENACAO=acesso_pedido&ORDEM_ORDENACAO=1`;
        const bImprimeAutomatico = await verificaImprimirAutomatico('RelPedidoA');
        let arquivo = await GeraRelatorio(`${url}&NUMERO='${numero}'${ordem}`, 'GET', 1000000, false, 'RelPedidoA');
        if (arquivo != undefined) {
          if (!bImprimeAutomatico) {
            window.open(`${BASE_URI}/relatorios_api/pdf/${arquivo}`, '_blank');
          }
          await limparRelatorios();
        }

      } catch (error) {
        console.error(error);
      }
    } finally {
      $.LoadingOverlay('hide');
    }
  }

  async function adicionaPesquisaFiltros() {
    componenteFiltro("cliente", true);
    componenteFiltro("produto", true);
    componenteFiltro("grupoPA", true);
    componenteFiltro("etiqueta", true);
    componenteFiltro("linha", true);
    componenteFiltro("representante", true);

    $('#txtNumero').pesquisa_variosServerside(3, `{ 
      "tabela":"OS", 
      "camposSelect":[ "OS.NUMERO", "ENTIDADE.NOME"], 
      "leftjoin":[{"tabela":"ENTIDADE", "condicao": "ENTIDADE.CODCLI = OS.CLIENTE"}]}`,
      'NUMERO', 'NOME');

    $('#btnNumero').pesquisa_serversideSel('#txtNumero', `{ 
      "tabela":"OS", 
      "camposSelect":[ "OS.NUMERO", "ENTIDADE.NOME"], 
      "leftjoin":[{"tabela":"ENTIDADE", "condicao": "ENTIDADE.CODCLI = OS.CLIENTE"}], 
      "where": null}`, 'Pesquisa Número');

    $('#btnLimpaNumero').on('click', function () {
      $('#txtNumero').empty().trigger('change');
    });

    const usuarioMasterSupervisor = await uMasterOuSupervisor()

    if (usuarioMasterSupervisor) {
      $('#divRepresentante').removeClass('d-none')
    } else {
      $('#divRepresentante').addClass('d-none')
    }

    const mes = new Date().getMonth() + 1
    const ano = new Date().getFullYear()

    $('#txtDtCadastroI').val(`${ano}-${mes}-01`)
    $('#txtDtCadastroF').val('2500-12-01')
  }
});
