$(document).ready(async function () {

    const materialCodigo = await retornaCodigoMaterialUrl();
    const materialDescricao = await retornaDescricaoMaterial();
    let ultimaRowFocus = -1;

    $('#titleMaterial').html(`[${materialCodigo}] - ${materialDescricao}`);

    $('#btnConsultar').on('click', async function () {
        $.LoadingOverlay('show');
        try {
            $('#tabelaItensMat').DataTable().clear().draw(false);

            const url = '/sisplan/matitensest/v1/consultaitensestmat?';

            const filtros = await retornaFiltros();

            const response = await requisicao('GET', url, filtros, '', 360000);

            const jsonStr = await response.json();

            if (jsonStr.length <= 0) {
                msgAlerta('Nenhum registro encontrado.');
                return
            }

            for (row in jsonStr) {
                const newRow = $('#tabelaItensMat').DataTable().row.add(jsonStr[row]).draw(false);

                const celulasEditaveis = [4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 16, 17];

                celulasEditaveis.forEach((index) => {
                    const celula = $($(newRow.node()).children()[index])[0];
                    celula.setAttribute('contenteditable', true);

                    aplicaEvento(celula, 'blur', async (event) => {
                        if (index === 5 || index === 6 || index === 8 || index === 9 || index === 13) {
                            if (event.target.textContent == '' && antigoValor != '') {
                                event.target.textContent = antigoValor;
                                antigoValor = '';
                                return
                            };
                        };
                    });

                    if (index === 11 || index === 12) {
                        aplicaEvento(celula, 'input', (event) => {
                            let value = event.target.textContent.replace(/\D/g, '');
                            if (value.length > 8) value = value.substring(0, 8);
                            const day = value.substring(0, 2);
                            const month = value.substring(2, 4);
                            const year = value.substring(4, 8);
                            let formattedValue = day;
                            if (month) formattedValue += '/' + month;
                            if (year) formattedValue += '/' + year;
                            event.target.textContent = formattedValue;
                            const range = document.createRange();
                            const sel = window.getSelection();
                            range.selectNodeContents(event.target);
                            range.collapse(false);
                            sel.removeAllRanges();
                            sel.addRange(range);
                        });
                    };

                    if (index === 5 || index === 6 || index === 8 || index === 9 || index === 13) {
                        aplicaEvento(celula, 'focus', (event) => {
                            antigoValor = event.target.textContent;
                            event.target.textContent = '';
                        });

                        aplicaEvento(celula, 'input', (event) => {
                            let input = event.target.textContent;
                            input = input.replace(/[^0-9]/g, '').replace(/^0+/, '');
                            if (input.length > 2) {
                                let integerPart = input.slice(0, -2);
                                let decimalPart = input.slice(-2);
                                event.target.textContent = (integerPart || '0') + '.' + decimalPart;
                            } else if (input.length > 0) {
                                event.target.textContent = '0.' + input.padStart(2, '0');
                            } else {
                                event.target.textContent = '';
                            }
                            const range = document.createRange();
                            const sel = window.getSelection();
                            range.selectNodeContents(event.target);
                            range.collapse(false);
                            sel.removeAllRanges();
                            sel.addRange(range);
                        })
                    };
                });
            };

            $('td[contenteditable="true"]').addClass('tdEditable');

            $('td[contenteditable="true"]').on('focusout', function () {
                $('#tabelaItensMat').DataTable().columns.adjust().draw(false);
            });
        } catch (error) {
            console.error(error);
            msgErro('Ocorreu um erro ao consultar! Erro: ' + error.message);
        } finally {
            $.LoadingOverlay('hide');
        }
    });

    $('#btnGravar').on('click', async function () {
        $.LoadingOverlay('show');
        try {
            const regsDatatable = $('#tabelaItensMat tbody tr');
            const arrayRegs = [];
            for (let j = 0; j < regsDatatable.length; j++) {
                const obj = {
                    "QUALIDADE": $(regsDatatable[j]).children()[0].textContent,
                    "COR": $(regsDatatable[j]).children()[1].textContent,
                    "LOCAL": $(regsDatatable[j]).children()[4].textContent,
                    "PRECO": parseFloat($(regsDatatable[j]).children()[5].textContent),
                    "PRECO_COMPRA": parseFloat($(regsDatatable[j]).children()[6].textContent),
                    "PRECO_ANT": parseFloat(0),
                    "BARRA": $(regsDatatable[j]).children()[7].textContent,
                    "EST_MIN": parseFloat($(regsDatatable[j]).children()[8].textContent),
                    "EST_MAX": parseFloat($(regsDatatable[j]).children()[9].textContent),
                    "OBS": $(regsDatatable[j]).children()[10].textContent,
                    "DT_FAB": formataDataParaGravar($(regsDatatable[j]).children()[11].textContent),
                    "DT_VAL": formataDataParaGravar($(regsDatatable[j]).children()[12].textContent),
                    "MIN_LOTE": parseFloat($(regsDatatable[j]).children()[13].textContent),
                    "CON": $(regsDatatable[j]).children()[16].textContent,
                    "LOTE_FIO": $(regsDatatable[j]).children()[17].textContent,
                    "DEPOSITO": $(regsDatatable[j]).children()[19].textContent,
                    "LOTE": $(regsDatatable[j]).children()[20].textContent,
                    "CODIGO": materialCodigo,
                    "DESC_MAT": materialDescricao,
                };
                arrayRegs.push(obj);
            }

            const url = '/sisplan/matitensest/v1/atualizaitensestmat?';
            const response = await requisicao('PUT', url, '', `LISTAITENSMAT=${encodeURIComponent(JSON.stringify({ LISTAITENSMATEST: arrayRegs }))}`, 360000);

            if (response.status == 200) {
                criaMensagemSucesso(`Dados do material [${materialCodigo}] - ${materialDescricao} atualizados com sucesso!`, () => { window.location.reload(true) });
                return;
            };

            if (response.status != 200) {
                const jsonStr = await response.json();
                msgErro('Não foi possível atualizar os dados desse material! Verifique. Erro: ' + jsonStr.mensagem);
                return;
            };
        } catch (error) {
            console.error(error);
            msgErro('Oocrreu um erro ao gravar! Erro: ' + error.message);
        } finally {
            $.LoadingOverlay('hide');
        }
    });

    $('#btnGerarBarras').on('click', async function () {
        $.LoadingOverlay('show');
        try {
            const datatable = $('#tabelaItensMat tbody tr');

            if (datatable.length <= 0) {
                msgErro('Não existe dados para gerar as barras. Clique em consultar.');
                return
            };

            for (let w = 0; w < datatable.length; w++) {
                const barra = $(datatable[w]).children()[7].textContent;
                const cor = $(datatable[w]).children()[1].textContent;
                const codigo = materialCodigo;

                if (await retornaSeExisteBarra(barra, codigo, cor)) {
                    const result = await buscaValorListaWhere('MAT_ITEN', ['BARRA'], ['CODIGO', 'COR'], [`${codigo}`, `${cor}`]);
                    $(datatable[w]).children()[7].textContent = result.BARRA
                } else {
                    $(datatable[w]).children()[7].textContent = await RetornaProximo("MAT_ITEN", "MAT_ITEN", "BARRA", 12);
                };
            };
        } catch (error) {
            console.error(error);
            msgErro('Ocorreu um erro ao gerar as barras. Verifique! Erro: ' + error.message);
        } finally {
            $.LoadingOverlay('hide');
        };
    });

    $('#btnGerarEAN13').on('click', async function () {
        $.LoadingOverlay('show');
        try {
            const regsDatatable = $('#tabelaItensMat tbody tr');

            if (regsDatatable.length <= 0) {
                msgErro('Não existe dados para gerar as barras. Clique em consultar.');
                return
            };

            for (let j = 0; j < regsDatatable.length; j++) {
                let barraRegDatatable = $(regsDatatable[j]).children()[7].textContent;

                if (barraRegDatatable === '') {
                    barraRegDatatable = await buscaBarraMaterial(materialCodigo, $(regsDatatable[j]).children()[1].textContent);
                };

                if (barraRegDatatable === '') {
                    barraRegDatatable = await geraEAN13Material(materialCodigo, $(regsDatatable[j]).children()[1].textContent);
                };

                $(regsDatatable[j]).children()[7].textContent = barraRegDatatable;
            }
        } catch (error) {
            console.error(error);
            msgErro('Ocorreu um erro ao gerar o EAN13. Verifique! Erro: ' + error.message);
        } finally {
            $.LoadingOverlay('hide');
        }
    })

    $('#btnImpBarras').on('click', async function () {
        try {
            $.LoadingOverlay('show');
            try {
                const regsDatatableImpressao = $('#tabelaItensMat tbody tr');
                if (regsDatatableImpressao.length <= 0) {
                    msgErro('Não foi possível imprimir pois não há registros consultados. Favor consultar para depois imprimir!');
                    return
                }
                const arrayRegsImpressao = [];
                for (let j = 0; j < regsDatatableImpressao.length; j++) {
                    const obj = {
                        "QUALIDADE": $(regsDatatableImpressao[j]).children()[0].textContent,
                        "COR": $(regsDatatableImpressao[j]).children()[1].textContent,
                        "LOCAL": $(regsDatatableImpressao[j]).children()[4].textContent,
                        "PRECO": parseFloat($(regsDatatableImpressao[j]).children()[5].textContent),
                        "PRECO_COMPRA": parseFloat($(regsDatatableImpressao[j]).children()[6].textContent),
                        "PRECO_ANT": parseFloat(0),
                        "BARRA": $(regsDatatableImpressao[j]).children()[7].textContent,
                        "EST_MIN": parseFloat($(regsDatatableImpressao[j]).children()[8].textContent),
                        "EST_MAX": parseFloat($(regsDatatableImpressao[j]).children()[9].textContent),
                        "OBS": $(regsDatatableImpressao[j]).children()[10].textContent,
                        "DT_FAB": formataDataParaGravar($(regsDatatableImpressao[j]).children()[11].textContent),
                        "DT_VAL": formataDataParaGravar($(regsDatatableImpressao[j]).children()[12].textContent),
                        "MIN_LOTE": parseFloat($(regsDatatableImpressao[j]).children()[13].textContent),
                        "CON": $(regsDatatableImpressao[j]).children()[16].textContent,
                        "LOTE_FIO": $(regsDatatableImpressao[j]).children()[17].textContent,
                        "DEPOSITO": $(regsDatatableImpressao[j]).children()[19].textContent,
                        "LOTE": $(regsDatatableImpressao[j]).children()[20].textContent,
                        "CODIGO": materialCodigo,
                        "DESC_MAT": materialDescricao,
                    };
                    arrayRegsImpressao.push(obj);
                }
                const url = `/sisplan/matitensest/v1/imprimirbarras?`;
                let arquivo = await GeraRelatorio(`${url}&`, 'POST', 100000, false, 'RelMatBarras', `LISTAITENSMAT=${encodeURIComponent(JSON.stringify({ LISTAITENSMATEST: arrayRegsImpressao }))}`);
                if (arquivo != undefined) {
                    window.open(`${BASE_URI}/relatorios_api/pdf/${arquivo}`, '_blank');
                    await limparRelatorios();
                }

            } catch (error) {
                console.error(error);
            }
        } finally {
            $.LoadingOverlay('hide');
        }
    });

    document.addEventListener('keydown', (event) => {
        if (event.key === 'Enter') {
            event.preventDefault();
        };
    });

    async function retornaSeExisteBarra(sBarra, sCodigo, sCor) {
        const url = '/sisplan/matitensest/v1/existebarramat?';

        const response = await requisicao('GET', url, `CODIGO=${sCodigo}&COR=${sCor}&BARRA=${sBarra}`, '', 360000);

        if (!response) {
            msgErro('Não foi possível consultar se existe a barra! Verifique.');
            return;
        }

        if (response.status != 200) {
            const jsonStr = await response.json();
            msgErro('Não foi possível consultar se existe a barra! Verifique. Erro: ' + jsonStr.mensagem);
            return;
        };

        const result = await response.text();

        return result === 'true' ? true : false
    };

    async function buscaBarraMaterial(sCodigo, sCor) {
        const url = '/sisplan/matitensest/v1/buscabarramat?';

        const response = await requisicao('GET', url, `CODIGO=${sCodigo}&COR=${sCor}`, '', 360000);

        if (!response) {
            msgErro('Não foi possível buscar a barra! Verifique.');
            return;
        }

        if (response.status != 200) {
            const jsonStr = await response.json();
            msgErro('Não foi possível buscar a barra! Verifique. Erro: ' + jsonStr.mensagem);
            return;
        };

        return response.text();
    };

    async function geraEAN13Material(sCodigo, sCor) {
        const url = '/sisplan/matitensest/v1/geraean13material?';

        const response = await requisicao('GET', url, `CODIGO=${sCodigo}&COR=${sCor}`, '', 360000);

        if (!response) {
            msgErro('Não foi possível gerar o EAN13! Verifique.');
            return;
        }

        if (response.status != 200) {
            const jsonStr = await response.json();
            msgErro('Não foi possível buscar gerar o EAN13! Verifique. Erro: ' + jsonStr.mensagem);
            return;
        };

        return response.text();
    };

    function formataDataParaGravar(data) {
        const [dia, mes, ano] = data.split('/');
        return `${ano}-${mes}-${dia}`;
    };

    async function retornaCodigoMaterialUrl() {
        const queryString = window.location.href;
        const parametros = queryString.split('/');
        const materialUrl = atob(parametros[parametros.length - 1]);

        return materialUrl;
    };

    async function retornaDescricaoMaterial() {
        const pesquisaDescricaoMaterial = {
            tabela: 'MATERIAL',
            camposSelect: ['DESCRICAO'],
            where: [`CODIGO = '${materialCodigo}'`]
        }

        const jsonDescricaoMaterial = await retornaJsonPesquisaPadrao(JSON.stringify(pesquisaDescricaoMaterial));

        if (jsonDescricaoMaterial.length == 0) {
            return;
        };

        return jsonDescricaoMaterial[0].DESCRICAO;
    };

    function aplicaEvento(element, evento, callback) {
        element.addEventListener(evento, callback);
    };

    async function retornaFiltros() {
        const somenteComEstoque = $('#checkSomenteCEstoque').is(':checked') ? 'S' : 'N';
        const estoqueMaxEMin = $('#checkEstoqueMaxEMin').is(':checked') ? 'S' : 'N';
        const considerarDepositos = $('#checkConsiderarDepositos').is(':checked') ? 'S' : 'N';
        const etiquetaTag = $('#checkEtiquetaTag').is(':checked') ? 'S' : 'N';
        const depositos = await formataListas($('#txtDeposito').val().toString());
        const cores = await formataListas($('#txtCor').val().toString());
        const qualidade = await formataListas($('#txtQualidade').val().toString());
        const lote = await formataListas($('#txtLote').val().toString());

        return `SOMENTE_COM_ESTOQUE=${somenteComEstoque}&ESTOQUE_MAX_MIN=${estoqueMaxEMin}&CONSIDERAR_DEPOSITOS=${considerarDepositos}&ETIQUETA_TAG=${etiquetaTag}&DEPOSITOS=${depositos}&CORES=${cores}&QUALIDADE=${qualidade}&LOTE=${lote}&CODIGO=${materialCodigo}`;
    }

    function criaDataTableAoAbrirATela() {
        $('#tabelaItensMat').DataTable({
            destroy: true,
            ordering: false,
            pageLength: 10,
            lengthChange: false,
            serverside: false,
            searching: false,
            paging: false,
            scrollY: '400px',
            scrollCollapse: true,
            "language": {
                "sEmptyTable": "Nenhum registro encontrado",
                "sInfo": "_TOTAL_ registros",
                "sInfoEmpty": " 0 registros",
                "sInfoFiltered": "(Filtrados de _MAX_ registros)",
                "sInfoPostFix": "",
                "sInfoThousands": ".",
                "sLengthMenu": "_MENU_ resultados",
                "sLoadingRecords": "Carregando...",
                "sProcessing": "Processando...",
                "sZeroRecords": "Nenhum registro encontrado",
                "sSearch": "Pesquisar",
                "oPaginate": {
                    "sNext": "Próximo",
                    "sPrevious": "Anterior",
                    "sFirst": "Primeiro",
                    "sLast": "Último"
                },
                "oAria": {
                    "sSortAscending": ": Ordenar colunas de forma ascendente",
                    "sSortDescending": ": Ordenar colunas de forma descendente"
                }
            },
            "autoWidth": true,
            "columns": [
                {
                    "data": "QUALIDADE",
                    "title": "Qualidade",
                },
                {
                    "data": "COR",
                    "title": "Cor",
                },
                {
                    "data": "DESC_COR",
                    "title": "Desc. Cor",
                },
                {
                    "data": "QTDE",
                    "title": "Quantidade",
                },
                {
                    "data": "LOCAL",
                    "title": `Local<i class="fas fa-check ml-1 mt-1" id="checkAtualizaLocal" title="Aplicar valor para todos(somente o primeiro valor para os demais)" style="color: #32CD32; font-size: 1.0em"/>`,
                },
                {
                    "data": "PRECO_MED",
                    "title": `Preço<i class="fas fa-check ml-1 mt-1" id="checkAtualizaPreco" title="Aplicar valor para todos(somente o primeiro valor para os demais)" style="color: #32CD32; font-size: 1.0em"/>`,
                },
                {
                    "data": "PRECO_COMPRA",
                    "title": `Preço Compra<i class="fas fa-check ml-1 mt-1" id="checkAtualizaPrecoCompra" title="Aplicar valor para todos(somente o primeiro valor para os demais)" style="color: #32CD32; font-size: 1.0em"/>`,
                },
                {
                    "data": "BARRA",
                    "title": "Barra",
                },
                {
                    "data": "QTD_MINIMA",
                    "title": `Est. Mín.<i class="fas fa-check ml-1 mt-1" id="checkAtualizaQtdeMin" title="Aplicar valor para todos(somente o primeiro valor para os demais)" style="color: #32CD32; font-size: 1.0em"/>`,
                },
                {
                    "data": "QTD_MAXIMA",
                    "title": `Est. Máx.<i class="fas fa-check ml-1 mt-1" id="checkAtualizaQtdeMax" title="Aplicar valor para todos(somente o primeiro valor para os demais)" style="color: #32CD32; font-size: 1.0em"/>`,
                },
                {
                    "data": "OBS",
                    "title": `Obs.<i class="fas fa-check ml-1 mt-1" id="checkAtualizaObs" title="Aplicar valor para todos(somente o primeiro valor para os demais)" style="color: #32CD32; font-size: 1.0em"/>`,
                },
                {
                    "data": "DT_FAB",
                    "title": `Data Fab.<i class="fas fa-check ml-1 mt-1" id="checkAtualizaDtFab" title="Aplicar valor para todos(somente o primeiro valor para os demais)" style="color: #32CD32; font-size: 1.0em"/>`,
                },
                {
                    "data": "DT_VAL",
                    "title": `Data Val.<i class="fas fa-check ml-1 mt-1" id="checkAtualizaDtVal" title="Aplicar valor para todos(somente o primeiro valor para os demais)" style="color: #32CD32; font-size: 1.0em"/>`,
                },
                {
                    "data": "MIN_LOTE",
                    "title": `Mín Lote.<i class="fas fa-check ml-1 mt-1" id="checkAtualizaMinLote" title="Aplicar valor para todos(somente o primeiro valor para os demais)" style="color: #32CD32; font-size: 1.0em"/>`,
                },
                {
                    "data": "EXISTE_LAUDO",
                    "title": "Existe Laudo",
                },
                {
                    "data": "EXISTE_FICHA_SEG",
                    "title": "Existe Ficha Seg.",
                },
                {
                    "data": "CON",
                    "title": `Con<i class="fas fa-check ml-1 mt-1" id="checkAtualizaCon" style="color: #32CD32; font-size: 1.0em" title="Aplicar valor para todos(somente o primeiro valor para os demais)"/>`,
                },
                {
                    "data": "LOTE_FIO",
                    "title": `Lote Fio<i class="fas fa-check ml-1 mt-1" id="checkAtualizaLoteFio" style="color: #32CD32; font-size: 1.0em" title="Aplicar valor para todos(somente o primeiro valor para os demais)"/>`,
                },
                {
                    "data": "COR_COD2",
                    "title": "Cor Cod. 2",
                },
                {
                    "data": "DEPOSITO",
                    "title": "Depósito",
                },
                {
                    "data": "LOTE",
                    "title": "Lote",
                }
            ],
            "columnDefs": [
                {
                    targets: [3, 5, 6, 8, 9, 13],
                    "className": 'text-right'
                },
                {
                    type: 'date-br',
                    targets: [11, 12],
                    render(data) {
                        if (data) {
                            return new Intl.DateTimeFormat('pt-BR').format(new Date(`${data.split(' ')[0]} 23:59:59`));
                        } else {
                            return '';
                        }

                    },
                },
            ],
        });

        $('#checkAtualizaLocal').on('click', async function () {
            await atualizaTodosRegistros(4);
        });

        $('#checkAtualizaPreco').on('click', async function () {
            await atualizaTodosRegistros(5);
        });

        $('#checkAtualizaPrecoCompra').on('click', async function () {
            await atualizaTodosRegistros(6);
        });

        $('#checkAtualizaQtdeMin').on('click', async function () {
            await atualizaTodosRegistros(8);
        });

        $('#checkAtualizaQtdeMax').on('click', async function () {
            await atualizaTodosRegistros(9);
        });

        $('#checkAtualizaObs').on('click', async function () {
            await atualizaTodosRegistros(10);
        });

        $('#checkAtualizaDtFab').on('click', async function () {
            await atualizaTodosRegistros(11);
        });

        $('#checkAtualizaDtVal').on('click', async function () {
            await atualizaTodosRegistros(12);
        });

        $('#checkAtualizaMinLote').on('click', async function () {
            await atualizaTodosRegistros(13);
        });

        $('#checkAtualizaCon').on('click', async function () {
            await atualizaTodosRegistros(16);
        });

        $('#checkAtualizaLoteFio').on('click', async function () {
            await atualizaTodosRegistros(17);
        });

        $('#tabelaItensMat').on('focus', 'td', function () {
            const row = $(this).closest('tr');
            ultimaRowFocus = row.index();
        });
    };

    function criaPesquisas() {
        componenteFiltro('depositoUsuario', true, true, 'Deposito');
        componenteFiltro('cor', true);
        componenteFiltro('qualidade', true);
        componenteFiltro('loteInterno', true, true, 'Lote');
    };

    async function atualizaTodosRegistros(indice) {
        if (ultimaRowFocus === 0) {
            msgAguardaConfirmacao('Deseja inserir esse valor para todos os registros?', () => {
                const tbRecordCount = $('#tabelaItensMat').DataTable().data().toArray().length;
                const valorPrimeiroTd = $($('#tabelaItensMat tbody tr')[0]).children()[indice].textContent;

                for (let i = 0; i < tbRecordCount; i++) {
                    $($('#tabelaItensMat tbody tr')[i]).children()[indice].textContent = valorPrimeiroTd;
                };
            }, () => { });
        };
    };

    criaDataTableAoAbrirATela();
    criaPesquisas();
});