$('#tutorial').on('click', function () {
    $(document).ready(async function () {
        const driver = new Driver({
            doneBtnText: 'Sair',
            closeBtnText: 'Fechar',
            nextBtnText: 'Próximo',
            prevBtnText: 'Anterior',
            allowClose: false
        });
        driver.defineSteps([{
            element: '#btnFiltros',
            popover: {
                title: 'Botão Filtros',
                description: 'Clique aqui para abrir os filtros padrões da tela.',
                position: 'right'
            }
        },
        {
            element: '#btnNovoMaterial',
            popover: {
                title: 'Botão Incluir',
                description: 'Clique aqui para iniciar o cadastro de um material.',
                position: 'right'
            }
        },
        {
            element: '#tabelaCadMaterial_wrapper',
            popover: {
                title: 'Tabela Produtos',
                description: 'Aqui estão os dados dos materiais cadastrados.',
                position: 'top'
            }
        }
        ]);
        driver.start();
    });
});
$(document).ready(async function () {
    const permissaoUsuarioLogado = await permissaoAcessos("MATERIAL");

    $('#btnFiltros').on('click', function () {
        $('#modal-filtros').modal('show');
    });

    $('#btnNovoMaterial').on('click', function () {
        if (permissaoUsuarioLogado.INCLUI == 'S') {
            window.location.href = "material/create";
        } else {
            msgAlertaSemConfirmacao("Sem permissão para incluir!");
        }
    });

    componenteFiltro('material', true)
    componenteFiltro('grupo', true)
    componenteFiltro('subGrupo', true)
    componenteFiltro('linha', true)
    componenteFiltro('ncm', true)

    function retornaBotaoOpcoes(data) {
        var retorno = '<div style="text-align:start;"> ' +
          '    <button class="btn btn-info btn-sm dropdown-toggle btnVerificaOpcoes" type="button" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false"> ' +
          '      ' + data + ' ' +
          '    </button> ' +
          '    <div class="dropdown-menu"> ' +
          '    <button class="dropdown-item" type="button" title="Editar" id="btn-editar">Editar</button>     ' +
          '    <button class="dropdown-item" type="button" title="Excluir" id="btn-excluir">Excluir</button>  ' +
          '    <button class="dropdown-item" type="button" title="Duplicar" id="btn-duplicar">Duplicar</button>     ' +
          '    <button class="dropdown-item" type="button" title="Anexos" id="btnAnexos">Gestão Documentos</button>     ' +
          '    <button class="dropdown-item" type="button" title="Itens em Estoque de Materiais" id="btnMatItensEst">Estoque de Materiais</button>     ' +
          '</div>';
        return retorno;
      };


    consultaMaterial();

    $('#btnConsultar').on('click', async function () {
        $('#modal-filtros').modal('hide');
        await consultaMaterial(true);
    });

    $('#btnLimparFiltros').on('click', async function () {
        $('#txtMaterial').empty().trigger('change')
        $('#txtGrupo').empty().trigger('change')
        $('#txtLinha').empty().trigger('change')
        $('#txtSubGrupo').empty().trigger('change')
        $('#txtNCM').empty().trigger('change')
    });


    async function consultaMaterial(bBotao = false) {
        try {
            $.LoadingOverlay("show");

            let listaMaterial = await formataListas($('#txtMaterial').val().toString());
            let listaGrupo = await formataListas($('#txtGrupo').val().toString());
            let listaSubGrupo  = await formataListas($('#txtSubGrupo').val().toString());
            let listaLinha  = await formataListas($('#txtLinha').val().toString());
            let listaNcm  = await formataListas($('#txtNcm').val().toString());

            const material = listaMaterial !== '' ? ` AND CODIGO IN (${listaMaterial})` : '';
            const grupo = listaGrupo !== '' ? ` AND GRUPO IN (${listaGrupo})` : '';
            const subGrupo = listaSubGrupo !== '' ? ` AND SUB_GRUPO IN (${listaSubGrupo})` : '';
            const linha = listaLinha !== '' ? ` AND LINHA IN (${listaLinha})` : '';
            const ncm = listaNcm !== '' ? ` AND CODFIS IN (${listaNcm})` : '';
            const inputStatus = $('input[name="cbStatus"]:checked');
            const status = inputStatus.attr('id') === 'cbTodos' ? '' : ` AND ATIVO = '${inputStatus.val()}'`;

            const response = await requisicao('GET', '/Sisplan/Funcoes/V1/pesquisa?', `JSON={ "tabela":"material", "camposSelect":[ "CODIGO", "DESCRICAO"], "where": ["1=1 ${material} ${grupo} ${subGrupo} ${linha} ${ncm} ${status}"]}`, null);

            if (!response) {
                $.LoadingOverlay("hide");
                return;
            }

            const jsonStr = await response.json()
            if (response.status != 200) {
                $.LoadingOverlay("hide");
                msgErro(jsonStr['RESULT'][0].mensagem)
                return
            }

            var table = $('#tabelaCadMaterial').DataTable({
                destroy: true,
                lengthChange: false,
                serverside: true,
                "language": {
                    "sEmptyTable": "Nenhum registro encontrado",
                    "sInfo": "_TOTAL_ registros",
                    "sInfoEmpty": " 0 registros",
                    "sInfoFiltered": "(Filtrados de _MAX_ registros)",
                    "sInfoPostFix": "",
                    "sInfoThousands": ".",
                    "sLengthMenu": "_MENU_ resultados",
                    "sLoadingRecords": "Carregando...",
                    "sProcessing": "Processando...",
                    "sZeroRecords": "Nenhum registro encontrado",
                    "sSearch": "Pesquisar",
                    "oPaginate": {
                        "sNext": "Próximo",
                        "sPrevious": "Anterior",
                        "sFirst": "Primeiro",
                        "sLast": "Último"
                    },
                    "oAria": {
                        "sSortAscending": ": Ordenar colunas de forma ascendente",
                        "sSortDescending": ": Ordenar colunas de forma descendente"
                    }
                },

                "autoWidth": true,
                "data": jsonStr['RESULT'][0],
                "columns": [{
                    "data": "CODIGO"
                },
                {
                    "data": "DESCRICAO"
                },
                ],
                "columnDefs": [{
                    targets: [0], render: function (data, type, row) {
                        return retornaBotaoOpcoes(data);
                      }
                }]
            });

            $.LoadingOverlay("hide");
        } catch (error) {
            console.error(error);
            $.LoadingOverlay("hide");
            msgErro('Não foi possível buscar os dados do cliente: ' + error)
        }
    }

    $('#tabelaCadMaterial').on('click', '#btn-editar', async function () {
        if (permissaoUsuarioLogado.ALTERA == 'S') {
            event.preventDefault();
            var data = $('#tabelaCadMaterial').DataTable().row($(this).parents('tr')).data();
            var registroLiberado = await verificarRegistro('PRODUTO', data.CODIGO)
            if (registroLiberado) {
                window.location.href = "material/" + data.CODIGO
            }
        } else {
            msgAlertaSemConfirmacao("Sem permissão para alterar!");
        }
    });

    $('#tabelaCadMaterial').on('dblclick', 'tr', async function () {
        if (permissaoUsuarioLogado.ALTERA == 'S') {
            event.preventDefault();
            var data = $('#tabelaCadMaterial').DataTable().row($(this)).data();
            var registroLiberado = await verificarRegistro('PRODUTO', data.CODIGO)
            if (registroLiberado) {
                window.location.href = "material/" + data.CODIGO
            }
        } else {
            msgAlertaSemConfirmacao("Sem permissão para alterar!");
        }
    });

    $('#tabelaCadMaterial').on('click', '#btn-excluir', async function () {
        if (permissaoUsuarioLogado.EXCLUI == 'S') {
            msgAlerta('Você realmente deseja excluir esse registro?', async () => {
                const data = $("#tabelaCadMaterial").DataTable().row($(this).parents("tr"));
                await excluiRegistro(data);
            });
        } else {
            msgAlertaSemConfirmacao("Sem permissão para excluir!");
        }
    });

    async function excluiRegistro(data) {
        try {
            $.LoadingOverlay("show");
            try {
                let valorLinha = data.data();
                let response = await requisicao("DELETE", "/Sisplan/Cadastros/v1/material?", `CODIGOMATERIAL=${encodeURIComponent(valorLinha.CODIGO)}`, null);
                if (!response) {
                    return;
                }
                if (response.status != 200) {
                    let jsonStr = await response.json();
                    msgErro(jsonStr.mensagem);
                    return;
                }

                toastr.success("Exclusão efetuada com sucesso!", "Confirmação", {
                    toastClass: "success",
                    iconClasses: {
                        error: "alert-error",
                        info: "alert-info",
                        success: "alert-success",
                        warning: "alert-warning",
                    },
                    positionClass: "toast-top-center",
                    progressBar: true,
                    timeOut: 3000,
                    fadeOut: 1000,
                    onHidden() {
                        data.remove().draw(false);
                    },
                }).css({
                    "margin-top": "20%",
                    width: "500px",
                    "max-width": "500px",
                });

            } catch (error) {
                console.error(error);
            }
        } finally {
            $.LoadingOverlay("hide");
        }
    }

    $("#tabelaCadMaterial").on('click', "#btnAnexos", async function () {
        const data = $('#tabelaCadMaterial').DataTable().rows($(this).parents('tr')).data();

        await abreModalAnexos(data[0].CODIGO, data[0].DESCRICAO, 'MATERIAL');
    });

    $('#tabelaCadMaterial').on('click', "#btn-duplicar", async function () {
        if (permissaoUsuarioLogado.ALTERA == 'S') {
            let data = $('#tabelaCadMaterial').DataTable().row($(this).parents('tr')).data();
            await duplicaCadastroMaterial(data.CODIGO);
        } else {
            msgAlertaSemConfirmacao("Sem permissão para alterar!");
        }
    });

    $('#tabelaCadMaterial').on('click', '#btnMatItensEst', function () {
        const data = $('#tabelaCadMaterial').DataTable().row($(this).parents('tr')).data();
        abreMatItensEst(data.CODIGO);
    });

});
