$('#tutorial').on('click', function () {
    $(document).ready(async function () {
        const driver = new Driver({
            doneBtnText: 'Sair',
            closeBtnText: 'Fechar',
            nextBtnText: 'Próximo',
            prevBtnText: 'Anterior',
            allowClose: false,
            animate: true,
        });
        driver.defineSteps([{
            element: '#campostour',
            popover: {
                title: 'Dados Gerais',
                description: 'Aqui estão os campos disponíveis para realizar a consulta.',
                position: 'bottom'
            }
        },
        {
            element: '#txtNumeroAP',
            popover: {
                title: 'Campo Obrigatório',
                description: 'Esse é um campo obrigatório, preencha com um número da AP que deseja estornar.',
                position: 'top'
            }
        },
        {
            element: '#btnConsultar',
            popover: {
                title: 'Botão Consulta',
                description: 'Clique aqui para realizar a consulta.',
                position: 'left'
            }
        }
        ]);
        driver.start();
    });
});

$(document).ready(async function () {

    //Pesquisas

    $('#txtPeriodoDe').autocompleta(
        1,
        `JSON={ 
            "tabela":"TABPRZ", 
            "camposSelect":["PRAZO CHAVE, DESCRICAO DESCRICAO"], 
            "where": []
        }`
    );

    $('#btnPeriodoDe').pesquisa(
        '#txtPeriodoDe',
        'PRAZO',
        'DESCRICAO',
        '/sisplan/funcoes/v1/pesquisa?JSON={ "tabela":"TABPRZ", "camposSelect":["PRAZO", "DESCRICAO", "DT_INICIO", "DT_FIM"], "where": null}',
        'Pesquisa de Prazo',
        'TABPRZ'
    );

    $('#btnLimpaPeriodoDe').on('click', function () {
        $('#txtPeriodoDe').val('');
    });

    $('#txtPeriodoAte').autocompleta(
        1,
        `JSON={ 
            "tabela":"TABPRZ", 
            "camposSelect":["PRAZO CHAVE, DESCRICAO DESCRICAO"], 
            "where": []
        }`
    );

    $('#btnPeriodoAte').pesquisa(
        '#txtPeriodoAte',
        'PRAZO',
        'DESCRICAO',
        '/sisplan/funcoes/v1/pesquisa?JSON={ "tabela":"TABPRZ", "camposSelect":["PRAZO", "DESCRICAO", "DT_INICIO", "DT_FIM"], "where": null}',
        'Pesquisa de Prazo',
        'TABPRZ'
    );

    $('#btnLimpaPeriodoAte').on('click', function () {
        $('#txtPeriodoAte').val('');
    });

    $('#txtTipo').autocompleta(
        1,
        `JSON={ 
            "tabela":"TIPO", 
            "camposSelect":["ID_TIPO CHAVE, DESCRICAO DESCRICAO"], 
            "where": []
        }`
    );

    $('#btnTipo').pesquisa(
        '#txtTipo',
        'ID_TIPO',
        'DESCRICAO',
        '/sisplan/funcoes/v1/pesquisa?JSON={ "tabela":"TIPO", "camposSelect":["ID_TIPO", "DESCRICAO", "AREA"], "where": null}',
        'Pesquisa de Tipo',
        'TIPO'
    );

    $('#btnLimpaTipo').on('click', function () {
        $('#txtTipo').val('');
    });


    $('#txtPedido').pesquisa_variosServerside(
        1,
        `{ 
            "tabela":"PEDIDO", 
            "camposSelect":["PEDIDO.NUMERO", "ENTIDADE.NOME"], 
            "leftJoin": [{ "TABELA": "ENTIDADE", "CONDICAO": "ENTIDADE.CODCLI = PEDIDO.CODCLI"}],
            "where": null}
            `,
        "NUMERO",
        "NOME");

    $("#btnPedido").pesquisa_serversideSel(
        "#txtPedido",
        `{
            "tabela":"PEDIDO", 
            "camposSelect":["PEDIDO.NUMERO", "ENTIDADE.NOME", "PEDIDO.CODCLI", "PEDIDO.DT_FATURA", "PEDIDO.DT_EMISSAO", "PEDIDO.COLECAO", "PEDIDO.DT_SAIDA", "PEDIDO.ENTREGA",  "PEDIDO.TIPO"], 
            "leftJoin": [{ "TABELA": "ENTIDADE", "CONDICAO": "ENTIDADE.CODCLI = PEDIDO.CODCLI"}],
            "where": null
        }`,
        "Pesquisa de Pedido");

    $('#btnLimpaPedido').on('click', function () {
        $('#txtPedido').empty().trigger('change');
    });

    $('#txtSetor').pesquisa_variosServerside(
        1,
        `{ 
            "tabela":"CADFLUXO", 
            "camposSelect":["CODIGO", "DESCRICAO"], 
            "where": null}
            `,
        "CODIGO",
        "DESCRICAO");

    $("#btnSetor").pesquisa_serversideSel(
        "#txtSetor",
        `{
            "tabela":"CADFLUXO", 
            "camposSelect":["CODIGO", "DESCRICAO", "ORDEM", "CUSTO"], 
            "where": null
        }`,
        "Pesquisa de Setor");

    $('#btnLimpaSetor').on('click', function () {
        $('#txtSetor').empty().trigger('change');
    });

    $('#txtFaccao').pesquisa_variosServerside(
        1,
        `{ 
            "tabela":"ENTIDADE", 
            "camposSelect":["CODCLI", "NOME"], 
            "where": null}
            `,
        "CODCLI",
        "NOME");

    $("#btnFaccao").pesquisa_serversideSel(
        "#txtFaccao",
        `{
            "tabela":"ENTIDADE", 
            "camposSelect":["CODCLI", "NOME", "CNPJ", "FANTASIA"], 
            "where": null
        }`,
        "Pesquisa de Facção");

    $('#btnLimpaFaccao').on('click', function () {
        $('#txtFaccao').empty().trigger('change');
    });

    $('#txtOF').pesquisa_variosServerside(
        2,
        `{ 
            "tabela":"FACCAO", 
            "camposSelect":["FACCAO.NUMERO", "ENTIDADE.NOME"], 
            "leftJoin": [{ "TABELA": "ENTIDADE", "CONDICAO": "ENTIDADE.CODCLI = FACCAO.CODCLI"}],
            "where": null}
            `,
        "NUMERO",
        "NOME");

    $("#btnOF").pesquisa_serversideSel(
        "#txtOF",
        `{
            "tabela":"FACCAO", 
            "camposSelect":["FACCAO.NUMERO", "ENTIDADE.NOME", "FACCAO.CODCLI", "FACCAO.PEDIDO", "FACCAO.DT_S", "FACCAO.TAM", "FACCAO.IDENTIFICADOR", "FACCAO.OP", "FACCAO.QUANT"], 
            "leftJoin": [{ "TABELA": "ENTIDADE", "CONDICAO": "ENTIDADE.CODCLI = FACCAO.CODCLI"}],
            "where": null
        }`,
        "Pesquisa de OF");

    $('#btnLimpaOF').on('click', function () {
        $('#txtOF').empty().trigger('change');
    });

    async function consultaEstornoFaccao() {
        // event.preventDefault();
        if (!$('#txtNumeroAP').val()) {
            msgAlerta('Insira o número de AP para consulta.');
            return
        }

        $.LoadingOverlay("show");

        if ($.fn.DataTable.isDataTable('#tabelaEstorno')) {
            $("#tabelaEstorno").DataTable().destroy();
            $("#tabelaEstorno").empty();
        }

        try {
            const params = await buscaDadosCampos();
            const response = await requisicao('GET', `/sisplan/facpreco/v1/facestornopag?`, `JSON=${JSON.stringify(params)}`, '', 90000);

            if (!response) {
                return;
            }

            let jsonStr = await response.json();

            if (jsonStr[1].length > 0 || jsonStr[0].length > 0) {
                const dataSetCols = [];
                const keys = Object.keys(jsonStr[1][0]);
                dataSetCols.push({
                    'title': 'SEL',
                    'data': 'SEL',
                    'width': '15px'
                });

                $('#separador').removeClass('d-none');

                dataSetCols[0].render = function (data, type, row, meta) {
                    return '<div class="group-default form-group">' +
                        '<div class="relative icheck-primary">' +
                        '<input style="height:20px" type="checkbox" id="check_col_' + [meta.row] + '_row_' + [meta.col] + '" class="input-default focus form-control validate campoCheck"><label for="check_col_' + [meta.row] + '_row_' + [meta.col] + '"></label>' +
                        '</div>' +
                        '</div>';
                }

                for (var k in keys) {
                    dataSetCols.push({
                        'title': keys[k],
                        'data': keys[k]
                    });
                }

                let tabelaEstorno = $('#tabelaEstorno').DataTable({
                    paging: true,
                    filter: false,
                    info: true,
                    colReorder: false,
                    destroy: true,
                    lengthChange: true,
                    lengthMenu: [10, 25, 50, 100],
                    pageLength: 25,
                    processing: true,
                    "language": {
                        "sEmptyTable": "Nenhuma consulta realizada",
                        "sInfo": "_TOTAL_ registros",
                        "sInfoEmpty": " 0 registros",
                        "sInfoFiltered": "(Filtrados de _MAX_ registros)",
                        "sInfoPostFix": "",
                        "sInfoThousands": ".",
                        "sLengthMenu": "_MENU_ resultados",
                        "sLoadingRecords": "Carregando...",
                        "sProcessing": "Processando...",
                        "sZeroRecords": "Nenhuma consulta realizada",
                        "sSearch": "Pesquisar",
                        "oPaginate": {
                            "sNext": "Próximo",
                            "sPrevious": "Anterior",
                            "sFirst": "Primeiro",
                            "sLast": "Último"
                        },
                        "oAria": {
                            "sSortAscending": ": Ordenar colunas de forma ascendente",
                            "sSortDescending": ": Ordenar colunas de forma descendente"
                        }
                    },
                    "data": jsonStr[1],
                    "columns": dataSetCols,
                    columnDefs: [{
                        targets: [3, 4, 5, 53, 77, 78, 94],
                        render(data) {
                            const dateObject = new Date(data);
                            const dia = dateObject.getDate().toString().padStart(2, '0');
                            const mes = (dateObject.getMonth() + 1).toString().padStart(2, '0');
                            const ano = dateObject.getFullYear();
                            const dataFormatada = `${dia}/${mes}/${ano}`;
                            return dataFormatada;
                        },
                    }]
                });

                $('#tabelaEstorno').on('click', '.campoCheck', function () {
                    let checkbox = $(this);
                    let rowIndex = tabelaEstorno.row(checkbox.closest('tr')).index();
                    let rowData = tabelaEstorno.row(rowIndex).data();

                    let currentPage = tabelaEstorno.page.info().page; // Armazena o número da página atual
                    let changeMade = false; // Marcador de mudança

                    for (let page = 0; page < tabelaEstorno.page.info().pages; page++) {
                        tabelaEstorno.page(page).draw('page'); // Vai para a página correspondente
                        tabelaEstorno.rows().every(function () { // Percorre todas as linhas da página atual
                            let currentRowData = this.data();
                            let currentRowIndex = this.index();

                            if (
                                currentRowData.LANCTO_PAGAR === rowData.LANCTO_PAGAR &&
                                currentRowData.FAC_NUMERO === rowData.FAC_NUMERO
                            ) {
                                $('#check_col_' + currentRowIndex + '_row_0').prop('checked', checkbox.prop('checked'));

                                // Adiciona/Remove a classe 'selected' apenas na linha clicada
                                this.nodes().to$().toggleClass('selected', checkbox.prop('checked'));

                                changeMade = true; // Mudança foi feita
                            }
                        });
                    }

                    if (changeMade) {
                        tabelaEstorno.page(currentPage).draw('page'); // Volta para a página original apenas se alguma mudança foi feita
                    }

                    tabelaEstorno.rows('.selected').data().length;
                });


            } else {
                msgErro('Sem dados na consulta');
                return
            }
        } catch (error) {
            console.error(error)
            msgErro('Não foi possível fazer a consulta. Erro: ' + $(error));
        } finally {
            $.LoadingOverlay('hide');
        }
    };

    $('#btnConsultar').on('click', consultaEstornoFaccao);


    $('#btnReabrirPgto').on('click', async function () {
        estornoPagamento();
    })

    async function estornoPagamento() {
        let _url = `/Sisplan/facpreco/v1/facestornopag?`;
        let arrayLancamentos = [];
        let valoresSelecionados = {};

        try {
            $.LoadingOverlay("show");
            let tabelaEstornoInstance = $('#tabelaEstorno').DataTable();

            for (let page = 0; page < tabelaEstornoInstance.page.info().pages; page++) {   // Percorre todas as páginas do DataTable
                tabelaEstornoInstance.page(page).draw('page'); // Vai para a página correspondente

                tabelaEstornoInstance.rows().every(function () {  // Percorre todas as linhas da tabela na página atual
                    let currentRowData = this.data();
                    let rowIndex = this.index();

                    if ($('#check_col_' + rowIndex + '_row_0').prop('checked')) {
                        let identifier = currentRowData.LANCTO_PAGAR + '_' + currentRowData.FAC_NUMERO;  // Cria um identificador único para a linha
                        if (!valoresSelecionados[identifier]) { // Verifica se o identificador já foi adicionado

                            let Tabela = {
                                lancamentoPagar: currentRowData.LANCTO_PAGAR,
                                numeroFaccao: currentRowData.FAC_NUMERO,
                                numeroAp: $('#txtNumeroAP').val()
                            };
                            arrayLancamentos.push(Tabela);

                            valoresSelecionados[identifier] = true; // Marca o identificador como já adicionado para evitar duplicatas
                        }
                    }
                });
            }

            const body = {
                Tabela: arrayLancamentos
            }

            let response = await requisicao('POST', _url, '', JSON.stringify(body), 60000)

            if (!response) {
                $.LoadingOverlay("hide");
                return;
            }

            let jsonStr = await response.json();
            if (response.status != 200) {
                $.LoadingOverlay("hide");
                msgErro(
                    'Não é possível fazer o estorno dessa AP, pois a mesma possui baixas!',
                    async function () {
                        consultaEstornoFaccao()
                    },
                    async function () {
                        consultaEstornoFaccao()
                    });

                return
            }

            toastr.success(
                'Estorno efetuado com sucesso!',
                'Confirmação', {
                toastClass: 'alert',
                iconClasses: {
                    error: 'alert-error',
                    info: 'alert-info',
                    success: 'alert-success',
                    warning: 'alert-warning'
                },
                positionClass: "toast-top-center",
                progressBar: true,
                timeOut: 3000,
                fadeOut: 1000,
                onHidden: async function () {
                    tabelaEstornoInstance.clear().destroy();
                    $('#btnConsultar').click();
                }
            }
            ).css({
                "margin-top": "20%",
                "width": "500px",
                "max-width": "500px"
            });;
            $.LoadingOverlay("hide");
            return jsonStr;
        } catch (error) {
            $.LoadingOverlay("hide");
            msgErro(error);
        }
    };



    async function buscaDadosCampos() {
        inputsTela = {
            retornoDe: $('#txtRetornoDe').val() != '' ? formataDataBonita($('#txtRetornoDe').val()) : '01/01/1200',
            retornoAte: $('#txtRetornoAte').val() != '' ? formataDataBonita($('#txtRetornoAte').val()) : '31/12/2500',
            pagamentoDe: $('#txtPagamentoDe').val() != '' ? formataDataBonita($('#txtPagamentoDe').val()) : '01/01/1200',
            pagamentoAte: $('#txtPagamentoAte').val() != '' ? formataDataBonita($('#txtPagamentoAte').val()) : '31/12/2500',
            envioDe: $('#txtEnvioDe').val() != '' ? formataDataBonita($('#txtEnvioDe').val()) : '01/01/1200',
            envioAte: $('#txtEnvioAte').val() != '' ? formataDataBonita($('#txtEnvioAte').val()) : '31/12/2500',
            periodoDe: pegaChave('#txtPeriodoDe'),
            periodoAte: pegaChave('#txtPeriodoAte'),
            numeroAP: $('#txtNumeroAP').val(),
            pedido: $('#txtPedido').val() != '' ? await formataListas($('#txtPedido').val().toString()) : '',
            setor: $('#txtSetor').val() != '' ? await formataListas($('#txtSetor').val().toString()) : '',
            consideraFaccao: $('#cbConsideraFaccao').is(':checked') ? '0' : '1',
            faccao: $('#txtFaccao').val() != '' ? await formataListas($('#txtFaccao').val().toString()) : '',
            consideraOF: $('#cbConsideraOF').is(':checked') ? '0' : '1',
            offaccao: $('#txtOF').val() != '' ? await formataListas($('#txtOF').val().toString()) : '',
            tipo: pegaChave('#txtTipo')
        }
        return inputsTela;
    }

});