let colunas = JSON.parse(localStorage.getItem('colunasInvisiveisRelatorios'));

if (colunas == null || colunas.EscEnvio == undefined) {
  localStorage.setItem('colunasInvisiveisRelatorios', JSON.stringify({ ...colunas, EscEnvio: [] }));
  colunas = JSON.parse(localStorage.getItem('colunasInvisiveisRelatorios'));
}

var ultimaColunaOrdenada = {
  nome: '',
  ordenacao: 'ASC'
};

$("#btnConsultar").on("click", async function () {
  await buscaDados();
});

$("#btnConfirmarColunas").on("click", async function () {
  try {
    $.LoadingOverlay("show");

    const novasColunas = retornaNovasColunasInvisiveis();

    localStorage.setItem(
      "colunasInvisiveisRelatorios",
      JSON.stringify({ ...colunas, EscEnvio: novasColunas })
    );

    $("#tabelaDados").DataTable().columns().visible(true);

    $("#tabelaDados")
      .DataTable()
      .columns()
      .every(function () {
        if (novasColunas.indexOf(this.dataSrc()) != -1) {
          this.visible(false);
        }
      });
  } finally {
    $.LoadingOverlay("hide");
    $("#modal-ColunasVisiveis").modal("hide");
  }
});

$("#modal-ColunasVisiveis").on("show.bs.modal", function () {
  const cols = [];

  let colunasInvisiveis = JSON.parse(
    localStorage.getItem("colunasInvisiveisRelatorios")
  );

  $("#tabelaDados")
    .DataTable()
    .columns()
    .every(function () {
      cols.push({
        title: $(this.header()).text(),
        data: this.dataSrc(),
      });
    });
  adicionaColunas(cols, colunasInvisiveis.EscEnvio ?? []);
});

async function montaWherePesquisa() {
  let where = '';

  where += $('#cbConciliacao').is(':checked') ? ' AND INTEGRACAO_VENDAS.TIPO_SERV = 3' : $('#cbPagamento').is(':checked') ? ' AND INTEGRACAO_VENDAS.TIPO_SERV = 4' : $('#cbAntecipacao').is('checked') ? ' AND INTEGRACAO_VENDAS.TIPO_SERV = 6' : '';
  where += $('#cbConciliado').is(':checked') ? ` AND INTEGRACAO_VENDAS.CONCILIADO = 'S'` : $('#cbPendente').is(':checked') ? ` AND INTEGRACAO_VENDAS.CONCILIADO = 'N'` : '';
  where += $('#txtNSUConsulta').val() != '' ? ` AND INTEGRACAO_VENDAS.NSU = '${$('#txtNSUConsulta').val()}'` : '';
  where += $('#txtAutorizacaoConsulta').val() != '' ? ` AND INTEGRACAO_VENDAS.AUTORIZACAO = '${$('#txtAutorizacaoConsulta').val()}'` : '';

  return where;
}

async function montaGrupoByPesquisa() {
  let groupBy = [];

  groupBy = ["INTEGRACAO_VENDAS.CARTAO", "INTEGRACAO_VENDAS.ARQUIVO"];

  return groupBy;
}

async function montaLigacoesPesquisa() {
  let ligacao = '';
  if (!$('#cbAgrupaArquivo').is(':checked')) {
    ligacao = [{ "tabela": "(SELECT IT.ARQUIVO, COUNT(IT.NSU) TOT_REGISTROS,SUM(CASE WHEN (IT.CHAVE <> '') THEN 1 ELSE 0 END) TOT_CONCILIADO FROM [INTEGRACAO_VENDAS] IT GROUP BY IT.ARQUIVO)", tabelaSelect: "(SELECT IT.ARQUIVO, COUNT(IT.NSU) TOT_REGISTROS,SUM(CASE WHEN (IT.CHAVE <> '') THEN 1 ELSE 0 END) TOT_CONCILIADO FROM [INTEGRACAO_VENDAS] IT GROUP BY IT.ARQUIVO)", "condicao": "(TAB.ARQUIVO = INTEGRACAO_VENDAS.ARQUIVO)", alias: 'TAB' }]
  };
  return ligacao;
}

async function montaCamposSelect() {
  let camposSelect = [];
  let colunas = [];
  if ($('#cbAgrupaArquivo').is(':checked')) {
    camposSelect = ["INTEGRACAO_VENDAS.CARTAO", "INTEGRACAO_VENDAS.ARQUIVO", "COUNT(INTEGRACAO_VENDAS.NSU) TOT_REGISTROS", "SUM(CASE WHEN (((INTEGRACAO_VENDAS.CHAVE IS NOT NULL) OR (INTEGRACAO_VENDAS.CHAVE <> ''))) THEN 1 ELSE 0 END) TOT_CONCILIADO", "'N' ZEBRADO"];
    colunas = ["CARTAO", "ARQUIVO", "TOTAL_REGISTROS", "TOTAL_CONCILIADO", "ZEBRADO"];
  } else {
    camposSelect = ["DISTINCT INTEGRACAO_VENDAS.CARTAO", "INTEGRACAO_VENDAS.ARQUIVO", "INTEGRACAO_VENDAS.AUTORIZACAO", "INTEGRACAO_VENDAS.NSU", "INTEGRACAO_VENDAS.DATA", "INTEGRACAO_VENDAS.CHAVE", "INTEGRACAO_VENDAS.VALOR",
      "CASE WHEN ((INTEGRACAO_VENDAS.TIPO_SERV = 3) AND (INTEGRACAO_VENDAS.CHAVE <> '') THEN VENDA CONCILIADA",
      "WHEN ((INTEGRACAO_VENDAS.TIPO_SERV = 4) AND (INTEGRACAO_VENDAS.CHAVE <> '') THEN TITULO PAGO",
      "WHEN ((INTEGRACAO_VENDAS.TIPO_SERV = 6) AND (INTEGRACAO_VENDAS.CHAVE <> '') THEN ANTEC CONCILIADA",
      "ELSE NAO CONCILIADO END TIPO_SERV", "INTEGRACAO_VENDAS.CONCILIADO", "INTEGRACAO_VENDAS.DT_VENCTO", "TAB.TOT_REGISTROS", "TAB.TOT_CONCILIADO", "'N' ZEBRADO"
    ];
    colunas = ["CARTAO", "ARQUIVO", "AUTORIZACAO", "NSU", "DATA", "CHAVE",
      "VALOR", "TIPO_SERV", "CONCILIADO", "DT_VENCTO", "TOTAL_REGISTROS", "TOTAL_CONCILIADO", "ZEBRADO"];
  }

  return objeto = {
    camposSelect: camposSelect,
    colunas: colunas
  };
}

async function buscaDados(colunaOrdenacao = '') {
  if ($.fn.DataTable.isDataTable('#tabelaConsulta')) {
    $('#tabelaConsulta').DataTable().destroy();
    $('#tabelaConsulta').empty();
  };
  ultimaColunaOrdenada.nome = colunaOrdenacao.replaceAll(' ASC', '').replaceAll(' DESC', '');
  ultimaColunaOrdenada.ordenacao = colunaOrdenacao.indexOf(' ASC') > -1 ? 'ASC' : 'DESC';

  try {
    $.LoadingOverlay("show");

    const pesquisa = await montaPesquisa(colunaOrdenacao);

    $('#tabelaConsulta').DataTable({
      paging: true,
      lengthChange: true,
      filter: false,
      info: true,
      autoWidth: true,
      destroy: true,
      serverSide: true,
      processing: true,
      ajax: {
        url: `${getCookie('protocolo')}://${getCookie('ip_api')}/sisplan/funcoes/v1/pesquisadatatable`,
        type: "GET",
        headers: {
          'Authorization': BASIC_AUTH
        },
        data: {
          EMPRESA: getCookie('empresa'),
          JSON: encodeURIComponent(JSON.stringify(pesquisa.pesquisa)),
          CLIENTE: 'N'
        },
        dataSrc: function (data) {
          const cols = pesquisa.colunas;
          const array = data.data;
          // let arq = '';
          // let zebrado = true;
          return array.map(row => {
            return row.reduce((obj, value, index) => {
              // zebrado = arq != value ? !zebrado : zebrado;
              // arq = value;
              // value.ZEBRADO = zebrado ? 'S' : 'N';
              if (cols[index] == 'ARQUIVO') {
                obj[cols[index]] = value.replace(/\[BARRA\]/g, '/');
                return obj
              } else {
                obj[cols[index]] = value;
                return obj;
              }
            }, {});
          });
        }
      },
      "language": {
        "sEmptyTable": "Nenhuma consulta realizada",
        "sInfo": "_TOTAL_ registros",
        "sInfoEmpty": " 0 registros",
        "sInfoFiltered": "(Filtrados de _MAX_ registros)",
        "sInfoPostFix": "",
        "sInfoThousands": ".",
        "sLengthMenu": "_MENU_ resultados",
        "sLoadingRecords": "Carregando...",
        "sProcessing": "Processando...",
        "sZeroRecords": "Nenhuma consulta realizada",
        "sSearch": "Pesquisar",
        "oPaginate": {
          "sNext": "Próximo",
          "sPrevious": "Anterior",
          "sFirst": "Primeiro",
          "sLast": "Último"
        },
        "oAria": {
          "sSortAscending": ": Ordenar colunas de forma ascendente",
          "sSortDescending": ": Ordenar colunas de forma descendente"
        }
      },
      columns: columnsConsulta,
      colReorder: true,
    });

    const colunasInvisiveis = JSON.parse(localStorage.getItem('colunasInvisiveisRelatorios'));

    $('#tabelaConsulta_length').prepend('<button class="buttonColVis" id="buttonColVis"><i class="fas fa-cogs"></i></button>');
    $('#tabelaConsulta_length').prepend('<button class="buttonExcel" id="buttonExcel"><i class="fas fa-file-excel"></i></button>');

    $('#buttonColVis').prop('title', 'Configurar colunas visíveis');
    $('#buttonExcel').prop('title', 'Exportar');

    $('#buttonColVis').on('click', async function () {
      $.LoadingOverlay('show');
      $('#modal-ColunasVisiveis').modal('show');
      $.LoadingOverlay('hide');
    });

    $('#buttonExcel').on('click', async function () {
      const url = '/Sisplan/Funcoes/v1/pesquisa?';
      const pesquisa = await montaPesquisa();
      await exportaCSV(url, `JSON=${encodeURIComponent(JSON.stringify(pesquisa.pesquisa))}`, true, null, 'Relatório de Embarque', '#tabelaConsulta');
    })

    $('#tabelaConsulta').DataTable().columns().every(
      function () {
        if ((colunasInvisiveis.EscEnvio).indexOf(this.dataSrc()) != -1) {
          this.visible(false);
        }
      })

    $('#tabelaConsulta th').on('click', async function () {
      const nomeColuna = $(this).html();
      const novaOrdenacao = ultimaColunaOrdenada.ordenacao == 'ASC' ? 'DESC' : 'ASC';
      const ordenacao = ultimaColunaOrdenada.nome == nomeColuna ? novaOrdenacao : 'ASC';
      await buscaDados(nomeColuna + ' ' + ordenacao);
    });

  } catch (error) {
    console.error(error);
    msgErro('Não foi possível buscar os dados.');

  } finally {
    $.LoadingOverlay("hide");
    $('#modal-filtros').modal('hide');
  }
};

async function montaPesquisa() {
  const whereCompleto = await montaWherePesquisa();
  const ligacaoCompleta = await montaLigacoesPesquisa();
  const camposCompleto = await montaCamposSelect();
  const groupByCompleto = await montaGrupoByPesquisa();
  try {
    try {
      $.LoadingOverlay("show");
      let pesquisa = {};

      if ($('#cbAgrupaArquivo').is(':checked')) {
        pesquisa = {
          tabela: 'INTEGRACAO_VENDAS',
          camposSelect: camposCompleto.camposSelect,
          where: [`1=1 ${whereCompleto}`],
          groupBy: groupByCompleto,
          isArquivo: true
        }
      } else {
        pesquisa = {
          tabela: 'INTEGRACAO_VENDAS',
          camposSelect: camposCompleto.camposSelect,
          leftjoin: ligacaoCompleta,
          where: [`1=1 ${whereCompleto}`],
          isArquivo: true
        }
      }

      return {
        pesquisa: pesquisa,
        colunas: camposCompleto.colunas
      }

    } catch (error) {
      console.error(error);
      msgErro('Não foi possível buscar os dados.');
    }
  } finally {
    $.LoadingOverlay("hide");
    $('#modal-filtros').modal('hide');
  }
}