function validarCaracteres(value) {
    const result = value.match(/[&\/\\#,+()$~%.'":*?<>{}´`]/g);
    return result?.length ?? 0;
}

$(document).ready(async function () {

    let contaFs = 1;

    $(".next").click(function () {
        contaFs += 1;

        let validator = $("#msform").validate();
        validator.form();
        let erros = 0;
        erros = validator.numberOfInvalids();

        if (erros == 0) {
            currentFs = $(this).parent();
            nextFs = $(this).parent().next();

            $("#progressbar li").eq($(".abas").index(nextFs)).addClass("active");

            nextFs.show();
            currentFs.animate(
                {
                    opacity: 0,
                },
                {
                    step(now) {
                        opacity = 1 - now;

                        currentFs.css({
                            display: "none",
                            position: "relative",
                        });
                        nextFs.css({
                            opacity,
                        });
                    },
                    duration: 600,
                }
            );
        }
    });

    $(".previous").click(function () {
        contaFs -= 1;

        currentFs = $(this).parent();
        previousFs = $(this).parent().prev();
        $("#progressbar li")
            .eq($(".abas").index(currentFs))
            .removeClass("active");
        previousFs.show();
        currentFs.animate(
            {
                opacity: 0,
            },
            {
                step(now) {
                    opacity = 1 - now;
                    currentFs.css({
                        display: "none",
                        position: "relative",
                    });
                    previousFs.css({
                        opacity,
                    });
                },
                duration: 600,
            }
        );
    });

    if (getCookie("usuario") == "") {
        window.location.href = `${BASE_URI}/login`;
        return;
    }

    $('#account').on('click', function () {
        if (contaFs == 2) {
            $('#voltar2').trigger('click');
        }
    });

    $('#confirm').on('click', function () {
        if (contaFs == 1) {
            $('#verBaixas').trigger('click');
        }
    });

    componenteFiltro('banco', false, false);
    componenteFiltro('carteira');
    componenteFiltro('classeBaixa', false, false);
    componenteFiltro('classeJuros', false, false);
    componenteFiltro('classeDesconto', false, false);
    componenteFiltro('historico', false, false);
    componenteFiltro('conta', false, false);
    componenteFiltro('conta', false, false, 'ContaAlterarConta');

    $('#txtBanco').on('blur', async function () {
        try {
            if ($('#txtBanco').val() == '') {
                return;
            }
            $.LoadingOverlay('show');

            let tabelaBanco = 'CADBAN';

            if (await Existe('CADBAN_CONF', ['BANCO', 'EMP_ID'], [pegaChave('#txtBanco'), getCookie('emp_id')])) {
                tabelaBanco = 'CADBAN_CONF';
            }

            await preencheCaminhos(tabelaBanco);
            await preencheHistorico();

            const result = await buscaValor(tabelaBanco, 'SOMA_TARIFA, INTEGRA_ENVIO', 'BANCO', pegaChave('#txtBanco'));

            if (result != '' && result != undefined && result != null) {
                $('#cbSomarTarifa').prop('checked', result.SOMA_TARIFA == 'S');
                $('#cbPossuiIntegracao').prop('checked', result.INTEGRA_ENVIO == 'S');
            }

        } finally {
            $.LoadingOverlay('hide');
        }
    })

    $('#txtCarteira').on('blur', async function () {
        try {
            $.LoadingOverlay('show');

            if ($('#txtBanco').val() != '') {
                await preencheConta();
            } else {
                await buscaDadosCarteira();
            }

        } finally {
            $.LoadingOverlay('hide');
        }
    })

    $('#cbAlterarBanco').on('change', function () {
        if ($('#cbAlterarBanco').prop('checked') == true) {
            $('#divAlterarBanco').removeClass('d-none');
        } else {
            $('#divAlterarBanco').addClass('d-none');
        }
    });

    await definePadraoTela()

    async function definePadraoTela() {
        const carteiraRegistro = await carregaValoresPadroes('CARTEIRA_REGISTRO')
        $('#cbCarteiraRegistro').prop('checked', carteiraRegistro)
    }

    async function carregaValoresPadroes() {
        try {
            const pesquisa = {
                camposSelect: ['CAMPO', 'VALOR'],
                tabela: 'TABPADRAO',
                where: [`TABELA = 'RETORNO'`]
            }
            const jsonStr = await retornaJsonPesquisaPadrao(JSON.stringify(pesquisa));

            jsonStr.map(async item => {
                switch (item.CAMPO) {
                    case 'CARTEIRA_REGISTRO': {
                        $('#cbCarteiraRegistro').prop('checked', item.VALOR == 'S')
                        break;
                    }
                    case 'CARTEIRA': {
                        const registroValido = await buscaValor('CARTEIRA', 'CARTEIRA, DESCRICAO', 'CARTEIRA', item.VALOR)
                        if (registroValido && registroValido.CARTEIRA != '') {
                            insereValor('#txtCarteira', item.VALOR, registroValido.DESCRICAO);
                        }
                        $('#txtCarteira').trigger('blur')
                        break;
                    }
                    case 'CLASSE_BAIXA': {
                        const registroValido = await buscaValor('CLASSE_GER', 'CODIGO, DESCRICAO', 'CODIGO', item.VALOR)
                        if (registroValido && registroValido.CODIGO != '') {
                            insereValor('#txtClasseBaixa', item.VALOR, registroValido.DESCRICAO);
                        }
                        break;
                    }
                    case 'CLASSE_JUROS': {
                        const registroValido = await buscaValor('CLASSE_GER', 'CODIGO, DESCRICAO', 'CODIGO', item.VALOR)
                        if (registroValido && registroValido.CODIGO != '') {
                            insereValor('#txtClasseJuros', item.VALOR, registroValido.DESCRICAO);
                        }
                        break;
                    }
                    case 'CLASSE_DESCONTO': {
                        const registroValido = await buscaValor('CLASSE_GER', 'CODIGO, DESCRICAO', 'CODIGO', item.VALOR)
                        if (registroValido && registroValido.CODIGO != '') {
                            insereValor('#txtClasseDesconto', item.VALOR, registroValido.DESCRICAO);
                        }
                        break;
                    }
                    case 'HISTORICO': {
                        const registroValido = await buscaValor('HISTCP', 'HISTORICO, DESCRICAO', 'HISTORICO', item.VALOR)
                        if (registroValido && registroValido.CODIGO != '') {
                            insereValor('#txtHistorico', item.VALOR, registroValido.DESCRICAO);
                        }
                        break;
                    }
                    default:
                        break;
                }
            });
        } catch (e) {
            console.log(e);
            msgErro(`Não foi possível buscar os valores padrões.`)
        }
    };


    function criaTabelaRetorno() {

        function retornaBotaoSel(meta, data) {
            let marcado = '';
            if (data == 'S') {
                marcado = 'checked';
            }

            return `<div class="icheck-primary">
                                      <input type="checkbox" ${marcado} id="check_col_${meta.col}_row_${meta.row}" class="campoSel">
                                      <label for="check_col_${meta.col}_row_${meta.row}"></label>
                                </div>`

        };

        const cols = [
            {
                title: `<div class="form-group icheck-primary col-1 m-0 p-0" id="containerSelTodos">
                            <input type="checkbox" class="input-default focus form-control validate" id="cbSelecionarTodos" name="cbSelecionarTodos">
                            <label for="cbSelecionarTodos">Sel</label>
                        </div>`,
                data: `SEL`
            },
            {
                title: 'Nota_F',
                data: 'FATURA'
            },
            {
                title: 'Bordero',
                data: 'BORDERO'
            },
            {
                title: 'Número',
                data: 'NUMERO'
            },
            {
                title: 'Data Vencimento',
                data: 'DT_VENCTO'
            },
            {
                title: 'Data Contabilização',
                data: 'DT_CONT'
            },
            {
                title: 'Valor',
                data: 'VALOR'
            },
            {
                title: 'Valor Pago',
                data: 'VALOR_PAGO'
            },
            {
                title: 'Juro',
                data: 'JURO'
            },
            {
                title: 'Acréscimo',
                data: 'ACRESCIMO'
            },
            {
                title: 'Valor Antec.',
                data: 'VALOR_ANTEC'
            },
            {
                title: 'Desconto',
                data: 'DESCONTO'
            },
            {
                title: 'Desconto Programado',
                data: 'DESC_PROGRAMADO'
            },
            {
                title: 'Status',
                data: 'STATUS'
            },
            {
                title: 'Cliente',
                data: 'NOME'
            },
            {
                title: 'Codcli',
                data: 'CODCLI'
            },
            {
                title: 'Código Ocorrência',
                data: 'COD_OCORRENCIA'
            },
            {
                title: 'Desc. Ocorrência',
                data: 'DESC_OCORRENCIA'
            },
            {
                title: 'Nr. Banco',
                data: 'NR_BANCO'
            },
            {
                title: 'Nome Banco',
                data: 'NOME_BANCO'
            },
            {
                title: 'Altera Vencimento',
                data: 'ALTERA_VENCTO'
            },
            {
                title: 'Juro_calc',
                data: 'JURO_CALC'
            },
            {
                title: 'Juro_desc',
                data: 'JURO_DESC'
            },
            {
                title: 'Taxa',
                data: 'TAXA'
            },
            {
                title: 'Tarifa',
                data: 'TARIFA'
            },
            {
                title: 'Despesa',
                data: 'DESPESA'
            },
            {
                title: 'IOF',
                data: 'IOF'
            },
            {
                title: 'Data',
                data: 'DATA'
            },
            {
                title: 'Banco',
                data: 'BANCO'
            },
            {
                title: 'Conta',
                data: 'CONTA'
            },
            {
                title: 'Conta Cont. Juros',
                data: 'CONTACONT_JUROS'
            },
            {
                title: 'Carteira',
                data: 'CARTEIRA'
            },
            {
                title: 'Comp_cart',
                data: 'COMP_CART'
            },
            {
                title: 'Situação',
                data: 'SITUACAO'
            },
            {
                title: 'Classe',
                data: 'CLASSE'
            },
            {
                title: 'Arquivo',
                data: 'ARQUIVO'
            },
            {
                title: 'Ordem',
                data: 'ORDEM'
            },
            {
                title: 'Emp',
                data: 'EMP'
            },
            {
                title: 'Rej',
                data: 'REJEITA'
            },
            {
                title: 'Cód. Rejeição',
                data: 'COD_REJEICAO'
            },
            {
                title: 'Desc. Rejeição',
                data: 'DESC_REJEICAO'
            },
            {
                title: 'Baixada',
                data: 'BAIXADA'
            },
            {
                title: 'Valida',
                data: 'VALIDA'
            },
            {
                title: 'Código Liquidação',
                data: 'COD_LIQUIDACAO'
            },
            {
                title: 'Situação Duplicata',
                data: 'SIT_DUP'
            },
            {
                title: 'Desc. Situação Duplicata',
                data: 'DESC_SIT_DUP'
            },
            {
                title: 'Gera ContaCor',
                data: 'GERA_CONTACOR'
            },
            {
                title: 'Emp_id',
                data: 'EMP_ID'
            },
            {
                title: 'Duplicado',
                data: 'DUPLICADO'
            },
            {
                title: 'Credita_CC',
                data: 'CREDITA_CC'
            },
            {
                title: 'Debita_CC',
                data: 'DEBITA_CC'
            },
            {
                title: 'Id Integra',
                data: 'ID_INTEGRA'
            },
            {
                title: 'Obs',
                data: 'OBS'
            },
            {
                title: 'Classe_capa',
                data: 'CLASSE_CAPA'
            },
            {
                title: 'Bolecode',
                data: 'BOLECODE'
            }
        ];

        try {
            $('#tabelaRetorno').DataTable({
                paging: false,
                lengthChange: false,
                info: false,
                order: [[16, 'asc'], [31, 'asc'], [3, 'asc']],
                destroy: true,
                autowidth: true,
                columnDefs: [
                    {
                        targets: [0],
                        render: function (data, type, row, meta) {
                            return retornaBotaoSel(meta, data);
                        }
                    },
                    {
                        type: 'date-br',
                        targets: [4, 5, 27],
                        render(data) {
                            if (data) {
                                return new Intl.DateTimeFormat('pt-BR').format(new Date(`${data.split(' ')[0]} 23:59:59`));
                            } else {
                                return '';
                            }

                        },
                    },
                    {
                        targets: [6, 7, 8, 9, 10, 11, 12, 21, 22, 23, 24, 25, 26, 27, 49, 50],
                        render: function (data) {
                            return parseFloat(data).toLocaleString("pt-br", {
                                maximumFractionDigits: 2,
                                minimumFractionDigits: 2,
                            });
                        },
                    }
                ],
                rowCallback: async function (row, data) {
                    $(row).css('color', 'white');
                    if ((data.VALOR != data.VALOR_PAGO) && (data.VALOR_PAGO > 0)) {
                        $(row).css('background-color', '#90ee90');
                        $(row).css('color', 'black');
                    }
                    if (data.DESCONTO > 0) {
                        $(row).css('background-color', '#EDEC3E');
                        $(row).css('color', 'black');
                    }
                    if (data.REJEITA == 'S') {
                        $(row).css('background-color', '#F46262');
                        $(row).css('color', 'black');
                    }
                    if (data.STATUS == 'CANC') {
                        $(row).css('color', 'white');
                        $(row).css('background-color', '#3C67B0');
                        $(row.cells[3]).css('background-color', '#63bec8');
                        $(row.cells[3]).css('color', 'black');
                    }
                    if (data.STATUS == 'DESD' || data.STATUS == 'AGRU') {
                        $(row).css('background-color', '#8C8C8C');
                        $(row).css('color', 'black');
                    }
                    if (data.DUPLICADO == 'S') {
                        $(row.cells[3]).css('background-color', '#63bec8');
                        $(row.cells[3]).css('color', 'black');
                    }

                    if (localStorage.getItem('theme') == 'theme-dark') {
                        $(row.cells[0]).css('background-color', '#1d2729');
                    } else {
                        $(row.cells[0]).css('background-color', '#ffffff');
                    }
                    $(`#check_col_0_row_${row._DT_RowIndex}`).off('change');

                    $(`#check_col_0_row_${row._DT_RowIndex}`).on('change', function () {
                        let indice = (this.id).split('_')[4];
                        let d = $('#tabelaRetorno').DataTable().row(indice).data();

                        if ($(this).prop('checked')) {
                            d.SEL = 'S';
                        } else {
                            d.SEL = 'N';
                        }

                        $('#tabelaRetorno').DataTable().row(indice).data(d).draw(false);
                    })
                },

                "language": {
                    "sEmptyTable": "Nenhum registro encontrado",
                    "sInfo": "_TOTAL_ registros",
                    "sInfoEmpty": " 0 registros",
                    "sInfoFiltered": "(Filtrados de _MAX_ registros)",
                    "sInfoPostFix": "",
                    "sInfoThousands": ".",
                    "sLengthMenu": "_MENU_ resultados",
                    "sLoadingRecords": "Carregando...",
                    "sProcessing": "Processando...",
                    "sZeroRecords": "Nenhum registro encontrado",
                    "sSearch": "Pesquisar",
                    "oPaginate": {
                        "sNext": "Próximo",
                        "sPrevious": "Anterior",
                        "sFirst": "Primeiro",
                        "sLast": "Último"
                    },
                    "oAria": {
                        "sSortAscending": ": Ordenar colunas de forma ascendente",
                        "sSortDescending": ": Ordenar colunas de forma descendente"
                    }
                },
                columns: cols
            });

            $('#tabelaRetorno_filter').addClass('d-none');

            $('#cbSelecionarTodos').on('change', function () {
                $.LoadingOverlay('show');
                if (localStorage.getItem('theme') == 'theme-dark') {
                    $('#tabelaRetorno tr td:nth-child(1)').css('background-color', '#1d2729');
                    $('#tabelaRetorno tbody tr').each(function () {
                        if (($(this)[0].style.backgroundColor == 'rgb(0, 0, 0)') || ($(this)[0].style.backgroundColor == '')) {
                            $(this)[0].style.color = 'rgb(255, 255, 255)';
                        }
                    })
                } else {
                    $('#tabelaRetorno tr td:nth-child(1)').css('background-color', '#ffffff');
                    $('#tabelaRetorno tbody tr').each(function () {
                        if (($(this)[0].style.backgroundColor == 'rgb(255, 255, 255)') || ($(this)[0].style.backgroundColor == '')) {
                            $(this)[0].style.color = 'rgb(0, 0, 0)';
                        }
                    })
                }

                if ($('#cbSelecionarTodos').prop('checked')) {
                    $('.campoSel').prop('checked', true);
                } else {
                    $('.campoSel').prop('checked', false);
                }

                $('.campoSel').trigger('change');
                $.LoadingOverlay('hide');
            })

            $('#tabelaRetorno thead th').each(function () {
                $(this)[0].style.verticalAlign = 'middle';
            })
        } catch (e) {
            console.log(e);
        }
    }

    $('#theme-slider').on('change', function () {
        if (localStorage.getItem('theme') == 'theme-dark') {
            $('#tabelaRetorno tr td:nth-child(1)').css('background-color', '#1d2729');
            $('#tabelaRetorno tbody tr').each(function () {
                if (($(this)[0].style.backgroundColor == 'rgb(0, 0, 0)') || ($(this)[0].style.backgroundColor == '')) {
                    $(this)[0].style.color = 'rgb(255, 255, 255)';
                }
            })
        } else {
            $('#tabelaRetorno tr td:nth-child(1)').css('background-color', '#ffffff');
            $('#tabelaRetorno tbody tr').each(function () {
                if (($(this)[0].style.backgroundColor == 'rgb(255, 255, 255)') || ($(this)[0].style.backgroundColor == '')) {
                    $(this)[0].style.color = 'rgb(0, 0, 0)';
                }
            })
        }
    })

    $('#btnCheckSaldo').on('click', function () {
        let dSel = $('#tabelaSelDupli').DataTable().row($('#tabelaSelDupli').DataTable().$('tr.selected')[0]).data();
        // let valor = parseFloat(dSel.VALOR_PAGO) - parseFloat(dSel.JUROS);
        let valor = parseFloat(dSel.VALOR_PAGO - dSel.JUROS).toLocaleString("pt-br", {
            maximumFractionDigits: 2,
            minimumFractionDigits: 2,
        });

        $('#txtSaldoSelDupli').val(valor);
        $('#txtSaldoSelDupli').trigger('input');
    })

    async function preencheHistorico() {
        try {
            const response = await requisicao('GET', '/Sisplan/Funcoes/v1/pesquisa?',
                `JSON={ "tabela":"OCORRENCIA",
                        "camposSelect":["OCORRENCIA.HISTORICO", "HISTCP.DESCRICAO"],
                        "leftjoin": [{"tabela": "HISTCP", "condicao": "OCORRENCIA.HISTORICO = HISTCP.HISTORICO"}],
                        "where": ["OCORRENCIA.BANCO = '${pegaChave('#txtBanco')}'"]}`,
            )

            if (!response) {
                return;
            }

            let jsonStr = await response.json();
            if (response.status != 200) {
                msgErro(jsonStr.RESULT[0].mensagem);
                return;
            }

            const data = jsonStr.RESULT[0];

            if (data.length == 0) {
                return;
            } else {
                insereValor('#txtHistorico', data[0].HISTORICO, data[0].DESCRICAO);
            }

        } catch (e) {
            console.log(e);
        }
    }

    async function preencheCaminhos(tabelaBanco) {
        try {

            let where = `BANCO = '${pegaChave('#txtBanco')}'`;

            if (tabelaBanco != 'CADBAN') {
                where += ` AND EMP_ID = ${getCookie('emp_id')}`;
            }

            let arrayWhere = ['BANCO'];
            let arrayValores = [pegaChave('#txtBanco')];

            if (tabelaBanco != 'CADBAN') {
                arrayWhere.push('EMP_ID');
                arrayValores.push(getCookie('emp_id'));
            };

            let caminho = await buscaCaminho(tabelaBanco, ['ENTRADA', 'ENTRADA_LIDO'], arrayWhere, arrayValores)

            $('#txtArquivo').val(caminho[0]);
            $('#txtCaminhoLido').val(caminho[1]);
        } catch (e) {
            console.log(e);
        }
    }

    async function preencheConta() {
        try {

            const response = await requisicao('GET', '/Sisplan/Funcoes/v1/pesquisa?',
                `JSON={ "tabela":"CARTEIRA",
                        "camposSelect":["CARTEIRA.DESCRICAO", "CARTEIRA.CONTA", "CADCONTA.DESCRICAO DESC_CONTA"],
                        "leftjoin": [{"tabela": "CADCONTA", "condicao": "CARTEIRA.CONTA = CADCONTA.CONTA"}],
                        "where": ["EXISTS (SELECT C.CONTA FROM [CADCONTA] C WHERE C.BANCO = '${pegaChave('#txtBanco')}' AND CARTEIRA.CONTA = C.CONTA)", "CARTEIRA.CARTEIRA = '${pegaChave('#txtCarteira')}'"]}`,
            )

            if (!response) {
                return;
            }

            let jsonStr = await response.json();
            if (response.status != 200) {
                msgErro(jsonStr.RESULT[0].mensagem);
                return;
            }

            const data = jsonStr.RESULT[0];

            if (data.length > 0) {
                if (data[0].CONTA != '') {
                    insereValor('#txtConta', data[0].CONTA, data[0].DESC_CONTA);
                }
            } else {
                await buscaDadosCarteira();
            }



        } catch (e) {
            console.log(e);
        }
    }

    async function buscaDadosCarteira() {
        try {
            const response = await requisicao('GET', '/Sisplan/Funcoes/v1/pesquisa?',
                `JSON={ "tabela":"CARTEIRA",
                        "camposSelect":["CARTEIRA.CONTA", "CADCONTA.DESCRICAO DESC_CONTA"],
                        "leftjoin": [{"tabela": "CADCONTA", "condicao": "CARTEIRA.CONTA = CADCONTA.CONTA"}],
                        "where": ["CARTEIRA.CARTEIRA = '${pegaChave('#txtCarteira')}'"]}`,
            )

            if (!response) {
                return;
            }

            let jsonStr = await response.json();
            if (response.status != 200) {
                msgErro(jsonStr.RESULT[0].mensagem);
                return;
            }

            const data = jsonStr.RESULT[0];

            if (data.length == 0) {
                return;
            }

            insereValor('#txtConta', data[0].CONTA, data[0].DESC_CONTA);
        } catch (e) {
            console.log(e);
        }
    }

    $(async function () {
        let idCampo = '';
        var modalUploadAnexos = $("#mdModalUpload");
        var Anexo = $('#txtArquivo');
        var BotaoAnexo = $("#btnArquivo");
        BotaoAnexo.click(function (e) {
            e.preventDefault();
            modalUploadAnexos.click();
        });

        modalUploadAnexos.change(async function () {
            var NomeAnexo = $(this).val().split('\\')[$(this).val().split('\\').length - 1];
            Anexo.val(NomeAnexo);

            let file = document.querySelector('input[type=file]').files[0];
            let reader = new FileReader();

            reader.onload = function (e) {
                $('#fileContent').text(e.target.result);
            }

            reader.readAsText(file);

        });
    });

    // $('#voltar1').on('click', function () {
    //     msgAlerta('Tem certeza que deseja cancelar o procedimento?', () => {
    //         window.location.href = `${BASE_URI}/index.php`
    //     })
    // })

    $('#verBaixas').on('click', async function () {
        if (!$.fn.DataTable.isDataTable('#tabelaRetorno')) {
            await criaTabelaRetorno();
        }

        if ($('#tabelaRetorno').DataTable().data().length == 0) {
            try {
                $.LoadingOverlay('show');

                if ($('#txtArquivo').val() == '') {
                    throw msgErro('Arquivo não pode ser vazio, favor verificar.');
                }

                if (await Existe('RECEBER', ['NUMERO'], [''])) {
                    throw msgErro('Existe uma duplicata sem número, impossível continuar.');
                }

                if (!$('#cbPossuiIntegracao').prop('checked')) {
                    let arq = (($('#fileContent').text()).replaceAll(',', '')).split('\n');
                    if (arq.length == 0) {
                        throw msgErro('Arquivo sem movimento, impossível continuar.');
                    }

                    for (let i = 0; i < arq.length; i++) {
                        if (arq[i] == '' || arq[i] == null || arq[i] == undefined) {
                            arq.splice(i, 1);
                        }
                    }

                    await iniciaLeitura(arq);
                } else {
                    let obj = retornaObjInfo();

                    let response = await requisicao("POST", `/Sisplan/escretorno/V1/consultacomintegracao?&CODUSUARIO=${getCookie('cod_usuario')}`, `&EMPRESA=${getCookie('empresa')}`, `&JSON=${encodeURIComponent(JSON.stringify(obj))}`);

                    if (response.status != 200) {
                        return;
                    }

                    let dadosRetorno = await response.json();
                    if (response.status != 200) {
                        msgErro(dadosRetorno.mensagem);
                        return;
                    }

                    if (dadosRetorno.length == 0) {
                        msgErro('Nenhum registro encontrado.')
                        return;
                    }
                }

                $('#tabelaRetorno').DataTable().rows().every(function () {
                    let data = this.data();
                    data.VALIDA = 'S';

                    if ((data.STATUS == 'DESD') || (data.STATUS == 'AGRU')) {
                        if (data.VALOR_PAGO > 0) {
                            data.VALIDA = 'N';
                        }
                    }

                    this.data(data).draw(false);
                })

            } finally {
                $.LoadingOverlay('hide');
            }
        }
    });

    $('#imprimirDados').on('click', async function () {
        try {
            $.LoadingOverlay("show");
            try {
                let Grid = buscaDadosTabela();
                const url = `/sisplan/impressao/v1/imprimirescretorno?`;
                const bImprimeAutomatico = await verificaImprimirAutomatico('CobrancaRetorno');
                const arquivo = await GeraRelatorio(`${url}`, "POST", 100000, false, 'CobrancaRetorno', `JSON=${JSON.stringify(Grid)}`);

                if (arquivo != undefined) {
                    if (!bImprimeAutomatico) {
                        window.open(`${BASE_URI}/relatorios_api/pdf/${arquivo}`, "_blank");
                    }
                    await limparRelatorios();
                }
            } catch (error) {
                console.error(error);
            }
        } finally {
            $.LoadingOverlay("hide");
        }
    });


    function buscaDadosTabela() {
        const tabelaRetorno = $('#tabelaRetorno').DataTable().rows().data().toArray();
        let retorno = tabelaRetorno.map((item) => ({
            ACRESCIMO: item.ACRESCIMO,
            ALTERA_VENCTO: item.ALTERA_VENCTO,
            ARQUIVO: item.ARQUIVO,
            BAIXADA: item.BAIXADA,
            BANCO: item.BANCO,
            BOLECODE: item.BOLECODE,
            BORDERO: item.BORDERO,
            CARTEIRA: item.CARTEIRA,
            CLASSE: item.CLASSE,
            CLASSE_CAPA: item.CLASSE_CAPA,
            CODCLI: item.CODCLI,
            COD_LIQUIDACAO: item.COD_LIQUIDACAO,
            COD_OCORRENCIA: item.COD_OCORRENCIA,
            COD_REJEICAO: item.COD_REJEICAO,
            COMP_CART: item.COMP_CART,
            CONTA: item.CONTA,
            CONTACONT_JUROS: item.CONTACONT_JUROS,
            CREDITA_CC: item.CREDITA_CC,
            DATA: item.DATA,
            DEBITA_CC: item.DEBITA_CC,
            DESCONTO: item.DESCONTO,
            DESC_OCORRENCIA: item.DESC_OCORRENCIA,
            DESC_PROGRAMADO: item.DESC_PROGRAMADO,
            DESC_REJEICAO: item.DESC_REJEICAO,
            DESC_SIT_DUP: item.DESC_SIT_DUP,
            DESPESA: item.DESPESA,
            DT_CONT: item.DT_CONT,
            DT_VENCTO: item.DT_VENCTO,
            DUPLICADO: item.DUPLICADO,
            EMP: item.EMP,
            EMP_ID: item.EMP_ID,
            FATURA: item.FATURA,
            GERA_CONTACOR: item.GERA_CONTACOR,
            ID_INTEGRA: item.ID_INTEGRA,
            IOF: item.IOF,
            JURO: item.JURO,
            JURO_CALC: item.JURO_CALC,
            JURO_DESC: item.JURO_DESC,
            NOME: item.NOME,
            NOME_BANCO: item.NOME_BANCO,
            NR_BANCO: item.NR_BANCO,
            NUMERO: item.NUMERO,
            OBS: item.OBS,
            ORDEM: item.ORDEM,
            REJEITA: item.REJEITA,
            SEL: item.SEL,
            SITUACAO: item.SITUACAO,
            SIT_DUP: item.SIT_DUP,
            STATUS: item.STATUS,
            TARIFA: item.TARIFA,
            TAXA: item.TAXA,
            VALIDA: item.VALIDA,
            VALOR: item.VALOR,
            VALOR_ANTEC: item.VALOR_ANTEC,
            VALOR_PAGO: item.VALOR_PAGO,
        }));


        return retorno;
    }

    async function iniciaLeitura(arq) {

        let ocultaOcorrencia = '';
        let linhaSel = {};
        let modoConsulta = 2;
        let v1;
        let v2;
        let conta = '';

        if ($('#txtCarteira').val() != '' && await verificaCarteira240Pos(pegaChave('#txtCarteira'))) {
            modoConsulta = 1;
        }

        for (let i = 0; modoConsulta != 1 ? i <= arq.length - 2 : i < arq.length - 2; i++) {
            try {

                let linha = retornaObjInfo();

                linha.INDICE = i;
                linha.ARQUIVO = arq;
                linha.TIPOCONSULTA = modoConsulta;

                let response = await requisicao("POST", `/Sisplan/escretorno/V1/lelinhaarquivo?&CODUSUARIO=${getCookie('cod_usuario')}`, `&EMP_ID=${getCookie('emp_id')}&EMPRESA=${getCookie('empresa')}&CONTA=${conta}`, `&JSON=${encodeURIComponent(JSON.stringify(linha))}`);

                if (response.status != 200) {
                    return;
                }

                let jsonStr = await response.json();
                if (response.status != 200) {
                    msgErro(jsonStr.mensagem);
                    return;
                }
                conta = jsonStr.conta

                let dataRetorno = [];
                if (jsonStr.tbRetorno != '') {
                    dataRetorno = JSON.parse(jsonStr.tbRetorno)
                }

                if (dataRetorno.length > 0) {

                    dadosRetorno = dataRetorno[0];

                    if (dadosRetorno.SOMA_INDICE == 'S') {
                        i += 1;
                    }

                    if ((dadosRetorno.CAMPOS_NCONFIG != '') && (linha.VALIDARCAMPOS)) {
                        await abreModalCampos(`Campos não configurados: ${dadosRetorno.CAMPOS_NCONFIG}`);
                    }

                    let wherePesquisa = `"CODIGO = '${dadosRetorno.COD_OCORRENCIA}'", "BANCO = '${linha.BANCO}'", "CARTEIRA = '${dadosRetorno.CARTEIRA}'", "TIPO = 'E'"`;

                    if (await buscaValor('OCORRENCIA', 'CONTA', `BANCO = '${linha.BANCO}' AND CARTEIRA = '${dadosRetorno.CARTEIRA}' AND CODIGO = '${dadosRetorno.COD_OCORRENCIA}' AND CONTA`, dadosRetorno.CONTA) != undefined) {
                        wherePesquisa += `, "CONTA = '${dadosRetorno.CONTA}'"`;
                    }

                    response = await requisicao('GET', '/Sisplan/Funcoes/v1/pesquisa?',
                        `JSON={ "tabela":"OCORRENCIA",
                    "camposSelect":["DESCRICAO", "SITUACAO", "HISTORICO", "REJEITA", "OCULTA_OCORRENCIA"],
                    "where": [${wherePesquisa}]}`,
                    )

                    if (!response) {
                        return;
                    }

                    let dados = await response.json();
                    if (response.status != 200) {
                        msgErro(dados.RESULT[0].mensagem);
                        return;
                    }

                    dados = dados.RESULT[0];

                    if (dados.length > 0) {
                        dadosRetorno.SITUACAO = dados[0].SITUACAO;
                        dadosRetorno.DESC_OCORRENCIA = dados[0].DESCRICAO;
                        dadosRetorno.CLASSE = dados[0].HISTORICO;
                        dadosRetorno.REJEITA = dados[0].REJEITA;
                        ocultaOcorrencia = dados[0].OCULTA_OCORRENCIA;
                    }

                    if (dadosRetorno.CLASSE != '') {
                        dadosRetorno.CLASSE = pegaChave('#txtHistorico');
                    }

                    if (modoConsulta == 1) {
                        response = await requisicao('GET', `/Sisplan/escretorno/v1/dadosduplicata?&EMPRESA=${getCookie('empresa')}&MODO=${1}&NRBANCO=${dadosRetorno.NR_BANCO}&NRBANCO2=${dadosRetorno.NR_BANCO2}&NUMERO=${dadosRetorno.NUMERO}&TIPO=${linha.INSTRUCAO}&CONTA=${dadosRetorno.CONTA}&TODAS_EMPRESAS=${linha.TODASEMPRESAS}&`)
                    } else {
                        response = await requisicao('GET', `/Sisplan/escretorno/v1/dadosduplicata3?&EMPRESA=${getCookie('empresa')}&EMPID=${getCookie('emp_id')}&NRBANCO=${dadosRetorno.NR_BANCO}&BANCO=${linha.BANCO}&CONTA=${dadosRetorno.CONTA}&NUMERO=${dadosRetorno.NUMERO}&TIPO=${linha.INSTRUCAO}&TODAS_EMPRESAS=${linha.TODASEMPRESAS}&`)
                    }

                    if (!response) {
                        return;
                    }

                    let dadosDuplicata = await response.json();
                    if (response.status != 200) {
                        msgErro(dadosDuplicata.mensagem);
                        return;
                    }
                    if (dadosDuplicata[0].REFAZ_CONSULTA == 'N') {
                        dadosRetorno.NUMERO = dadosDuplicata[0].NUMERO_AUX;
                        linhaSel.NUMERO = dadosDuplicata[0].NUMERO;
                        linhaSel.NOME = dadosDuplicata[0].NOME;
                        linhaSel.CODCLI = dadosDuplicata[0].CODCLI;
                        linhaSel.STATUS = dadosDuplicata[0].STATUS;
                        linhaSel.VALOR2 = dadosDuplicata[0].VALOR2;
                        linhaSel.VALOR_PAGO = dadosDuplicata[0].VALOR_PAGO;
                        linhaSel.DT_VENCTO = dadosDuplicata[0].DT_VENCTO;
                        linhaSel.TAXA = dadosDuplicata[0].TAXA;
                        linhaSel.FATURA = dadosDuplicata[0].FATURA;
                        linhaSel.NRBANCO = dadosDuplicata[0].NRBANCO;
                        linhaSel.EMP = dadosDuplicata[0].EMP;
                        linhaSel.DESC_PROGRAMADO = dadosDuplicata[0].DESC_PROGRAMADO;
                        linhaSel.SIT_DUP = dadosDuplicata[0].SIT_DUP;
                        linhaSel.DESC_SIT_DUP = dadosDuplicata[0].DESC_SIT_DUP;
                        linhaSel.GERA_CONTACOR = dadosDuplicata[0].GERA_CONTACOR;
                        linhaSel.EMP_ID = dadosDuplicata[0].EMP_ID;
                        linhaSel.CLASSE = dadosDuplicata[0].CLASSE;
                        linhaSel.JUROS = dadosDuplicata[0].JUROS;
                        linhaSel.BORDERO = dadosDuplicata[0].BORDERO;
                    } else {
                        linhaSel.NUMERO = dadosRetorno.NUMERO;
                        dadosRetorno.NUMERO = dadosDuplicata[0].NUMERO_AUX;
                        linhaSel.NOME = dadosRetorno.NOME;
                        linhaSel.CODCLI = dadosRetorno.CODCLI;
                        linhaSel.STATUS = dadosRetorno.STATUS;
                        linhaSel.VALOR2 = dadosRetorno.VALOR;
                        linhaSel.VALOR_PAGO = dadosRetorno.VALOR_PAGO;
                        linhaSel.DT_VENCTO = dadosRetorno.DT_VENCTO;
                        linhaSel.TAXA = dadosRetorno.TAXA;
                        linhaSel.FATURA = dadosRetorno.FATURA;
                        linhaSel.NRBANCO = dadosRetorno.NR_BANCO;
                        linhaSel.EMP = dadosRetorno.EMP;
                        linhaSel.DESC_PROGRAMADO = dadosRetorno.DESC_PROGRAMADO;
                        linhaSel.SIT_DUP = dadosRetorno.SIT_DUP;
                        linhaSel.DESC_SIT_DUP = dadosRetorno.DESC_SIT_DUP;
                        linhaSel.GERA_CONTACOR = dadosRetorno.GERA_CONTACOR;
                        linhaSel.EMP_ID = dadosRetorno.EMP_ID;
                        linhaSel.CLASSE = dadosRetorno.CLASSE;
                        linhaSel.JUROS = dadosRetorno.JURO;
                        linhaSel.BORDERO = dadosRetorno.BORDERO;
                    }

                    let valorAux;

                    if (dadosDuplicata.length > 1) {
                        valorAux = dadosRetorno.VALOR + dadosRetorno.JURO_PAGO - dadosRetorno.DESCONTO;

                        valorAux += linha.SOMARTARIFA ? tarifa : 0;

                        dadosDuplicata = dadosDuplicata.map((e) => {
                            return { ...e, VALOR_PAGO: valorAux, JUROS: dadosRetorno.JURO, VALOR2_SEMJUROS: e.VALOR2 }
                        })

                        alimentaTabelaSelDupli(dadosDuplicata);
                        await abreModalSelecionarDuplicatas();

                        let indiceSelecionado = $('#tabelaSelDupli').DataTable().row($('#tabelaSelDupli').DataTable().$('tr.selected')[0]).index();

                        linhaSel.NUMERO = dadosDuplicata[indiceSelecionado].NUMERO;
                        linhaSel.NOME = dadosDuplicata[indiceSelecionado].NOME;
                        linhaSel.CODCLI = dadosDuplicata[indiceSelecionado].CODCLI;
                        linhaSel.STATUS = dadosDuplicata[indiceSelecionado].STATUS;
                        linhaSel.VALOR2 = dadosDuplicata[indiceSelecionado].VALOR2;
                        linhaSel.VALOR_PAGO = dadosDuplicata[indiceSelecionado].VALOR_PAGO;
                        linhaSel.DT_VENCTO = dadosDuplicata[indiceSelecionado].DT_VENCTO;
                        linhaSel.TAXA = dadosDuplicata[indiceSelecionado].TAXA;
                        linhaSel.FATURA = dadosDuplicata[indiceSelecionado].FATURA;
                        linhaSel.NRBANCO = dadosDuplicata[indiceSelecionado].NRBANCO;
                        linhaSel.EMP = dadosDuplicata[indiceSelecionado].EMP;
                        linhaSel.DESC_PROGRAMADO = dadosDuplicata[indiceSelecionado].DESC_PROGRAMADO;
                        linhaSel.SIT_DUP = dadosDuplicata[indiceSelecionado].SIT_DUP;
                        linhaSel.DESC_SIT_DUP = dadosDuplicata[indiceSelecionado].DESC_SIT_DUP;
                        linhaSel.GERA_CONTACOR = dadosDuplicata[indiceSelecionado].GERA_CONTACOR;
                        linhaSel.EMP_ID = dadosDuplicata[indiceSelecionado].EMP_ID;
                        linhaSel.CLASSE = dadosDuplicata[indiceSelecionado].CLASSE;
                        linhaSel.JUROS = dadosDuplicata[indiceSelecionado].JUROS;
                        linhaSel.BORDERO = dadosDuplicata[indiceSelecionado].BORDERO;
                    }

                    dadosRetorno.BAIXADA = 'N';

                    if (dadosDuplicata[0].REFAZ_CONSULTA == 'S') {
                        response = await requisicao('GET', `/Sisplan/escretorno/v1/dadosduplicata2?&EMPRESA=${getCookie('empresa')}&MODO=${1}&EMPID=${getCookie('emp_id')}&NRBANCO=${dadosRetorno.NR_BANCO}&NRBANCO2=${dadosRetorno.NR_BANCO2}&NUMERO=${dadosRetorno.NUMERO}&TIPO=${linha.INSTRUCAO}&TODASEMPRESAS=${linha.TODASEMPRESAS}&`)
                        if (!response) {
                            return;
                        }

                        dadosDuplicata = await response.json();
                        if (response.status != 200) {
                            msgErro(dadosDuplicata.mensagem);
                            return;
                        }

                        if (dadosDuplicata.length > 0) {
                            linhaSel.NUMERO = dadosDuplicata[0].NUMERO;
                            linhaSel.NOME = dadosDuplicata[0].NOME;
                            linhaSel.CODCLI = dadosDuplicata[0].CODCLI;
                            linhaSel.STATUS = dadosDuplicata[0].STATUS;
                            linhaSel.VALOR2 = dadosDuplicata[0].VALOR2;
                            linhaSel.VALOR_PAGO = dadosDuplicata[0].VALOR_PAGO;
                            linhaSel.DT_VENCTO = dadosDuplicata[0].DT_VENCTO;
                            linhaSel.TAXA = dadosDuplicata[0].TAXA;
                            linhaSel.FATURA = dadosDuplicata[0].FATURA;
                            linhaSel.NRBANCO = dadosDuplicata[0].NRBANCO;
                            linhaSel.EMP = dadosDuplicata[0].EMP;
                            linhaSel.DESC_PROGRAMADO = dadosDuplicata[0].DESC_PROGRAMADO;
                            linhaSel.SIT_DUP = dadosDuplicata[0].SIT_DUP;
                            linhaSel.DESC_SIT_DUP = dadosDuplicata[0].DESC_SIT_DUP;
                            linhaSel.GERA_CONTACOR = dadosDuplicata[0].GERA_CONTACOR;
                            linhaSel.EMP_ID = dadosDuplicata[0].EMP_ID;
                            linhaSel.CLASSE = dadosDuplicata[0].CLASSE;
                            linhaSel.JUROS = dadosDuplicata[0].JUROS;
                            linhaSel.BORDERO = dadosDuplicata[0].BORDERO;
                        }

                        dadosRetorno.BAIXADA = 'S';
                    }

                    let vencto = linhaSel.DT_VENCTO;
                    if (vencto.trim() != '') {
                        let taxa = linhaSel.TAXA == undefined ? 0 : linhaSel.TAXA;
                        if (await atrasoDiaUtil(vencto, dadosRetorno.DATA) == 'S') {
                            let dateDiff = ((new Date(dadosRetorno.DATA)).getTime() - (new Date(vencto)).getTime());

                            let dias = Math.floor(dateDiff / (100 * 60 * 60 * 24));

                            dadosRetorno.JURO_CALC = ((taxa / 30 / 100) * dadosRetorno.VALOR) * dias;
                        }
                    }

                    dadosRetorno.DESC_PROGRAMADO = linhaSel.DESC_PROGRAMADO;

                    dadosRetorno.VALOR += dadosRetorno.JURO_PAGO - dadosRetorno.DESCONTO;

                    if (ocultaOcorrencia != 'S') {
                        let obj = {};
                        if (dadosRetorno.BOLECODE != '') {
                            obj.BOLECODE = dadosRetorno.BOLECODE;
                        } else {
                            obj.SEL = linhaSel.VALOR2 > 0 ? 'S' : 'N';
                            obj.FATURA = linhaSel.FATURA;
                            obj.NUMERO = linhaSel.NUMERO;
                            obj.DT_VENCTO = linhaSel.DT_VENCTO;
                            obj.DT_CONT = dadosRetorno.DT_CONT;
                            obj.VALOR = linhaSel.VALOR2;
                            obj.VALOR_PAGO = dadosRetorno.VALOR + (linha.SOMARTARIFA ? dadosRetorno.TARIFA : 0);
                            obj.JURO = dadosRetorno.JURO;
                            obj.ACRESCIMO = dadosRetorno.ACRESCIMO;
                            obj.VALOR_ANTEC = dadosRetorno.VALOR_ANTEC;
                            obj.DESCONTO = dadosRetorno.DESCONTO + dadosRetorno.DESC_PROGRAMADO;
                            obj.DESC_PROGRAMADO = dadosRetorno.DESC_PROGRAMADO;
                            obj.STATUS = linhaSel.STATUS;
                            obj.NOME = linhaSel.NOME;
                            obj.CODCLI = linhaSel.CODCLI;
                            obj.COD_OCORRENCIA = dadosRetorno.COD_OCORRENCIA;
                            obj.DESC_OCORRENCIA = dadosRetorno.DESC_OCORRENCIA;
                            obj.NR_BANCO = dadosRetorno.NR_BANCO;
                            obj.NOME_BANCO = pegaDescricao('#txtBanco');
                            obj.ALTERA_VENCTO = dadosRetorno.ALTERA_VENCTO;
                            obj.JURO_CALC = dadosRetorno.JURO_CALC + dadosRetorno.JURO;
                            obj.JURO_DESC = dadosRetorno.JURO_DESC;
                            obj.TAXA = linhaSel.TAXA;
                            obj.TARIFA = dadosRetorno.TARIFA;
                            obj.DESPESA = dadosRetorno.DESPESA;
                            obj.IOF = dadosRetorno.IOF;
                            obj.DATA = dadosRetorno.DATA;
                            obj.BANCO = pegaChave('#txtBanco');
                            obj.CONTA = dadosRetorno.CONTA;
                            obj.CONTACONT_JUROS = dadosRetorno.CONTACONT_JUROS;
                            obj.CARTEIRA = dadosRetorno.CARTEIRA;
                            obj.COMP_CART = dadosRetorno.COMP_CART;
                            obj.SITUACAO = dadosRetorno.SITUACAO;
                            obj.CLASSE = dadosRetorno.CLASSE;
                            obj.ARQUIVO = $('#txtArquivo').val();
                            obj.ORDEM = dadosRetorno.ORDEM;
                            obj.EMP = linhaSel.EMP;
                            obj.REJEITA = dadosRetorno.REJEITA;
                            obj.BAIXADA = dadosRetorno.BAIXADA;
                            obj.VALIDA = dadosRetorno.VALIDA;
                            obj.COD_LIQUIDACAO = dadosRetorno.COD_LIQUIDACAO;
                            obj.SIT_DUP = linhaSel.SIT_DUP;
                            obj.DESC_SIT_DUP = linhaSel.DESC_SIT_DUP;
                            obj.GERA_CONTACOR = linhaSel.GERA_CONTACOR;
                            obj.EMP_ID = linhaSel.EMP_ID;
                            obj.DUPLICADO = dadosRetorno.DUPLICADO;
                            obj.CREDITA_CC = dadosRetorno.CREDITA_CC;
                            obj.DEBITA_CC = dadosRetorno.DEBITA_CC;
                            obj.ID_INTEGRA = dadosRetorno.ID_INTEGRA;
                            obj.OBS = dadosRetorno.OBS;
                            obj.CLASSE_CAPA = linhaSel.CLASSE;
                            obj.BOLECODE = dadosRetorno.BOLECODE;
                            obj.COD_REJEICAO = dadosRetorno.COD_REJEICAO;
                            obj.DESC_REJEICAO = dadosRetorno.DESC_REJEICAO;
                            obj.BORDERO = linhaSel.BORDERO;

                            if (dadosRetorno.REJEITA == 'S') {
                                obj.DESC_REJEICAO = await retornaDescricaoRejeicao(pegaChave('#txtBanco'), dadosRetorno.COD_OCORRENCIA, dadosRetorno.CARTEIRA, dadosRetorno.COD_REJEICAO);
                            }

                            if (dadosRetorno.COD_LIQUIDACAO != '') {
                                let dias = await buscaValor('MODA_PAGTO', 'DIAS', `BANCO = '${pegaChave('#txtBanco')}' AND CODIGO`, dadosRetorno.COD_LIQUIDACAO);
                                dias = parseInt(dias);
                                dias = isNaN(dias) ? 0 : dias;
                                let novaDataCont = new Date(dadosRetorno.DATA_CONT);
                                novaDataCont.setDate(novaDataCont.getDate() + dias);

                                obj.DATA_CONT = novaDataCont;
                            }
                        }

                        $('#tabelaRetorno').DataTable().row.add(obj);

                    }
                }

                v1 = StrToFloat($('#txtRegArq').val());
                v2 = StrToFloat($('#txtRegImp').val());

                if (i > 0) {
                    if (!isNaN(v1)) { v1 += 1 } else { v1 = 0 }

                    if (!isNaN(v2)) { v2 += 1 } else { v2 = 0 }
                }

                $('#txtRegArq').val(v1);
                $('#txtRegImp').val(v2);

            } catch (e) {
                console.log(e);
            }
        }

        $('#tabelaRetorno').DataTable().draw(false);
        $('#tabelaRetorno').DataTable().draw(false);

        verificaRegistroDuplicado();
        await calculaTotais()
    }

    function verificaRegistroDuplicado() {
        let data = $('#tabelaRetorno').DataTable().data().toArray();

        let v = data.filter((item, index, array) => {
            return array.findIndex(obj => obj.NUMERO == item.NUMERO) !== index;
        });

        let listaNumeros = [];

        v.map(e => {
            listaNumeros.push(e.NUMERO);
        });

        for (i = 0; i < data.length; i++) {
            if (listaNumeros.includes(data[i].NUMERO)) {
                let d = $('#tabelaRetorno').DataTable().row(i).data();
                d.DUPLICADO = 'S';

                $('#tabelaRetorno').DataTable().row(i).data(d).draw(false);
            }
        }
    }

    async function calculaTotais() {
        try {

            let vValor = 0;
            let vValorPago = 0;
            let vJuro = 0;
            let vAcres = 0;
            let vDesc = 0;
            let vConta = 0;
            let vContas = [];

            $('#txtTotVal').val(0);
            $('#txtTotPag').val(0);
            $('#txtTotSal').val(0);
            $('#txtTotJur').val(0);
            $('#txtTotDes').val(0);
            $('#txtTotAcr').val(0);

            $('#tabelaRetorno').DataTable().rows().data().each(async function (row) {
                vValor += parseFloat(row.VALOR) ?? 0;
                vValorPago += parseFloat(row.VALOR_PAGO) ?? 0;

                if (await buscaValor('OCORRENCIA', 'BAIXA', `CODIGO = '${row.COD_OCORRENCIA}' AND BANCO = '${row.BANCO}' AND CARTEIRA`, row.CARTEIRA) == 'S') {
                    vJuro += parseFloat(row.JURO);
                }

                vAcres += parseFloat(row.ACRESCIMO);
                vDesc += parseFloat(row.DESCONTO);

                vConta = row.CONTA.trim();

                if ((vConta != '') && (!vContas.includes(vConta))) {
                    vContas.push(vConta);
                }

                vConta = '';
                vConta = await buscaValor('CADCONTA', 'CONTA_CREDITADA', 'CONTA', row.CONTA);
                if ((vConta != '') && (!vContas.includes(vConta))) {
                    vContas.push(vConta);
                }
            })

            $('#txtTotVal').val(isNaN(vValor) ? 0 : parseFloat(vValor).toLocaleString("pt-br", {
                maximumFractionDigits: 2,
                minimumFractionDigits: 2,
            }));
            $('#txtTotPag').val(isNaN(vValorPago) ? 0 : parseFloat(vValorPago).toLocaleString("pt-br", {
                maximumFractionDigits: 2,
                minimumFractionDigits: 2,
            }));
            $('#txtTotSal').val(isNaN(vValor - vValorPago) ? 0 : parseFloat(vValor - vValorPago).toLocaleString("pt-br", {
                maximumFractionDigits: 2,
                minimumFractionDigits: 2,
            }));
            $('#txtTotJur').val(isNaN(vJuro) ? 0 : parseFloat(vJuro).toLocaleString("pt-br", {
                maximumFractionDigits: 2,
                minimumFractionDigits: 2,
            }));
            $('#txtTotDes').val(isNaN(vDesc) ? 0 : parseFloat(vDesc).toLocaleString("pt-br", {
                maximumFractionDigits: 2,
                minimumFractionDigits: 2,
            }));
            $('#txtTotAcr').val(isNaN(vAcres) ? 0 : parseFloat(vAcres).toLocaleString("pt-br", {
                maximumFractionDigits: 2,
                minimumFractionDigits: 2,
            }));

        } catch (e) {
            console.log(e);
        }
    }

    function retornaObjInfo() {
        let retorno = {}

        retorno.BANCO = pegaChave('#txtBanco');
        retorno.CARTEIRA = pegaChave('#txtCarteira');
        retorno.CLASSEBAIXA = pegaChave('#txtClasseBaixa');
        retorno.CLASSEJUROS = pegaChave('#txtClasseJuros');
        retorno.CLASSEDESCONTO = pegaChave('#txtClasseDesconto');
        retorno.HISTORICO = pegaChave('#txtHistorico');
        retorno.CONTA = pegaChave('#txtConta');
        retorno.JUROS = $('#txtJuros').val();
        retorno.CONTABILIZACAO = $('#txtContabilizacao').val() != '' ? $('#txtContabilizacao').val() : '1200-01-01';
        retorno.FORCAR = $('#cbForcar').prop('checked');
        retorno.INSTRUCAO = $('#txtInstrucao').val();
        retorno.TODASEMPRESAS = $('#cbTodasEmpresas').prop('checked');
        retorno.VALIDARCAMPOS = $('#cbValidarCampos').prop('checked');
        retorno.SOMARTARIFA = $('#cbSomarTarifa').prop('checked');
        retorno.CARTEIRAREGISTRO = $('#cbCarteiraRegistro').prop('checked');
        retorno.LANCARTARIFA = $('#cbLancarValorCC').prop('checked');
        retorno.MENSAGEMCC = $('#cbMsgCC').prop('checked');
        retorno.POSSUIINTEGRACAO = $('#cbPossuiIntegracao').prop('checked');
        retorno.CLASSEGERCAPA = $('#cbUsarClasse').prop('checked');

        return retorno;
    }

    async function abreModalSelecionarDuplicatas() {
        return await new Promise(async (resolve) => {

            $('#btnConfirmarSelDupli').off('click');
            $('#btnFecharSelDupli').off('click');
            $.LoadingOverlay('hide');

            await criaModalSelDupli(undefined,
                undefined,
                async () => {
                    $.LoadingOverlay('show');
                    resolve();
                }, async () => {
                    $.LoadingOverlay('show');
                    resolve();
                }
            );

        })
    }


    async function abreModalCampos(msg) {
        return await new Promise(async (resolve) => {

            setTimeout(async () => {
                $.LoadingOverlay('hide');

                $('#modal-warning .modal-header').css('-webkit-justify-content', 'left')

                msgErro(msg,
                    async () => {
                        $.LoadingOverlay('show');
                        resolve();
                    }, async () => {
                        $.LoadingOverlay('show');
                        resolve();
                    })
            }, 500);
        })

    }

    async function abreModalConfirmacao(msg) {
        return await new Promise(async (resolve) => {

            setTimeout(async () => {
                $.LoadingOverlay('hide');

                $('#modal-warning .modal-header').css('-webkit-justify-content', 'left')

                await msgAlerta(msg,
                    async () => { },
                    async () => {
                        gravaLog = false;
                        resolve();
                    },
                    async () => {
                        gravaLog = true;
                        $.LoadingOverlay('show');
                        resolve();
                        rotinaGeraLog('ESCRETORNO', pegaChave('#txtConta'), `RE-IMPORTADO: ${$('#txtArquivo').val()}`, 'Movimentação');
                    })
            }, 500);

        })
    }

    async function criaModalSelDupli($callback, $callbackCancelar, $callbackOk, $callbackClose) {
        $("#modalSelDupli").modal({
            backdrop: "static",
            keyboard: true,
            show: true,
        });

        $('.close').addClass('d-none');

        $("#btnConfirmarSelDupli").on("click", async function () {
            $("#modalSelDupli").modal("hide");
            if ($callback != undefined) {
                $callback();
            }
        });

        if ($callback != undefined && $callbackCancelar != undefined) {
            $("#btnCancelarSelDupli").on("click", async function () {
                $("#modalSelDupli").modal("hide");
                $callbackCancelar();
            });
        }
        if ($callbackOk != undefined) {
            $("#btnConfirmarSelDupli").on("click", async function () {
                $("#modalSelDupli").modal("hide");
                $callbackOk();
            });
        }
        if ($callbackClose != undefined) {
            $("#btnFecharSelDupli").on("click", async function () {
                $("#modalSelDupli").modal("hide");
                $callbackClose();
            });
        }
        $("#modalSelDupli").click();
        $("#modalSelDupli").focus();

        $($("#tabelaSelDupli tbody tr")[0]).addClass('selected');
    }

    criaTabelaRetorno();

    $('#tabelaSelDupli tbody').on('click', 'tr', async function () {
        if ($('#tabelaSelDupli').DataTable().data().length > 0) {
            $('#tabelaSelDupli').DataTable().$('tr.selected').removeClass('selected');
            $(this).addClass('selected');
        }
    });

    async function retornaDescricaoRejeicao(banco, ocorrencia, carteira, codigo) {
        try {
            const response = await requisicao('GET', '/Sisplan/Funcoes/v1/pesquisa?',
                `JSON={ "tabela":"RECUSAS",
                "camposSelect":["*"]}`
            )

            if (!response) {
                return '';
            }

            let jsonStr = await response.json();
            if (response.status != 200) {
                msgErro(jsonStr.RESULT[0].mensagem);
                return '';
            }

            const listaRejeicoes = jsonStr.RESULT[0];

            if (listaRejeicoes.length == 0) {
                return '';
            }

            let result;

            if (carteira != '') {
                if (!listaRejeicoes.find((e) => { e.BANCO == banco && e.OCORRENCIA == ocorrencia && e.CARTEIRA == carteira })) {
                    result = listaRejeicoes.find((e) => { e.BANCO == banco && e.CODIGO == codigo && e.CARTEIRA == carteira });
                } else {
                    result = listaRejeicoes.find((e) => { e.BANCO == banco && e.OCORRENCIA == ocorrencia && e.CODIGO == codigo && e.CARTEIRA == carteira });
                }
            }

            if (result == '') {
                if (!listaRejeicoes.find((e) => { e.BANCO == banco && e.OCORRENCIA == ocorrencia })) {
                    result = listaRejeicoes.find(
                        (e) => {
                            e.BANCO == banco && e.CODIGO == codigo
                        });
                } else {
                    result = listaRejeicoes.find((e) => { e.BANCO == banco && e.OCORRENCIA == ocorrencia && e.CODIGO == codigo });
                }
            }


            return result ? result.DESCRICAO : '';
        } catch (e) {
            console.log(e);
        }
    }

    async function atrasoDiaUtil(vencto, data) {
        try {

            const response = await requisicao('GET', `/Sisplan/escretorno/v1/atrasodiautil?`, `&VENCTO=${vencto}&DATA=${data}`);

            if (!response) {
                return;
            }
            return await response.text();

        } catch (e) {
            console.log(e);
        }
    }

    async function verificaCarteira240Pos(carteira) {
        try {
            const response = await requisicao('GET', '/Sisplan/Funcoes/v1/pesquisa?',
                `JSON={ "tabela":"CARTEIRA",
                "camposSelect":["CARTEIRA.POSICOES_240"],
                "where": ["EXISTS (SELECT C.CONTA FROM [CADCONTA] C WHERE C.BANCO = '${pegaChave('#txtBanco')}' AND CARTEIRA.CONTA = C.CONTA)", "CARTEIRA.CARTEIRA = '${carteira}'"]}`,
            )

            if (!response) {
                return;
            }

            let jsonStr = await response.json();
            if (response.status != 200) {
                msgErro(jsonStr.RESULT[0].mensagem);
                return;
            }

            const data = jsonStr.RESULT[0];

            if (data.length > 0) {
                if (data[0].POSICOES_240 == 'S') {
                    return true;
                } else {
                    return false;
                }
            } else {
                return false;
            }
        } catch (e) {
            console.log(e);
        }
    }

    $('#txtSaldoSelDupli').on('input', function () {
        let val = $(this).val();

        $('#tabelaSelDupli').DataTable().column(7).search(val, false).draw();
    })

    function alimentaTabelaSelDupli(data) {
        try {
            cols = [
                {
                    title: 'Número',
                    data: 'NUMERO'
                },
                {
                    title: 'Codcli',
                    data: 'CODCLI'
                },
                {
                    title: 'Nome',
                    data: 'NOME'
                },
                {
                    title: 'Nr. Banco',
                    data: 'NRBANCO'
                },
                {
                    title: 'Valor Pago',
                    data: 'VALOR_PAGO'
                },
                {
                    title: 'Saldo',
                    data: 'VALOR2'
                },
                {
                    title: 'Juros',
                    data: 'JUROS'
                },
                {
                    title: 'Saldo (sem juros)',
                    data: 'VALOR2_SEMJUROS'
                },
                {
                    title: 'Data Vencimento',
                    data: 'DT_VENCTO'
                },
                {
                    title: 'Fatura',
                    data: 'FATURA'
                },
                {
                    title: 'Empresa',
                    data: 'EMP'
                }
            ];

            $("#tabelaSelDupli").DataTable({
                order: false,
                sort: true,
                paging: false,
                destroy: true,
                lengthChange: false,
                language: {
                    sEmptyTable: "Nenhum registro encontrado",
                    sInfo: "_TOTAL_ registros",
                    sInfoEmpty: " 0 registros",
                    sInfoFiltered: "(Filtrados de _MAX_ registros)",
                    sInfoPostFix: "",
                    sInfoThousands: ".",
                    sLengthMenu: "_MENU_ resultados",
                    sLoadingRecords: "Carregando...",
                    sProcessing: "Processando...",
                    sZeroRecords: "Nenhum registro encontrado",
                    sSearch: "Pesquisar",
                    oPaginate: {
                        sNext: "Próximo",
                        sPrevious: "Anterior",
                        sFirst: "Primeiro",
                        sLast: "Último",
                    },
                    oAria: {
                        sSortAscending: ": Ordenar colunas de forma ascendente",
                        sSortDescending: ": Ordenar colunas de forma descendente",
                    },
                },
                autoWidth: true,
                data: data,
                columns: cols,
                columnDefs: [{
                    type: 'date-br',
                    targets: [8],
                    render(data) {
                        if (data) {
                            return new Intl.DateTimeFormat('pt-BR').format(new Date(`${data.split(' ')[0]} 23:59:59`));
                        } else {
                            return '';
                        }

                    },
                },
                {
                    render: function (data) {
                        return parseFloat(data).toLocaleString("pt-br", {
                            maximumFractionDigits: 2,
                            minimumFractionDigits: 2,
                        });
                    },
                    targets: [4, 5, 6, 7],
                },
                ],
            });

            $('.dataTables_filter').addClass('d-none')

        } catch (e) {
            console.log(e);
        }
    }

    function StrToFloat(v) {
        let result = parseFloat(v);

        if (isNaN(result) || result === undefined || result === null) {
            return 0;
        }

        return result;
    }

    let gravaLog = false;

    $('#btnConfirmar').on('click', async function () {
        try {
            try {
                $.LoadingOverlay('show');

                $('#modal-warning .modal-header').css('-webkit-justify-content', 'left')

                const tableData = $('#tabelaRetorno').DataTable().data().toArray();

                const data = tableData.filter((e) => {
                    return e.SEL == 'S';
                })

                if (data.length == 0) {
                    msgErro('Nenhum registro selecionado, impossível continuar.');
                    return;
                }

                if (!$('#cbPossuiIntegracao').prop('checked')) {
                    if (data.length == 0) {
                        await copiaArquivo();
                        return;
                    }
                }

                if ($('#txtBanco').val() == '') {
                    msgErro('Código do banco não informado, impossível continuar.', () => {
                        if ($('#confirm').hasClass('active')) {
                            $('#account').trigger('click');
                        }

                        $('#btnBanco').trigger('click');
                    }, () => {
                        if ($('#confirm').hasClass('active')) {
                            $('#account').trigger('click');
                        }

                        $('#btnBanco').trigger('click');
                    })
                }

                if ((!$('#cbPossuiIntegracao').prop('checked')) && ($('#txtArquivo').val() == '')) {
                    msgErro('Campo arquivo inválido, impossível continuar.', () => {
                        if ($('#confirm').hasClass('active')) {
                            $('#account').trigger('click');
                        }

                        $('#btnArquivo').trigger('click');
                    }, () => {
                        if ($('#confirm').hasClass('active')) {
                            $('#account').trigger('click');
                        }

                        $('#btnArquivo').trigger('click');
                    })
                }

                let valida = data.find((e) => {
                    return e.STATUS == 'AGRU' || e.STATUS == 'DESD'
                })

                if (valida != undefined) {
                    await abreModalCampos('Existem duplicatas com status Agrupada ou Desdobrada. Não é possivel realizar alterações nestas duplicatas.');
                }

                if (!$('#cbPossuiIntegracao').prop('checked')) {
                    if (await Existe('LOG', ['TELA', 'CHAVE', 'DESCRICAO'], ['ESCRETORNO', (pegaChave('#txtConta')).toUpperCase(), `IMPORTADO: ${($('#txtArquivo').val()).toUpperCase()}`])) {

                        await abreModalConfirmacao('Arquivo já importado anteriormente. Deseja importar mesmo assim?');
                        if (!gravaLog) {
                            return;
                        }
                    } else {
                        await rotinaGeraLog('ESCRETORNO', pegaChave('#txtConta'), `IMPORTADO: ${$('#txtArquivo').val()}`, 'Movimentação');
                    }
                }

                await iniciaConfirmar(data);
            } catch (e) {
                console.log(e);
            }
        } finally {
            $.LoadingOverlay('hide');
        }
    });

    async function iniciaConfirmar(data) {

        let numeroLancto;
        let baixa = true;
        let lancaJuros;

        for (i = 0; i < data.length; i++) {

            let e = data[i];

            async function excedeSaldoDuplicata(receber, ocorrencia) {
                try {

                    let valorDup = StrToFloat(receber.VALOR2) + StrToFloat(receber.JUROS) - StrToFloat(receber.DESCONTO) - StrToFloat(receber.VAL_DEV) - StrToFloat(receber.VALOR_PAGO);
                    let valorBai = StrToFloat(receber.VALOR_PAGO) - StrToFloat(receber.JURO) - StrToFloat(receber.ACRESCIMO) - StrToFloat(receber.DESCONTO);

                    let result = true;

                    if (parseFloat(valorDup).toFixed(2) < parseFloat(valorBai).toFixed(2)) {
                        if (ocorrencia != undefined && ocorrencia.VALOR_EXCEDIDO == 'S') {
                            await new Promise(async (resolve) => {

                                $.LoadingOverlay('hide');

                                $('#modal-warning .modal-header').css('-webkit-justify-content', 'left')

                                await msgAlerta(`Valor excedido para a duplicata ${e.NUMERO}. Inserir o valor excedente em juros?`,
                                    async () => { },
                                    async () => {
                                        $.LoadingOverlay('show');
                                        if (e.JURO <= 0) {
                                            e.JURO = valorBai - valorPago;
                                        }
                                        result = false;
                                        resolve();
                                    },
                                    async () => {
                                        $.LoadingOverlay('show');
                                        resolve();
                                    })

                            })
                        } else if (ocorrencia != undefined && ocorrencia.VAL_EXCEDIDO_SALDO == 'S') {
                            await new Promise(async (resolve) => {

                                $.LoadingOverlay('hide');

                                $('#modal-warning .modal-header').css('-webkit-justify-content', 'left')

                                msgErro(`Valor excedido para a duplicata ${e.NUMERO}. Será baixado somente o saldo.`,
                                    async () => {
                                        $.LoadingOverlay('show');
                                        e.VALOR_PAGO = valorDup;
                                        result = false;
                                        resolve();
                                    },
                                    async () => {
                                        $.LoadingOverlay('show');
                                        resolve();
                                    })

                            })
                        } else {
                            e.VALOR_ANTEC = valorBai - valorDup;
                            result = true;
                        }
                    }

                    return result;

                } catch (e) {
                    console.log(e);
                }
            }

            let bLanca = false;
            let proximoDocto;
            let conta;

            if ((e.VALIDA == 'S') && e.SEL == 'S') {
                let receber = await buscaValor('RECEBER', '*', 'NUMERO', e.NUMERO);
                let ocorrencia = await buscaValor('OCORRENCIA', '*', `CODIGO = '${e.COD_OCORRENCIA}' AND BANCO = '${pegaChave('#txtBanco')}' AND CARTEIRA`, e.CARTEIRA);

                if (ocorrencia == undefined) {
                    ocorrencia = '';
                }

                let antecipa = false;

                if (receber == undefined) {
                    await abreModalCampos(`Duplicata não encontrada: ${e.NUMERO}`);
                } else if (e.BAIXADA == 'S') {
                    baixa = false;
                    // abreModalGerarAntecipacao();
                    await abreModalCampos(`Duplicata ${e.NUMERO} já baixada, ignorando registro.`);

                } else if (!excedeSaldoDuplicata(receber, ocorrencia)) {
                    baixa = false;
                    // abreModalGerarAntecipacao();
                    if (ocorrencia.BAIXA == 'S') {
                        await abreModalCampos(`Valor excedido para a duplicata ${e.NUMERO}.`);
                    }
                }

                if (baixa) {
                    lancaJuros = false;
                    if (ocorrencia.BAIXA == 'S') {
                        bLanca = true;


                        await new Promise(async (resolve) => {

                            await msgAlerta(`Juros calculados no valor de ${e.JURO_CALC} para o cliente ${e.CODCLI} na duplicata ${e.NUMERO}. Deseja lançar os juros na duplicata?`,
                                async () => { },
                                async () => {
                                    $.LoadingOverlay('show');
                                    lancaJuros = true;
                                    resolve();
                                },
                                async () => {
                                    $.LoadingOverlay('show');
                                    resolve();
                                })
                        })
                    }
                }

                let obj = retornaObjInfo();

                obj.ARQUIVO = [$('#txtArquivo').val()];

                const response = await requisicao("POST", `/Sisplan/escretorno/V1/atualizareceber?&CODUSUARIO=${getCookie('cod_usuario')}`, `&EMPRESA=${getCookie('empresa')}`,
                    `&EMP_ID=${getCookie('emp_id')}&ANTECIPA=${antecipa}&ARQUIVO=${$('#txtArquivo').val()}&LANCA_JUROS=${lancaJuros}&BAIXA=${baixa}&JSONFILTROS=${encodeURIComponent(JSON.stringify(obj))}&JSONDADOS=${encodeURIComponent(JSON.stringify(e))}`);

                if (!response) {
                    return;
                }

                let jsonStr = await response.json();
                if (response.status != 200) {
                    // msgErro(jsonStr.RESULT[0].mensagem);
                    return;
                }

                numeroLancto = jsonStr;

            }
        }

        if ($('#cbLancarValorCC').prop('checked')) {
            let dadosTabela = $('#tabelaRetorno').DataTable().data().toArray();

            let info = retornaObjInfo();

            bLanca = false;

            for (i = 0; i < dadosTabela.length; i++) {

                let e = dadosTabela[i];
                let valorBai;
                let valorDup;

                async function excedeSaldoDuplicata(receber, ocorrencia) {
                    try {

                        valorDup = StrToFloat(receber.VALOR2) + StrToFloat(receber.JUROS) - StrToFloat(receber.DESCONTO) - StrToFloat(receber.VAL_DEV) - StrToFloat(receber.VALOR_PAGO);
                        valorBai = StrToFloat(receber.VALOR_PAGO) - StrToFloat(receber.JURO) - StrToFloat(receber.ACRESCIMO) - StrToFloat(receber.DESCONTO);

                        let result = false;

                        if (parseFloat(valorDup).toFixed(2) < parseFloat(valorBai).toFixed(2)) {
                            if (ocorrencia != undefined && ocorrencia.VALOR_EXCEDIDO == 'S') {
                                await new Promise(async (resolve) => {

                                    $.LoadingOverlay('hide');

                                    $('#modal-warning .modal-header').css('-webkit-justify-content', 'left')

                                    await msgAlerta(`Valor excedido para a duplicata ${e.NUMERO}. Inserir o valor excedente em juros?`,
                                        async () => { },
                                        async () => {
                                            $.LoadingOverlay('show');
                                            if (e.JURO <= 0) {
                                                e.JURO = valorBai - valorPago;
                                            }
                                            result = false;
                                            resolve();
                                        },
                                        async () => {
                                            $.LoadingOverlay('show');
                                            resolve();
                                        })

                                })
                            } else if (ocorrencia != undefined && ocorrencia.VAL_EXCEDIDO_SALDO == 'S') {
                                await new Promise(async (resolve) => {

                                    $.LoadingOverlay('hide');

                                    $('#modal-warning .modal-header').css('-webkit-justify-content', 'left')

                                    msgErro(`Valor excedido para a duplicata ${e.NUMERO}. Será baixado somente o saldo.`,
                                        async () => {
                                            $.LoadingOverlay('show');
                                            e.VALOR_PAGO = valorDup;
                                            result = false;
                                            resolve();
                                        },
                                        async () => {
                                            $.LoadingOverlay('show');
                                            resolve();
                                        })

                                })
                            } else {
                                e.VALOR_ANTEC = valorBai - valorDup;
                                result = true;
                            }
                        }

                        return result;

                    } catch (e) {
                        console.log(e);
                    }
                }

                let receber = await buscaValor('RECEBER', '*', 'NUMERO', e.NUMERO);
                let ocorrencia = await buscaValor('OCORRENCIA', '*', `CODIGO = '${e.COD_OCORRENCIA}' AND BANCO = '${pegaChave('#txtBanco')}' AND CARTEIRA`, e.CARTEIRA);

                if ((e.TARIFA > 0) && (e.BAIXADA == 'S') && (e.SEL == 'S') && (e.NUMERO != '')) {
                    if (excedeSaldoDuplicata(receber, ocorrencia)) {
                        if (ocorrencia.LANCA == 'S') {
                            const response = await requisicao("POST", `/Sisplan/escretorno/V1/lancatarifaposterior?&CODUSUARIO=${getCookie('cod_usuario')}`, `&EMPRESA=${getCookie('empresa')}`,
                                `&EMP_ID=${getCookie('emp_id')}&VALORBAIXA=${valorBai}&LANCTO=${numeroLancto}&INFO=${encodeURIComponent(JSON.stringify(obj))}&LINHA=${encodeURIComponent(JSON.stringify(e))}`);
                            if (!response) {
                                return;
                            }

                            let jsonStr = await response.json();
                            if (response.status != 200) {
                                // msgErro(jsonStr.RESULT[0].mensagem);
                                return;
                            }
                        }
                    }
                }
            }


        }

        toastr.success("Dados gravados com sucesso!", "Confirmação", {
            toastClass: "alert",
            iconClasses: {
                error: "alert-error",
                info: "alert-info",
                success: "alert-success",
                warning: "alert-warning",
            },
            positionClass: "toast-top-center",
            progressBar: true,
            timeOut: 3000,
            fadeOut: 1000,
            onHidden() {
                window.location.href = `${BASE_URI}/escretorno`;
            },
        }).css({
            "margin-top": "20%",
            width: "500px",
            "max-width": "500px",
        });

        $('#cbForcar').prop('checked', false);

    }

    $('#limparDados').on('click', function () {
        $.LoadingOverlay('show');
        if ($.fn.DataTable.isDataTable('#tabelaRetorno')) {
            $('#tabelaRetorno').DataTable().destroy();
            $('#tabelaRetorno').empty();
        }
        $('#txtRegArq').val('');
        $('#txtRegImp').val('');
        $('#txtTotVal').val('');
        $('#txtTotPag').val('');
        $('#txtTotSal').val('');
        $('#txtTotJur').val('');
        $('#txtTotDes').val('');
        $('#txtTotAcr').val('');
        $.LoadingOverlay('hide');
    })

    $('#alterarConta').on('click', function () {
        $('#modalAlterarConta').modal('show')
    })

    $('#btnConfirmarAlterarConta').on('click', async function () {
        const conta = pegaChave('#txtContaAlterarConta');

        if (!conta || conta === '') {
            msgErro('É necessário informar uma conta, favor verificar.')
            return
        }

        const banco = await buscaValor('CADCONTA', 'BANCO', 'CONTA', conta);
        if (banco && banco.BANCO && banco.BANCO !== '' && banco.BANCO !== pegaChave('#txtBanco')) {
            msgAlerta('A conta escolhida é de um banco diferente do informado em tela. Continuar mesmo assim?',
                () => { },
                () => { },
                () => { alteraContaDataTable(conta) }
            )
            return
        }
        alteraContaDataTable(conta)
    })

    function alteraContaDataTable(conta) {
        const data = buscaDadosTabela()
        data.map((e, i) => {
            const newData = {
                ...e,
                CONTA: e.SEL == 'S' ? conta : e.CONTA
            }
            $('#tabelaRetorno').DataTable().row(i).data(newData).draw(false);
        })
        $('#modalAlterarConta').modal('hide')
        $('#txtContaAlterarConta').val('')
    }
    
    $('#btnFecharAlterarConta').on('click', function () {
        $('#modalAlterarConta').modal('hide')
    })

    $("#tutorial").on("click", function () {
        $(document).ready(async function () {
            const driver = new Driver({
                doneBtnText: "Sair",
                closeBtnText: "Fechar",
                nextBtnText: "Próximo",
                prevBtnText: "Anterior",
                allowClose: false,
                animate: true,
                onNext: (Element) => {
                    if ((Element.node.id == 'verBaixas')) {
                        $('#verBaixas').trigger('click');
                    };
                },
                onPrevious: (Element) => {
                    if (Element.node.id == 'fieldset2') {
                        $('#voltar2').trigger('click');
                    }
                }
            });

            driver.defineSteps([
                {
                    element: "#fieldset1",
                    popover: {
                        title: "Dados",
                        description:
                            "Aqui você informa os dados da ocorrência.",
                        position: "right",
                    },
                },
                // {
                //     element: "#voltar1",
                //     popover: {
                //         title: "Botão Voltar",
                //         description:
                //             "Clique neste botão para voltar para a tela de acesso.",
                //         position: "right",
                //     },
                // },
                {
                    element: "#verBaixas",
                    popover: {
                        title: "Botão Gravar",
                        description: "Clique neste botão para avançar para a aba Configuração.",
                        position: "top",
                    },
                },
                {
                    element: "#fieldset2",
                    popover: {
                        title: "Configuração",
                        description: "Aqui você realiza a configuração da ocorrência.",
                        position: "top",
                    },
                },
                {
                    element: "#voltar2",
                    popover: {
                        title: "Configuração",
                        description: "Clique neste botão para voltar para a aba Geral.",
                        position: "top",
                    },
                },
                {
                    element: "#btnConfirmar",
                    popover: {
                        title: "Configuração",
                        description: "Clique neste botão para gravar os dados.",
                        position: "top",
                    },
                },
            ]);
            driver.start();
        });
    });

});