$(document).ready(async function () {
  const queryString = window.location.href;
  const parametros = queryString.split("/");
  const base64 = parametros[parametros.length - 1];
  const descriptografado = atob(base64);
  const [tipo, codigo, cor, periodo] = descriptografado.split('###');

  const buscaTabelaPrincipal = async () => {
    const url = '/sisplan/disponibilidadetecidos/v1/buscatabelaprincipalob?';
    const numero = $('#modal-detalhes-numero').html();
    const response = await requisicao("GET", url, `&ORDEM=${numero}`, '', 1800000);

    if (!response) {
      return;
    }

    const data = await response.json();
    const dadosTratados = data.map((item => [item.CODIGO, item.COR, item.ORIGEM, item.COR_ORIGEM, item.DEPOSITO, item.TIPO, item.PEDIDO, item.CLIENTE, item.CRITERIO, item.ROLOS, item.KG, formataDataTabela(item.QUINZENA).trim()]));
    $('#tabela-detalhamento-principal').DataTable({
      bPaginate: false,
      destroy: true,
      colReorder: false,
      reoder: false,
      order: false,
      search: false,
      filter: false,
      info: false,
      language: {
        sEmptyTable: "Nenhum registro encontrado",
        sInfo: "_TOTAL_ registros",
        sInfoEmpty: " 0 registros",
        sInfoFiltered: "(Filtrados de _MAX_ registros)",
        sInfoPostFix: "",
        sInfoThousands: ".",
        sLengthMenu: "_MENU_ resultados",
        sLoadingRecords: "Carregando...",
        sProcessing: "Processando...",
        sZeroRecords: "Nenhum registro encontrado",
        sSearch: "Pesquisar",
        oPaginate: {
          sNext: "Próximo",
          sPrevious: "Anterior",
          sFirst: "Primeiro",
          sLast: "Último",
        },
        oAria: {
          sSortAscending: ": Ordenar colunas de forma ascendente",
          sSortDescending: ": Ordenar colunas de forma descendente",
        },
      },
      autoWidth: true,
      data: dadosTratados,
      columnDefs: []
    });

  };

  const buscaTabelaAgrupamento = async () => {
    const url = '/sisplan/disponibilidadetecidos/v1/buscatabelaagrupamentoob?';
    const numero = $('#modal-detalhes-numero').html();
    const partida = $('#txtDetalheAgrupamento').val();
    const response = await requisicao("GET", url, `&ORDEM=${numero}&PARTIDA=${partida}`, '', 1800000);

    if (!response) {
      return;
    }

    const data = await response.json();
    const dadosTratados = data.map((item => [item.ORDEM_PRODUCAO, item.REFERENCIA, item.COR_REFERENCIA, item.ORIGEM, item.COR_ORIGEM, item.ROLOS, item.KG]));
    $('#tabela-detalhamento-agrupamento').DataTable({
      bPaginate: false,
      destroy: true,
      colReorder: false,
      reoder: false,
      order: false,
      search: false,
      filter: false,
      info: false,
      language: {
        sEmptyTable: "Nenhum registro encontrado",
        sInfo: "_TOTAL_ registros",
        sInfoEmpty: " 0 registros",
        sInfoFiltered: "(Filtrados de _MAX_ registros)",
        sInfoPostFix: "",
        sInfoThousands: ".",
        sLengthMenu: "_MENU_ resultados",
        sLoadingRecords: "Carregando...",
        sProcessing: "Processando...",
        sZeroRecords: "Nenhum registro encontrado",
        sSearch: "Pesquisar",
        oPaginate: {
          sNext: "Próximo",
          sPrevious: "Anterior",
          sFirst: "Primeiro",
          sLast: "Último",
        },
        oAria: {
          sSortAscending: ": Ordenar colunas de forma ascendente",
          sSortDescending: ": Ordenar colunas de forma descendente",
        },
      },
      autoWidth: true,
      data: dadosTratados,
      columnDefs: []
    });

  };


  const buscaDados = async () => {
    const url = tipo == 'aemitir' ? `/sisplan/disponibilidadetecidos/v1/buscaordensaemitir?`
      : `/sisplan/disponibilidadetecidos/v1/buscaordensemitidas?`;
    const response = await requisicao("GET", url, `&CODIGO=${separaCodigo(codigo)}&COR=${separaCodigo(cor)}&PERIODO=${periodo}`, '', 1800000);

    if (!response) {
      return;
    }

    const data = await response.json();
    const dadosTratados = data.map((item => [item.NUMERO, item.ROTEIRO, item.CODIGO, item.COR, formataDataTabela(item.PREVISAO).trim(), item.ROLOS_PROG, item.ROLOS, item.AGRUPAMENTO, item.AGRUPAMENTO_CASADO, item.RGB]));
    $('#tabela-ordens-emitidas').DataTable({
      bPaginate: false,
      destroy: true,
      colReorder: false,
      reoder: false,
      order: false,
      search: false,
      filter: false,
      info: false,
      language: {
        sEmptyTable: "Nenhum registro encontrado",
        sInfo: "_TOTAL_ registros",
        sInfoEmpty: " 0 registros",
        sInfoFiltered: "(Filtrados de _MAX_ registros)",
        sInfoPostFix: "",
        sInfoThousands: ".",
        sLengthMenu: "_MENU_ resultados",
        sLoadingRecords: "Carregando...",
        sProcessing: "Processando...",
        sZeroRecords: "Nenhum registro encontrado",
        sSearch: "Pesquisar",
        oPaginate: {
          sNext: "Próximo",
          sPrevious: "Anterior",
          sFirst: "Primeiro",
          sLast: "Último",
        },
        oAria: {
          sSortAscending: ": Ordenar colunas de forma ascendente",
          sSortDescending: ": Ordenar colunas de forma descendente",
        },
      },
      autoWidth: true,
      data: dadosTratados,
      columnDefs: [
        {
          targets: [9],
          visible: false
        },
        {
          targets: [3],
          // eslint-disable-next-line arrow-body-style
          render: (data, type, row) => {
            const cor = row[9];
            const partes = [];

            // Itera sobre a string original em incrementos de 3 caracteres
            for (let i = 0; i < cor.length; i += 3) {
              // Extrai uma parte de 3 caracteres
              const parte = cor.substring(i, i + 3);
              // Adiciona a parte ao array
              partes.push(parte);
            }


            const corRGB = `rgb(${partes[0]}, ${partes[1]}, ${partes[2]})`;

            return `<div style="border-bottom: 8px solid ${corRGB};">${data}</div>`;
          }
        },
        {
          targets: [1],
          render: (data) => `<button data-roteiro="${data}" class="btn btn-secondary btn-sm btn-roteiro">${data}</button>`
        },
        {
          targets: [0],
          render: (data, type, row) => `<div title="Abrir detalhamento da Ordem de Produção" data-ordem="${data}" data-tipo="${tipo}" class="btn-detalhamento-ob clicavel">${data}</div>`
        }
      ]
    });

    $('.btn-detalhamento-ob').off();
    $('.btn-detalhamento-ob').on('click', async function () {
      try {
        const ordem = $(this).attr('data-ordem');
        const tipo = $(this).attr('data-tipo');
        const url = `/sisplan/disponibilidadetecidos/v1/buscadetalhamentoob?`;
        const response = await requisicao("GET", url, `&ORDEM=${separaCodigo(ordem)}`, '', 1800000);

        if (!response) {
          return;
        }
        const data = await response.json();

        $('#modal-detalhes-numero').html(ordem);
        $('#txtDetalhePeriodo').val(data[0].SEMANA);
        $('#txtDetalheAgrupamento').val(data[0].PARTIDA_TINT);
        $('#txtDetalheMaquina').val(data[0].MAQUINA);
        $('#txtDetalheObs').val(data[0].OBS);
        $('#txtDetalheObs2').val(data[0].OBS2);
        $('#txtDetalheEstagioAtual').val(data[0].FASE);
        await buscaTabelaPrincipal();
        await buscaTabelaAgrupamento();

        if (tipo != 'emitidas') {
          $('#txtDetalheObs').attr('readonly', false);
          $('#txtDetalheObs2').attr('readonly', false);
          $('#btn-detalhe-obs').parent().removeClass('d-none');
          $('#btn-detalhe-obs2').parent().removeClass('d-none');
        }
        $('#btn-detalhe-obs').off('click');
        $('#btn-detalhe-obs').on('click', async function () {
          const numero = $('#modal-detalhes-numero').html();
          const obs = $(`#txtDetalheObs`).val();
          try {
            const response = await requisicao("POST", "/sisplan/disponibilidadetecidos/v1/alteraobsop?", `NUMERO=${numero}&ALTERAR=OBS&OBS=${obs}`, "", 300000);

            if (!response) {
              throw msgAlerta("Não foi possível alterar a observação da ordem.");
            }

            if (response.status != 200) {
              throw msgAlerta("Não foi possível alterar a observação da ordem.");
            }


            criaMensagemSucesso("Observação alterada com sucesso", async () => {
            });

          } catch (error) {
            console.error(error);
          }
        });
        $('#btn-detalhe-obs2').off('click');
        $('#btn-detalhe-obs2').on('click', async function () {
          const numero = $('#modal-detalhes-numero').html();
          const obs2 = $(`#txtDetalheObs2`).val();
          try {
            const response = await requisicao("POST", "/sisplan/disponibilidadetecidos/v1/alteraobsop?", `NUMERO=${numero}&ALTERAR=OBS2&OBS2=${obs2}`, "", 300000);

            if (!response) {
              throw msgAlerta("Não foi possível alterar a observação 2 da ordem.");
            }

            if (response.status != 200) {
              throw msgAlerta("Não foi possível alterar a observação 2 da ordem.");
            }


            criaMensagemSucesso("Observação 2 alterada com sucesso", async () => {
            });

          } catch (error) {
            console.error(error);
          }
        });
        $('#modal-detalhes-ordem').modal('show');
      } catch (error) {
        console.log(error);
      }
    });


    $('.btn-roteiro').off();
    $('.btn-roteiro').on('click', async function () {
      const roteiro = $(this).attr('data-roteiro');
      const url = `/sisplan/disponibilidadetecidos/v1/buscaroteiro?`;
      const response = await requisicao("GET", url, `&ROTEIRO=${separaCodigo(roteiro)}`, '', 1800000);

      if (!response) {
        return;
      }

      $('#modal-roteiro-roteiro').html(roteiro);
      const data = await response.json();
      const dadosTratados = data.map((item => [item.CODIGO, item.DESCRICAO]));
      $('#tabela-roteiro').DataTable({
        bPaginate: false,
        destroy: true,
        colReorder: false,
        reoder: false,
        order: false,
        search: false,
        filter: false,
        info: false,
        language: {
          sEmptyTable: "Nenhum registro encontrado",
          sInfo: "_TOTAL_ registros",
          sInfoEmpty: " 0 registros",
          sInfoFiltered: "(Filtrados de _MAX_ registros)",
          sInfoPostFix: "",
          sInfoThousands: ".",
          sLengthMenu: "_MENU_ resultados",
          sLoadingRecords: "Carregando...",
          sProcessing: "Processando...",
          sZeroRecords: "Nenhum registro encontrado",
          sSearch: "Pesquisar",
          oPaginate: {
            sNext: "Próximo",
            sPrevious: "Anterior",
            sFirst: "Primeiro",
            sLast: "Último",
          },
          oAria: {
            sSortAscending: ": Ordenar colunas de forma ascendente",
            sSortDescending: ": Ordenar colunas de forma descendente",
          },
        },
        autoWidth: true,
        data: dadosTratados
      });

      $('#modal-roteiro-operacoes').modal('show');
    });


    const lista = $('#tabela-ordens-emitidas').DataTable().data().toArray();
    const listaAgrupada = lista.reduce((acumulador, atual) => {
      const data = atual[4];
      if (!acumulador[data]) {
        acumulador[data] = 0;
      }
      if (atual[2].substr(0,2) == '18') {
        acumulador[data] += 0;
      } else {
        acumulador[data] += atual[6];
      }
      return acumulador;
    }, {});
    const listaAdaptada = Object.entries(listaAgrupada).map(([data, valor]) => [data, valor]);


    $('#tabela-ordens-data').DataTable({
      bPaginate: false,
      destroy: true,
      colReorder: false,
      reoder: false,
      order: [[0, 'asc']],
      search: false,
      filter: false,
      info: false,
      language: {
        sEmptyTable: "Nenhum registro encontrado",
        sInfo: "_TOTAL_ registros",
        sInfoEmpty: " 0 registros",
        sInfoFiltered: "(Filtrados de _MAX_ registros)",
        sInfoPostFix: "",
        sInfoThousands: ".",
        sLengthMenu: "_MENU_ resultados",
        sLoadingRecords: "Carregando...",
        sProcessing: "Processando...",
        sZeroRecords: "Nenhum registro encontrado",
        sSearch: "Pesquisar",
        oPaginate: {
          sNext: "Próximo",
          sPrevious: "Anterior",
          sFirst: "Primeiro",
          sLast: "Último",
        },
        oAria: {
          sSortAscending: ": Ordenar colunas de forma ascendente",
          sSortDescending: ": Ordenar colunas de forma descendente",
        },
      },
      autoWidth: true,
      data: listaAdaptada,
    });

    $('#title').html(tipo == "aemitir" ? 'Ordens a emitir' : 'Ordens Emitidas');
    // $('#modal-ordens-emitidas').modal('show');
    $('#tabela-ordens-emitidas tbody').unbind('click');
    $('#tabela-ordens-emitidas tbody').on('click', 'tr', async function () {
      if ($('#tabela-ordens-emitidas').DataTable().data().length > 0) {
        const data = $('#tabela-ordens-emitidas').DataTable().row($(this)).data();
        if (data[8] == 'SIM') {
          await buscaOrdensAgrupadas(data[7], true);
        } else {
          if ($.fn.DataTable.isDataTable('#tabela-ordens-agrupamento')) {
            $('#tabela-ordens-agrupamento').DataTable().clear().draw(false);
          }
        }
        $('#tabela-ordens-emitidas').DataTable().$('tr.selected').removeClass('selected');
        $(this).addClass('selected');
      }
    });

    if ($('#tabela-ordens-emitidas').DataTable().data().toArray().length > 0) {
      $('#tabela-ordens-emitidas tbody tr:eq(0)').trigger('click');
    }
  };


  const separaCodigo = (codigo) => codigo.split('-')[0].trim();
  async function buscaOrdensAgrupadas(numero, aEmitir = false) {
    const url = aEmitir ? `/sisplan/disponibilidadetecidos/v1/buscaordensaemitiragrupadas?` : `/sisplan/disponibilidadetecidos/v1/buscaordensemitidasagrupadas?`;
    const response = await requisicao("GET", url, `&NUMERO=${separaCodigo(numero)}`, '', 1800000);
    if (!response) {
      return;
    }

    const data = await response.json();
    const dadosTratados = data.map((item => [item.CODIGO, item.ROTEIRO, item.ORIGEM_CASADO, item.AGRUPAMENTO]));
    $('#tabela-ordens-agrupamento').DataTable({
      bPaginate: false,
      destroy: true,
      colReorder: false,
      reoder: false,
      order: false,
      search: false,
      filter: false,
      info: false,
      language: {
        sEmptyTable: "Nenhum registro encontrado",
        sInfo: "_TOTAL_ registros",
        sInfoEmpty: " 0 registros",
        sInfoFiltered: "(Filtrados de _MAX_ registros)",
        sInfoPostFix: "",
        sInfoThousands: ".",
        sLengthMenu: "_MENU_ resultados",
        sLoadingRecords: "Carregando...",
        sProcessing: "Processando...",
        sZeroRecords: "Nenhum registro encontrado",
        sSearch: "Pesquisar",
        oPaginate: {
          sNext: "Próximo",
          sPrevious: "Anterior",
          sFirst: "Primeiro",
          sLast: "Último",
        },
        oAria: {
          sSortAscending: ": Ordenar colunas de forma ascendente",
          sSortDescending: ": Ordenar colunas de forma descendente",
        },
      },
      autoWidth: true,
      data: dadosTratados,
      columnDefs: [
        {
          targets: [1],
          render: (data) => `<button data-roteiro="${data}" class="btn btn-secondary btn-sm btn-roteiro">${data}</button>`
        }
      ]
    });

    $('.btn-roteiro').off();
    $('.btn-roteiro').on('click', async function () {
      const roteiro = $(this).attr('data-roteiro');
      const url = `/sisplan/disponibilidadetecidos/v1/buscaroteiro?`;
      const response = await requisicao("GET", url, `&ROTEIRO=${separaCodigo(roteiro)}`, '', 1800000);

      if (!response) {
        return;
      }

      $('#modal-roteiro-roteiro').html(roteiro);
      const data = await response.json();
      const dadosTratados = data.map((item => [item.CODIGO, item.DESCRICAO]));
      $('#tabela-roteiro').DataTable({
        bPaginate: false,
        destroy: true,
        colReorder: false,
        reoder: false,
        order: false,
        search: false,
        filter: false,
        info: false,
        language: {
          sEmptyTable: "Nenhum registro encontrado",
          sInfo: "_TOTAL_ registros",
          sInfoEmpty: " 0 registros",
          sInfoFiltered: "(Filtrados de _MAX_ registros)",
          sInfoPostFix: "",
          sInfoThousands: ".",
          sLengthMenu: "_MENU_ resultados",
          sLoadingRecords: "Carregando...",
          sProcessing: "Processando...",
          sZeroRecords: "Nenhum registro encontrado",
          sSearch: "Pesquisar",
          oPaginate: {
            sNext: "Próximo",
            sPrevious: "Anterior",
            sFirst: "Primeiro",
            sLast: "Último",
          },
          oAria: {
            sSortAscending: ": Ordenar colunas de forma ascendente",
            sSortDescending: ": Ordenar colunas de forma descendente",
          },
        },
        autoWidth: true,
        data: dadosTratados
      });

      $('#modal-roteiro-operacoes').modal('show');
    });
  }
  const formataDataTabela = (data) => {
    if (!data) {
      return '';
    }
    const [dataParte, horaParte] = data.split(' ');
    const [ano, mes, dia] = dataParte.split('-');
    const dataFormatada = `${dia}/${mes}/${ano} ${horaParte != '00:00:00' ? horaParte : ''}`;
    return dataFormatada;
  };

  buscaDados();


});