$('#tutorial').on('click', function () {
    $(document).ready(async function () {
        const driver = new Driver({
            doneBtnText: 'Sair',
            closeBtnText: 'Fechar',
            nextBtnText: 'Próximo',
            prevBtnText: 'Anterior',
            allowClose: false,
            animate: true,
            onNext: (Element) => {
                if ((Element.node.id == 'avancar1')) {
                    $('#avancar1').trigger('click');
                };
            }
        });

        driver.defineSteps([{
            element: '#formcard1',
            popover: {
                title: 'Dados Gerais',
                description: 'Aqui estão os campos disponíveis para o cadastro.',
                position: 'top'
            }
        },
        {
            element: "#btnVoltar",
            popover: {
                title: "Botão Voltar",
                description:
                    "Ao clicar nesse botão você retorna para a tela de consulta.",
                position: "left",
            },
        },
        {
            element: '#avancar1',
            popover: {
                title: 'Botão Avançar',
                description: 'Clique aqui para ir para a próxima aba.',
                position: 'left'
            }
        },
        {
            element: '#formcard2',
            popover: {
                title: 'Setores',
                description: 'Aqui estão os setores cadastrados neste fluxo',
                position: 'top'
            }
        },
        {
            element: '#btnAddSetor',
            popover: {
                title: 'Adicionar Setor',
                description: 'Este botão é utilizado para adicionar um setor.',
                position: 'top'
            }
        },
        {
            element: '#voltar2',
            popover: {
                title: 'Botão Voltar',
                description: 'Clique aqui para voltar a página anterior.',
                position: 'top'
            }
        },
        {
            element: '#btnGravar',
            popover: {
                title: 'Botão Gravar',
                description: 'Clique aqui para gravar os dados.',
                position: 'left'
            }
        }
        ]);
        driver.start();
    });
});

$(document).ready(async function () {

    $('#msform').validate({
        debug: false,
        ignore: "",
        rules: {
            txtIdDash: {
                required: true,
            },
            txtTituloDash: {
                required: true,
            }
        },
        messages: {
            txtIdDash: {
                required: "É necessário informar um Id Dash."
            },
            txtTituloDash: {
                required: "É necessário informar um Titulo para o Dashboard."
            }
        },
        errorElement: 'span',
        errorPlacement(error, element) {
            error.addClass('invalid-feedback');
            element.closest('.form-group').append(error);
        },
        highlight(element) {
            $(element).addClass('is-invalid');
        },
        unhighlight(element) {
            $(element).removeClass('is-invalid');
        }
    });

    let queryString = window.location.href;
    let parametros = queryString.split('/');
    let idDash = parametros[parametros.length - 1];
    let alterando = false;
    let bloqueiaTable = false;

    if (idDash != 'create') {
        if (await liberarRegistro('DASHBOARDAPP', idDash) == false) {
            window.location.href = '../dashboard';
        } else {
            $('#txtIdDash').prop('disabled', true);
            await buscaDadosCampos()
            await buscaDadosTabela();
        }
    } else {
        $('#txtIdDash').focus()
    }

    $('#btnVoltar').on('click', async function () {
        await deletaRegistro('DASHBOARDAPP', getCookie('usuario'), idDash);
        window.location.href = `${BASE_URI}/dashboardapp`;
    });

    async function buscaDadosCampos() {
        $.LoadingOverlay('show')
        try {
            let response = await requisicao('GET', '/Sisplan/Funcoes/v1/pesquisa?',
                `JSON={ "tabela":"DASH_ERP", 
            "camposSelect":["ID_DASH", "TITULO_DASH"], 
            "where": ["ID_DASH = '${idDash}'"]}`, null);

            if (!response) {
                return;
            }
            let jsonStr = await response.json();
            if (response.status != 200) {
                msgErro(jsonStr.RESULT[0].mensagem);
                return;
            }

            $('#txtIdDash').val(jsonStr.RESULT[0][0].ID_DASH)
            $('#txtTituloDash').val(jsonStr.RESULT[0][0].TITULO_DASH)

        } catch (error) {
            console.error(error)
            msgAlerta(error.message)
        } finally {
            $.LoadingOverlay('hide')
        }
    }

    async function buscaDadosTabela() {
        $.LoadingOverlay('show');
        try {
            const url = "/sisplan/cadastros/v1/dashboardapp?";
            const response = await requisicao("GET", url, `IDDASH=${idDash}`, "", 78000);

            if (!response) {
                return;
            }

            const jsonStr = await response.json()
            if (response.status != 200) {
                throw new Error(jsonStr['RESULT'][0].mensagem);
            }

            if (jsonStr.length <= 0) {
                throw new Error('Nenhum registro encontrado!')
            }

            await montaDataTableDash(jsonStr)

        } catch (error) {
            console.error(error);
        } finally {
            $.LoadingOverlay('hide');
        }
    };

    function decodeHTMLEntities(text) {
        var textArea = document.createElement('textarea');
        textArea.innerHTML = text;
        return textArea.value;
    }

    async function montaDataTableDash(jsonStr) {
        let novoRegistro = [];
        for (let i = 0; i < jsonStr.length; i++) {
            novoRegistro = []
            novoRegistro.push(jsonStr[i].ID)
            novoRegistro.push(jsonStr[i].ORDEM)
            novoRegistro.push(jsonStr[i].TITULO)
            novoRegistro.push(jsonStr[i].META)
            novoRegistro.push(decodeHTMLEntities(jsonStr[i].DADOS))

            $('#tabelaDashboards').DataTable().row.add(novoRegistro).draw(false);
        }

        $('#tabelaDashboards').DataTable().columns.adjust().draw(false);
    };

    function retornaBotaoOpcoes(data) {
        var retorno = '<div style="text-align:start;"> ' +
            '    <button class="btn btn-info btn-sm dropdown-toggle btnVerificaOpcoes" type="button" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false"> ' +
            '      ' + data + ' ' +
            '    </button> ' +
            '    <div class="dropdown-menu"> ' +
            '    <button class="dropdown-item" type="button" title="Editar" id="btn-editar">Editar</button>     ' +
            '    <button class="dropdown-item" type="button" title="Excluir" id="btn-excluir">Excluir</button>  ' +
            '</div>';
        return retorno;
    };

    $('#tabelaDashboards').DataTable({
        bPaginate: false,
        search: false,
        destroy: true,
        colReorder: true,
        order: [],
        info: false,
        scrollY: '200px',
        language: {
            sEmptyTable: "Nenhum registro encontrado na tabela de Dashboards",
            sInfo: "_TOTAL_ registros",
            sInfoEmpty: " 0 registros",
            sInfoFiltered: "(Filtrados de _MAX_ registros)",
            sInfoPostFix: "",
            sInfoThousands: ".",
            sLengthMenu: "_MENU_ resultados",
            sLoadingRecords: "Carregando...",
            sProcessing: "Processando...",
            sZeroRecords: "Nenhum registro encontrado na tabela de Dashboards",
            sSearch: "Pesquisar",
            oPaginate: {
                sNext: "Próximo",
                sPrevious: "Anterior",
                sFirst: "Primeiro",
                sLast: "Último",
            },
            oAria: {
                sSortAscending: ": Ordenar colunas de forma ascendente",
                sSortDescending: ": Ordenar colunas de forma descendente",
            },
        },
        autoWidth: true,
        columns: [
            {
                title: 'ID',
                data: 'ID',
            },
            {
                title: 'Ordem',
                data: 'ORDEM',
            },
            {
                title: 'Título',
                data: 'TITULO',
            },
            {
                title: 'Meta',
                data: 'META',
            },
            {
                title: 'Dados',
                data: 'DADOS',
            },
        ],
        columnDefs: [
            {
                targets: [0, 4],
                visible: false,
            },
            {
                targets: [1], render: function (data, type, row) {
                    return retornaBotaoOpcoes(data);
                }
            }
        ],
    });

    $('#tabelaDashboards').on('click', 'tr', async function () {
        if (!bloqueiaTable) {
            $("#tabelaDashboards").dataTable().$("tr.selected").removeClass("selected");
            $(this).addClass('selected')
            let tabela = $("#tabelaDashboards").DataTable()
            let linha = tabela.$("tr.selected");
            let dash = tabela.row(linha).data()
            $('#txtId').val(dash.ID)
            $('#txtOrdem').val(dash.ORDEM)
            $('#txtTitulo').val(dash.TITULO)
            $('#txtMeta').val(dash.META)
            $('#txtSelect').val(decodeHTMLEntities(dash.DADOS))
        }
    })

    if ($('#tabelaDashboards').DataTable().rows().data().length > 0) {
        $('#tabelaDashboards tbody').find('tr:eq(0)').click()
    }

    $('#tabelaDashboards').on('click', '#btn-editar', async function () {
        alterando = true
        rotinaBotoesEdicao(true, false)
    });

    $('#tabelaDashboards').on('click', '#btn-excluir', async function () {
        $.LoadingOverlay('show')
        try {
            await msgAguardaConfirmacao('Deseja realmente excluir o registro selecionado?',
                async () => {
                    let data = $('#tabelaDashboards').DataTable().row($(this).parents('tr'))
                    if (data.data().ID == '') {
                        $('#tabelaDashboards').DataTable().row($(this).parents('tr')).remove().draw(false)
                    } else {
                        await removeItem(data);
                    }
                    $('#txtId').val('')
                    $('#txtOrdem').val('')
                    $('#txtTitulo').val('')
                    $('#txtMeta').val('')
                    $('#txtSelect').val('')
                }
            )
        } catch (error) {
            console.error(error)
            msgAlerta(error.message)
        } finally {
            $.LoadingOverlay('hide')
        }
    });

    $('#btnIncluirDash').on('click', function () {
        $.LoadingOverlay('show')
        try {
            rotinaBotoesEdicao(true, true)
            alterando = false
        } finally {
            $.LoadingOverlay('hide')
        }
    })

    $('#btnConfirmarDash').on('click', async function () {
        $.LoadingOverlay('show')
        try {
            if ($('#txtTitulo').val() == '') {
                throw new Error('Título não informado, impossivel Continuar!')
            }

            if ($('#txtOrdem').val() == '') {
                throw new Error('Ordem não informada, impossivel Continuar!')
            }

            if ($('#txtSelect').val() == '') {
                throw new Error('Select não informado, impossivel Continuar!')
            }

            await validaSelect($('#txtSelect').val())

            if (alterando) {
                await insereRegistroDash(true, $("#tabelaDashboards").dataTable().$("tr.selected").index())
            } else {
                await insereRegistroDash(false)
            }

            rotinaBotoesEdicao(false, true)
        } catch (error) {
            console.error(error)
            msgAlerta(error.message)
        } finally {
            $.LoadingOverlay('hide')
        }
    })

    $('#btnDesistirDash').on('click', function () {
        $.LoadingOverlay('show')
        try {
            rotinaBotoesEdicao(false, true)
            alterando = false
        } finally {
            $.LoadingOverlay('hide')
        }
    })

    function rotinaBotoesEdicao(incluindo = true, confirmandoRegistro = false) {
        if (incluindo) {
            $('#btnConfirmarDash').removeClass('d-none')
            $('#btnDesistirDash').removeClass('d-none')
            $('#btnIncluirDash').addClass('d-none')
        } else {
            $('#btnConfirmarDash').addClass('d-none')
            $('#btnDesistirDash').addClass('d-none')
            $('#btnIncluirDash').removeClass('d-none')
        }
        $('#txtOrdem').prop('disabled', !incluindo)
        $('#txtTitulo').prop('disabled', !incluindo)
        $('#txtMeta').prop('disabled', !incluindo)
        $('#txtSelect').prop('disabled', !incluindo)
        $('#btnVoltar').prop('disabled', incluindo)
        $('#btnGravar').prop('disabled', incluindo)
        bloqueiaTable = incluindo
        if (confirmandoRegistro) {
            $("#tabelaDashboards").dataTable().$("tr.selected").removeClass("selected");
            $('#txtId').val('')
            $('#txtOrdem').val('')
            $('#txtTitulo').val('')
            $('#txtMeta').val('')
            $('#txtSelect').val('')
        }
    }

    $('#txtOrdem').on('blur', function () {
        $.LoadingOverlay('show')
        try {
            if ($(this).val() == '') {
                let tabela = $('#tabelaDashboards').DataTable().data().toArray()
                const maxOrdem = Math.max(...tabela.map(item => item.ORDEM))
                const novaOrdem = isNaN(parseInt(maxOrdem) + 1) ? 1 : (parseInt(maxOrdem) + 1)
                $(this).val(novaOrdem)
            } else {
                for (let i = 0; i < $('#tabelaDashboards').DataTable().data().toArray().length; i++) {
                    let ordemAtual = $('#tabelaDashboards').DataTable().data().toArray()[i].ORDEM

                    if (parseInt($(this).val()) == parseInt(ordemAtual)) {
                        $(this).val('')
                        $(this).focus()
                        throw new Error(`Ordem ${$(this).val()} ja cadastrada nesse Id Dash, `)
                    }
                }
            }
        } catch (error) {
            console.error(error)
            msgAlerta(error.message)
        } finally {
            $.LoadingOverlay('hide')
        }
    })

    async function insereRegistroDash(alterando, indiceLinha = 0) {
        $.LoadingOverlay('show')
        try {
            try {
                const id = $('#txtId').val()
                const ordem = $('#txtOrdem').val()
                const titulo = $('#txtTitulo').val()
                const meta = $('#txtMeta').val() ?? 0
                const select = $('#txtSelect').val()

                const novoRegistro = {
                    ID: id,
                    ORDEM: ordem,
                    TITULO: titulo,
                    META: meta,
                    DADOS: select
                }

                if (alterando) {
                    $('#tabelaDashboards').DataTable().row(indiceLinha).data(novoRegistro).draw(false);
                } else {
                    $('#tabelaDashboards').DataTable().row.add(novoRegistro).draw(false);
                }

                alterando = false;
            } catch (error) {
                console.error(error)
            }
        } finally {
            $.LoadingOverlay('hide')
        }
    }

    async function validaSelect(select) {
        const url = "/sisplan/cadastros/v1/dashboardapp?";
        const response = await requisicao("PUT", url, null, `&JSON=${encodeURIComponent(JSON.stringify(select))}`, 78000);

        if (!response) {
            return;
        }

        const jsonStr = await response.json()
        if (response.status != 200 || jsonStr.mensagem != '') {
            throw new Error(jsonStr.mensagem);
        }

        if (jsonStr.length <= 0) {
            throw new Error('Nenhum registro encontrado!')
        }
    }

    async function removeItem(data) {
        let valorLinha = data.data();
        const url = "/sisplan/cadastros/v1/dashboardapp?"
        const response = await requisicao("DELETE", url, `IDDASH=${valorLinha.ID}`);
        if (!response) {
            return;
        }
        if (response.status != 200) {
            let jsonStr = await response.json();
            msgErro(jsonStr.mensagem);
            return;
        }

        toastr.success("Exclusão efetuada com sucesso!", "Confirmação", {
            toastClass: "success",
            iconClasses: {
                error: "alert-error",
                info: "alert-info",
                success: "alert-success",
                warning: "alert-warning",
            },
            positionClass: "toast-top-center",
            progressBar: true,
            timeOut: 3000,
            fadeOut: 1000,
            onHidden() {
                data.remove().draw(false);
            },
        }).css({
            "margin-top": "20%",
            width: "500px",
            "max-width": "500px",
        });
    }

    $('#txtIdDash').on('blur', async function () {
        $.LoadingOverlay('show')
        try {
            if (idDash == 'create') {
                if ($('#txtIdDash').val() != '') {
                    const validaCodigo = await buscaValor('DASH_ERP', 'ID_DASH', 'ID_DASH', $(this).val());

                    if (validaCodigo != undefined && validaCodigo != '') {
                        msgErro(`Dashboard: ${$(this).val()} já cadastrado!`);
                        $('#txtIdDash').val('');
                        $('#txtIdDash').focus();
                        return;
                    };
                }
            }
            let response = await requisicao('GET', '/Sisplan/Funcoes/v1/pesquisa?',
                `JSON={ "tabela":"DASH_ERP", 
            "camposSelect":["MAX(ID_DASH)"], 
            "where": null}`, null);

            if (!response) {
                return;
            }
            let jsonStr = await response.json();
            if (response.status != 200) {
                msgErro(jsonStr.RESULT[0].mensagem);
                return;
            }

            $('#txtIdDash').val(parseInt(jsonStr.RESULT[0][0].MAX) + 1)
        } catch (error) {
            console.error(error)
            msgAlerta(error.message)
        } finally {
            $.LoadingOverlay('hide')
        }
    })

    $('#txtIdDash').on('blur', async function () {
        $.LoadingOverlay('show');
        try {
            if (idDash == 'create') {
                const id = $('#txtIdDash').val()
                if (id != '') {
                    const validaCodigo = await buscaValor('DASH_ERP', 'ID_DASH', 'ID_DASH', id);

                    if (validaCodigo != undefined && validaCodigo != '') {
                        msgErro('Dashboard já cadastrado, favor verificar.');

                        $('#txtIdDash').focus();
                        return;
                    };
                }
            }
        } catch (e) {
            console.error(e);
            msgErro(`Não foi possível buscar os dados: ${e}`);

        } finally {
            $.LoadingOverlay('hide');
        }
    });

    $('#btnGravar').on('click', async function () {
        let validator = $("#msform").validate();
        validator.form();
        let erros = 0;
        erros = validator.numberOfInvalids();

        if (erros == 0) {
            try {
                $.LoadingOverlay("show");

                const dash = {};

                dash.IDDASH = $('#txtIdDash').val();
                dash.TITULODASH = $('#txtTituloDash').val();
                dash.TIPODASH = 'M'
                dash.ITENS = $('#tabelaDashboards').DataTable().data().toArray();

                let response = await requisicao('POST', '/Sisplan/Cadastros/v1/dashboardapp?', null, `&JSON=${encodeURIComponent(JSON.stringify(dash))}`, 760000);

                if (!response) {
                    $.LoadingOverlay("hide");
                    return;
                };

                let jsonStr = await response.json();
                if (response.status != 200) {
                    $.LoadingOverlay("hide");
                    msgErro(jsonStr.mensagem);
                    return;
                }
                $.LoadingOverlay("hide");
                toastr.success(
                    `Cadastro efetuado com sucesso!`,
                    'Confirmação', {
                    toastClass: 'alert',
                    iconClasses: {
                        error: 'alert-error',
                        info: 'alert-info',
                        success: 'alert-success',
                        warning: 'alert-warning'
                    },
                    positionClass: "toast-top-center",
                    progressBar: true,
                    timeOut: 3000,
                    fadeOut: 1000,
                    onHidden() {
                        window.location.href = `${BASE_URI}/dashboardapp`;
                    }
                }
                ).css({
                    "margin-top": "20%",
                    "width": "500px",
                    "max-width": "500px"
                });

            } catch (error) {
                console.error(error);
                $.LoadingOverlay("hide");
            }
        }
    });
});