$("#tutorial").on("click", function () {
    $(document).ready(async function () {
        const driver = new Driver({
            doneBtnText: "Sair",
            closeBtnText: "Fechar",
            nextBtnText: "Próximo",
            prevBtnText: "Anterior",
            allowClose: false,
            animate: true,
        });

        driver.defineSteps([
            {
                element: "#campostuto",
                popover: {
                    title: "Dados Gerais",
                    description: "Aqui estão os campos disponíveis para o cadastro.",
                    position: "top",
                },
            },
            {
                element: "#txtCodigo",
                popover: {
                    title: "Campos Obrigatórios",
                    description:
                        "Esse é um campo obrigatório, para identificá-los, você verá um * ao lado do nome.",
                    position: "top",
                },
            },
            {
                element: "#txtDescricao",
                popover: {
                    title: "Campos Obrigatórios",
                    description:
                        "Este campo tem por sua funcionalidade conter a descrição do nome do Histórico.",
                    position: "top",
                },
            },
            {
                element: "#gravar",
                popover: {
                    title: "Botão Gravar",
                    description: "Clique aqui para gravar um Histórico.",
                    position: "left",
                },
            },
        ]);
        driver.start();
    });
});

$(document).ready(async function () {
    bloqueiaCampoMoeda()

    let erros = 0;
    let geraCaixaLoja;
    bSleep = false;
    await filtrosConsultaCheque();
    const gravaChequeCaixa = await CopiaParametro("RECEBER", 3);
    const validarCreditoCliente = await CopiaParametro("RECEBER", 4);
    const validarCreditoGrupo = await CopiaParametro("RECEBER", 5);
    const validarCampoPedido = await CopiaParametro("RECEBER", 13) == '1';
    await setarDataAtual('dtEmissao');
    await verificaPermissoes('CHEQUE');
    $('#dtEmissao').prop('disabled', true);
    $('#dtEmissao').prop('readonly', true);

    if (gravaChequeCaixa == '1') {
        $('#caixa').removeClass('d-none');
        $('#moeda').removeClass('d-none');
    } else {
        $('#nrCaixa').addClass('d-none');
        $('#Moeda').addClass('d-none');
    }

    if (gravaChequeCaixa == '0' && validarCreditoGrupo == '0') {
        $('#Conta').removeClass('col-md-6')
        $('#Conta').addClass('col-md-4')
        $('#Banco').removeClass('col-md-6')
        $('#Banco').addClass('col-md-12')
    }
    let queryString = window.location.href;
    let parametros = queryString.split("/");
    let numero = parametros[parametros.length - 1];

    async function filtrosConsultaCheque() {
        //AUTOCOMPLETE
        $('#txtCliente').autocompleta(1, `JSON={ "tabela": "ENTIDADE", "camposSelect":[ "CODCLI CHAVE", "NOME DESCRICAO"], "where": null }`);
        $('#txtRepresentante').autocompleta(1, `JSON={ "tabela": "REPRESEN", "camposSelect":[ "CODREP CHAVE", "NOME DESCRICAO"], "where": null }`);
        $('#txtHistorico').autocompleta(1, `JSON={ "tabela":"HISTCP", "camposSelect":[ "HISTORICO chave", "DESCRICAO DESCRICAO"], "where": null}`);
        $('#txtClasse').autocompleta(1, `JSON={ "tabela": "CLASSE_GER", "camposSelect":[ "CODIGO CHAVE", "DESCRICAO DESCRICAO"], "where": null }`);
        $('#txtSituacao').autocompleta(1, `JSON={ "tabela": "TABSIT", "camposSelect":[ "CODIGO CHAVE", "DESCRICAO DESCRICAO"], "where": null }`);
        $('#txtSituacao').autocompleta(1, `JSON={ "tabela": "TABSIT", "camposSelect":[ "CODIGO CHAVE", "DESCRICAO DESCRICAO"], "where": null }`);
        $("#txtBanco").autocompleta(1, `JSON={ "tabela":"cadban", "camposSelect":[ "banco chave", "nome_banco descricao"], "where": null}`);
        $("#txtConta").autocompleta(1, `JSON={ "tabela":"CADCONTA", "camposSelect":[ "CONTA chave", "DESCRICAO descricao"], "where": null}`);
        $('#txtCaixa').autocompleta(2, `JSON={ "tabela":"caixa_loja", "camposSelect":[ "codigo CHAVE", "descricao"], "where": null}`);

        //SEARCH ALL
        $('#btnCliente').pesquisa_serverside(['#txtCliente'], ['CODCLI'], ['NOME'], '{"tabela":"ENTIDADE", "camposSelect":[ "CODCLI", "NOME"], "where": null}', 'Pesquisa Cliente');
        $("#btnRepresentante").pesquisa_serverside(["#txtRepresentante"], ["CODREP"], ["NOME"], '{"tabela":"REPRESEN", "camposSelect":[ "CODREP", "NOME"], "where": null}', "Pesquisa Representante");
        $("#btnHistorico").pesquisa("#txtHistorico", "HISTORICO", "DESCRICAO", `/sisplan/funcoes/v1/pesquisa?JSON={ "tabela":"HISTCP", "camposSelect":[ "HISTORICO", "DESCRICAO"], "where": null}`, "Pesquisa Histórico", "HISTCP");
        $("#btnClasse").pesquisa("#txtClasse", "CODIGO", "DESCRICAO", `/sipslan/funcoes/v1/pesquisa?JSON={ "tabela":"CLASSE_GER", "camposSelect":[ "CODIGO", "DESCRICAO"], "where": null}`, "Pesquisa Classe Gerencial", "CLASSE_GER");
        $('#btnSituacao').pesquisa("#txtSituacao", "CODIGO", "DESCRICAO", `/sisplan/funcoes/v1/pesquisa?JSON={ "tabela":"TABSIT", "camposSelect":[ "CODIGO", "DESCRICAO"], "where": null}`, "Pesquisa Situação", "TABSIT");
        $("#btnBanco").pesquisa("#txtBanco", "BANCO", "NOME_BANCO", `/sisplan/funcoes/v1/pesquisa?JSON={ "tabela":"cadban", "camposSelect":[ "banco", "nome_banco"]}`, "Pesquisa Banco", "cadban");
        $("#btnConta").pesquisa("#txtConta", "CONTA", "DESCRICAO", `/sisplan/funcoes/v1/pesquisa?JSON={ "tabela":"CADCONTA", "camposSelect":[ "CONTA", "DESCRICAO"]}`, "Pesquisa Conta", "cadconta");
        $('#btnCaixa').pesquisa('#txtCaixa', 'CODIGO', 'DESCRICAO', '/sisplan/funcoes/v1/pesquisa?JSON={ "tabela":"caixa_loja", "camposSelect":[ "codigo", "descricao"], "where": null}', 'Pesquisa Caixa', 'caixa_loja');
    }

    //GERA O DATATABLE
    $('#tabelaCheques').DataTable({
        paging: false,
        filter: false,
        info: false,
        ordering: false,
        destroy: true,
        scrollY: '400px',
        "language": {
            "sEmptyTable": "Preencha os campos acima para preencher o cheque.",
            "sInfo": "_TOTAL_ registros",
            "sInfoEmpty": " 0 registros",
            "sInfoFiltered": "(Filtrados de _MAX_ registros)",
            "sInfoPostFix": "",
            "sInfoThousands": ".",
            "sLengthMenu": "_MENU_ resultados",
            "sLoadingRecords": "Carregando...",
            "sProcessing": "Processando...",
            "sZeroRecords": "Nenhum registro encontrado",
            "sSearch": "Pesquisar",
            "oPaginate": {
                "sNext": "Próximo",
                "sPrevious": "Anterior",
                "sFirst": "Primeiro",
                "sLast": "Último"
            },
            "oAria": {
                "sSortAscending": ": Ordenar colunas de forma ascendente",
                "sSortDescending": ": Ordenar colunas de forma descendente"
            }
        }
    });

    //VALIDA CAMPOS PREENCHIDOS E ADICIONAR LINHA DE CHEQUE
    $('#btnIncluirCheque').on('click', function () {
        const camposObrigatorios = ['#txtCliente', '#txtRepresentante', '#txtHistorico', '#txtClasse', '#txtSituacao'];
        for (const campo of camposObrigatorios) {
            if ($(campo).val() == '') {
                msgErro(`Preencha o campo ${$(campo).attr('placeholder')} antes de adicionar o cheque.`);
                return;
            }
        }
        $('#txtCliente').prop('disabled', true);
        $('#btnCliente').prop('disabled', true);
        $('#btnLimpaCliente').prop('disabled', true);
        geraLinhaTabela();
    });

    $('#txtCliente').on('blur', async function () {
        if ($(this).val() != '') {
            let sCodCli = pegaChave('#txtCliente');
            if ($('#txtMoeda').prop('disabled')) {
                $('#txtMoeda').attr('disabled', false)
                $('#btnMoeda').attr('disabled', false)
                $('#btnLimpaMoeda').attr('disabled', false)
            }
            const existeEntMoeda = await buscaValor('ENT_MOEDA', 'CODMOE', 'CODCLI', sCodCli)
            if (existeEntMoeda) {
                $("#txtMoeda").autocompleta(1, `JSON={"tabela":"ENT_MOEDA",
                                                  "camposSelect":[ "ENT_MOEDA.CODMOE CHAVE", "MOEDA.DESCRICAO DESCRICAO" ],
                                                  "leftjoin":[{"tabela": "MOEDA", "condicao": "ENT_MOEDA.CODMOE = MOEDA.CODMOE"}],
                                                  "where": ["ENT_MOEDA.CODCLI = '${sCodCli}' AND DESCRICAO LIKE '[PERCENTUAL]CHEQUE[PERCENTUAL]'"]}`); //MOEDA.TIPO = '1'

                $('#btnMoeda').pesquisa_serverside(['#txtMoeda'], ['ENT_MOEDA.CODMOE'], ['MOEDA.DESCRICAO'],
                    `{"tabela":"ENT_MOEDA",
                "camposSelect":[ "ENT_MOEDA.CODMOE", "MOEDA.DESCRICAO" ],
                "leftjoin": [{"tabela": "MOEDA", "condicao": "ENT_MOEDA.CODMOE = MOEDA.CODMOE"}],
                "where": ["ENT_MOEDA.CODCLI = '${sCodCli}' AND DESCRICAO LIKE '[PERCENTUAL]CHEQUE[PERCENTUAL]'"]}`,
                    'Pesquisa Moeda', null, false);
            } else {
                $('#txtMoeda').autocompleta(1, `JSON={ "tabela":"moeda", "camposSelect":[ "codmoe CHAVE", "descricao"], "where": ["DESCRICAO LIKE '[PERCENTUAL]CHEQUE[PERCENTUAL]'"]}`);
                $('#btnMoeda').pesquisa('#txtMoeda', 'CODIGO', 'DESCRICAO', `/sisplan/funcoes/v1/pesquisa?JSON={ "tabela":"moeda", "camposSelect":[ "codmoe codigo", "descricao"], "where": ["DESCRICAO LIKE '[PERCENTUAL]CHEQUE[PERCENTUAL]'"]}`, 'Pesquisa Moeda', 'moeda');
            }
        }
    });

    function bloqueiaCampoMoeda() {
        if (!$('#txtCliente').val()) {
            $('#txtMoeda').attr('disabled', true)
            $('#btnMoeda').attr('disabled', true)
            $('#btnLimpaMoeda').attr('disabled', true)
        }
    }

    async function BuscaDadosMoeda(moeda) {
        $.LoadingOverlay('show');
        try {

            result = { BANCO: '', DESC_BANCO: '', CONTA: '' };
            let response = await requisicao(
                "GET",
                "/Sisplan/Funcoes/v1/pesquisa?",
                `JSON={ "tabela":"MOEDA", "camposSelect":["MOEDA.CONTA", "MOEDA.BANCO", "CADBAN.NOME_BANCO"],
                        "leftjoin": [{"tabela": "CADBAN", "condicao": "MOEDA.BANCO = CADBAN.BANCO"}],
                        "where": ["CODMOE = ${moeda}"]}`,
                null
            );
            if (!response) {
                return result;
            }
            let jsonStr = await response.json();
            if (response.status != 200) {
                return result;
            }

            if (jsonStr.RESULT[0].length == 0) {
                return result;
            }

            result = { BANCO: jsonStr.RESULT[0][0].BANCO, DESC_BANCO: jsonStr.RESULT[0][0].NOME_BANCO, CONTA: jsonStr.RESULT[0][0].CONTA };

            return result;
        } catch (e) {
            console.log(e);
        } finally {
            $.LoadingOverlay('hide');
        }
    }

    //GERA LINHA DE CHEQUE
    async function geraLinhaTabela() {
        let novoTamanho = 0;
        if (!$('#tabelaCheques').DataTable().rows().data().length) {
        } else if (!!$('#tabelaCheques').DataTable().rows().data().length) {
            novoTamanho = $('#tabelaCheques').DataTable().rows().data().length
        }

        let CNPJCli = await buscaValor('ENTIDADE', 'CNPJ', 'CODCLI', `${pegaChave('#txtCliente')}`)

        const moeda = pegaChave('#txtMoeda');
        const dadosMoeda = await BuscaDadosMoeda(moeda);
        const banco = dadosMoeda.BANCO != '' ? dadosMoeda.BANCO : '';

        //LINHAS DO DATA TABLE
        $('#tabelaCheques').DataTable().row.add([
            pegaDescricao('#txtCliente'),
            CNPJCli.CNPJ,
            `<input type="text" placeholder="Banco CH" value="${banco}" id="banco_col_${novoTamanho}_row_2" class="input-default focus form-control campoBanco"> `,
            `<input type="text" value="" placeholder="Agência CH" class="input-default focus form-control campoAgencia">`,
            `<input type="text" value="${''}" placeholder="Conta CH" class="input-default focus form-control campoConta">`,
            `<input type="text" value="" placeholder="Número do Cheque" class="input-default focus form-control campoNumero">`,
            `<input type="date" value="" placeholder="Vencimento" class="input-default focus form-control campoVencimento">`,
            `<input type="text" value="" id="campoValor" placeholder="Valor" class="input-default focus form-control campoValor">`,

            `<div class="input-group-append">
                <input type="text"
                    class="input-default focus form-control validate campoPedido" style="min-width: 20ch; max-width: 30ch" id="pedido_row_${novoTamanho}" name="pedido_row_${novoTamanho}" placeholder="Pedido">
                    <div class="input-group-append">
                    <button class="btn bg-danger" id="btnPedido_${novoTamanho}" name="btnPedido_${novoTamanho}" data-button="absolute" type="button"><i class="m-0 p-0 fas fa-search"></i></button>
                    <button class="btn bg-danger" id="btnLimpaPedido_${novoTamanho}" name="btnLimpaPedido_${novoTamanho}" type="button"><i class="m-0 p-0 fas fa-trash"></i></button>
                </div>
            </div>`,
            `<button type="button" class="btn btn-sm btn-danger campoExcluirCheque" value="">Excluir</button>`,
            `<button type="button" title="Ler cheque" class="btn btn-primary btnLerCheque"><i class="fas fa-download"></i></button>`
        ]).draw(false);

        // for (let i = 0; i < $('#tabelaCheques').DataTable().rows().data().length; i++) {
        //     $(`#banco_col_${novoTamanho}_row_2`).pesquisa(
        //         `#banco_col_${novoTamanho}_row_2`,
        //         "BANCO",
        //         "NOME_BANCO",
        //         '/sisplan/funcoes/v1/pesquisa?JSON={ "tabela":"cadban", "camposSelect":[ "banco", "nome_banco"], "where": null}',
        //         "Pesquisa Banco",
        //         "cadban"
        //     );
        // }

        for (let i = 0; i < $('#tabelaCheques').DataTable().rows().data().length; i++) {
            $(`#pedido_row_${novoTamanho}`).autocompleta(1, `JSON={ "tabela":"PEDIDO", "camposSelect":[ "PEDIDO.NUMERO CHAVE", "ENTIDADE.NOME DESCRICAO"], "innerjoin":[{"tabela" : "ENTIDADE", "condicao" : "ENTIDADE.CODCLI = PEDIDO.CODCLI"}, {"tabela" : "PED_ITEN", "condicao" : "PED_ITEN.NUMERO = PEDIDO.NUMERO"}], "groupby":  ["PEDIDO.NUMERO", "ENTIDADE.NOME"], "where": ["PED_ITEN.QTDE > 0", "PEDIDO.CODCLI = '${pegaChave('#txtCliente')}'"]}`);
            $(`#btnPedido_${novoTamanho}`).pesquisa_serverside([`#pedido_row_${novoTamanho}`], ["PEDIDO.NUMERO"], ["ENTIDADE.NOME"], `{
                "tabela":"PEDIDO", 
                "camposSelectSubSelect": ["NUMERO", "CODCLI", "NOME", "DT_EMISSAO", "DT_FATURA", "QTDE"],
                "camposSelect":[
                    "PEDIDO.NUMERO", 
                    "PEDIDO.CODCLI",
                    "ENTIDADE.NOME", 
                    "PEDIDO.DT_EMISSAO", 
                    "PEDIDO.DT_FATURA",
                    "SUM(PED_ITEN.QTDE) QTDE"
                ], 
                "innerjoin": [
                    {"tabela" : "PED_ITEN", "condicao" : "PED_ITEN.NUMERO = PEDIDO.NUMERO"},
                    {"tabela" : "ENTIDADE", "condicao" : "ENTIDADE.CODCLI = PEDIDO.CODCLI"}
                ],
                "groupby":  ["PEDIDO.NUMERO", "PEDIDO.CODCLI", "ENTIDADE.NOME", "PEDIDO.DT_EMISSAO", "PEDIDO.DT_FATURA"],  
                "groupBySubSelect": ["NUMERO", "CODCLI", "NOME", "DT_EMISSAO", "DT_FATURA", "QTDE"],
                "where": ["PED_ITEN.QTDE > 0", "PEDIDO.CODCLI = '${pegaChave('#txtCliente')}'"]
            }`, 'Pesquisa de Pedido');
            $(`#btnLimpaPedido_${novoTamanho}`).on('click', function () {
                $(`#pedido_row_${novoTamanho}`).val('');
            });
        }

        $('.campoValor').maskMoney({
            decimal: ',',
            thousands: '.',
            precision: 2,
            allowZero: true,
            defaultZero: true,
            min: 0,
            max: 99
        });

    }
    if (validarCreditoGrupo == '1') {
        $('#moeda').removeClass('d-none');
    }

    //EXCLUI LINHA DE CHEQUE
    $('#tabelaCheques tbody').on('click', '.campoExcluirCheque', function () {
        $('#tabelaCheques').DataTable().row($(this).parents('tr')).remove().draw(false);
        if ($('#tabelaCheques').DataTable().rows().count() <= 0) {
            $('#txtCliente').prop('disabled', false);
            $('#btnCliente').prop('disabled', false);
            $('#btnLimpaCliente').prop('disabled', false);
        }
    });

    $('#btnLimpaRepresentante').on('click', function () {
        $('#txtRepresentante').val('');
    });

    $('#btnLimpaHistorico').on('click', function () {
        $('#txtHistorico').val('');
    });

    $('#btnLimpaSituacao').on('click', function () {
        $('#txtSituacao').val('');
    });

    $('#btnLimpaCaixa').on('click', function () {
        $('#txtCaixa').val('');
    });

    $('#btnLimpaClasse').on('click', function () {
        $('#txtClasse').val('');
    });

    $('#btnLimpaMoeda').on('click', function () {
        $('#txtMoeda').val('');
    });

    $('#btnLimpaCliente').on('click', function () {
        $('#txtCliente').val('');
        bloqueiaCampoMoeda()
    });

    $('#btnLimpaConta').on('click', function () {
        $('#txtConta').val('');
    });
    $('#btnLimpaBanco').on('click', function () {
        $('#txtBanco').val('');
    });

    // ADICIONA EVENTOS NOS CA'MPOS DA TABELA, COMO LER O CHEQUE E PREENCHER OS CAMPOS COM A BARRA
    function adicionaEventosCamposTabela() {
        $('#tabelaCheques tbody').on('click', ".btnLerCheque", async function () {
            try {
                try {
                    $(this).attr("disabled", "true");
                    $.LoadingOverlay("show");
                    const posicao = $(this).parents("tr")[0].rowIndex - 1;
                    //CHAMA ROTINA LER CHEQUE
                    await LerCheque(posicao);
                } finally {
                    $.LoadingOverlay("hide");
                    $(this).removeAttr("disabled");
                }
            } catch (error) {
                msgErro("Erro ao ler cheque.");
                $(this).removeAttr("disabled");
            }
        });

        $(".campoBanco").on("blur", function () {
            for (let i = 0; i < $(".campoBanco").length; i++) {
                if ($($(".campoBanco")[i]).val() == "") {
                    $($(".campoBanco")[i]).val($(this).val());
                }
            }
        });

        // Ler barra e prenche os campos.
        $(document).on("blur", ".campoAgencia", function () {
            const bLeu = preencheDadosCheque(this);
            if (bLeu) {
                for (let i = 0; i < $(".campoAgencia").length; i++) {
                    if ($($(".campoAgencia")[i]).val() == "") {
                        $($(".campoAgencia")[i]).val($(this).val());
                    }
                }
            }
        });

        $(document).on("blur", ".campoConta", function () {
            const bLeu = preencheDadosCheque(this);
            if (bLeu) {
                for (let i = 0; i < $(".campoConta").length; i++) {
                    if ($($(".campoConta")[i]).val() == "") {
                        $($(".campoConta")[i]).val($(this).val());
                    }
                }
            }
        });

        $(document).on("blur", ".campoNumero", function () {
            const bLeu = preencheDadosCheque(this);
            if (bLeu) {
                if ($(this).val() == "") {
                    return;
                }
                for (let i = 0; i < $(".campoNumero").length; i++) {
                    if ($($(".campoNumero")[i]).val() == "") {
                        $($(".campoNumero")[i]).val(parseInt($(this).val()) + i);
                    }
                }
            }
        });

        $('.campoAgencia').keydown(function (e) {
            if (e.which === 13) {
                e.preventDefault();
                $('.campoAgencia').trigger('blur');
            }
        });

        $('.campoConta').keydown(function (e) {
            if (e.which === 13) {
                e.preventDefault();
                $('.campoConta').trigger('blur');
            }
        });

        $('.campoNumero').keydown(function (e) {
            if (e.which === 13) {
                e.preventDefault();
                $('.campoNumero').trigger('blur');
            }
        });
    }

    $('#txtMoeda').on('focusout', async function () {
        try {
            if ($(this).val() != '') {

                let moeda = pegaChave($(this));
                let situacao = (await buscaValor('MOEDA', 'CODSIT', 'CODMOE', parseFloat(moeda))).CODSIT
                let historico = (await buscaValor('MOEDA', 'HISTORICO', 'CODMOE', parseFloat(moeda))).HISTORICO
                let classe = (await buscaValor('MOEDA', 'CLASSE', 'CODMOE', parseFloat(moeda))).CLASSE
                let conta = (await buscaValor('MOEDA_CONTA', 'CONTA', `MOEDA = ${moeda} AND EMPRESA`, `${getCookie('empresa').replace('_', '').trim()}`)).CONTA
                let banco = (await buscaValor('MOEDA', 'BANCO', 'CODMOE', parseFloat(moeda))).BANCO

                conta = !conta ? '' : conta
                insereValor(`#txtSituacao`, situacao, { tabela: 'TABSIT', campoBusca: 'DESCRICAO', campoWhere: 'CODIGO', valorWhere: situacao })
                insereValor(`#txtHistorico`, historico, { tabela: 'HISTCP', campoBusca: 'DESCRICAO', campoWhere: 'HISTORICO', valorWhere: historico })
                insereValor(`#txtClasse`, classe, { tabela: 'CLASSE_GER', campoBusca: 'DESCRICAO', campoWhere: 'CODIGO', valorWhere: classe })
                insereValor(`#txtConta`, conta, { tabela: 'CADCONTA', campoBusca: 'DESCRICAO', campoWhere: 'CONTA', valorWhere: conta })
                insereValor(`#txtBanco`, banco, { tabela: 'CADBAN', campoBusca: 'NOME_BANCO', campoWhere: 'BANCO', valorWhere: banco })

            }
        } catch (error) {
            console.log(error)
            throw msgAlerta('Não foi possível buscar os dados da moeda (SITUAÇÃO, HISTÓRIO E CLASSE), verifique!')
        }
    })

    async function gravaReceber(bLimiteGrupo = true, bLimiteCliente = true) {
        let listaCheques = {};
        let listaAntecipacao = {};
        if (erros == 0) {
            if (bLimiteGrupo) {
                await verificaLimiteCreditoGrupo();
            }
            if (bLimiteCliente) {
                await verificaLimiteCreditoCliente();
            }
            try {
                $.LoadingOverlay("show");
                await validaData();
                // await verificaCamposPreenchidos();
                const cheques = $("#tabelaCheques").DataTable().data().toArray();
                const classe = pegaChave("#txtClasse");
                const banco = pegaChave("#txtBanco");
                const situacao = pegaChave("#txtSituacao");
                const representante = pegaChave("#txtRepresentante");
                const codcli = pegaChave("#txtCliente");
                const nome = pegaDescricao("#txtCliente");
                const historico = pegaChave('#txtHistorico');
                const cpf_cnpj = await buscaValor('ENTIDADE', 'CNPJ', 'CODCLI', `${pegaChave('#txtCliente')}`)
                const caixa = pegaChave('#txtCaixa');
                const conta = pegaChave('#txtConta');
                const moeda = pegaChave('#txtMoeda');
                const obs = $('#txtObservacao').val() != '' ? $('#txtObservacao').val() : '';

                try {
                    // PEGA AS INFORMAÇÕES DAS DE CHEQUE NO DATATABLE
                    listaCheques = cheques.map((cheque, index) => {
                        const dataVencimento = $($(".campoVencimento")[index]).val();
                        const bancoCH =
                            $($(".campoBanco")[index]).val() != undefined
                                ? $($(".campoBanco")[index]).val()
                                : "";
                        const agenciaCH =
                            $($(".campoAgencia")[index]).val() != undefined
                                ? $($(".campoAgencia")[index]).val()
                                : "";
                        const contaCH =
                            $($(".campoConta")[index]).val() != undefined
                                ? $($(".campoConta")[index]).val()
                                : "";
                        const numeroCH =
                            $($(".campoNumero")[index]).val() != undefined
                                ? $($(".campoNumero")[index]).val()
                                : "";
                        const valorCheque = parseFloat(
                            $($(".campoValor")[index]).val().replace(".", "").replace(",", ".")
                        );
                        const pedido =
                            $($('.campoPedido')[index]).val() != undefined
                                ? pegaChave($($(".campoPedido")[index]).val())
                                : "";

                        return {
                            NUMERO: RetornaProximo('RECEBER', 'RECEBER', 'NUMERO', 6),
                            LANCAMENTO: "",
                            FATURA: "",
                            BANCO: banco,
                            CODCLI: codcli,
                            CPF_CNPJ: cpf_cnpj.CNPJ,
                            CONTA: conta,
                            NOME: nome,
                            VALOR: valorCheque,
                            VALOR2: valorCheque,
                            DT_VENCTO: `${dataVencimento}`,
                            DT_EMISSAO: `${new Date().toISOString().slice(0, 10)}`,
                            STATUS: "CHEQ",
                            CODREP: representante,
                            SITUACAO: situacao,
                            CLASSE: classe,
                            NUMERO_CH: numeroCH,
                            AGENCIA_CH: agenciaCH,
                            BANCO_CH: bancoCH,
                            CNPJ_CH: cpf_cnpj.CNPJ,
                            CONTA_CH: contaCH,
                            CONTA_CHEQUE: conta,
                            EMISSOR_CH: nome,
                            HISTORICO: historico,
                            MOEDA: moeda,
                            NRCAIXA: caixa,
                            TIPFAT: 'W',
                            GERACAIXALOJA: geraCaixaLoja,
                            OBS: isChecked('#cbLancarAnte') ? `Criado antecipação para cheque ${numero}` : obs,
                            PEDIDO: pedido
                        };
                    });

                    if (isChecked('#cbLancarAnte')) {
                        listaAntecipacao = cheques.map((cheque, index) => {
                            const dataVencimento = $($(".campoVencimento")[index]).val();
                            const banco =
                                $($(".campoBanco")[index]).val() != undefined
                                    ? $($(".campoBanco")[index]).val()
                                    : "";
                            const conta =
                                $($(".campoConta")[index]).val() != undefined
                                    ? $($(".campoConta")[index]).val()
                                    : "";
                            const numero =
                                $($(".campoNumero")[index]).val() != undefined
                                    ? $($(".campoNumero")[index]).val()
                                    : "";
                            const valorCheque = parseFloat(
                                $($(".campoValor")[index]).val().replace(".", "").replace(",", ".")
                            );

                            return {
                                VALOR: valorCheque,
                                VALOR2: valorCheque,
                                DT_EMISSAO: `${new Date().toISOString().slice(0, 10)}`,
                                DT_VENCTO: `${dataVencimento}`,
                                STATUS: 'ANTE',
                                OBS: `Antecipação do cheque ${numero}.`,
                                CODREP: representante,
                                CODCLI: codcli,
                                SITUACAO: situacao,
                                CLASSE: classe,
                                BANCO: banco,
                                MOEDA: moeda,
                                NRCAIXA: caixa,
                                CONTA_CH: conta,
                                NUMERO_CH: numero,
                                TIPFAT: 'W',
                                GERACAIXALOJA: geraCaixaLoja
                            };
                        })
                    }
                    //CARREGA OS CHEQUES EM FORMA DE OBJETO
                    let objeto = { listaCheques, listaAntecipacoes: listaAntecipacao }

                    let response = await requisicao(
                        (receber = "POST"),
                        "/sisplan/receber/v1/recebervarios?",
                        "",
                        `JSON=${JSON.stringify(objeto)}`
                    );

                    let jsonStr = await response.json();

                    if (response.status != 200) {
                        msgAlerta(jsonStr.mensagem);
                        return;
                    }

                    toastr.success(
                        `Cadastro efetuado com sucesso!`,
                        "Confirmação",
                        {
                            toastClass: "alert",
                            iconClasses: {
                                error: "alert-error",
                                info: "alert-info",
                                success: "alert-success",
                                warning: "alert-warning",
                            },
                            positionClass: "toast-top-center",
                            progressBar: true,
                            timeOut: 3000,
                            fadeOut: 1000,
                            onHidden() {
                                window.location.href = `${BASE_URI}/cheque`;
                            },
                        }
                    )
                        .css({
                            "margin-top": "20%",
                            width: "500px",
                            "max-width": "500px",
                        });
                }

                catch (error) {
                    console.error(error);
                    msgAlerta(`Não foi possível gravar os dados:`);
                }

                finally {
                    $.LoadingOverlay("hide");
                }
            } finally {
                $.LoadingOverlay("hide");
            }
        }
    }
    // VERIFICA LIMITE CREDITO CLIENTE
    async function verificaLimiteCreditoCliente() {
        try {
            try {
                $.LoadingOverlay('show');

                const url = `/sisplan/funcoes/v1/pesquisa?`;
                var response = await requisicao('GET', url, encodeURIComponent(
                    `JSON={ "tabela":"entidade", 
                "camposSelect":["ENTIDADE.CREDITO, HISTCP.CREDITO_GRUPO, (SUM(RECEBER.VALOR2+RECEBER.JUROS-RECEBER.VALOR_PAGO-RECEBER.VAL_DEV-RECEBER.DESCONTO)) AS ABERTO"], 
                "leftJoin": [
                  {"tabela" : "receber", "condicao" : "entidade.codcli = receber.codcli AND RECEBER.STATUS = 'DUPL'"},
                  {"tabela" : "histcp", "condicao" : "entidade.historico = histcp.historico"}
                ], 
                "where": ["ENTIDADE.CODCLI = '${pegaChave('#txtCliente')}'"], 
                "groupBy": ["entidade.credito, histcp.credito_grupo"]}`
                ), null, 20000);

                if (!response) {
                    return false;
                }

                const jsonStr = await response.json();
                if (response.status != 200) {
                    msgErro(jsonStr['RESULT'][0].mensagem)
                    return false;
                }

                if (jsonStr['RESULT'][0].length == 0) {
                    return false;
                }

                const dados = jsonStr['RESULT'][0][0];
                let creditoCliente = Number(dados.CREDITO);
                let valorEmAberto = Number(dados.ABERTO);
                if (dados.CREDITO_GRUPO == 'S') {
                    await carregaLimiteCredito(clienteAtual);
                    creditoCliente = Number($('#txtLimiteCreditoCli').val());
                    valorEmAberto = 0;
                }

                const $valores = $('.campoValor');
                let totalCheques = 0;

                if ($valores.length > 1) {
                    for (let i = 0; i < $valores.length; i++) {
                        const valor = parseFloat($($valores[i]).val().replace('.', '').replace(',', '.'));
                        if (!isNaN(valor)) {
                            totalCheques += valor;
                        }
                    }
                } else {
                    totalCheques = parseFloat($valores.val().replace('.', '').replace(',', '.'));
                }
                const valorMoeda = totalCheques;
                async function rotinaGravaCheque() {
                    await gravaReceber(false, false)
                    bSleep = false;
                }
                if ((valorMoeda + valorEmAberto) > creditoCliente) {
                    bSleep = true;
                    await senhaSupervisor(
                        `Crédito do cliente excedido, crédito: ${creditoCliente}, valor disponível: ${(creditoCliente - valorEmAberto).toFixed(2).replace('.', ',')}, valor utilizado: ${(valorMoeda + valorEmAberto).toFixed(2).replace('.', ',')}`,
                        rotinaGravaCheque, '', false, () => {
                            $.LoadingOverlay('hide');
                            bSleep = false;
                        }, undefined, undefined, false, 'CHEQUE'
                    );
                    while (bSleep) {
                        await sleep(500);
                    }
                    return true;
                }
                rotinaGravaCheque();
                return false;
            } catch (error) {
                msgErro('Erro ao validar limite de crédito cliente');
                console.error(error);
                return false;
            }
        } finally {
            $.LoadingOverlay('hide');
        }
    }

    let btnIncluido = false;

    $('#btnIncluirCheque').click(function () {
        btnIncluido = true;
    });

    $("#gravar").click(async function () {
        $("#gravar").prop('disabled', true);
        try {
            if (!btnIncluido) {
                msgAlerta('Necessário adicionar um cheque!');
                return;
            }
    
            // Seleciona todas as linhas da tabela
            let linhas = $('#tabelaCheques tbody tr');
            for (var i = 0; i < linhas.length; i++) {
                var linha = $(linhas[i]);
    
                if (linha.find('.campoBanco').val() == '' ||
                    linha.find('.campoAgencia').val() == '' ||
                    linha.find('.campoConta').val() == '' ||
                    linha.find('.campoNumero').val() == '' ||
                    linha.find('.campoVencimento').val() == '' ||
                    linha.find('.campoValor').val() == '' ||
                    (validarCampoPedido && linha.find('.campoPedido').val() == '')) {
                    msgAlerta('Necessário preencher todos os campos do cheque!');
                    return;
                }
            }
    
            let validator = $("#msform").validate();
            validator.form();
            let erros = 0;
            erros = validator.numberOfInvalids();
    
            if (gravaChequeCaixa == '1') {
                $('#caixa, #moeda').removeClass('d-none');
                await msgAlerta(
                    'Deseja lançar o valor do cheque no caixa?',
                    async function () {
                        if (pegaChave('#txtCaixa') == '') {
                            msgAlerta('Necessário informar o campo caixa!');
                            return;
                        }
                        if (pegaChave('#txtMoeda') == '') {
                            msgAlerta('Necessário informar o campo moeda!');
                            return;
                        }
    
                        geraCaixaLoja = true;
                        if (await validaCaixa(true)) {
                            if (validarCreditoCliente == '1') {
                                await verificaLimiteCreditoCliente();
                            } else if (validarCreditoGrupo == '1') {
                                await verificaLimiteCreditoGrupo();
                            } else {
                                gravaReceber(false, false);
                            }
                            // if (validarCreditoGrupo == '1') {
                            //     await verificaLimiteCreditoGrupo();
                            // }
                        }
                    },
                    async function () {
                        geraCaixaLoja = false;
                        if (await validaCaixa(false)) {
                            if (validarCreditoCliente == '1') {
                                await verificaLimiteCreditoCliente();
                            } else if (validarCreditoGrupo == '1') {
                                await verificaLimiteCreditoGrupo();
                            } else {
                                gravaReceber(false, false);
                            }
                            // if (validarCreditoGrupo == '1') {
                            // }
                        }
                    }
                );
            } else {
                geraCaixaLoja = false;
                if (await validaCaixa(false)) {
                    if (validarCreditoCliente == '1') {
                        await verificaLimiteCreditoCliente();
                    } else if (validarCreditoGrupo == '1') {
                        await verificaLimiteCreditoGrupo();
                    } else {
                        gravaReceber(false, false);
                    }
                    // if (validarCreditoGrupo == '1') {
                    // }
                }
            }
        } catch (error) {
            console.log(error);
        } finally {
            $("#gravar").prop('disabled', false);
        }
    });

    async function verificaLimiteCreditoGrupo() {
        if ($('#txtMoeda').val() == '') {
            throw msgAlerta('Campo moeda não pode ser vazio, verifique!');
        }
        try {
            $.LoadingOverlay('show');
            let = valorMoeda = 0;
            let limiteDisponivel = '';

            if (await verificaCreditoGrupoHistoricoMoeda()) {
                await carregaLimiteCredito(pegaChave('#txtCliente'));
                const creditoGrupo = Number($('#txtLimiteCreditoConsignado').val());
                const creditoCliente = Number($('#txtLimiteCreditoCli').val());
                let valoresCampo = document.querySelectorAll('.campoValor');
                valoresCampo.forEach(function (valor) {
                    valorMoeda += TruncaDecimaisNova(2, valor.value.replace(".", "").replace(',', '.'));
                });

                async function rotinaGravaCheque() {
                    await gravaReceber(false, false)
                }

                if ((valorMoeda) > creditoGrupo) {
                    limiteDisponivel = creditoGrupo < (creditoCliente) ? creditoGrupo : (creditoCliente);
                    bSleep = true;
                    await senhaSupervisor(
                        `Crédito do grupo excedido, crédito: ${creditoGrupo}, valor disponível: ${limiteDisponivel.toFixed(2).replace('.', ',')}, valor utilizado: ${(valorMoeda).toFixed(2).replace('.', ',')}`,
                        rotinaGravaCheque, '', false, () => {
                            $.LoadingOverlay('hide');
                            bSleep = false;
                        }, undefined, undefined, false, 'CHEQUE'
                    );
                    while (bSleep) {
                        await sleep(500);
                    }
                    return true;
                }
                rotinaGravaCheque();
            }

        } catch (error) {
            console.error(error);
            msgErro('Não foi possível validar limite de crédito grupo');
        } finally {
            $.LoadingOverlay('hide');
        }
    }

    async function verificaCreditoGrupoHistoricoMoeda() {
        try {
            const moeda = pegaChave('#txtMoeda');
            const url = `/sisplan/funcoes/v1/pesquisa?`;

            const response = await requisicao('GET', url, encodeURIComponent(
                `JSON={ "tabela":"MOEDA", 
                    "camposSelect":["HISTCP.CREDITO_GRUPO"], 
                    "leftJoin": [{"tabela" : "HISTCP", "condicao" : "MOEDA.HISTORICO = HISTCP.HISTORICO"}], 
                    "where": ["MOEDA.CODMOE = ${moeda}"]}`
            ), null, 20000);

            if (!response) {
                return false;
            }

            const jsonStr = await response.json();
            if (response.status != 200) {
                msgErro(jsonStr['RESULT'][0].mensagem)
                return false;
            }

            if (jsonStr['RESULT'][0].length == 0) {
                throw false;
            }

            if (jsonStr['RESULT'][0][0].CREDITO_GRUPO == 'S') {
                return true;
            } else {
                throw false;
            }

        } catch (error) {
            console.log(error);
            msgAlerta('Não foi possível verificar crédito grupo no histórico da moeda!');
            return false;
        }
    }

    async function carregaLimiteCredito(sCodCli) {
        try {
            var response = await requisicao('GET', `/sisplan/funcoes/v1/pesquisa?`, encodeURIComponent(
                `JSON={ 
              "tabela":"entidade", 
              "camposSelect":["ENTIDADE.CREDITO, ENTIDADE.CRED_CONSIGNADO, HISTCP.CREDITO_GRUPO, (SUM(RECEBER.VALOR2+RECEBER.JUROS-RECEBER.VALOR_PAGO-RECEBER.VAL_DEV-RECEBER.DESCONTO)) AS ABERTO"], 
              "leftJoin": [
                {"tabela" : "receber", "condicao" : "entidade.codcli = receber.codcli AND RECEBER.STATUS = 'DUPL' AND receber.HISTORICO IN (SELECT HISTCP1.HISTORICO FROM HISTCP_001 HISTCP1 WHERE HISTCP1.LIMITE_CREDITO = 'S')"},
                {"tabela" : "histcp", "condicao" : "entidade.historico = histcp.historico"}
              ],  
              "where": ["ENTIDADE.CODCLI = '${sCodCli}'"], 
              "groupBy": ["ENTIDADE.CREDITO, ENTIDADE.CRED_CONSIGNADO, HISTCP.CREDITO_GRUPO"]
          }`), null);

            if (!response) {
                return;
            }

            const jsonStr = await response.json();
            if (response.status != 200) {
                msgErro(jsonStr['RESULT'][0].mensagem);
                return;
            }

            const dados = jsonStr['RESULT'][0][0];
            if (!dados) {
                $('#txtLimiteCreditoCli').val(0);
                $('#txtLimiteCreditoConsignado').val(0);
                return;
            }

            let credConsig = dados.CREDITO_GRUPO == 'S' ? dados.CRED_CONSIGNADO - dados.ABERTO : dados.CRED_CONSIGNADO;
            credConsig = ((dados.CREDITO != 0) && ((dados.CREDITO - dados.ABERTO) < credConsig)) ? dados.CREDITO - dados.ABERTO : credConsig;
            credConsig = (dados.CREDITO == 0) ? dados.CREDITO : credConsig;

            if (dados.CREDITO == 0) {
                $('#txtLimiteCreditoCli').val(0);
                if (dados.CRED_CONSIGNADO == 0) {
                    $('#txtLimiteCreditoConsignado').val(parseFloat(credConsig).toFixed(2));
                    return;
                } else {
                    $('#txtLimiteCreditoConsignado').val(parseFloat(dados.CRED_CONSIGNADO).toFixed(2));
                }
                return;
            } else {
                $('#txtLimiteCreditoCli').val(parseFloat(dados.CREDITO - dados.ABERTO).toFixed(2));
            }

            if (dados.CRED_CONSIGNADO == 0) {
                $('#txtLimiteCreditoConsignado').val(parseFloat(credConsig).toFixed(2));
                return;
            } else {
                $('#txtLimiteCreditoConsignado').val(parseFloat(dados.CRED_CONSIGNADO).toFixed(2));
            }
        } catch (error) {
            console.error(error);
            $('#txtLimiteCreditoCli').val(0);
            $('#txtLimiteCreditoConsignado').val(0);
        }
    }

    // BOTÃO VOLTAR
    $("#btnVoltar").on("click", async function () {
        await deletaRegistro("CHEQUE", getCookie("usuario"), numero);
        window.location.href = `${BASE_URI}/cheque`;
    });

    async function validaData() {
        dtEmissao = new Date().toISOString().slice(0, 10);
        dtVencimento = $('#dtVencimento').val();

        if (dtEmissao > dtVencimento) {
            msgAlerta('Data de emissão maior que a data de vencimento!')
            return;
        }
    }

    // VALIDA CAIXA ABERTO
    async function validaCaixa(bGeraCaixa) {
        dtEmissao = new Date();
        if (bGeraCaixa) {
            const bCaixaFechado = await CaixaFechado(pegaChave('#txtCaixa'), dtEmissao.toISOString().slice(0, 10));
            return !bCaixaFechado;
        } else {
            return true;
        }
    };

    // CASO CAIXA ESTEJA FECHADO
    async function CaixaFechado(caixa, data) {
        try {
            $.LoadingOverlay('show');
            try {
                let response = await requisicao('GET', '/Sisplan/vendas/V1/VerificaStatusCaixa?',
                    `CAIXA=${caixa}&DATA=${data}`, null);

                if (!response) {
                    return false;
                }

                var jsonStr = await response.json();
                if (response.status != 200) {
                    msgErro(jsonStr.mensagem);
                    return false;
                }

                if (jsonStr == "true") {
                    dtEmissao = new Date();
                    const dataFormatada = new Intl.DateTimeFormat("pt-BR").format(new Date(`${dtEmissao.getFullYear()}-${dtEmissao.getMonth() + 1}-${dtEmissao.getDate()} 23:59:59`));
                    msgAlerta(`Caixa já fechado para a data ${dataFormatada}. Para lançar o valor no caixa será necessário reabrir o mesmo.`);
                    return true;
                }

            } catch (error) {
                console.error(error);
                $.LoadingOverlay("hide");
                msgErro('Erro ao verificar se o caixa está fechado ou aberto!');
            }
        } finally {
            $.LoadingOverlay('hide');
        }
    }
    adicionaEventosCamposTabela();
})
