$(document).ready(async function () {
  $("#txtCep").mask("00000-000");
  $("#txtCidade").prop("disabled", true);

  $("#msform").validate({
    debug: false,
    ignore: "",
    rules: {
      txtCep: {
        required: true,
      },
      txtCidade: {
        required: true,
      },
      txtUf: {
        required: true,
      },
      txtPais: {
        required: true,
      },
    },
    messages: {
      txtCep: {
        required: "Informe um cep válido.",
      },
      txtCidade: {
        required: "Informe uma cidade válida.",
      },
      txtUf: {
        required: "Informe um estado válido.",
      },
      txtPais: {
        required: "Informe um país válido.",
      },
    },
    errorElement: "span",
    errorPlacement(error, element) {
      error.addClass("invalid-feedback");
      element.closest(".form-group").append(error);
    },
    highlight(element) {
      $(element).addClass("is-invalid");
    },
    unhighlight(element) {
      $(element).removeClass("is-invalid");
    },
  });

  $("#btnGravar").click(function () {
    let validator = $("#msform").validate();
    validator.form();
    let erros = 0;
    erros = validator.numberOfInvalids();

    if (erros == 0) {
      gravarCep();
    }
  });

  $("#txtPais").autocompleta(
    1,
    `JSON={ "tabela":"cadpais", "camposSelect":[ "codigo chave", "NOME descricao"], "where": null}`
  );
  $("#txtUf").autocompleta(
    1,
    `JSON={ "tabela":"tabuf", "camposSelect":[ "codigo chave", "descricao descricao"], "where": null}`
  );

  $("#btnPais").pesquisa(
    "#txtPais",
    "CODIGO",
    "NOME",
    `/sisplan/funcoes/v1/pesquisa?JSON={"tabela":"cadpais", "camposSelect":[ "CODIGO", "NOME"]}`,
    "Pesquisa País",
    "cadpais"
  );
  $("#btnUf").pesquisa(
    "#txtUf",
    "CODIGO",
    "DESCRICAO",
    `/sisplan/funcoes/v1/pesquisa?JSON={"tabela":"tabuf", "camposSelect":[ "CODIGO", "DESCRICAO"]}`,
    "Pesquisa UF",
    "tabuf"
  );

  $("#btnACidade").on("click", function () {
    $("#txtCidade").val("");
  });
  $("#btnAPais").on("click", function () {
    $("#txtPais").val("");
  });
  $("#btnAUf").on("click", function () {
    $("#txtUf").val("");
    $("#txtCidade").val("");
    $("#txtUf").trigger("blur");
  });

  $("#txtUf").on("blur", async function () {
    let uf;
    if ($("#txtUf").val() != "") {
      uf = pegaChave("#txtUf", uf);

      $("#txtCidade").prop("readonly", false);
      $("#btnCidade").removeClass("d-none");
      $("#btnACidade").removeClass("d-none");
      $("#txtCidade").prop("disabled", false);

      $("#txtCidade").off();
      $("#txtCidade").autocompleta(
        1,
        `JSON={ "tabela":"cidade", "camposSelect":[ "codigo chave", "NOME descricao"], "where": ["cod_uf = '${uf}'"]}`
      );
      $("#btnCidade").pesquisa(
        "#txtCidade",
        "CODIGO",
        "NOME",
        `/sisplan/funcoes/v1/pesquisa?JSON={"tabela":"cidade", "camposSelect":[ "CODIGO", "NOME"], "where": ["cod_uf = '${uf}'"]}`,
        "Pesquisa Cidade",
        "cidade"
      );
    } else {
      $("#txtCidade").prop("readonly", true);
      $("#btnCidade").addClass("d-none");
      $("#btnACidade").addClass("d-none");
      $("#txtCidade").prop("disabled", true);
      $("#txtCidade").off();
    }
  });

  let queryString = window.location.href;
  let parametros = queryString.split("/");
  let cepurl = parametros[parametros.length - 1];

  $("#txtCep").change(async function () {
    if ($("#txtCep").val() != "" && $("#txtCep").val().length == 9) {
      await buscaCep();
    } else {
      msgAlerta("Preencha um cep válido antes de continuar!");
    }
  });
  $("#btnVoltar").on("click", async function () {
    await deletaRegistro("CEP", getCookie("usuario"), cepurl);
    window.location.href = `${BASE_URI}/cep`;
  });

  async function buscaCep() {
    if (cepurl == "create") {
      try {
        cep = $("#txtCep").val().replace("-", "");

        $.LoadingOverlay("show");

        let response = await requisicao(
          "GET",
          "/Sisplan/Funcoes/v1/pesquisa?",
          `JSON={ "tabela":"cadcep", 
                        "camposSelect":["cep"], 
                        "where": ["cep = '${cep}'"]}`,
          null
        );

        if (!response) {
          return;
        }
        let jsonStr = await response.json();
        if (jsonStr.RESULT[0].length > 0) {
          msgAlerta("Cep já cadastrado, redirecionando à edição do mesmo.");
          setTimeout(function () {
            window.location.href = `${BASE_URI}/cep/${cep}`;
          }, 3000);
        } else {
          try {
            let responseStr = await requisicao(
              "GET",
              "/sisplan/cep/v1/CEP?",
              `CEP=${cep}`,
              null
            );
            if (!responseStr) {
              return;
            }

            carregaDados(cep);
          } finally {
            $.LoadingOverlay("hide");
          }
        }
      } catch (error) {
        console.error(error);
      }
    }
  }

  if (cepurl != "" && cepurl != "create") {
    carregaDados(cepurl);
  }

  async function carregaDados(ceppesquisa) {
    try {
      $.LoadingOverlay("show");
      try {
        let response = await requisicao(
          "GET",
          "/sisplan/funcoes/v1/pesquisa?",
          `JSON={ 
                        "tabela":"cadcep", 
                        "camposSelect":["cadcep.cep", "CIDADE.codigo", "tabuf.coduf", "tabuf.codigo", "CIDADE.cod_uf", "CIDADE.nome", "cadcep.nomcep", "cadcep.bairro", "cadcep.cod_pais", "tabuf.descricao"], 
                        "innerJoin": [{"tabela": "cidade", 
                        "condicao": "cidade.codigo = cadcep.codmun"}], 
                        "leftJoin": [{"tabela": "tabuf", 
                        "condicao": "tabuf.codigo = cidade.cod_uf"}],
                        "where": ["cadcep.cep = '${ceppesquisa}'"]}`,
          null
        );

        if (!response) {
          return;
        }
        let jsonStr = await response.json();
        if (response.status != 200) {
          msgErro(jsonStr.RESULT[0].mensagem);
          return;
        }

        $("#txtCep").val(jsonStr.RESULT[0][0].CEP);
        $("#txtEndereco").val(jsonStr.RESULT[0][0].NOMCEP);
        $("#txtBairro").val(jsonStr.RESULT[0][0].BAIRRO);

        insereValor(
          "#txtCidade",
          jsonStr.RESULT[0][0].CODIGO,
          jsonStr.RESULT[0][0].NOME
        );
        insereValor(
          "#txtUf",
          jsonStr.RESULT[0][0].COD_UF,
          jsonStr.RESULT[0][0].DESCRICAO
        );

        if (jsonStr.RESULT[0][0].COD_PAIS != "") {
          try {
            let responseOperadora = await requisicao(
              "GET",
              "/Sisplan/Funcoes/v1/pesquisa?",
              `JSON={ "tabela":"cadpais", 
                                "camposSelect":["nome"], 
                                "where": ["codigo = '${jsonStr.RESULT[0][0].COD_PAIS}'"]}`,
              null
            );

            if (!responseOperadora) {
              return;
            }
            let jsonStrOperadora = await responseOperadora.json();
            if (responseOperadora.status != 200) {
              msgErro(jsonStrClasse.RESULT[0].mensagem);
              return;
            }

            insereValor(
              "#txtPais",
              jsonStr.RESULT[0][0].COD_PAIS,
              jsonStrOperadora.RESULT[0][0].NOME
            );
          } catch (error) {
            console.error(error);
          }
        }
      } catch (error) {
        console.error(error);
      }
    } finally {
      $.LoadingOverlay("hide");
    }
  }

  $('#www').on('click', async function () {
    $.LoadingOverlay('show')
    try {
      const cep = $("#txtCep").val().replace("-", "");

      let responseStr = await requisicao(
        "GET",
        "/sisplan/cep/v1/CEP?",
        `CEP=${cep}&CONSULTAWWW=S`,
        null
      );
      if (!responseStr) {
        return;
      }

      const jsonStr = await responseStr.json()

      if (responseStr.status != 200) {
        msgErro(jsonStr.mensagem);
        return;
      }

      carregaDadosWebService(jsonStr);
    } catch (error) {
      console.error(error)
      msgAlerta(error.message)
    } finally {
      $.LoadingOverlay('hide')
    }
  })

  function carregaDadosWebService(dados) {
    $("#txtEndereco").val(dados.nOMCEP);
    $("#txtBairro").val(dados.bAIRRO);

    insereValor("#txtCidade", dados.cODMUN, dados.nOMCIDADE);
    insereValor("#txtUf", dados.eSTCEP, { tabela: 'TABUF', campoBusca: 'DESCRICAO', campoWhere: 'CODIGO', valorWhere: dados.eSTCEP });
    insereValor("#txtPais", dados.cOD_PAIS,  { tabela: 'CADPAIS', campoBusca: 'NOME', campoWhere: 'CODIGO', valorWhere: dados.cOD_PAIS });
  }

  async function gravarCep() {
    try {
      $.LoadingOverlay("show");
      let cep = {};

      cep.CEP = $("#txtCep").val().replace("-", "");
      cep.NOMCEP = $("#txtEndereco").val().toUpperCase();
      cep.BAIRRO = $("#txtBairro").val().toUpperCase();
      cep.CODMUN = pegaChave($("#txtCidade").val(), cep.CODMUN);
      cep.ESTCEP = pegaChave($("#txtUf").val(), cep.ESTCEP);
      cep.COD_PAIS = pegaChave($("#txtPais").val(), cep.COD_PAIS);

      let response = await requisicao(
        "POST",
        "/sisplan/cep/v1/CEP?",
        `JSON=${JSON.stringify(cep)}`,
        null
      );

      if (!response) {
        $.LoadingOverlay("hide");
        return;
      }

      let jsonStr = await response.json();
      if (response.status != 200) {
        $.LoadingOverlay("hide");
        msgErro(jsonStr.RESULT[0].mensagem);
        return;
      }
      $.LoadingOverlay("hide");
      toastr
        .success("Cadastro efetuado com sucesso!", "Confirmação", {
          toastClass: "alert",
          iconClasses: {
            error: "alert-error",
            info: "alert-info",
            success: "alert-success",
            warning: "alert-warning",
          },
          positionClass: "toast-top-center",
          progressBar: true,
          timeOut: 3000,
          fadeOut: 1000,
          onHidden() {
            window.location.href = `${BASE_URI}/cep`;
          },
        })
        .css({
          "margin-top": "20%",
          width: "500px",
          "max-width": "500px",
        });
    } catch (error) {
      console.error(error);
      $.LoadingOverlay("hide");
      msgErro(`Não foi possível gravar os dados do CEP: ${error}`);
    }
  }
});

$("#tutorial").on("click", function () {
  $(document).ready(async function () {
    const driver = new Driver({
      doneBtnText: "Sair",
      closeBtnText: "Fechar",
      nextBtnText: "Próximo",
      prevBtnText: "Anterior",
      allowClose: false,
    });
    driver.defineSteps([
      {
        element: "#telatour",
        popover: {
          title: "Dados Gerais",
          description: "Aqui estão os campos disponíveis para o cadastro, os campos obrigatórios terão o * ao lado do nome.",
          position: "top",
        },
      },
      {
        element: "#txtCep",
        popover: {
          title: "Campo CEP",
          description:
            "Ao alterar esse campo, será feita uma pesquisa aos WebServices https://apps.correios.com.br/ e http://viacep.com.br/ws/, se houver retorno preencherá os campos de endereço.",
          position: "top",
        },
      },
      {
        element: "#txtUf",
        popover: {
          title: "UF",
          description:
            "Adicionamos aqui o estado do cep que estamos cadastrando ou alterando.",
          position: "top",
        },
      },
      {
        element: "#txtCidade",
        popover: {
          title: "Cidade",
          description:
            "Adicionamos aqui a cidade do cep que estamos cadastrando ou alterando.",
          position: "top",
        },
      },
      {
        element: "#txtPais",
        popover: {
          title: "País",
          description:
            "E aqui adicionamos o país do cep que estamos cadastrando ou alterando.",
          position: "top",
        },
      },
      {
        element: "#btnVoltar",
        popover: {
          title: "Botão Voltar",
          description:
            "Ao clicar nesse botão você retorna para a tela de consulta.",
          position: "left",
        },
      },
      {
        element: "#btnGravar",
        popover: {
          title: "Botão Gravar",
          description: "Clique aqui para gravar o CEP.",
          position: "left",
        },
      },
    ]);
    driver.start();
  });
});
