$('#tutorial').on('click', function () {
  $('#geral-tab').trigger('click');
  $(document).ready(async function () {
    const driver = new Driver({
      doneBtnText: 'Sair',
      closeBtnText: 'Fechar',
      nextBtnText: 'Próximo',
      prevBtnText: 'Anterior',
      allowClose: false,
      onHighlightStarted: (Element) => {
        if (Element.node.id == 'geral') {
          if (!$('#DadosGerais').hasClass('show'));
          $('#DadosGerais').collapse('show');
        }
      },
    });

    driver.defineSteps([{
      element: '#btnFiltros',
      popover: {
        title: 'Filtros',
        description: 'Aqui você pode inserir filtros para fazer a consulta do cancelamento.',
        position: 'bottom'
      }
    },
    {
      element: '#btnNovoCancelamento',
      popover: {
        title: 'Incluir Cancelamento',
        description: 'Ao selecionar esse botão, você será direcionado para a tela de cancelamento de pedido.',
        position: 'bottom'
      }
    },
    {
      element: '#btnImprimir',
      popover: {
        title: 'Botão Imprimir',
        description: 'Clique aqui para imprimir os pedidos filtrados.',
        position: 'right'
      }
    },
    {
      element: '#tutTabelaPedido',
      popover: {
        title: 'Tabela de Pedidos',
        description: 'Aqui estão pedidos, é possivel identificar as quantidades canceladas e/ou faturadas.',
        position: 'bottom'
      }
    }
    ]);

    driver.start();
  });
});

$(document).ready(async function () {
  const permissaoUsuarioLogado = await permissaoAcessos("CANCELAMENTO_PEDIDO");
  let consultando = true

  let colunas = JSON.parse(localStorage.getItem('colunasInvisiveisRelatorios'));

  // aqui so valida se nao existe tem que criar para nao dar erro
  if (colunas == null || colunas.acessoCancelamento == undefined) {
    localStorage.setItem('colunasInvisiveisRelatorios', JSON.stringify({ ...colunas, acessoCancelamento: [] }));
    colunas = JSON.parse(localStorage.getItem('colunasInvisiveisRelatorios'));
  }

  $('#btnConfirmarColunas').on('click', async function () {
    $.LoadingOverlay('show');
    try {
      const novasColunas = retornaNovasColunasInvisiveis();
      localStorage.setItem('colunasInvisiveisRelatorios', JSON.stringify({ ...colunas, acessoCancelamento: novasColunas }))

      $('#tabelaPedido').DataTable().columns().visible(true);

      $('#tabelaPedido').DataTable().columns().every(
        function () {
          if ((novasColunas).indexOf(this.dataSrc()) != -1) {
            this.visible(false);
          }
        })

    } finally {
      $.LoadingOverlay('hide');
      $('#modal-ColunasVisiveis').modal('hide');
    }
  })

  $('#modal-ColunasVisiveis').on('show.bs.modal', function () {
    const cols = [];

    let colunasInvisiveis = JSON.parse(localStorage.getItem('colunasInvisiveisRelatorios'))

    $('#tabelaPedido').DataTable().columns().every(function () {
        cols.push({
            'title': $(this.header()).text(),
            'data': this.dataSrc()
        })
    });

    adicionaColunas(cols, colunasInvisiveis.acessoCancelamento ?? [], ['NUMERO'])
})

  buscaDataAtual();

  async function buscaDataAtual() {
    const date = new Date();
    const firstDay = new Date(date.getFullYear(), date.getMonth(), 1);
    $('#dtCancalamentoDe').val(formataData(firstDay));
  }

  $('#txtCliente').autocompleta(1, `JSON={ "tabela":"ENTIDADE", "camposSelect":["CODCLI CHAVE", "NOME DESCRICAO"], "where": null}`);
  $('#txtRepresentante').autocompleta(1, `JSON={ "tabela":"REPRESEN", "camposSelect":["CODREP CHAVE", "NOME DESCRICAO"], "where": null}`);
  $('#txtMotivo').autocompleta(1, `JSON={ "tabela":"MENSAGEM", "camposSelect":["CODMEN CHAVE", "DESCRICAO DESCRICAO"], "where": null}`);
  $('#txtReserva').autocompleta(1, `JSON={ "tabela":"PED_RESERVA", "camposSelect":["NUMERO CHAVE", "CODIGO DESCRICAO"], "where": null}`);
  $('#txtColecao').autocompleta(1, `JSON={ "tabela":"COLECAO", "camposSelect":["CODIGO CHAVE", "DESCRICAO DESCRICAO"], "where": null}`);
  $('#txtEtiqueta').autocompleta(1, `JSON={ "tabela":"ETQ_PROD", "camposSelect":["CODIGO CHAVE", "DESCRICAO DESCRICAO"], "where": null}`);
  $('#txtCor').autocompleta(1, `JSON={ "tabela":"CADCOR", "camposSelect":["COR CHAVE", "DESCRICAO DESCRICAO"], "where": null}`);
  $('#txtTamanho').autocompleta(1, `JSON={ "tabela":"TABTAM", "camposSelect":["TAM CODIGO", "FAIXA DESCRICAO"], "where": null}`);
  $('#txtMotivoGrava').autocompleta(1, `JSON={ "tabela":"CODMEN", "camposSelect":["CODMEN CHAVE", "DESCRICAO DESCRICAO"], "where": null}`);
  $('#txtProduto').autocompleta(1, `JSON={ "tabela":"PRODUTO", "camposSelect":["CODIGO CHAVE", "DESCRICAO DESCRICAO"], "where": null}`);
  $('#txtGrupoProduto').autocompleta(1, `JSON={ "tabela":"GRUPO_PA", "camposSelect":["CODIGO CHAVE", "DESCRICAO DESCRICAO"], "where": null}`);
  $('#txtProgramacao').autocompleta(1, `JSON={ "tabela":"OF1", "camposSelect":["NUMERO CHAVE", "PROGRAMACAO DESCRICAO"], "where": null}`);
  $('#txtPedido').autocompleta(1, `JSON={ "tabela":"PEDIDO", "camposSelect":[ "PEDIDO.NUMERO CHAVE", "ENTIDADE.NOME DESCRICAO" ], "leftjoin":[{"tabela" : "ENTIDADE", "condicao" : "ENTIDADE.CODCLI = PEDIDO.CODCLI"}], "where": null}`);

  $('#btnPedido').pesquisa('#txtPedido', 'NUMERO', 'NOME', `/sisplan/funcoes/v1/pesquisa?JSON={"tabela":"PEDIDO", "camposSelect":[ "PEDIDO.NUMERO", "ENTIDADE.NOME" ], "leftjoin":[{"tabela" : "ENTIDADE", "condicao" : "ENTIDADE.CODCLI = PEDIDO.CODCLI"}]}`, 'Pesquisa Pedido', 'PEDIDO');
  $('#btnCliente').pesquisa('#txtCliente', 'CODCLI', 'NOME', `/sisplan/funcoes/v1/pesquisa?JSON={"tabela":"ENTIDADE", "camposSelect":[ "CODCLI", "NOME"]}`, 'Pesquisa Cliente', 'ENTIDADE');
  $('#btnRepresentante').pesquisa('#txtRepresentante', 'CODREP', 'NOME', `/sisplan/funcoes/v1/pesquisa?JSON={"tabela":"REPRESEN", "camposSelect":[ "CODREP", "NOME"]}`, 'Pesquisa Representante', 'REPRESEN');
  $('#btnMotivo').pesquisa('#txtMotivo', 'CODMEN', 'DESCRICAO', `/sisplan/funcoes/v1/pesquisa?JSON={"tabela":"MENSAGEM", "camposSelect":[ "CODMEN", "DESCRICAO"]}`, 'Pesquisa Motivo', 'MENSAGEM');
  $('#btnReserva').pesquisa('#txtReserva', 'NUMERO', 'CODIGO', `/sisplan/funcoes/v1/pesquisa?JSON={"tabela":"PED_RESERVA", "camposSelect":[ "NUMERO", "CODIGO"]}`, 'Pesquisa Reserva', 'PED_RESERVA');
  $('#btnColecao').pesquisa('#txtColecao', 'CODIGO', 'DESCRICAO', `/sisplan/funcoes/v1/pesquisa?JSON={"tabela":"COLECAO", "camposSelect":[ "CODIGO", "DESCRICAO"]}`, 'Pesquisa Colecao', 'COLECAO');
  $('#btnEtiqueta').pesquisa('#txtEtiqueta', 'CODIGO', 'DESCRICAO', `/sisplan/funcoes/v1/pesquisa?JSON={"tabela":"ETQ_PROD", "camposSelect":[ "CODIGO", "DESCRICAO"]}`, 'Pesquisa Etiqueta', 'ETQ_PROD');
  $('#btnCor').pesquisa('#txtCor', 'COR', 'DESCRICAO', `/sisplan/funcoes/v1/pesquisa?JSON={"tabela":"CADCOR", "camposSelect":[ "COR", "DESCRICAO"]}`, 'Pesquisa Cor', 'CADCOR');
  $('#btnTamanho').pesquisa('#txtTamanho', 'TAM', 'FAIXA', `/sisplan/funcoes/v1/pesquisa?JSON={"tabela":"TABTAM", "camposSelect":[ "TAM", "FAIXA"]}`, 'Pesquisa Tamanho', 'TABTAM');
  $('#btnMotivoGrava').pesquisa('#txtMotivoGrava', 'CODMEN', 'DESCRICAO', `/sisplan/funcoes/v1/pesquisa?JSON={"tabela":"MENSAGEM", "camposSelect":[ "CODMEN", "DESCRICAO"]}`, 'Pesquisa Motivo Grava', 'MENSAGEM');
  $('#btnProduto').pesquisa('#txtProduto', 'CODIGO', 'DESCRICAO', `/sisplan/funcoes/v1/pesquisa?JSON={"tabela":"PRODUTO", "camposSelect":[ "CODIGO", "DESCRICAO"]}`, 'Pesquisa Produto', 'PRODUTO');
  $('#btnGrupoProduto').pesquisa('#txtGrupoProduto', 'CODIGO', 'DESCRICAO', `/sisplan/funcoes/v1/pesquisa?JSON={"tabela":"GRUPO_PA", "camposSelect":[ "CODIGO", "DESCRICAO"]}`, 'Pesquisa Grupo Produto', 'GRUPO_PA');
  $('#btnProgramacao').pesquisa('#txtProgramacao', 'NUMERO', 'PROGRAMACAO', `/sisplan/funcoes/v1/pesquisa?JSON={"tabela":"OF1", "camposSelect":[ "NUMERO", "PROGRAMACAO"]}`, 'Pesquisa Programacao', 'OF1');

  $('#btnLimpaPedido').on('click', function () {
    $('#txtPedido').val('');
  });

  $('#btnLimpaCliente').on('click', function () {
    $('#txtCliente').val('');
  });

  $('#btnLimpaRepresentante').on('click', function () {
    $('#txtRepresentante').val('');
  });

  $('#btnLimpaMotivo').on('click', function () {
    $('#txtMotivo').val('');
  });

  $('#btnLimpaReserva').on('click', function () {
    $('#txtReserva').val('');
  });

  $('#btnLimpaColecao').on('click', function () {
    $('#txtColecao').val('');
  });

  $('#btnLimpaEtiqueta').on('click', function () {
    $('#xtEtiqueta').val('');
  });

  $('#btnLimpaCor').on('click', function () {
    $('#txtCor').val('');
  });

  $('#btnLimpaTamanho').on('click', function () {
    $('#txtTamanho').val('');
  });

  $('#btnMotivoGrava').on('click', function () {
    $('#txtMotivoGrava').val('');
  });

  $('#btnLimpaProgramacao').on('click', function () {
    $('#txtProgramacao').val('');
  });

  $('#btnLimpaGrupoProduto').on('click', function () {
    $('#txtGrupoProduto').val('');
  });

  $('#btnLimpaProduto').on('click', function () {
    $('#txtProduto').val('');
  });

  $('#btnLimpaFiltros').on('click', function () {
    buscaDataAtual();
    $('#cbMotivoCancelamento').prop('checked', false);
    $('#cbFaturamentoParcial').prop('checked', false);
    $('#cbSomenteQtdePendente').prop('checked', false);
    $('#dtCancelamentoAte').val('2500-12-31');
    $('#txtPedido').val('');
    $('#txtCliente').val('');
    $('#txtRepresentante').val('');
    $('#txtMotivo').val('');
    $('#txtReserva').val('');
    $('#txtColecao').val('');
    $('#xtEtiqueta').val('');
    $('#txtCor').val('');
    $('#txtTamanho').val('');
    $('#txtMotivoGrava').val('');
    $('#txtProgramacao').val('');
    $('#txtGrupoProduto').val('');
    $('#txtProduto').val('');
  })

  function retornaBotaoOpcoes(pedido) {
    var retorno = '<div style="text-align:start;"> ' +
      '   <div class="dropdown" style="position: initial"> ' +
      '    <button class="btn btn-info btn-sm dropdown-toggle" type="button" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false"> ' +
      '      ' + pedido + ' ' +
      '    </button> ' +
      '    <div class="dropdown-menu"> ' +
      '    <button id="btn-editar" type="button" class="dropdown-item">Alterar</button>' +
      `    <button id="btn-imprimirIndividual" type="button" ${getCookie('cod_usuario') == '0000' ? 'title="Este botão chama o Layout RelCancelamentoPedidoIndividual.FR3"' : ''} class="dropdown-item">Imprimir</button>`;
    retorno += '</div>' +
      '  </div>' +
      '</div>';
    return retorno;
  }

  function buscaParametros() {
    //CHECKBOX
    let sMotivoCancelamento = $('#cbMotivoCancelamento').is(':checked') ? 'S' : 'N';
    let sFaturadoParcialmente = $('#cbFaturamentoParcial').is(':checked') ? 'S' : 'N';
    let sComQtdePendente = $('#cbSomenteQtdePendente').is(':checked') ? 'S' : 'N';
    //CAMPOS    
    let sDtCancelamentoDe = formataDataBonita($('#dtCancalamentoDe').val());
    let sDtCancelamentoAte = formataDataBonita($('#dtCancelamentoAte').val());
    let sPedido = pegaChave('#txtPedido');
    let sCliente = pegaChave('#txtCliente');
    let sRepresentante = pegaChave('#txtRepresentante');
    let sReserva = pegaChave('#txtReserva');
    let sMotivo = pegaChave('#txtMotivo');
    let sColecao = pegaChave('#txtColecao');
    let sEtiqueta = pegaChave('#txtEtiqueta');
    let sCor = pegaChave('#txtCor');
    let sTamanho = pegaChave('#txtTamanho');
    let sProduto = pegaChave('#txtProduto');
    let sGrupoProduto = pegaChave('#txtGrupoProduto');
    let sProgramacao = pegaChave('#txtProgramacao');

    let retorno =
      //CHECKBOX
      `MOTIVO_CANCELAMENTO=${sMotivoCancelamento}` +
      `&FATURADO_PARCIALMENTE=${sFaturadoParcialmente}` +
      `&COM_QTDE_PENDENTE=${sComQtdePendente}` +
      //CAMPOS
      `&DT_CANCEL_INICIO=${sDtCancelamentoDe}` +
      `&DT_CANCEL_FIM=${sDtCancelamentoAte}` +
      `&NUMERO=${sPedido}` +
      `&CLIENTE=${sCliente}` +
      `&CODREP=${sRepresentante}` +
      `&RESERVA=${sReserva}` +
      `&MOTIVO=${sMotivo}` +
      `&COLECAO=${sColecao}` +
      `&ETIQUETA=${sEtiqueta}` +
      `&COR=${sCor}` +
      `&TAMANHO=${sTamanho}` +
      `&PRODUTO=${sProduto}` +
      `&GRUPO_PRODUTO=${sGrupoProduto}` +
      `&PROGRAMACAO=${sProgramacao}`;

    return retorno;
  };

  async function buscaCancelamento() {
    $.LoadingOverlay("show");
    try {
      let params = buscaParametros();
      const response = await requisicao('GET', '/sisplan/cancelamentopedido/v1/buscarcancelamento?', params, '', 15000);

      if (!response) {
        return;
      }

      let jsonStr = await response.json();

      return jsonStr;
    } catch (error) {
      console.log(error)
    } finally {
      $.LoadingOverlay("hide");
    }
  }

  $('#btnConsultar').on('click', async function () {
    consultando = true
    if ($.fn.DataTable.isDataTable('#tabelaPedido')) {
      $('#tabelaPedido').DataTable().destroy();
      $('#tabelaPedido').empty();
    }
    try {
      var dataSet = await buscaCancelamento();

      let ordemColunasRelatorio = localStorage.getItem('ordemColunasDataTable')
      ordemColunasRelatorio = JSON.parse(ordemColunasRelatorio)

      const dataSetCols = [];
      let keys
      if (ordemColunasRelatorio != null && ordemColunasRelatorio.cancelamentoAcesso != undefined) {
        const ordenacao = 'GERAL'
        const colunas = ordemColunasRelatorio.cancelamentoAcesso.filter(f => f.ordenacao == ordenacao)
        keys = colunas.length > 0 ? colunas[0].colunas : Object.keys(dataSet[0]);
      } else {
        keys = Object.keys(dataSet[0]);
      }

      const colunasOriginais = Object.keys(dataSet[0])

      for (var k in keys) {
        dataSetCols.push({
          'title': keys[k],
          'data': keys[k]
        });
      }

      $('#tabelaPedido').DataTable({
        paging: true,
        lengthChange: true,
        filter: false,
        info: true,
        order: false,
        destroy: true,
        order: [],
        colReorder: true,
        "language": {
          "sEmptyTable": "Nenhuma consulta realizada",
          "sInfo": "_TOTAL_ registros",
          "sInfoEmpty": " 0 registros",
          "sInfoFiltered": "(Filtrados de _MAX_ registros)",
          "sInfoPostFix": "",
          "sInfoThousands": ".",
          "sLengthMenu": "_MENU_ resultados",
          "sLoadingRecords": "Carregando...",
          "sProcessing": "Processando...",
          "sZeroRecords": "Nenhuma consulta realizada",
          "sSearch": "Pesquisar",
          "oPaginate": {
            "sNext": "Próximo",
            "sPrevious": "Anterior",
            "sFirst": "Primeiro",
            "sLast": "Último"
          },
          "oAria": {
            "sSortAscending": ": Ordenar colunas de forma ascendente",
            "sSortDescending": ": Ordenar colunas de forma descendente"
          }
        },
        "data": dataSet,
        "columns": dataSetCols,
        columnDefs: [
          {
            render(row) {
              return retornaBotaoOpcoes(row);
            },
            targets: [keys.indexOf(colunasOriginais[0])],
          },
          {
            targets: [keys.indexOf(colunasOriginais[7]), keys.indexOf(colunasOriginais[9])],
            render(data) {
              return 'R$ ' + parseFloat(data).toFixed(2).replace('.', ',')
            }
          }]
      });

      const colunasInvisiveis = JSON.parse(localStorage.getItem('colunasInvisiveisRelatorios'));

      $('#tabelaPedido_length').prepend('<button class="buttonColVis" id="buttonColVis"><i class="fas fa-cogs"></i></button>');
      $('#tabelaPedido_length').prepend('<button class="buttonExcel" id="buttonExcel"><i class="fas fa-file-excel"></i></button>');

      $('#buttonColVis').prop('title', 'Configurar colunas visíveis');
      $('#buttonExcel').prop('title', 'Exportar');

      $('#buttonColVis').on('click', async function () {
        $.LoadingOverlay('show');
        $('#modal-ColunasVisiveis').modal('show');
        $.LoadingOverlay('hide');
      });

      $('#buttonExcel').on('click', async function () {
        const dados = $("#tabelaPedido").DataTable().data().toArray();
        await exportaCSV("", "", undefined, null, 'Relatório de Cancelamento de Pedido', '#tabelaPedido', '', 999, false, false, dados);
      })

      $('#tabelaPedido').DataTable().columns().every(
        function () {
          if ((colunasInvisiveis.acessoCancelamento).indexOf(this.dataSrc()) != -1) {
            this.visible(false);
          }
        })

      $('#tabelaPedido').on('column-reorder.dt', function (e, settings, details) {
        if (consultando) {
          return
        }
        const newColumnOrder = []

        for (let i = 0; i < settings.aoColumns.length; i++) {
          const column = settings.aoColumns[i].mData

          newColumnOrder.push(column)
        }

        let ordemColunas = localStorage.getItem('ordemColunasDataTable')
        ordemColunas = JSON.parse(ordemColunas)
        const ordenacao = 'GERAL'

        if (ordemColunas == null || ordemColunas.cancelamentoAcesso == undefined) {
          localStorage.setItem('ordemColunasDataTable', JSON.stringify({ ...ordemColunas, cancelamentoAcesso: [{ ordenacao: ordenacao, colunas: newColumnOrder }] }));

        } else if (!ordemColunas.cancelamentoAcesso.some(s => s.ordenacao == ordenacao)) {

          const ordensSalvas = JSON.parse(localStorage.getItem('ordemColunasDataTable'));
          const newObj = { ordenacao: ordenacao, colunas: newColumnOrder }
          ordensSalvas.cancelamentoAcesso.push(newObj)
          localStorage.setItem('ordemColunasDataTable', JSON.stringify(ordensSalvas));

        } else if (ordemColunas.cancelamentoAcesso.some(s => s.ordenacao == ordenacao)) {

          const ordensSalvas = JSON.parse(localStorage.getItem('ordemColunasDataTable'));
          ordensSalvas.cancelamentoAcesso.filter(f => f.ordenacao == ordenacao)[0].colunas = newColumnOrder
          localStorage.setItem('ordemColunasDataTable', JSON.stringify(ordensSalvas));
        }
      });

      consultando = false
    } catch (err) {
      console.log(err)
    } finally {
      $('#modal-filtros').modal('hide');
    }
  });

  $('#tabelaPedido').on('click', '#btn-editar', async function () {
    try {
      if (permissaoUsuarioLogado.ALTERA == 'S') {
        let data = $('#tabelaPedido').DataTable().row($(this).parents('tr')).data();
        window.location.href = `cancelamento_pedido/${data.NUMERO}`;
      } else {
        msgAlertaSemConfirmacao("Sem permissão para alterar!");
      }
    } catch (error) {
      console.error();
    }
  })

  $('#tabelaPedido').on('dblclick', 'tr', async function () {
    try {
      if (permissaoUsuarioLogado.ALTERA == 'S') {
        let data = $('#tabelaPedido').DataTable().row($(this)).data();
        window.location.href = `cancelamento_pedido/${data.NUMERO}`;
      } else {
        msgAlertaSemConfirmacao("Sem permissão para alterar!");
      }
    } catch (error) {
      console.error();
    }
  });

  $('#tabelaPedido').on('click', '#btn-imprimirIndividual', async function () {
    $.LoadingOverlay('show');
    try {
      const data = $('#tabelaPedido').DataTable().row($(this).parents('tr')).data();
      const url = `/sisplan/cancelamentopedido/v1/imprimirindividual?`;

      const filtros = `EMPRESA=${getCookie('empresa')}&USUARIO=${getCookie('usuario')}&NUMERO=${data.NUMERO}`;
      const bImprimeAutomatico = await verificaImprimirAutomatico('RelCancelamentoPedidoIndividual');
      let arquivo = await GeraRelatorio(`${url}${filtros}`, 'GET', 150000, false, 'RelCancelamentoPedidoIndividual');
      if (arquivo != undefined) {
        if (!bImprimeAutomatico) {
          window.open(`${BASE_URI}/relatorios_api/pdf/${arquivo}`, '_blank');
        }
        await limparRelatorios();
      }

    } catch (error) {
      console.error(error);
    } finally {
      $.LoadingOverlay('hide');
    }
  })

  $('#btnNovoCancelamento').on('click', function () {
    if (permissaoUsuarioLogado.INCLUI == 'S') {
      window.location.href = "cancelamento_pedido/create";
    } else {
      msgAlertaSemConfirmacao("Sem permissão para incluir!");
    }
  });

  $('#btnFiltros').on('click', function () {
    $('#modal-filtros').modal('show');
  });

  retornaHintRelatorio('btnImprimir', 'RelCancelamentoPedido')

  $('#btnImprimir').on('click', async function () {
    try {
      $.LoadingOverlay('show');
      try {
        let url = `/sisplan/cancelamentopedido/v1/imprimir?`;

        const filtros = buscaParametros();
        const bImprimeAutomatico = await verificaImprimirAutomatico('RelCancelamentoPedido');
        let arquivo = await GeraRelatorio(`${url}&EMPRESA=${getCookie('empresa')}&USUARIO=${getCookie('usuario')}&${filtros}`, 'GET', 150000, false, 'RelCancelamentoPedido');
        if (arquivo != undefined) {
          if (!bImprimeAutomatico) {
            window.open(`${BASE_URI}/relatorios_api/pdf/${arquivo}`, '_blank');
          }
          await limparRelatorios();
        }

      } catch (error) {
        console.error(error);
      }
    } finally {
      $.LoadingOverlay('hide');
    }
  })

  $('#btnConsultar').trigger('click');
});