$("#tutorial").on("click", function () {
  $(document).ready(async function () {
    const driver = new Driver({
      doneBtnText: "Sair",
      closeBtnText: "Fechar",
      nextBtnText: "Próximo",
      prevBtnText: "Anterior",
      allowClose: false,
    });
    driver.defineSteps([
      {
        element: "#btnFiltros",
        popover: {
          title: "Botão Filtros",
          description:
            "Clique aqui para ter acesso aos filtros e iniciar uma consulta.",
          position: "right",
        },
      },
      {
        element: "#btnIncluir",
        popover: {
          title: "Botão Incluir",
          description:
            "Clique aqui para iniciar o cadastro de um ramo de atuação.",
          position: "right",
        },
      },
      {
        element: "#tabelaRamoAtuacao",
        popover: {
          title: "Tabela de Dados",
          description: "Aqui estão os dados dos ramos de atuação cadastrados.",
          position: "top",
        },
      },
    ]);
    driver.start();
  });
});

$(document).ready(async function () {
  await consultaDados();
  const permissaoUsuarioLogado = await permissaoAcessos("CADTABSERVICO");

  $('#txtCodigo').autocompleta(1, `JSON={ "tabela":"TABSERV", "camposSelect":[ "CODIGO CHAVE", "DESCRICAO DESCRICAO"], "where": null}`);
  $('#btnCodigo').pesquisa('#txtCodigo', 'CODIGO', 'DESCRICAO', `/sisplan/funcoes/v1/pesquisa?JSON={ "tabela":"TABSERV", "camposSelect":[ "CODIGO", "DESCRICAO"]}`, 'Pesquisa Tabela Servicos', '');

  $('#btnLimpaCodigo').on('click', async function () {
    $('#txtCodigo').val('');
  })

  $("#btnFiltros").on("click", function () {
    $("#modal-filtros").modal("show");
  });

  $('#btnLimparFiltros').on('click', function () {
    $('#txtCodigo').val('');
  });

  $("#btnIncluir").on("click", async function () {

    if (permissaoUsuarioLogado.INCLUI == 'S') {
      const proximo = await RetornaProximo('TABSERV', 'TABSERV', 'CODIGO', 0);

      window.location.href = `cadtabservico/${proximo}`;
    } else {
      msgAlertaSemConfirmacao("Sem permissão para incluir!");
    }
  });

  function retornaBotaoOpcoes(data) {
    var retorno = '<div style="text-align:start;"> ' +
      '    <button class="btn btn-info btn-sm dropdown-toggle btnVerificaOpcoes" type="button" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false"> ' +
      '      ' + data + ' ' +
      '    </button> ' +
      '    <div class="dropdown-menu"> ' +
      '    <button class="dropdown-item" title="Editar" id="btn-editar">Editar</button>     ' +
      '    <button class="dropdown-item" title="Excluir" id="btn-excluir">Excluir</button>     ' +
      '</div>';
    return retorno;
  };

  $("#btnConsultar").on("click", async function () {
    await consultaDados();
    $("#modal-filtros").modal("hide");
  });

  async function consultaDados() {
    try {
      $.LoadingOverlay("show");
      try {

        let params = ''

        if ($('#txtCodigo').val() != '') {
          params += ` AND CODIGO = '${pegaChave('#txtCodigo')}'`
        }

        $("#tabelaServicos").DataTable({
          destroy: true,
          lengthChange: false,
          serverSide: true,
          processing: true,
          ajax: {
            url: `${getCookie('protocolo')}://${getCookie("ip_api")}/sisplan/funcoes/v1/pesquisadatatable`,
            type: "POST",
            headers: { Authorization: BASIC_AUTH },
            data: {
              EMPRESA: getCookie("empresa"),
              JSON: `{"tabela":"TABSERV", "camposSelect":[ "CODIGO", "DESCRICAO"], "where": ["1=1 ${params}"] }`,
            },
          },
          language: {
            sEmptyTable: "Nenhum registro encontrado",
            sInfo: "_TOTAL_ registros",
            sInfoEmpty: " 0 registros",
            sInfoFiltered: "(Filtrados de _MAX_ registros)",
            sInfoPostFix: "",
            sInfoThousands: ".",
            sLengthMenu: "_MENU_ resultados",
            sLoadingRecords: "Carregando...",
            sProcessing: "Processando...",
            sZeroRecords: "Nenhum registro encontrado",
            sSearch: "Pesquisar",
            oPaginate: {
              sNext: "Próximo",
              sPrevious: "Anterior",
              sFirst: "Primeiro",
              sLast: "Último",
            },
            oAria: {
              sSortAscending: ": Ordenar colunas de forma ascendente",
              sSortDescending: ": Ordenar colunas de forma descendente",
            },
          },
          columnDefs: [
            {
              targets: [0], render: function (data) {
                return retornaBotaoOpcoes(data);
              },
            },
          ],
        });
        $("input[type='search']").focus();
      } catch (error) {
        console.error(error);
        msgErro(`Não foi possível buscar os dados: ${error}`);
      }
    } finally {
      $.LoadingOverlay("hide");
    }
  }

  async function excluiLinha(codigo) {
    if (!!await buscaValor('SERVICO', 'CODSERV', 'CODSERV', codigo)) {
      throw msgAlerta('Código esta sendo utilizado no Cadastro de Serviços. Impossível Excluir.')
    }

    let response = await requisicao("DELETE", `/Sisplan/Cadastros/V1/cadtabservico?`, `CODIGO=${codigo}`, 15000);

    if (!response) {
      return;
    }

    let jsonStr = await response.json();
    if (response.status != 200) {
      msgAlerta(jsonStr[0].mensagem);
      return;
    }

    toastr
      .success("Exclusão realizada com sucesso!", "Confirmação", {
        toastClass: "alert",
        iconClasses: {
          error: "alert-error",
          info: "alert-info",
          success: "alert-success",
          warning: "alert-warning",
        },
        positionClass: "toast-top-center",
        progressBar: true,
        timeOut: 3000,
        fadeOut: 1000,
        onHidden() {
          window.location.href = `${BASE_URI}/cadtabservico`;
        },
      })
      .css({
        "margin-top": "20%",
        width: "500px",
        "max-width": "500px",
      });
  }

  $("#tabelaServicos").on("click", "#btn-excluir", async function () {
    msgAlerta('Deseja excluir este registro?', async () => {
      if (permissaoUsuarioLogado.EXCLUI == 'S') {
        let data = $("#tabelaServicos").DataTable().row($(this).parents("tr")).data();
        await excluiLinha(data[0]);
      } else {
        msgAlertaSemConfirmacao("Sem permissão para excluir!");
      }
    })
  });

  $("#tabelaServicos").on("click", "#btn-editar", async function () {
    if (permissaoUsuarioLogado.ALTERA == 'S') {
      let data = $("#tabelaServicos").DataTable().row($(this).parents("tr")).data();
      let clienteLiberado = await liberarRegistro("CADTABSERVICO", data[0]);
      if (clienteLiberado) {
        window.location.href = `cadtabservico/${data[0]}`;
      }
    } else {
      msgAlertaSemConfirmacao("Sem permissão para alterar!");
    }
  });

  $("#tabelaServicos").on("dblclick", "tr", async function () {
    if (permissaoUsuarioLogado.ALTERA == 'S') {
      let data = $("#tabelaServicos").DataTable().row($(this)).data();
      let clienteLiberado = await liberarRegistro("CADTABSERVICO", data[0]);
      if (clienteLiberado) {
        window.location.href = `cadtabservico/${data[0]}`;
      }
    } else {
      msgAlertaSemConfirmacao("Sem permissão para alterar!");
    }
  });

  $("input[type='search']").on("keydown", function () {
    if (window.event.which === 13) {
      $("#btn-editar").trigger("click");
    }
  });
});
