<?php include_once('../../../config.php') ?>

<!DOCTYPE html>
<html>

<head>
    <meta charset="utf-8">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <title>Sisplan Web | Região de Estado</title>
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <link rel="stylesheet" href="plugins/fontawesome-free/css/all.min.css?versao=3.251.16.1">
    <link rel="stylesheet" href="dist/css/adminlte.min.css?versao=3.251.16.1">
    <link rel="stylesheet" href="dist/css/custom.css?versao=3.251.16.1">
    <link rel="stylesheet" href="dist/css/sisplan.css?versao=3.251.16.1">
    <link rel="stylesheet" type="text/css" href="plugins/datatables-keytable/css/keyTable.bootstrap4.min.css?versao=3.251.16.1">
    <link rel="stylesheet" href="plugins/toastr/toastr.min.css?versao=3.251.16.1">
    <link rel="stylesheet" href="plugins/icheck-bootstrap/icheck-bootstrap.min.css?versao=3.251.16.1">
    <link rel="stylesheet" href="plugins/fontawesome-free/css/all.min.css?versao=3.251.16.1">
    <link rel="shortcut icon" href="favicon.ico">
    <link rel="stylesheet" type="text/css" href="dist/css/driver.min.css?versao=3.251.16.1" />
    <link rel="stylesheet" href="dist/css/jquery-ui.css?versao=3.251.16.1">
    <link href="https://fonts.googleapis.com/css?family=Source+Sans+Pro:300,400,400i,700" rel="stylesheet">
    <link rel="stylesheet" href="plugins/select2/css/select2.min.css?versao=3.251.16.1">
    <link rel="stylesheet" href="plugins/select2-bootstrap4-theme/select2-bootstrap4.min.css?versao=3.251.16.1">
    <link rel="stylesheet" href="plugins/datatables-colreorder/css/colReorder.bootstrap4.min.css?versao=3.251.16.1">
    <style>
        #tabelaAcessoRegEstado td div button {
            padding: .0rem .5rem;
            margin-top: .1rem;
            margin-bottom: .2rem;
        }

        #tabelaAcessoRegEstado td {
            padding: 0 !important;
            padding-left: 10px !important;
        }

        .content-wrapper {
            margin-left: 0px !important;
        }

        .main-header,
        .main-sidebar {
            display: none;
        }
    </style>
</head>

<body class="hold-transition sidebar-mini layout-fixed">
    <div class="wrapper">

        <div class="content-wrapper">
            <div class="content-header">
                <div class="container-fluid">
                    <div class="row mb-2">
                        <div class="col-sm-6 flex">
                            <h1 class="m-0 text-dark">Região de Estado</h1>
                            <button type="button" class="btn btn-info btn-sm ml-2" title="Tutorial" style="color: white;" id="tutorial">
                                <i class="fas fa-question-circle"></i></button>
                        </div>
                        <div class="col-sm-6">

                        </div>
                    </div>
                </div>
                <div class="container-fluid" id="tabelRegEstado">
                    <div class="row card">
                        <div class="col-sm-12 mt-3">
                            <button class="btn btn-success btn-sisp" id="btnFiltros"><span class="fas fa-search"></span> Filtros</button>
                            <button class="btn btn-danger btn-sisp" id="btnIncluir"><span class="fas fa-plus"></span> Incluir</button>
                        </div>
                        <div class="col-sm-12 table-responsive card-body">
                            <h5>Lista de Região de Estado</h5>
                            <table id="tabelaAcessoRegEstado" class="table table-sm table-select table-hover" width="100%">
                                <thead>
                                    <tr>
                                        <th class="th-sm">Código
                                        </th>
                                        <th class="th-sm">Descrição
                                        </th>
                                        <th class="th-sm">Código 2
                                        </th>
                                        <th class="th-sm">Tipo
                                        </th>
                                        <th class="th-sm">Cota
                                        </th>
                                        <th class="th-sm">Obs
                                        </th>
                                    </tr>
                                </thead>
                                <tbody>
                                </tbody>
                            </table>
                        </div>
                    </div>
                </div>
                <div id="modal-filtros" class="modal" tabindex="-1" role="dialog">
                    <div class="modal-dialog modal-xl" role="document">
                        <div class="modal-content" id="modalBody">
                            <div class="modal-header">
                                <h4 class="modal-title">Filtros</h4>
                                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                                    <span aria-hidden="true">&times;</span>
                                </button>
                            </div>
                            <div class="modal-body">
                                <div class="row">
                                    <div class="col-4 col-sm-4 col-md-4" id="TourRegEstado">
                                        <label data-error="wrong" data-success="right" for="txtRegEstado">Códigos: </label>
                                        <div class="input-group">
                                            <select class="js-example-programmatic js-states form-control" id="txtRegEstado" name="txtRegEstado" multiple="multiple">
                                            </select>
                                            <div class="input-group-append">
                                                <button class="btn bg-danger" id="btnRegEstado" name="btnRegEstado" data-button="absolute" type="button"><i class="m-0 p-0 fas fa-search"></i></button>
                                                <button class="btn bg-danger" id="btnLimpaRegEstado" name="btnLimpaRegEstado" type="button"><i class="m-0 p-0 fas fa-trash"></i></button>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="col-4 col-sm-4 col-md-4" id="TourLinha">
                                        <label data-error="wrong" data-success="right" for="txtLinha">Linha: </label>
                                        <div class="input-group">
                                            <select class="js-example-programmatic js-states form-control" id="txtLinha" name="txtLinha" multiple="multiple">
                                            </select>
                                            <div class="input-group-append">
                                                <button class="btn bg-danger" id="btnLinha" name="btnLinha" data-button="absolute" type="button"><i class="m-0 p-0 fas fa-search"></i></button>
                                                <button class="btn bg-danger" id="btnLimpaLinha" name="btnLimpaLinha" type="button"><i class="m-0 p-0 fas fa-trash"></i></button>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="col-4 col-sm-4 col-md-4" id="TourMarca">
                                        <label data-error="wrong" data-success="right" for="txtMarca">Marca: </label>
                                        <div class="input-group">
                                            <select class="js-example-programmatic js-states form-control" id="txtMarca" name="txtMarca" multiple="multiple">
                                            </select>
                                            <div class="input-group-append">
                                                <button class="btn bg-danger" id="btnMarca" name="btnMarca" data-button="absolute" type="button"><i class="m-0 p-0 fas fa-search"></i></button>
                                                <button class="btn bg-danger" id="btnLimpaMarca" name="btnLimpaMarca" type="button"><i class="m-0 p-0 fas fa-trash"></i></button>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <div class="modal-footer">
                                <div class="row">
                                    <button class="btn btn-primary btn-sisp mr-1" id="btnLimparFiltros" style="background-color: #B22222; border-color: #B22222"><span class="fas fa-trash"></span> Limpar Filtros</button>
                                    <button class="btn btn-primary btn-sisp" id="btnConsultar"><span class="fas fa-trash"></span> Consultar</button>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <?php
    include_once('../../../modais.php');
    ?>
    <aside class="control-sidebar control-sidebar-dark">
    </aside>
    </div>
    <script src="plugins/jquery/jquery.min.js?versao=3.251.16.1"></script>
    <script type="text/javascript" src="dist/js/jquery.dataTables.js?versao=3.251.16.1"></script>
    <script type="text/javascript" src="dist/js/dataTables.bootstrap4.min.js?versao=3.251.16.1"></script>
    <script src="plugins/jquery-ui/jquery-ui.min.js?versao=3.251.16.1"></script>
    <script>
        $.widget.bridge('uibutton', $.ui.button);
    </script>
    <script src="plugins/bootstrap/js/bootstrap.bundle.min.js?versao=3.251.16.1"></script>
    <script src="dist/js/adminlte.min.js?versao=3.251.16.1"></script>
    <script src="dist/js/sisplan.js?versao=3.251.16.1"></script>
    <script src="utils/funcoes.js?versao=3.251.16.1"></script>
    <script src="utils/cookies.js?versao=3.251.16.1"></script>
    <script src="dist/js/requisicoes.js?versao=3.251.16.1"></script>
    <script src="dist/js/loadingoverlay.min.js?versao=3.251.16.1"></script>
    <script src="dist/js/driver.min.js?versao=3.251.16.1"></script>
    <script src="plugins/toastr/toastr.min.js?versao=3.251.16.1"></script>
    <script src="plugins/moment/moment.min.js?versao=3.251.16.1"></script>
    <script type="text/javascript" src="dist/js/sum().js?versao=3.251.16.1"></script>
    <script type="text/javascript" src="config.js?versao=3.251.16.1"></script>
    <script src="plugins/select2/js/select2.full.min.js?versao=3.251.16.1"></script>
    <script src="plugins/datatables-colreorder/js/dataTables.colReorder.min.js?versao=3.251.16.1"></script>
    <script>
        $(document).ready(async function() {
            if (getCookie('usuario') == "") {
                window.location.href = `${BASE_URI}/login`;
                return;
            }

            let usuario = getCookie('usuario');
            let empresa = getCookie('empresa');

            ipInterno = IP_INTERNO;
            ipExterno = IP_EXTERNO;
            basicAuth = BASIC_AUTH;

            const temAcesso = await temAcessoTela('CADREGESTADO');
            if (!temAcesso.resultado) {
                toastrAcesso(temAcesso, BASE_URI);
                return;
            }

            sArquivo = `${BASE_URI}/pages/cadregestado/acesso_cadregestado/acesso_cadregestado.js?versao=3.251.16.1`;
            insereJavaScriptPagina(sArquivo);

        });
    </script>
</body>

</html>