$('#tutorial').on('click', function () {
  $(document).ready(async function () {
    const driver = new Driver({
      doneBtnText: 'Sair',
      closeBtnText: 'Fechar',
      nextBtnText: 'Próximo',
      prevBtnText: 'Anterior',
      allowClose: false
    });
    driver.defineSteps([

      {
        element: '#btnFiltros',
        popover: {
          title: 'Botão Filtros',
          description: 'Clique aqui para filtrar a consulta.',
          position: 'right'
        }
      },
      {
        element: '#btnNovoTemplate',
        popover: {
          title: 'Botão Incluir',
          description: 'Clique aqui para iniciar o cadastro de uma qualidade.',
          position: 'right'
        }
      },
      {
        element: '#tabelaQualidade',
        popover: {
          title: 'Tabela Qualidade',
          description: 'Aqui estão os dados das qualidades cadastradas.',
          position: 'top'
        }
      },
      {
        element: '#tutorialTabela',
        popover: {
          title: 'Opções de Alterar e Excluir',
          description: 'Neste botão, podemos escolher entre alterar ou excluir o registro.',
          position: 'top'
        }
      }

    ]);
    driver.start();
  });
});
//Grid Acesso//,
$(document).ready(async function () {
  await buscaStatus();
  // $('#btnConsultar').trigger('click');

  // autocompleta
  $('#txtQualidade').autocompleta(1, `JSON={ "tabela":"TABQUL", "camposSelect":[ "codigo chave", "descricao descricao"], "where": null}`);

  // pesquisa
  $('#btnConsultaQualidade').pesquisa('#txtQualidade', 'CODIGO', 'DESCRICAO', `/sisplan/funcoes/v1/pesquisa?JSON={ "tabela":"TABQUL", "camposSelect":[ "codigo", "descricao"], "where": null}`, 'Pesquisa de Qualidade', 'TABQUL');

  // limpacampo
  $('#btnLimpaQualidade, #btnLimparFiltros').on('click', function () {
    $('#txtQualidade').val('');
  });

  $('#btnFiltros').on('click', function () {
    $('#modal-filtros').modal('show');
  });

  async function buscaStatus() {
    $.LoadingOverlay("show");
    try {
      let response;
      let qualidade =
        pegaChave("#txtQualidade") != ""
          ? ` AND CODIGO = '${pegaChave("#txtQualidade")}'`
          : "";
      if ($('#txtQualidade').val() !== '') {
        response = await requisicao(
          "GET",
          "/Sisplan/Funcoes/V1/pesquisa?",
          `JSON={ "tabela":"TABQUL", "camposSelect":[ "CODIGO", "DESCRICAO", "ATIVO"], "where": ["1=1 ${qualidade}"]}`,
          null
        );
      } else {
        response = await requisicao(
          "GET",
          "/Sisplan/Funcoes/V1/pesquisa?",
          'JSON={ "tabela":"TABQUL", "camposSelect":[ "CODIGO", "DESCRICAO", "ATIVO"], "where": null}',
          null
        );
      }

      if (!response) {
        $.LoadingOverlay("hide");
        return;
      }

      let jsonStr = await response.json();
      if (response.status != 200) {
        $.LoadingOverlay("hide");
        msgErro(jsonStr.RESULT[0].mensagem);
        return;
      }

      $('#tabelaQualidade').DataTable({
        destroy: true,
        lengthChange: false,
        serverside: true,
        "language": {
          "sEmptyTable": "Nenhum registro encontrado",
          "sInfo": "_TOTAL_ registros",
          "sInfoEmpty": " 0 registros",
          "sInfoFiltered": "(Filtrados de _MAX_ registros)",
          "sInfoPostFix": "",
          "sInfoThousands": ".",
          "sLengthMenu": "_MENU_ resultados",
          "sLoadingRecords": "Carregando...",
          "sProcessing": "Processando...",
          "sZeroRecords": "Nenhum registro encontrado",
          "sSearch": "Pesquisar",
          "oPaginate": {
            "sNext": "Próximo",
            "sPrevious": "Anterior",
            "sFirst": "Primeiro",
            "sLast": "Último"
          },
          "oAria": {
            "sSortAscending": ": Ordenar colunas de forma ascendente",
            "sSortDescending": ": Ordenar colunas de forma descendente"
          }
        },

        "autoWidth": true,
        "data": jsonStr.RESULT[0],
        "columns": [{
          "data": "CODIGO"
        },
        {
          "data": "DESCRICAO"
        },
        {
          "data": "ATIVO"
        },
        ],
        "columnDefs": [{
          targets: [0], render: function (data, type, row) {
            return retornaBotaoOpcoes(data);
          }
        }]
      });

    } catch (error) {
      console.error(error);
    } finally {
      $('#modal-filtros').modal('hide');
      $.LoadingOverlay("hide");
    }
  }

  $('#btnConsultar').on('click', async function () {
    await buscaStatus(true);
  })

  $('#tabelaQualidade').on('click', '#btn-editar', async function () {
    if (permissaoUsuarioLogado.ALTERA == 'S') {
      let data = $('#tabelaQualidade').DataTable().row($(this).parents('tr')).data();
      let registroLiberado = await verificarRegistro('QUALIDADE', data.CODIGO);
      if (registroLiberado) {
        window.location.href = `qualidade/${data.CODIGO}`;
      }
    } else {
      msgAlertaSemConfirmacao("Sem permissão para alterar!");
    }
  });

  $('#tabelaQualidade').on('click', '#btn-excluir', async function () {
    if (permissaoUsuarioLogado.EXCLUI == 'S') {
      msgAlerta('Você realmente deseja excluir esse registro?', async () => {
        const data = $('#tabelaQualidade').DataTable().row($(this).parents('tr')).data();
        await excluiRegistro(data);
      });
    } else {
      msgAlertaSemConfirmacao("Sem permissão para excluir!");
    }
  });

  async function excluiRegistro(data) {
    try {
      $.LoadingOverlay("show");
      try {

        let response = await requisicao('DELETE', '/Sisplan/cadastros/V1/qualidade?', `CODIGOQUALIDADE=${encodeURIComponent(data.CODIGO)}`, null)
        if (!response) {
          return;
        }
        if (response.status != 200) {
          let jsonStr = await response.json();
          msgErro(jsonStr.mensagem);
          return;
        }

        toastr.success("Exclusão efetuada com sucesso!", "Confirmação", {
          toastClass: "success",
          iconClasses: {
            error: "alert-error",
            info: "alert-info",
            success: "alert-success",
            warning: "alert-warning",
          },
          positionClass: "toast-top-center",
          progressBar: true,
          timeOut: 3000,
          fadeOut: 1000,
          onHidden() {
            window.location.href = `${BASE_URI}/qualidade`;
          },
        }).css({
          "margin-top": "20%",
          width: "500px",
          "max-width": "500px",
        });

      } catch (error) {
        console.error(error);
      }
    } finally {
      $.LoadingOverlay("hide");
    }
  }

  function retornaBotaoOpcoes(data) {
    var retorno = '<div style="text-align:start;"> ' +
      '    <button class="btn btn-info btn-sm dropdown-toggle btnVerificaOpcoes" id="tutorialTabela" type="button" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false"> ' +
      '      ' + data + ' ' +
      '    </button> ' +
      '    <div class="dropdown-menu"> ' +
      '    <button class="dropdown-item" type="button" title="Editar" id="btn-editar">Editar</button>     ' +
      '    <button class="dropdown-item" type="button" title="Excluir" id="btn-excluir">Excluir</button>  ' +
      '</div>';
    return retorno;
  };

  async function permissaoAcessos(tela) {
    try {
      $.LoadingOverlay("show");

      let object = new Object();
      object.resultado = true;
      object.mensagem = "";

      if (getCookie("cod_usuario") == "0000") {
        object.ALTERA = "S";
        object.CONSULTA = 'S';
        object.EXCLUI = 'S';
        object.INCLUI = 'S';
        return object;
      }

      try {
        const codusuario = `'${getCookie("cod_usuario")}'`;
        const response = await requisicao(
          "GET",
          `/Sisplan/AcessoMenu/v1/Acesso?`,
          `codusuarios=${codusuario}&telas='${tela}'`,
          null,
          60000
        );

        if (!response) {
          msgErro("Erro ao buscar permissões da tela.");
          return;
        }

        let valida = await response.json();
        if (response.status != 200) {
          console.error(valida.RESULT[0].mensagem);
          msgErro("Erro ao buscar permissões da tela.");
          return;
        }

        if (valida.length <= 0) {
          object.ALTERA = "N";
          object.CONSULTA = 'N';
          object.EXCLUI = 'N';
          object.INCLUI = 'N';
          return object;
        }

        return valida[0];
      } catch (error) {
        console.error(error);
        msgErro("Erro ao buscar permissões da tela.");
      }
    } finally {
      $.LoadingOverlay("hide");
    }
  }
  const permissaoUsuarioLogado = await permissaoAcessos("QUALIDADE");

  $('#tabelaQualidade').on('dblclick', 'tr', async function () {
    if (permissaoUsuarioLogado.ALTERA == 'S') {
      let data = $('#tabelaQualidade').DataTable().row($(this)).data();
      let registroLiberado = await verificarRegistro('QUALIDADE', data.CODIGO);
      if (registroLiberado) {
        window.location.href = `qualidade/${data.CODIGO}`;
      }
    } else {
      msgAlertaSemConfirmacao("Sem permissão para alterar!");
    }
  });
});