function criaTabelaConsumos(data) {
  function retornaBotaoOpcoes(data) {
    var retorno = '<div> ' +
      '    <button class="btn btn-info btn-sm dropdown-toggle btnVerificaOpcoes consumosDatatableButtonControl" type="button" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false"> ' +
      '      ' + data + ' ' +
      '    </button> ' +
      '    <div class="dropdown-menu"> ' +
      '    <button type="button" class="dropdown-item consumosDatatableButtonControl" title="Alterar" id="btnAlterar">Alterar</button>     ' +
      '    <button type="button" class="dropdown-item consumosDatatableButtonControl" title="Excluir" id="btnExcluir">Excluir</button>     ' +
      '</div>';
    return retorno;
  }

  if ($.fn.DataTable.isDataTable('#tabelaConsumos')) {
    $('#tabelaConsumos').DataTable().destroy();
    $('#tabelaConsumos').empty();
  }

  const columns = [
    {
      data: 'ORDEM',
      title: 'Ordem'
    },
    {
      data: 'QTDE',
      title: 'Quantidade'
    },
    {
      data: 'CUSTO',
      title: 'Custo'
    },
    {
      data: 'CODIGO',
      title: 'Código'
    },
    {
      data: 'DESCRICAO',
      title: 'Descrição'
    },
    {
      data: 'ATIVO',
      title: 'Ativo'
    },
    {
      data: 'SETOR',
      title: 'Setor'
    },
    {
      data: 'DESC_SETOR',
      title: 'Desc. Setor'
    },
    {
      data: 'COR',
      title: 'Cor'
    },
    {
      data: 'DESC_COR',
      title: 'Desc. Cor'
    },
    {
      data: 'FAIXA',
      title: 'Faixa'
    },
    {
      data: 'PRECO',
      title: 'Preço'
    }
  ];

  $("#tabelaConsumos").DataTable({
    sort: false,
    paging: false,
    destroy: true,
    lengthChange: false,
    filter: false,
    info: false,
    language: {
      sEmptyTable: "Nenhum registro encontrado",
      sInfo: "_TOTAL_ registros",
      sInfoEmpty: " 0 registros",
      sInfoFiltered: "(Filtrados de _MAX_ registros)",
      sInfoPostFix: "",
      sInfoThousands: ".",
      sLengthMenu: "_MENU_ resultados",
      sLoadingRecords: "Carregando...",
      sProcessing: "Processando...",
      sZeroRecords: "Nenhum registro encontrado",
      sSearch: "Pesquisar",
      oPaginate: {
        sNext: "Próximo",
        sPrevious: "Anterior",
        sFirst: "Primeiro",
        sLast: "Último",
      },
      oAria: {
        sSortAscending: ": Ordenar colunas de forma ascendente",
        sSortDescending: ": Ordenar colunas de forma descendente",
      },
    },
    columnDefs: [
      {
        targets: [0],
        render: function (data) {
          return retornaBotaoOpcoes(data);
        }
      }
    ],
    autoWidth: true,
    data,
    columns
  }).draw(false);
}

function habilitaEdicaoConsumo() {
  $('.consumoControl').prop('disabled', false)
  $('#btnIncluirConsumo').addClass('d-none')
  $('#btnConfirmarConsumo').removeClass('d-none')
  $('#btnDesistirConsumo').removeClass('d-none')
  $('.consumosDatatableButtonControl').prop('disabled', true)
}

function desabilitaEdicaoConsumo() {
  $('.consumoControl').prop('disabled', true)
  $('#btnIncluirConsumo').removeClass('d-none')
  $('#btnConfirmarConsumo').addClass('d-none')
  $('#btnDesistirConsumo').addClass('d-none')
  $('.consumosDatatableButtonControl').prop('disabled', false)
  $('#txtMaterialConsumo').val('')
  $('#txtCorConsumo').val('')
  $('#txtSetorConsumo').val('')
  $('#txtFaixaConsumo').val('')
  $('#txtQuantidadeConsumo').val('')
  $('#txtCustoUniConsumo').val('')
  $('#cbAtivoConsumo').prop('checked', false)
  $('#cbPrecoConsumo').prop('checked', false)
  $("#tabelaConsumos tr").removeClass("selected");
}

function insereValoresEdicaoConsumo(data) {
  insereValor('#txtMaterialConsumo', data.CODIGO, data.DESCRICAO)
  insereValor('#txtCorConsumo', data.COR, data.DESC_COR)
  insereValor('#txtSetorConsumo', data.SETOR, data.DESC_SETOR)
  insereValor('#txtFaixaConsumo', data.FAIXA, data.DESC_FAIXA)
  insereValor('#txtQuantidadeConsumo', data.QTDE)
  insereValor('#txtCustoUniConsumo', data.CUSTO)
  $('#cbAtivoConsumo').prop('checked', data.ATIVO === 'S')
  $('#cbPrecoConsumo').prop('checked', data.PRECO === 'S')
}

function adicionaRegistroConsumo(data) {
  try {
    const datatable = $("#tabelaConsumos").DataTable()
    const datatableData = datatable.data().toArray()
    const selectedRow = datatable.rows(".selected")
    const editingRegister = selectedRow.data().toArray()

    if (!editingRegister || editingRegister.length === 0) {
      if (datatableData.find(e => e.CODIGO === data.CODIGO && e.COR === data.COR && e.SETOR === data.SETOR)) {
        msgErro('Esse registro já existe, impossível continuar.')
        return
      }

      const currentMaxOrder = datatableData.reduce((max, obj) => {
        return obj.ORDEM > max ? obj.ORDEM : max
      }, 0)

      data.ORDEM = currentMaxOrder + 1

      datatable.row.add(data).draw(false)
    } else {
      const [index] = selectedRow.indexes().toArray()
      const existingRegisterCount = datatableData.filter((e, i) => e.CODIGO === data.CODIGO && e.COR === data.COR && e.SETOR === data.SETOR && index !== i)

      if (existingRegisterCount && existingRegisterCount.length > 0) {
        msgErro('Esse registro já existe, impossível continuar.')
        return
      }

      if (editingRegister.length > 1) {
        throw new Error()
      }

      const [dataSelected] = editingRegister

      data.ORDEM = dataSelected.ORDEM

      datatable.row(index).data(data).draw(false)
    }
  } catch (e) {
    console.log(e)
    msgErro('Ocorreu um problema ao inserir/editar o registro, por favor tente novamente.')
  } finally {
    desabilitaEdicaoConsumo()
  }
}