$('#tutorial').on('click', function () {
  $(document).ready(async function () {
    const driver = new Driver({
      doneBtnText: 'Sair',
      closeBtnText: 'Fechar',
      nextBtnText: 'Próximo',
      prevBtnText: 'Anterior',
      allowClose: false
    });
    driver.defineSteps([

      {
        element: '#btnFiltros',
        popover: {
          title: 'Botão Filtros',
          description: 'Clique aqui para filtrar a consulta.',
          position: 'right'
        }
      },
      {
        element: '#btnNovoCadastro',
        popover: {
          title: 'Botão Incluir',
          description: 'Clique aqui para iniciar o cadastro.',
          position: 'right'
        }
      },
      {
        element: '#tabelaAmarracaoFornecedor',
        popover: {
          title: 'Tabela de Amarração códigos Fornecedores',
          description: 'Aqui estão os dados das Amarrações cadastradas.',
          position: 'bottom'
        }
      }
    ]);
    driver.start();
  });
});
$(document).ready(async function () {
  
  componenteFiltro('fornecedor', true)
  componenteFiltro('grupoMA', true)
  componenteFiltro('produto', true)
  componenteFiltro('material', true)
  componenteFiltro('servico', true)

  $('#rdTipoProduto, #rdTipoMaterial, #rdTipoServico').on('change', function () {
    $('#txtProduto').empty().trigger('change')
    $('#txtMaterial').empty().trigger('change')
    $('#txtServico').empty().trigger('change')

    if($('#rdTipoServico').is(':checked')) {
      $('#inputMaterial').addClass('d-none')
      $('#inputProduto').addClass('d-none')
      $('#inputServico').removeClass('d-none')
    }else if($('#rdTipoProduto').is(':checked')){
      $('#inputMaterial').addClass('d-none')
      $('#inputServico').addClass('d-none')
      $('#inputProduto').removeClass('d-none')
    }else {
      $('#inputMaterial').removeClass('d-none')
      $('#inputProduto').addClass('d-none')
      $('#inputServico').addClass('d-none')
    }
  });

  const permissaoUsuarioLogado = await permissaoAcessos("AMARRACAO_FORNECEDOR");

  $('#btnFiltros').on('click', function () {
    $('#modal-filtros').modal('show');
  });



  $('#btnConsultar').on('click', async function () {
    $.LoadingOverlay('show');
    await fazConsulta();
    $('#modal-filtros').modal('hide');
  });

  $('#btnLimparFiltros').on('click', async function () {
    $('#txtProduto').empty().trigger('change')
    $('#txtMaterial').empty().trigger('change')
    $('#txtServico').empty().trigger('change')
    $('#txtGrupoMA').empty().trigger('change')
    $('#txtCodFornecedor').val('')
    $('#dtAttDe').val('1200-01-01')
    $('#dtAttAte').val('2500-12-31')
  });

  async function fazConsulta() {
    if ($.fn.DataTable.isDataTable('#tabelaAmarracaoFornecedor')) {
        $("#tabelaAmarracaoFornecedor").DataTable().destroy();
        $("#tabelaAmarracaoFornecedor").empty();
    };
    try {
        const jsonStr = await retornaDados();

        if (jsonStr.length == 0) {
            throw new Error('Nenhum dado encontrado, favor verificar os filtros.')
        }

        const cols = [
          {
            data: "ID",
            title: "ID"
          },
          {
            data: "CODIGO_MAT",
            title: 'Cód. Mat'
          },
          {
            data: "DESCRICAO",
            title: 'Decrição'
          },
          {
            data: "UNIDADE",
            title: 'UN'
          },
          {
            data: "UNIDADE",
            title: 'Valor Aval.'
          },
          {
            data: "CODFOR",
            title: 'Fornecedor'
          },
          {
            data: "NOME",
            title: 'Desc. Fornecedor'
          },
          {
            data: "CODIGO_FOR",
            title: 'Cód. Fornecedor'
          },
          {
            data: "DESCRICAO_FOR",
            title: 'Desc. Fornec.'
          },
          {
            data: "PRECO",
            title: 'Preço'
          },
          {
            data: "TIPO",
            title: 'Tipo'
          },
          {
            data: "GRUPO",
            title: 'Grupo'
          },
          {
            data: "DESC_GRUPO",
            title: 'Desc. Grupo'
          },
          {
            data: "DIAS_ENTREGA",
            title: 'Dias Entrega'
          },
          {
            data: "PESO",
            title: 'Peso'
          },
          {
            data: "DT_ATUALIZA",
            title: 'Data Atualiza'
          },
          {
            data: "GRAMATURA",
            title: 'Gramatura'
          },
          {
            data: "LARGURA",
            title: 'Largura'
          },
          {
            data: "TELA",
            title: 'Tela'
          },
          {
            data: "COR",
            title: 'Cor'
          },
          {
            data: "TAM",
            title: 'Tamanho'
          }
        ];

        $("#tabelaAmarracaoFornecedor").DataTable({
            destroy: true,
            filter: false,
            lengthChange: false,
            serverside: false,
            language: {
                sEmptyTable: "Nenhum registro encontrado",
                sInfo: "_TOTAL_ registros",
                sInfoEmpty: " 0 registros",
                sInfoFiltered: "(Filtrados de _MAX_ registros)",
                sInfoPostFix: "",
                sInfoThousands: ".",
                sLengthMenu: "_MENU_ resultados",
                sLoadingRecords: "Carregando...",
                sProcessing: "Processando...",
                sZeroRecords: "Nenhum registro encontrado",
                sSearch: "Pesquisar",
                oPaginate: {
                    sNext: "Próximo",
                    sPrevious: "Anterior",
                    sFirst: "Primeiro",
                    sLast: "Último",
                },
                oAria: {
                    sSortAscending: ": Ordenar colunas de forma ascendente",
                    sSortDescending: ": Ordenar colunas de forma descendente",
                },
            },
            autoWidth: true,
            data: jsonStr,
            columns: cols,
            columnDefs: [
                {
                    targets: [0], render: function (data, type, row) {
                        return retornaBotaoOpcoes(data);
                    }
                },
            ]
        });
    } catch (error) {
        console.error(error);
        msgAlerta(error.message);
    }
    finally {
        $.LoadingOverlay('hide');
    }
  }

  $('#btnNovoCadastro').on('click', function () {
    if (permissaoUsuarioLogado.INCLUI == 'S') {
      window.location.href = "amarracao_fornecedor/create";
    } else {
      msgAlertaSemConfirmacao("Sem permissão para incluir!");
    }
  });

  $('#tabelaAmarracaoFornecedor').on('click', '#btn-editar', async function () {
    if (permissaoUsuarioLogado.ALTERA == 'S') {
      let data = $('#tabelaAmarracaoFornecedor').DataTable().row($(this).parents('tr')).data();
      let registroLiberado = await verificarRegistro('AMARRACAO_FORNECEDOR', data.ID);
      if (registroLiberado) {
        window.location.href = `amarracao_fornecedor/${data.ID}`;
      }
    } else {
      msgAlertaSemConfirmacao("Sem permissão para alterar!");
    }
  });

  $('#tabelaAmarracaoFornecedor').on('dblclick', 'tr', async function () {
    if (permissaoUsuarioLogado.ALTERA == 'S') {
      let data = $('#tabelaAmarracaoFornecedor').DataTable().row($(this)).data();
      let registroLiberado = await verificarRegistro('AMARRACAO_FORNECEDOR', data.ID);
      if (registroLiberado) {
        window.location.href = `amarracao_fornecedor/${data.ID}`;
      }
    } else {
      msgAlertaSemConfirmacao("Sem permissão para alterar!");
    }
  });

  $('#tabelaAmarracaoFornecedor').on('click', '#btn-excluir', async function () {
    if (permissaoUsuarioLogado.EXCLUI == 'S') {
      msgAlerta('Você realmente deseja excluir esse registro?', async () => {
        const data = $("#tabelaAmarracaoFornecedor").DataTable().row($(this).parents("tr"));
        await excluiRegistro(data);
      });
    } else {
      msgAlertaSemConfirmacao("Sem permissão para excluir!");
    }
  });

  async function excluiRegistro(data) {
    try {
      $.LoadingOverlay("show");
      try {
        let valorLinha = data.data();
        let response = await requisicao("DELETE", "/Sisplan/Cadastros/v1/amarracaofornecedor?", `ID=${encodeURIComponent(valorLinha.ID)}`, null);
        if (!response) {
          return;
        }
        if (response.status != 200) {
          let jsonStr = await response.json();
          msgErro(jsonStr.mensagem);
          return;
        }

        toastr.success("Exclusão efetuada com sucesso!", "Confirmação", {
          toastClass: "success",
          iconClasses: {
            error: "alert-error",
            info: "alert-info",
            success: "alert-success",
            warning: "alert-warning",
          },
          positionClass: "toast-top-center",
          progressBar: true,
          timeOut: 3000,
          fadeOut: 1000,
          onHidden() {
            data.remove().draw(false);
          },
        }).css({
          "margin-top": "20%",
          width: "500px",
          "max-width": "500px",
        });

      } catch (error) {
        console.error(error);
      }
    } finally {
      $.LoadingOverlay("hide");
    }
  }
  
  async function retornaDados() {
    let params = await buscaParametros();
    const response = await requisicao('GET', '/sisplan/cadastros/v1/buscaamarracaofornecedor?', params, '', 15000);

    if (!response) {
        return;
    }

    const jsonStr = await response.json();

    if (response.status != 200) {
        throw new Error(jsonStr.RESULT[0].mensagem);
    }

    return jsonStr
  }

  async function buscaParametros() {
    let pCodigo
    let pTipo = '';

    const tipoMap = {
      '#rdTipoServico': { input: '#txtServico', tipo: 'S' },
      '#rdTipoProduto': { input: '#txtProduto', tipo: 'P' },
      '#rdTipoMaterial': { input: '#txtMaterial', tipo: 'M' }
    };
    
    for (const [key, value] of Object.entries(tipoMap)) {
      if ($(key).is(':checked')) {
        pCodigo = await formataListas($(value.input).val().toString());
        pTipo = value.tipo;
        break;
      }
    }
    
    if (!pCodigo) {
      pCodigo = await formataListas($('#txtMaterial').val().toString());
    }
    
    let pAttDe = $('#dtAttDe').val() == '' ? '1200-01-01' : $('#dtAttDe').val();
    let pAttAte = $('#dtAttAte').val() ==='' ? '2500-12-31' : $('#dtAttAte').val();
    let pTela = isChecked('#rdTelaManual') ? 1 : (isChecked('#rdTelaNotas') ? 2 : 0);
    let pCodFornecedor = pegaValor('#txtCodFornecedor');
    let pGrupoMa = await formataListas($('#txtGrupoMA').val().toString());
    let pFornecedor = await formataListas($('#txtFornecedor').val().toString());

    let retorno =
        `ATTDE=${pAttDe}` +
        `&ATTATE=${pAttAte}` +
        `&CODIGO=${pCodigo}` +
        `&CODFOR=${pFornecedor}` +
        `&CODIGOLIKE=${pCodFornecedor}` +
        `&TIPO=${pTipo}` +
        `&TELA=${pTela}` +
        `&GRUPO=${pGrupoMa}`
    return retorno;
  };

  function retornaBotaoOpcoes(data) {
    var retorno = '<div style="text-align:start;"> ' +
      '    <button class="btn btn-info btn-sm dropdown-toggle btnVerificaOpcoes" type="button" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false"> ' +
      '      ' + data + ' ' +
      '    </button> ' +
      '    <div class="dropdown-menu"> ' +
      '    <button class="dropdown-item" type="button" title="Editar" id="btn-editar">Editar</button>     ' +
      '    <button class="dropdown-item" type="button" title="Excluir" id="btn-excluir">Excluir</button>  ' +
      '</div>';
    return retorno;
  };
});
