$(document).ready(async function () {
    let arrCusto = []

    $('#modalLancRateio').on('shown.bs.modal', async function () {
        buscaDadosRateio();
    })

    $('#btnFecharLancRateio').on('click', function () {
        $('#modalLancRateio').modal('hide')
    })

    $('#modalLancRateio').on('hidden.bs.modal', async function () {
        $('#tabelaItens').DataTable().rows().remove().draw(false)
        $('#tabelaCusto').DataTable().rows().remove().draw(false)
        arrCusto = []
    })

    function criaTabelaCusto() {
        $("#tabelaCusto").DataTable({
            lengthChange: false,
            filter: true,
            order: false,
            autoWidth: true,
            paging: false,
            info: false,
            destroy: true,
            language: {
                sEmptyTable: "Nenhum registro encontrado",
                sInfo: "_TOTAL_ registros",
                sInfoEmpty: " 0 registros",
                sInfoFiltered: "(Filtrados de _MAX_ registros)",
                sInfoPostFix: "",
                sInfoThousands: ".",
                sLengthMenu: "_MENU_ resultados",
                sLoadingRecords: "Carregando...",
                sProcessing: "Processando...",
                sZeroRecords: "Nenhum registro encontrado",
                sSearch: "Pesquisar",
                oPaginate: {
                    sNext: "Próximo",
                    sPrevious: "Anterior",
                    sFirst: "Primeiro",
                    sLast: "Último",
                },
                oAria: {
                    sSortAscending: ": Ordenar colunas de forma ascendente",
                    sSortDescending: ": Ordenar colunas de forma descendente",
                },
            },
            columnDefs: [{
                targets: [4],
                visible: false
            }],
            rowCallback: async function (row, data) {
                setTimeout(function () {
                    $(`#btnCentroCusto_${row._DT_RowIndex}`).pesquisa_serverside(
                        [`#txtCentroCusto_${row._DT_RowIndex}`],
                        ['CODIGO'],
                        ['DESCRICAO'],
                        '{"tabela":"CENTROCUSTO", "camposSelect":[ "CODIGO", "DESCRICAO"], "where": null}',
                        'Pesquisa de Centro Custo');

                    $(`#txtCentroCusto_${row._DT_RowIndex}`).autocompleta(2, `JSON={ "tabela":"CENTROCUSTO", "camposSelect":[ "CODIGO CHAVE", "DESCRICAO DESCRICAO"], "where": null}`);
                }, 100)
            },
        }).draw(false)

        $('#tabelaCusto_filter').addClass('d-none')
        $('#tabelaCusto_wrapper').prepend('<div class="row justify-content-end">' +
            '<div class="dt-buttons btn-group flex-wrap">' +
            '<button class="buttonColVis" id="btnAddCusto"><i class="fas fa-plus"></i></button>' +
            '</div>' +
            '</div>');

        $('#btnAddCusto').on("click", function () {
            let indexSelecionada = $('#tabelaItens .selected').first().index();
            const tabelaItens = $("#tabelaItens").DataTable();
            const chave = pegaChave(`#txtClasseItens_${tabelaItens.row(indexSelecionada)[0][0]}`)

            const table = $('#tabelaCusto').DataTable()
            const newRow = table.rows().count()
            table.row.add([
                retornaBotaoOpcoes(),
                retornaInputPesquisa(null, newRow),
                `<div class="input-group col-12 mx-0 px-0">
                    <input type="text" class="input-default focus form-control validate campoPercentual" id="txtPercRateioCusto_${newRow}" name="txtPercRateioCusto_${newRow}" value="" placeholder="Perc. Rateio">
                </div>`,
                `<div class="input-group col-12 mx-0 px-0">
                    <input type="text" class="input-default focus form-control validate campoValor" id="txtValorRateioCusto_${newRow}" name="txtValorRateioCusto_${newRow}" value="" placeholder="Valor">
                </div>`,
                chave
            ]).draw(false)

            arrCusto.push({
                id: newRow,
                centroCustoFixo: '',
                percRateio: 0,
                valor: 0,
                classe: 0
            })
        })
    }

    function criaTabelaItens() {
        $("#tabelaItens").DataTable({
            lengthChange: false,
            info: true,
            filter: true,
            order: false,
            autoWidth: true,
            paging: false,
            info: false,
            language: {
                sEmptyTable: "Nenhum registro encontrado",
                sInfo: "_TOTAL_ registros",
                sInfoEmpty: " 0 registros",
                sInfoFiltered: "(Filtrados de _MAX_ registros)",
                sInfoPostFix: "",
                sInfoThousands: ".",
                sLengthMenu: "_MENU_ resultados",
                sLoadingRecords: "Carregando...",
                sProcessing: "Processando...",
                sZeroRecords: "Nenhum registro encontrado",
                sSearch: "Pesquisar",
                oPaginate: {
                    sNext: "Próximo",
                    sPrevious: "Anterior",
                    sFirst: "Primeiro",
                    sLast: "Último",
                },
                oAria: {
                    sSortAscending: ": Ordenar colunas de forma ascendente",
                    sSortDescending: ": Ordenar colunas de forma descendente",
                },
            },
            rowCallback: async function (row, data) {
                setTimeout(function () {
                    $(`#btnClasseItens_${row._DT_RowIndex}`).pesquisa_serverside(
                        [`#txtClasseItens_${row._DT_RowIndex}`],
                        ['CODIGO'],
                        ['DESCRICAO'],
                        '{"tabela":"CLASSE_GER", "camposSelect":[ "CODIGO", "DESCRICAO"], "where": null}',
                        'Pesquisa de Classe');

                    $(`#txtClasseItens_${row._DT_RowIndex}`).autocompleta(2, `JSON={ "tabela":"CLASSE_GER", "camposSelect":[ "CODIGO CHAVE", "DESCRICAO DESCRICAO"], "where": null}`);
                }, 100)
            },
        }).draw(false);

        $('#tabelaItens_filter').addClass('d-none')
        $('#tabelaItens_wrapper').prepend('<div class="row justify-content-end">' +
            '<div class="dt-buttons btn-group flex-wrap">' +
            '<button class="buttonColVis" id="btnAddItens"><i class="fas fa-plus"></i></button>' +
            '</div>' +
            '</div>');

        $('#btnAddItens').on("click", function () {
            const table = $('#tabelaItens').DataTable()
            const newRow = table.rows().count()
            table.row.add([
                $('#txtNumeroRateio').val(),
                retornaInputPesquisaClasse(null, newRow),
                `<div class="input-group col-12 mx-0 px-0">
                    <input type="text" class="input-default focus form-control validate campoPercentual" id="txtPercRateioItens_${newRow}" name="txtPercRateioItens_${newRow}" value="" placeholder="Perc. Rateio">
                </div>`,
                `<div class="input-group col-12 mx-0 px-0">
                    <input type="text" class="input-default focus form-control validate campoValor" id="txtValorRateioItens_${newRow}" name="txtValorRateioItens_${newRow}" value="" placeholder="Valor">
                </div>`
            ]).draw(false)
        })

        $("#tabelaItens tbody").on("click", "tr", function () {
            $("#tabelaItens").DataTable().$("tr.selected").removeClass("selected");
            $(this).addClass("selected");
            const tabelaItens = $("#tabelaItens").DataTable();
            const tabelaCusto = $("#tabelaCusto").DataTable();

            tabelaCusto.search('').draw();
            const chave = pegaChave(`#txtClasseItens_${tabelaItens.row($(this))[0][0]}`)

            tabelaCusto.column(4).search(chave).draw(false);
        });
    }

    async function buscaDadosRateio() {
        $.LoadingOverlay('show');
        const dados = {
            numero: $('#txtNumeroRateio').val(),
            classe: $('#txtClasseRateio').val(),
            tipo: $('#txtTipoRateio').val(),
            valor: $('#txtValorRateio').val(),
            data: $('#txtDataRateio').val(),
            numeroAnt: $('#txtNumeroAnt').val(),
            dataVencto: $('#txtDataVencto').val(),
            duplicata: $('#txtDuplicata').val(),
            numeroOC: $('#txtNumeroOC').val(),
            centroCustoFixo: $('#txtCentroCustoFixo').val(),
            empId: $('#txtEmpId').val(),
        }

        try {
            const response = await requisicao('GET', '/sisplan/lancamentorateio/v1/buscadados?', `JSON=${JSON.stringify(dados)}`, 600000);
            if (!response) {
                return;
            }

            const data = await response.json();
            if (response.status != 200) {
                msgErro(data.mensagem);
                return;
            }

            await adicionaDadosItens(data.itens);
            await adicionaDadosCentroCusto(data.centroCusto)

        } catch (e) {
            console.log(e);
            msgErro(`Não foi possível buscar os dados: ${e}`);
        } finally {
            $.LoadingOverlay('hide');
        }
    };

    function retornaBotaoOpcoes() {
        return '<div class="divBtnOpcoes"> ' +
            '    <button class="botaoOpcoes" id="btnExcluirRateio" class="botaoOpcoes" type="button"><span class="fas fa-trash-alt" style="color:red"></span></button>  ' +
            '   </div>';
    };

    function retornaInputPesquisa(data, row) {
        let info = !!data ? '[' + data.centroCustoFixo + '] - ' + data.descricao : '';

        return `<div class="input-group-append">
                <input style="width: 9rem !important;" type="text" class="input-default focus form-control validate centroCusto"
                    id="txtCentroCusto_${row}" name="txtCentroCusto_${row}" value="${info}" required placeholder="Centro Custo">
                <div class="input-group-append">
                    <button class="btn bg-danger" id="btnCentroCusto_${row}" name="btnCentroCusto_${row}"
                        data-button="absolute" type="button"><i
                            class="m-0 p-0 fas fa-search"></i></button>
                </div>
            </div>`;
    };

    function retornaInputPesquisaClasse(data, row) {
        let info = !!data ? '[' + data.classe + '] - ' + data.descricao : '';

        return `<div class="input-group-append">
                <input style="width: 9rem !important;" type="text" class="input-default focus form-control validate"
                    id="txtClasseItens_${row}" name="txtClasseItens_${row}" value="${info}" required placeholder="Classe">
                <div class="input-group-append">
                    <button class="btn bg-danger" id="btnClasseItens_${row}" name="btnClasseItens_${row}"
                        data-button="absolute" type="button"><i
                            class="m-0 p-0 fas fa-search"></i></button>
                </div>
            </div>`;
    };

    async function adicionaDadosItens(data) {
        if ($.fn.DataTable.isDataTable('#tabelaItens')) {
            $('#tabelaItens').empty();
            $('#tabelaItens').DataTable().destroy();
        };
        criaTabelaItens()
        const table = $('#tabelaItens').DataTable();
        try {
            data?.map((item, i) => {
                table.row.add([
                    item.numero,
                    retornaInputPesquisaClasse(item, i),
                    `<div class="input-group col-12 mx-0 px-0">
                        <input type="text" class="input-default focus form-control validate campoPercentual" id="txtPercRateioItens_${i}" name="txtPercRateioItens_${i}" value="${TruncaDecimaisNova(2, item.percRateio)}" placeholder="Perc. Rateio">
                    </div>`,
                    `<div class="input-group col-12 mx-0 px-0">
                        <input type="text" class="input-default focus form-control validate campoValor" id="txtValorRateioItens_${i}" name="txtValorRateioItens_${i}" value="${TruncaDecimaisNova(2, item.valor)}" placeholder="Valor">
                    </div>`
                ]).draw(false)
            })
            console.table(data)
            preencheValorTotal()
        } catch (e) {
            console.log(e);
            msgErro(`Não foi possível carregar os dados: ${e}`);
        }
    };

    async function adicionaDadosCentroCusto(data) {
        if ($.fn.DataTable.isDataTable('#tabelaCusto')) {
            $('#tabelaCusto').empty();
            $('#tabelaCusto').DataTable().destroy();
        };
        criaTabelaCusto()
        const table = $('#tabelaCusto').DataTable();
        try {
            data?.map((item, i) => {
                table.row.add([
                    retornaBotaoOpcoes(),
                    retornaInputPesquisa(item, i),
                    `<div class="input-group col-12 mx-0 px-0">
                        <input type="text" class="input-default focus form-control validate campoPercentual" id="txtPercRateioCusto_${i}" name="txtPercRateioCusto_${i}" value="${TruncaDecimaisNova(2, item.percRateio)}" placeholder="Perc. Rateio">
                    </div>`,
                    `<div class="input-group col-12 mx-0 px-0">
                        <input type="text" class="input-default focus form-control validate campoValor" id="txtValorRateioCusto_${i}" name="txtValorRateioCusto_${i}" value="${TruncaDecimaisNova(2, item.valor)}" placeholder="Valor">
                    </div>`,
                    item.classe
                ]).draw(false)

                arrCusto.push({
                    id: i,
                    centroCustoFixo: item.centroCustoFixo,
                    percRateio: item.percRateio,
                    valor: item.valor,
                    classe: item.classe
                })
            })
            $('#tabelaItens tbody tr:first').trigger('click')
            preencheValorSaldo()
            console.table(arrCusto)
        } catch (e) {
            console.log(e);
            msgErro(`Não foi possível carregar os dados: ${e}`);
        }
    };

    $('#tabelaCusto').on('blur', '.campoPercentual', async function () {
        try {
            if ($(`#txtCentroCusto_${$('#tabelaCusto').DataTable().row($(this).parents('tr'))[0][0]}`).val() == '') {
                throw msgAlerta('Classe não informada, verifique!')
            }
            if (this.value == '') {
                this.value = 0
                return
            }

            await recalculaCusto(this)
            atualizaValoresCCNovo()
            atualizaObjeto($('#tabelaCusto').DataTable().row($(this).parents('tr'))[0][0])
            preencheValorSaldo()

        } catch (e) {
            console.log(e)
        }
        validaPercentualCusto()
    })

    $('#tabelaItens').on('blur', '.campoPercentual', async function () {
        try {
            if ($(`#txtClasseItens_${$('#tabelaItens').DataTable().row($(this).parents('tr'))[0][0]}`).val() == '') {
                throw msgAlerta('Classe não informada, verifique!')
            }
            await recalculaItens(this)

            if (this.value == '') {
                this.value = 0
            }

            atualizaValoresCCNovo()
            atualizaObjeto($('#tabelaCusto').DataTable().row($(this).parents('tr'))[0][0])
            preencheValorSaldo()
        } catch (e) {
            console.log(e)
        }
    })

    function validaPercentualItens(gravar = false) {
        const total = 100
        let percInput = 0

        $('#tabelaItens').DataTable().rows({ page: 'current' }).every((item) => {
            percInput += parseFloat($(`#txtPercRateioItens_${item}`).val())
        })

        if (percInput > total) {
            throw msgAlerta('Somatório dos percentuais dos itens é superior à 100%, verifique!')
        }
        if (gravar) {
            if (percInput < total) {
                throw msgAlerta('Somatório dos percentuais dos itens não fecha 100%, verifique!')
            }
        }
    }

    async function recalculaCusto(input) {
        validaPercentualCusto()
        let indexSelecionada = $('#tabelaItens .selected').first().index();
        const table = $('#tabelaCusto').DataTable()
        const valorTotal = $(`#txtValorRateioItens_${indexSelecionada}`).val()
        const novoPercentual = $(input)[0].value
        const rowIndex = table.row($(input).parents('tr'))[0][0]


        await new Promise((resolve, reject) => {
            if ($(`#txtValorRateioCusto_${rowIndex}`).val() != 0) {
                if (TruncaDecimaisNova(2, (valorTotal / 100) * novoPercentual) != parseFloat($(`#txtValorRateioCusto_${rowIndex}`).val())) {
                    msgAlerta('Atenção valor calculado é diferente do valor já informado no campo valor \n' +
                        `Calculado:${TruncaDecimaisNova(2, valorTotal / 100 * novoPercentual)} Valor inf.:${$(`#txtValorRateioCusto_${rowIndex}`).val()}.\n` +
                        `Deseja manter o valor informado?`,
                        () => {
                            novoValor = valorTotal * novoPercentual / 100
                            $(`#txtValorRateioCusto_${rowIndex}`).val(TruncaDecimaisNova(2, novoValor))
                            resolve()
                        },
                        () => {
                            reject()
                        },
                        () => {
                            novoValor = valorTotal * novoPercentual / 100
                            $(`#txtValorRateioCusto_${rowIndex}`).val(TruncaDecimaisNova(2, novoValor))
                            resolve()
                        },
                        () => {
                            reject()
                        },
                    )
                }
            } else {
                novoValor = valorTotal * novoPercentual / 100
                $(`#txtValorRateioCusto_${rowIndex}`).val(TruncaDecimaisNova(2, novoValor))
                resolve()
            }
        })
    }

    async function recalculaItens(input) {
        validaPercentualItens()
        let row = $('#tabelaItens .selected').first().index();
        const valorTotal = $(`#txtValorTotalCentroCusto`).html()
        const novoPercentual = $(input)[0].value

        if ($(`#txtValorRateioItens_${row}`).val() != 0) {
            await new Promise((resolve, reject) => {
                if ((valorTotal / 100 * novoPercentual) != TruncaDecimaisNova(2, $(`#txtValorRateioItens_${row}`).val())) {
                    msgAlerta('Atenção, valor calculado é diferente do valor já informado no campo valor \n' +
                        `Calculado:${TruncaDecimaisNova(2, valorTotal / 100 * novoPercentual)} Valor inf.:${$(`#txtValorRateioItens_${row}`).val()}.\n` +
                        `Deseja menter o valor informado?`,
                        () => {
                            let novoValor = valorTotal * novoPercentual / 100
                            $(`#txtValorRateioItens_${row}`).val(TruncaDecimaisNova(2, novoValor))
                            calcula()
                            resolve()
                        },
                        () => {
                            reject()
                        },
                        () => {
                            let novoValor = valorTotal * novoPercentual / 100
                            $(`#txtValorRateioItens_${row}`).val(TruncaDecimaisNova(2, novoValor))
                            calcula()
                            resolve()
                        },
                        () => {
                            reject()
                        },
                    )
                }
            })
        } else {
            let novoValor = valorTotal * novoPercentual / 100
            $(`#txtValorRateioItens_${row}`).val(TruncaDecimaisNova(2, novoValor))
            calcula()
        }
    }

    function validaPercentualCusto(gravar = false) {
        const total = 100
        let percInput = 0

        $('#tabelaCusto').DataTable().rows({ page: 'current' }).every((item) => {
            percInput += parseFloat($(`#txtPercRateioCusto_${item}`).val())
        })

        if (percInput > total) {
            throw msgAlerta('Somatório dos percentuais dos centros de custo é superior à 100%, verifique!')
        }
        if (gravar) {
            if (percInput < total) {
                throw msgAlerta('Somatório dos percentuais dos centros de custo não fecha 100%, verifique!')
            }
        }
    }

    function atualizaObjeto(index) {
        let table = $('#tabelaCusto').DataTable()

        table.rows({ page: 'current' }).every((item) => {
            arrCusto[item] = {
                ...arrCusto[item],
                valor: $(`#txtValorRateioCusto_${item}`).val(),
                percRateio: $(`#txtPercRateioCusto_${item}`).val()
            }
        })

        if (!index && index != 0) {
            return
        }
        if (pegaChave(`#txtCentroCusto_${index}`) == '#') {
            arrCusto = arrCusto.filter(item => item.id != index)
        } else {
            arrCusto[index] = {
                ...arrCusto[index],
                centroCustoFixo: pegaChave(`#txtCentroCusto_${index}`),
                percRateio: TruncaDecimaisNova(2, $(`#txtPercRateioCusto_${index}`).val()),
                valor: TruncaDecimaisNova(2, $(`#txtValorRateioCusto_${index}`).val()),
                classe: pegaChave(`#txtClasseItens_${$('#tabelaItens .selected').first().index()}`)
            }
        }
        $('#tabelaCentroCusto').DataTable().rows().data(arrCusto).draw(false);
        console.table(arrCusto)
    }

    function preencheValorTotal() {
        let valor = 0;
        const table = $('#tabelaItens').DataTable()
        const rows = table.rows().count()

        for (let i = 0; i < rows; i++) {
            valor += parseFloat($(`#txtValorRateioItens_${i}`).val());
        }
        if (valor == 0) {
            $('#txtValorTotalCentroCusto').html($('#txtValorRateio').val())
        } else {
            $('#txtValorTotalCentroCusto').html(valor.toFixed(2))
        }
    }

    function preencheValorSaldo() {
        const valorTotal = parseFloat($('#txtValorTotalCentroCusto').html())

        let valores = 0

        valores = arrCusto.reduce((acumulador, item) => {
            return acumulador + parseFloat(item.valor);
        }, 0)
        if (valores != 0) {
            $('#txtSaldoCentroCusto').html((valorTotal - valores).toFixed(2))
        }
    }

    $('#btnGravarLancRateio').on('click', async function () {
        await gravarRateio()
        $('#modalLancRateio').modal('hide')
    })

    async function gravarRateio() {
        validaPercentualItens()
        validaPercentualCusto()
        if (parseFloat($('#txtSaldoCentroCusto').html()) > 0) {
            throw msgAlerta('Ainda possui saldo pendente, verifique!')
        }

        const tabelaItens = $('#tabelaItens').DataTable().rows().data().toArray();

        const Itens = tabelaItens.map((dados, i) => ({
            numero: dados[0],
            classe: pegaChave(`#txtClasseItens_${i}`),
            percRateio: $(`#txtPercRateioItens_${i}`).val(),
            valor: $(`#txtValorRateioItens_${i}`).val()
        }))

        const Rateio = {
            numero: $('#txtNumeroRateio').val(),
            classe: $('#txtClasseRateio').val(),
            tipo: $('#txtTipoRateio').val(),
            valor: $('#txtValorRateio').val(),
            data: $('#txtDataRateio').val(),
            numeroAnt: $('#txtNumeroAnt').val(),
            dataVencto: $('#txtDataVencto').val(),
            duplicata: $('#txtDuplicata').val(),
            numeroOC: $('#txtNumeroOC').val(),
            centroCustoFixo: $('#txtCentroCustoFixo').val(),
            valorTotal: $('#txtValorTotalCentroCusto').html(),
            empID: $('#txtEmpId').val()
        }

        const body = {
            Itens: Itens,
            CentroCusto: arrCusto
        }

        let response = await requisicao("POST", `/sisplan/lancamentorateio/V1/gravadados?`, `PARAMS=${JSON.stringify(Rateio)}`, JSON.stringify(body));
        if (!response) {
            return
        }

        let jsonStr = await response.json();

        if (response.status != 200) {
            throw msgAlerta(jsonStr.mensagem);
        }
        toastr.success(
            `Cadastro efetuado com sucesso!`,
            'Confirmação', {
            toastClass: 'alert',
            iconClasses: {
                error: 'alert-error',
                info: 'alert-info',
                success: 'alert-success',
                warning: 'alert-warning'
            },
            positionClass: "toast-top-center",
            progressBar: true,
            timeOut: 3000,
            fadeOut: 1000,
            onHidden() {
                $('#modalLancRateio').trigger('fechaRateioDesagrupaPagar');
            },
        }
        ).css({
            "margin-top": "20%",
            "width": "500px",
            "max-width": "500px"
        });
    }

    $('#tabelaCusto').on('click', '#btnExcluirRateio', async function () {
        msgAlerta('Você realmente deseja excluir esse registro?', async () => {
            let index = $('#tabelaCusto').DataTable().row(this.closest('tr')).index()
            await excluiRegistro([arrCusto[index]]);

            $("#tabelaCusto").DataTable().row(index).remove().draw(false);
            atualizaObjeto([arrCusto[index].id][0])
            preencheValorSaldo()
        });
    });

    async function excluiRegistro(data) {
        try {
            $.LoadingOverlay("show");
            const tabelaItens = $('#tabelaItens').DataTable().rows().data().toArray();

            const Itens = tabelaItens.map((dados, i) => ({
                numero: dados[0],
                classe: pegaChave(`#txtClasseItens_${i}`),
                percRateio: $(`#txtPercRateioItens_${i}`).val(),
                valor: $(`#txtValorRateioItens_${i}`).val()
            }))

            const Rateio = {
                numero: $('#txtNumeroRateio').val(),
                classe: $('#txtClasseRateio').val(),
                tipo: $('#txtTipoRateio').val(),
                valor: $('#txtValorRateio').val(),
                data: $('#txtDataRateio').val(),
                numeroAnt: $('#txtNumeroAnt').val(),
                dataVencto: $('#txtDataVencto').val(),
                duplicata: $('#txtDuplicata').val(),
                numeroOC: $('#txtNumeroOC').val(),
                centroCustoFixo: $('#txtCentroCustoFixo').val(),
                valorTotal: $('#txtValorTotalCentroCusto').html(),
                empID: $('#txtEmpId').val()
            }

            const params = {
                CentroCusto: data,
                Itens: Itens
            }

            try {
                let response = await requisicao("DELETE", "/sisplan/lancamentorateio/v1/excluirdados?", `JSON=${JSON.stringify(params)}&PARAMS=${JSON.stringify(Rateio)}`, null);
                if (!response) {
                    return;
                }
                if (response.status != 200) {
                    let jsonStr = await response.json();
                    msgErro(jsonStr.mensagem);
                    return;
                }

            } catch (error) {
                console.error(error);
            }
        } finally {
            $.LoadingOverlay("hide");
        }
    }

    function atualizaValoresCCNovo() {
        let percTotal = 100
        let valorTotal = parseFloat($(`#txtValorRateioItens_${$('#tabelaItens .selected').first().index()}`).val())
        let dif = 0
        let valores = 0
        let percs = 0
        let novoValor = 0

        $('#tabelaCusto').DataTable().rows({ page: 'current' }).every((item) => {
            novoValor = TruncaDecimaisNova(2, (parseFloat($(`#txtPercRateioCusto_${item}`).val()) / 100) * valorTotal)

            valores += novoValor
            percs += parseFloat($(`#txtPercRateioCusto_${item}`).val())

            if ($(`#txtPercRateioCusto_${item}`).val() == '') {
                novoValor = 0
            }
            $(`#txtValorRateioCusto_${item}`).val(TruncaDecimaisNova(2, novoValor))
        })

        if (percTotal == percs) {
            dif = valorTotal - valores
            // if (dif != 0) {
            //     if (dif < 0) {
            //         dif += dif + 0.01
            //     } else {
            //         dif += dif - 0.01
            //     }
            // }
            $(`#txtValorRateioCusto_0`).val(TruncaDecimaisNova(2, parseFloat($(`#txtValorRateioCusto_0`).val()) + dif))
        }
    }

    function calcula() {
        let percTotal = 100
        let percItens = 0
        let valorTotal = parseFloat($('#txtValorTotalCentroCusto').html())
        let valores = 0
        let dif = 0

        $('#tabelaItens').DataTable().rows({ page: 'current' }).every((item) => {
            percItens += parseFloat($(`#txtPercRateioItens_${item}`).val())
            valores += parseFloat($(`#txtValorRateioItens_${item}`).val())
        })

        if (percItens == percTotal) {
            if (TruncaDecimaisNova(2, valores) != TruncaDecimaisNova(2, valorTotal)) {
                dif = TruncaDecimaisNova(2, TruncaDecimaisNova(2, valores) - TruncaDecimaisNova(2, valorTotal))
                if (dif != 0) {
                    if (dif > 0) {
                        dif = dif - 0.01 - 0.01
                    } else {
                        dif += dif + 0.01
                    }
                }
                $(`#txtValorRateioItens_${$('#tabelaItens .selected').first().index()}`).val(TruncaDecimaisNova(2, parseFloat($(`#txtValorRateioItens_${$('#tabelaItens .selected').first().index()}`).val()) + dif))
            }
        }
    }
});


