$(document).ready(async function () {
  let verificaInclusao = false;
  let fotoCamera;
  $("#modal-anexos").on('show.bs.modal', async function () {
    await bloqueiaCampos();
    await buscaAnexo($('#txtChave').val(), $('#txtTela').val());
    $("#imgAnexo").attr('src', `${BASE_URI}/dist/img/prod-1.png`);
  });

  $('#txtDocumento').autocompleta(1, `JSON={ "tabela":"TIPO_DOCUMENTO", "camposSelect":["CODIGO CHAVE, DESCRICAO DESCRICAO"], "where": []}`);
  $('#btnDocumento').pesquisa('#txtDocumento', 'CODIGO', 'DESCRICAO', '/sisplan/funcoes/v1/pesquisa?JSON={ "tabela":"TIPO_DOCUMENTO", "camposSelect":[ "CODIGO", "DESCRICAO"], "where": null}', 'Pesquisa Tipo Documento', 'TIPO_DOCUMENTO');

  $('#fileimagem').change(async function () {
    try {
      $.LoadingOverlay("show");
      const leitorDeArquivos = new FileReader();
      const previaDaImagem = document.querySelector('.imagem');
      const inputArquivo = document.querySelector('.upload');

      let imagemEnviada = inputArquivo.files[0];
      leitorDeArquivos.readAsDataURL(imagemEnviada);
      leitorDeArquivos.addEventListener('loadend', function (load) {
        previaDaImagem.src = load.target.result;
      });

    } finally {
      $.LoadingOverlay('hide');
    }
  });

  $('#btnIncluirAnexo').on('click', async function () {
    desbloqueiaCampos();
    verificaInclusao = true;
    buscaDataAtual();
    await mostraBotaoGravar();
    const Ordem = await findLastOrder();
    limpaCampos(Ordem);
    $('#txtOrdemAnexo').focus();
    mostraBotaoCancelar();

  });

  async function buscaDataAtual() {
    Date.prototype.toDateInputValue = (function () {
      var local = new Date(this);
      local.setMinutes(this.getMinutes() - this.getTimezoneOffset());
      return local.toJSON().slice(0, 10);
    });

    $(document).ready(function () {
      $('#dtCadastro').val(new Date().toDateInputValue());
    });

    $(document).ready(function () {
      $('#dtValidade').val(new Date().toDateInputValue());
    });
  }

  $('#tabelaAnexo').on('click', '#btn-download', async function () {
    const data = $('#tabelaAnexo').DataTable().row($(this).parents('tr'));
    await preparaParaBaixarAnexo(data)
  });

  $('#tabelaAnexo').on('click', '#btn-excluir', async function () {
    msgAlerta('Você realmente deseja excluir esse registro?', async () => {
      const data = $("#tabelaAnexo").DataTable().row($(this).parents("tr"));
      await excluiRegistro(data);
    });
  });

  async function preparaParaBaixarAnexo(sData) {
    let sRow = sData.data();
    window.event.preventDefault()
    try {
      let response = await requisicao('GET', '/sisplan/funcoes/v1/caminhoanexos?', null);
      if (!response) {
        return;
      }
      let data = await response.json();
      let pastaAnexosLocal = data.mensagem;
      try {
        let response = await requisicao('GET', '/sisplan/funcoes/v1/caminhorelatorios?', null);
        if (!response) {
          return;
        }
        let data2 = await response.json();
        let rotaBase = data2.mensagem.replace(/\\/g, '/');
        let Base = rotaBase.split("/", 3);
        try {
          let response = await requisicao('GET', '/sisplan/funcoes/v1/baixaranexo?', `TELA=${sRow.TELA}&ARQUIVO=${sRow.ARQUIVO}&CHAVE=${encodeURIComponent(sRow.CAMPO_CHAVE)}&DIRETORIO=${pastaAnexosLocal}&EMP_PAT=${getCookie('g_empresa_logada')}`)
          if (!response) {
            return
          }
          let data = await response.json()
          const rotaSemFormatacao = data.mensagem.replace(/\\/g, '/');
          const urlAtual = window.location.href.split("/", 3);
          const rotaFormatada = rotaSemFormatacao.replace(Base[0] + '/' + Base[1] + '/' + Base[2] + '/', urlAtual[0] + '//' + urlAtual[2] + '/');
          await baixaArquivo(rotaFormatada);
        } catch (error) {
          console.log(error)
          return
        }
      } catch (error) {
        console.log(error)
      }
    } catch (error) {
      console.log(error);
    } finally {
      $.LoadingOverlay('hide');
    }
  }

  async function baixaArquivo(link) {
    $('#anchorDownload').attr('href', link)
    $('#btnDownloadTrigger').trigger('click')
  }

  async function excluiRegistro(sData) {
    let sRow = sData.data();
    try {
      $.LoadingOverlay("show");
      try {
        let response = await requisicao("DELETE", "/sisplan/anexo/v1/excluiranexo?", `ORDEM=${sRow.ORDEM}&ARQUIVO=${sRow.ARQUIVO}&CHAVE=${encodeURIComponent(sRow.CAMPO_CHAVE)}`, null);
        if (!response) {
          return;
        }
        if (response.status != 200) {
          let jsonStr = await response.json();
          msgErro(jsonStr.mensagem);
          return;
        }
        try {
          let response = await requisicao('GET', '/sisplan/funcoes/v1/caminhoanexos?', null);
          if (!response) {
            return;
          }
          jsonStr = await response.json();
          let pastaAnexos = jsonStr.mensagem;

          response = await requisicao('DELETE', '/sisplan/funcoes/v1/anexoarquivo?',
            `DIRETORIO=${pastaAnexos}&TELA=${sRow.TELA}&CHAVE=${encodeURIComponent(sRow.CAMPO_CHAVE)}&ARQUIVO=${sRow.ARQUIVO}&EMP_PAT=${getCookie('g_empresa_logada')}`);

        } catch (error) {
          console.log(error)
        }

        toastr.success("Exclusão efetuada com sucesso!", "Confirmação", {
          toastClass: "success",
          iconClasses: {
            error: "alert-error",
            info: "alert-info",
            success: "alert-success",
            warning: "alert-warning",
          },
          positionClass: "toast-top-center",
          progressBar: true,
          timeOut: 3000,
          fadeOut: 1000,
          onHidden() {
            sData.remove().draw(false);
            $("#imgAnexo").attr('src', `${BASE_URI}/dist/img/prod-1.png`)
            limpaCampos('');
          },
        }).css({
          "margin-top": "20%",
          width: "500px",
          "max-width": "500px",
        });

      } catch (error) {
        console.error(error);
      }
    } finally {
      $.LoadingOverlay("hide");
    }
  }

  $("#modal-anexos").on('hide.bs.modal', async function () {
    limpaCampos('');
    // await mostraBotaoIncluir();
    $('#btnCancelar').trigger('click');
  });

  async function mostraBotaoIncluir() {
    $('#btnIncluirAnexo').removeClass('d-none');
    $('#btnGravarAnexo').addClass('d-none');
    $('#btnAlterarAnexo').attr('disabled', false)
  }
  async function mostraBotaoGravar() {
    $('#btnIncluirAnexo').addClass('d-none');
    $('#btnGravarAnexo').removeClass('d-none');
    $('#btnAlterarAnexo').attr('disabled', true)
  };

  $('#btnAlterarAnexo').on('click', async function () {
    if ($('#tabelaAnexo').DataTable().data().length == 0) {
      msgAlerta('Nenhum dado para alterar.')
      return
    }
    mostraBotaoCancelar()
    desbloqueiaCampos()
    mostraBotaoGravar()
  });

  $('#btnCancelar').on('click', async function () {
    mostraBotaoIncluir()
    mostraBotaoAlterar()
    bloqueiaCampos()
    $('#tabelaAnexo').find('tbody tr:eq(0)').trigger('click');
  })

  async function mostraBotaoAlterar() {
    $('#btnAlterarAnexo').removeClass('d-none')
    $('#btnCancelar').addClass('d-none')
  }

  async function mostraBotaoCancelar() {
    $('#btnAlterarAnexo').addClass('d-none')
    $('#btnCancelar').removeClass('d-none')
  }

  $('#btnGravarAnexo').on('click', async function () {
    await gravaDados();
    $('#btnCancelar').trigger('click')
  });

  async function gravaDados() {
    if (verificaInclusao) {
      const verificaOrdem = await orderExists($('#txtOrdemAnexo').val())
      if (!verificaOrdem) {
        throw msgAlerta('Esta ordem já existe!');
      }
    }

    if ($('#dtValidade').val() < $('#dtCadastro').val()) {
      throw msgAlerta('Data de validade menor que a data de cadastro, impossível continuar.');
    }
    if (!$('#txtOrdemAnexo').val()) {
      throw msgAlerta('Necessário inserir uma ordem.');
    }
    if (!$('#txtArquivo').val()) {
      throw msgAlerta('Nenhum arquivo foi selecionado!');
    }
    if (!$('#txtDescricao').val()) {
      throw msgAlerta('Deve conter uma descrição, verifique!');
    }

    const Anexo = {
      Tela: $('#txtTela').val(),
      Arquivo: $('#txtArquivo').val(),
      Descricao: $('#txtDescricao').val(),
      Data: $('#dtCadastro').val(),
      Campo_Chave: $('#txtChave').val(),
      Ordem: $('#txtOrdemAnexo').val(),
      Dt_validade: $('#dtValidade').val(),
      Tipo_doc: $('#txtDocumento').val(),
      Usuario: $('#txtUsuario').val(),
    }
    await gravaAnexoBanco(Anexo);
    await gravaAnexoDiretorio(Anexo);
  };

  async function gravaAnexoBanco(Anexo) {
    const url = `/sisplan/anexo/v1/gravaanexo?`
    const response = await requisicao('POST', url, '', `JSON=${JSON.stringify(Anexo)}`, 90000);

    if (!response) {
      return;
    }

    if (response.status != 200) {
      return;
    }
  }

  async function gravaAnexoDiretorio() {
    $.LoadingOverlay('show');
    try {
      const sTela = $('#txtTela').val();
      const sChave = $('#txtChave').val();
      const sArquivo = $('#txtArquivo').val();
      let baseString;

      if ($('#btnAddArquivo').prop('disabled')) {
        baseString = await uploadCamera();
      } else if ($('#btnCamera').prop('disabled')) {
        let file = document.querySelector('#mdModalUpload').files[0];
        let reader = new FileReader();
        reader.onloadend = function () {
          baseString = { arquivo: reader.result, type: file.type }
        };
        reader.readAsDataURL(file);
      }

      let response = await requisicao('GET', '/sisplan/funcoes/v1/caminhoanexos?', null);
      jsonStr = await response.json();
      if (response.status != 200) {
        $("#imgAnexo").attr('src', `${BASE_URI}/dist/img/prod-1.png`);
        throw msgAlerta(jsonStr.mensagem);
      }

      let pastaAnexos = jsonStr.mensagem;

      response = await requisicao('POST', '/sisplan/funcoes/v1/anexoarquivo?',
        `DIRETORIO=${pastaAnexos}&TELA=${sTela}&CHAVE=${encodeURIComponent(sChave)}&ARQUIVO=${sArquivo}&EMP_PAT=${getCookie('g_empresa_logada')}`,
        `SBASE64=${encodeURIComponent(baseString.arquivo)}&FILETYPE=${baseString.type}`);

      await buscaAnexo(sChave, sTela);

      mostraBotaoIncluir();
      mostraBotaoAlterar();
    } catch (error) {
      console.error(error);
    } finally {
      $.LoadingOverlay("hide");
    }
  }

  async function uploadCamera() {
    return { arquivo: imgElement.src, type: 'image/jpeg' }
  }

  async function bloqueiaCampos() {
    $('#txtOrdemAnexo').attr("disabled", true);
    $('#txtOrdemAnexo').attr('readonly', true);
    $('#dtValidade').attr('disabled', true);
    $('#dtValidade').attr('readonly', true);
    $('#txtDescricao').attr('disabled', true);
    $('#txtDescricao').attr('readonly', true);
    $('#btnDocumento').attr('disabled', true);
    $('#btnAddArquivo').attr('disabled', true);
    $('#btnAddArquivo').attr('readonly', true);
    $('#btnCamera').attr('disabled', true);
    $('#btnLimpaDocumento').attr('disabled', true);
    $('#btnLimpaDocumento').attr('readonly', true);
    $('.botaoOpcoes').attr('disabled', false)
    $('.botaoOpcoes').attr('readonly', false)
    $('.botaoOpcoes').attr('disabled', false);
    $('.botaoOpcoes').attr('readonly', false);
  };

  async function desbloqueiaCampos() {
    $('#txtOrdemAnexo').attr("disabled", false);
    $('#txtOrdemAnexo').attr('readonly', false);
    $('#dtValidade').attr('disabled', false);
    $('#dtValidade').attr('readonly', false);
    $('#txtDescricao').attr('disabled', false);
    $('#txtDescricao').attr('readonly', false);
    $('#btnAddArquivo').attr('disabled', false);
    $('#btnAddArquivo').attr('readonly', false);
    $('#btnCamera').attr('disabled', false);
    $('.botaoOpcoes').attr('disabled', true)
    $('.botaoOpcoes').attr('readonly', true)
    $('.botaoOpcoes').attr('disabled', true);
    $('.botaoOpcoes').attr('readonly', true);
  };

  //Faz a pesquisa dos anexos vinculados a essa chave
  async function buscaAnexo(sChave, sTela) {
    const pesquisaParam = {
      tabela: "ANEXO",
      camposSelect: [
        "ANEXO.TELA",
        "ANEXO.ARQUIVO",
        "ANEXO.DESCRICAO",
        "ANEXO.DATA",
        "ANEXO.CAMPO_CHAVE",
        "ANEXO.ORDEM",
        "ANEXO.DT_VALIDADE",
        "ANEXO.USUARIO",
        "USUARIO.NOME"
      ],
      leftJoin: [
        { tabela: 'ACESSO_USUARIOS', alias: "USUARIO", condicao: 'USUARIO.CODIGO = ANEXO.USUARIO' },
      ],
      where: [`CAMPO_CHAVE = '${sChave}' AND TELA='${sTela}'`]
    };
    const jsonStr = await retornaJsonPesquisaPadrao(encodeURIComponent(JSON.stringify(pesquisaParam)));

    $("#tabelaAnexo").DataTable({
      destroy: true,
      order: false,
      search: false,
      filter: false,
      lengthChange: false,
      serverside: false,
      language: {
        sEmptyTable: "Nenhum registro encontrado",
        sInfo: "_TOTAL_ registros",
        sInfoEmpty: " 0 registros",
        sInfoFiltered: "(Filtrados de _MAX_ registros)",
        sInfoPostFix: "",
        sInfoThousands: ".",
        sLengthMenu: "_MENU_ resultados",
        sLoadingRecords: "Carregando...",
        sProcessing: "Processando...",
        sZeroRecords: "Nenhum registro encontrado",
        sSearch: "Pesquisar",
        oPaginate: {
          sNext: "Próximo",
          sPrevious: "Anterior",
          sFirst: "Primeiro",
          sLast: "Último",
        },
        oAria: {
          sSortAscending: ": Ordenar colunas de forma ascendente",
          sSortDescending: ": Ordenar colunas de forma descendente",
        },
      },
      autoWidth: true,
      data: jsonStr,
      columns: [
        {
          data: "TELA",
          title: "TELA"
        },
        {
          data: "ARQUIVO",
          title: "ARQUIVO"
        },
        {
          data: "DESCRICAO",
          title: "DESCRICAO"
        },
        {
          data: "DATA",
          title: "DATA"
        },
        {
          data: "CAMPO_CHAVE",
          title: "CHAVE"
        },
        {
          data: "ORDEM",
          title: "ORDEM"
        },
        {
          data: "DT_VALIDADE",
          title: "DT_VALIDADE"
        },
        {
          data: "USUARIO",
          title: "USUARIO"
        },
        {
          data: "NOME",
          title: "NOME"
        },
      ],
      columnDefs: [
        {
          targets: 9,
          data: null,
          className: "tdBtnOpcoes",
          defaultContent: retornaBotaoOpcoes(),
        },
        {
          "type": 'date-br',
          "targets": [3, 6],
          "render"(data, type, row) {
            return (new Intl.DateTimeFormat('pt-BR', {
            }).format(new Date(data)));
          }
        },
      ],
    });
  }

  function limpaCampos(sOrdem) {
    $('#txtArquivo').val('');
    $('#txtDescricao').val('');
    $('#txtDocumento').val('');
    $('#txtOrdemAnexo').val(sOrdem);
    $('#txtArquivo').val();
    $("#imgAnexo").attr('src', `${BASE_URI}/dist/img/prod-1.png`);
    $("#tabelaAnexo").dataTable().$("tr.selected").removeClass("selected");
  };

  //Altualiza os inputs de acordo com os registros da linha selecionada
  async function mostraLinhaSelecionada(data) {
    $('#txtChave').val(data.CAMPO_CHAVE);
    $('#txtTela').val(data.TELA);
    $('#txtOrdemAnexo').val(data.ORDEM);
    $('#txtUsuario').val(data.USUARIO);
    await buscaDataRegistro(data.CAMPO_CHAVE, data.ORDEM)
    $('#txtArquivo').val(data.ARQUIVO);
    $('#txtDescricao').val(data.DESCRICAO);
    $('#txtDocumento').val(data.DOCUMENTO);
  }

  //Busca qual a última ordem cadastrada e soma + 5.
  async function findLastOrder() {
    const sChave = $('#txtChave').val();
    const sTela = $('#txtTela').val();

    const pesquisaParam = {
      tabela: "ANEXO",
      camposSelect: [
        "MAX(ORDEM) ORDEM",
      ],
      where: [`TELA = '${sTela}' AND CAMPO_CHAVE = '${sChave}' `]
    };

    const jsonStr = await retornaJsonPesquisaPadrao(encodeURIComponent(JSON.stringify(pesquisaParam)));

    return jsonStr[0].ORDEM + 5;
  }

  async function buscaDataRegistro(sChave, sOrdem) {
    const pesquisaParam = {
      tabela: "ANEXO",
      camposSelect: [
        "DATA, DT_VALIDADE",
      ],
      where: [`CAMPO_CHAVE = '${sChave}' AND ORDEM = '${sOrdem}'`]
    };

    const jsonStr = await retornaJsonPesquisaPadrao(encodeURIComponent(JSON.stringify(pesquisaParam)));
    $('#dtCadastro').val(jsonStr[0].DATA.substr(0, 10));
    $('#dtValidade').val(jsonStr[0].DT_VALIDADE.substr(0, 10));
  }

  //Verifica se a ordem já existe
  async function orderExists(sOrdem) {
    const sTela = $('#txtTela').val();
    const sChave = $('#txtChave').val();

    const pesquisaParam = {
      tabela: "ANEXO",
      camposSelect: [
        "ORDEM",
      ],
      where: [`TELA = '${sTela}' AND CAMPO_CHAVE = '${sChave}' AND ORDEM = ${sOrdem} `]
    };

    const jsonStr = await retornaJsonPesquisaPadrao(encodeURIComponent(JSON.stringify(pesquisaParam)));

    if (jsonStr.length > 0) {
      return false;
    }
    return true;
  }

  //Insere botão excluir ao final de toda linha carregada
  function retornaBotaoOpcoes() {
    return '<div class="divBtnOpcoes" style="background:var(--primary-color); border:none !important; padding: 6px 7px;"> ' +
      '    <a href="" id="anchorDownload" download><button class="botaoOpcoes pr-2 d-none" id="btnDownloadTrigger" type="button"><span class="fas fa-download" style="color:green"></span></button></a>' +
      '    <button class="botaoOpcoes pr-2" id="btn-download" class="botaoOpcoes" type="button"><span class="fas fa-download" style="color:white"></span></button>' +
      '    <button class="botaoOpcoes pl-2" id="btn-excluir" class="botaoOpcoes" type="button"><span class="fas fa-trash-alt" style="color:white !important"></span></button>  ' +
      '   </div>';
  };

  //Função responsável por abrir o SaveDialog para fazermos upload das imagens
  $(async function () {
    let idCampo = '';
    var modalUploadAnexos = $("#mdModalUpload");
    var Anexo = $('#txtArquivo');
    var BotaoAnexo = $("#btnAddArquivo");

    BotaoAnexo.click(function () {
      modalUploadAnexos.click();
    });

    modalUploadAnexos.change(async function () {
      var NomeAnexo = $(this).val().split('\\')[$(this).val().split('\\').length - 1];
      Anexo.val(NomeAnexo);

      let dadosArquivo = document.querySelector('#mdModalUpload').files[0].type
      if (dadosArquivo.slice(0, 5) == 'video' || dadosArquivo.slice(0, 5) == 'audio') {
        idTag = '#idVideo'
        $('#imgAnexo').addClass('d-none');
        $('#idVideo').removeClass('d-none');
        $('#idVideo').attr('type', 'video/mp4');
        $('#btnCamera').attr('disabled', true)
      } else if (dadosArquivo.slice(0, 5) == 'image') {
        idTag = '#imgAnexo'
        $('#imgAnexo').removeClass('d-none');
        $('#idVideo').addClass('d-none');
        $('#btnCamera').attr('disabled', true)
      } else {
        idTag = '#imgAnexo'
        $('#imgAnexo').removeClass('d-none');
        $('#idVideo').addClass('d-none');
        $("#imgAnexo").attr('src', `${BASE_URI}/dist/img/prod-1.png`);
        $('#btnCamera').attr('disabled', true)
        return;
      }

      let fileAnexo = document.querySelector('#mdModalUpload').files[0];
      let readerAnexo = new FileReader();
      let baseStringAnexo;
      readerAnexo.onloadend = function () {
        baseStringAnexo = readerAnexo.result;
        $(idTag).attr('src', baseStringAnexo);
      };
      await readerAnexo.readAsDataURL(fileAnexo);
    });
  });

  $('#btnTeste').on('click', function () {
    $('#btnCamera').attr('disabled', false)
  })

  //Busca a foto dentro da pasta anexos, se não insere imagem padrão
  async function buscaFoto(sFoto, sExtensao) {
    const sTela = $('#txtTela').val();
    const sChave = $('#txtChave').val();
    try {
      let url = '/Sisplan/Funcoes/v1/AnexoArquivo?';
      let response = await requisicao('GET', url, `ARQUIVO=${sFoto}&TELA=${sTela}&CHAVE=${encodeURIComponent(sChave)}&EMP_PAT=${getCookie('g_empresa_logada')}`, null);

      let jsonStr = await response.json();

      if (response.status != 200) {
        $("#imgAnexo").attr('src', `${BASE_URI}/dist/img/prod-1.png`);
        throw msgAlerta(jsonStr.mensagem);
      }

      let sBase64 = jsonStr;

      if (sExtensao == 'mp4' || sExtensao == 'mp3' || sExtensao == 'wav' || sExtensao == 'ogg') {
        $('#imgAnexo').addClass('d-none');
        $('#idVideo').removeClass('d-none');
        $('#idVideo').attr('type', 'video/mp4');
        $("#idVideo").attr('src', `data:video/mp4;base64,${sBase64.mensagem}`);
      }
      else if (sExtensao == 'pdf' || sExtensao == 'txt') {
        $("#imgAnexo").attr('src', `${BASE_URI}/dist/img/prod-1.png`);
      }
      else {
        $('#imgAnexo').removeClass('d-none');
        $('#idVideo').addClass('d-none');
        $("#imgAnexo").attr('src', `data:image/png;base64,${sBase64.mensagem}`);
      }

    } catch (error) {
      console.error(error);
      $("#imgAnexo").attr('src', `${BASE_URI}/dist/img/prod-1.png`);
    }
  }

  $("#tabelaAnexo tbody").on("click", "tr", async function () {
    $("#tabelaAnexo").dataTable().$("tr.selected").removeClass("selected");
    $(this).addClass("selected");
    const data = $('#tabelaAnexo').DataTable().row($(this)).data();
    const extensao = $('#tabelaAnexo').DataTable().row($(this)).data().ARQUIVO.split('.')[1]
    if (data == undefined) {
      return
    } else {
      await mostraLinhaSelecionada(data);
      await buscaFoto(data.ARQUIVO, extensao);
    }
  });

  $('#btnCamera').on('click', async function () {
    await pararCamera();
    $('#btnAddArquivo').attr('disabled', true);
    iniciaCamera();
    $('#modalCamera').modal('show');
  });

  $('#modalCamera').on('hide.bs.model', async function () {
    await pararCamera();
  });

  $('#modalCamera').on('show.bs.modal', function () {
    $('#canvas').addClass('d-none');
    $('#video').removeClass('d-none');

    $('#btnTiraFoto').removeClass('d-none');
    $('#btnBaixarFoto').addClass('d-none');
    $('#btnViraCamera').removeClass('d-none');
    $('#btnTentarNovamente').addClass('d-none');
  });

  const video = document.getElementById('video');
  const canvas = document.getElementById('canvas');
  const botaoTiraFoto = document.getElementById('btnTiraFoto');
  const imgElement = document.getElementById('imgAnexo');

  let switchCamera = 'user';

  const constrains = {
    video: {
      width: { min: 640, ideal: 640 },
      height: { min: 480, ideal: 480 },
      frameRate: { min: 30 },
      advanced: [
        { width: 640, height: 480 },
        { aspectRatio: { min: 8 / 5, max: 8 / 5 } },
      ]
    }
  };

  $('#btnViraCamera').on('click', async function () {
    switchCamera = (switchCamera === 'environment') ? 'user' : 'environment';
    constrains.video.facingMode = switchCamera;
    await pararCamera();
    iniciaCamera();
  });

  async function pararCamera() {
    if (window.stream) {
      const tracks = window.stream.getTracks();

      tracks.forEach(track => {
        track.stop();
      });

      video.srcObject = null
    }
  }

  function handleSuccess(stream) {
    window.stream = stream;
    video.srcObject = stream;
  }

  var context = canvas.getContext('2d');
  botaoTiraFoto.addEventListener('click', function () {
    context.drawImage(video, 0, 0, 640, 480)
    $('#video').addClass('d-none')
    $('#canvas').removeClass('d-none')

    $('#btnTiraFoto').addClass('d-none')
    $('#btnBaixarFoto').removeClass('d-none')
    $('#btnViraCamera').addClass('d-none')
    $('#btnTentarNovamente').removeClass('d-none')
  });

  $('#btnBaixarFoto').on('click', async function () {
    $('#modalCamera').modal('hide');
    const dataURL = canvas.toDataURL('image/jpeg');
    $('#txtArquivo').val(`foto (${$('#txtOrdemAnexo').val()}).jpg`)
    // const a = document.createElement('a');
    // a.href = dataURL;
    // a.download = 'foto.jpg';
    // a.click();
    imgElement.src = dataURL;
  });

  $('#btnTentarNovamente').on('click', function () {
    $('#canvas').addClass('d-none')
    $('#video').removeClass('d-none');

    $('#btnTiraFoto').removeClass('d-none');
    $('#btnBaixarFoto').addClass('d-none');
    $('#btnViraCamera').removeClass('d-none');
    $('#btnTentarNovamente').addClass('d-none');
  });

  async function iniciaCamera() {
    try {
      navigator.mediaDevices.getUserMedia(constrains)
        .then((stream => {
          handleSuccess(stream);
        }))

      // const [track] = stream.getVideoTracks();

      // const { width, height, aspectRatio } = track.getSettings();

      // if (width < height) {
      //   [width, height] = [height, width];
      //   aspectRatio = 1 / aspectRatio;
      // }

      // await track.applyConstraints({
      //   resizeMode: 'crop-and-scale',
      //   width: { exact: width },
      //   height: { exact: height },
      //   frameRate: { exact: 10 },
      //   aspectRatio,
      // });

    } catch (e) {
      console.log(e);
      $('#modalCamera').modal('hide');
      msgAlerta('Não foi possível acessar a câmera, verifique!');
    }
  }
});